#include <stdlib.h>
#include <string.h>

#if 0
#include "typedef.h"
#include "system.h"
#include "sfr_base.h"
#include "cis.h"
#include "util.h"
#include "i2c.h"
#else
#include "def.h"
#include "sysc.h"
#include "camera.h"
#include "util.h"
#include "csi.h"
#include "iic.h"
#endif

#if 0
#ifdef BB37_1B
static I2C oIic(I2C_B);
#else
static I2C oIic;
#endif
#endif

static u8 ucSlaveAddr;

void SetReg(u8 ucRegAddr, u8 ucData)
{
#if 0 // i2c.c
	Send(ucSlaveAddr, ucRegAddr, ucData);
#else // iic.c
	u8  ucIicData[2];
	s32 iRetval = OK;

	ucIicData[0] = ucRegAddr;
	ucIicData[1] = ucData;
	
	if(I2C_Master_Polling_Write(I2C_CH0, ucSlaveAddr, ucIicData, (s32)0x2) == ERROR)
	{
		Assert(0);
	}	
#endif	
}

void GetReg(u8 ucRegAddr, u8* ucData)
{
#if 0
	oIic.Receive(ucSlaveAddr, ucRegAddr, *ucData);
#endif
}

#if 0
void InitOV7620(CAM_ATTR eCcir, u32 uBits, bool bInv, IMG_FMT eSrcFmt)
{
	oIic.InitIp();
	ucSlaveAddr = 0x42;
	
//	SetReg(0x12, 0x80);	// Camera Soft reset. Self cleared after reset.
//	Delay(100);

	SetReg(0x00, 0x00);	// AGC gain
	SetReg(0x01, 0x80);	// blue gain
	SetReg(0x02, 0x80);	// red gain

	SetReg(0x03, 0xb0);	// saturation control
	SetReg(0x06, 0x60);	// set brightness - CJH
	SetReg(0x0c, 0x24);	// set white balance blue background
	SetReg(0x0d, 0x24);	// set white balance red background
	SetReg(0x10, 0xff);	// set auto exposure time, (not used in auto adjust mode)

	u8 ucVal;

	ucVal = 0;
	if (bInv)
	{
		ucVal |= (0<<7);
		ucVal |= (1<<6);
	}
	else
	{
		ucVal |= (1<<7);
		ucVal |= (0<<6);
	}
	ucVal |= (0<<0);
	SetReg(0x11, ucVal);

	ucVal = 0;
	if ( eSrcFmt == YCBYCR || eSrcFmt == YCRYCB)
		ucVal |= (1<<4); 
	ucVal |= (1<<2); // enable white balnace
	ucVal |= (1<<5); // enable AGC
	SetReg(0x12, ucVal);

	ucVal = 0;
	ucVal |= (uBits == 8 ? 1 : 0)<<5;
	ucVal |= (eCcir == CCIR656 ? 1 : 0)<<4;
	SetReg(0x13, ucVal);

	Delay(10);

	ucVal |= 0;
	if (eSrcFmt == CBYCRY || eSrcFmt == YCBYCR)
		ucVal |= (1<<0);
	ucVal |= (bInv  ? 1 : 0)<<6;
	SetReg(0x15, ucVal);

	Delay(10);	
	
	SetReg(0x16, 0x03);	// Field mode : 11b-FRAME mode -> FD<7:2> is useless (default)
	SetReg(0x17, 0x2f);	// 47 -> Horizontal Start
	SetReg(0x18, 0xcf);	// (207-47)*4=640 -> Horizontal End
	SetReg(0x19, 0x06);	// 6 -> Vertical Start
	SetReg(0x1a, 0xf5);	// (245-6+1)*2=480 -> Vertical End
	SetReg(0x1b, 0x00);	// pixel shift=0

				//(??old,incorrect) limit vertical size to 480, second stage aperture correction enable
	SetReg(0x20, (0<<7));	// limit vertical size to 480  -> bit 7: Modified CCIR656 format vertical sizing enabled
	SetReg(0x21, 0x80);	// Y Channel Offset Adjustment - 0 , direction - Subtract
	SetReg(0x22, 0x80);	// U Channel Offset Adjustment - 0
	SetReg(0x23, 0x00);	// Crystal Current control : maximum current
	SetReg(0x26, 0xa2);	// digital sharpness threshold(64mV), magnitude(100%). 
	
	SetReg(0x27, 0xe2 );	// default, disable CCIR rang clip
				//?? old value: 0xea, but bit[3] is reserved, why 1 ?
	SetReg(0x29, (0<<6));	// CHSYNC & VSYNC master mode
	SetReg(0x2a, 0x00);	// default(
				// (?? old,incorrect)frame rate high, 60Hz, 50Hz:0x80, UV delay 2 pixel. - CJH
	SetReg(0x2b, 0x00);	// default
				// (??old,incorrect) frame rate low, 60Hz, 50Hz:0xac
	SetReg(0x2c, 0x88);	// default
	SetReg(0x2e, 0x80);	// default
	SetReg(0x2f, 0x44);	// default
	SetReg(0x60, 0x27);	// default 
	SetReg(0x61, 0x82);	// YUV mode (7'st bit -> 1(YUV mode)) 
	SetReg(0x62, 0x5f);	// RGB Gamma control, gamma=010_1111b
	SetReg(0x63, 0xd5);	// reserved value ???
	SetReg(0x64, 0x57);	// enable Y Gamma,gammma=010_1011b	
	SetReg(0x65, 0x80+(3<<0));//??? bit[7:3]is reserved 01000b, why 0x80?, ADC_ref=11b(1.26V peak)
	SetReg(0x66, 0x55);	// default 
	SetReg(0x68, 0xcf);	// not default
	SetReg(0x69, 0x76);	// not default
	SetReg(0x6a, 0x22);	// not default
	SetReg(0x6b, 0x00);	// ??reserved
	SetReg(0x6c, 0x08);	// ??reserved
	SetReg(0x6d, 0x48);	// ??reserved
	SetReg(0x6e, 0x80);	// ??reserved
	SetReg(0x6f, 0x0c);	// ?? how? -CJH ( default=0x3a)
	SetReg(0x70, 0x89);	// -CJH, accelerated saturation mode(fast), -> if 3'st bit is zero, acclerated saturation mode
	SetReg(0x71, 0x00);	//  default, freerunning PCLK
	SetReg(0x72, 0x14);	//  default
	SetReg(0x73, 0x54);	//  default
	SetReg(0x75, 0x0e);	// ?? -CJH (bit[6:3]=reserved)
	SetReg(0x76, 0x00);	// default
	SetReg(0x77, 0xff);	// ??reserved
	SetReg(0x78, 0x80);	// ??reserved
	SetReg(0x79, 0x80);	// ??reserved
	SetReg(0x7a, 0x80);	// ??reserved
	SetReg(0x7b, 0xe6);	// ???reserved -CJH 
	SetReg(0x7c, 0x00);	// default

	ucVal = 0;
	ucVal |= (bInv ? 1 : 0)<<3;
	ucVal |= (1<<7);
	ucVal |= (1<<4);
	ucVal |= (1<<2);
	SetReg(0x14, ucVal);
	
	SetReg(0x24, 0x10);	// for progressive - CJH
	SetReg(0x25, 0x8a);	// for progressive - CJH 
	SetReg(0x28, 0x20);	// select progressive mode. -> if 5'st bit is '1', progressive scan mode 
	SetReg(0x2d, 0x95);	// auto brightness(4'st bit is '1'), banding filter enabled
	SetReg(0x67, 0x92);	// Color space=601 YCrCb, Y signal delay=0
	SetReg(0x74, 0x00);	// AGC maximum gain=2x.(COMM[6:5] is 00) -CJH
}
#endif

#if 0
#if 0 // Summy code
void InitS5K3AAE(CAM_ATTR eCcir, IMG_FMT eSrcFmt, IMG_RESOLUTION eSrcSz)
{	
	oIic.InitIp();
	ucSlaveAddr = 0x5a;
	SetReg(0xec, 0x00);
	SetReg(0x71, 0x00); // PCLK setting	

#if 1
	SetSizeInS5K3AAE(eSrcSz);

	Delay(20000);

	// Camera data format, YC order setting
	u32 uOutSel = (eCcir == CCIR601) ? (1<<2) : (0<<2);
	u32 uYcSel = (eSrcFmt == YCBYCR || eSrcFmt == YCRYCB) ? (1<<1) : (0<<1);
	u32 uCrCbSel = (eSrcFmt == YCRYCB || eSrcFmt == CRYCBY) ? (1<<0) : (0<<0);
	SetReg(0xec, 0x01);
	///SetReg(0x6a, uOutSel | uYcSel | uCrCbSel);
	SetReg(0x6a, uOutSel | uYcSel | 1);
	u8 x;
	GetReg(0x6a, x);

#elif 0
	SetReg(0xec, 0x01);
	SetReg(0x6a, 0x01); 
	u8 x;
	GetReg(0x6a, x);	

	Disp("1.6ah = %02x\n", x);
#elif 0
	u8 t1;
	SetReg(0xec, 0x00);
	GetReg(0xb0, t1);
	Disp("0.0xb0: 0x%x \n",  t1);
	GetReg(0xb1, t1);
	Disp("0.0xb1: 0x%x \n",  t1);
	GetReg(0xb2, t1);
	Disp("0.0xb2: 0x%x \n",  t1);
	GetReg(0xb3, t1);
	Disp("0.0xb3: 0x%x \n",  t1);
	///SetReg(0x7b, 0xff);

	SetReg(0xec, 0x01);
	GetReg(0x00, t1);
	Disp("1.0x00: 0x%x \n",  t1);

	SetReg(0xec, 0x01);
	SetReg(0x6a, 0x03);

#endif
}
#else // modified by JJang
void InitS5K3AAE(CAM_ATTR eCcir, IMG_FMT eSrcFmt, IMG_RESOLUTION eSrcSz)
{	
	oIic.InitIp();
	ucSlaveAddr = 0x5a;
	SetReg(0xec, 0x00);
	SetReg(0x71, 0x00); // PCLK setting	

	u8 y, x;
	ucSlaveAddr = 0x5a;

	// Size scaling setting
	u8 ucSrcSize = 
		(eSrcSz == SXGA) ? (0) : 
		(eSrcSz == VGA) ? (1) :
		(eSrcSz == QVGA) ? (2):
		(eSrcSz == QQVGA) ? (3) :
		(eSrcSz == CIF) ? (4) :
		(eSrcSz == QCIF) ? (5) :
		0xff;
	Assert(ucSrcSize != 0xff);

//	SetEVT6(eSrcSize);

	SetReg(0xec, 0x00);	
	SetReg(0x02, ucSrcSize);

	SetReg(0xec, 0x04);

//	Delay(20000);

	// Camera data format, YC order setting
	u32 uOutSel = (eCcir == CCIR601) ? (1<<2) : (0<<2);
	u32 uYcSel = (eSrcFmt == YCBYCR || eSrcFmt == YCRYCB) ? (1<<1) : (0<<1);
	u32 uCrCbSel = (eSrcFmt == YCRYCB || eSrcFmt == CRYCBY) ? (1<<0) : (0<<0);
	SetReg(0xec, 0x01);
	///SetReg(0x6a, uOutSel | uYcSel | uCrCbSel);
	SetReg(0x6a, uOutSel | uYcSel | 1);
//	u8 x;
//	GetReg(0x6a, x);

}
#endif
void InitS5C733A(void)
{
	oIic.InitIp();
	ucSlaveAddr = 0x5a;

	SetReg(0xfc, 0x00);
	SetReg(0x00, 0x10); // firmware mode	

	Delay(10);
	
	SetReg(0xfc, 0x02);
	SetReg(0x03, 0x00); // 3C1 stream off -> Off before changing PLL setting

	// 733A PLL : 27Mhz Input, 36Mhz PCLK, 18Mhz DCK for 733A
	SetReg(0xfc, 0x01);
	SetReg(0x04, 0x00); // IPD=0
	SetReg(0x06, 0x00); // FBD=0
	SetReg(0x05, 0x1f); 
	SetReg(0x01, 0x04); 	// ARM 1/2 divide, PLL 1/8  divide ARM clk : 14~40Mhz		
							// [7]   ADC  Clcok divider = default 1/128
							// [6:5] ARM  Clock Divider = default 1/1  
							// [4:3] MCLK Clock Divider = default 1/1
						 	// [2:0] PLL  Clock Divider = default 1/8
	SetReg(0x03, 0x00);	// CIS 1 divide => 32Mhz CIS Clk

	// --------------------
	// CIS setting
	// --------------------
	SetReg(0xfc, 0x02);

	SetReg(0x02, 0x94);	
	SetReg(0x04, 0x05);

	SetReg(0x10, 0x00);	
	SetReg(0x11, 0x00);	
	SetReg(0x16, 0x19);	

	//Max SetReg(utter value
	SetReg(0x1c, 0x08);	//fine integration time
	SetReg(0x1d, 0x8f);	
	SetReg(0x1e, 0x06);	//coarSetReg(e integration time
	SetReg(0x1f, 0xcb);	

		
	//2056x1544
	SetReg(0x24, 0x00);
	SetReg(0x25, 0x02);
	SetReg(0x26, 0x00);
	SetReg(0x27, 0x04);
	SetReg(0x28, 0x08);
	SetReg(0x29, 0x09);
	SetReg(0x2a, 0x06);
	SetReg(0x2b, 0x0b);	
	SetReg(0x2c, 0x08);// X output SetReg(ize
	SetReg(0x2d, 0x08);
	SetReg(0x2e, 0x06);	// Y output SetReg(ize
	SetReg(0x2f, 0x08);

	SetReg(0x40, 0x00);	
	SetReg(0x41, 0x81);	

	SetReg(0x48, 0x29);	
	SetReg(0x70, 0x33);	

	SetReg(0x4f, 0xf7);	

	//PLL SetReg(etting in:out = 27 : 27
	SetReg(0x50, 0x04);	
	SetReg(0x54, 0x04);	//pre pll div
	SetReg(0x56, 0x00);	//pll m (high)
	SetReg(0x57, 0x50);	//pll m (low)
	SetReg(0x58, 0x2a);//vt_SetReg(ySetReg(_div[7:4], vt_pix_div[3:0]
	SetReg(0x59, 0x2a);	//op_SetReg(ySetReg(_div[7:4], op_pix_div[3:0]

	SetReg(0x63, 0x01);

	SetReg(0x66, 0x04);
	SetReg(0x67, 0x00);
	SetReg(0x69, 0x89);

	SetReg(0x71, 0x47);

	SetReg(0x03, 0x10);//streaming on

}

void InitS5K3C1F(void)
{
	oIic.InitIp();
	ucSlaveAddr = 0x5a;
	SetReg(0xfc, 0x02);

	SetReg(0x02, 0x94);	
	SetReg(0x04, 0x05);

	SetReg(0x10, 0x00);	
	SetReg(0x11, 0x00);	
	SetReg(0x16, 0x19);	

	//Max SetReg(utter value
	SetReg(0x1c, 0x08);	//fine integration time
	SetReg(0x1d, 0x8f);	
	SetReg(0x1e, 0x06);	//coarSetReg(e integration time
	SetReg(0x1f, 0xcb);	

		
	//2056x1544
	SetReg(0x24, 0x00);
	SetReg(0x25, 0x02);
	SetReg(0x26, 0x00);
	SetReg(0x27, 0x04);
	SetReg(0x28, 0x08);
	SetReg(0x29, 0x09);
	SetReg(0x2a, 0x06);
	SetReg(0x2b, 0x0b);	
	SetReg(0x2c, 0x08);// X output SetReg(ize
	SetReg(0x2d, 0x08);
	SetReg(0x2e, 0x06);	// Y output SetReg(ize
	SetReg(0x2f, 0x08);

	SetReg(0x40, 0x00);	
	SetReg(0x41, 0x81);	

	SetReg(0x48, 0x29);	
	SetReg(0x70, 0x33);	

	SetReg(0x4f, 0xf7);	

	//PLL SetReg(etting in:out = 27 : 27
	SetReg(0x50, 0x04);	
	SetReg(0x54, 0x04);	//pre pll div
	SetReg(0x56, 0x00);	//pll m (high)
	SetReg(0x57, 0x50);	//pll m (low)
	SetReg(0x58, 0x2a);//vt_SetReg(ySetReg(_div[7:4], vt_pix_div[3:0]
	SetReg(0x59, 0x2a);	//op_SetReg(ySetReg(_div[7:4], op_pix_div[3:0]

	SetReg(0x63, 0x01);

	SetReg(0x66, 0x04);
	SetReg(0x67, 0x00);
	SetReg(0x69, 0x89);

	SetReg(0x71, 0x47);

	SetReg(0x03, 0x10);//streaming on

}


void InitS5K4AAF(CAM_ATTR eCcir, IMG_FMT eSrcFmt, IMG_RESOLUTION eSrcSize)
{
	oIic.InitIp();
	ucSlaveAddr = 0x5a;
	
	u8 x;
	
#if 1
//	GetReg(0x02, x);
//	Disp(" 0.02h = %02x\n", x);
	SetReg(0xec, 0x00);
	SetReg(0x71, 0x00); // PCLK setting
#else  // 9.5
	SetReg(0xec, 0x01);
	SetReg(0xa5, 0x01);		//ARM Clock divider=ARM_CLK_DIV (1/2) (ARM_CLK range = 14MHz ~ 44MHz)				
	
	//In case of PCLK = 27MHz (PLL_CLK = Pixel_CLK*2, ARM_CLK = PLL_CLK/ARM_CLK_DIV )
	SetReg(0xec, 0x01);
	SetReg(0xa1, 54);		//PLL M=54	
	SetReg(0xa2, 0x48);      	//PLL S=1,P=8
#endif
	// Size scaling
	//--------------
	u8 ucSrcSize = 
		(eSrcSize == SXGA) ? (0) : 
		(eSrcSize == VGA) ? (1) :
		(eSrcSize == QVGA) ? (2) :
		(eSrcSize == QQVGA) ? (3) :
		(eSrcSize == CIF) ? (4) :
		(eSrcSize == QCIF) ? (5) :
		0xff;
	Assert(ucSrcSize != 0xff);
		
	SetReg(0xec, 0x00);
	SetReg(0x02, ucSrcSize);	

#if 1	// if deleted, no operation..
	// Camera data format, YC order
	//------------------------------
	u8 uOutSel = (eCcir == CCIR601) ? (1<<2) : (0<<2);
	u8 uYcSel = (eSrcFmt == YCBYCR || eSrcFmt == YCRYCB) ? (1<<1) : (0<<1);
	u8 uCrCbSel = (eSrcFmt == YCRYCB || eSrcFmt == CRYCBY) ? (1<<0) : (0<<0);
	
	SetReg(0xec, 0x01);
	GetReg(0x7f, x);
	Disp("1.7fh = %02x, 0x%02x\n", x, uOutSel | uYcSel | uCrCbSel);	
	SetReg(0x7f, uOutSel | uYcSel | uCrCbSel);	
///	SetReg(0x7f, 0x40|uOutSel | uYcSel | 1);


///	GetReg(0x7f, x);
///	Disp("1.7fh = %02x\n", x);
#endif
	

}
#endif

u32 uMClkOfS5K3BAFB;
u32 uFrameRateOfS5K3BAFB;

void CAM_InitS5K3BAF(CAM_ATTR eCcir, IMG_FMT eSrcFmt, IMG_RESOLUTION eSize)
{
	u8 ucPll_s,ucPll_m;
	u8 ucPll_p;

	u8 ucSub;

	u32 uOutSel, uYcSel, uCrCbSel;

	//Delay(2000);
	Delay(10000);

#if 0 // i2c.c
	InitIp();
#else // iic.c	
	//I2C_General_IP_Init();	
	I2C_GPIO_Open(I2C_CH0);
	I2C_SFR_Mapping_Init(I2C_CH0);
	I2C_Initialize_Controller(I2C_CH0);
#endif
	ucSlaveAddr = 0x5a;
	
	ucPll_p = uMClkOfS5K3BAFB / 1000000;

	if ( uFrameRateOfS5K3BAFB==4 )
		ucPll_m=128,ucPll_s=2;
	else if ( uFrameRateOfS5K3BAFB==8 )
		ucPll_m=128,ucPll_s=1;
	else if ( uFrameRateOfS5K3BAFB==15 )
		ucPll_m=128,ucPll_s=0;
	else if( uFrameRateOfS5K3BAFB < 15 && uFrameRateOfS5K3BAFB>4)
		ucPll_m=18*uFrameRateOfS5K3BAFB,ucPll_s=1;
	else
		Assert(0);
 	//u8 x;
	SetReg(0xfc, 0x01);
	SetReg(0x03, 0x01); // sw reset

	Delay(100);

	// 1. PLL SETTING MCLK = 27Mhz PLL_CLK = 64 PCLK = 32
	SetReg(0xfc, 0x01);
	SetReg(0x04, 0x01); //PCLK = PLL / 2^1	

	SetReg(0xfc, 0x02);
	SetReg(0x52, ucPll_m);  //PLL M=128d

	SetReg(0xfc, 0x02);
	SetReg(0x50, ucPll_p|ucPll_s<<6); // PLL_S = 1 

	// 2. Size
	ucSub = 
		(eSize == UXGA) ? 0 :
		(eSize == SXGA) ? 1 :
		(eSize == VGA) ? 2 :
		(eSize == QVGA) ? 3 :
		(eSize == CIF) ? 5 :
		0xff;
	Assert(ucSub < 0xff);
	SetReg(0xfc, 0x00);
	SetReg(0x02, ucSub);
	
	// 3. Camera data format, YC order setting
	uOutSel = (eCcir == CCIR601) ? (1<<2) : (0<<2);
	uYcSel = (eSrcFmt == YCBYCR || eSrcFmt == YCRYCB) ? (1<<1) : (0<<1);
	uCrCbSel = (eSrcFmt == YCRYCB || eSrcFmt == CRYCBY) ? (1<<0) : (0<<0);
	SetReg(0xfc, 0x01);
	SetReg(0x02, uOutSel|uYcSel|uCrCbSel);
}

#if 0
#ifndef SCL
#define SCL  1
#define SDA  2
#endif
#include "gpio.h"

class I2cOnGpio
{
public:

	void SendData(u8 ucSlvAddr, u8 addr, u8 data);
	void RcvData(u8 ucSlvAddr, u8 addr, u8& data);

protected:

	void WriteStart(void);
	void WriteStop(void);

	void WriteByte(u8 data);
	void ReadByte(u8& data);

	void WriteAck(void);
	void ReadAck(int& hilo);

	GPIO m_oGpio;
};

void I2cOnGpio::SendData(u8 ucSlvAddr, u8 addr, u8 data)
{
	int ack;

	WriteStart();

	ucSlvAddr &= ~0x01;
	WriteByte(ucSlvAddr);
	ReadAck(ack);
	
	WriteByte(addr);
	ReadAck(ack);
	
	WriteByte(data);
	ReadAck(ack);

	WriteStop();
}

void I2cOnGpio::RcvData(u8 ucSlvAddr, u8 addr, u8& data) // To be Verified.
{
	int ack;
	
	WriteStart();

	ucSlvAddr &= ~0x01;
	WriteByte(ucSlvAddr);
	ReadAck(ack);

	WriteByte(addr);
	ReadAck(ack);

	WriteStart();

	ucSlvAddr |= 0x01;
	WriteByte(ucSlvAddr);
	ReadAck(ack);

	ReadByte(data);
	WriteAck();

	WriteStop();
}

void I2cOnGpio::WriteStart(void)
{
	m_oGpio.SetBit(SCL);
	m_oGpio.SetBit(SDA);
	m_oGpio.ClrBit(SDA);
}

void I2cOnGpio::WriteStop(void)
{
	m_oGpio.ClrBit(SDA);
	m_oGpio.SetBit(SCL);
	m_oGpio.SetBit(SDA);
	Delay(20);
}

void I2cOnGpio::WriteByte(u8 data)
{
	m_oGpio.ClrBit(SCL);

	for (int i=0; i<8; i++)
	{
		if (data & 0x80)
			m_oGpio.SetBit(SDA);
		else
			m_oGpio.ClrBit(SDA);

		data <<= 1;

		m_oGpio.SetBit(SCL);
		m_oGpio.ClrBit(SCL);
	} 
}

void I2cOnGpio::ReadByte(u8& data)
{
	int rd;

	for (int i=0; i<8; i++)
	{
		data <<= 1;
		m_oGpio.ClrBit(SCL);
		m_oGpio.SetBit(SCL);

		m_oGpio.GetBit(SDA, rd);
		if(rd == 1)
			data |= 1;
	}
}

void I2cOnGpio::WriteAck(void)
{
	m_oGpio.ClrBit(SCL);
	m_oGpio.SetBit(SDA);
	m_oGpio.SetBit(SCL);
}

void I2cOnGpio::ReadAck(int& hilo)
{
	m_oGpio.CfgBit(SDA, 1);

	m_oGpio.SetBit(SCL);
	m_oGpio.ClrBit(SCL);
	m_oGpio.GetBit(SDA, hilo);

	m_oGpio.CfgBit(SDA, 0);

//	Assert(hilo == 0);
}
#endif

void InitADV7180(void)
{
#if 0
	oIic.InitIp();

	// If ALSB is high, address is 0x42
    // If ALSB is low, address is 0x40
	ucSlaveAddr = 0x42;

#if 1
	// DVD player display setting: RGB(O), YPrPb(X)

	// Setup CVBS (for composit)
	//-----------------------
	SetReg(0x00, 0x00); // use Ain 1 for composit. Ain1(0x00), Ain2(0x03), Ain3(0x04)
	SetReg(0x04, 0xD7);// SFL enable	
	SetReg(0x17, 0x41);// SH1, narrow notch
	SetReg(0x31, 0x02);
	SetReg(0x3D, 0xA2);// kill at 1.5%

	SetReg(0x3E, 0x6A);
	SetReg(0x3F, 0xA0);
	SetReg(0x0E, 0x80);
	SetReg(0x55, 0x81);
	SetReg(0x0E, 0x00);	
#endif
	
#if 0
	// Setup SVIDEO (for Y/C(S-VIDEO))
	//------------------------------
	SetReg(0x00, 0x06);// use Ain1(Y) and Ain2(C) for Y/C(S-VIDEO)
	SetReg(0x04, 0x57);
	SetReg(0x31, 0x02);
	SetReg(0x3D, 0xA2);
	SetReg(0x3E, 0x6A);

	SetReg(0x3F, 0xA0);
	SetReg(0x58, 0x04);
	SetReg(0x0E, 0x80);
	SetReg(0x55, 0x81);
	SetReg(0x0E, 0x00);
#endif

#if 0
	// Setup YPrPb (for component)
	//-------------------------
	SetReg(0x00, 0x09);// use Ain1(Y), Ain2(Pb) and Ain3(Pr) for component
	SetReg(0x31, 0x02);
	SetReg(0x3D, 0xA2);
	SetReg(0x3E, 0x6A);
	SetReg(0x3F, 0xA0);

	SetReg(0x0E, 0x80);
	SetReg(0x55, 0x81);
	SetReg(0x0E, 0x00);
#endif	
#endif
}

void SetHwRegOfS5K4CAGX(u8 ucHSubAddr, u8 ucLSubAddr, u8 ucHData, u8 ucLData)
{
#if 0
	u8 aRegAddr[2];
	u8 aData[2];

	aRegAddr[0] = 0x00;
	aRegAddr[1] = 0x28;
	aData[0] = 0xd0;
	aData[1] = 0x00;
	oIic.Send(ucSlaveAddr, aRegAddr, aData, 0x2);

	aRegAddr[0] = 0x00;
	aRegAddr[1] = 0x2a;
	aData[0] = ucHSubAddr;
	aData[1] = ucLSubAddr;
	oIic.Send(ucSlaveAddr, aRegAddr, aData, 0x2);

	aRegAddr[0] = 0x0f;
	aRegAddr[1] = 0x12;
	aData[0] = ucHData;
	aData[1] = ucLData;
	oIic.Send(ucSlaveAddr, aRegAddr, aData, 0x2);
#endif
}

void SetSwRegOfS5K4CAGX(u8 ucHSubAddr, u8 ucLSubAddr, u8 ucHData, u8 ucLData)
{
#if 0
	u8 aRegAddr[2];
	u8 aData[2];

	aRegAddr[0] = 0x00;
	aRegAddr[1] = 0x28;
	aData[0] = 0x70;
	aData[1] = 0x00;
	oIic.Send(ucSlaveAddr, aRegAddr, aData, 0x2);

	aRegAddr[0] = 0x00;
	aRegAddr[1] = 0x2a;
	aData[0] = ucHSubAddr;
	aData[1] = ucLSubAddr;
	oIic.Send(ucSlaveAddr, aRegAddr, aData, 0x2);

	aRegAddr[0] = 0x0f;
	aRegAddr[1] = 0x12;
	aData[0] = ucHData;
	aData[1] = ucLData;
	oIic.Send(ucSlaveAddr, aRegAddr, aData, 0x2);	
#endif
}

void InitS5K4CAGX(CAM_ATTR eCcir, IMG_FMT eSrcFmt, IMG_RESOLUTION eSize)
{
#if 0
	Assert(eCcir==MIPI); // CCIR601, CCIR656 need to be set later

	// More image size need to be set later
	if((eSrcFmt==BayerRGB8)||(eSrcFmt==BayerRGB8)||(eSrcFmt==BayerRGB8))
	{
		Assert(eSize==QXGA);
	}
	else if(eSrcFmt==CBYCRY)
	{
		Assert((eSize==QXGA)||(eSize==HD720));
	}
	else
	{
		Assert(0);
	}
	
	oIic.InitIp();
	ucSlaveAddr = 0x5a;

	if(eSrcFmt == BayerRGB8)
	{
		SetHwRegOfS5K4CAGX(0x00, 0x52, 0x01, 0x40);	// PLL M
		SetHwRegOfS5K4CAGX(0x00, 0x54, 0x00, 0x06);	// PLL P
		SetHwRegOfS5K4CAGX(0x00, 0x56, 0x00, 0x04);	// PLL S
		SetHwRegOfS5K4CAGX(0x00, 0x50, 0x00, 0x01);	// PLL en
		
		SetHwRegOfS5K4CAGX(0x00, 0x60, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0x00, 0x64, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0x10, 0x02, 0x11, 0x01);
		SetHwRegOfS5K4CAGX(0xa0, 0x10, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0xa0, 0x8e, 0x00, 0x20);
		SetHwRegOfS5K4CAGX(0xa0, 0x44, 0x00, 0x7d);
		SetHwRegOfS5K4CAGX(0xa0, 0x4c, 0x00, 0x17);
		SetHwRegOfS5K4CAGX(0xa0, 0x4e, 0x00, 0x08);
		SetHwRegOfS5K4CAGX(0xa0, 0x50, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0xa0, 0x52, 0x00, 0x06);
		SetHwRegOfS5K4CAGX(0xa0, 0x54, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0x00, 0x20, 0x70, 0x00);
		SetHwRegOfS5K4CAGX(0x00, 0x22, 0x17, 0xb6);
		SetHwRegOfS5K4CAGX(0x00, 0x24, 0x70, 0x00);
		SetHwRegOfS5K4CAGX(0x00, 0x26, 0x18, 0x1a);
		SetHwRegOfS5K4CAGX(0x00, 0x2a, 0x10, 0x04);

		SetHwRegOfS5K4CAGX(0x10, 0x50, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x20, 0x00, 0x00, 0x86);
		SetHwRegOfS5K4CAGX(0x20, 0x02, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0x20, 0x04, 0x08, 0x00);
		SetHwRegOfS5K4CAGX(0x20, 0x06, 0x06, 0x00);
		SetHwRegOfS5K4CAGX(0x20, 0x0a, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0x20, 0x20, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x31, 0x02, 0x08, 0x00);

		SetHwRegOfS5K4CAGX(0x31, 0x04, 0x06, 0x00);
		SetHwRegOfS5K4CAGX(0x32, 0x18, 0x07, 0xf8);
		SetHwRegOfS5K4CAGX(0x32, 0x1a, 0x06, 0x00);

		SetHwRegOfS5K4CAGX(0x48, 0x00, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x34, 0x00, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x63, 0x00, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x64, 0x00, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x65, 0x00, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x66, 0x00, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x68, 0x00, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x74, 0x2a, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x70, 0x00, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x71, 0xba, 0x00, 0x01);

		SetHwRegOfS5K4CAGX(0x74, 0x22, 0x03, 0x80);
		SetHwRegOfS5K4CAGX(0x74, 0x24, 0x03, 0x80);
		SetHwRegOfS5K4CAGX(0x74, 0x26, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x74, 0x28, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x75, 0x00, 0x00, 0x00);

		SetHwRegOfS5K4CAGX(0x31, 0x00, 0x00, 0x19);
		SetHwRegOfS5K4CAGX(0x30, 0x00, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0x32, 0x00, 0x00, 0x00);

		SetHwRegOfS5K4CAGX(0x32, 0x18, 0x08, 0x00);
		SetHwRegOfS5K4CAGX(0x32, 0x1a, 0x06, 0x00);
		SetHwRegOfS5K4CAGX(0x48, 0x00, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x41, 0x00, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x42, 0x02, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x43, 0x00, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x4a, 0x00, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x6a, 0x00, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x63, 0x00, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x64, 0x00, 0x00, 0x01);	
		SetHwRegOfS5K4CAGX(0x65, 0x00, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x66, 0x00, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x67, 0x00, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x68, 0x00, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x6d, 0x00, 0x00, 0x01);

		SetHwRegOfS5K4CAGX(0xb0, 0x00, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0xb0, 0x02, 0x00, 0x2a); // video data type
		SetHwRegOfS5K4CAGX(0xb0, 0x08, 0x00, 0x08);
		SetHwRegOfS5K4CAGX(0xb0, 0x0a, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0xb0, 0x0c, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0xb0, 0x10, 0x00, 0x08);
		SetHwRegOfS5K4CAGX(0xb0, 0x14, 0x00, 0xac);
		SetHwRegOfS5K4CAGX(0xb0, 0x40, 0x00, 0x28);
		SetHwRegOfS5K4CAGX(0xb0, 0x50, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0xb0, 0x04, 0x00, 0x30);
		SetHwRegOfS5K4CAGX(0xb0, 0x16, 0x00, 0x88);
		SetHwRegOfS5K4CAGX(0xb0, 0x20, 0x08, 0x03);
		SetHwRegOfS5K4CAGX(0xb0, 0x30, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0xb0, 0x32, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0xb0, 0x34, 0x02, 0x8b);
		SetHwRegOfS5K4CAGX(0xb0, 0x36, 0x03, 0x4c);
		SetHwRegOfS5K4CAGX(0xb0, 0x38, 0x0b, 0xed);
		SetHwRegOfS5K4CAGX(0xb0, 0x40, 0x00, 0x20);
		SetHwRegOfS5K4CAGX(0xb0, 0x42, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0xb0, 0x44, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0xb0, 0x46, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0xb0, 0x48, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0xb0, 0x50, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0xb0, 0x58, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0xb0, 0x62, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0xb0, 0x6a, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0xb0, 0x7e, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0xb0, 0xa8, 0x00, 0x1d);
		SetHwRegOfS5K4CAGX(0xb0, 0xb0, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0xb0, 0xb2, 0x00, 0x40);
		SetHwRegOfS5K4CAGX(0xb0, 0xc8, 0x00, 0x00);
		
		SetHwRegOfS5K4CAGX(0x31, 0x00, 0x00, 0x18);
		SetHwRegOfS5K4CAGX(0x31, 0x02, 0x08, 0x02);
		SetHwRegOfS5K4CAGX(0x31, 0x04, 0x06, 0x00);

		SetHwRegOfS5K4CAGX(0x00, 0x66, 0x00, 0x05);
		SetHwRegOfS5K4CAGX(0x00, 0x68, 0x00, 0x02);
		
		SetHwRegOfS5K4CAGX(0xb0, 0xa0, 0x00, 0x3f);
		SetHwRegOfS5K4CAGX(0xb0, 0x70, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0xb0, 0x22, 0x08, 0x00); // 8bit
		SetHwRegOfS5K4CAGX(0xb0, 0x80, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0xb0, 0x00, 0x00, 0x03);

		SetHwRegOfS5K4CAGX(0x00, 0x30, 0x00, 0x07);
		SetHwRegOfS5K4CAGX(0x00, 0x30, 0x00, 0x06);
		SetHwRegOfS5K4CAGX(0x00, 0x30, 0x00, 0x07);		
	}
	else if(eSrcFmt == BayerRGB10)
	{
		SetHwRegOfS5K4CAGX(0x00, 0x52, 0x01, 0x40);	// PLL M
		SetHwRegOfS5K4CAGX(0x00, 0x54, 0x00, 0x06);	// PLL P
		SetHwRegOfS5K4CAGX(0x00, 0x56, 0x00, 0x04);	// PLL S
		SetHwRegOfS5K4CAGX(0x00, 0x50, 0x00, 0x01);	// PLL en
		
		SetHwRegOfS5K4CAGX(0x00, 0x60, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0x00, 0x64, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0x10, 0x02, 0x11, 0x01);
		SetHwRegOfS5K4CAGX(0xa0, 0x10, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0xa0, 0x8e, 0x00, 0x20);
		SetHwRegOfS5K4CAGX(0xa0, 0x44, 0x00, 0x7d);
		SetHwRegOfS5K4CAGX(0xa0, 0x4c, 0x00, 0x17);
		SetHwRegOfS5K4CAGX(0xa0, 0x4e, 0x00, 0x08);
		SetHwRegOfS5K4CAGX(0xa0, 0x50, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0xa0, 0x52, 0x00, 0x06);
		SetHwRegOfS5K4CAGX(0xa0, 0x54, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0x00, 0x20, 0x70, 0x00);
		SetHwRegOfS5K4CAGX(0x00, 0x22, 0x17, 0xb6);
		SetHwRegOfS5K4CAGX(0x00, 0x24, 0x70, 0x00);
		SetHwRegOfS5K4CAGX(0x00, 0x26, 0x18, 0x1a);
		SetHwRegOfS5K4CAGX(0x00, 0x2a, 0x10, 0x04);

		SetHwRegOfS5K4CAGX(0x10, 0x50, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x20, 0x00, 0x00, 0x86);
		SetHwRegOfS5K4CAGX(0x20, 0x02, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0x20, 0x04, 0x08, 0x00);
		SetHwRegOfS5K4CAGX(0x20, 0x06, 0x06, 0x00);
		SetHwRegOfS5K4CAGX(0x20, 0x0a, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0x20, 0x20, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x31, 0x02, 0x08, 0x00);

		SetHwRegOfS5K4CAGX(0x31, 0x04, 0x06, 0x00);
		SetHwRegOfS5K4CAGX(0x32, 0x18, 0x07, 0xf8);
		SetHwRegOfS5K4CAGX(0x32, 0x1a, 0x06, 0x00);

		SetHwRegOfS5K4CAGX(0x48, 0x00, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x34, 0x00, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x63, 0x00, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x64, 0x00, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x65, 0x00, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x66, 0x00, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x68, 0x00, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x74, 0x2a, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x70, 0x00, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x71, 0xba, 0x00, 0x01);

		SetHwRegOfS5K4CAGX(0x74, 0x22, 0x03, 0x80);
		SetHwRegOfS5K4CAGX(0x74, 0x24, 0x03, 0x80);
		SetHwRegOfS5K4CAGX(0x74, 0x26, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x74, 0x28, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x75, 0x00, 0x00, 0x00);

		SetHwRegOfS5K4CAGX(0x31, 0x00, 0x00, 0x19);
		SetHwRegOfS5K4CAGX(0x30, 0x00, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0x32, 0x00, 0x00, 0x00);

		SetHwRegOfS5K4CAGX(0x32, 0x18, 0x08, 0x00);
		SetHwRegOfS5K4CAGX(0x32, 0x1a, 0x06, 0x00);
		SetHwRegOfS5K4CAGX(0x48, 0x00, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x41, 0x00, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x42, 0x02, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x43, 0x00, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x4a, 0x00, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x6a, 0x00, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x63, 0x00, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x64, 0x00, 0x00, 0x01);	
		SetHwRegOfS5K4CAGX(0x65, 0x00, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x66, 0x00, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x67, 0x00, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x68, 0x00, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x6d, 0x00, 0x00, 0x01);

		SetHwRegOfS5K4CAGX(0xb0, 0x00, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0xb0, 0x02, 0x00, 0x2b); // video data type
		SetHwRegOfS5K4CAGX(0xb0, 0x08, 0x00, 0x04);
		SetHwRegOfS5K4CAGX(0xb0, 0x0a, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0xb0, 0x0c, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0xb0, 0x10, 0x00, 0x08);
		SetHwRegOfS5K4CAGX(0xb0, 0x14, 0x00, 0xd6); // D000B014 00D6
		SetHwRegOfS5K4CAGX(0xb0, 0x40, 0x00, 0x28);
		SetHwRegOfS5K4CAGX(0xb0, 0x50, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0xb0, 0x04, 0x00, 0x30);
		SetHwRegOfS5K4CAGX(0xb0, 0x16, 0x00, 0x88);
		SetHwRegOfS5K4CAGX(0xb0, 0x20, 0x08, 0x03);
		SetHwRegOfS5K4CAGX(0xb0, 0x30, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0xb0, 0x32, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0xb0, 0x34, 0x02, 0x8b);
		SetHwRegOfS5K4CAGX(0xb0, 0x36, 0x03, 0x4c);
		SetHwRegOfS5K4CAGX(0xb0, 0x38, 0x0b, 0xed);
		SetHwRegOfS5K4CAGX(0xb0, 0x40, 0x00, 0x20);
		SetHwRegOfS5K4CAGX(0xb0, 0x42, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0xb0, 0x44, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0xb0, 0x46, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0xb0, 0x48, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0xb0, 0x50, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0xb0, 0x58, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0xb0, 0x62, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0xb0, 0x6a, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0xb0, 0x7e, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0xb0, 0xa8, 0x00, 0x1d);
		SetHwRegOfS5K4CAGX(0xb0, 0xb0, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0xb0, 0xb2, 0x00, 0x40);
		SetHwRegOfS5K4CAGX(0xb0, 0xc8, 0x00, 0x00);
		
		SetHwRegOfS5K4CAGX(0x31, 0x00, 0x00, 0x18);
		SetHwRegOfS5K4CAGX(0x31, 0x02, 0x08, 0x02);
		SetHwRegOfS5K4CAGX(0x31, 0x04, 0x06, 0x00);

		SetHwRegOfS5K4CAGX(0x00, 0x66, 0x00, 0x05);
		SetHwRegOfS5K4CAGX(0x00, 0x68, 0x00, 0x02);
		
		SetHwRegOfS5K4CAGX(0xb0, 0xa0, 0x00, 0x3f);
		SetHwRegOfS5K4CAGX(0xb0, 0x70, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0xb0, 0x22, 0x0a, 0x00); // 10bit
		SetHwRegOfS5K4CAGX(0xb0, 0x80, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0xb0, 0x00, 0x00, 0x03);

		SetHwRegOfS5K4CAGX(0x00, 0x30, 0x00, 0x07);
		SetHwRegOfS5K4CAGX(0x00, 0x30, 0x00, 0x06);
		SetHwRegOfS5K4CAGX(0x00, 0x30, 0x00, 0x07);		
	}
	else if(eSrcFmt == BayerRGB12)
	{
		SetHwRegOfS5K4CAGX(0x00, 0x52, 0x01, 0x40);	// PLL M
		SetHwRegOfS5K4CAGX(0x00, 0x54, 0x00, 0x06);	// PLL P
		SetHwRegOfS5K4CAGX(0x00, 0x56, 0x00, 0x04);	// PLL S
		SetHwRegOfS5K4CAGX(0x00, 0x50, 0x00, 0x01);	// PLL en
		
		SetHwRegOfS5K4CAGX(0x00, 0x60, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0x00, 0x64, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0x10, 0x02, 0x11, 0x01);
		SetHwRegOfS5K4CAGX(0xa0, 0x10, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0xa0, 0x8e, 0x00, 0x20);
		SetHwRegOfS5K4CAGX(0xa0, 0x44, 0x00, 0x7d);
		SetHwRegOfS5K4CAGX(0xa0, 0x4c, 0x00, 0x17);
		SetHwRegOfS5K4CAGX(0xa0, 0x4e, 0x00, 0x08);
		SetHwRegOfS5K4CAGX(0xa0, 0x50, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0xa0, 0x52, 0x00, 0x06);
		SetHwRegOfS5K4CAGX(0xa0, 0x54, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0x00, 0x20, 0x70, 0x00);
		SetHwRegOfS5K4CAGX(0x00, 0x22, 0x17, 0xb6);
		SetHwRegOfS5K4CAGX(0x00, 0x24, 0x70, 0x00);
		SetHwRegOfS5K4CAGX(0x00, 0x26, 0x18, 0x1a);
		SetHwRegOfS5K4CAGX(0x00, 0x2a, 0x10, 0x04);

		SetHwRegOfS5K4CAGX(0x10, 0x50, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x20, 0x00, 0x00, 0x86);
		SetHwRegOfS5K4CAGX(0x20, 0x02, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0x20, 0x04, 0x08, 0x00);
		SetHwRegOfS5K4CAGX(0x20, 0x06, 0x06, 0x00);
		SetHwRegOfS5K4CAGX(0x20, 0x0a, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0x20, 0x20, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x31, 0x02, 0x08, 0x00);

		SetHwRegOfS5K4CAGX(0x31, 0x04, 0x06, 0x00);
		SetHwRegOfS5K4CAGX(0x32, 0x18, 0x07, 0xf8);
		SetHwRegOfS5K4CAGX(0x32, 0x1a, 0x06, 0x00);

		SetHwRegOfS5K4CAGX(0x48, 0x00, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x34, 0x00, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x63, 0x00, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x64, 0x00, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x65, 0x00, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x66, 0x00, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x68, 0x00, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x74, 0x2a, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x70, 0x00, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x71, 0xba, 0x00, 0x01);

		SetHwRegOfS5K4CAGX(0x74, 0x22, 0x03, 0x80);
		SetHwRegOfS5K4CAGX(0x74, 0x24, 0x03, 0x80);
		SetHwRegOfS5K4CAGX(0x74, 0x26, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x74, 0x28, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x75, 0x00, 0x00, 0x00);

		SetHwRegOfS5K4CAGX(0x31, 0x00, 0x00, 0x19);
		SetHwRegOfS5K4CAGX(0x30, 0x00, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0x32, 0x00, 0x00, 0x00);

		SetHwRegOfS5K4CAGX(0x32, 0x18, 0x08, 0x00);
		SetHwRegOfS5K4CAGX(0x32, 0x1a, 0x06, 0x00);
		SetHwRegOfS5K4CAGX(0x48, 0x00, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x41, 0x00, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x42, 0x02, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x43, 0x00, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x4a, 0x00, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x6a, 0x00, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x63, 0x00, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x64, 0x00, 0x00, 0x01);	
		SetHwRegOfS5K4CAGX(0x65, 0x00, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x66, 0x00, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x67, 0x00, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x68, 0x00, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0x6d, 0x00, 0x00, 0x01);

		SetHwRegOfS5K4CAGX(0xb0, 0x00, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0xb0, 0x02, 0x00, 0x2c); // video data type
		//SetHwRegOfS5K4CAGX(0xb0, 0x08, 0x00, 0x08);
		SetHwRegOfS5K4CAGX(0xb0, 0x08, 0x00, 0x0c);	// bayer 12bit
		SetHwRegOfS5K4CAGX(0xb0, 0x0a, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0xb0, 0x0c, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0xb0, 0x10, 0x00, 0x08);
		SetHwRegOfS5K4CAGX(0xb0, 0x14, 0x01, 0x00);	// 12bit
		SetHwRegOfS5K4CAGX(0xb0, 0x40, 0x00, 0x28);
		SetHwRegOfS5K4CAGX(0xb0, 0x50, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0xb0, 0x04, 0x00, 0x30);
		SetHwRegOfS5K4CAGX(0xb0, 0x16, 0x00, 0x88);
		SetHwRegOfS5K4CAGX(0xb0, 0x20, 0x08, 0x03);
		SetHwRegOfS5K4CAGX(0xb0, 0x30, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0xb0, 0x32, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0xb0, 0x34, 0x02, 0x8b);
		SetHwRegOfS5K4CAGX(0xb0, 0x36, 0x03, 0x4c);
		SetHwRegOfS5K4CAGX(0xb0, 0x38, 0x0b, 0xed);
		SetHwRegOfS5K4CAGX(0xb0, 0x40, 0x00, 0x20);
		SetHwRegOfS5K4CAGX(0xb0, 0x42, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0xb0, 0x44, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0xb0, 0x46, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0xb0, 0x48, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0xb0, 0x50, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0xb0, 0x58, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0xb0, 0x62, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0xb0, 0x6a, 0x00, 0x01);
		SetHwRegOfS5K4CAGX(0xb0, 0x7e, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0xb0, 0xa8, 0x00, 0x1d);
		SetHwRegOfS5K4CAGX(0xb0, 0xb0, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0xb0, 0xb2, 0x00, 0x40);
		SetHwRegOfS5K4CAGX(0xb0, 0xc8, 0x00, 0x00);
		
		SetHwRegOfS5K4CAGX(0x31, 0x00, 0x00, 0x18);
		SetHwRegOfS5K4CAGX(0x31, 0x02, 0x08, 0x02);
		SetHwRegOfS5K4CAGX(0x31, 0x04, 0x06, 0x00);

		SetHwRegOfS5K4CAGX(0x00, 0x66, 0x00, 0x05);
		SetHwRegOfS5K4CAGX(0x00, 0x68, 0x00, 0x02);
		
		SetHwRegOfS5K4CAGX(0xb0, 0xa0, 0x00, 0x3f);
		SetHwRegOfS5K4CAGX(0xb0, 0x70, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0xb0, 0x22, 0x0c, 0x00); // 12bit
		SetHwRegOfS5K4CAGX(0xb0, 0x80, 0x00, 0x00);
		SetHwRegOfS5K4CAGX(0xb0, 0x00, 0x00, 0x03);

		SetHwRegOfS5K4CAGX(0x00, 0x30, 0x00, 0x07);
		SetHwRegOfS5K4CAGX(0x00, 0x30, 0x00, 0x06);
		SetHwRegOfS5K4CAGX(0x00, 0x30, 0x00, 0x07);		
	}
	else if(eSrcFmt == CBYCRY)
	{
		SetHwRegOfS5K4CAGX(0x00, 0x14, 0x00, 0x01);

		SetSwRegOfS5K4CAGX(0x02, 0x74, 0x00, 0x01);	// clock calculation mode( 0 : auto, 1 : manual )
		SetSwRegOfS5K4CAGX(0x06, 0x48, 0x00, 0x00);

		// 3. Description about Limits of PLL block
		SetSwRegOfS5K4CAGX(0x06, 0x50, 0x0b, 0xb8);	// the minimum value of pre-divider output in 1kHz unit
		SetSwRegOfS5K4CAGX(0x06, 0x52, 0x17, 0x70);	// the maximum value of pre-divider output in 1kHz unit
		SetSwRegOfS5K4CAGX(0x06, 0x54, 0x02, 0xee);	// the minimum value of main multiplier output in 1Mhz unit
		SetSwRegOfS5K4CAGX(0x06, 0x56, 0x04, 0x4c);	// the maximum value of main multiplier output in 1Mhz unit
		SetSwRegOfS5K4CAGX(0x06, 0x58, 0x00, 0x01);	// The value of  s divider in PLL.
		SetSwRegOfS5K4CAGX(0x06, 0x5a, 0x00, 0x0a);	// This limits the range of M multiplier in PLL.
		
		// 4. requirement of PLL
		SetSwRegOfS5K4CAGX(0x02, 0x62, 0x5d, 0xc0);
		SetSwRegOfS5K4CAGX(0x02, 0x64, 0x00, 0x00);	
		SetSwRegOfS5K4CAGX(0x02, 0x70, 0x00, 0x01);
		SetSwRegOfS5K4CAGX(0x02, 0x72, 0x00, 0x01);
		
		SetSwRegOfS5K4CAGX(0x02, 0x8c, 0x2b, 0xf2);	// system clock in 4KHz unit
		SetSwRegOfS5K4CAGX(0x02, 0x8e, 0x57, 0xe4);	// pvi clock in 4kHz unit					
		SetSwRegOfS5K4CAGX(0x02, 0x90, 0x10, 0xf0);	// P:10, M:a0 // = main multiplier | ( pre divider << uPllMulShifter )			
													  // e.g.) 0x413E => 0x10 for predivier and 0x13E for main multiplier
		SetSwRegOfS5K4CAGX(0x02, 0x92, 0x02, 0x04);	// Tx devider:2, Sclk devider:2  // = Sclk divider * 2 | ( Pvi divider << 8 )	
		
		SetSwRegOfS5K4CAGX(0x02, 0x94, 0x2b, 0xf2);	// system clock in 4KHz unit		
		SetSwRegOfS5K4CAGX(0x02, 0x96, 0x57, 0xe4);	// pvi clock in 4kHz unit	
		SetSwRegOfS5K4CAGX(0x02, 0x98, 0x10, 0xf0);	// = main multiplier | ( pre divider << uPllMulShifter )
													 // e.g.) 0x413E => 0x10 for predivier and 0x13E for main multiplier 
		SetSwRegOfS5K4CAGX(0x02, 0x9a, 0x02, 0x04);	 // = Sclk divider * 2 | ( Pvi divider << 8 )
		
		SetHwRegOfS5K4CAGX(0xb0, 0x80, 0x00, 0x0a);	// MIPI DPHY BandCtl// for 4CA 

		// usClkFreqDiv4 * 4 => system clock which used in ISP & sensor                                
		// usClkFreqDiv4 * 4 * uPVINumer => system clock * sdivider * 2 => input clock of Sclk divider 
		// input clock of Sclk divider = input clock of if/tx clock divider = (VCO >> s divider)/4  

		// 2. initparam update 
		SetSwRegOfS5K4CAGX(0x02, 0x6a, 0x00, 0x00);
		SetSwRegOfS5K4CAGX(0x02, 0x88, 0x00, 0x01);
		SetSwRegOfS5K4CAGX(0x02, 0x8a, 0x00, 0x01);

		// 3. preview configuration . conf 0
		SetSwRegOfS5K4CAGX(0x03, 0x36, 0x00, 0x00); //init clock index

		if(eSize == QXGA)
		{
			SetSwRegOfS5K4CAGX(0x03, 0x2a, 0x08, 0x00);	//width 2048
			SetSwRegOfS5K4CAGX(0x03, 0x2c, 0x06, 0x00);	//Height 1536
		}
		else if(eSize == HD720)
		{
			SetSwRegOfS5K4CAGX(0x03, 0x2a, 0x05, 0x00);	//width 1280
			SetSwRegOfS5K4CAGX(0x03, 0x2c, 0x02, 0xd0);	//Height 720
		}
		else
		{
			Assert(0);
		}
		
		SetSwRegOfS5K4CAGX(0x03, 0x2e, 0x00, 0x05); //format=> 5 : FULL_YUV
		SetSwRegOfS5K4CAGX(0x03, 0x30, 0x3d, 0x86);	// upper limit of output clock which you want to use, about 10%% more
		SetSwRegOfS5K4CAGX(0x03, 0x32, 0x37, 0xaa);	// lower limit of output clock which you want to use, about 10%% less
		SetSwRegOfS5K4CAGX(0x03, 0x34, 0x00, 0x42);
		SetSwRegOfS5K4CAGX(0x03, 0x38, 0x00, 0x02);
		SetSwRegOfS5K4CAGX(0x03, 0x3a, 0x00, 0x02);
		SetSwRegOfS5K4CAGX(0x03, 0x3c, 0x03, 0x50);	// max frame time = 1 / frame rate
		SetSwRegOfS5K4CAGX(0x03, 0x3e, 0x00, 0x00);

		// 3. preview configuration . conf 1
		SetSwRegOfS5K4CAGX(0x03, 0x5c, 0x00, 0x01);	// init clock index

		if(eSize == QXGA)
		{
			SetSwRegOfS5K4CAGX(0x03, 0x50, 0x08, 0x00);	// 2048
			SetSwRegOfS5K4CAGX(0x03, 0x52, 0x06, 0x00);	// 1536			
		}
		else if(eSize == HD720)
		{
			SetSwRegOfS5K4CAGX(0x03, 0x50, 0x05, 0x00);	// 1280
			SetSwRegOfS5K4CAGX(0x03, 0x52, 0x02, 0xd0);	// 720	
		}
		else
		{
			Assert(0);
		}		

		SetSwRegOfS5K4CAGX(0x03, 0x54, 0x00, 0x05);	// 5 : FULL_YUV
		SetSwRegOfS5K4CAGX(0x03, 0x56, 0x3d, 0x86);	//2700	//1400	// upper limit of output clock which you want to use, about 10%% more
		SetSwRegOfS5K4CAGX(0x03, 0x58, 0x37, 0xaa);	//2600	//1300	// lower limit of output clock which you want to use, about 10%% less		
		SetSwRegOfS5K4CAGX(0x03, 0x5a, 0x00, 0x42);
		SetSwRegOfS5K4CAGX(0x03, 0x5e, 0x00, 0x02);
		SetSwRegOfS5K4CAGX(0x03, 0x60, 0x00, 0x02);	
		SetSwRegOfS5K4CAGX(0x03, 0x62, 0x03, 0x50);	// max frame time = 1 / frame rate
		SetSwRegOfS5K4CAGX(0x03, 0x64, 0x00, 0x00);	

		// 4. capture configuration 0(first)  
		SetSwRegOfS5K4CAGX(0x04, 0x00, 0x00, 0x01);	// init clock index
		
		if(eSize == QXGA)
		{
			SetSwRegOfS5K4CAGX(0x03, 0xf4, 0x08, 0x00);	// 2048
			SetSwRegOfS5K4CAGX(0x03, 0xf6, 0x06, 0x00);	// 1536
		}
		else if(eSize == HD720)
		{
			SetSwRegOfS5K4CAGX(0x03, 0xf4,   0x05, 0x00); // 1028
			SetSwRegOfS5K4CAGX(0x03, 0xf6, 0x02, 0xd0);	// 720
		}
		else
		{
			Assert(0);
		}	

		SetSwRegOfS5K4CAGX(0x03, 0xf8, 0x00, 0x05);	// 5 : FULL_YUV
		SetSwRegOfS5K4CAGX(0x03, 0xfa, 0x3d, 0x86);	// upper limit of output clock which you want to use, about 10%% more
		SetSwRegOfS5K4CAGX(0x03, 0xfc, 0x37, 0xaa);	// lower limit of output clock which you want to use, about 10%% less			
		SetSwRegOfS5K4CAGX(0x03, 0xfe, 0x00, 0x42);
		SetSwRegOfS5K4CAGX(0x04, 0x02, 0x00, 0x02);
		SetSwRegOfS5K4CAGX(0x04, 0x04, 0x00, 0x02);
		SetSwRegOfS5K4CAGX(0x04, 0x06, 0x03, 0x50);	// max frame time = 1 / frame rate
		SetSwRegOfS5K4CAGX(0x04, 0x08, 0x00, 0x00);

		Delay(2000);
		// 5. OIF setting for mipi
		SetSwRegOfS5K4CAGX(0x04, 0xf0, 0x00, 0x01);
		SetSwRegOfS5K4CAGX(0x04, 0xf2, 0x08, 0x03);
		SetSwRegOfS5K4CAGX(0x04, 0xf8, 0x00, 0x01);

		Delay(2000);
		// 6. preview activate  
		SetSwRegOfS5K4CAGX(0x02, 0xe2, 0x00, 0x01);
		SetSwRegOfS5K4CAGX(0x02, 0xea, 0x00, 0x00);
		SetSwRegOfS5K4CAGX(0x02, 0xe6, 0x00, 0x01);
		SetSwRegOfS5K4CAGX(0x02, 0xbe, 0x00, 0x01);
		SetSwRegOfS5K4CAGX(0x02, 0xe4, 0x00, 0x01);

		Delay(2000);
		SetHwRegOfS5K4CAGX(0xb0, 0x0c, 0x00, 0x21);		
	}
	else
	{
		Assert(0);
	}
#endif
}

void SetRegOfM5MO(u8 ucCategory, u8 ucRegAddr, u8 ucData)
{
#if 0
	u8 aData[4] = {0x02, ucCategory, ucRegAddr, ucData};
	oIic.Send(0x3E, 0x05, aData, 4);
#endif
}

void GetRegOfM5MO(u8 ucCategory, u8 ucRegAddr, u8* ucData)
{
#if 0
	u8 aData[4] = {0x01, ucCategory, ucRegAddr, 0x1};
	Delay(1000);
	oIic.Send(0x3E, 0x05, aData, 4);
	Delay(1000);
	oIic.Receive(0x3F, *ucData);
#endif
}

void InitM5moForPreview(IMG_RESOLUTION eSize)
{
#if 0
	u32 uGPE1DAT;
	u8 ucData;
	
	oIic.InitIp();

	// 1. Start camera
	//--------------
	Delay(1000);
	SetRegOfM5MO(0x0F, 0x12, 0x01); //0x3E 0x05 0x02 0x0F 0x12 0x01

	// 2. Check interrupt
	//-----------------
	Delay(1000);
	for(;;) // polling interrupt signal
	{
		Inp32(0xe03000c4, uGPE1DAT);
		if((uGPE1DAT&0x20) == 0x20)
		{
			break;
		}
	}
	
	// 3. Clear interrupt
	//----------------
	Delay(1000);
	GetRegOfM5MO(0x00, 0x10, ucData); //0x3E 0x05 0x01 0x00 0x10 0x01 //0x3F
	
	// 4. Set monitor size
	//-----------------
	Delay(1000);
	switch(eSize)
	{
		case QVGA: // 320x240			
			SetRegOfM5MO(0x01, 0x01, 0x03); //0x3E 0x05 0x02 0x01 0x01 0x03
			break;
		case VGA: // 640x480
			SetRegOfM5MO(0x01, 0x01, 0x06); //0x3E 0x05 0x02 0x01 0x01 0x06
			break;
		case WVGA: // 800x480
			SetRegOfM5MO(0x01, 0x01, 0x07); //0x3E 0x05 0x02 0x01 0x01 0x07
			break;		
		case HD720: // 1280x720
			SetRegOfM5MO(0x01, 0x01, 0x11); //0x3E 0x05 0x02 0x01 0x01 0x11
			break;
		case CAM_8M: // 3264x2448
			SetRegOfM5MO(0x01, 0x01, 0x09); //0x3E 0x05 0x02 0x01 0x01 0x09
			break;			
		default:
			Assert(0);
			break;
	}

	// 5. Enable interrupt
	//-----------------	
	Delay(1000);
	SetRegOfM5MO(0x00, 0x11, 0x01); // 0x3E 0x05 0x02 0x00 0x11 0x01 (Enable)
	Delay(1000);
	SetRegOfM5MO(0x00, 0x12, 0x01); // 0x3E 0x05 0x02 0x00 0x12 0x01 (Root enable)

	// 6. Change from parameter mode to monitor mode
	//-------------------------------------------
	Delay(1000);
	SetRegOfM5MO(0x00, 0x0B, 0x02); //0x3E 0x05 0x02 0x00 0x0B 0x02

	// 7. Check interrupt
	//----------------
	Delay(1000);
	for(;;) // polling interrupt signal
	{
		Inp32(0xe03000c4, uGPE1DAT);
		if((uGPE1DAT&0x20) == 0x20)
		{
			break;
		}
	}
	
	// 8. Clear interrupt
	//----------------
	Delay(1000);
	GetRegOfM5MO(0x00, 0x10, ucData); //0x3E 0x05 0x01 0x00 0x10 0x01 //0x3F
#endif
}

void InitM5moToGetJpeg(void)
{
#if 0
	u32 uGPE1DAT;
	u8 ucData;
	
	oIic.InitIp();	

	// Capture mode
	//-------------
	
	// 1) Enable interrupt
	Delay(1000);
	SetRegOfM5MO(0x00, 0x11, 0x88); // 0x3E 0x05 0x02 0x00 0x11 0x88 -> enable
	Delay(1000);
	SetRegOfM5MO(0x00, 0x12, 0x01); // 0x3E 0x05 0x02 0x00 0x12 0x01 -> root enable
	
	// 2) Start single capture 	
	Delay(1000);
	SetRegOfM5MO(0x00, 0x0B, 0x03); // 0x3E 0x05 0x02 0x00 0x0B 0x03
	
	// 3) Check interrupt
	Delay(1000);
	for(;;) // polling interrupt signal
	{
		Inp32(0xe03000c4, uGPE1DAT);
		if((uGPE1DAT&0x20) == 0x20)
		{
			break;
		}
	}
	
	// 4) Clear interrupt
	Delay(1000);
	GetRegOfM5MO(0x00, 0x10, ucData); //0x3E 0x05 0x01 0x00 0x10 0x01 //0x3F	
	
	// 5) Enable interrupt
	Delay(1000);
	SetRegOfM5MO(0x00, 0x12, 0x01); // 0x3E 0x05 0x02 0x00 0x12 0x01 -> root enable
	
	// 6) Check interrupt
	Delay(1000);
	for(;;) // polling interrupt signal
	{
		Inp32(0xe03000c4, uGPE1DAT);
		if((uGPE1DAT&0x20) == 0x20)
		{
			break;
		}
	}
	
	// 7) Clear interrupt
	Delay(1000);
	GetRegOfM5MO(0x00, 0x10, ucData); //0x3E 0x05 0x01 0x00 0x10 0x01 //0x3F
#endif
}

void GetJpegFromM5mo(IMG_RESOLUTION eOutJpegSize, u32* uJpgFileSz)
{
#if 0
	u32 uGPE1DAT;
	u8 ucData;
	
	oIic.InitIp();

	// Get main image data
	//-------------------
	
	// 1) Capture select frame main
	Delay(1000);
	SetRegOfM5MO(0x0C, 0x06, 0x01); // 0x3E 0x05 0x02 0x0C 0x06 0x01
	
	// 2) Set main image JPEG file max size (4 Mbytes)
	Delay(1000);
	SetRegOfM5MO(0x0B, 0x0F, 0x00); // 0x3E 0x05 0x02 0x0B 0x0F 0x00
	Delay(1000);
	SetRegOfM5MO(0x0B, 0x10, 0x40); // 0x3E 0x05 0x02 0x0B 0x10 0x40
	Delay(1000);
	SetRegOfM5MO(0x0B, 0x11, 0x00); // 0x3E 0x05 0x02 0x0B 0x11 0x00
	Delay(1000);
	SetRegOfM5MO(0x0B, 0x12, 0x00); // 0x3E 0x05 0x02 0x0B 0x12 0x00
	
	// 3) Set main image JPEG file min size (0 Bytes)
	Delay(1000);
	SetRegOfM5MO(0x0B, 0x13, 0x00); // 0x3E 0x05 0x02 0x0B 0x13 0x00
	Delay(1000);
	SetRegOfM5MO(0x0B, 0x14, 0x00); // 0x3E 0x05 0x02 0x0B 0x14 0x00
	Delay(1000);
	SetRegOfM5MO(0x0B, 0x15, 0x00); // 0x3E 0x05 0x02 0x0B 0x15 0x00
	Delay(1000);
	SetRegOfM5MO(0x0B, 0x16, 0x00); // 0x3E 0x05 0x02 0x0B 0x16 0x00
	
	// 4) Select main image format (JPEG with header: 422)
	Delay(1000);
	SetRegOfM5MO(0x0B, 0x00, 0x01); // 0x3E 0x05 0x02 0x0B 0x00 0x01
	
	// 5) Set main image size
	Delay(1000);
	switch(eOutJpegSize)
	{
		case QVGA: // 320x240			
			SetRegOfM5MO(0x0B, 0x01, 0x00); // 0x3E 0x05 0x02 0x0B 0x01 0x00
			break;
		case VGA: // 640x480
			SetRegOfM5MO(0x0B, 0x01, 0x02); // 0x3E 0x05 0x02 0x0B 0x01 0x02
			break;
		case WVGA: // 800x480
			SetRegOfM5MO(0x0B, 0x01, 0x03); // 0x3E 0x05 0x02 0x0B 0x01 0x03
			break;		
		case CAM_8M: // 3264x2448
			SetRegOfM5MO(0x0B, 0x01, 0x09); // 0x3E 0x05 0x02 0x0B 0x01 0x09
			break;			
		default:
			Assert(0);
			break;		
	}

	// 6) Enable interrupt
	Delay(1000);
	SetRegOfM5MO(0x00, 0x12, 0x01); // 0x3E 0x05 0x02 0x00 0x12 0x01 -> root enable
	
	// 7) Get main JPEG data, capture transfer start
	Delay(1000);
	SetRegOfM5MO(0x0C, 0x09, 0x01); // 0x3E 0x05 0x02 0x0C 0x09 0x01

	// 8) Check interrupt
	Delay(1000);
	for(;;) // polling interrupt signal
	{
		Inp32(0xe03000c4, uGPE1DAT);
		if((uGPE1DAT&0x20) == 0x20)
		{
			break;
		}
	}

	// 9) Clear interrupt
	Delay(1000);
	GetRegOfM5MO(0x00, 0x10, ucData); //0x3E 0x05 0x01 0x00 0x10 0x01 //0x3F

	// 10) Get JPEG size
	u8 ucJpegSize_31_24; // Bit: 31~24
	u8 ucJpegSize_23_16; // Bit: 23~16
	u8 ucJpegSize_15_8; // Bit: 15~8
	u8 ucJpegSize_7_0; // Bit: 7~0
	Delay(1000);
	GetRegOfM5MO(0x0C, 0x0D, ucJpegSize_31_24); // 0x3E 0x05 0x01 0x0C 0x0D 0x01 // 0x3F
	Delay(1000);
	GetRegOfM5MO(0x0C, 0x0E, ucJpegSize_23_16); // 0x3E 0x05 0x01 0x0C 0x0E 0x01 // 0x3F
	Delay(1000);
	GetRegOfM5MO(0x0C, 0x0F, ucJpegSize_15_8); // 0x3E 0x05 0x01 0x0C 0x0F 0x01 //0x3F
	Delay(1000);
	GetRegOfM5MO(0x0C, 0x10, ucJpegSize_7_0); // 0x3E 0x05 0x01 0x0C 0x10 0x01 // 0x3F
	u32 uJpegSize_31_24 = (u32)(ucJpegSize_31_24);
	u32 uJpegSize_23_16 = (u32)(ucJpegSize_23_16);
	u32 uJpegSize_15_8 = (u32)(ucJpegSize_15_8);
	u32 uJpegSize_7_0 = (u32)(ucJpegSize_7_0);	
	*uJpgFileSz = 0x00000000;
	*uJpgFileSz = (*uJpgFileSz) |(uJpegSize_31_24<<24);
	*uJpgFileSz = (*uJpgFileSz) |(uJpegSize_23_16<<16);
	*uJpgFileSz = (*uJpgFileSz) |(uJpegSize_15_8<<8);
	*uJpgFileSz = (*uJpgFileSz) |(uJpegSize_7_0<<0);
	if((*uJpgFileSz) == 0xFFFFFFFF)
	{
		Assert(0);
	}
	
	// 11) Read Exif information

	// 12) Enable interrupt
	Delay(1000);
	SetRegOfM5MO(0x00, 0x11, 0x01); // 0x3E 0x05 0x02 0x00 0x11 0x01 -> enable
	Delay(1000);
	SetRegOfM5MO(0x00, 0x12, 0x01); // 0x3E 0x05 0x02 0x00 0x12 0x01 -> root enable

	// 13) Change to monitor mode
	Delay(1000);
	SetRegOfM5MO(0x00, 0x0B, 0x02); // 0x3E 0x05 0x02 0x00 0x0B 0x02

	// 14) Check interrupt
	Delay(1000);
	for(;;) // polling interrupt signal
	{
		Inp32(0xe03000c4, uGPE1DAT);
		if((uGPE1DAT&0x20) == 0x20)
		{
			break;
		}
	}

	// 15) Clear interrupt
	Delay(1000);
	GetRegOfM5MO(0x00, 0x10, ucData); //0x3E 0x05 0x01 0x00 0x10 0x01 //0x3F
#endif
}

void CAM_InitCE143MonacoForPreview(IMG_RESOLUTION eSize)
{
	u8  pIicData[3]={0, 0, 0};
	u32 uDelay1, uDelay2;

	// Initialize I2C channel 0
	I2C_GPIO_Open(I2C_CH0);
	I2C_SFR_Mapping_Init(I2C_CH0);
	I2C_Initialize_Controller(I2C_CH0);

	// Set I2C slave address
	ucSlaveAddr = 0x78; // 0x0111_100X

	// Set F/W(in camera module) start
	pIicData[0] = 0xf0;	
	if(I2C_Master_Polling_Write(I2C_CH0, ucSlaveAddr, pIicData, (s32)0x1) == ERROR)
	{
		Assert(0);
	}
	
	for(uDelay1=0;uDelay1<1000;uDelay1++)
	{
		for(uDelay2=0;uDelay2<1000000;uDelay2++)
		{
		}
	}
	Disp("\n F/W READY delay end! \n");

	Disp("\n Flow 0 \n");

	// Set preview stop
	pIicData[0] = 0x6b;
	pIicData[1] = 0x00;
	if(I2C_Master_Polling_Write(I2C_CH0, ucSlaveAddr, pIicData, (s32)0x2) == ERROR)
	{
		Assert(0);
	}	
	do
	{
		for(uDelay2=0;uDelay2<1000000;uDelay2++)
		{
		}
		
		pIicData[0] = 0x6c;
		if(I2C_Master_Polling_Write(I2C_CH0, ucSlaveAddr, pIicData, (s32)0x1) == ERROR)
		{
			Assert(0);
		}
		if(I2C_Master_Polling_Read(I2C_CH0, ucSlaveAddr, pIicData, (s32)0x1) == ERROR)
		{
			Assert(0);
		}
	}
	while(pIicData[0] != 0x0);		

	Disp("\n Flow 1 \n");

	// Set resolution
	switch(eSize)
	{
		case HD720: // 1280x720
			pIicData[0] = 0x54;
			pIicData[1] = 0x16;
			pIicData[2] = 0x01;			
			break;	
		case WVGA: // 800x480
			pIicData[0] = 0x54;
			pIicData[1] = 0x13;
			pIicData[2] = 0x01;			
			break;			
		case SD480: // 720x480
			pIicData[0] = 0x54;
			pIicData[1] = 0x20;
			pIicData[2] = 0x01; 		
			break;
		case VGA: // 640x480
			pIicData[0] = 0x54;
			pIicData[1] = 0x04;
			pIicData[2] = 0x01; 		
			break;			
		case QVGA: // 320x240
			pIicData[0] = 0x54;
			pIicData[1] = 0x02;
			pIicData[2] = 0x01; 		
			break;
		default:
			Assert(0);
			break;			
	}	
	if(I2C_Master_Polling_Write(I2C_CH0, ucSlaveAddr, pIicData, (s32)0x3) == ERROR)
	{
		Assert(0);
	}

#if 1
	 // For QVGA 120[FPS]
	 if(eSize == QVGA)
 	{
 		pIicData[0] = 0x54;
		pIicData[1] = 0x02;
		pIicData[2] = 0x04; 
			
		if(I2C_Master_Polling_Write(I2C_CH0, ucSlaveAddr, pIicData, (s32)0x3) == ERROR)
		{
			Assert(0);
		}	
		
		//--------------------------
		
		pIicData[0] = 0x5a;
		pIicData[1] = 0x78;
		pIicData[2] = 0x00; 
			
		if(I2C_Master_Polling_Write(I2C_CH0, ucSlaveAddr, pIicData, (s32)0x3) == ERROR)
		{
			Assert(0);
		}	
 	}
#endif

	Disp("\n Flow 2 \n");

	// Set preview start
	pIicData[0] = 0x6b;
	pIicData[1] = 0x01;
	if(I2C_Master_Polling_Write(I2C_CH0, ucSlaveAddr, pIicData, (s32)0x2) == ERROR)
	{
		Assert(0);
	}	
	do
	{
		for(uDelay2=0;uDelay2<1000000;uDelay2++)
		{
		}
			
		pIicData[0] = 0x6c;
		if(I2C_Master_Polling_Write(I2C_CH0, ucSlaveAddr, pIicData, (s32)0x1) == ERROR)
		{
			Assert(0);
		}	
		if(I2C_Master_Polling_Read(I2C_CH0, ucSlaveAddr, pIicData, (s32)0x1) == ERROR)
		{
			Assert(0);
		}	
	}
	while(pIicData[0] != 0x8); // '0x8' means 'under preview'

	Disp("\n Flow 3 \n");
}

void CAM_InitCE143MonacoToGetJpeg(IMG_RESOLUTION eSize)
{
	u8  pIicData[8]={0, 0, 0, 0, 0, 0, 0, 0};
	u32 uDelay1, uDelay2;

	// Set I2C slave address
	ucSlaveAddr = 0x78; // 0x0111_100X

#if 0
	for(uDelay1=0;uDelay1<1000;uDelay1++)
	{
		for(uDelay2=0;uDelay2<1000000;uDelay2++)
		{
		}
	}
#endif	
	Disp("\n Flow 0 \n");

	CAM_InitCE143MonacoForPreview(WVGA);
	for(uDelay1=0;uDelay1<1000;uDelay1++)
	{
		for(uDelay2=0;uDelay2<1000000;uDelay2++)
		{
		}
	}
	Disp("\n Preview running delay end! \n");	

#if 0
	for(uDelay1=0;uDelay1<1000;uDelay1++)
	{
		for(uDelay2=0;uDelay2<1000000;uDelay2++)
		{
		}
	}
#endif	
	Disp("\n Flow 1 \n");

	// Set buffering capture
	pIicData[0] = 0x73;
	switch(eSize)
	{
		case CAM_12M: // 4000x3000
			pIicData[1] = 0x11;
			break;
		case CAM_W10M: // 4000x2400
			pIicData[1] = 0x24;
			break;
		case CAM_8M: // 3264x2448
			pIicData[1] = 0x0e;
			break;
		case CAM_W6M: // 3264x1960
			pIicData[1] = 0x22;
			break;
		default:
			Assert(0);
			break;			
	}	
	pIicData[2] = 0x00;
	pIicData[3] = 0x01;
	pIicData[4] = 0x00;
	if(I2C_Master_Polling_Write(I2C_CH0, ucSlaveAddr, pIicData, (s32)0x5) == ERROR)
	{
		Assert(0);
	}

#if 0
	for(uDelay1=0;uDelay1<1000;uDelay1++)
	{
		for(uDelay2=0;uDelay2<1000000;uDelay2++)
		{
		}
	}
#endif	
	Disp("\n Flow 2 \n");	

	// Set AE/AWB lock
	pIicData[0] = 0x11;
	pIicData[1] = 0x11;
	if(I2C_Master_Polling_Write(I2C_CH0, ucSlaveAddr, pIicData, (s32)0x2) == ERROR)
	{
		Assert(0);
	}

#if 0
	for(uDelay1=0;uDelay1<1000;uDelay1++)
	{
		for(uDelay2=0;uDelay2<1000000;uDelay2++)
		{
		}
	}
#endif	
	Disp("\n Flow 3 \n");	

	// Set buffering capture start
	pIicData[0] = 0x74;
	if(I2C_Master_Polling_Write(I2C_CH0, ucSlaveAddr, pIicData, (s32)0x1) == ERROR)
	{
		Assert(0);
	}
	for(uDelay1=0;uDelay1<1000;uDelay1++)
	{
		for(uDelay2=0;uDelay2<1000000;uDelay2++)
		{
		}
	}
	Disp("\n Buffering capture start delay end! \n");

#if 0
	for(uDelay1=0;uDelay1<1000;uDelay1++)
	{
		for(uDelay2=0;uDelay2<1000000;uDelay2++)
		{
		}
	}
#endif	
	Disp("\n Flow 4 \n");

	do
	{
		for(uDelay2=0;uDelay2<1000000;uDelay2++)
		{
		}
			
		pIicData[0] = 0x6c;
		if(I2C_Master_Polling_Write(I2C_CH0, ucSlaveAddr, pIicData, (s32)0x1) == ERROR)
		{
			Assert(0);
		}		
		if(I2C_Master_Polling_Read(I2C_CH0, ucSlaveAddr, pIicData, (s32)0x1) == ERROR)
		{
			Assert(0);
		}	
	}
	while(pIicData[0] != 0x0);	

#if 0
	for(uDelay1=0;uDelay1<1000;uDelay1++)
	{
		for(uDelay2=0;uDelay2<1000000;uDelay2++)
		{
		}
	}
#endif	
	Disp("\n Flow 5 \n");

	// Set JPEG (including compression rate)
	pIicData[0] = 0x90;
	pIicData[1] = 0x00;
	pIicData[2] = 0xdc;
	pIicData[3] = 0x05;
	pIicData[4] = 0x78;
	pIicData[5] = 0x05; 
	pIicData[6] = 0x0a;
	pIicData[7] = 0x00; 
	if(I2C_Master_Polling_Write(I2C_CH0, ucSlaveAddr, pIicData, (s32)0x8) == ERROR)
	{
		Assert(0);
	}

#if 0
	for(uDelay1=0;uDelay1<1000;uDelay1++)
	{
		for(uDelay2=0;uDelay2<1000000;uDelay2++)
		{
		}
	}
#endif	
	Disp("\n Flow 6 \n");

	// Set JPEG start
	pIicData[0] = 0x92;
	pIicData[1] = 0x00;
	if(I2C_Master_Polling_Write(I2C_CH0, ucSlaveAddr, pIicData, (s32)0x2) == ERROR)
	{
		Assert(0);
	}
	do
	{
		for(uDelay2=0;uDelay2<1000000;uDelay2++)
		{
		}
			
		pIicData[0] = 0x6c;
		if(I2C_Master_Polling_Write(I2C_CH0, ucSlaveAddr, pIicData, (s32)0x1) == ERROR)
		{
			Assert(0);
		}		
		if(I2C_Master_Polling_Read(I2C_CH0, ucSlaveAddr, pIicData, (s32)0x1) == ERROR)
		{
			Assert(0);
		}	
	}
	while(pIicData[0] != 0x0);	

#if 0
	for(uDelay1=0;uDelay1<1000;uDelay1++)
	{
		for(uDelay2=0;uDelay2<1000000;uDelay2++)
		{
		}
	}
#endif	
	Disp("\n Flow 7 \n");

	// Get JPEG status
	pIicData[0] = 0x93;
	if(I2C_Master_Polling_Write(I2C_CH0, ucSlaveAddr, pIicData, (s32)0x1) == ERROR)
	{
		Assert(0);
	}
	if(I2C_Master_Polling_Read(I2C_CH0, ucSlaveAddr, pIicData, (s32)0x4) == ERROR)
	{
		Assert(0);
	}
	Disp("\n Q (%2x), size (%2x %2x %2x)\n", pIicData[0], pIicData[3], pIicData[2], pIicData[1]);

	for(uDelay1=0;uDelay1<1000;uDelay1++)
	{
		for(uDelay2=0;uDelay2<1000000;uDelay2++)
		{
		}
	}
	Disp("\n Flow 8 \n");
}

void CAM_SetCE143MonacoToGetJpeg(void)
{
	u8 pIicData[3]={0, 0, 0};
	u32 uDelay1, uDelay2;

	// Set I2C slave address
	ucSlaveAddr = 0x78; // 0x0111_100X

	// Set output data
	pIicData[0] = 0x65;
	pIicData[1] = 0x02;
	pIicData[2] = 0x00;
	if(I2C_Master_Polling_Write(I2C_CH0, ucSlaveAddr, pIicData, (s32)0x3) == ERROR)
	{
		Assert(0);
	}
	if(I2C_Master_Polling_Read(I2C_CH0, ucSlaveAddr, pIicData, (s32)0x3) == ERROR)
	{
		Assert(0);
	}
	Disp("\n Size (%2x %2x %2x)\n", pIicData[2], pIicData[1], pIicData[0]);

#if 0	
	for(uDelay1=0;uDelay1<1000;uDelay1++)
	{
		for(uDelay2=0;uDelay2<1000000;uDelay2++)
		{
		}
	}
#endif	
	Disp("\n Flow 0 \n");
	
	// Set output data transfer
	pIicData[0] = 0x66;
	if(I2C_Master_Polling_Write(I2C_CH0, ucSlaveAddr, pIicData, (s32)0x1) == ERROR)
	{
		Assert(0);
	}
	if(I2C_Master_Polling_Read(I2C_CH0, ucSlaveAddr, pIicData, (s32)0x3) == ERROR)
	{
		Assert(0);
	}
	Disp("\n Size (%2x %2x %2x)\n", pIicData[2], pIicData[1], pIicData[0]);

#if 0	
	for(uDelay1=0;uDelay1<1000;uDelay1++)
	{
		for(uDelay2=0;uDelay2<1000000;uDelay2++)
		{
		}
	}
#endif	
	Disp("\n Flow 1 \n");

	// Check output data transfer status
	do
	{
		for(uDelay2=0;uDelay2<1000000;uDelay2++)
		{
		}
			
		pIicData[0] = 0x61;
		if(I2C_Master_Polling_Write(I2C_CH0, ucSlaveAddr, pIicData, (s32)0x1) == ERROR)
		{
			Assert(0);
		}		
		if(I2C_Master_Polling_Read(I2C_CH0, ucSlaveAddr, pIicData, (s32)0x1) == ERROR)
		{
			Assert(0);
		}	
	}
	while(pIicData[0] != 0x0);

#if 0	
	for(uDelay1=0;uDelay1<1000;uDelay1++)
	{
		for(uDelay2=0;uDelay2<1000000;uDelay2++)
		{
		}
	}
#endif	
	Disp("\n Flow 2 \n");
}

