/**************************************************************************************
* 
*	Project Name : S3C6410 Validation
*
*	Copyright 2006 by Samsung Electronics, Inc.
*	All rights reserved.
*
*	Project Description :
*		This software is only for validating functions of the S3C6410.
*		Anybody can use this software without our permission.
*  
*--------------------------------------------------------------------------------------
* 
*	File Name : SROMC_test.c
*  
*	File Description : This file implements the functons for SROM controller test.
*
*	Author : Sunil Roe
*	Dept. : AP Development Team
*	Created Date : 2007/02/22
*	Version : 0.1 
* 
*	History
*	- Created(sunil.roe 2007/02/22)
*  	- Modify	(HeeMyung.Noh 2008/02/27)
**************************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "def.h"
#include "option.h"
#include "library.h"
#include "v210_sfr.h"
#include "system.h"
#include "sysc.h"
#include "dma.h"
#include "intc.h"
#include "sromc.h"
#include "nand.h"
#include "gpio.h"
//#include "onenand.h"
//#include "cf.h"
//#include "ata.h"
#include "timer.h"
//#include "cs8900.h"
//#include  "lan9115.h"

#include "audi_ondc.h"

#define SRAM_DATA_SIZE	0x1000
#define NAND_DATA_SIZE	512

//rb1004
#define SROMC_Tacs_MIN		(0)
#define SROMC_Tacs_TYP		(0)
#define SROMC_Tacs_MAX		(4)		// 15

#define SROMC_Tcos_MIN		(0)		// K4X4016T3F : 3[HCLK] at 133MHz
#define SROMC_Tcos_TYP		(3)		// K4X4016T3F : 3[HCLK] at 133MHz
#define SROMC_Tcos_MAX		(4)		//15

#define SROMC_Tacc_MIN		(0)		//K4X4016T3F : 6[HCLK] at 133Mhz
#define SROMC_Tacc_TYP		(8)		//K4X4016T3F : 6[HCLK] at 133Mhz
#define SROMC_Tacc_MAX		(12)		//32

#define SROMC_Tcoh_MIN		(0)		// orginal  1
#define SROMC_Tcoh_TYP		(1)		// orginal  1
#define SROMC_Tcoh_MAX		(4)		//15

#define SROMC_Tcah_MIN		(0)		//0
#define SROMC_Tcah_TYP		(1)		//0
#define SROMC_Tcah_MAX		(4)		// 15

//#define SROMC_Tacp_MIN		(0)		// In case of Non Page Mode	
#define SROMC_Tacp_MIN		(0)		// In case of Page Mode Test
#define SROMC_Tacp_TYP		(2)		// In case of Page Mode Test
#define SROMC_Tacp_MAX		(4)		//15

// Device
#define SROMC_6400			(0)
#define SROMC_v210			(1)
#define SROMC_DEVICE		SROMC_v210

// External SRAM Memory Access Size Setting
#if (SROMC_DEVICE == SROMC_v210)
//#define SROMC_SRAM_SIZE	(512*1024)	
#define SROMC_SRAM_SIZE	(15*1024)	// modem dpram 16K  // should be aligned for 64bit x 16burst 
#else
#define SROMC_SRAM_SIZE	(64*1024)
#endif

#define SROMC_WRITE_BASE	(_DRAM_BaseAddress + 0x01000000)
#define SROMC_READ_BASE	(_DRAM_BaseAddress + 0x01200000)
#define SROMC_COMPARE_BASE	(_DRAM_BaseAddress + 0x01400000)

// SROMC data pattern setting
#define SROMC_DATA_RANDOM	(0)
#define SROMC_DATA_ONEVALUE	(0x5A5A5A5A)
#define SROMC_DATA_PATTERN 	(SROMC_DATA_RANDOM)

// SROMC Data Transfer Type
#define SROMC_POLLING		(0)
#define SROMC_MEMCPY		(1)
#define SROMC_DMA			(2)
#define SROMC_TR_TYPE		SROMC_DMA

DMAC g_oSROMCDmac0;
volatile u32 SROMC_DmaDone;

// EBI_oInform	g_oaEBIInform[MEMIF_NUM];
u8 aBuffer[512];			//NAND_PAGE_MAX
u8 aSpareBuffer[200];		//NAND_SPARE_MAX
u32 aReadData[512/4] = {0, };   //ONENAND_PAGESIZE
u32	g_uLLIBaseAddr = _DRAM_BaseAddress + 0x00100000;
volatile u32 Nand_DmaTestDone;
u32 g_uOneNANDSrcAddr = 0;

extern void ProgramAM29F800(void);
bool DM9000_16bit_Test_autotest(void);

void __irq SROMC_DmaISR(void)
{
	

	#if 0
  	DMA_ClearIntPending(NUM_MDMA,&g_oSROMCDmac0);

	SROMC_DmaDone = 1;
	INTC_ClearVectAddr();
	#endif
	/////////////

	u32 uInt;
	
	UART_Printf("DMA_Int\n");
	INTC_Disable(NUM_PDMA0);

	DMA_GetIntrSrc(&uInt, &g_oSROMCDmac0);
	

		DMA_ClearIntPending(uInt, &g_oSROMCDmac0);	
		SROMC_DmaDone = 1;
		DMA_StopCh(&g_oSROMCDmac0);
	//	Disp("Ch NO %d DMA Transfer Done Interrupt !! \n",uInt);
	
	INTC_ClearVectAddr();

	INTC_Enable(NUM_PDMA0);




	
}

void __irq DM9000_DmaISR(void)
{
	

  	u32 uInt;
	
	UART_Printf("DMA_Int\n");
	
	INTC_Disable(NUM_PDMA0);

	DMA_GetIntrSrc(&uInt, &g_oSROMCDmac0);
	

		DMA_ClearIntPending(uInt, &g_oSROMCDmac0);	
		SROMC_DmaDone = 1;
		DMA_StopCh(&g_oSROMCDmac0);
		Disp("Ch NO %d DMA Transfer Done Interrupt !! \n",uInt);
	
	INTC_ClearVectAddr();

	INTC_Enable(NUM_PDMA0);




	
}


#if  0
//rb1004.....for EBI Multi Access Test
//extern DMAC g_oDmc0Dmac0;
void __irq SROMC_MADmaISR(void)
{
	u32 uIntStatus;
	
	//uIntStatus = DMAC_IntStatus(&g_oSROMCDmac0);
	uIntStatus = *(u32 *)0x75000000;

	if(uIntStatus & 0x01)		// SROMC Dma : DMA0 Ch0
	{
  		DMA_ClearIntPendingrb1004(&g_oSROMCDmac0, 0x01);
		SROMC_DmaDone = 1;
	}

	INTC_ClearVectAddr();
}
#endif
u32 SROMC_WriteReadTest(SROMC_eBANK uBank, Bank_eTiming eTacs, Bank_eTiming eTcos,Bank_eTiming eTacc, 
							 					Bank_eTiming eTcoh, Bank_eTiming eTcah, Bank_eTiming eTacp, Page_eMode ePageMode )
{
	u32 i;
	u8 bError = FALSE;
	u32 *pWriteBaseData, *pReadBaseData, *pWriteData, *pReadData;
	u32 *pBankBaseAddress, *pAddress;

//	pWriteBaseData = (u32 *)malloc(SROMC_SRAM_SIZE);
	pWriteBaseData = (u32 *)SROMC_WRITE_BASE;	
	if(pWriteBaseData == 0)
	{
		UART_Printf("Memory Allocation Error...\n");
		return 0;
	}
	pWriteData = pWriteBaseData;
	
//	pReadBaseData = (u32 *)malloc(SROMC_SRAM_SIZE);	
	pReadBaseData = (u32 *)SROMC_READ_BASE;	
	if(pReadBaseData == 0)
	{
//		free(pWriteBaseData);
		UART_Printf("Memory Allocation Error...\n");
		return 0;
	}
	pReadData = pReadBaseData;

	pBankBaseAddress = (u32 *)((uBank * 0x08000000)+0x80000000);
	pAddress = pBankBaseAddress;


#if (SROMC_TR_TYPE == SROMC_DMA)
#if 1	//DMA0 controller

	INTC_SetVectAddr(NUM_MDMA,  SROMC_DmaISR);
	INTC_Enable(NUM_MDMA);

#elif 0	//DMA1 controller
	DMAC_InitCh(DMA1, DMA_ALL, &g_oSROMCDmac0);
	INTC_SetVectAddr(NUM_DMA1,  SROMC_DmaISR);
	INTC_Enable(NUM_DMA1);
#elif 0	//SDMA0 controller
	DMAC_InitCh(SDMA0, DMA_ALL, &g_oSROMCDmac0);
	INTC_SetVectAddr(NUM_SDMA0,  SROMC_DmaISR);
	INTC_Enable(NUM_SDMA0);
#else	//SDMA1 controller
	DMAC_InitCh(SDMA1, DMA_ALL, &g_oSROMCDmac0);
	INTC_SetVectAddr(NUM_SDMA1,  SROMC_DmaISR);
	INTC_Enable(NUM_SDMA1);	
#endif	
#endif	

	UART_Printf("Tacs(%d), Tcos(%d), Tacc(%d), Tcoh(%d), Tcah(%d), Tacp(%d)\n", eTacs, eTcos, eTacc, eTcoh, eTcah, eTacp);
	SROMC_SetTiming(uBank, eTacs, eTcos, eTacc, 	eTcoh, eTcah, eTacp, ePageMode);
	DelayfrTimer(milli, 1);
	
	pWriteData = pWriteBaseData;
	
	srand(eTacs + eTcos + eTacc + eTcoh + eTcah + eTacp);

#if 1	
	for(i=0; i<SROMC_SRAM_SIZE/4; i++)
	{
#if(SROMC_DATA_PATTERN == SROMC_DATA_RANDOM)
		*pWriteData++ = rand();
#else	// ONDT_DATA_PATTERN == ONDT_DATA_ONEVALUE
		*pWriteData++ = SROMC_DATA_ONEVALUE;
#endif
	}
#else	// rb1004... for 8-bit bus width test(external bus width : 16bit at SMDK)
	{	
		u8 cTemp;
		
		for(i=0; i<SROMC_SRAM_SIZE/2; i++)
		{
#if(SROMC_DATA_PATTERN == SROMC_DATA_RANDOM)
			cTemp = (u8)rand();
			*((u8 *)pWriteData)++ = cTemp;
			*((u8 *)pWriteData)++ = cTemp;
#else	// ONDT_DATA_PATTERN == ONDT_DATA_ONEVALUE
			*((u8 *)pWriteData)++ = (u8)(SROMC_DATA_ONEVALUE);
			*((u8 *)pWriteData)++ = (u8)(SROMC_DATA_ONEVALUE);
#endif
		}
	}
#endif

	/////////////////////////////////
	// Write from DRAM to SRAM memory
	/////////////////////////////////
	pWriteData = pWriteBaseData;
	pAddress = pBankBaseAddress;
	
#if (SROMC_TR_TYPE == SROMC_POLLING)
	for(i=0; i<SROMC_SRAM_SIZE/4; i++)
	{
		*pAddress++ =  *pWriteData++;
	}
#elif (SROMC_TR_TYPE == SROMC_MEMCPY)
	memcpy((void *)pAddress, (void *)pWriteData, SROMC_SRAM_SIZE);
#else
	SROMC_DmaDone = 0;
	DMA_SetCh(DMA_20,&g_oSROMCDmac0);
	DMA_InitCh(HWORD, SOFTWARE, DMA_M2M, SINGLE, &g_oSROMCDmac0);

	DMA_StartCh((u32)pWriteData, (u32)pAddress, SROMC_SRAM_SIZE,&g_oSROMCDmac0);

//	DMACH_Setup(DMA_A, 0, (u32)pWriteData, 0, (u32)pAddress, 0, WORD, SROMC_SRAM_SIZE/4, DEMAND, MEM, MEM, BURST4, &g_oSROMCDmac0);
//	DMACH_Start(&g_oSROMCDmac0);
	while(!SROMC_DmaDone);
#endif

	/////////////////////////////////
	// Read from SRAM memory to DRAM
	/////////////////////////////////
	pReadData = pReadBaseData;
	pAddress = pBankBaseAddress;
	
#if (SROMC_TR_TYPE == SROMC_POLLING)
	for(i=0; i<SROMC_SRAM_SIZE/4; i++)
	{
		*pReadData++ = *pAddress++;
	}
#elif (SROMC_TR_TYPE == SROMC_MEMCPY)
	memcpy((void *)pReadData, (void *)pAddress, SROMC_SRAM_SIZE);
#else
	SROMC_DmaDone = 0;

	DMA_SetCh(DMA_20,&g_oSROMCDmac0);
	DMA_InitCh(WORD, SOFTWARE, DMA_M2M, BURST4, &g_oSROMCDmac0);

	DMA_StartCh((u32)pAddress, (u32)pReadData, SROMC_SRAM_SIZE,&g_oSROMCDmac0);

//	DMACH_Setup(DMA_A, 0, (u32)pAddress, 0, (u32)pReadData, 0, WORD, SROMC_SRAM_SIZE/4, DEMAND, MEM, MEM, BURST4, &g_oSROMCDmac0);
//	DMACH_Start(&g_oSROMCDmac0);
	while(!SROMC_DmaDone);
#endif			

	/////////////////////////////////
	// Compare Data
	/////////////////////////////////
	pReadData = pReadBaseData;
	pWriteData = pWriteBaseData;
	pAddress = pBankBaseAddress;
	bError = FALSE;
	
	for(i=0 ; i<SROMC_SRAM_SIZE/4 ; i++)
	{
		if(pReadData[i] != pWriteData[i])
		{
			UART_Printf("\t [Address: 0x%08x] [Write data : Read data] = [0x%08x  : 0x%08x ]  \n", pAddress, pWriteData[i], pReadData[i]);
			UART_Getc();
			bError = TRUE;
			break;
		}
		pAddress++;
	}
	if(bError == FALSE)
		UART_Printf("Test OK\n");	

	pWriteData = pWriteBaseData;
	for(i=0; i<SROMC_SRAM_SIZE/4; i++)
	{
		*pWriteData++ = 0;
	}

//	free(pWriteBaseData);
//	free(pReadBaseData);
	
	return 0;
}


void SROMC_Test(void)
{
	u32 uTacs, uTcos, uTacc, uTcoh, uTcah, uTacp;
	SROMC_eBANK uBank;
	Data_eWidth eDWidth;
	WAIT_eCTL eWAITCTL;
	Byte_eCTL eByteCTL;
	Page_eMode ePageMode;

	UART_Printf("[SROMC Test]\n");

	UART_Printf("Input the SROMC BANK Number[0~%d] : \n", eBankMAX);
	uBank = (SROMC_eBANK)UART_GetIntNum(); 
	if(uBank > 5)
		uBank = (SROMC_eBANK)0;
	UART_Printf("Input the Data Bus Width : 8-bit(0),   16-bit(1) \n");
	eDWidth = (Data_eWidth)UART_GetIntNum(); 	
	if(eDWidth > 1)
		eDWidth = (Data_eWidth)1;
	UART_Printf("Input the Wait Enable Control : Disable(0),  Enable(1)\n");
	eWAITCTL = (WAIT_eCTL)UART_GetIntNum(); 
	if(eWAITCTL > 1)
		eWAITCTL = (WAIT_eCTL)0;
	UART_Printf("Input the Byte Enable(nBE/nWBE) Setting : Not using(0),  Using(1)\n");
	eByteCTL = (Byte_eCTL)UART_GetIntNum(); 
	if(eByteCTL > 1)
		eByteCTL = (Byte_eCTL)0;
	UART_Printf("Input the Page Mode Setting : Normal(0),  4data(1)\n");
	ePageMode = (Page_eMode)UART_GetIntNum(); 
	if(ePageMode > 1)
		ePageMode = (Page_eMode)0;
	
	SROMC_SetBusWidth( uBank, eDWidth);
	SROMC_SetWaitControl(uBank, eWAITCTL);
	SROMC_SetByteEnable(uBank, eByteCTL);

	uTacs = SROMC_Tacs_MIN;
	uTcos = SROMC_Tcos_MIN;
	uTacc = SROMC_Tacc_MIN;
	uTcoh = SROMC_Tcoh_MIN;
	uTcah = SROMC_Tcah_MIN;
	
	// Tacp parameter test
	for(uTacp = SROMC_Tacp_MIN ; uTacp <= SROMC_Tacp_MAX ; uTacp++)
	{
		SROMC_WriteReadTest(uBank, (Bank_eTiming)uTacs, (Bank_eTiming)uTcos, (Bank_eTiming)uTacc, 
									(Bank_eTiming)uTcoh, (Bank_eTiming)uTcah, (Bank_eTiming)uTacp, ePageMode);
	}
	uTacp = SROMC_Tacp_MIN;

	// Tcah parameter test
	for(uTcah = SROMC_Tcah_MIN ; uTcah <= SROMC_Tcah_MAX ; uTcah++)
	{
		SROMC_WriteReadTest(uBank, (Bank_eTiming)uTacs, (Bank_eTiming)uTcos, (Bank_eTiming)uTacc, 
									(Bank_eTiming)uTcoh, (Bank_eTiming)uTcah, (Bank_eTiming)uTacp, ePageMode);
	}
	uTcah = SROMC_Tcah_MIN;

	// Tcoh parameter test
	for(uTcoh = SROMC_Tcoh_MIN ; uTcoh <= SROMC_Tcoh_MAX ; uTcoh++)
	{
		SROMC_WriteReadTest(uBank, (Bank_eTiming)uTacs, (Bank_eTiming)uTcos, (Bank_eTiming)uTacc, 
									(Bank_eTiming)uTcoh, (Bank_eTiming)uTcah, (Bank_eTiming)uTacp, ePageMode);
	}
	uTcoh = SROMC_Tcoh_MIN;

	// Tacc parameter test
	for(uTacc = SROMC_Tacc_MIN ; uTacc <= SROMC_Tacc_MAX ; uTacc++)
	{
		SROMC_WriteReadTest(uBank, (Bank_eTiming)uTacs, (Bank_eTiming)uTcos, (Bank_eTiming)uTacc, 
									(Bank_eTiming)uTcoh, (Bank_eTiming)uTcah, (Bank_eTiming)uTacp, ePageMode);
	}
	uTacc = SROMC_Tacc_MIN;

	// Tcos parameter test
	for(uTcos = SROMC_Tcos_MIN ; uTcos <= SROMC_Tcos_MAX ; uTcos++)
	{
		SROMC_WriteReadTest(uBank, (Bank_eTiming)uTacs, (Bank_eTiming)uTcos, (Bank_eTiming)uTacc, 
									(Bank_eTiming)uTcoh, (Bank_eTiming)uTcah, (Bank_eTiming)uTacp, ePageMode);
	}
	uTcos = SROMC_Tcos_MIN;

	// Tacs parameter test
	for(uTacs = SROMC_Tacs_MIN ; uTacs <= SROMC_Tacs_MAX ; uTacs++)
	{
		SROMC_WriteReadTest(uBank, (Bank_eTiming)uTacs, (Bank_eTiming)uTcos, (Bank_eTiming)uTacc, 
									(Bank_eTiming)uTcoh, (Bank_eTiming)uTcah, (Bank_eTiming)uTacp, ePageMode);
	}
	uTacs = SROMC_Tacs_MIN;	

	UART_Printf("\n\n");
}


#if 0
void SROMC_AgingTest(void)
{
	u32 i, uNumClock, uTacs, uTcos, uTacc, uTcoh, uTcah, uTacp;
	SROMC_eBANK uBank;
	Data_eWidth eDWidth;
	WAIT_eCTL eWAITCTL;
	Byte_eCTL eByteCTL;
	Page_eMode ePageMode;
						   //{Sync Mode, APLL, MPLL, HCLKx2 divide, HCLK divide}
	u32 aCaseOfClock[][7] = { //Sync Mode
#if(SROMC_DEVICE == SROMC_6410)	
							{eSYNC_MODE, (APLL_eOUT)eAPLL532M, (APLL_eOUT)eAPLL266M, 2, 2},
							{eSYNC_MODE, (APLL_eOUT)eAPLL532M, (APLL_eOUT)eAPLL266M, 4, 2},
#endif	

#if 1
							{eASYNC_MODE, (APLL_eOUT)eAPLL532M, (APLL_eOUT)eAPLL266M, 1, 2},
							{eASYNC_MODE, (APLL_eOUT)eAPLL532M, (APLL_eOUT)eAPLL266M, 2, 2},
							{eASYNC_MODE, (APLL_eOUT)eAPLL667M, (APLL_eOUT)eAPLL266M, 1, 2},
							{eASYNC_MODE, (APLL_eOUT)eAPLL667M, (APLL_eOUT)eAPLL266M, 2, 2},
#endif
							};
						   
	UART_Printf("[SROMC Test]\n");

	UART_Printf("Input the SROMC BANK Number[0~%d] : \n", eBankMAX);
	uBank = (SROMC_eBANK)UART_GetIntNum(); 
	if(uBank > 5)
		uBank = (SROMC_eBANK)0;
	UART_Printf("Input the Data Bus Width : 8-bit(0),   16-bit(1) \n");
	eDWidth = (Data_eWidth)UART_GetIntNum(); 	
	if(eDWidth > 1)
		eDWidth = (Data_eWidth)1;
	UART_Printf("Input the Wait Enable Control : Disable(0),  Enable(1)\n");
	eWAITCTL = (WAIT_eCTL)UART_GetIntNum(); 
	if(eWAITCTL > 1)
		eWAITCTL = (WAIT_eCTL)0;
	UART_Printf("Input the Byte Enable(nBE/nWBE) Setting : Not using(0),  Using(1)\n");
	eByteCTL = (Byte_eCTL)UART_GetIntNum(); 
	if(eByteCTL > 1)
		eByteCTL = (Byte_eCTL)0;
	UART_Printf("Input the Page Mode Setting : Normal(0),  4data(1)\n");
	ePageMode = (Page_eMode)UART_GetIntNum(); 
	if(ePageMode > 1)
		ePageMode = (Page_eMode)0;
	
	SROMC_SetBusWidth( uBank, eDWidth);
	SROMC_SetWaitControl(uBank, eWAITCTL);
	SROMC_SetByteEnable(uBank, eByteCTL);

	uTacs = SROMC_Tacs_MIN;
	uTcos = SROMC_Tcos_MIN;
	uTacc = SROMC_Tacc_MIN;
	uTcoh = SROMC_Tcoh_MIN;
	uTcah = SROMC_Tcah_MIN;
	uTacp = SROMC_Tacp_MIN;

	uNumClock = sizeof(aCaseOfClock)/sizeof(aCaseOfClock[0]);

	while(!UART_GetKey())
	{
	for(i=0 ; i<uNumClock ; i++)
	{
		if(aCaseOfClock[i][0] == eSYNC_MODE)
		{
			SYSC_ChangeMode(eSYNC_MODE);
			SYSC_ChangeSYSCLK_1((APLL_eOUT)aCaseOfClock[i][1], (APLL_eOUT)aCaseOfClock[i][2], 0, 1, 3);
			SYSC_SetDIV0(0, 1, aCaseOfClock[i][4]-1, aCaseOfClock[i][3]-1,  3, 0, 1,0, 1, 0);

			SYSC_GetClkInform();
			OpenConsole();

			UART_Printf("\n\n");
			UART_Printf("====================================================================\n");
			UART_Printf("Sync Mode : Synchronous\n");
			UART_Printf("ARMCLK : HCLK : PCLK = %d : %d : %d MHz (MPLL : %d MHz)\n", 
								g_ARMCLK/1000000, g_HCLK/1000000, g_PCLK/1000000, g_MPLL/1000000 );
		}
		else		// Async Mode
		{
			SYSC_ChangeMode(eASYNC_MODE);
			SYSC_ChangeSYSCLK_1((APLL_eOUT)aCaseOfClock[i][1], (APLL_eOUT)aCaseOfClock[i][2], 0, 1, 3);
			SYSC_SetDIV0(0, 1, aCaseOfClock[i][4]-1, aCaseOfClock[i][3]-1,  3, 0, 1,0, 1, 0);

			SYSC_GetClkInform();
			OpenConsole();

			UART_Printf("\n\n");
			UART_Printf("====================================================================\n");
			UART_Printf("Sync Mode : Asynchronous\n");
			UART_Printf("ARMCLK : HCLK : PCLK = %d : %d : %d MHz (MPLL : %d MHz)\n", 
								g_ARMCLK/1000000, g_HCLK/1000000, g_PCLK/1000000, g_MPLL/1000000 );		
		}
		UART_Printf("\n");

		// Tacp parameter test
		for(uTacp = SROMC_Tacp_MIN ; uTacp <= SROMC_Tacp_MAX ; uTacp++)
		{
			SROMC_WriteReadTest(uBank, (Bank_eTiming)uTacs, (Bank_eTiming)uTcos, (Bank_eTiming)uTacc, 
										(Bank_eTiming)uTcoh, (Bank_eTiming)uTcah, (Bank_eTiming)uTacp, ePageMode);
		}
		uTacp = SROMC_Tacp_MIN;

		// Tcah parameter test
		for(uTcah = SROMC_Tcah_MIN ; uTcah <= SROMC_Tcah_MAX ; uTcah++)
		{
			SROMC_WriteReadTest(uBank, (Bank_eTiming)uTacs, (Bank_eTiming)uTcos, (Bank_eTiming)uTacc, 
										(Bank_eTiming)uTcoh, (Bank_eTiming)uTcah, (Bank_eTiming)uTacp, ePageMode);
		}
		uTcah = SROMC_Tcah_MIN;

		// Tcoh parameter test
		for(uTcoh = SROMC_Tcoh_MIN ; uTcoh <= SROMC_Tcoh_MAX ; uTcoh++)
		{
			SROMC_WriteReadTest(uBank, (Bank_eTiming)uTacs, (Bank_eTiming)uTcos, (Bank_eTiming)uTacc, 
										(Bank_eTiming)uTcoh, (Bank_eTiming)uTcah, (Bank_eTiming)uTacp, ePageMode);
		}
		uTcoh = SROMC_Tcoh_MIN;

		// Tacc parameter test
		for(uTacc = SROMC_Tacc_MIN ; uTacc <= SROMC_Tacc_MAX ; uTacc++)
		{
			SROMC_WriteReadTest(uBank, (Bank_eTiming)uTacs, (Bank_eTiming)uTcos, (Bank_eTiming)uTacc, 
										(Bank_eTiming)uTcoh, (Bank_eTiming)uTcah, (Bank_eTiming)uTacp, ePageMode);
		}
		uTacc = SROMC_Tacc_MIN;

		// Tcos parameter test
		for(uTcos = SROMC_Tcos_MIN ; uTcos <= SROMC_Tcos_MAX ; uTcos++)
		{
			SROMC_WriteReadTest(uBank, (Bank_eTiming)uTacs, (Bank_eTiming)uTcos, (Bank_eTiming)uTacc, 
										(Bank_eTiming)uTcoh, (Bank_eTiming)uTcah, (Bank_eTiming)uTacp, ePageMode);
		}
		uTcos = SROMC_Tcos_MIN;

		// Tacs parameter test
		for(uTacs = SROMC_Tacs_MIN ; uTacs <= SROMC_Tacs_MAX ; uTacs++)
		{
			SROMC_WriteReadTest(uBank, (Bank_eTiming)uTacs, (Bank_eTiming)uTcos, (Bank_eTiming)uTacc, 
										(Bank_eTiming)uTcoh, (Bank_eTiming)uTcah, (Bank_eTiming)uTacp, ePageMode);
		}
		uTacs = SROMC_Tacs_MIN;	
		
		UART_Printf("====================================================================\n");
	}
	}
	
	UART_Printf("\n\n");

	SYSC_ChangeMode(eSYNC_MODE);
	SYSC_ChangeSYSCLK_1(eAPLL532M, eAPLL266M, 0, 1, 3);
	SYSC_SetDIV0(0, 1, 1, 1,  3, 1, 1, 1, 1, 1);	
}
#endif

u32 SROMC_ByteWriteReadTest(SROMC_eBANK uBank, Bank_eTiming eTacs, Bank_eTiming eTcos,Bank_eTiming eTacc, 
							 					Bank_eTiming eTcoh, Bank_eTiming eTcah, Bank_eTiming eTacp, Page_eMode ePageMode )
{
	u32 i,time;
	u8 bError = FALSE;
	u8 *pWriteBaseData, *pReadBaseData, *pWriteData, *pReadData;
	u8 *pBankBaseAddress, *pAddress;

//	pWriteBaseData = (u8 *)malloc(SROMC_SRAM_SIZE);
	pWriteBaseData = (u8 *)SROMC_WRITE_BASE;	
	if(pWriteBaseData == 0)
	{
		UART_Printf("Memory Allocation Error...\n");
		return 0;
	}
	pWriteData = pWriteBaseData;
	
//	pReadBaseData = (u8 *)malloc(SROMC_SRAM_SIZE);	
	pReadBaseData = (u8 *)SROMC_READ_BASE;		
	if(pReadBaseData == 0)
	{
//		free(pWriteBaseData);
		UART_Printf("Memory Allocation Error...\n");
		return 0;
	}
	pReadData = pReadBaseData;

	pBankBaseAddress = (u8 *)((uBank * 0x08000000)+0x80000000);
	pAddress = pBankBaseAddress;




#if (SROMC_TR_TYPE == SROMC_DMA)
#if 1	//DMA0 controller


	INTC_Init();
	INTC_SetVectAddr(NUM_MDMA,  SROMC_DmaISR);
	INTC_Enable(NUM_MDMA);
#elif 0	//DMA1 controller
	DMAC_InitCh(DMA1, DMA_ALL, &g_oSROMCDmac0);
	INTC_SetVectAddr(NUM_DMA1,  SROMC_DmaISR);
	INTC_Enable(NUM_DMA1);
#elif 0	//SDMA0 controller
	DMAC_InitCh(SDMA0, DMA_ALL, &g_oSROMCDmac0);
	INTC_SetVectAddr(NUM_SDMA0,  SROMC_DmaISR);
	INTC_Enable(NUM_SDMA0);
#else	//SDMA1 controller
	DMAC_InitCh(SDMA1, DMA_ALL, &g_oSROMCDmac0);
	INTC_SetVectAddr(NUM_SDMA1,  SROMC_DmaISR);
	INTC_Enable(NUM_SDMA1);	
#endif	
#endif	

	UART_Printf("Tacs(%d), Tcos(%d), Tacc(%d), Tcoh(%d), Tcah(%d), Tacp(%d)\n", eTacs, eTcos, eTacc, eTcoh, eTcah, eTacp);
	SROMC_SetTiming(uBank, eTacs, eTcos, eTacc, 	eTcoh, eTcah, eTacp, ePageMode);
	DelayfrTimer(milli, 1);
	
	pWriteData = pWriteBaseData;
	
	srand(eTacs + eTcos + eTacc + eTcoh + eTcah + eTacp);
#if 1	
	for(i=0; i<SROMC_SRAM_SIZE; i++)
	{
#if(SROMC_DATA_PATTERN == SROMC_DATA_RANDOM)
		*pWriteData++ = (u8)rand();
#else	// ONDT_DATA_PATTERN == ONDT_DATA_ONEVALUE
		*pWriteData++ = (u8)(SROMC_DATA_ONEVALUE);
#endif
	}
#else	// rb1004... for 8-bit bus width test(external bus width : 16bit at SMDK)
	{	
		u8 cTemp;
		
		for(i=0; i<SROMC_SRAM_SIZE/2; i++)
		{
#if(SROMC_DATA_PATTERN == SROMC_DATA_RANDOM)
			cTemp = (u8)rand();
			*pWriteData++ = cTemp;
			*pWriteData++ = cTemp;
#else	// ONDT_DATA_PATTERN == ONDT_DATA_ONEVALUE
			*pWriteData++ = (u8)(SROMC_DATA_ONEVALUE);
			*pWriteData++ = (u8)(SROMC_DATA_ONEVALUE);
#endif
		}
	}
#endif

	/////////////////////////////////
	// Write from DRAM to SRAM memory
	/////////////////////////////////
	pWriteData = pWriteBaseData;
	pAddress = pBankBaseAddress;
	
#if (SROMC_TR_TYPE == SROMC_POLLING)
	for(i=0; i<SROMC_SRAM_SIZE; i++)
	{
		*pAddress++ =  *pWriteData++;
	}
#elif (SROMC_TR_TYPE == SROMC_MEMCPY)
	UART_Printf("Memcpy() function is not byte access\n");
	free(pWriteBaseData);
	free(pReadBaseData);
	return 0;
#else
	SROMC_DmaDone = 0;
	DMA_SetCh(DMA_20,&g_oSROMCDmac0);
	DMA_InitCh(HWORD, SOFTWARE, DMA_M2M, SINGLE, &g_oSROMCDmac0);

	StartTimer(2);
//	DMACH_Setup(DMA_A, 0, (u32)pWriteData, 0, (u32)pAddress, 0, BYTE, SROMC_SRAM_SIZE, DEMAND, MEM, MEM, BURST4, &g_oSROMCDmac0);
	DMA_StartCh((u32)pWriteData, (u32)pAddress, SROMC_SRAM_SIZE,&g_oSROMCDmac0);
//	DMACH_Start(&g_oSROMCDmac0);
	while(!SROMC_DmaDone);
	time = StopTimer(2);
	UART_Printf("Time: %dus , Data rate= %fbyte/sec\n",time,(float)(SROMC_SRAM_SIZE)/time*1000000);
#endif

	/////////////////////////////////
	// Read from SRAM memory to DRAM
	/////////////////////////////////
	pReadData = pReadBaseData;
	pAddress = pBankBaseAddress;
	
#if (SROMC_TR_TYPE == SROMC_POLLING)
	for(i=0; i<SROMC_SRAM_SIZE; i++)
	{
		*pReadData++ = *pAddress++;
	}
#else
	SROMC_DmaDone = 0;
	DMA_SetCh(DMA_20,&g_oSROMCDmac0);
	DMA_InitCh(BYTE, SOFTWARE, DMA_M2M, SINGLE, &g_oSROMCDmac0);


	StartTimer(2);	
	DMA_StartCh((u32)pAddress, (u32)pReadData, SROMC_SRAM_SIZE,&g_oSROMCDmac0);

//	DMACH_Setup(DMA_A, 0, (u32)pAddress, 0, (u32)pReadData, 0, BYTE, SROMC_SRAM_SIZE, DEMAND, MEM, MEM, BURST4, &g_oSROMCDmac0);
//	DMACH_Start(&g_oSROMCDmac0);
	while(!SROMC_DmaDone);
	time = StopTimer(2);
	UART_Printf("Time: %dus , Data rate= %fbyte/sec\n",time,(float)(SROMC_SRAM_SIZE)/time*1000000);	
#endif			

	/////////////////////////////////
	// Compare Data
	/////////////////////////////////
	pReadData = pReadBaseData;
	pWriteData = pWriteBaseData;
	pAddress = pBankBaseAddress;
	bError = FALSE;
	
	for(i=0 ; i<SROMC_SRAM_SIZE ; i++)
	{
		if(pReadData[i] != pWriteData[i])
		{
			UART_Printf("\t [Address: 0x%08x] [Write data : Read data] = [0x%02x  : 0x%02x ]  \n", pAddress, pWriteData[i], pReadData[i]);
			UART_Getc();
			bError = TRUE;
			break;
		}
		pAddress++;
	}
	if(bError == FALSE)
		UART_Printf("Test OK\n");	

	pWriteData = pWriteBaseData;
	for(i=0; i<SROMC_SRAM_SIZE; i++)
	{
		*pWriteData++ = 0;
	}

//	free(pWriteBaseData);
//	free(pReadBaseData);
	INTC_ClearVectAddr();
	INTC_Disable(NUM_MDMA);
	return 0;
}



#define DM9000Debug
#ifdef DM9000Debug
#define DM9000DEBUG(x) Disp x
#define DM9000_DBG(fmt,args...) UART_Printf((fmt), (##args))
#else
#define DM9000DEBUG(x) 0
#endif

//#define DM9000_BASE 0x80000000

#define DM9000_ID		0x90000A46

#define DM9000_VIDL		0x28
#define DM9000_VIDH		0x29
#define DM9000_PIDL		0x2A
#define DM9000_PIDH		0x2B
#define DM9000_SRAM_CNT	12288


#define 		CONFIG_DM9000_BASE	0xA8000000
#define	 	DM9000_IO 		CONFIG_DM9000_BASE 
#define		DM9000_DATA		(CONFIG_DM9000_BASE + 1)
#define	 	DM9000_IO16 		CONFIG_DM9000_BASE 
#define		DM9000_DATA16		(CONFIG_DM9000_BASE + 2)

#define DM9000_outb(d,r) ( *(volatile u8 *)r = d )
#define DM9000_outw(d,r) ( *(volatile u16 *)r = d )
#define DM9000_outl(d,r) ( *(volatile u32 *)r = d )
#define DM9000_inb(r) (*(volatile u8 *)r)
#define DM9000_inw(r) (*(volatile u16 *)r)
#define DM9000_inl(r) (*(volatile u32 *)r)


static volatile u8* g_DM9000_BASE ;
static volatile u16* g_DM9000_BASE16 ;

/*
   Read a byte from I/O port
*/
static u8
DM9000_ior(int reg)
{
	DM9000_outb(reg, DM9000_IO);
	//DelayfrTimer(micro, 1);
	return DM9000_inb(DM9000_DATA);
}

/*
   Write a byte to I/O port
*/
static void
DM9000_iow(int reg, u8 value)
{
	DM9000_outb(reg, DM9000_IO);
	DM9000_outb(value, DM9000_DATA);
}

/*
   Read a word from I/O port
*/
static u16
DM9000_ior_16(int reg)
{
	DM9000_outw(reg, DM9000_IO16);
	//DelayfrTimer(micro, 1);
	return DM9000_inw(DM9000_DATA16);
}

/*
   Write a word to I/O port
*/
static void
DM9000_iow_16(int reg, u16 value)
{
	DM9000_outw(reg, DM9000_IO16);
	DM9000_outw(value, DM9000_DATA16);
}
static void dm9000_outblk_8bit(volatile void *data_ptr, int count)
{
	int i;
	for (i = 0; i < count; i++)
		DM9000_outb((((u8 *) data_ptr)[i] & 0xff), DM9000_DATA);
}

static void dm9000_outblk_16bit(volatile void *data_ptr, int count)
{
	int i;
	u32 tmplen = (count + 1) / 2;

	for (i = 0; i < tmplen; i++)
		DM9000_outw(((u16 *) data_ptr)[i], DM9000_DATA);
}
static void dm9000_outblk_32bit(volatile void *data_ptr, int count)
{
	int i;
	u32 tmplen = (count + 3) / 4;

	for (i = 0; i < tmplen; i++)
		DM9000_outl(((u32 *) data_ptr)[i], DM9000_DATA);
}

static void dm9000_inblk_8bit(void *data_ptr, int count)
{
	int i;
	for (i = 0; i < count; i++)
		((u8 *) data_ptr)[i] = DM9000_inb(DM9000_DATA);
}

static void dm9000_inblk_16bit(void *data_ptr, int count)
{
	int i;
	u32 tmplen = (count + 1) / 2;

	for (i = 0; i < tmplen; i++)
		((u16 *) data_ptr)[i] = DM9000_inw(DM9000_DATA);
}
static void dm9000_inblk_32bit(void *data_ptr, int count)
{
	int i;
	u32 tmplen = (count + 3) / 4;

	for (i = 0; i < tmplen; i++)
		((u32 *) data_ptr)[i] = DM9000_inl(DM9000_DATA);
}

static void dm9000_rx_status_32bit(u16 *RxStatus, u16 *RxLen)
{
	u32 tmpdata;

	DM9000_outb(DM9000_MRCMD, DM9000_IO);

	tmpdata = DM9000_inl(DM9000_DATA);
	*RxStatus = tmpdata;
	*RxLen = tmpdata >> 16;
}

static void dm9000_rx_status_16bit(u16 *RxStatus, u16 *RxLen)
{
	DM9000_outb(DM9000_MRCMD, DM9000_IO);

	*RxStatus = DM9000_inw(DM9000_DATA);
	*RxLen = DM9000_inw(DM9000_DATA);
}

static void dm9000_rx_status_8bit(u16 *RxStatus, u16 *RxLen)
{
	DM9000_outb(DM9000_MRCMD, DM9000_IO);

	*RxStatus = DM9000_inb(DM9000_DATA) + (DM9000_inb(DM9000_DATA) << 8);
	*RxLen = DM9000_inb(DM9000_DATA) + (DM9000_inb(DM9000_DATA) << 8);
}

static u8 ReadReg8(u8 addr)
{
//	*((volatile u8*)g_DM9000_BASE) = addr;
//	Disp("addr = 0x%x\n",*((volatile u8*)DM9000_BASE));
//	return *((volatile u8 *)(DM9000_BASE+1));

	*g_DM9000_BASE = addr;
//	Disp("addr = 0x%x\n",*g_DM9000_BASE);
	return *(g_DM9000_BASE+1);

	
}

static u8 WriteReg8(u8 addr,u8 data)
{
	//*((volatile u8*)DM9000_BASE) = addr;
	//	return *((volatile u8 *)(DM9000_BASE+1));
	*g_DM9000_BASE = addr;
	*(g_DM9000_BASE+1) = data;
}

static u16 ReadReg16(u16 addr)
{
//	*((volatile u8*)g_DM9000_BASE) = addr;
//	Disp("addr = 0x%x\n",*((volatile u8*)DM9000_BASE));
//	return *((volatile u8 *)(DM9000_BASE+1));

	*g_DM9000_BASE16 = addr;
//	Disp("addr = 0x%x\n",*g_DM9000_BASE);
	return *(g_DM9000_BASE16+1);

	
}

static u16 WriteReg16(u16 addr,u16 data)
{
	//*((volatile u8*)DM9000_BASE) = addr;
	//	return *((volatile u8 *)(DM9000_BASE+1));
	*g_DM9000_BASE16 = addr;
	*(g_DM9000_BASE16+1) = data;
}
/* General Purpose dm9000 reset routine */
static void
dm9000_reset(void)
{
//	UART_Printf("resetting DM9000\n");

	/* Reset DM9000,
	   see DM9000 Application Notes V1.22 Jun 11, 2004 page 29 */

	/* DEBUG: Make all GPIO pins outputs */
	DM9000_iow(DM9000_GPCR, 0x0F);
	/* Step 1: Power internal PHY by writing 0 to GPIO0 pin */
	DM9000_iow(DM9000_GPR, 0);
	/* Step 2: Software reset */
	DM9000_iow(DM9000_NCR, 3);

	do {
		UART_Printf("resetting the DM9000, 1st reset\n");
		DelayfrTimer(micro, 20); /* Wait at least 20 us */
	} while (DM9000_ior(DM9000_NCR) & 1);

	DM9000_iow(DM9000_NCR, 0);
	DM9000_iow(DM9000_NCR, 3); /* Issue a second reset */

	do {
//		UART_Printf("resetting the DM9000, 2nd reset\n");
		DelayfrTimer(micro, 20); /* Wait at least 20 us */
	} while (DM9000_ior(DM9000_NCR) & 1);

		DelayfrTimer(milli, 1);

	/* Check whether the ethernet controller is present */
	if ((DM9000_ior(DM9000_PIDL) != 0x0) ||
	    (DM9000_ior(DM9000_PIDH) != 0x90))
		printf("ERROR: resetting DM9000 -> not responding\n");
}
/* General Purpose dm9000 reset routine 16bit bus */
static void
dm9000_reset_16(void)
{
//	UART_Printf("resetting DM9000\n");

	/* Reset DM9000,
	   see DM9000 Application Notes V1.22 Jun 11, 2004 page 29 */

	/* DEBUG: Make all GPIO pins outputs */
	DM9000_iow_16(DM9000_GPCR, 0x0F);
	/* Step 1: Power internal PHY by writing 0 to GPIO0 pin */
	DM9000_iow_16(DM9000_GPR, 0);
	/* Step 2: Software reset */
	DM9000_iow_16(DM9000_NCR, 3);

	do {
		UART_Printf("resetting the DM9000, 1st reset\n");
		DelayfrTimer(micro, 20); /* Wait at least 20 us */
	} while (DM9000_ior_16(DM9000_NCR) & 1);

	DM9000_iow_16(DM9000_NCR, 0);
	DM9000_iow_16(DM9000_NCR, 3); /* Issue a second reset */

	do {
//		UART_Printf("resetting the DM9000, 2nd reset\n");
		DelayfrTimer(micro, 20); /* Wait at least 20 us */
	} while (DM9000_ior_16(DM9000_NCR) & 1);

		DelayfrTimer(milli, 1);

	/* Check whether the ethernet controller is present */
	if ((DM9000_ior_16(DM9000_PIDL) != 0x0) ||
	    (DM9000_ior_16(DM9000_PIDH) != 0x90))
		printf("ERROR: resetting DM9000 -> not responding\n");
}
/*
  DM9000 sram write
*/
void
dm9000_Sram_Write(u16 addr, u32 byte_count, u8* src_buf)
{
	u32 i;

	DM9000_iow(DM9000_MWRH,((addr&0xff00)>>8));
	DM9000_iow(DM9000_MWRL,(addr&0xff) );

	DM9000_outb(DM9000_MWCMD, DM9000_IO);
#if 1
	for(i=0;i<byte_count;i++)
	{
		//DM9000_iow(DM9000_MWCMD,*src_buf++);
	
		DM9000_outb(*src_buf++, DM9000_DATA);

	}
#endif
#if  0
	INTC_SetVectAddr(NUM_PDMA0,  DM9000_DmaISR);
	INTC_Enable(NUM_PDMA0);


	SROMC_DmaDone = 0;
	DMA_SetCh(DMA_00,&g_oSROMCDmac0);
	DMA_InitCh(BYTE, SOFTWARE, DMA_M2P, SINGLE, &g_oSROMCDmac0);

	DMA_StartCh((u32)src_buf, DM9000_DATA, byte_count,&g_oSROMCDmac0);

	while(!SROMC_DmaDone);
	
	INTC_Disable(NUM_PDMA0);
#endif
}

/*
  DM9000 sram read
*/
void
dm9000_Sram_Read(u16 addr, u32 byte_count, u8* dst_buf)
{
	u32 i;

	DM9000_iow(DM9000_MRRH,((addr&0xff00)>>8));
	DM9000_iow(DM9000_MRRL,(addr&0xff) );

	DM9000_outb(DM9000_MRCMD, DM9000_IO);
#if 1	
	for(i=0;i<byte_count;i++)
	{
	//	*dst_buf++ = DM9000_ior(DM9000_MRCMD);
	*dst_buf++ =DM9000_inb(DM9000_DATA);	

	}
#endif
#if 0
	INTC_SetVectAddr(NUM_PDMA0,  DM9000_DmaISR);
	INTC_Enable(NUM_PDMA0);


	SROMC_DmaDone = 0;
	DMA_SetCh(DMA_00,&g_oSROMCDmac0);
	DMA_InitCh(BYTE, SOFTWARE, DMA_P2M, SINGLE, &g_oSROMCDmac0);

	DMA_StartCh(DM9000_DATA, (u32)dst_buf, byte_count,&g_oSROMCDmac0);

	while(!SROMC_DmaDone);
	
	INTC_Disable(NUM_PDMA0);
#endif	
	
}

/*
  DM9000 sram write 16
*/
void
dm9000_Sram_Write16(u16 addr, u32 byte_count, u16* src_buf)
{
	u32 i;

	DM9000_iow_16(DM9000_MWRH,((addr&0xff00)>>8));
	DM9000_iow_16(DM9000_MWRL,(addr&0xff) );
	DM9000_iow_16(DM9000_MWRL,(addr) );

	DM9000_outw(DM9000_MWCMD, DM9000_IO16);
#if 1
	for(i=0;i<byte_count;i++)
	{
		//DM9000_iow(DM9000_MWCMD,*src_buf++);
	
		DM9000_outw(*src_buf++, DM9000_DATA16);		//  16bit case --> alignment error ????

	}
#endif
#if  0
	INTC_SetVectAddr(NUM_PDMA0,  DM9000_DmaISR);
	INTC_Enable(NUM_PDMA0);


	SROMC_DmaDone = 0;
	DMA_SetCh(DMA_00,&g_oSROMCDmac0);
	DMA_InitCh(BYTE, SOFTWARE, DMA_M2P, SINGLE, &g_oSROMCDmac0);

	DMA_StartCh((u32)src_buf, DM9000_DATA, byte_count,&g_oSROMCDmac0);

	while(!SROMC_DmaDone);
	
	INTC_Disable(NUM_PDMA0);
#endif
}

/*
  DM9000 sram read 16
*/
void
dm9000_Sram_Read16(u16 addr, u32 byte_count, u16* dst_buf)
{
	u32 i;

	DM9000_iow_16(DM9000_MRRH,((addr&0xff00)>>8));
	DM9000_iow_16(DM9000_MRRL,(addr&0xff) );
	DM9000_iow_16(DM9000_MRRL,(addr) );
	

	DM9000_outw(DM9000_MRCMD, DM9000_IO16);
#if 1	
	for(i=0;i<byte_count;i++)
	{
	//	*dst_buf++ = DM9000_ior(DM9000_MRCMD);
	*dst_buf++ =DM9000_inw(DM9000_DATA16);	

	}
#endif
#if 0
	INTC_SetVectAddr(NUM_PDMA0,  DM9000_DmaISR);
	INTC_Enable(NUM_PDMA0);


	SROMC_DmaDone = 0;
	DMA_SetCh(DMA_00,&g_oSROMCDmac0);
	DMA_InitCh(BYTE, SOFTWARE, DMA_P2M, SINGLE, &g_oSROMCDmac0);

	DMA_StartCh(DM9000_DATA, (u32)dst_buf, byte_count,&g_oSROMCDmac0);

	while(!SROMC_DmaDone);
	
	INTC_Disable(NUM_PDMA0);
#endif	
	
}

/*
  Search DM9000 board, allocate space and register it
*/
int
dm9000_probe(void)
{
	u32 id_val;
	id_val = DM9000_ior(DM9000_VIDL);
	id_val |= DM9000_ior(DM9000_VIDH) << 8;
	id_val |= DM9000_ior(DM9000_PIDL) << 16;
	id_val |= DM9000_ior(DM9000_PIDH) << 24;
	if (id_val == DM9000_ID) {
		printf("dm9000 i/o: 0x%x, id: 0x%x \n", CONFIG_DM9000_BASE,
		       id_val);
		return 0;
	} 
	else {
		printf("dm9000 not found at 0x%08x id: 0x%08x\n",
		       CONFIG_DM9000_BASE, id_val);
		return -1;
	}
}
/*
  Search DM9000 board, allocate space and register it
*/
int
dm9000_probe_16(void)
{
	u32 id_val;
	id_val = DM9000_ior_16(DM9000_VIDL);
	id_val |= DM9000_ior_16(DM9000_VIDH) << 8;
	id_val |= DM9000_ior_16(DM9000_PIDL) << 16;
	id_val |= DM9000_ior_16(DM9000_PIDH) << 24;
	if (id_val == DM9000_ID) {
		printf("dm9000 i/o: 0x%x, id: 0x%x \n", CONFIG_DM9000_BASE,
		       id_val);
		return 0;
	} 
	else {
		printf("dm9000 not found at 0x%08x id: 0x%08x\n",
		       CONFIG_DM9000_BASE, id_val);
		return -1;
	}
}


/*
   Read a word from phyxcer
*/
static u16
phy_read(int reg)
{
	u16 val;

	/* Fill the phyxcer register into REG_0C */
	DM9000_iow(DM9000_EPAR, DM9000_PHY | reg);
	DM9000_iow(DM9000_EPCR, 0xc);	/* Issue phyxcer read command */
	DelayfrTimer(milli, 1);			/* Wait read complete */
	DM9000_iow(DM9000_EPCR, 0x0);	/* Clear phyxcer read command */
	val = (DM9000_ior(DM9000_EPDRH) << 8) | DM9000_ior(DM9000_EPDRL);

	printf("val : 0x%x : 0x%x\n",val,(val & 0x20));

	/* The read data keeps on REG_0D & REG_0E */
	DM9000_DBG("phy_read(0x%x): 0x%x\n", reg, val);
	return val;
}

/*
   Write a word to phyxcer
*/
static void
phy_write(int reg, u16 value)
{

	/* Fill the phyxcer register into REG_0C */
	DM9000_iow(DM9000_EPAR, DM9000_PHY | reg);

	/* Fill the written data into REG_0D & REG_0E */
	DM9000_iow(DM9000_EPDRL, (value & 0xff));
	DM9000_iow(DM9000_EPDRH, ((value >> 8) & 0xff));
	DM9000_iow(DM9000_EPCR, 0xa);	/* Issue phyxcer write command */
	DelayfrTimer(milli, 1);;			/* Wait write complete */
	DM9000_iow(DM9000_EPCR, 0x0);	/* Clear phyxcer write command */
	DM9000_DBG("phy_write(reg:0x%x, value:0x%x)\n", reg, value);
}
void DM9000_WRITE(void)
{
	u32 addr, data;

	UART_Printf("Reg Addr to write: \n");
	addr = UART_GetIntNum();
	UART_Printf("Value : \n");
	data = UART_GetIntNum();
	DM9000_iow(addr,data);


}

void DM9000_READ(void)
{
	u32 addr, data;

	UART_Printf("Reg Addr to read: \n");
	addr = UART_GetIntNum();

	UART_Printf("Value : 0x%x \n",DM9000_ior(addr));

}

void DM9000_16bit_Test(void)
{
	u32 uTacs, uTcos, uTacc, uTcoh, uTcah, uTacp;
	u32* r_mp0_4con;
	SROMC_eBANK uBank;
	Data_eWidth eDWidth;
	WAIT_eCTL eWAITCTL;
	Byte_eCTL eByteCTL;
	Page_eMode ePageMode;
	Addr_eMode eAddrMode;
	
	
	u16 IDlow;
	u16 IDhigh;
	u16 ID2low;
	u16 ID2high;
	u16 io_mode;

	u16 phy_reg3;

	u32 ID;


	u32 i,t;
	u8 dm_rdata,dm_wdata;
	
	volatile u8 *pBank4BaseAddress,*pBank5BaseAddress, *index4_Address, *data4_Address, *index5_Address, *data5_Address;
	volatile u8 *pWriteBaseData,*pReadBaseData;
	volatile u16 *pWriteBaseData16,*pReadBaseData16;
	u8 *pWriteData,*pReadData;
	u16 *pWriteData16,*pReadData16;




	UART_Printf("[DM9000 16bit Access]\n");

	uBank = 5; 
	if(uBank > 5)
		uBank = (SROMC_eBANK)0;

	UART_Printf("BANK 5 is used. \n", uBank);

//	UART_Printf("Input the Data Bus Width : 8-bit(0),   16-bit(1) \n");
//	eDWidth = (Data_eWidth)UART_GetIntNum(); 	
	eDWidth = e16bit; 	
	if(eDWidth > 1)
		eDWidth = (Data_eWidth)1;
//	UART_Printf("Input the Wait Enable Control : Disable(0),  Enable(1)\n");
//	eWAITCTL = (WAIT_eCTL)UART_GetIntNum(); 
	eWAITCTL = eDis_WAIT; 
	if(eWAITCTL > 1)
		eWAITCTL = (WAIT_eCTL)0;
//	UART_Printf("Input the Byte Enable(nBE/nWBE) Setting : Not using(0),  Using(1)\n");
//	eByteCTL = (Byte_eCTL)UART_GetIntNum(); 
	eByteCTL = eDis_CTL; 
	if(eByteCTL > 1)
		eByteCTL = (Byte_eCTL)0;
//	UART_Printf("Input the Page Mode Setting : Normal(0),  4data(1)\n");
//	ePageMode = (Page_eMode)UART_GetIntNum(); 
	ePageMode = eNor_Mode; 
	if(ePageMode > 1)
		ePageMode = (Page_eMode)0;

	eAddrMode = eHalfword_Mode;
	SROMC_SetAddrMode(uBank,eAddrMode);
	
	SROMC_SetBusWidth( uBank, eDWidth);
	SROMC_SetWaitControl(uBank, eWAITCTL);
	SROMC_SetByteEnable(uBank, eByteCTL);
	
//	SROMC_SetBusWidth( 4, eDWidth);
//	SROMC_SetWaitControl(4, eWAITCTL);
//	SROMC_SetByteEnable(4, eByteCTL);
	
	uTacs = SROMC_Tacs_MIN;
	uTcos = SROMC_Tcos_MIN;
	uTacc = SROMC_Tacc_MIN;
	uTcoh = SROMC_Tcoh_MIN;
	uTcah = SROMC_Tcah_MIN;
	uTacp = SROMC_Tacp_MIN;

	uTacs = 8;
	uTcos = 3;
	uTacc = 6;
	uTcoh = 2;
	uTcah = 8;
	uTacp = 2;

#if 0
	UART_Printf("Input the tacs(8)\n");
	uTacs= UART_GetIntNum(); 

	UART_Printf("Input the tcos(3)\n");
	uTcos= UART_GetIntNum(); 

	UART_Printf("Input the tacc(6)\n");
	uTacc= UART_GetIntNum(); 

	UART_Printf("Input the tcoh(2)\n");
	uTcoh= UART_GetIntNum(); 

	UART_Printf("Input the tcah(8)\n");
	uTcah= UART_GetIntNum(); 

	UART_Printf("Input the tacp(2)\n");
	uTacp= UART_GetIntNum(); 
#endif




	r_mp0_4con = (u32*)0xE02002E0;
	*r_mp0_4con = 0x22222222;  //      MP0_1CON
	
	r_mp0_4con = (u32*)0xE0200300;
	*r_mp0_4con = 0x22222222;  //      MP0_2CON
	
	r_mp0_4con = (u32*)0xE0200340;
	*r_mp0_4con = 0x22222222;  //      MP0_4CON

	r_mp0_4con = (u32*)0xE0200380;
	*r_mp0_4con = 0x22222222;  //      MP0_6CON
	
	r_mp0_4con = (u32*)0xE02003A0;
	*r_mp0_4con = 0x22222222;  //      MP0_6CON
	


	 	GPIO_SetDSAll(eGPIO_MP0_1,0x0000ffff);
	 	GPIO_SetDSAll(eGPIO_MP0_2,0x0000ffff);
	 	GPIO_SetDSAll(eGPIO_MP0_3,0x0000ffff);
	 	GPIO_SetDSAll(eGPIO_MP0_4,0x0000ffff);
		GPIO_SetDSAll(eGPIO_MP0_5,0x0000ffff);
		GPIO_SetDSAll(eGPIO_MP0_6,0x0000ffff);
		GPIO_SetDSAll(eGPIO_MP0_7,0x0000ffff);
		
i=0; t=0;
while(i<2)
	{


//		UART_Printf("Input the tacs\n");
//		uTacs= UART_GetIntNum(); 

//		UART_Printf("Input the tcah\n");
//		uTcah= UART_GetIntNum(); 

		UART_Printf("Tacs(%d), Tcos(%d), Tacc(%d), Tcoh(%d), Tcah(%d), Tacp(%d)\n", uTacs, uTcos, uTacc, uTcoh, uTcah, uTacp);
		SROMC_SetTiming(uBank, (Bank_eTiming)uTacs,(Bank_eTiming)uTcos,(Bank_eTiming)uTacc, (Bank_eTiming)uTcoh,(Bank_eTiming)uTcah,(Bank_eTiming) uTacp, ePageMode);
//		DelayfrTimer(milli, 1);
//		SROMC_SetTiming(4, (Bank_eTiming)uTacs,(Bank_eTiming)uTcos,(Bank_eTiming)uTacc, (Bank_eTiming)uTcoh,(Bank_eTiming)uTcah,(Bank_eTiming) uTacp, ePageMode);
		DelayfrTimer(milli, 1);



	//	while(1){
		g_DM9000_BASE =(volatile u8*) 0xa8000000;
		g_DM9000_BASE16 = (volatile u16*)0xa8000000;
		IDlow = ReadReg16(DM9000_VIDL);
		IDhigh = ReadReg16(DM9000_VIDH);
		ID2low = ReadReg16(DM9000_PIDL);
		ID2high = ReadReg16(DM9000_PIDH);
			
		UART_Printf(" ---------BANK5-------- \n");
		DM9000DEBUG(("IDlow=0x%x\n",IDlow));
		DM9000DEBUG(("IDhigh=0x%x\n",IDhigh));
		DM9000DEBUG(("ID2low=0x%x\n",ID2low));
		DM9000DEBUG(("ID2high=0x%x\n",ID2high));
//			}
		ID = IDlow | (IDhigh<<8) | (ID2low<<16) |(ID2high<<24);

		if(ID==DM9000_ID)
		{
			DM9000DEBUG(("ID ok\n"));
		}
		else
		{
			DM9000DEBUG(("ID fail\n"));
		}
		
		dm9000_probe_16();
		
		t=i%2;
		UART_Printf("t=0x%x\n",t);
		DM9000_iow_16(DM9000_GPR,t<<4);		// DM9000 GPIO control
		

	
	i++;
		
	}	


	
	dm9000_probe_16();
	dm9000_reset_16();
	dm9000_probe_16();

	
	
	/* Auto-detect 8/16/32 bit mode, ISR Bit 6+7 indicate bus width */
	io_mode = DM9000_ior_16(DM9000_ISR) >> 6;
	UART_Printf("io_mode : 0x%x \n",io_mode);

	// identify nic

//	DM9000_iow(DM9000_NCR, NCR_EXT_PHY);
//	phy_reg3  =  phy_read(3);
//	UART_Getc();

//	while(1)
{
		dm9000_reset_16();
	pWriteBaseData16 = (u16 *)SROMC_WRITE_BASE;	
	
	pWriteData16 = pWriteBaseData16;
	for(i=0;i<DM9000_SRAM_CNT/2;i++)	*pWriteData16++ = ((u32)rand()%0xffff);
	pWriteData16 = pWriteBaseData16;

		
	pReadBaseData16 = (u16 *)SROMC_READ_BASE;		
	pReadData16 = pReadBaseData16;



//	UART_Printf("Burst Write....\n");
//	UART_Getc();
	eDWidth = e16bit; 	
	SROMC_SetBusWidth( uBank, eDWidth);	
	eAddrMode = eHalfword_Mode;
	SROMC_SetAddrMode(uBank,eAddrMode);

	dm9000_Sram_Write16(0x0, DM9000_SRAM_CNT/2, pWriteData16);

	DM9000_ior_16(DM9000_MRCMDX);
	DM9000_ior_16(DM9000_MRCMDX);
	DM9000_ior_16(DM9000_MRCMDX);
	DM9000_ior_16(DM9000_MRCMDX);
	
//	UART_Printf("Burst Read....\n");
//	UART_Getc();	
	dm9000_Sram_Read16(0x0, DM9000_SRAM_CNT/2, pReadData16);

	t=0;
	for(i=0;i<DM9000_SRAM_CNT/2;i++)
	{
		if(*pWriteData16++ != *pReadData16++) t++;
			//UART_Printf("ERROR> Addr: 0x%x   Wdata: 0x%x   Rdata: 0x%x \n",i,*(pWriteData-1),*(pReadData-1));
	}
	UART_Printf("ERROR count : 0x%x / 0x%x  \n",t<<1,DM9000_SRAM_CNT);
	#if 1
	//UART_Getc();
	pWriteData16 = pWriteBaseData16;
	pReadData16 = pReadBaseData16;
UART_Printf("//////////////////////////////////////////////////\n\n");
}
	UART_Printf("Next list show 10 data ...  \n");
	for(i=0;i<10;i++)
	{
			UART_Printf("[Addr: 0x%x ]  Wdata: 0x%x   Rdata: 0x%x \n",i,*pWriteData16++,*pReadData16++);
	
	}
	#endif

	UART_Printf("\n\n");
}

void DM9000_8bit_Test(void)
{
	u32 uTacs, uTcos, uTacc, uTcoh, uTcah, uTacp;
	u32* reg_temp;
	SROMC_eBANK uBank;
	Data_eWidth eDWidth;
	WAIT_eCTL eWAITCTL;
	Byte_eCTL eByteCTL;
	Page_eMode ePageMode;
	
	u8 IDlow;
	u8 IDhigh;
	u8 ID2low;
	u8 ID2high;
	u8 io_mode;

	u16 phy_reg3;

	u32 ID;


	u32 i,t;
	u8 dm_rdata,dm_wdata;
	
	volatile u8 *pBank5BaseAddress, *index5_Address, *data5_Address;
	volatile u8 *pWriteBaseData,*pReadBaseData;
	u8 *pWriteData,*pReadData;





	UART_Printf("[SROMC_ByteAccess]\n");

	UART_Printf("Input the SROMC BANK Number[0~%d] : \n", eBankMAX);
	uBank = 5; 
	if(uBank > 5)
		uBank = (SROMC_eBANK)0;
//	UART_Printf("Input the Data Bus Width : 8-bit(0),   16-bit(1) \n");
//	eDWidth = (Data_eWidth)UART_GetIntNum(); 	
	eDWidth = e8bit; 	
	if(eDWidth > 1)
		eDWidth = (Data_eWidth)1;
//	UART_Printf("Input the Wait Enable Control : Disable(0),  Enable(1)\n");
//	eWAITCTL = (WAIT_eCTL)UART_GetIntNum(); 
	eWAITCTL = eDis_WAIT; 
	if(eWAITCTL > 1)
		eWAITCTL = (WAIT_eCTL)0;
//	UART_Printf("Input the Byte Enable(nBE/nWBE) Setting : Not using(0),  Using(1)\n");
//	eByteCTL = (Byte_eCTL)UART_GetIntNum(); 
	eByteCTL = eDis_CTL; 
	if(eByteCTL > 1)
		eByteCTL = (Byte_eCTL)0;
//	UART_Printf("Input the Page Mode Setting : Normal(0),  4data(1)\n");
//	ePageMode = (Page_eMode)UART_GetIntNum(); 
	ePageMode = eNor_Mode; 
	if(ePageMode > 1)
		ePageMode = (Page_eMode)0;


	
	SROMC_SetBusWidth( uBank, eDWidth);
	SROMC_SetWaitControl(uBank, eWAITCTL);
	SROMC_SetByteEnable(uBank, eByteCTL);

	uTacs = SROMC_Tacs_MIN;
	uTcos = SROMC_Tcos_MIN;
	uTacc = SROMC_Tacc_MIN;
	uTcoh = SROMC_Tcoh_MIN;
	uTcah = SROMC_Tcah_MIN;
	uTacp = SROMC_Tacp_MIN;

	uTacs = 8;
	uTcos = 3;
	uTacc = 6;
	uTcoh = 2;
	uTcah = 8;
	uTacp = 2;

#if 0
	UART_Printf("Input the tacs(8)\n");
	uTacs= UART_GetIntNum(); 

	UART_Printf("Input the tcos(3)\n");
	uTcos= UART_GetIntNum(); 

	UART_Printf("Input the tacc(6)\n");
	uTacc= UART_GetIntNum(); 

	UART_Printf("Input the tcoh(2)\n");
	uTcoh= UART_GetIntNum(); 

	UART_Printf("Input the tcah(8)\n");
	uTcah= UART_GetIntNum(); 

	UART_Printf("Input the tacp(2)\n");
	uTacp= UART_GetIntNum(); 

#endif

	pBank5BaseAddress = (u8 *)((uBank * 0x08000000)+0x80000000);


	reg_temp = (u32*)0xE02002E0;
	*reg_temp = 0x22222222;  //      MP0_1CON
	
	reg_temp = (u32*)0xE0200300;
	*reg_temp = 0x22222222;  //      MP0_2CON
	
	reg_temp = (u32*)0xE0200340;
	*reg_temp = 0x22222222;  //      MP0_4CON

	reg_temp = (u32*)0xE0200380;
	*reg_temp = 0x22222222;  //      MP0_6CON
	
	reg_temp = (u32*)0xE02003A0;
	*reg_temp = 0x22222222;  //      MP0_6CON

	 	GPIO_SetDSAll(eGPIO_MP0_1,0x0000ffff);
	 	GPIO_SetDSAll(eGPIO_MP0_2,0x0000ffff);
	 	GPIO_SetDSAll(eGPIO_MP0_3,0x0000ffff);
	 	GPIO_SetDSAll(eGPIO_MP0_4,0x0000ffff);
		GPIO_SetDSAll(eGPIO_MP0_5,0x0000ffff);
		GPIO_SetDSAll(eGPIO_MP0_6,0x0000ffff);
		GPIO_SetDSAll(eGPIO_MP0_7,0x0000ffff);

i=0; t=0;
while(i<2)
	{


//		UART_Printf("Input the tacs\n");
//		uTacs= UART_GetIntNum(); 

//		UART_Printf("Input the tcah\n");
//		uTcah= UART_GetIntNum(); 

		UART_Printf("Tacs(%d), Tcos(%d), Tacc(%d), Tcoh(%d), Tcah(%d), Tacp(%d)\n", uTacs, uTcos, uTacc, uTcoh, uTcah, uTacp);
		SROMC_SetTiming(uBank, (Bank_eTiming)uTacs,(Bank_eTiming)uTcos,(Bank_eTiming)uTacc, (Bank_eTiming)uTcoh,(Bank_eTiming)uTcah,(Bank_eTiming) uTacp, ePageMode);
//		DelayfrTimer(milli, 1);
//		SROMC_SetTiming(4, (Bank_eTiming)uTacs,(Bank_eTiming)uTcos,(Bank_eTiming)uTacc, (Bank_eTiming)uTcoh,(Bank_eTiming)uTcah,(Bank_eTiming) uTacp, ePageMode);
		DelayfrTimer(milli, 1);

	
	
	//	while(1){
		g_DM9000_BASE = pBank5BaseAddress;
		IDlow = ReadReg8(DM9000_VIDL);
		IDhigh = ReadReg8(DM9000_VIDH);
		ID2low = ReadReg8(DM9000_PIDL);
		ID2high = ReadReg8(DM9000_PIDH);
			
		UART_Printf(" ---------BANK5-------- \n");
		DM9000DEBUG(("IDlow=0x%x\n",IDlow));
		DM9000DEBUG(("IDhigh=0x%x\n",IDhigh));
		DM9000DEBUG(("ID2low=0x%x\n",ID2low));
		DM9000DEBUG(("ID2high=0x%x\n",ID2high));
//			}
		ID = IDlow | (IDhigh<<8) | (ID2low<<16) |(ID2high<<24);

		if(ID==DM9000_ID)
		{
			DM9000DEBUG(("ID ok\n"));
		}
		else
		{
			DM9000DEBUG(("ID fail\n"));
		}

		
		dm9000_probe();
		
		t=i%2;
		UART_Printf("t=0x%x\n",t);
		DM9000_iow(DM9000_GPR,t<<4);		// DM9000 GPIO control
		

	
	i++;
		
	}	


	
	dm9000_probe();
	dm9000_reset();
	dm9000_probe();

	
	
	/* Auto-detect 8/16/32 bit mode, ISR Bit 6+7 indicate bus width */
	io_mode = DM9000_ior(DM9000_ISR) >> 6;
	UART_Printf("io_mode : 0x%x \n",io_mode);

	// identify nic

//	DM9000_iow(DM9000_NCR, NCR_EXT_PHY);
	phy_reg3  =  phy_read(3);
	

//	while(1)
{
		dm9000_reset();
	pWriteBaseData = (u8 *)SROMC_WRITE_BASE;	
	
	pWriteData = pWriteBaseData;
	for(i=0;i<DM9000_SRAM_CNT;i++)	*pWriteData++ = ((u32)rand()%0xff);
	pWriteData = pWriteBaseData;

		
	pReadBaseData = (u8 *)SROMC_READ_BASE;		
	pReadData = pReadBaseData;



//	UART_Printf("Burst Write....\n");
//	UART_Getc();

	dm9000_Sram_Write(0x0, DM9000_SRAM_CNT, pWriteData);

	DM9000_ior(DM9000_MRCMDX);
	DM9000_ior(DM9000_MRCMDX);
	DM9000_ior(DM9000_MRCMDX);
	DM9000_ior(DM9000_MRCMDX);
	
//	UART_Printf("Burst Read....\n");
//	UART_Getc();	
	dm9000_Sram_Read(0x0, DM9000_SRAM_CNT, pReadData);

	t=0;
	for(i=0;i<DM9000_SRAM_CNT;i++)
	{
		if(*pWriteData++ != *pReadData++) t++;
			//UART_Printf("ERROR> Addr: 0x%x   Wdata: 0x%x   Rdata: 0x%x \n",i,*(pWriteData-1),*(pReadData-1));
	}
	UART_Printf("ERROR count : %d   \n",t);
	#if 1
	//UART_Getc();
	pWriteData = pWriteBaseData;
	pReadData = pReadBaseData;
UART_Printf("//////////////////////////////////////////////////\n\n");
}
	UART_Printf("Next list show 10 data ...  \n");
	for(i=0;i<10;i++)
	{
			UART_Printf("[Addr: 0x%x ]  Wdata: 0x%x   Rdata: 0x%x \n",i,*pWriteData++,*pReadData++);
	
	}
	#endif

	UART_Printf("\n\n");
}

void SROMC_ByteAccess(void)
{
	u32 uTacs, uTcos, uTacc, uTcoh, uTcah, uTacp;
	SROMC_eBANK uBank;
	Data_eWidth eDWidth;
	Addr_eMode eAddrMode;
	WAIT_eCTL eWAITCTL;
	Byte_eCTL eByteCTL;
	Page_eMode ePageMode;

	UART_Printf("[SROMC_ByteAccess]\n");

	UART_Printf("Input the SROMC BANK Number[0~%d] : \n", eBankMAX);
	uBank = (SROMC_eBANK)UART_GetIntNum(); 
	if(uBank > 5)
		uBank = (SROMC_eBANK)0;
	UART_Printf("Input the Data Bus Width : 8-bit(0),   16-bit(1) \n");
	eDWidth = (Data_eWidth)UART_GetIntNum(); 	
	if(eDWidth > 1)
		eDWidth = (Data_eWidth)1;
	if(eDWidth == 1)
	{
		UART_Printf("Input the Address mode  : Half word(0),  Byte base(1) \n");
		eAddrMode = (Addr_eMode)UART_GetIntNum(); 	
	}
	else eAddrMode = eBytebase_Mode; 	 
	
	UART_Printf("Input the Wait Enable Control : Disable(0),  Enable(1)\n");
	eWAITCTL = (WAIT_eCTL)UART_GetIntNum(); 
	if(eWAITCTL > 1)
		eWAITCTL = (WAIT_eCTL)0;
	UART_Printf("Input the Byte Enable(nBE/nWBE) Setting : Not using(0),  Using(1)\n");
	eByteCTL = (Byte_eCTL)UART_GetIntNum(); 
	if(eByteCTL > 1)
		eByteCTL = (Byte_eCTL)0;
	UART_Printf("Input the Page Mode Setting : Normal(0),  4data(1)\n");
	ePageMode = (Page_eMode)UART_GetIntNum(); 
	if(ePageMode > 1)
		ePageMode = (Page_eMode)0;
	
	SROMC_SetBusWidth( uBank, eDWidth);
	SROMC_SetWaitControl(uBank, eWAITCTL);
	SROMC_SetByteEnable(uBank, eByteCTL);
	SROMC_SetAddrMode(uBank,eAddrMode);

	uTacs = SROMC_Tacs_MIN;
	uTcos = SROMC_Tcos_MIN;
	uTacc = SROMC_Tacc_MIN;
	uTcoh = SROMC_Tcoh_MIN;
	uTcah = SROMC_Tcah_MIN;
	uTacp = SROMC_Tacp_MIN;

	// Tacp parameter test
	for(uTacp = 0 ; uTacp <= SROMC_Tacp_MAX ; uTacp++)
	{
		SROMC_ByteWriteReadTest(uBank, (Bank_eTiming)uTacs, (Bank_eTiming)uTcos, (Bank_eTiming)uTacc, 
									(Bank_eTiming)uTcoh, (Bank_eTiming)uTcah, (Bank_eTiming)uTacp, ePageMode);
	}
	uTacp = SROMC_Tacp_MIN;

	// Tcah parameter test
	for(uTcah = 0 ; uTcah <= SROMC_Tcah_MAX ; uTcah++)
	{
		SROMC_ByteWriteReadTest(uBank, (Bank_eTiming)uTacs, (Bank_eTiming)uTcos, (Bank_eTiming)uTacc, 
									(Bank_eTiming)uTcoh, (Bank_eTiming)uTcah, (Bank_eTiming)uTacp, ePageMode);
	}
	uTcah = SROMC_Tcah_MIN;

	// Tcoh parameter test
	for(uTcoh = 0 ; uTcoh <= SROMC_Tcoh_MAX ; uTcoh++)
	{
		SROMC_ByteWriteReadTest(uBank, (Bank_eTiming)uTacs, (Bank_eTiming)uTcos, (Bank_eTiming)uTacc, 
									(Bank_eTiming)uTcoh, (Bank_eTiming)uTcah, (Bank_eTiming)uTacp, ePageMode);
	}
	uTcoh = SROMC_Tcoh_MIN;

	// Tacc parameter test
	for(uTacc = 0 ; uTacc <= SROMC_Tacc_MAX ; uTacc++)
	{
		SROMC_ByteWriteReadTest(uBank, (Bank_eTiming)uTacs, (Bank_eTiming)uTcos, (Bank_eTiming)uTacc, 
									(Bank_eTiming)uTcoh, (Bank_eTiming)uTcah, (Bank_eTiming)uTacp, ePageMode);
	}
	uTacc = SROMC_Tacc_MIN;

	// Tcos parameter test
	for(uTcos = 0 ; uTcos <= SROMC_Tcos_MAX ; uTcos++)
	{
		SROMC_ByteWriteReadTest(uBank, (Bank_eTiming)uTacs, (Bank_eTiming)uTcos, (Bank_eTiming)uTacc, 
									(Bank_eTiming)uTcoh, (Bank_eTiming)uTcah, (Bank_eTiming)uTacp, ePageMode);
	}
	uTcos = SROMC_Tcos_MIN;

	// Tacs parameter test
	for(uTacs = 0 ; uTacs <= SROMC_Tacs_MAX ; uTacs++)
	{
		SROMC_ByteWriteReadTest(uBank, (Bank_eTiming)uTacs, (Bank_eTiming)uTcos, (Bank_eTiming)uTacc, 
									(Bank_eTiming)uTcoh, (Bank_eTiming)uTcah, (Bank_eTiming)uTacp, ePageMode);
	}
	uTacs = SROMC_Tacs_MIN;	

	UART_Printf("\n\n");
}



u32 SROMC_HalfWordWriteReadTest(SROMC_eBANK uBank, Bank_eTiming eTacs, Bank_eTiming eTcos,Bank_eTiming eTacc, 
							 					Bank_eTiming eTcoh, Bank_eTiming eTcah, Bank_eTiming eTacp, Page_eMode ePageMode )
{
	u32 i,time;
	u8 bError = FALSE;
	u16 *pWriteBaseData, *pReadBaseData, *pWriteData, *pReadData;
	u16 *pBankBaseAddress, *pAddress;

	pWriteBaseData = (u16 *)malloc(SROMC_SRAM_SIZE);
	if(pWriteBaseData == 0)
	{
		UART_Printf("Memory Allocation Error...\n");
		return 0;
	}
	memset( pWriteBaseData, 0, SROMC_SRAM_SIZE );
	pWriteData = pWriteBaseData;
	
	pReadBaseData = (u16 *)malloc(SROMC_SRAM_SIZE);	
	if(pReadBaseData == 0)
	{
		free(pWriteBaseData);
		UART_Printf("Memory Allocation Error...\n");
		return 0;
	}
	pReadData = pReadBaseData;
	memset( pReadBaseData, 0, SROMC_SRAM_SIZE );
	
	pBankBaseAddress = (u16 *)((uBank * 0x08000000)+0x80000000);
	pAddress = pBankBaseAddress;

#if (SROMC_TR_TYPE == SROMC_DMA)
#if 1	//DMA0 controller


	INTC_SetVectAddr(NUM_MDMA,  SROMC_DmaISR);
	INTC_Enable(NUM_MDMA);

//	DMAC_InitCh(DMA0, DMA_ALL, &g_oSROMCDmac0);
//	INTC_SetVectAddr(NUM_DMA0,  SROMC_DmaISR);
//	INTC_Enable(NUM_DMA0);
#elif 0	//DMA1 controller
	DMAC_InitCh(DMA1, DMA_ALL, &g_oSROMCDmac0);
	INTC_SetVectAddr(NUM_DMA1,  SROMC_DmaISR);
	INTC_Enable(NUM_DMA1);
#elif 0	//SDMA0 controller
	DMAC_InitCh(SDMA0, DMA_ALL, &g_oSROMCDmac0);
	INTC_SetVectAddr(NUM_SDMA0,  SROMC_DmaISR);
	INTC_Enable(NUM_SDMA0);
#else	//SDMA1 controller
	DMAC_InitCh(SDMA1, DMA_ALL, &g_oSROMCDmac0);
	INTC_SetVectAddr(NUM_SDMA1,  SROMC_DmaISR);
	INTC_Enable(NUM_SDMA1);	
#endif	
#endif	

	UART_Printf("Tacs(%d), Tcos(%d), Tacc(%d), Tcoh(%d), Tcah(%d), Tacp(%d)\n", eTacs, eTcos, eTacc, eTcoh, eTcah, eTacp);
	SROMC_SetTiming(uBank, eTacs, eTcos, eTacc, 	eTcoh, eTcah, eTacp, ePageMode);
	DelayfrTimer(milli, 1);
	
	pWriteData = pWriteBaseData;
	
	srand(eTacs + eTcos + eTacc + eTcoh + eTcah + eTacp);
	for(i=0; i<SROMC_SRAM_SIZE/2; i++)
	{
#if(SROMC_DATA_PATTERN == SROMC_DATA_RANDOM)
		*pWriteData++ = (u16)rand();
#else	// ONDT_DATA_PATTERN == ONDT_DATA_ONEVALUE
		*pWriteData++ = SROMC_DATA_ONEVALUE;
#endif
	}

	/////////////////////////////////
	// Write from DRAM to SRAM memory
	/////////////////////////////////
	pWriteData = pWriteBaseData;
	pAddress = pBankBaseAddress;
	
#if (SROMC_TR_TYPE == SROMC_POLLING)
	for(i=0; i<SROMC_SRAM_SIZE/2; i++)
	{
		*pAddress++ =  *pWriteData++;
	}
#elif (SROMC_TR_TYPE == SROMC_MEMCPY)
	UART_Printf("Memcpy() function is not byte access\n");
	free(pWriteBaseData);
	free(pReadBaseData);
	return 0;
#else
	SROMC_DmaDone = 0;

	DMA_SetCh(DMA_20,&g_oSROMCDmac0);
	DMA_InitCh(HWORD, SOFTWARE, DMA_M2M, BURST16, &g_oSROMCDmac0);

	
	StartTimer(2);	
	DMA_StartCh((u32)pWriteData, (u32)pAddress, SROMC_SRAM_SIZE/2,&g_oSROMCDmac0);

//	DMACH_Setup(DMA_A, 0, (u32)pWriteData, 0, (u32)pAddress, 0, HWORD, SROMC_SRAM_SIZE/2, DEMAND, MEM, MEM, BURST4, &g_oSROMCDmac0);
//	DMACH_Start(&g_oSROMCDmac0);
	while(!SROMC_DmaDone);

	time = StopTimer(2);
	UART_Printf("WriteTime: %dus (  Kbyte), Data rate= %fKbyte/sec\n",time,(float)(SROMC_SRAM_SIZE)/time*1000);
	
#endif

	/////////////////////////////////
	// Read from SRAM memory to DRAM
	/////////////////////////////////
	pReadData = pReadBaseData;
	pAddress = pBankBaseAddress;
	
#if (SROMC_TR_TYPE == SROMC_POLLING)
	for(i=0; i<SROMC_SRAM_SIZE/2; i++)
	{
		*pReadData++ = *pAddress++;
	}
#else
	SROMC_DmaDone = 0;

	DMA_SetCh(DMA_20,&g_oSROMCDmac0);
	DMA_InitCh(HWORD, SOFTWARE, DMA_M2M, BURST16, &g_oSROMCDmac0);


	StartTimer(2);	
	DMA_StartCh((u32)pAddress, (u32)pReadData, SROMC_SRAM_SIZE/2,&g_oSROMCDmac0);

//	DMACH_Setup(DMA_A, 0, (u32)pAddress, 0, (u32)pReadData, 0, HWORD, SROMC_SRAM_SIZE/2, DEMAND, MEM, MEM, BURST4, &g_oSROMCDmac0);
//	DMACH_Start(&g_oSROMCDmac0);
	while(!SROMC_DmaDone);
		time = StopTimer(2);
	UART_Printf("ReadTime: %dus ( Kbyte), Data rate= %fKbyte/sec\n",time,(float)(SROMC_SRAM_SIZE)/time*1000);
	
#endif			

	/////////////////////////////////
	// Compare Data
	/////////////////////////////////
	pReadData = pReadBaseData;
	pWriteData = pWriteBaseData;
	pAddress = pBankBaseAddress;
	bError = FALSE;
	
	for(i=0 ; i<SROMC_SRAM_SIZE/2 ; i++)
	{
		if(pReadData[i] != pWriteData[i])
		{
			UART_Printf("\t [Address: 0x%08x] [Write data : Read data] = [0x%04x  : 0x%04x ]  \n", pAddress, pWriteData[i], pReadData[i]);
			UART_Getc();
			bError = TRUE;
			break;
		}
		pAddress++;
	}
	if(bError == FALSE)
		UART_Printf("Test OK\n");	

	pWriteData = pWriteBaseData;
	for(i=0; i<SROMC_SRAM_SIZE/2; i++)
	{
		*pWriteData++ = 0;
	}

	free(pWriteBaseData);
	free(pReadBaseData);
	
	return 0;
}


void SROMC_HalfWordAccess(void)
{
	u32 uTacs, uTcos, uTacc, uTcoh, uTcah, uTacp;
	SROMC_eBANK uBank;
	Data_eWidth eDWidth;
	WAIT_eCTL eWAITCTL;
	Byte_eCTL eByteCTL;
	Page_eMode ePageMode;
	Addr_eMode eAddrMode;
	
	UART_Printf("[SROMC_HalfWordAccess]\n");

	UART_Printf("Input the SROMC BANK Number[0~%d] : \n", eBankMAX);
	uBank = (SROMC_eBANK)UART_GetIntNum(); 
	if(uBank > 5)
		uBank = (SROMC_eBANK)0;
	UART_Printf("Input the Data Bus Width : 8-bit(0),   16-bit(1) \n");
	eDWidth = (Data_eWidth)UART_GetIntNum(); 	
	if(eDWidth > 1)
		eDWidth = (Data_eWidth)1;
	
	if(eDWidth == 1)
	{
		UART_Printf("Input the Address mode  : Half word(0),  Byte base(1) \n");
		eAddrMode = (Addr_eMode)UART_GetIntNum(); 	
	}
	else eAddrMode = eBytebase_Mode; 	 


	
	UART_Printf("Input the Wait Enable Control : Disable(0),  Enable(1)\n");
	eWAITCTL = (WAIT_eCTL)UART_GetIntNum(); 
	if(eWAITCTL > 1)
		eWAITCTL = (WAIT_eCTL)0;
	UART_Printf("Input the Byte Enable(nBE/nWBE) Setting : Not using(0),  Using(1)\n");
	eByteCTL = (Byte_eCTL)UART_GetIntNum(); 
	if(eByteCTL > 1)
		eByteCTL = (Byte_eCTL)0;
	UART_Printf("Input the Page Mode Setting : Normal(0),  4data(1)\n");
	ePageMode = (Page_eMode)UART_GetIntNum(); 
	if(ePageMode > 1)
		ePageMode = (Page_eMode)0;
	
	SROMC_SetBusWidth( uBank, eDWidth);
	SROMC_SetWaitControl(uBank, eWAITCTL);
	SROMC_SetByteEnable(uBank, eByteCTL);
	SROMC_SetAddrMode(uBank,eAddrMode);
	
	uTacs = SROMC_Tacs_MIN;
	uTcos = SROMC_Tcos_MIN;
	uTacc = SROMC_Tacc_MIN;
	uTcoh = SROMC_Tcoh_MIN;
	uTcah = SROMC_Tcah_MIN;
	uTacp = SROMC_Tacp_MIN;

	// Tacp parameter test
	for(uTacp = SROMC_Tacp_MIN ; uTacp <= SROMC_Tacp_MAX ; uTacp++)
	{
		SROMC_HalfWordWriteReadTest(uBank, (Bank_eTiming)uTacs, (Bank_eTiming)uTcos, (Bank_eTiming)uTacc, 
									(Bank_eTiming)uTcoh, (Bank_eTiming)uTcah, (Bank_eTiming)uTacp, ePageMode);
	}
	uTacp = SROMC_Tacp_MIN;

	// Tcah parameter test
	for(uTcah = SROMC_Tcah_MIN ; uTcah <= SROMC_Tcah_MAX ; uTcah++)
	{
		SROMC_HalfWordWriteReadTest(uBank, (Bank_eTiming)uTacs, (Bank_eTiming)uTcos, (Bank_eTiming)uTacc, 
									(Bank_eTiming)uTcoh, (Bank_eTiming)uTcah, (Bank_eTiming)uTacp, ePageMode);
	}
	uTcah = SROMC_Tcah_MIN;

	// Tcoh parameter test
	for(uTcoh = SROMC_Tcoh_MIN ; uTcoh <= SROMC_Tcoh_MAX ; uTcoh++)
	{
		SROMC_HalfWordWriteReadTest(uBank, (Bank_eTiming)uTacs, (Bank_eTiming)uTcos, (Bank_eTiming)uTacc, 
									(Bank_eTiming)uTcoh, (Bank_eTiming)uTcah, (Bank_eTiming)uTacp, ePageMode);
	}
	uTcoh = SROMC_Tcoh_MIN;

	// Tacc parameter test
	for(uTacc = SROMC_Tacc_MIN ; uTacc <= SROMC_Tacc_MAX ; uTacc++)
	{
		SROMC_HalfWordWriteReadTest(uBank, (Bank_eTiming)uTacs, (Bank_eTiming)uTcos, (Bank_eTiming)uTacc, 
									(Bank_eTiming)uTcoh, (Bank_eTiming)uTcah, (Bank_eTiming)uTacp, ePageMode);
	}
	uTacc = SROMC_Tacc_MIN;

	// Tcos parameter test
	for(uTcos = SROMC_Tcos_MIN ; uTcos <= SROMC_Tcos_MAX ; uTcos++)
	{
		SROMC_HalfWordWriteReadTest(uBank, (Bank_eTiming)uTacs, (Bank_eTiming)uTcos, (Bank_eTiming)uTacc, 
									(Bank_eTiming)uTcoh, (Bank_eTiming)uTcah, (Bank_eTiming)uTacp, ePageMode);
	}
	uTcos = SROMC_Tcos_MIN;

	// Tacs parameter test
	for(uTacs = SROMC_Tacs_MIN ; uTacs <= SROMC_Tacs_MAX ; uTacs++)
	{
		SROMC_HalfWordWriteReadTest(uBank, (Bank_eTiming)uTacs, (Bank_eTiming)uTcos, (Bank_eTiming)uTacc, 
									(Bank_eTiming)uTcoh, (Bank_eTiming)uTcah, (Bank_eTiming)uTacp, ePageMode);
	}
	uTacs = SROMC_Tacs_MIN;	

	UART_Printf("\n\n");
}


u32 SROMC_DWordWriteReadTest(SROMC_eBANK uBank, Bank_eTiming eTacs, Bank_eTiming eTcos,Bank_eTiming eTacc, 
							 					Bank_eTiming eTcoh, Bank_eTiming eTcah, Bank_eTiming eTacp, Page_eMode ePageMode )
{
	u32 i,time,err_cnt;
	u8 bError = FALSE;
	u32 *pWriteBaseData, *pReadBaseData, *pWriteData, *pReadData;
	u32 *pBankBaseAddress, *pAddress;

	pWriteBaseData = (u32 *)malloc(SROMC_SRAM_SIZE);
	if(pWriteBaseData == 0)
	{
		UART_Printf("Memory Allocation Error...\n");
		return 0;
	}
	memset( pWriteBaseData, 0, SROMC_SRAM_SIZE );
	pWriteData = pWriteBaseData;
	
	pReadBaseData = (u32 *)malloc(SROMC_SRAM_SIZE);	
	if(pReadBaseData == 0)
	{
		free(pWriteBaseData);
		UART_Printf("Memory Allocation Error...\n");
		return 0;
	}
	pReadData = pReadBaseData;
	memset( pReadBaseData, 0, SROMC_SRAM_SIZE );
	
	pBankBaseAddress = (u32 *)((uBank * 0x08000000)+0x80000000);
	pAddress = pBankBaseAddress;
///while(1)				///// for test......
//{
#if (SROMC_TR_TYPE == SROMC_DMA)


	INTC_SetVectAddr(NUM_MDMA,  SROMC_DmaISR);
	INTC_Enable(NUM_MDMA);


#endif	

	UART_Printf("Tacs(%d), Tcos(%d), Tacc(%d), Tcoh(%d), Tcah(%d), Tacp(%d)\n", eTacs, eTcos, eTacc, eTcoh, eTcah, eTacp);
	SROMC_SetTiming(uBank, eTacs, eTcos, eTacc, 	eTcoh, eTcah, eTacp, ePageMode);
	DelayfrTimer(milli, 1);
	
	pWriteData = pWriteBaseData;
	

	for(i=0; i<SROMC_SRAM_SIZE/4; i++)
	{
#if(SROMC_DATA_PATTERN == SROMC_DATA_RANDOM)
		*pWriteData++ = (u32)rand();
#else	// ONDT_DATA_PATTERN == ONDT_DATA_ONEVALUE
		*pWriteData++ = SROMC_DATA_ONEVALUE;
#endif
	}

	/////////////////////////////////
	// Write from DRAM to SRAM memory
	/////////////////////////////////
	pWriteData = pWriteBaseData;
	pAddress = pBankBaseAddress;
	
#if 	0	// (SROMC_TR_TYPE == SROMC_POLLING)
	for(i=0; i<SROMC_SRAM_SIZE/4; i++)
	{
		*pAddress++ =  *pWriteData++;
	}
#elif 0 	//(SROMC_TR_TYPE == SROMC_MEMCPY)
	UART_Printf("Memcpy() function is not byte access\n");
	free(pWriteBaseData);
	free(pReadBaseData);
	return 0;
#else

	
	SROMC_DmaDone = 0;
	DMA_SetCh(DMA_20,&g_oSROMCDmac0);
	DMA_InitCh(DWORD, SOFTWARE, DMA_M2M, BURST16, &g_oSROMCDmac0);

	
	StartTimer(2);	
	DMA_StartCh((u32)pWriteData, (u32)pAddress, SROMC_SRAM_SIZE/8,&g_oSROMCDmac0);

//	DMACH_Setup(DMA_A, 0, (u32)pWriteData, 0, (u32)pAddress, 0, HWORD, SROMC_SRAM_SIZE/2, DEMAND, MEM, MEM, BURST4, &g_oSROMCDmac0);
//	DMACH_Start(&g_oSROMCDmac0);
	while(!SROMC_DmaDone);

	time = StopTimer(2);
	UART_Printf("WriteTime: %dus (  Kbyte), Data rate= %fKbyte/sec\n",time,(float)(SROMC_SRAM_SIZE)/time*1000);
	
#endif

	/////////////////////////////////
	// Read from SRAM memory to DRAM
	/////////////////////////////////
	pReadData = pReadBaseData;
	pAddress = pBankBaseAddress;
	
#if 0		// (SROMC_TR_TYPE == SROMC_POLLING)
	for(i=0; i<SROMC_SRAM_SIZE/2; i++)
	{
		*pReadData++ = *pAddress++;
	}
#else

		// read timing fixed for write timing change test.....
//	UART_Printf("Tacs(%d), Tcos(%d), Tacc(%d), Tcoh(%d), Tcah(%d), Tacp(%d)\n", eTacs, eTcos, eTacc, eTcoh, eTcah, eTacp);
//	SROMC_SetTiming(uBank, eTacs, eTcos, eTacc, 	eTcoh, eTcah, eTacp, ePageMode);
	SROMC_SetTiming(uBank, 0, 3,5,1,0,0,0);
	DelayfrTimer(milli, 1);
	
	SROMC_DmaDone = 0;

	DMA_SetCh(DMA_20,&g_oSROMCDmac0);
	DMA_InitCh(DWORD, SOFTWARE, DMA_M2M, BURST16, &g_oSROMCDmac0);


	StartTimer(2);	
	DMA_StartCh((u32)pAddress, (u32)pReadData, SROMC_SRAM_SIZE/8,&g_oSROMCDmac0);

//	DMACH_Setup(DMA_A, 0, (u32)pAddress, 0, (u32)pReadData, 0, HWORD, SROMC_SRAM_SIZE/2, DEMAND, MEM, MEM, BURST4, &g_oSROMCDmac0);
//	DMACH_Start(&g_oSROMCDmac0);
	while(!SROMC_DmaDone);
	INTC_Disable(NUM_MDMA);
	time = StopTimer(2);
	UART_Printf("ReadTime: %dus ( Kbyte), Data rate= %fKbyte/sec\n",time,(float)(SROMC_SRAM_SIZE)/time*1000);
	
#endif			

	/////////////////////////////////
	// Compare Data
	/////////////////////////////////
	pReadData = pReadBaseData;
	pWriteData = pWriteBaseData;
	pAddress = pBankBaseAddress;
	bError = FALSE;
	err_cnt = 0;
	for(i=0 ; i<SROMC_SRAM_SIZE/4 ; i++)
	{
		if(pReadData[i] != pWriteData[i])
		{
			//UART_Printf("\t [Address: 0x%08x] [Write data : Read data] = [0x%04x  : 0x%04x ]  \n", pAddress, pWriteData[i], pReadData[i]);
			//UART_Getc();
			bError = TRUE;
			err_cnt++;
			//break;
		}
		pAddress++;
	}
	if(bError == FALSE)
		UART_Printf("Test OK!\n");	
	else	
		UART_Printf("Test Fail! Total Error bytes :  %d\n",err_cnt*4);	

	UART_Printf("\n");
	//UART_Printf("Press any key...\n");
	//UART_Getc();
	UART_Printf("0: continue        1: show write&read data\n");	
	i=0;
//	i=	UART_GetIntNum();
	if(i==1)
	{
		pWriteData = pWriteBaseData;
		UART_Printf("Write data is......................");
		for(i=0; i<SROMC_SRAM_SIZE/4; i++) {
			if((i%12)==0) UART_Printf("\n%4x: ", i*4);
			UART_Printf("%08x ", *pWriteData++);
		}
		UART_Printf("\n");
		
		pReadData = pReadBaseData;
		UART_Printf("Read data is......................");
		for(i=0; i<SROMC_SRAM_SIZE/4; i++) {
			if((i%12)==0) UART_Printf("\n%4x: ", i*4);
			UART_Printf("%08x ", *pReadData++);
		}
		UART_Printf("\n");
		
		UART_Printf("Press any key...\n");	
		UART_Getc();
	}
	pWriteData = pWriteBaseData;
	for(i=0; i<SROMC_SRAM_SIZE/2; i++)
	{
		*pWriteData++ = 0;
	}
// }///// while  1    for test.....
	free(pWriteBaseData);
	free(pReadBaseData);
	
	return 0;
}




void SROMC_DWordAccess(void)
{
	u32 uTacs, uTcos, uTacc, uTcoh, uTcah, uTacp,i;
	SROMC_eBANK uBank;
	Data_eWidth eDWidth;
	WAIT_eCTL eWAITCTL;
	Byte_eCTL eByteCTL;
	Page_eMode ePageMode;
	Addr_eMode eAddrMode;
	
	UART_Printf("[SROMC_DoubleWordAccess]\n");

	UART_Printf("Input the SROMC BANK Number[0~%d] : \n", eBankMAX);
	uBank = (SROMC_eBANK)UART_GetIntNum(); 
	if(uBank > 5)
		uBank = (SROMC_eBANK)0;
	UART_Printf("Input the Data Bus Width : 8-bit(0),   16-bit(1) \n");
	eDWidth = (Data_eWidth)UART_GetIntNum(); 	
	if(eDWidth > 1)
		eDWidth = (Data_eWidth)1;
	
	if(eDWidth == 1)
	{
		UART_Printf("Input the Address mode  : Half word(0),  Byte base(1) \n");
		eAddrMode = (Addr_eMode)UART_GetIntNum(); 	
	}
	else eAddrMode = eBytebase_Mode; 	 


	
	UART_Printf("Input the Wait Enable Control : Disable(0),  Enable(1)\n");
	eWAITCTL = (WAIT_eCTL)UART_GetIntNum(); 
	if(eWAITCTL > 1)
		eWAITCTL = (WAIT_eCTL)0;
	UART_Printf("Input the Byte Enable(nBE/nWBE) Setting : Not using(0),  Using(1)\n");
	eByteCTL = (Byte_eCTL)UART_GetIntNum(); 
	if(eByteCTL > 1)
		eByteCTL = (Byte_eCTL)0;
	UART_Printf("Input the Page Mode Setting : Normal(0),  4data(1)\n");
	ePageMode = (Page_eMode)UART_GetIntNum(); 
	if(ePageMode > 1)
		ePageMode = (Page_eMode)0;
	
	SROMC_SetBusWidth( uBank, eDWidth);
	SROMC_SetWaitControl(uBank, eWAITCTL);
	SROMC_SetByteEnable(uBank, eByteCTL);
	SROMC_SetAddrMode(uBank,eAddrMode);
	
	uTacs = SROMC_Tacs_TYP;
	uTcos = SROMC_Tcos_TYP;
	uTacc = SROMC_Tacc_TYP;
	uTcoh = SROMC_Tcoh_TYP;
	uTcah = SROMC_Tcah_TYP;
	uTacp = SROMC_Tacp_TYP;
	UART_Printf("Input any number for random seed\n");
	i=UART_GetIntNum();
	srand(i);

	for(i = 0; i <= 4 ; i++)
	{
		SROMC_DWordWriteReadTest(uBank, (Bank_eTiming)uTacs, (Bank_eTiming)uTcos, (Bank_eTiming)uTacc, 
									(Bank_eTiming)uTcoh, (Bank_eTiming)uTcah, (Bank_eTiming)uTacp, ePageMode);
	}

	// Tacp parameter test
	for(uTacp = SROMC_Tacp_MIN ; uTacp <= SROMC_Tacp_MAX ; uTacp++)
	{
		SROMC_DWordWriteReadTest(uBank, (Bank_eTiming)uTacs, (Bank_eTiming)uTcos, (Bank_eTiming)uTacc, 
									(Bank_eTiming)uTcoh, (Bank_eTiming)uTcah, (Bank_eTiming)uTacp, ePageMode);
	}
	uTacp = SROMC_Tacp_TYP;

	// Tcah parameter test
	for(uTcah = SROMC_Tcah_MIN ; uTcah <= SROMC_Tcah_MAX ; uTcah++)
	{
		SROMC_DWordWriteReadTest(uBank, (Bank_eTiming)uTacs, (Bank_eTiming)uTcos, (Bank_eTiming)uTacc, 
									(Bank_eTiming)uTcoh, (Bank_eTiming)uTcah, (Bank_eTiming)uTacp, ePageMode);
	}
	uTcah = SROMC_Tcah_TYP;

	// Tcoh parameter test
	for(uTcoh = SROMC_Tcoh_MIN ; uTcoh <= SROMC_Tcoh_MAX ; uTcoh++)
	{
		SROMC_DWordWriteReadTest(uBank, (Bank_eTiming)uTacs, (Bank_eTiming)uTcos, (Bank_eTiming)uTacc, 
									(Bank_eTiming)uTcoh, (Bank_eTiming)uTcah, (Bank_eTiming)uTacp, ePageMode);
	}
	uTcoh = SROMC_Tcoh_TYP;

	// Tacc parameter test
	for(uTacc = SROMC_Tacc_MIN ; uTacc <= SROMC_Tacc_MAX ; uTacc++)
	{
		SROMC_DWordWriteReadTest(uBank, (Bank_eTiming)uTacs, (Bank_eTiming)uTcos, (Bank_eTiming)uTacc, 
									(Bank_eTiming)uTcoh, (Bank_eTiming)uTcah, (Bank_eTiming)uTacp, ePageMode);
	}
	uTacc = SROMC_Tacc_TYP;

	// Tcos parameter test
	for(uTcos = SROMC_Tcos_MIN ; uTcos <= SROMC_Tcos_MAX ; uTcos++)
	{
		SROMC_DWordWriteReadTest(uBank, (Bank_eTiming)uTacs, (Bank_eTiming)uTcos, (Bank_eTiming)uTacc, 
									(Bank_eTiming)uTcoh, (Bank_eTiming)uTcah, (Bank_eTiming)uTacp, ePageMode);
	}
	uTcos = SROMC_Tcos_TYP;

	// Tacs parameter test
	for(uTacs = SROMC_Tacs_MIN ; uTacs <= SROMC_Tacs_MAX ; uTacs++)
	{
		SROMC_DWordWriteReadTest(uBank, (Bank_eTiming)uTacs, (Bank_eTiming)uTcos, (Bank_eTiming)uTacc, 
									(Bank_eTiming)uTcoh, (Bank_eTiming)uTcah, (Bank_eTiming)uTacp, ePageMode);
	}
	uTacs = SROMC_Tacs_TYP;	

	UART_Printf("\n\n");
}
u32 SROMC_WordWriteReadTest_pdma(SROMC_eBANK uBank, Bank_eTiming eTacs, Bank_eTiming eTcos,Bank_eTiming eTacc, 
							 					Bank_eTiming eTcoh, Bank_eTiming eTcah, Bank_eTiming eTacp, Page_eMode ePageMode )
{
	u32 i,time,err_cnt;
	u8 bError = FALSE;
	u32 *pWriteBaseData, *pReadBaseData, *pWriteData, *pReadData;
	u32 *pBankBaseAddress, *pAddress;

	pWriteBaseData = (u32 *)malloc(SROMC_SRAM_SIZE);
	if(pWriteBaseData == 0)
	{
		UART_Printf("Memory Allocation Error...\n");
		return 0;
	}
	memset( pWriteBaseData, 0, SROMC_SRAM_SIZE );
	pWriteData = pWriteBaseData;
	
	pReadBaseData = (u32 *)malloc(SROMC_SRAM_SIZE);	
	if(pReadBaseData == 0)
	{
		free(pWriteBaseData);
		UART_Printf("Memory Allocation Error...\n");
		return 0;
	}
	pReadData = pReadBaseData;
	memset( pReadBaseData, 0, SROMC_SRAM_SIZE );
	
	pBankBaseAddress = (u32 *)((uBank * 0x08000000)+0x80000000);
	pAddress = pBankBaseAddress;
while(1)				///// for test......
{
#if (SROMC_TR_TYPE == SROMC_DMA)


	INTC_SetVectAddr(NUM_PDMA0,  SROMC_DmaISR);
	INTC_Enable(NUM_PDMA0);


#endif	

	UART_Printf("Tacs(%d), Tcos(%d), Tacc(%d), Tcoh(%d), Tcah(%d), Tacp(%d)\n", eTacs, eTcos, eTacc, eTcoh, eTcah, eTacp);
	SROMC_SetTiming(uBank, eTacs, eTcos, eTacc, 	eTcoh, eTcah, eTacp, ePageMode);
	DelayfrTimer(milli, 1);
	
	pWriteData = pWriteBaseData;
	

	for(i=0; i<SROMC_SRAM_SIZE/4; i++)
	{
#if(SROMC_DATA_PATTERN == SROMC_DATA_RANDOM)
		*pWriteData++ = (u32)rand();
#else	// ONDT_DATA_PATTERN == ONDT_DATA_ONEVALUE
		*pWriteData++ = SROMC_DATA_ONEVALUE;
#endif
	}

	/////////////////////////////////
	// Write from DRAM to SRAM memory
	/////////////////////////////////
	pWriteData = pWriteBaseData;
	pAddress = pBankBaseAddress;
	
#if 	0	// (SROMC_TR_TYPE == SROMC_POLLING)
	for(i=0; i<SROMC_SRAM_SIZE/4; i++)
	{
		*pAddress++ =  *pWriteData++;
	}
#elif 0 	//(SROMC_TR_TYPE == SROMC_MEMCPY)
	UART_Printf("Memcpy() function is not byte access\n");
	free(pWriteBaseData);
	free(pReadBaseData);
	return 0;
#else

	
	SROMC_DmaDone = 0;

	DMA_SetCh(DMA_00,&g_oSROMCDmac0);
	DMA_InitCh(WORD, SOFTWARE, DMA_M2P, BURST8, &g_oSROMCDmac0);

	
	StartTimer(2);	
	DMA_StartCh((u32)pWriteData, (u32)pAddress, SROMC_SRAM_SIZE/4,&g_oSROMCDmac0);

//	DMACH_Setup(DMA_A, 0, (u32)pWriteData, 0, (u32)pAddress, 0, HWORD, SROMC_SRAM_SIZE/2, DEMAND, MEM, MEM, BURST4, &g_oSROMCDmac0);
//	DMACH_Start(&g_oSROMCDmac0);
	while(!SROMC_DmaDone);

	time = StopTimer(2);
	UART_Printf("WriteTime: %dus (  Kbyte), Data rate= %fKbyte/sec\n",time,(float)(SROMC_SRAM_SIZE)/time*1000);
	
#endif

	/////////////////////////////////
	// Read from SRAM memory to DRAM
	/////////////////////////////////
	pReadData = pReadBaseData;
	pAddress = pBankBaseAddress;
	
#if 0		// (SROMC_TR_TYPE == SROMC_POLLING)
	for(i=0; i<SROMC_SRAM_SIZE/2; i++)
	{
		*pReadData++ = *pAddress++;
	}
#else

		// read timing fixed for write timing change test.....
//	UART_Printf("Tacs(%d), Tcos(%d), Tacc(%d), Tcoh(%d), Tcah(%d), Tacp(%d)\n", eTacs, eTcos, eTacc, eTcoh, eTcah, eTacp);
	SROMC_SetTiming(uBank, eTacs, eTcos, eTacc, 	eTcoh, eTcah, eTacp, ePageMode);
//	SROMC_SetTiming(uBank, 0, 3,5,1,0,0,0);
	DelayfrTimer(milli, 1);
	
	SROMC_DmaDone = 0;

	DMA_SetCh(DMA_00,&g_oSROMCDmac0);
	DMA_InitCh(WORD, SOFTWARE, DMA_M2P, BURST8, &g_oSROMCDmac0);


	StartTimer(2);	
	DMA_StartCh((u32)pAddress, (u32)pReadData, SROMC_SRAM_SIZE/4,&g_oSROMCDmac0);

//	DMACH_Setup(DMA_A, 0, (u32)pAddress, 0, (u32)pReadData, 0, HWORD, SROMC_SRAM_SIZE/2, DEMAND, MEM, MEM, BURST4, &g_oSROMCDmac0);
//	DMACH_Start(&g_oSROMCDmac0);
	while(!SROMC_DmaDone);
	INTC_Disable(NUM_PDMA0);
	time = StopTimer(2);
	UART_Printf("ReadTime: %dus ( Kbyte), Data rate= %fKbyte/sec\n",time,(float)(SROMC_SRAM_SIZE)/time*1000);
	
#endif			

	/////////////////////////////////
	// Compare Data
	/////////////////////////////////
	pReadData = pReadBaseData;
	pWriteData = pWriteBaseData;
	pAddress = pBankBaseAddress;
	bError = FALSE;
	err_cnt = 0;
	for(i=0 ; i<SROMC_SRAM_SIZE/4 ; i++)
	{
		if(pReadData[i] != pWriteData[i])
		{
			//UART_Printf("\t [Address: 0x%08x] [Write data : Read data] = [0x%04x  : 0x%04x ]  \n", pAddress, pWriteData[i], pReadData[i]);
			//UART_Getc();
			bError = TRUE;
			err_cnt++;
			//break;
		}
		pAddress++;
	}
	if(bError == FALSE)
		UART_Printf("Test OK!\n");	
	else	
		UART_Printf("Test Fail! Total Error bytes :  %d\n",err_cnt*4);	

	UART_Printf("\n");
	//UART_Printf("Press any key...\n");
	//UART_Getc();
	UART_Printf("0: continue        1: show write&read data\n");	
	i=0;
//	i=	UART_GetIntNum();
	if(i==1)
	{
		pWriteData = pWriteBaseData;
		UART_Printf("Write data is......................");
		for(i=0; i<SROMC_SRAM_SIZE/4; i++) {
			if((i%12)==0) UART_Printf("\n%4x: ", i*4);
			UART_Printf("%08x ", *pWriteData++);
		}
		UART_Printf("\n");
		
		pReadData = pReadBaseData;
		UART_Printf("Read data is......................");
		for(i=0; i<SROMC_SRAM_SIZE/4; i++) {
			if((i%12)==0) UART_Printf("\n%4x: ", i*4);
			UART_Printf("%08x ", *pReadData++);
		}
		UART_Printf("\n");
		
		UART_Printf("Press any key...\n");	
		UART_Getc();
	}
	pWriteData = pWriteBaseData;
	for(i=0; i<SROMC_SRAM_SIZE/2; i++)
	{
		*pWriteData++ = 0;
	}
}///// while  1    for test.....
	free(pWriteBaseData);
	free(pReadBaseData);
	
	return 0;
}


void SROMC_WordAccess_pdma(void)
{
	u32 uTacs, uTcos, uTacc, uTcoh, uTcah, uTacp,i;
	SROMC_eBANK uBank;
	Data_eWidth eDWidth;
	WAIT_eCTL eWAITCTL;
	Byte_eCTL eByteCTL;
	Page_eMode ePageMode;
	Addr_eMode eAddrMode;
	
	UART_Printf("[SROMC_PDMA WordAccess]\n");

	UART_Printf("Input the SROMC BANK Number[0~%d] : \n", eBankMAX);
	uBank = (SROMC_eBANK)UART_GetIntNum(); 
	if(uBank > 5)
		uBank = (SROMC_eBANK)0;
	UART_Printf("Input the Data Bus Width : 8-bit(0),   16-bit(1) \n");
	eDWidth = (Data_eWidth)UART_GetIntNum(); 	
	if(eDWidth > 1)
		eDWidth = (Data_eWidth)1;
	
	if(eDWidth == 1)
	{
		UART_Printf("Input the Address mode  : Half word(0),  Byte base(1) \n");
		eAddrMode = (Addr_eMode)UART_GetIntNum(); 	
	}
	else eAddrMode = eBytebase_Mode; 	 


	
	UART_Printf("Input the Wait Enable Control : Disable(0),  Enable(1)\n");
	eWAITCTL = (WAIT_eCTL)UART_GetIntNum(); 
	if(eWAITCTL > 1)
		eWAITCTL = (WAIT_eCTL)0;
	UART_Printf("Input the Byte Enable(nBE/nWBE) Setting : Not using(0),  Using(1)\n");
	eByteCTL = (Byte_eCTL)UART_GetIntNum(); 
	if(eByteCTL > 1)
		eByteCTL = (Byte_eCTL)0;
	UART_Printf("Input the Page Mode Setting : Normal(0),  4data(1)\n");
	ePageMode = (Page_eMode)UART_GetIntNum(); 
	if(ePageMode > 1)
		ePageMode = (Page_eMode)0;
	
	SROMC_SetBusWidth( uBank, eDWidth);
	SROMC_SetWaitControl(uBank, eWAITCTL);
	SROMC_SetByteEnable(uBank, eByteCTL);
	SROMC_SetAddrMode(uBank,eAddrMode);
	
	uTacs = SROMC_Tacs_TYP;
	uTcos = SROMC_Tcos_TYP;
	uTacc = SROMC_Tacc_TYP;
	uTcoh = SROMC_Tcoh_TYP;
	uTcah = SROMC_Tcah_TYP;
	uTacp = SROMC_Tacp_TYP;
	UART_Printf("Input any number for random seed\n");
	i=UART_GetIntNum();
	srand(i);

	for(i = 0; i <= 4 ; i++)
	{
		SROMC_WordWriteReadTest_pdma(uBank, (Bank_eTiming)uTacs, (Bank_eTiming)uTcos, (Bank_eTiming)uTacc, 
									(Bank_eTiming)uTcoh, (Bank_eTiming)uTcah, (Bank_eTiming)uTacp, ePageMode);
	}

	// Tacp parameter test
	for(uTacp = SROMC_Tacp_MIN ; uTacp <= SROMC_Tacp_MAX ; uTacp++)
	{
		SROMC_WordWriteReadTest_pdma(uBank, (Bank_eTiming)uTacs, (Bank_eTiming)uTcos, (Bank_eTiming)uTacc, 
									(Bank_eTiming)uTcoh, (Bank_eTiming)uTcah, (Bank_eTiming)uTacp, ePageMode);
	}
	uTacp = SROMC_Tacp_TYP;

	// Tcah parameter test
	for(uTcah = SROMC_Tcah_MIN ; uTcah <= SROMC_Tcah_MAX ; uTcah++)
	{
		SROMC_WordWriteReadTest_pdma(uBank, (Bank_eTiming)uTacs, (Bank_eTiming)uTcos, (Bank_eTiming)uTacc, 
									(Bank_eTiming)uTcoh, (Bank_eTiming)uTcah, (Bank_eTiming)uTacp, ePageMode);
	}
	uTcah = SROMC_Tcah_TYP;

	// Tcoh parameter test
	for(uTcoh = SROMC_Tcoh_MIN ; uTcoh <= SROMC_Tcoh_MAX ; uTcoh++)
	{
		SROMC_WordWriteReadTest_pdma(uBank, (Bank_eTiming)uTacs, (Bank_eTiming)uTcos, (Bank_eTiming)uTacc, 
									(Bank_eTiming)uTcoh, (Bank_eTiming)uTcah, (Bank_eTiming)uTacp, ePageMode);
	}
	uTcoh = SROMC_Tcoh_TYP;

	// Tacc parameter test
	for(uTacc = SROMC_Tacc_MIN ; uTacc <= SROMC_Tacc_MAX ; uTacc++)
	{
		SROMC_WordWriteReadTest_pdma(uBank, (Bank_eTiming)uTacs, (Bank_eTiming)uTcos, (Bank_eTiming)uTacc, 
									(Bank_eTiming)uTcoh, (Bank_eTiming)uTcah, (Bank_eTiming)uTacp, ePageMode);
	}
	uTacc = SROMC_Tacc_TYP;

	// Tcos parameter test
	for(uTcos = SROMC_Tcos_MIN ; uTcos <= SROMC_Tcos_MAX ; uTcos++)
	{
		SROMC_WordWriteReadTest_pdma(uBank, (Bank_eTiming)uTacs, (Bank_eTiming)uTcos, (Bank_eTiming)uTacc, 
									(Bank_eTiming)uTcoh, (Bank_eTiming)uTcah, (Bank_eTiming)uTacp, ePageMode);
	}
	uTcos = SROMC_Tcos_TYP;

	// Tacs parameter test
	for(uTacs = SROMC_Tacs_MIN ; uTacs <= SROMC_Tacs_MAX ; uTacs++)
	{
		SROMC_WordWriteReadTest_pdma(uBank, (Bank_eTiming)uTacs, (Bank_eTiming)uTcos, (Bank_eTiming)uTacc, 
									(Bank_eTiming)uTcoh, (Bank_eTiming)uTcah, (Bank_eTiming)uTacp, ePageMode);
	}
	uTacs = SROMC_Tacs_TYP;	

	UART_Printf("\n\n");
}


//////////
// Function Name : SROMC_InitForMultiAccessTest
// Function Description : Simultaneous Access through the EBI
// Version : v0.1
// rb1004
u32 *pMAWriteBaseData, *pMAReadBaseData, *pMAWriteData, *pMAReadData;
u32 *pMABankBaseAddress, *pMAAddress;

void SROMC_InitForMultiWriteTest(SROMC_eBANK uBank, Data_eWidth eDWidth, WAIT_eCTL eWAITCTL, Byte_eCTL eByteCTL)
{
	u32 uTacs, uTcos, uTacc, uTcoh, uTcah, uTacp;
	u32 i;
	
	SROMC_Init();

	SROMC_SetBusWidth( uBank, eDWidth);
	SROMC_SetWaitControl(uBank, eWAITCTL);
	SROMC_SetByteEnable(uBank, eByteCTL);

	pMAWriteBaseData = (u32 *)malloc(SROMC_SRAM_SIZE);
	if(pMAWriteBaseData == 0)
	{
		UART_Printf("Memory Allocation Error...\n");
		return;
	}
	pMAWriteData = pMAWriteBaseData;
	
	pMAReadBaseData = (u32 *)malloc(SROMC_SRAM_SIZE);	
	if(pMAReadBaseData == 0)
	{
		free(pMAWriteBaseData);
		UART_Printf("Memory Allocation Error...\n");
		return;
	}
	pMAReadData = pMAReadBaseData;

	pMABankBaseAddress = (u32 *)((uBank * 0x08000000)+0x80000000);
	pMAAddress = pMABankBaseAddress;

	uTacs = SROMC_Tacs_MIN;
	uTcos = SROMC_Tcos_MIN;
	uTacc = SROMC_Tacc_MIN;
	uTcoh = SROMC_Tcoh_MIN;
	uTcah = SROMC_Tcah_MIN;

	SROMC_SetTiming(uBank, (Bank_eTiming)uTacs, (Bank_eTiming)uTcos, (Bank_eTiming)uTacc, 
								(Bank_eTiming)uTcoh, (Bank_eTiming)uTcah, (Bank_eTiming)uTacp, eNor_Mode);
	DelayfrTimer(milli, 1);
	
	pMAWriteData = pMAWriteBaseData;
	
	srand(uTacs + uTcos + uTacc + uTcoh + uTcah + uTacp);

	for(i=0; i<SROMC_SRAM_SIZE/4; i++)
	{
#if(SROMC_DATA_PATTERN == SROMC_DATA_RANDOM)
		*pMAWriteData++ = rand();
#else	// ONDT_DATA_PATTERN == ONDT_DATA_ONEVALUE
		*pMAWriteData++ = SROMC_DATA_ONEVALUE;
#endif
	}
}


void SROMC_MultiWriteTest(void)
{
	//DMA0 controller

	INTC_SetVectAddr(NUM_MDMA,  SROMC_DmaISR);
	INTC_Enable(NUM_MDMA);

//	DMAC_InitCh(DMA0, DMA_ALL, &g_oSROMCDmac0);
//	INTC_SetVectAddr(NUM_DMA0,  SROMC_MADmaISR);
//	INTC_Enable(NUM_DMA0);
	
	/////////////////////////////////
	// Write from DRAM to SRAM memory
	/////////////////////////////////
	pMAWriteData = pMAWriteBaseData;
	pMAAddress = pMABankBaseAddress;
	
	SROMC_DmaDone = 0;

	DMA_SetCh(DMA_20,&g_oSROMCDmac0);
	DMA_InitCh(WORD, SOFTWARE, DMA_M2M, BURST4, &g_oSROMCDmac0);


//	DMACH_Setup(DMA_A, 0, (u32)pMAWriteData, 0, (u32)pMAAddress, 0, WORD, SROMC_SRAM_SIZE/4, DEMAND, MEM, MEM, BURST4, &g_oSROMCDmac0);
}


void SROMC_StartMultiWriteTest(void)
{
	DMA_StartCh((u32)pMAWriteData, (u32)pMAAddress, SROMC_SRAM_SIZE/4,&g_oSROMCDmac0);

	//DMACH_Start(&g_oSROMCDmac0);
}


void SROMC_CheckDoneMultiWriteTest(void)
{
	while(!SROMC_DmaDone);
}


void SROMC_MultiReadTest(void)
{
	//DMA0 controller
	INTC_SetVectAddr(NUM_MDMA,  SROMC_DmaISR);
	INTC_Enable(NUM_MDMA);

	
//	DMAC_InitCh(DMA0, DMA_ALL, &g_oSROMCDmac0);
//	INTC_SetVectAddr(NUM_DMA0,  SROMC_DmaISR);
//	INTC_Enable(NUM_DMA0);

	/////////////////////////////////
	// Read from SRAM memory to DRAM
	/////////////////////////////////
	
	pMAReadData = pMAReadBaseData;
	pMAAddress = pMABankBaseAddress;

	SROMC_DmaDone = 0;

	DMA_SetCh(DMA_20,&g_oSROMCDmac0);
	DMA_InitCh(WORD, SOFTWARE, DMA_M2M, BURST4, &g_oSROMCDmac0);

	
	//DMACH_Setup(DMA_A, 0, (u32)pMAAddress, 0, (u32)pMAReadData, 0, WORD, SROMC_SRAM_SIZE/4, DEMAND, MEM, MEM, BURST4, &g_oSROMCDmac0);
}


void SROMC_StartMultiReadTest(void)
{
	DMA_StartCh((u32)pMAAddress, (u32)pMAReadData, SROMC_SRAM_SIZE,&g_oSROMCDmac0);

	//DMACH_Start(&g_oSROMCDmac0);
}


void SROMC_CheckDoneMultiReadTest(void)
{
	while(!SROMC_DmaDone);
}


void SROMC_VerifyMultiAccessTest(void)
{
	u32 i;
	u8 bError = FALSE;
	
	/////////////////////////////////
	// Compare Data
	/////////////////////////////////
	pMAReadData = pMAReadBaseData;
	pMAWriteData = pMAWriteBaseData;
	pMAAddress = pMABankBaseAddress;
	bError = FALSE;
	
	for(i=0 ; i<SROMC_SRAM_SIZE/4 ; i++)
	{
		if(pMAReadData[i] != pMAWriteData[i])
		{
			UART_Printf("\t [Address: 0x%08x] [Write data : Read data] = [0x%08x  : 0x%08x ]  \n", pMAAddress, pMAWriteData[i], pMAReadData[i]);
			UART_Getc();
			bError = TRUE;
			break;
		}
		pMAAddress++;
	}
	if(bError == FALSE)
		UART_Printf("SROMC Test OK\n");	

	pMAWriteData = pMAWriteBaseData;
	pMAAddress = pMABankBaseAddress;
	
	for(i=0; i<SROMC_SRAM_SIZE/4; i++)
	{
		*pMAWriteData++ = 0;
		*pMAAddress++ = 0;
	}

	free(pMAWriteBaseData);
	free(pMAReadBaseData);

}


void SROMC_MultiAccessTestExample(void)
{
	SROMC_InitForMultiWriteTest(eBank1, e16bit, eDis_WAIT, eEn_CTL);
	SROMC_MultiWriteTest();
	// External IP DMA Write Start 
	SROMC_CheckDoneMultiWriteTest();
	// External IP DMA Write done check
	
	SROMC_MultiReadTest();
	// External IP DMA Read Start 
	SROMC_CheckDoneMultiReadTest();
	// External IP DMA Read done check

	SROMC_VerifyMultiAccessTest();
}





///////////////////////////////////////////////////////////////////////////////////
////////////////////                    SMC Main Test                  /////////////////////////// 
///////////////////////////////////////////////////////////////////////////////////
//extern void Test_LAN9115(void);
const testFuncMenu smc_menu[] =
{
		SROMC_Test,					"SROMC Test",
		SROMC_ByteAccess,			"SROMC Byte Access",
		DM9000_8bit_Test,			 	"DM9000 8bit access",
		DM9000_16bit_Test,			"DM9000 16bit access",
		SROMC_HalfWordAccess,		"SROMC Half-Word Access",
		SROMC_DWordAccess,		"SROMC Double-Word Access(64bit-16burst-MDMA)",
		SROMC_WordAccess_pdma, 	"SROMC Word Access(32bit-8burst-PDMA)",
		DM9000_WRITE,				"DM9000 write",
		DM9000_READ,				"DM9000 read",
		ProgramAM29F800,			"Program NOR",
		DM9000_16bit_Test_autotest, "DM9000 Auto test",
		0,0
};


void SMC_Test(void)
{
	u32 i;
	s32 uSel;

	UART_Printf("[SROMC_Test]\n\n");
	
	SROMC_Init();
//	SYSC_CtrlHCLKGate( eHCLK_DMC0	, 0);
//	DelayfrTimer(milli, 10);
//	SYSC_CtrlHCLKGate( eHCLK_DMC0	, 1);
//	DelayfrTimer(milli, 10);
	
	while(1)
	{
		for (i=0; (u32)(smc_menu[i].desc)!=0; i++)
			UART_Printf("%2d: %s\n", i, smc_menu[i].desc);

		UART_Printf("\nSelect the function to test : ");
		uSel =UART_GetIntNum();
		UART_Printf("\n");
		if(uSel == -1) 
			break;
		if (uSel>=0 && uSel<(sizeof(smc_menu)/8-1))
			(smc_menu[uSel].func) ();
	}
}	
bool DM9000_16bit_Test_autotest(void)
{
	u32 uTacs, uTcos, uTacc, uTcoh, uTcah, uTacp;
	u32* reg_temp;
	SROMC_eBANK uBank;
	Data_eWidth eDWidth;
	WAIT_eCTL eWAITCTL;
	Byte_eCTL eByteCTL;
	Page_eMode ePageMode;
	Addr_eMode eAddrMode;
	
	
	u16 IDlow;
	u16 IDhigh;
	u16 ID2low;
	u16 ID2high;
	u16 io_mode;

	u32 ID;

	
	volatile u8 *pBank5BaseAddress,  *index5_Address, *data5_Address;


	UART_Printf("[DM9000 16bit Access]\n");
	SROMC_Init();

	uBank = 5; 
	if(uBank > 5)
		uBank = (SROMC_eBANK)0;

	UART_Printf("BANK 5 is used. \n", uBank);

	
	eDWidth = e16bit; 	
	if(eDWidth > 1)
		eDWidth = (Data_eWidth)1;

	eWAITCTL = eDis_WAIT; 
	if(eWAITCTL > 1)
		eWAITCTL = (WAIT_eCTL)0;

	eByteCTL = eDis_CTL; 
	if(eByteCTL > 1)
		eByteCTL = (Byte_eCTL)0;

	ePageMode = eNor_Mode; 
	if(ePageMode > 1)
		ePageMode = (Page_eMode)0;

	eAddrMode = eHalfword_Mode;
	SROMC_SetAddrMode(uBank,eAddrMode);
	
	SROMC_SetBusWidth( uBank, eDWidth);
	SROMC_SetWaitControl(uBank, eWAITCTL);
	SROMC_SetByteEnable(uBank, eByteCTL);
	
	
	uTacs = SROMC_Tacs_MIN;
	uTcos = SROMC_Tcos_MIN;
	uTacc = SROMC_Tacc_MIN;
	uTcoh = SROMC_Tcoh_MIN;
	uTcah = SROMC_Tcah_MIN;
	uTacp = SROMC_Tacp_MIN;

	uTacs = 8;
	uTcos = 3;
	uTacc = 6;
	uTcoh = 2;
	uTcah = 8;
	uTacp = 2;





	reg_temp = (u32*)0xE02002E0;
	*reg_temp = 0x22222222;  //      MP0_1CON
	
	reg_temp = (u32*)0xE0200300;
	*reg_temp = 0x22222222;  //      MP0_2CON
	
	reg_temp = (u32*)0xE0200340;
	*reg_temp = 0x22222222;  //      MP0_4CON

	reg_temp = (u32*)0xE0200380;
	*reg_temp = 0x22222222;  //      MP0_6CON
	
	reg_temp = (u32*)0xE02003A0;
	*reg_temp = 0x22222222;  //      MP0_6CON
	

	 	GPIO_SetDSAll(eGPIO_MP0_1,0x0000ffff);
	 	GPIO_SetDSAll(eGPIO_MP0_2,0x0000ffff);
	 	GPIO_SetDSAll(eGPIO_MP0_3,0x0000ffff);
	 	GPIO_SetDSAll(eGPIO_MP0_4,0x0000ffff);
		GPIO_SetDSAll(eGPIO_MP0_5,0x0000ffff);
		GPIO_SetDSAll(eGPIO_MP0_6,0x0000ffff);
		GPIO_SetDSAll(eGPIO_MP0_7,0x0000ffff);
		
		UART_Printf("Tacs(%d), Tcos(%d), Tacc(%d), Tcoh(%d), Tcah(%d), Tacp(%d)\n", uTacs, uTcos, uTacc, uTcoh, uTcah, uTacp);
		SROMC_SetTiming(uBank, (Bank_eTiming)uTacs,(Bank_eTiming)uTcos,(Bank_eTiming)uTacc, (Bank_eTiming)uTcoh,(Bank_eTiming)uTcah,(Bank_eTiming) uTacp, ePageMode);
		DelayfrTimer(milli, 1);

		g_DM9000_BASE16 = (volatile u16*)0xa8000000;
		IDlow = ReadReg16(DM9000_VIDL);
		IDhigh = ReadReg16(DM9000_VIDH);
		ID2low = ReadReg16(DM9000_PIDL);
		ID2high = ReadReg16(DM9000_PIDH);
			
		UART_Printf(" ---------BANK5-------- \n");
		DM9000DEBUG(("IDlow=0x%x\n",IDlow));
		DM9000DEBUG(("IDhigh=0x%x\n",IDhigh));
		DM9000DEBUG(("ID2low=0x%x\n",ID2low));
		DM9000DEBUG(("ID2high=0x%x\n",ID2high));

		ID = IDlow | (IDhigh<<8) | (ID2low<<16) |(ID2high<<24);

		if(ID==DM9000_ID)
		{
			DM9000DEBUG(("ID ok\n"));
			return true;
		}
		else
		{
			DM9000DEBUG(("ID fail\n"));
			return false;
		}
		

}

