/**************************************************************************************
* 
*	Project Name : S3C6410 Validation
*
*	Copyright 2006 by Samsung Electronics, Inc.
*	All rights reserved.
*
*	Project Description :
*		This software is only for validating functions of the S3C6410.
*		Anybody can use this software without our permission.
*  
*--------------------------------------------------------------------------------------
* 
*	File Name : dmc.h
*  
*	File Description : This file implements the API functons for Static Memory controller.
*
*	Author : Wonjoon.jang
*	Dept. : AP Development Team
*	Created Date : 2007/01/06
*	Version : 0.1 
* 
*	History
*	- Created(Wonjoon.jang 2007/01/06)
*  
**************************************************************************************/
#ifndef __SROMC_H__
#define __SROMC_H__


#ifdef __cplusplus
extern "C" {
#endif

#include <stdio.h>

#include "def.h"
#include "dma.h"

#define		MEMIF_NUM		5
#if  0
typedef struct EBI_Inform
{
//	u8			ucRecDone;	
	u8			ucIntNum;
	
	DMA_UNIT	eDMACon;	
	DMA_CH		eDMACh;
	u32			uLLIBaseAddr;		
	u32			uSrcAddr;
	u32			uDstAddr;
	u8			bSrcFixed;
	u8			bDstFixed;
	DATA_SIZE	eDataSz;
	u32			uDataCnt;
	DREQ_SRC	eSrcReq;
	DREQ_SRC	eDstReq;
	BURST_MODE	eBurstMode;
	DMAC		oEBIDma;

	void 		(* pHandler)(void) __irq;
}
EBI_oInform;
#endif
typedef enum Mem_Type
{
	eMEM_DMC0		=	0,
	eMEM_NAND		=	1,	
	eMEM_SROMC	=	2,
	eMEM_OneNAND	=	3,	
	eMEM_CF		=	4,	
}Mem_eType;

#if 0
typedef enum Bank_Timing
{
	eCLK0	=	0,	
	eCLK1	=	0,		// Tacc Only
	eCLK2	=	1,	
	eCLK3	= 	2,
	eCLK4	= 	3,
	eCLK5	= 	4,
	eCLK6	= 	5,
	eCLK7	= 	6,
	eCLK8	= 	7,
	eCLK9	= 	8,
	eCLK10	= 	9,
	eCLK11	= 	10,
	eCLK12	= 	11,
	eCLK13	= 	12,
	eCLK14	= 	13,
	eCLK15	= 	14,
	eCLK16	= 	15,
	eCLK17	= 	16,
	eCLK18	= 	17,
	eCLK19	= 	18,
	eCLK20	= 	19,
	eCLK21	= 	20,
	eCLK22	= 	21,
	eCLK23	= 	22,
	eCLK24	= 	23,
	eCLK25	= 	24,
	eCLK26	= 	25,
	eCLK27	= 	26,
	eCLK28	= 	27,
	eCLK29	= 	28,
	eCLK30	= 	29,
	eCLK31	= 	30,
	eCLK32	=	31
}Bank_eTiming;
#else
typedef enum Bank_Timing
{
	eCLK0	=	0,	
	eCLK1	=	1,		// Tacc Only
	eCLK2	=	2,	
	eCLK3	= 	3,
	eCLK4	= 	4,
	eCLK5	= 	5,
	eCLK6	= 	6,
	eCLK7	= 	7,
	eCLK8	= 	8,
	eCLK9	= 	9,
	eCLK10	= 	10,
	eCLK11	= 	11,
	eCLK12	= 	12,
	eCLK13	= 	13,
	eCLK14	= 	14,
	eCLK15	= 	15,
	eCLK16	= 	16,
	eCLK17	= 	17,
	eCLK18	= 	18,
	eCLK19	= 	19,
	eCLK20	= 	20,
	eCLK21	= 	21,
	eCLK22	= 	22,
	eCLK23	= 	23,
	eCLK24	= 	24,
	eCLK25	= 	25,
	eCLK26	= 	26,
	eCLK27	= 	27,
	eCLK28	= 	28,
	eCLK29	= 	29,
	eCLK30	= 	30,
	eCLK31	= 	31,
	eCLK32	=	32
}Bank_eTiming;

#endif

typedef enum Page_Mode
{
	eNor_Mode	=	0,	
	eD4_Mode	=	1,		
}Page_eMode;

typedef enum Addr_Mode
{
	eHalfword_Mode	=	0,		// SRAM_addr[22:0] <= HADDR[23:1]
	eBytebase_Mode	=	1,		// SRAM_addr[22:0] <= HADDR[22:0]
}Addr_eMode;


typedef enum Byte_CTL
{
	eDis_CTL	=	0,	
	eEn_CTL		=	1
}Byte_eCTL;

typedef enum WAIT_CTL
{
	eDis_WAIT		=	0,	
	eEn_WAIT		=	1
}WAIT_eCTL;

typedef enum Data_Width
{
	e8bit		=	0,	
	e16bit		=	1
}Data_eWidth;

typedef enum SROMC_BANK
{
	eBank0		= 0,
	eBank1		= 1,
	eBank2		= 2,
	eBank3		= 3,
	eBank4		= 4,
	eBank5		= 5,	
	eBankMAX	= 5
}SROMC_eBANK;

extern u32 bank_of_nor;
extern volatile unsigned int downloadFileSize;


void	SROMC_Init(void);
void	SROMC_SetBusWidth(SROMC_eBANK uBank, Data_eWidth eDWidth);
void	SROMC_SetWaitControl(SROMC_eBANK uBank, WAIT_eCTL eWAITCTL);
void	SROMC_SetByteEnable(SROMC_eBANK uBank, Byte_eCTL eByteCTL);
void SROMC_SetAddrMode(SROMC_eBANK uBank,Addr_eMode eAddrMode);
void SROMC_SetTiming(	SROMC_eBANK uBank, Bank_eTiming eTacs, Bank_eTiming eTcos,Bank_eTiming eTacc, 
							 					Bank_eTiming eTcoh, Bank_eTiming eTcah, Bank_eTiming eTacp,
							 					Page_eMode ePageMode);

void	SROMC_SetBank(u8 , Byte_eCTL , WAIT_eCTL , Data_eWidth , Page_eMode,
	Bank_eTiming , Bank_eTiming ,Bank_eTiming , Bank_eTiming , Bank_eTiming , Bank_eTiming );

void EBI_SetDMAParams(Mem_eType );
void SMC_SetLLI(u32 , u32 , DATA_SIZE , BURST_MODE , u32 );
void EBI_CloseDMA(Mem_eType );

void SetGPIO_SROM_ADDR_16_22(void);



/*
 * dm9000 Ethernet
 */

//#ifdef CONFIG_DRIVER_DM9000

#define DM9000_ID		0x90000A46
#define DM9000_PKT_MAX		1536	/* Received packet max size */
#define DM9000_PKT_RDY		0x01	/* Packet ready to receive */

/* although the registers are 16 bit, they are 32-bit aligned.
 */

#define DM9000_NCR             0x00
#define DM9000_NSR             0x01
#define DM9000_TCR             0x02
#define DM9000_TSR1            0x03
#define DM9000_TSR2            0x04
#define DM9000_RCR             0x05
#define DM9000_RSR             0x06
#define DM9000_ROCR            0x07
#define DM9000_BPTR            0x08
#define DM9000_FCTR            0x09
#define DM9000_FCR             0x0A
#define DM9000_EPCR            0x0B
#define DM9000_EPAR            0x0C
#define DM9000_EPDRL           0x0D
#define DM9000_EPDRH           0x0E
#define DM9000_WCR             0x0F

#define DM9000_PAR             0x10
#define DM9000_MAR             0x16

#define DM9000_GPCR			0x1e
#define DM9000_GPR             0x1f
#define DM9000_TRPAL           0x22
#define DM9000_TRPAH           0x23
#define DM9000_RWPAL           0x24
#define DM9000_RWPAH           0x25

#define DM9000_VIDL            0x28
#define DM9000_VIDH            0x29
#define DM9000_PIDL            0x2A
#define DM9000_PIDH            0x2B

#define DM9000_CHIPR           0x2C
#define DM9000_SMCR            0x2F

#define DM9000_PHY		0x40	/* PHY address 0x01 */

#define DM9000_MRCMDX          0xF0
#define DM9000_MRCMD           0xF2
#define DM9000_MRRL            0xF4
#define DM9000_MRRH            0xF5
#define DM9000_MWCMDX			0xF6
#define DM9000_MWCMD           0xF8
#define DM9000_MWRL            0xFA
#define DM9000_MWRH            0xFB
#define DM9000_TXPLL           0xFC
#define DM9000_TXPLH           0xFD
#define DM9000_ISR             0xFE
#define DM9000_IMR             0xFF

#define NCR_EXT_PHY		(1<<7)
#define NCR_WAKEEN		(1<<6)
#define NCR_FCOL		(1<<4)
#define NCR_FDX			(1<<3)
#define NCR_LBK			(3<<1)
#define NCR_RST			(1<<0)

#define NSR_SPEED		(1<<7)
#define NSR_LINKST		(1<<6)
#define NSR_WAKEST		(1<<5)
#define NSR_TX2END		(1<<3)
#define NSR_TX1END		(1<<2)
#define NSR_RXOV		(1<<1)

#define TCR_TJDIS		(1<<6)
#define TCR_EXCECM		(1<<5)
#define TCR_PAD_DIS2	(1<<4)
#define TCR_CRC_DIS2	(1<<3)
#define TCR_PAD_DIS1	(1<<2)
#define TCR_CRC_DIS1	(1<<1)
#define TCR_TXREQ		(1<<0)

#define TSR_TJTO		(1<<7)
#define TSR_LC			(1<<6)
#define TSR_NC			(1<<5)
#define TSR_LCOL		(1<<4)
#define TSR_COL			(1<<3)
#define TSR_EC			(1<<2)

#define RCR_WTDIS		(1<<6)
#define RCR_DIS_LONG	(1<<5)
#define RCR_DIS_CRC		(1<<4)
#define RCR_ALL			(1<<3)
#define RCR_RUNT		(1<<2)
#define RCR_PRMSC		(1<<1)
#define RCR_RXEN		(1<<0)

#define RSR_RF			(1<<7)
#define RSR_MF			(1<<6)
#define RSR_LCS			(1<<5)
#define RSR_RWTO		(1<<4)
#define RSR_PLE			(1<<3)
#define RSR_AE			(1<<2)
#define RSR_CE			(1<<1)
#define RSR_FOE			(1<<0)

#define FCTR_HWOT(ot)	(( ot & 0xf ) << 4 )
#define FCTR_LWOT(ot)	( ot & 0xf )

#define IMR_PAR			(1<<7)
#define IMR_ROOM		(1<<3)
#define IMR_ROM			(1<<2)
#define IMR_PTM			(1<<1)
#define IMR_PRM			(1<<0)

//#endif





#ifdef __cplusplus
}
#endif

#endif //__SROMC_H__



