;/*************************************************************************************
; 
;	Project Name : S3C6400 Validation
;
;	Copyright 2006 by Samsung Electronics, Inc.
;	All rights reserved.
;
;	Project Description :
;		This software is only for validating functions of the S3C6400.
;		Anybody can use this software without our permission.
;  
;--------------------------------------------------------------------------------------
; 
;	File Name : memcpy_lib.s
;  
;	File Description : This file implements memcpy
;
;	Author	: Haksoo,Kim
;	Dept. : AP Development Team
;	Created Date : 2006/11/08
;	Version : 0.1 
; 
;	History
;	- Created(Haksoo,Kim 2006/11/08)
;  
;*************************************************************************************/

;				GET		option.inc
				

;				AREA	|C$$code|, CODE, READONLY
				AREA	|.text|, CODE, READONLY

;;;void burst2_memcpy(void *DAddr, void *SAddr, u32 Size); // implementation by assembly in memcpy_lib.s
				EXPORT	_burst2_memcpy
_burst2_memcpy
				; r0 : Destination Address
				; r1 : Source Address
				; r2 : Size
				stmdb	r13!,{r0-r2,r11-r12,lr}
				mov		r2, r2, LSR #3
loop2				
				ldmia	r1!,{r11-r12}					; 
				stmia	r0!,{r11-r12}					; 
				subs		r2,r2,#0x1					; Count decrement
				bne		loop2	 
 
				ldmia	r13!,{r0-r2,r11-r12,pc}


;;;void burst4_memcpy(void *DAddr, void *SAddr, u32 Size); // implementation by assembly in memcpy_lib.s
				EXPORT	_burst4_memcpy
_burst4_memcpy
				; r0 : Destination Address
				; r1 : Source Address
				; r2 : Size
				stmdb	r13!,{r0-r2,r9-r12,lr}
				mov		r2, r2, LSR #4
loop4				
				ldmia	r1!,{r9-r12}					; 
				stmia	r0!,{r9-r12}					; 
				subs		r2,r2,#0x1					; Count decrement
				bne		loop4	 
 
				ldmia	r13!,{r0-r2,r9-r12,pc}


;;;;void burst8_memcpy(void *DAddr, void *SAddr, u32 Size);
				EXPORT _burst8_memcpy
_burst8_memcpy
				; r0 : Destination Address
				; r1 : Source Address
				; r2 : Size
				stmdb	r13!,{r0-r2,r5-r12,lr}
				mov		r2, r2, LSR #5
loop8				
				ldmia	r1!,{r5-r12}					; 
				stmia	r0!,{r5-r12}					; 
				subs		r2,r2,#0x1					; Count decrement
				bne		loop8	 
 
				ldmia	r13!,{r0-r2,r5-r12,pc}

				
;;;void burst2_memcpy_writeonly(void *DAddr, u32 Size); // implementation by assembly in memcpy_lib.s
				EXPORT _burst2_memcpy_writeonly
_burst2_memcpy_writeonly
				; r0 : Destination Address
				; r1 : Size
				stmdb	r13!,{r0-r5,r9-r12,lr}
				mov		r1, r1, LSR #3
				mov		r2,#0
				mov		r3,#0xFFFFFFFF
loop2_w				
				stmia	r0!,{r2-r3}					; 
				subs		r1,r1,#0x1					; Count decrement
				bne		loop2_w		 
 
				ldmia	r13!,{r0-r5,r9-r12,pc}
	
				
;;;void burst4_memcpy_writeonly(void *DAddr, u32 Size); // implementation by assembly in memcpy_lib.s
				EXPORT _burst4_memcpy_writeonly
_burst4_memcpy_writeonly
				; r0 : Destination Address
				; r1 : Size
				stmdb	r13!,{r0-r5,r9-r12,lr}
				mov		r1, r1, LSR #4
				mov		r2,#0
				mov		r3,#0xFFFFFFFF
				mov		r4,#0
				mov		r5,#0xFFFFFFFF
loop4_w				
				stmia	r0!,{r2-r5}					; 
				subs		r1,r1,#0x1					; Count decrement
				bne		loop4_w	 
 
				ldmia	r13!,{r0-r5,r9-r12,pc}


;;;void burst8_memcpy_writeonly(void *DAddr, u32 Size); // implementation by assembly in memcpy_lib.s
				EXPORT _burst8_memcpy_writeonly
_burst8_memcpy_writeonly
				; r0 : Destination Address
				; r1 : Size
				stmdb	r13!,{r0-r12,lr}
				mov		r1, r1, LSR #5
				mov		r2,#0
				mov		r3,#0xFFFFFFFF
				mov		r4,#0
				mov		r5,#0xFFFFFFFF
				mov		r6,#0
				mov		r7,#0xFFFFFFFF
				mov		r8,#0
				mov		r9,#0xFFFFFFFF
loop8_w				
				stmia	r0!,{r2-r9}					; 
				subs		r1,r1,#0x1					; Count decrement
				bne		loop8_w	 
 
				ldmia	r13!,{r0-r12,pc}


;;;void single_memcpy(void *DAddr, void *SAddr, u32 Size); // implementation by assembly in memcpy_lib.s
				EXPORT	_single_memcpy
_single_memcpy
				; r0 : Destination Address
				; r1 : Source Address
				; r2 : Size
				stmdb	r13!,{r0-r2,r11,lr}
				mov		r2, r2, LSR #2
loop_s				
				ldm		r1!,{r11}					; 
				stm		r0!,{r11}					; 
				subs		r2,r2,#0x1					; Count decrement
				bne		loop_s	 
 
				ldmia	r13!,{r0-r2,r11,pc}


	  
				LTORG
   
				END
