


			GET		dmc.inc

			EXPORT	InitDMC

			CODE32
			AREA    dmc_init, CODE, READONLY
;-----------------------------------------------------------------------------
;   DMC0 Clock Setting
;-----------------------------------------------------------------------------
	ldr r0, =0xE0100218 
	ldr r1, =0x01000000 
	str r1, [r0]         ;	CLK_SRC6[25:24] -> OneDRAM clock sel = MPLL
	
	ldr r0, =0xE0100318 
	ldr r1, =0x00000000 
	str r1, [r0]         ;	CLK_DIV6[31:28] -> 4=1/5, 3=1/4(166MHZ@667MHz), 2=1/3



;-----------------------------------------------------------------------------
;   lpdmc Initialization
;-----------------------------------------------------------------------------
InitDMC

	IF	:DEF: DMC0  ;;;; Initialize DMC0

;;	IF	:DEF: ENABLE_DLL  ;;;; Enable DLL

			;PHY control
			ldr r2, =DMC0_SET_PHY_REG
			ldr	r0,	=DMC0_PHY_CONTROL0
			ldr	r1,	[r2]	;DLL parameter set
			str	r1,	[r0]

			add r2, r2, #4
			ldr	r0,	=DMC0_PHY_CONTROL1		
			ldr	r1,	[r2]	;DLL parameter set
			str	r1,	[r0]

			add r2, r2, #4
			ldr	r0,	=DMC0_PHY_CONTROL2
			ldr	r1,	[r2]	;DLL parameter set
			str	r1,	[r0]

			ldr	r0,	=DMC0_PHY_CONTROL0
			ldr	r1,	[r0]	
			orr r1, r1, #(1<<1)	;DLL on
			str	r1,	[r0]

			orr	r1,	r1, #(1<<0)	;DLL start
			str	r1,	[r0]

 			;PHY off
			ldr r0, =DMC0_PHY_STATUS0
0       
			ldr r1, [r0]		;check PLL lock 
			ands r1, r1, #3 
			bne %B0 

			ldr	r0,	=DMC0_PHY_CONTROL0
			ldr r1, [r0]
			orr	r1,	r1, #(0x6A<<24)	;forcing locking value for DLL off
			str	r1,	[r0]

			bic	r1,	r1, #(1<<1)	;DLL off
			str	r1,	[r0]

  			;MEMORY setting
			ldr r2, =DMC0_SET_MEM_REG
			ldr	r0,	=DMC0_CON_CONTROL
			ldr	r1,	[r2] 		;auto refresh off
			str	r1,	[r0]

			add r2, r2, #4
			ldr	r0,	=DMC0_MEM_CONTROL
			ldr	r1,	[r2]		;DDR2 type, dynamic self refresh off,force precharge off,dynamic power down off
			str	r1,	[r0]

			add r2, r2, #4
			ldr	r0,	=DMC0_MEM_CONFIG0
			ldr	r1,	[r2]		
			str	r1,	[r0]

			add r2, r2, #4
			ldr	r0,	=DMC0_MEM_CONFIG1
			ldr	r1,	[r2]	
			str	r1,	[r0]

			add r2, r2, #4
			ldr	r0,	=DMC0_PRECH_CONFIG
			ldr	r1,	[r2]	
			str	r1,	[r0]

			add r2, r2, #4
			ldr	r0,	=DMC0_PWRDN_CONFIG
			ldr	r1,	[r2]
			str	r1,	[r0]
			
			add r2, r2, #4
			ldr	r0,	=DMC0_TIMING_AREF
			ldr	r1,	[r2]
			str	r1,	[r0]

			add r2, r2, #4
			ldr	r0,	=DMC0_TIMING_ROW
			ldr	r1,	[r2]
			str	r1,	[r0]

			add r2, r2, #4
			ldr	r0,	=DMC0_TIMING_DATA
			ldr	r1,	[r2]
			str	r1,	[r0]

			add r2, r2, #4
			ldr	r0,	=DMC0_TIMING_POWER
			ldr	r1,	[r2]
			str	r1,	[r0]

			; initializing QoS as 0x00FF0000
			mov r2, #8
			ldr	r0,	=DMC0_QOS_CONTROL0
1
			ldr	r1,	=0x00FF0000	;
			str	r1,	[r0]
			add r0, r0, #8
			subs r2, r2, #1
			bne %B1

			mov r2, #8
			ldr	r0,	=DMC0_QOS_CONFIG0
2
			ldr	r1,	=0x00000000	;
			str	r1,	[r0]
			add r0, r0, #8
			subs r2, r2, #1
			bne %B2

	 
			;Direct command

			mov r2, #10		 ;; for LPDDR
			ldr r0, =DMC0_DIRECT_CMD
			ldr r3, =DMC0_LPDDR_CMD
3
			ldr r1, [r3]			
			str r1, [r0]
			add r3, r3, #4
			subs r2, r2, #1
			bne %B3
			
			
			;Change control for using memory
			ldr	r0,	=DMC0_CON_CONTROL
			ldr	r1,	[r0]
			orr r1, r1, #(1<<5)		;auto refresh on
			str	r1,	[r0]
			
			ldr	r0,	=DMC0_MEM_CONTROL
			ldr	r1,	[r0]
			bic r1, r1, #0xff
;;;			orr	r1,	r1, #0x32		;dynamic self refresh, force precharge, dynamic power down on
			str r1,	[r0]


;; Write test.....	
;			ldr	r0, =0xc8000000
;			ldr	r3, =0xc8000010	
;10	
;			ldr	r1, =0x12345678;
;			str	r1, [r0]
;			str r1, [r3]	
;			NOP
;			b	%10


	ENDIF ;; End of DMC0 Initialize

	IF	:DEF: DMC1  ;;;; Initialize DMC1

;;	IF	:DEF: ENABLE_DLL  ;;;; Enable DLL
    
			;PHY control
			ldr r2, =DMC1_SET_PHY_REG
			ldr	r0,	=DMC1_PHY_CONTROL0
			ldr	r1,	[r2]	;DLL parameter set
			str	r1,	[r0]

			add r2, r2, #4
			ldr	r0,	=DMC1_PHY_CONTROL1		
			ldr	r1,	[r2]	;DLL parameter set
			str	r1,	[r0]

			add r2, r2, #4
			ldr	r0,	=DMC1_PHY_CONTROL2
			ldr	r1,	[r2]	;DLL parameter set
			str	r1,	[r0]

			ldr	r0,	=DMC1_PHY_CONTROL0
			ldr	r1,	[r0]	
			orr r1, r1, #(1<<1)	;DLL on
			str	r1,	[r0]

			orr	r1,	r1, #(1<<0)	;DLL start
			str	r1,	[r0]

 			;PHY off
			ldr r0, =DMC1_PHY_STATUS0
0       
			ldr r1, [r0]		;check PLL lock 
			ands r1, r1, #3 
			bne %B0 

			ldr	r0,	=DMC1_PHY_CONTROL0
			ldr r1, [r0]
			orr	r1,	r1, #(0x6A<<24)	;forcing locking value for DLL off
			str	r1,	[r0]

			bic	r1,	r1, #(1<<1)	;DLL off
			str	r1,	[r0]

			;MEMORY setting
			ldr r2, =DMC1_SET_MEM_REG
			ldr	r0,	=DMC1_CON_CONTROL
			ldr	r1,	[r2] 		;auto refresh off
			str	r1,	[r0]

			add r2, r2, #4
			ldr	r0,	=DMC1_MEM_CONTROL
			ldr	r1,	[r2]		;DDR2 type, dynamic self refresh off,force precharge off,dynamic power down off
			str	r1,	[r0]

			add r2, r2, #4
			ldr	r0,	=DMC1_MEM_CONFIG0
			ldr	r1,	[r2]		
			str	r1,	[r0]

			add r2, r2, #4
			ldr	r0,	=DMC1_MEM_CONFIG1
			ldr	r1,	[r2]	
			str	r1,	[r0]

			add r2, r2, #4
			ldr	r0,	=DMC1_PRECH_CONFIG
			ldr	r1,	[r2]	
			str	r1,	[r0]

			add r2, r2, #4
			ldr	r0,	=DMC1_PWRDN_CONFIG
			ldr	r1,	[r2]
			str	r1,	[r0]
			
			add r2, r2, #4
			ldr	r0,	=DMC1_TIMING_AREF
			ldr	r1,	[r2]
			str	r1,	[r0]

			add r2, r2, #4
			ldr	r0,	=DMC1_TIMING_ROW
			ldr	r1,	[r2]
			str	r1,	[r0]

			add r2, r2, #4
			ldr	r0,	=DMC1_TIMING_DATA
			ldr	r1,	[r2]
			str	r1,	[r0]

			add r2, r2, #4
			ldr	r0,	=DMC1_TIMING_POWER
			ldr	r1,	[r2]
			str	r1,	[r0]

			; initializing QoS as 0x00FF0000
			mov r2, #8
			ldr	r0,	=DMC1_QOS_CONTROL0
1
			ldr	r1,	=0x00FF0000	;
			str	r1,	[r0]
			add r0, r0, #8
			subs r2, r2, #1
			bne %B1

			mov r2, #8
			ldr	r0,	=DMC1_QOS_CONFIG0
2
			ldr	r1,	=0x00000000	;
			str	r1,	[r0]
			add r0, r0, #8
			subs r2, r2, #1
			bne %B2

	 
			;Direct command

			mov r2, #10		 ;; for LPDDR
			ldr r0, =DMC1_DIRECT_CMD
			ldr r3, =DMC1_LPDDR_CMD

3
			ldr r1, [r3]			
			str r1, [r0]
			add r3, r3, #4
			subs r2, r2, #1
			bne %B3
			
			
			;Change control for using memory
			ldr	r0,	=DMC1_CON_CONTROL
			ldr	r1,	[r0]
			orr r1, r1, #(1<<5)		;auto refresh on
			str	r1,	[r0]
			
			ldr	r0,	=DMC1_MEM_CONTROL
			ldr	r1,	[r0]
			bic r1, r1, #0xff
;;;			orr	r1,	r1, #0x32		;dynamic self refresh, force precharge, dynamic power down on
			str r1,	[r0]


;; Write test.....	
;			ldr	r0, =0xc8000000
;			ldr	r3, =0xc8000010	
;10	
;			ldr	r1, =0x12345678;
;			str	r1, [r0]
;			str r1, [r3]	
;			NOP
;			b	%10

	ENDIF ;; End of DMC1 Initialize
;;_InitLpdmc end	
			mov	pc,	lr


			LTORG


DMC0_SET_MEM_REG	DATA
			;DMC0_CON_CONTROL	BaseAddr+ 0x0 	
			;DMC0_MEM_CONTROL	BaseAddr+ 0x4	
			;DMC0_MEM_CONFIG0    BaseAddr+ 0x8
			;DMC0_MEM_CONFIG1    BaseAddr+ 0xc
			;DMC0_PRECH_CONFIG   BaseAddr+ 0x14
			;DMC0_PWRDN_CONFIG   BaseAddr+ 0x28
			;DMC0_TIMING_AREF    BaseAddr+ 0x30
			;DMC0_TIMING_ROW		BaseAddr+ 0x34
			;DMC0_TIMING_DATA    BaseAddr+ 0x38
			;DMC0_TIMING_POWER   BaseAddr+ 0x3c
			DCD	((DMC0_TIMEOUT_CNT<<16)|(DMC0_RD_FETCH<<12)|(DMC0_FAST_EN<<11)|(DMC0_DQ_SWAP<<10)|(DMC0_DRV_EN<<7)|(DMC0_CTC_RTR_GAP_EN<<6)|(DMC0_AREF_EN<<5)|(DMC0_OUT_OF<<4)) 
			DCD	((DMC0_BL<<20)|(DMC0_NUM_CHIP<<16)|(DMC0_MEM_WIDTH<<12)|(DMC0_MEM_TYPE<<8)|(DMC0_ADD_LAT_PALL<<6)|(DMC0_DSREF_EN<<5)|(DMC0_TP_EN<<4)|(DMC0_DPWRDN_TYPE<<2)|(DMC0_DPWRDN_EN<<1)|(DMC0_CLK_STOP_EN))
			DCD ((DMC0_CHIP_BASE0<<24)|(DMC0_CHIP_MASK0<<16)|(DMC0_CHIP_MAP0<<12)|(DMC0_CHIP_COL0<<8)|(DMC0_CHIP_ROW0<<4)|(DMC0_CHIP_BANK0))
			DCD ((DMC0_CHIP_BASE1<<24)|(DMC0_CHIP_MASK1<<16)|(DMC0_CHIP_MAP1<<12)|(DMC0_CHIP_COL1<<8)|(DMC0_CHIP_ROW1<<4)|(DMC0_CHIP_BANK1))
			DCD ((DMC0_FP_CNT<<24)|(DMC0_CHIP1_POLICY<<8)|(DMC0_CHIP0_POLICY))
			DCD ((DMC0_DSREF_CYC<<16)|(DMC0_DPWRDN_CYC))
			DCD (DMC0_T_REFI)
			DCD ((DMC0_T_RFC<<24)|(DMC0_T_RRD<<20)|(DMC0_T_RP<<16)|(DMC0_T_RCD<<12)|(DMC0_T_RC<<6)|(DMC0_T_RAS))
			DCD ((DMC0_T_WTR<<28)|(DMC0_T_WR<<24)|(DMC0_T_RTP<<20)|(DMC0_T_CL<<16)|(DMC0_T_WL<<8)|(DMC0_T_RL))
			DCD ((DMC0_T_FAW<<24)|(DMC0_T_XSR<<16)|(DMC0_T_XP<<8)|(DMC0_T_CKE<<4)|(DMC0_T_MRD))
			
DMC0_SET_PHY_REG	DATA
			DCD ((DMC0_CTRL_FORCE<<24)|(DMC0_CTRL_INC<<16)|(DMC0_CTRL_START_POINT<<8)|(DMC0_DQS_DELAY<<4)|(DMC0_DF_DQS<<3)|(DMC0_CTRL_HALF<<2)|(DMC0_CTRL_DLL_ON<<1)|(DMC0_CTRL_START))
			DCD ((DMC0_CTRL_OFFSETD<<16)|(DMC0_CTRL_OFFSETC<<8)|(DMC0_CTRL_SHIFTC))
			DCD ((DMC0_CTRL_OFFSET3<<24)|(DMC0_CTRL_OFFSET2<<16)|(DMC0_CTRL_OFFSET1<<8)|(DMC0_CTRL_OFFSET0))
			
DMC0_DDR_CMD	DATA			;16 items. not tested
			DCD	0x07000000	;chip0 Deselect(NOP)
			DCD	0x01000000	;chip0 PALL
			DCD	0x00010000	;chip0 EMRS 
			DCD	0x00000132	;chip0 MRS, CL=3, BL=4
			DCD	0x01000000	;chip0 PALL
			DCD	0x05000000	;chip0 REFA
			DCD	0x05000000	;chip0 REFA
			DCD	0x00000032	;chip0 MRS, CL=3, BL=4
			DCD	0x07100000	;chip1 Deselect(NOP)
			DCD	0x01100000	;chip1 PALL
			DCD	0x00110000	;chip1 EMRS 
			DCD	0x00100132	;chip1 MRS, CL=3, BL=4
			DCD	0x01100000	;chip1 PALL
			DCD	0x05100000	;chip1 REFA
			DCD	0x05100000	;chip1 REFA
			DCD	0x00100032	;chip1 MRS, CL=3, BL=4
			
DMC0_LPDDR_CMD	DATA			;10 items
			DCD	0x07000000	;chip0 Deselect(NOP)
			DCD	0x01000000	;chip0 PALL
			DCD	0x05000000	;chip0 REFA
			DCD	0x05000000	;chip0 REFA
			DCD	0x00000032	;chip0 MRS, CL=3, BL=4
			DCD	0x07100000	;chip1 Deselect(NOP)
			DCD	0x01100000	;chip1 PALL
			DCD	0x05100000	;chip1 REFA
			DCD	0x05100000	;chip1 REFA
			DCD	0x00100032	;chip1 MRS, CL=3, BL=4

DMC0_DDR2_CMD	DATA			;24 items
			DCD	0x07000000	;chip0 Deselect(NOP)
			DCD	0x01000000	;chip0 PALL
			DCD	0x00020000	;chip0 EMRS2
			DCD	0x00030000	;chip0 EMRS3
			DCD	0x00010400	;chip0 EMRS1 (MEM DLL on, DQS# disable)
			DCD	0x00000542	;chip0 MRS (MEM DLL reset)
			DCD	0x01000000	;chip0 PALL
			DCD	0x05000000	;chip0 REFA
			DCD	0x05000000	;chip0 REFA
			DCD	0x00000442	;chip0 MRS (MEM DLL unreset), BL=4
			DCD	0x00010780	;chip0 EMRS1 (OCD default)
			DCD	0x00010400	;chip0 EMRS1 (OCD exit)
			DCD	0x07100000	;chip1 Deselect(NOP)
			DCD	0x01100000	;chip1 PALL
			DCD	0x00120000	;chip1 EMRS2
			DCD	0x00130000	;chip1 EMRS3
			DCD	0x00110400	;chip1 EMRS1 (MEM DLL on, DQS# disable)
			DCD	0x00100542	;chip1 MRS (MEM DLL reset)
			DCD	0x01100000	;chip1 PALL
			DCD	0x05100000	;chip1 REFA
			DCD	0x05100000	;chip1 REFA
			DCD	0x00100442	;chip1 MRS (MEM DLL unreset), BL=4
			DCD	0x00110780	;chip1 EMRS1 (OCD default)
			DCD	0x00110400	;chip1 EMRS1 (OCD exit)
			
DMC1_SET_MEM_REG	DATA
			;DMC1_CON_CONTROL	BaseAddr+ 0x0 	
			;DMC1_MEM_CONTROL	BaseAddr+ 0x4	
			;DMC1_MEM_CONFIG0    BaseAddr+ 0x8
			;DMC1_MEM_CONFIG1    BaseAddr+ 0xc
			;DMC1_PRECH_CONFIG   BaseAddr+ 0x14
			;DMC1_PWRDN_CONFIG   BaseAddr+ 0x28
			;DMC1_TIMING_AREF    BaseAddr+ 0x30
			;DMC1_TIMING_ROW		BaseAddr+ 0x34
			;DMC1_TIMING_DATA    BaseAddr+ 0x38
			;DMC1_TIMING_POWER   BaseAddr+ 0x3c
			DCD	((DMC1_TIMEOUT_CNT<<16)|(DMC1_RD_FETCH<<12)|(DMC1_FAST_EN<<11)|(DMC1_DQ_SWAP<<10)|(DMC1_PRE_PRE_EN<<9)|(DMC1_CTC_RTR_GAP_EN<<6)|(DMC1_AREF_EN<<5)|(DMC1_OUT_OF<<4)) 
			DCD	((DMC1_BL<<20)|(DMC1_NUM_CHIP<<16)|(DMC1_MEM_WIDTH<<12)|(DMC1_MEM_TYPE<<8)|(DMC1_ADD_LAT_PALL<<6)|(DMC1_DSREF_EN<<5)|(DMC1_TP_EN<<4)|(DMC1_DPWRDN_TYPE<<2)|(DMC1_DPWRDN_EN<<1)|(DMC1_CLK_STOP_EN))
			DCD ((DMC1_CHIP_BASE0<<24)|(DMC1_CHIP_MASK0<<16)|(DMC1_CHIP_MAP0<<12)|(DMC1_CHIP_COL0<<8)|(DMC1_CHIP_ROW0<<4)|(DMC1_CHIP_BANK0))
			DCD ((DMC1_CHIP_BASE1<<24)|(DMC1_CHIP_MASK1<<16)|(DMC1_CHIP_MAP1<<12)|(DMC1_CHIP_COL1<<8)|(DMC1_CHIP_ROW1<<4)|(DMC1_CHIP_BANK1))
			DCD ((DMC1_FP_CNT<<24)|(DMC1_CHIP1_POLICY<<8)|(DMC1_CHIP0_POLICY))
			DCD ((DMC1_DSREF_CYC<<16)|(DMC1_DPWRDN_CYC))
			DCD (DMC1_T_REFI)
			DCD ((DMC1_T_RFC<<24)|(DMC1_T_RRD<<20)|(DMC1_T_RP<<16)|(DMC1_T_RCD<<12)|(DMC1_T_RC<<6)|(DMC1_T_RAS))
			DCD ((DMC1_T_WTR<<28)|(DMC1_T_WR<<24)|(DMC1_T_RTP<<20)|(DMC1_T_CL<<16)|(DMC1_T_WL<<8)|(DMC1_T_RL))
			DCD ((DMC1_T_FAW<<24)|(DMC1_T_XSR<<16)|(DMC1_T_XP<<8)|(DMC1_T_CKE<<4)|(DMC1_T_MRD))
			
DMC1_SET_PHY_REG	DATA
			DCD ((DMC1_CTRL_FORCE<<24)|(DMC1_CTRL_INC<<16)|(DMC1_CTRL_START_POINT<<8)|(DMC1_DQS_DELAY<<4)|(DMC1_DF_DQS<<3)|(DMC1_CTRL_HALF<<2)|(DMC1_CTRL_DLL_ON<<1)|(DMC1_CTRL_START))
			DCD ((DMC1_CTRL_OFFSETD<<16)|(DMC1_CTRL_OFFSETC<<8)|(DMC1_CTRL_SHIFTC))
			DCD ((DMC1_CTRL_OFFSET3<<24)|(DMC1_CTRL_OFFSET2<<16)|(DMC1_CTRL_OFFSET1<<8)|(DMC1_CTRL_OFFSET0))
			
DMC1_DDR_CMD	DATA			;16 items. not tested
			DCD	0x07000000	;chip0 Deselect(NOP)
			DCD	0x01000000	;chip0 PALL
			DCD	0x00010000	;chip0 EMRS 
			DCD	0x00000132	;chip0 MRS, CL=3, BL=4
			DCD	0x01000000	;chip0 PALL
			DCD	0x05000000	;chip0 REFA
			DCD	0x05000000	;chip0 REFA
			DCD	0x00000032	;chip0 MRS, CL=3, BL=4
			DCD	0x07100000	;chip1 Deselect(NOP)
			DCD	0x01100000	;chip1 PALL
			DCD	0x00110000	;chip1 EMRS 
			DCD	0x00100132	;chip1 MRS, CL=3, BL=4
			DCD	0x01100000	;chip1 PALL
			DCD	0x05100000	;chip1 REFA
			DCD	0x05100000	;chip1 REFA
			DCD	0x00100032	;chip1 MRS, CL=3, BL=4
			
DMC1_LPDDR_CMD	DATA			;10 items
			DCD	0x07000000	;chip0 Deselect(NOP)
			DCD	0x01000000	;chip0 PALL
			DCD	0x05000000	;chip0 REFA
			DCD	0x05000000	;chip0 REFA
			DCD	0x00000032	;chip0 MRS, CL=3, BL=4
			DCD	0x07100000	;chip1 Deselect(NOP)
			DCD	0x01100000	;chip1 PALL
			DCD	0x05100000	;chip1 REFA
			DCD	0x05100000	;chip1 REFA
			DCD	0x00100032	;chip1 MRS, CL=3, BL=4

DMC1_DDR2_CMD	DATA			;24 items
			DCD	0x07000000	;chip0 Deselect(NOP)
			DCD	0x01000000	;chip0 PALL
			DCD	0x00020000	;chip0 EMRS2
			DCD	0x00030000	;chip0 EMRS3
			DCD	0x00010400	;chip0 EMRS1 (MEM DLL on, DQS# disable)
			DCD	0x00000542	;chip0 MRS (MEM DLL reset)
			DCD	0x01000000	;chip0 PALL
			DCD	0x05000000	;chip0 REFA
			DCD	0x05000000	;chip0 REFA
			DCD	0x00000442	;chip0 MRS (MEM DLL unreset), BL=4
			DCD	0x00010780	;chip0 EMRS1 (OCD default)
			DCD	0x00010400	;chip0 EMRS1 (OCD exit)
			DCD	0x07100000	;chip1 Deselect(NOP)
			DCD	0x01100000	;chip1 PALL
			DCD	0x00120000	;chip1 EMRS2
			DCD	0x00130000	;chip1 EMRS3
			DCD	0x00110400	;chip1 EMRS1 (MEM DLL on, DQS# disable)
			DCD	0x00100542	;chip1 MRS (MEM DLL reset)
			DCD	0x01100000	;chip1 PALL
			DCD	0x05100000	;chip1 REFA
			DCD	0x05100000	;chip1 REFA
			DCD	0x00100442	;chip1 MRS (MEM DLL unreset), BL=4
			DCD	0x00110780	;chip1 EMRS1 (OCD default)
			DCD	0x00110400	;chip1 EMRS1 (OCD exit)

			


    
	END