;
; (C) COPYRIGHT 2006 Samsung Elec. Co. Ltd.
;     ALL RIGHTS RESERVED
; The entire notice above must be reproduced on all authorised
; copies and copies may only be made to the extent permitted
; by a licensing agreement from Samsung Elec. Co. Limited.
;
; - File Name : $Id: dmc.inc ,v 0.0 $
; - Revision  : $Revision: 0.0 $
; - Date      : $Date: 2007/10/09 $
;


;	GET	option.inc

; LPDMC setting					

	GBLL	ENABLE_DLL	; define => enable dll, comment => disable dll
	GBLL	DMC0            ; DMC0 Port Initialize
	GBLL	DMC1            ; DMC1 Port Initialize
	GBLL	USE_LPDDR		; select USE_xxxx between [LPDDR, DDR2, LPDDR2]	
        GBLL    ASYNC_BR_EN       ; DMC0 Asyncbridge
;        GBLL    ASYNC_BR_DIS       ; DMC0 Asyncbridge        
        
       GBLL    MCP_A_C_TYPE       ; MCP A&C Type [Select :MCP_A_C_TYPE or MCP_H_TYPE]        

	;DMC0_STARTUP_HCLK	       EQU	  12000000	;;;;;; temporary.. must be from option.inc      
	;DMC1_STARTUP_HCLK	       EQU	  12000000	;;;;;; temporary.. must be from option.inc	

;        IF :DEF: ASYNC_BR_EN
 ;     	DMC0_STARTUP_HCLK	       EQU	  12000000	;;;;;; temporary.. must be from option.inc      
;        ENDIF
        
;        IF :DEF: ASYNC_BR_DIS
;        DMC0_Startup_HCLK              EQU        DMC1_Startup_HCLK
;       ENDIF
	
;	IF :DEF: DMC0           ; Select DMC0 Port

;====================================================================
; MP1 register  : DRAM configure
;====================================================================

;;;; DMC0 SFR Base Address
DMC0_SFR_BASE		EQU	0xf0000000	; S5PC100 DMC base address

;;;; DMC0 SFRs...
DMC0_CON_CONTROL	EQU     DMC0_SFR_BASE + 0x00000000
DMC0_MEM_CONTROL	EQU     DMC0_SFR_BASE + 0x00000004
DMC0_MEM_CONFIG0	EQU     DMC0_SFR_BASE + 0x00000008
DMC0_MEM_CONFIG1	EQU     DMC0_SFR_BASE + 0x0000000c
DMC0_DIRECT_CMD		EQU     DMC0_SFR_BASE + 0x00000010
DMC0_PRECH_CONFIG	EQU     DMC0_SFR_BASE + 0x00000014
DMC0_PHY_CONTROL0	EQU     DMC0_SFR_BASE + 0x00000018
DMC0_PHY_CONTROL1	EQU     DMC0_SFR_BASE + 0x0000001c
DMC0_PHY_CONTROL2	EQU     DMC0_SFR_BASE + 0x00000020
DMC0_PWRDN_CONFIG	EQU     DMC0_SFR_BASE + 0x00000028
DMC0_TIMING_AREF	EQU     DMC0_SFR_BASE + 0x00000030
DMC0_TIMING_ROW		EQU     DMC0_SFR_BASE + 0x00000034
DMC0_TIMING_DATA	EQU     DMC0_SFR_BASE + 0x00000038
DMC0_TIMING_POWER	EQU     DMC0_SFR_BASE + 0x0000003c
DMC0_PHY_STATUS0	EQU     DMC0_SFR_BASE + 0x00000040
DMC0_PHY_STATUS1	EQU     DMC0_SFR_BASE + 0x00000044
DMC0_CHIP0_STATUS	EQU     DMC0_SFR_BASE + 0x00000048
DMC0_CHIP1_STATUS	EQU     DMC0_SFR_BASE + 0x0000004c
DMC0_AREF_STATUS	EQU     DMC0_SFR_BASE + 0x00000050
DMC0_QOS_CONTROL0	EQU     DMC0_SFR_BASE + 0x00000060
DMC0_QOS_CONFIG0	EQU     DMC0_SFR_BASE + 0x00000064
DMC0_QOS_CONTROL1	EQU     DMC0_SFR_BASE + 0x00000068
DMC0_QOS_CONFIG1	EQU     DMC0_SFR_BASE + 0x0000006c
DMC0_QOS_CONTROL2	EQU     DMC0_SFR_BASE + 0x00000070
DMC0_QOS_CONFIG2	EQU     DMC0_SFR_BASE + 0x00000074
DMC0_QOS_CONTROL3	EQU     DMC0_SFR_BASE + 0x00000078
DMC0_QOS_CONFIG3	EQU     DMC0_SFR_BASE + 0x0000007c
DMC0_QOS_CONTROL4	EQU     DMC0_SFR_BASE + 0x00000080
DMC0_QOS_CONFIG4	EQU     DMC0_SFR_BASE + 0x00000084
DMC0_QOS_CONTROL5	EQU     DMC0_SFR_BASE + 0x00000088
DMC0_QOS_CONFIG5	EQU     DMC0_SFR_BASE + 0x0000008c
DMC0_QOS_CONTROL6	EQU     DMC0_SFR_BASE + 0x00000090
DMC0_QOS_CONFIG6	EQU     DMC0_SFR_BASE + 0x00000094
DMC0_QOS_CONTROL7	EQU     DMC0_SFR_BASE + 0x00000098
DMC0_QOS_CONFIG7	EQU     DMC0_SFR_BASE + 0x0000009c
DMC0_QOS_CONTROL8	EQU     DMC0_SFR_BASE + 0x000000A0
DMC0_QOS_CONFI8		EQU	DMC0_SFR_BASE + 0x000000A4
DMC0_QOS_CONTROL9       EQU	DMC0_SFR_BASE + 0x000000A8
DMC0_QOS_CONFIG9	EQU	DMC0_SFR_BASE + 0x000000Ac
DMC0_QOS_CONTROL10	EQU	DMC0_SFR_BASE + 0x000000B0
DMC0_QOS_CONFIG10	EQU	DMC0_SFR_BASE + 0x000000B4
DMC0_QOS_CONTROL11	EQU	DMC0_SFR_BASE + 0x000000B8
DMC0_QOS_CONFIG11	EQU	DMC0_SFR_BASE + 0x000000Bc
DMC0_QOS_CONTROL12	EQU	DMC0_SFR_BASE + 0x000000C0
DMC0_QOS_CONFIG12	EQU	DMC0_SFR_BASE + 0x000000C4
DMC0_QOS_CONTROL13	EQU	DMC0_SFR_BASE + 0x000000C8
DMC0_QOS_CONFIG13	EQU	DMC0_SFR_BASE + 0x000000Cc
DMC0_QOS_CONTROL14	EQU	DMC0_SFR_BASE + 0x000000D0
DMC0_QOS_CONFIG14	EQU	DMC0_SFR_BASE + 0x000000D4
DMC0_QOS_CONTROL15	EQU	DMC0_SFR_BASE + 0x000000D8
DMC0_QOS_CONFIG15	EQU	DMC0_SFR_BASE + 0x000000Dc

DMC0_HCLK_KHZ		EQU	166000

DMC0_DRAM_tCK		EQU	((10*1000000/DMC0_HCLK_KHZ)+9)/10 ; for round, (x*10+9)/10
				; @12MHz -> 83ns, @166MHz -> 6ns, @200MHz -> 5ns

	IF :DEF: MCP_A_C_TYPE	
;;========================================================
;;[A & C Type] MCP(LPDDR+OneDram)4G1G1G Memory Setting
;; OneDRAM Setting Parameter :128MB(B-Port 112MB,A-Port 32MB,Shared 128Mb)
;; Bank: 4bank, Row: A0~A13, Column: A0~A8
;; tRFC 120ns, tRRD 12ns, tRP 18ns, tRCD 18ns, tRC 60ns, tRAS 42ns
;; tWR 12ns(2tclk), trtp 1tclk, tWTR 1tCK, tCKE 2tCK, tMRD 2tCK
;;=======================================================

DMC0_CHIP_BASE          EQU     0x20            ; AXI Base Addrress
DMC0_CHIP_MAP           EQU     2               ; 0:Linear, 1:Interleaved, 2:Mixed
DMC0_DRAM_ROW		EQU	2		; 14bit    0:12bit, 1:13bit , 2:14bit,3:15bit, 4~0xf:res
DMC0_DRAM_COL		EQU	2		; 10bit    0:res,1:8bit, 2:9bit, 3:10bit, 4:11bit, 5~0xf:res
DMC0_DRAM_BANK		EQU	2		; 4banks   0:1bank, 1:2bank, 2:4bank, 3:8bank, 4~0xf: res
DMC0_DRAM_TYPE		EQU	1		; mem type 0:res., 1:LPDDR, 2:LPDDR2, 3:res, 4:DDR2, 5~0xF:res.
DMC0_DRAM_ADDRMASK	EQU	0xF8		; 128MB

DMC0_DRAM_tREFRESH	EQU	7800		; ns  7800 

DMC0_DRAM_tRFC		EQU	120		; ns (min: 120ns)
DMC0_DRAM_tRRD		EQU	12		; ns (min: 30ns)
DMC0_DRAM_tRP		EQU	18		; ns (min: 30ns)
DMC0_DRAM_tRCD		EQU	18		; ns (min: 30ns)
DMC0_DRAM_tRC		EQU	60		; ns (min: 90ns)
DMC0_DRAM_tRAS		EQU	42		; ns (min: 60ns)

DMC0_DRAM_tWTR		EQU	2*DMC0_DRAM_tCK	; ns (min: 2 tCK)
DMC0_DRAM_tWR		EQU	2*DMC0_DRAM_tCK	; ns (min: 2 tCK)
DMC0_DRAM_tRTP		EQU	1*DMC0_DRAM_tCK	; tRP, ns (min: 30ns), t_rtp must be 1tclk(LPDDR)
DMC0_DRAM_CL		EQU	3*DMC0_DRAM_tCK	; ns (min: 3 tCK) CAS latency
DMC0_DRAM_WL		EQU	3*DMC0_DRAM_tCK	; for LPDDR2
DMC0_DRAM_RL		EQU	3*DMC0_DRAM_tCK	; for LPDDR2

DMC0_DRAM_tFAW		EQU	20		; for DDR2
DMC0_DRAM_tXSR		EQU	120		; ns (min: 120ns)
DMC0_DRAM_tXP		EQU	2*DMC0_DRAM_tCK	; for LPDDR2
DMC0_DRAM_tCKE	        EQU	2*DMC0_DRAM_tCK	; ns (min: 3 tCK)
DMC0_DRAM_tMRD		EQU	2*DMC0_DRAM_tCK	; ns (min: 2 tCK)

DMC0_DF_DQS0            EQU     1               ; DDR2/LPDDR2 Case( 1 but LPCON Phy DQSn bug- Always enable)

DMC0_CTRL_SHIFTC0       EQU     0x100           ; 0x100 when LPDDR/LPDDR2, 0x110 when DDR2

	ELIF :DEF: MCP_H_TYPE
;;========================================================
;;[MCP H Type] mDDR Memory Setting
;; CHIP_BASE: 0x20(0x2000_0000), CHIP_MASK: 0xF8(1G*2ea,256MByte), CHIP_MAP : 0(0:Linear,1:Interleaved,2:Mixed)
;; Bank: 4bank, Row: A0~A12, Column: A0~A9
;; tRFC 80ns, tRRD 10ns, tRP 15ns, tRCD 15ns, tRC 55ns, tRAS 40ns
;; tWR 15ns, trtp 7.5ns, tFAW 50ns(four Activate Window for 2KB Page Size product), tWTR 7.5ns
;; tWTR 2tCK, tCL 3tCK, tWL 3tCK, tRL 3tCK, tXP 2tCK, tCKE 2tCK, tMRD 2tCK
;;========================================================
DMC0_CHIP_BASE          EQU     0x20            ; AXI Base Addrress
DMC0_CHIP_MAP           EQU     2               ; 0:Linear, 1:Interleaved, 2:Mixed
DMC0_DRAM_ROW		EQU	1		; 13bit    0:12bit, 1:13bit , 2:14bit,3:15bit, 4~0xf:res
DMC0_DRAM_COL		EQU	3		; 10bit    0:res,1:8bit, 2:9bit, 3:10bit, 4:11bit, 5~0xf:res
DMC0_DRAM_BANK		EQU	2		; 4banks   0:1bank, 1:2bank, 2:4bank, 3:8bank, 4~0xf: res
DMC0_DRAM_TYPE		EQU	1		; mem type 0:res., 1:LPDDR, 2:LPDDR2, 3:res, 4:DDR2, 5~0xF:res.
DMC0_DRAM_ADDRMASK	EQU	0xF8		; 256MB (Real 2G:256*4)

DMC0_DRAM_tREFRESH	EQU	7800		; ns  7800 

DMC0_DRAM_tRFC		EQU	80		; ns (min: 195ns)
DMC0_DRAM_tRRD		EQU	10		; ns (min: 10ns)
DMC0_DRAM_tRP		EQU	15		; ns (min: 15ns)
DMC0_DRAM_tRCD		EQU	15		; ns (min: 15ns)
DMC0_DRAM_tRC		EQU	55		; ns (min: 60ns)
DMC0_DRAM_tRAS		EQU	40		; ns (min: 45ns)

DMC0_DRAM_tWTR		EQU	2*DMC0_DRAM_tCK	; ns (min: 7.5ns)
DMC0_DRAM_tWR		EQU	12		; ns (min: 15ns)
DMC0_DRAM_tRTP		EQU	8		; ns (min: 7.5ns)
DMC0_DRAM_CL		EQU	3*DMC0_DRAM_tCK	; ns (min: 3 tCK) CAS latency
DMC0_DRAM_WL		EQU	3*DMC0_DRAM_tCK	; for LPDDR2
DMC0_DRAM_RL		EQU	3*DMC0_DRAM_tCK	; for LPDDR2

DMC0_DRAM_tFAW		EQU	50		; ns (min: 50ns for 2KB page, 37.5ns for 1KB page)
DMC0_DRAM_tXSR		EQU	120		; ns (min: 200ns)
DMC0_DRAM_tXP		EQU	2*DMC0_DRAM_tCK	; ns (min: 2 tCK)
DMC0_DRAM_tCKE	        EQU	2*DMC0_DRAM_tCK	; ns (min: 3 tCK)
DMC0_DRAM_tMRD		EQU	2*DMC0_DRAM_tCK	; ns (min: 2 tCK)

DMC0_DF_DQS0            EQU     1               ; DDR2/LPDDR2 Case

DMC0_CTRL_SHIFTC0       EQU     0x100           ; 0x100 when LPDDR/LPDDR2, 0x110 when DDR2

	ENDIF
;--------------------------------------------------------------------
; DMC0_CON_CONTROL register  : DRAM controller control register
;--------------------------------------------------------------------
DMC0_TIMEOUT_CNT	EQU	0xFF0		;	queue timeout counter. aclk cycles : max. 0xFFF
DMC0_RD_FETCH		EQU	1		;	read latency : max. 0xFF 
DMC0_FAST_EN            EQU     0               ;       Adaptive QoS Enable
DMC0_DQ_SWAP		EQU	0		;	DQ swapping 0:dis, 1:en
DMC0_DRV_EN		EQU	0		; 	phy driving 0:dis, 1:en
DMC0_CTC_RTR_GAP_EN	EQU	0		; 	chip-chip read-read gap 0:dis, 1:en
DMC0_AREF_EN		EQU	0		; 	auto refresh 0:dis, 1:en
DMC0_OUT_OF		EQU	1		; 	out-of order op 0:dis, 1:en

;--------------------------------------------------------------------
; DMC0_MEM_CONTROL register : DRAM memory control register
;--------------------------------------------------------------------
DMC0_BL			EQU	2		;	burst length 0:res., 1:2, 2:4, 3:8, 4:16, 5~7:res.
DMC0_NUM_CHIP		EQU	0		;	the number of chip 0:1 chip, 1:2 chips, 2~0xf:res.
DMC0_MEM_WIDTH		EQU	2		;	data bus width 0,1:res., 2:32bit, 3~0xf:res.
DMC0_MEM_TYPE		EQU	DMC0_DRAM_TYPE	; 	mem type 0:res., 1:LPDDR, 2:res., 3:DDR, 4:DDR2, 5~0xF:res.
DMC0_ADD_LAT_PALL	EQU	0		; 	add latency for precharge 0:0cyc, 1:1cyc, 2:2cyc, 3:3cyc
DMC0_DSREF_EN		EQU	0		; 	dynamic self refresh 0:dis, 1:en
DMC0_TP_EN		EQU	0		; 	timeout precharge 0:dis, 1:en
DMC0_DPWRDN_TYPE	EQU	0		; 	dynamic power down type 0:active power down, 1:precharge power down, 2,3:res.
DMC0_DPWRDN_EN		EQU	0		; 	dynamic power down 0:dis, 1:en
DMC0_CLK_STOP_EN	EQU	0		; 	stop clk in idle 0:always running, 1:res.

;--------------------------------------------------------------------
; DMC0_MEM_CONFIG0 register : DRAM chip0 config register
;--------------------------------------------------------------------
DMC0_CHIP_BASE0		EQU	DMC0_CHIP_BASE	;	AXI base address
DMC0_CHIP_MASK0		EQU	DMC0_DRAM_ADDRMASK	;	AXI base mask
DMC0_CHIP_MAP0		EQU	DMC0_CHIP_MAP   ; 	address mapping method 0:linear(b,r,c,w), 1:interleaved(r,b,c,w), 2: Mixed 3~0xf:res.
DMC0_CHIP_COL0		EQU	DMC0_DRAM_COL	;	column address pins 0:res, 1:8bit, 2:9bit, 3:10bit, 4:11bit, 5:12bit, 6~0xf:res.
DMC0_CHIP_ROW0		EQU	DMC0_DRAM_ROW	; 	row address pins 0:12bit, 1:13bit, 2:14bit, 3:15bit, 4~0xf:res.
DMC0_CHIP_BANK0		EQU	DMC0_DRAM_BANK	; 	number of banks 0:1bank, 1:2banks, 2:4banks, 3:8banks, 4~0xf:res.

;--------------------------------------------------------------------
; DMC0_MEM_CONFIG1 register : DRAM chip1 config register
;-------------------------------------------------------------------
DMC0_CHIP_BASE1		EQU	DMC0_CHIP_BASE+0x10	;	AXI base address
DMC0_CHIP_MASK1		EQU	DMC0_DRAM_ADDRMASK	;	AXI base mask
DMC0_CHIP_MAP1		EQU	DMC0_CHIP_MAP   ; 	address mapping method 0:linear(b,r,c,w), 1:interleaved(r,b,c,w), 2: Mixed 3~0xf:res.
DMC0_CHIP_COL1		EQU	DMC0_DRAM_COL	;	column address pins 0:7bit, 1:8bit, 2:9bit, 3:10bit, 4:11bit, 5:12bit, 6~0xf:res.
DMC0_CHIP_ROW1		EQU	DMC0_DRAM_ROW	; 	row address pins 0:12bit, 1:13bit, 2:14bit, 3:15bit, 4~0xf:res.
DMC0_CHIP_BANK1		EQU	DMC0_DRAM_BANK	; 	number of banks 0:1bank, 1:2banks, 2:4banks, 3:8banks, 4~0xf:res.

;--------------------------------------------------------------------
; DMC0_TIMING_ROW register : AC timing register for the row 
;-------------------------------------------------------------------
DMC0_T_RFC		EQU	(10*(DMC0_HCLK_KHZ*DMC0_DRAM_tRFC)/1000000+9)/10	;	auto refresh to active - max.0xff
DMC0_T_RRD		EQU	(10*(DMC0_HCLK_KHZ*DMC0_DRAM_tRRD)/1000000+9)/10	;	active bank A to B delay - max.0xf
DMC0_T_RP		EQU	(10*(DMC0_HCLK_KHZ*DMC0_DRAM_tRP)/1000000+9)/10	        ;	precharge comm. period - max.0xf
DMC0_T_RCD		EQU	(10*(DMC0_HCLK_KHZ*DMC0_DRAM_tRCD)/1000000+9)/10	;	active to read or write delay - max.oxf
DMC0_T_RC		EQU	(10*(DMC0_HCLK_KHZ*DMC0_DRAM_tRC)/1000000+9)/10	        ; 	active to active period - max.0x3f
DMC0_T_RAS		EQU	(10*(DMC0_HCLK_KHZ*DMC0_DRAM_tRAS)/1000000+9)/10	; 	active to precharge comm. period - max.3f

;--------------------------------------------------------------------
; DMC0_TIMING_DATA register : AC timing register for the data 
;--------------------------------------------------------------------
DMC0_T_WTR		EQU	(10*(DMC0_HCLK_KHZ*DMC0_DRAM_tWTR)/1000000+9)/10	;	internal write to read comm. delay - max.0xf
DMC0_T_WR		EQU	(10*(DMC0_HCLK_KHZ*DMC0_DRAM_tWR)/1000000+9)/10	        ;	write recovery time - max.0xf
DMC0_T_RTP		EQU	(10*(DMC0_HCLK_KHZ*DMC0_DRAM_tRTP)/1000000+9)/10	;	internal read to precharge comm. delay - max.0xf
DMC0_T_CL		EQU	(10*(DMC0_HCLK_KHZ*DMC0_DRAM_CL)/1000000+5)/10          ;	CAS latency - max.0xf
DMC0_T_WL		EQU	(10*(DMC0_HCLK_KHZ*DMC0_DRAM_WL)/1000000+5)/10   	; 	write data latency - max.0xf
DMC0_T_RL		EQU	(10*(DMC0_HCLK_KHZ*DMC0_DRAM_RL)/1000000+5)/10	        ; 	read data latency - max.0xf

;--------------------------------------------------------------------
; DMC0_TIMING_POWER register : AC timing register for the power mode 
;-------------------------------------------------------------------
DMC0_T_FAW		EQU	(10*(DMC0_HCLK_KHZ*DMC0_DRAM_tFAW)/1000000+9)/10	;	four activate window - max.0x3f
DMC0_T_XSR		EQU	(10*(DMC0_HCLK_KHZ*DMC0_DRAM_tXSR)/1000000+9)/10	;	self refresh exit power down to next valid comm. delay - max.0xff
DMC0_T_XP		EQU	(10*(DMC0_HCLK_KHZ*DMC0_DRAM_tXP)/1000000+9)/10	        ;	exit power down to next valid comm. delay - max.0xff
DMC0_T_CKE		EQU	(10*(DMC0_HCLK_KHZ*DMC0_DRAM_tCKE)/1000000+9)/10	;	CKE min. pulse width - max.0xf
DMC0_T_MRD		EQU	(10*(DMC0_HCLK_KHZ*DMC0_DRAM_tMRD)/1000000+9)/10	; 	mode register set comm. period - max.0xf


;--------------------------------------------------------------------
; DMC0_PRECH_CONFIG register : DRAM precharge policy configration register
;--------------------------------------------------------------------
DMC0_FP_CNT		EQU	0x20		;	force precharge counter max.0xff (mclk cyc)
DMC0_CHIP1_POLICY	EQU	0		;	chip1 precharge policy per bank 0(bitwise):open page policy, 1(bitwise):close page policy
DMC0_CHIP0_POLICY	EQU	0		;	chip0 precharge policy per bank 0(bitwise):open page policy, 1(bitwise):close page policy

;--------------------------------------------------------------------
; DMC0_PWRDN_CONFIG register : DRAM power down configration register
;--------------------------------------------------------------------
DMC0_DSREF_CYC		EQU	0x10		; 	cycle for dynamic self refresh entry max.0xffff (aclk)
DMC0_DPWRDN_CYC		EQU	4		; 	cycle for dynamic power down entry max.0xff (aclk)

;--------------------------------------------------------------------
; DMC0_TIMING_AREF register : refresh cycle register
;--------------------------------------------------------------------
DMC0_T_REFI		EQU	(10*(DMC0_HCLK_KHZ/1000*DMC0_DRAM_tREFRESH)/1000+9)/10	; 	refresh cycle 
						;	7.8us*200MHz=1560(0x619)
						;	7.8us*166MHz=1295(0x50F)
						;	7.8us*133MHz=1038(0x40E)
						;	7.8us*100MHz=780(0x30C)
						;	7.8us*25MHz=195(0xC3)
						;	7.8us*12MHz=94(0x5E)

;--------------------------------------------------------------------
; DMC0_PHY_CONTROL0 register : PHY control 0 register
;--------------------------------------------------------------------
DMC0_CTRL_FORCE		EQU	0		;	DLL force - max.0xff
DMC0_CTRL_INC		EQU	0x10		;	Increase amount - max.0xff
DMC0_CTRL_START_POINT	EQU	0x10		;	DLL lock start point - max.0xff

DMC0_DQS_DELAY   	EQU	0		;	Delay Cycles or DQS Cleaning
DMC0_DF_DQS 		EQU	DMC0_DF_DQS0	; 	Differential DQS

DMC0_CTRL_HALF		EQU	0		; 	DLL low speed
DMC0_CTRL_DLL_ON	EQU	0		; 	DLL on
DMC0_CTRL_START		EQU	0		; 	DLL start

;--------------------------------------------------------------------
; DMC0_PHY_CONTROL1 register : PHY control 1 register
;-------------------------------------------------------------------
DMC0_CTRL_OFFSETD	EQU	0		;	offset for debug - max.0x7f
DMC0_CTRL_OFFSETC	EQU	0		;	gate offset - max.0x7f 
DMC0_CTRL_SHIFTC	EQU	DMC0_CTRL_SHIFTC0	;	gateout signal delay - 0:T/128, 1:T/64, 2:T/32, 3:T/16, 4:T/8, 5:T/4, 6:T/2, 7:T

;--------------------------------------------------------------------
; DMC0_PHY_CONTROL2 register : PHY control 2 register
;-------------------------------------------------------------------
DMC0_CTRL_OFFSET3	EQU	0		;	offset for debug - max.0x7f
DMC0_CTRL_OFFSET2	EQU	0		;	offset for debug - max.0x7f
DMC0_CTRL_OFFSET1	EQU	0		;	offset for debug - max.0x7f
DMC0_CTRL_OFFSET0	EQU	0		;	offset for debug - max.0x7f

;	END

;	ENDIF


;	IF :DEF: DMC1           ; Select DMC1 Port
	
;====================================================================
; MP2 register  : DRAM configure
;====================================================================

;;;; DMC1 SFR Base Address
DMC1_SFR_BASE		EQU	0xf1400000	; S5PC100 DMC base address

;;;; DMC1 SFRs...
DMC1_CON_CONTROL	EQU     DMC1_SFR_BASE + 0x00000000
DMC1_MEM_CONTROL	EQU     DMC1_SFR_BASE + 0x00000004
DMC1_MEM_CONFIG0	EQU     DMC1_SFR_BASE + 0x00000008
DMC1_MEM_CONFIG1	EQU     DMC1_SFR_BASE + 0x0000000c
DMC1_DIRECT_CMD		EQU     DMC1_SFR_BASE + 0x00000010
DMC1_PRECH_CONFIG	EQU     DMC1_SFR_BASE + 0x00000014
DMC1_PHY_CONTROL0	EQU     DMC1_SFR_BASE + 0x00000018
DMC1_PHY_CONTROL1	EQU     DMC1_SFR_BASE + 0x0000001c
DMC1_PHY_CONTROL2	EQU     DMC1_SFR_BASE + 0x00000020
DMC1_PWRDN_CONFIG	EQU     DMC1_SFR_BASE + 0x00000028
DMC1_TIMING_AREF	EQU     DMC1_SFR_BASE + 0x00000030
DMC1_TIMING_ROW		EQU     DMC1_SFR_BASE + 0x00000034
DMC1_TIMING_DATA	EQU     DMC1_SFR_BASE + 0x00000038
DMC1_TIMING_POWER	EQU     DMC1_SFR_BASE + 0x0000003c
DMC1_PHY_STATUS0	EQU     DMC1_SFR_BASE + 0x00000040
DMC1_PHY_STATUS1	EQU     DMC1_SFR_BASE + 0x00000044
DMC1_CHIP0_STATUS	EQU     DMC1_SFR_BASE + 0x00000048
DMC1_CHIP1_STATUS	EQU     DMC1_SFR_BASE + 0x0000004c
DMC1_AREF_STATUS	EQU     DMC1_SFR_BASE + 0x00000050
DMC1_QOS_CONTROL0	EQU     DMC1_SFR_BASE + 0x00000060
DMC1_QOS_CONFIG0	EQU     DMC1_SFR_BASE + 0x00000064
DMC1_QOS_CONTROL1	EQU     DMC1_SFR_BASE + 0x00000068
DMC1_QOS_CONFIG1	EQU     DMC1_SFR_BASE + 0x0000006c
DMC1_QOS_CONTROL2	EQU     DMC1_SFR_BASE + 0x00000070
DMC1_QOS_CONFIG2	EQU     DMC1_SFR_BASE + 0x00000074
DMC1_QOS_CONTROL3	EQU     DMC1_SFR_BASE + 0x00000078
DMC1_QOS_CONFIG3	EQU     DMC1_SFR_BASE + 0x0000007c
DMC1_QOS_CONTROL4	EQU     DMC1_SFR_BASE + 0x00000080
DMC1_QOS_CONFIG4	EQU     DMC1_SFR_BASE + 0x00000084
DMC1_QOS_CONTROL5	EQU     DMC1_SFR_BASE + 0x00000088
DMC1_QOS_CONFIG5	EQU     DMC1_SFR_BASE + 0x0000008c
DMC1_QOS_CONTROL6	EQU     DMC1_SFR_BASE + 0x00000090
DMC1_QOS_CONFIG6	EQU     DMC1_SFR_BASE + 0x00000094
DMC1_QOS_CONTROL7	EQU     DMC1_SFR_BASE + 0x00000098
DMC1_QOS_CONFIG7	EQU     DMC1_SFR_BASE + 0x0000009c
DMC1_QOS_CONTROL8	EQU     DMC1_SFR_BASE + 0x000000A0
DMC1_QOS_CONFI8		EQU	DMC1_SFR_BASE + 0x000000A4
DMC1_QOS_CONTROL9       EQU	DMC1_SFR_BASE + 0x000000A8
DMC1_QOS_CONFIG9	EQU	DMC1_SFR_BASE + 0x000000Ac
DMC1_QOS_CONTROL10	EQU	DMC1_SFR_BASE + 0x000000B0
DMC1_QOS_CONFIG10	EQU	DMC1_SFR_BASE + 0x000000B4
DMC1_QOS_CONTROL11	EQU	DMC1_SFR_BASE + 0x000000B8
DMC1_QOS_CONFIG11	EQU	DMC1_SFR_BASE + 0x000000Bc
DMC1_QOS_CONTROL12	EQU	DMC1_SFR_BASE + 0x000000C0
DMC1_QOS_CONFIG12	EQU	DMC1_SFR_BASE + 0x000000C4
DMC1_QOS_CONTROL13	EQU	DMC1_SFR_BASE + 0x000000C8
DMC1_QOS_CONFIG13	EQU	DMC1_SFR_BASE + 0x000000Cc
DMC1_QOS_CONTROL14	EQU	DMC1_SFR_BASE + 0x000000D0
DMC1_QOS_CONFIG14	EQU	DMC1_SFR_BASE + 0x000000D4
DMC1_QOS_CONTROL15	EQU	DMC1_SFR_BASE + 0x000000D8
DMC1_QOS_CONFIG15	EQU	DMC1_SFR_BASE + 0x000000Dc

DMC1_HCLK_KHZ		EQU	200000

DMC1_DRAM_tCK		EQU	((10*1000000/DMC1_HCLK_KHZ)+9)/10 ; for round, (x*10+9)/10
				; @12MHz -> 83ns, @166MHz -> 6ns, @200MHz -> 5ns

	IF :DEF: MCP_A_C_TYPE	
;;========================================================
;;[A & C Type] MCP(LPDDR+OneDram)4G1G1G Memory Setting
;; OneDRAM Setting Parameter :128MB(B-Port 112MB,A-Port 32MB,Shared 128Mb)
;; Bank: 4bank, Row: A0~A13, Column: A0~A8
;; tRFC 120ns, tRRD 12ns, tRP 18ns, tRCD 18ns, tRC 60ns, tRAS 42ns
;; tWR 12ns(2tclk), trtp 1tclk, tWTR 1tCK, tCKE 2tCK, tMRD 2tCK
;;=======================================================

DMC1_CHIP_BASE          EQU     0x40            ; AXI Base Addrress
DMC1_CHIP_MAP           EQU     1               ; 0:Linear, 1:Interleaved, 2:Mixed
DMC1_DRAM_ROW		EQU	2		; 14bit    0:12bit, 1:13bit , 2:14bit,3:15bit, 4~0xf:res
DMC1_DRAM_COL		EQU	2		; 10bit    0:res,1:8bit, 2:9bit, 3:10bit, 4:11bit, 5~0xf:res
DMC1_DRAM_BANK		EQU	2		; 4banks   0:1bank, 1:2bank, 2:4bank, 3:8bank, 4~0xf: res
DMC1_DRAM_TYPE		EQU	1		; mem type 0:res., 1:LPDDR, 2:LPDDR2, 3:res, 4:DDR2, 5~0xF:res.
DMC1_DRAM_ADDRMASK	EQU	0xF8		; 128MB

DMC1_DRAM_tREFRESH	EQU	7800		; ns  7800 

DMC1_DRAM_tRFC		EQU	120		; ns (min: 120ns)
DMC1_DRAM_tRRD		EQU	12		; ns (min: 30ns)
DMC1_DRAM_tRP		EQU	18		; ns (min: 30ns)
DMC1_DRAM_tRCD		EQU	18		; ns (min: 30ns)
DMC1_DRAM_tRC		EQU	60		; ns (min: 90ns)
DMC1_DRAM_tRAS		EQU	42		; ns (min: 60ns)

DMC1_DRAM_tWTR		EQU	2*DMC1_DRAM_tCK	; ns (min: 2 tCK)
DMC1_DRAM_tWR		EQU	2*DMC1_DRAM_tCK	; ns (min: 2 tCK)
DMC1_DRAM_tRTP		EQU	1*DMC1_DRAM_tCK	; tRP, ns (min: 30ns), t_rtp must be 1tclk(LPDDR)
DMC1_DRAM_CL		EQU	3*DMC1_DRAM_tCK	; ns (min: 3 tCK) CAS latency
DMC1_DRAM_WL		EQU	3*DMC1_DRAM_tCK	; for LPDDR2
DMC1_DRAM_RL		EQU	3*DMC1_DRAM_tCK	; for LPDDR2

DMC1_DRAM_tFAW		EQU	20		; for DDR2
DMC1_DRAM_tXSR		EQU	120		; ns (min: 120ns)
DMC1_DRAM_tXP		EQU	2*DMC1_DRAM_tCK	; for LPDDR2
DMC1_DRAM_tCKE	        EQU	2*DMC1_DRAM_tCK	; ns (min: 3 tCK)
DMC1_DRAM_tMRD		EQU	2*DMC1_DRAM_tCK	; ns (min: 2 tCK)

DMC1_DF_DQS0            EQU     1               ; DDR2/LPDDR2 Case( 1 but LPCON Phy DQSn bug- Always enable)

DMC1_CTRL_SHIFTC0       EQU     0x100           ; 0x100 when LPDDR/LPDDR2, 0x110 when DDR2

	ELIF :DEF: MCP_H_TYPE
;;========================================================
;;[MCP H Type] mDDR Memory Setting
;; CHIP_BASE: 0x20(0x2000_0000), CHIP_MASK: 0xF8(1G*2ea,256MByte), CHIP_MAP : 0(0:Linear,1:Interleaved,2:Mixed)
;; Bank: 4bank, Row: A0~A12, Column: A0~A9
;; tRFC 80ns, tRRD 10ns, tRP 15ns, tRCD 15ns, tRC 55ns, tRAS 40ns
;; tWR 15ns, trtp 7.5ns, tFAW 50ns(four Activate Window for 2KB Page Size product), tWTR 7.5ns
;; tWTR 2tCK, tCL 3tCK, tWL 3tCK, tRL 3tCK, tXP 2tCK, tCKE 2tCK, tMRD 2tCK
;;========================================================
DMC1_CHIP_BASE          EQU     0x40            ; AXI Base Addrress
DMC1_CHIP_MAP           EQU     1               ; 0:Linear, 1:Interleaved, 2:Mixed
DMC1_DRAM_ROW		EQU	1		; 13bit    0:12bit, 1:13bit , 2:14bit,3:15bit, 4~0xf:res
DMC1_DRAM_COL		EQU	3		; 10bit    0:res,1:8bit, 2:9bit, 3:10bit, 4:11bit, 5~0xf:res
DMC1_DRAM_BANK		EQU	2		; 4banks   0:1bank, 1:2bank, 2:4bank, 3:8bank, 4~0xf: res
DMC1_DRAM_TYPE		EQU	1		; mem type 0:res., 1:LPDDR, 2:LPDDR2, 3:res, 4:DDR2, 5~0xF:res.
DMC1_DRAM_ADDRMASK	EQU	0xF8		; 256MB (Real 2G:256*4)

DMC1_DRAM_tREFRESH	EQU	7800		; ns  7800 

DMC1_DRAM_tRFC		EQU	80		; ns (min: 195ns)
DMC1_DRAM_tRRD		EQU	10		; ns (min: 10ns)
DMC1_DRAM_tRP		EQU	15		; ns (min: 15ns)
DMC1_DRAM_tRCD		EQU	15		; ns (min: 15ns)
DMC1_DRAM_tRC		EQU	55		; ns (min: 60ns)
DMC1_DRAM_tRAS		EQU	40		; ns (min: 45ns)

DMC1_DRAM_tWTR		EQU	2*DMC1_DRAM_tCK	; ns (min: 7.5ns)
DMC1_DRAM_tWR		EQU	12		; ns (min: 15ns)
DMC1_DRAM_tRTP		EQU	8		; ns (min: 7.5ns)
DMC1_DRAM_CL		EQU	3*DMC1_DRAM_tCK	; ns (min: 3 tCK) CAS latency
DMC1_DRAM_WL		EQU	3*DMC1_DRAM_tCK	; for LPDDR2
DMC1_DRAM_RL		EQU	3*DMC1_DRAM_tCK	; for LPDDR2

DMC1_DRAM_tFAW		EQU	50		; ns (min: 50ns for 2KB page, 37.5ns for 1KB page)
DMC1_DRAM_tXSR		EQU	120		; ns (min: 200ns)
DMC1_DRAM_tXP		EQU	2*DMC1_DRAM_tCK	; ns (min: 2 tCK)
DMC1_DRAM_tCKE	        EQU	2*DMC1_DRAM_tCK	; ns (min: 3 tCK)
DMC1_DRAM_tMRD		EQU	2*DMC1_DRAM_tCK	; ns (min: 2 tCK)

DMC1_DF_DQS0            EQU     1               ; DDR2/LPDDR2 Case

DMC1_CTRL_SHIFTC0       EQU     0x100           ; 0x100 when LPDDR/LPDDR2, 0x110 when DDR2

	ENDIF


;--------------------------------------------------------------------
; DMC1_CON_CONTROL register  : DRAM controller control register
;--------------------------------------------------------------------
DMC1_TIMEOUT_CNT	EQU	0xFF0		;	queue timeout counter. aclk cycles : max. 0xFFF
DMC1_RD_FETCH		EQU	1		;	read latency : max. 0xFF 
DMC1_FAST_EN            EQU     0               ;       Adaptive QoS Enable
DMC1_DQ_SWAP		EQU	0		;	DQ swapping 0:dis, 1:en
DMC1_PRE_PRE_EN		EQU	0		;	pre-precharging 0:dis, 1:en
DMC1_PRE_ACT_EN		EQU	0		; 	pre-activation 0:dis, 1:en
DMC1_DRV_EN		EQU	0		; 	phy driving 0:dis, 1:en
DMC1_CTC_RTR_GAP_EN	EQU	0		; 	chip-chip read-read gap 0:dis, 1:en
DMC1_AREF_EN		EQU	0		; 	auto refresh 0:dis, 1:en
DMC1_OUT_OF		EQU	1		; 	out-of order op 0:dis, 1:en

;--------------------------------------------------------------------
; DMC1_MEM_CONTROL register : DRAM memory control register
;--------------------------------------------------------------------
DMC1_BL			EQU	2		;	burst length 0:res., 1:2, 2:4, 3:8, 4:16, 5~7:res.
DMC1_NUM_CHIP		EQU	0		;	the number of chip 0:1 chip, 1:2 chips, 2~0xf:res.
DMC1_MEM_WIDTH		EQU	2		;	data bus width 0,1:res., 2:32bit, 3~0xf:res.
DMC1_MEM_TYPE		EQU	DMC1_DRAM_TYPE	; 	mem type 0:res., 1:LPDDR, 2:res., 3:DDR, 4:DDR2, 5~0xF:res.
DMC1_ADD_LAT_PALL	EQU	0		; 	add latency for precharge 0:0cyc, 1:1cyc, 2:2cyc, 3:3cyc
DMC1_DSREF_EN		EQU	0		; 	dynamic self refresh 0:dis, 1:en
DMC1_TP_EN		EQU	0		; 	timeout precharge 0:dis, 1:en
DMC1_DPWRDN_TYPE	EQU	0		; 	dynamic power down type 0:active power down, 1:precharge power down, 2,3:res.
DMC1_DPWRDN_EN		EQU	0		; 	dynamic power down 0:dis, 1:en
DMC1_CLK_STOP_EN	EQU	0		; 	stop clk in idle 0:always running, 1:res.

;--------------------------------------------------------------------
; DMC1_MEM_CONFIG0 register : DRAM chip0 config register
;--------------------------------------------------------------------
DMC1_CHIP_BASE0		EQU	DMC1_CHIP_BASE	;	AXI base address
DMC1_CHIP_MASK0		EQU	DMC1_DRAM_ADDRMASK	;	AXI base mask
DMC1_CHIP_MAP0		EQU	DMC1_CHIP_MAP   ; 	address mapping method 0:linear(b,r,c,w), 1:interleaved(r,b,c,w), 2: Mixed 3~0xf:res.
DMC1_CHIP_COL0		EQU	DMC1_DRAM_COL	;	column address pins 0:res, 1:8bit, 2:9bit, 3:10bit, 4:11bit, 5:12bit, 6~0xf:res.
DMC1_CHIP_ROW0		EQU	DMC1_DRAM_ROW	; 	row address pins 0:12bit, 1:13bit, 2:14bit, 3:15bit, 4~0xf:res.
DMC1_CHIP_BANK0		EQU	DMC1_DRAM_BANK	; 	number of banks 0:1bank, 1:2banks, 2:4banks, 3:8banks, 4~0xf:res.

;--------------------------------------------------------------------
; DMC1_MEM_CONFIG1 register : DRAM chip1 config register
;-------------------------------------------------------------------
DMC1_CHIP_BASE1		EQU	DMC1_CHIP_BASE+0x18	;	AXI base address
DMC1_CHIP_MASK1		EQU	DMC1_DRAM_ADDRMASK	;	AXI base mask
DMC1_CHIP_MAP1		EQU	DMC1_CHIP_MAP   ; 	address mapping method 0:linear(b,r,c,w), 1:interleaved(r,b,c,w), 2: Mixed 3~0xf:res.
DMC1_CHIP_COL1		EQU	DMC1_DRAM_COL	;	column address pins 0:7bit, 1:8bit, 2:9bit, 3:10bit, 4:11bit, 5:12bit, 6~0xf:res.
DMC1_CHIP_ROW1		EQU	DMC1_DRAM_ROW	; 	row address pins 0:12bit, 1:13bit, 2:14bit, 3:15bit, 4~0xf:res.
DMC1_CHIP_BANK1		EQU	DMC1_DRAM_BANK	; 	number of banks 0:1bank, 1:2banks, 2:4banks, 3:8banks, 4~0xf:res.

;--------------------------------------------------------------------
; DMC1_TIMING_ROW register : AC timing register for the row 
;-------------------------------------------------------------------
DMC1_T_RFC		EQU	(10*(DMC1_HCLK_KHZ*DMC1_DRAM_tRFC)/1000000+9)/10	;	auto refresh to active - max.0xff
DMC1_T_RRD		EQU	(10*(DMC1_HCLK_KHZ*DMC1_DRAM_tRRD)/1000000+9)/10	;	active bank A to B delay - max.0xf
DMC1_T_RP		EQU	(10*(DMC1_HCLK_KHZ*DMC1_DRAM_tRP)/1000000+9)/10	        ;	precharge comm. period - max.0xf
DMC1_T_RCD		EQU	(10*(DMC1_HCLK_KHZ*DMC1_DRAM_tRCD)/1000000+9)/10	;	active to read or write delay - max.oxf
DMC1_T_RC		EQU	(10*(DMC1_HCLK_KHZ*DMC1_DRAM_tRC)/1000000+9)/10	        ; 	active to active period - max.0x3f
DMC1_T_RAS		EQU	(10*(DMC1_HCLK_KHZ*DMC1_DRAM_tRAS)/1000000+9)/10	; 	active to precharge comm. period - max.3f

;--------------------------------------------------------------------
; DMC1_TIMING_DATA register : AC timing register for the data 
;--------------------------------------------------------------------
DMC1_T_WTR		EQU	(10*(DMC1_HCLK_KHZ*DMC1_DRAM_tWTR)/1000000+9)/10	;	internal write to read comm. delay - max.0xf
DMC1_T_WR		EQU	(10*(DMC1_HCLK_KHZ*DMC1_DRAM_tWR)/1000000+9)/10	        ;	write recovery time - max.0xf
DMC1_T_RTP		EQU	(10*(DMC1_HCLK_KHZ*DMC1_DRAM_tRTP)/1000000+9)/10	;	internal read to precharge comm. delay - max.0xf
DMC1_T_CL		EQU	(10*(DMC1_HCLK_KHZ*DMC1_DRAM_CL)/1000000+5)/10          ;	CAS latency - max.0xf
DMC1_T_WL		EQU	(10*(DMC1_HCLK_KHZ*DMC1_DRAM_WL)/1000000+5)/10   	; 	write data latency - max.0xf
DMC1_T_RL		EQU	(10*(DMC1_HCLK_KHZ*DMC1_DRAM_RL)/1000000+5)/10	        ; 	read data latency - max.0xf

;--------------------------------------------------------------------
; DMC1_TIMING_POWER register : AC timing register for the power mode 
;-------------------------------------------------------------------
DMC1_T_FAW		EQU	(10*(DMC1_HCLK_KHZ*DMC1_DRAM_tFAW)/1000000+9)/10	;	four activate window - max.0x3f
DMC1_T_XSR		EQU	(10*(DMC1_HCLK_KHZ*DMC1_DRAM_tXSR)/1000000+9)/10	;	self refresh exit power down to next valid comm. delay - max.0xff
DMC1_T_XP		EQU	(10*(DMC1_HCLK_KHZ*DMC1_DRAM_tXP)/1000000+9)/10	        ;	exit power down to next valid comm. delay - max.0xff
DMC1_T_CKE		EQU	(10*(DMC1_HCLK_KHZ*DMC1_DRAM_tCKE)/1000000+9)/10	;	CKE min. pulse width - max.0xf
DMC1_T_MRD		EQU	(10*(DMC1_HCLK_KHZ*DMC1_DRAM_tMRD)/1000000+9)/10	; 	mode register set comm. period - max.0xf


;--------------------------------------------------------------------
; DMC1_PRECH_CONFIG register : DRAM precharge policy configration register
;--------------------------------------------------------------------
DMC1_FP_CNT		EQU	0x20		;	force precharge counter max.0xff (mclk cyc)
DMC1_CHIP1_POLICY	EQU	0		;	chip1 precharge policy per bank 0(bitwise):open page policy, 1(bitwise):close page policy
DMC1_CHIP0_POLICY	EQU	0		;	chip0 precharge policy per bank 0(bitwise):open page policy, 1(bitwise):close page policy

;--------------------------------------------------------------------
; DMC1_PWRDN_CONFIG register : DRAM power down configration register
;--------------------------------------------------------------------
DMC1_DSREF_CYC		EQU	0x10		; 	cycle for dynamic self refresh entry max.0xffff (aclk)
DMC1_DPWRDN_CYC		EQU	4		; 	cycle for dynamic power down entry max.0xff (aclk)

;--------------------------------------------------------------------
; DMC1_TIMING_AREF register : refresh cycle register
;--------------------------------------------------------------------
DMC1_T_REFI		EQU	(10*(DMC1_HCLK_KHZ/1000*DMC1_DRAM_tREFRESH)/1000+9)/10	; 	refresh cycle 
						;	7.8us*200MHz=1560(0x619)
						;	7.8us*166MHz=1295(0x50F)
						;	7.8us*133MHz=1038(0x40E)
						;	7.8us*100MHz=780(0x30C)
						;	7.8us*25MHz=195(0xC3)
						;	7.8us*12MHz=94(0x5E)

;--------------------------------------------------------------------
; DMC1_PHY_CONTROL0 register : PHY control 0 register
;--------------------------------------------------------------------
DMC1_CTRL_FORCE		EQU	0		;	DLL force - max.0xff
DMC1_CTRL_INC		EQU	0x10		;	Increase amount - max.0xff
DMC1_CTRL_START_POINT	EQU	0x10		;	DLL lock start point - max.0xff

DMC1_DQS_DELAY   	EQU	0		;	Delay Cycles or DQS Cleaning
DMC1_DF_DQS 		EQU	DMC1_DF_DQS0	; 	Differential DQS

DMC1_CTRL_HALF		EQU	0		; 	DLL low speed
DMC1_CTRL_DLL_ON	EQU	0		; 	DLL on
DMC1_CTRL_START		EQU	0		; 	DLL start

;--------------------------------------------------------------------
; DMC1_PHY_CONTROL1 register : PHY control 1 register
;-------------------------------------------------------------------
DMC1_CTRL_OFFSETD	EQU	0		;	offset for debug - max.0x7f
DMC1_CTRL_OFFSETC	EQU	0		;	gate offset - max.0x7f 
DMC1_CTRL_SHIFTC	EQU	DMC1_CTRL_SHIFTC0	;	gateout signal delay - 0:T/128, 1:T/64, 2:T/32, 3:T/16, 4:T/8, 5:T/4, 6:T/2, 7:T

;--------------------------------------------------------------------
; DMC1_PHY_CONTROL2 register : PHY control 2 register
;-------------------------------------------------------------------
DMC1_CTRL_OFFSET3	EQU	0		;	offset for debug - max.0x7f
DMC1_CTRL_OFFSET2	EQU	0		;	offset for debug - max.0x7f
DMC1_CTRL_OFFSET1	EQU	0		;	offset for debug - max.0x7f
DMC1_CTRL_OFFSET0	EQU	0		;	offset for debug - max.0x7f

;	ENDIF
             
	END

