/**************************************************************************************
* 
*	Project Name : S5PC100 Validation
*
*	Copyright 2007 by Samsung Electronics, Inc.
*	All rights reserved.
*
*	Project Description :
*		This software is only for validating functions of the S5PC100.
*		Anybody can use this software without our permission.
*  
*--------------------------------------------------------------------------------------
* 
*	File Name : dmc.h
*  
*	File Description : This file declares prototypes of low power DRAM controller. (LPCON)
*
*	Author : Joonsoo Jeon
*	Dept. : AP Development Team
*	Created Date : 2007/11/13
*	Version : 0.1 
* 
*	History
*	- Created(Joonsoo Jeon 2007/11/05)
*  
**************************************************************************************/

#ifndef __DMC_H__
#define __DMC_H__



#include <stdio.h>

#include "def.h"

// *** setting parameters of DMC functions
// data swap
#define DQ_SWAP_EN		1
#define DQ_SWAP_DIS		0
// PHY data pad drive
#define PHY_DRV_EN		1
#define PHY_DRV_DIS		0
// PHY drive Type
#define DRV_ALL_ZERO	0
#define DRV_PULL_DOWN	1

// Read cycle gap for two different chips
#define READ_GAP_EN		1
#define READ_GAP_DIS	0
// Clock ratio
#define CLK_RATIO_1_1	0

// Out of order scheduling
#define OUT_ORDER_EN	1
#define OUT_ORDER_DIS	0

// Burst length
#define DMC_BURST2		1
#define DMC_BURST4		2
#define DMC_BURST8		3
#define DMC_BURST16		4
// Chip select 
#define CHIP_0			0
#define CHIP_1			1
#define CHIP_BOTH		2 
// Selecting DRAM type
#define DT_LPDDR		1
#define DT_LPDDR2		2
//#define DT_DDR			3
#define DT_DDR2			4
// Add latency of PALL
#define ADD_LAT_PALL0	0
#define ADD_LAT_PALL1	1
#define ADD_LAT_PALL2	2
#define ADD_LAT_PALL3	3

// Address mapping method
#define MAP_LINEAR		0
#define MAP_INTERLEAVED	1
#define MAP_MIXED1      2
// Column address
#define COL_ADDR7		0
#define COL_ADDR8		1
#define COL_ADDR9		2
#define COL_ADDR10		3
#define COL_ADDR11		4
#define COL_ADDR12		5
// Row address
#define ROW_ADDR12		0
#define ROW_ADDR13		1
#define ROW_ADDR14		2
#define ROW_ADDR15		3
// Number of banks
#define NUM_BANK1		0
#define NUM_BANK2		1
#define NUM_BANK4		2
#define NUM_BANK8		3

// Command index
#define CMD_MRS			0	// mode register setting MRS/EMRS
#define CMD_PALL		1	// all bank precharge
#define CMD_PRE			2	// per bank precharge
#define CMD_DPD			3	// deep power down
#define CMD_REFS		4	// self refresh
#define CMD_REFA		5	// auto refresh
#define CMD_CKEL		6	// active/precharge power down
#define CMD_NOP			7	// exit from power down
#define CMD_REFSX		8	// exit from self refresh
#define CMD_MRR			9	// mode register reading

// Auto refresh enable
#define AREF_EN			1
#define AREF_DIS		0

// QoS enable
#define QOS_EN			1
#define QOS_DIS			0

// Timeout Precharge
#define TimeOut_PreEn	1
#define TimeOut_PreDis	0
// Force precharge
#define FORCE_PRE_EN			1
#define FORCE_PRE_DIS			0
// Dynamic power down 
#define DYN_POWER_DOWND_EN		1
#define DYN_POWER_DOWND_DIS		0
// Dynamic self refresh
#define DYN_SELF_REFRESH_EN		1
#define DYN_SELF_REFRESH_DIS	0
// Type of dynamic power down
#define FORCE_PRE_POWER_DOWN	1
#define ACTIVE_POWER_DOWN		0
// Dynamic clock control
#define DYN_CLK_CONTROL_EN		1
#define DYN_CLK_CONTROL_DIS		0

// Use LPCON 2Port
#define LPCON_Port		2 //LPCON DMC0 0, DMC1 1, Both DMC0,1 2
#define v210_DMC0				0
#define v210_DMC1				1


typedef enum 
{
	eARM_TM =0, 		
	eMFC_TM, 		
	eG3D_TM,			
	eFIMC0_TM,		
	eFIMC1_TM,		
	eFIMC2_TM,		
	eJPEG_TM,			
	eROT_TM,			
	eFIMD_W0_TM, 	
	eFIMD_W1_TM, 	
	eFIMD_W2_TM, 	
	eFIMD_W3_TM,		
	eFIMD_W4_TM, 	
	eVP_TM,			
	eMIXER_GRP0_TM,	
	eMIXER_GRP1_TM,	
	eSSYS_TM,		
	eGSYS_TM,		
	eESYS0_TM,		
	eESYS1_TM,		
	eCSYS_TM,		
	eUSYS_TM,		
	eAUDIO_TM,		
	ePDMA0_TM,		
	ePDMA1_TM,		
	eMDMA_TM		
}TRANS_MASTER;



typedef enum 
{
	ONEDRAM_A_PORT, ONEDRAM_B_PORT
}ONEDRAM_SEMAPHORE;

// *** function defines
//void DMC_SetDmcControl(u8 ucDqSwap, u8 ucPhyDrvEn, u8 ucChipReadGap, u8 ucClkRatio);
void DMC_SetDmcControl(u8 ucQosFastEn, u8 ucDqSwap, u8 ucPhyDrvEn, u8 ucChipReadGap, u8 ucClkRatio);
void DMC_SetEnhancedUtility(u16 usQToutCnt, u8 ucReadFetchDly, u8 ucOutOfOder);
void DMC_SetMemControl(u8 ucBurstLength, u8 ucChips, u8 ucMemType, u8 ucAddLatencyPall);
void DMC_SetMemAddrConfig(u8 ucChipNum, u8 ucBaseAddr, u8 ucBaseMask, u8 ucMapMethod, u8 ucColAddr, u8 ucRowAddr, u8 ucBanks);
void DMC_ChangeBurstLength(u8 ucBurstLength);
void DMC_ChangeMapMethod(u8 ucChipNum, u8 ucMapMethod);
void DMC_SendCommand(u8 ucChipNum, u8 ucCmd, u8 ucCmdBank, u16 ucCmdAddr);
u32 DMC_GetBankStatus(u8 ucChipNum);
u32 DMC_GetQueueEmpty(u8 ucChipNum);
u32 DMC_GetUsingDramType(void);

void DMC_SetAutoRefresh(u8 ucArefEn, u16 usArefInterval);
void DMC_SetRowTimingParameters(u8 ucTrfc, u8 ucTrrd, u8 ucTrp, u8 ucTrcd, u8 ucTrc, u8 ucTras);
void DMC_SetDataTimingParameters(u8 ucTwtr, u8 ucTwr, u8 ucTrtp, u8 ucCl, u8 ucWl, u8 ucRl);
void DMC_SetPowerModeTimingParameters(u8 ucTfaw, u8 ucTxsr, u8 ucTxp, u8 ucTcke, u8 ucTmrd);

void DMC_SetPrechPolicy(u8 ucChip0PrechPolicy, u8 ucChip1PrechPolicy);
void DMC_SetPowerDownCounter(u8 ucForcePrechCnt, u8 ucDPwrDnCnt, u16 usDSrefCnt);
void DMC_SetPowerDownModes(u8 ucForcePrechEn, u8 ucDPwrDnEn, u8 ucDSrefEn, u8 ucDPwrDnType, u8 ucClkStop);

void DMC_SetQosConfig(u8 ucQosNum, u16 usQosCnt, u8 ucQosEn, u16 usQosMask, u16 usQosId);
void DMC_ChangeDramParameter(u32 , u32);
void DMC_PreChangeDramParameter(void);

void DMC_InitDmc(void); 
void Drive_Strenth(void);

void DMC_2PORT_InitDmc(void);
void DMC_SetCh(s32 uCh);

//void DMC_Init_KAC00F00XM(void);
//void DMC_Init_K4X1G163PC(void);
void DMC_Init_K4T1G084QQ(void);
void DMC_Init_K4T2G084QA(void);
void DMC_Assem_Init_McpHtype(void);

void DMC_Init_McpHtype(void);
void DMC_Init_McpACtype(void);
void DMC_DriveStrength(u32 uDrv, u32 uSlew);
void DMC_PhyDriving(u8 ucDmcCh, u8 ucDrven, u8 ucType);
void DMC_QosClean(u8 ucDmcCh,u8 ucOffsetd,u8 ucOffsetc,u8 ucShiftc);
void DMC_ChangeRef(u32 uDMC0Tref,u32 uDMC1Tref);
void DMC_DownChangeClk(u32 uDmc0Mux,u32 uDmc0Div,u32 uDmc1Mux,u32 uDmc1Div );
void DMC_SetDQSn(u8 ucDmcCh, u8 ucDQSn);
void DMC_SetQosParameter(u8 ucDmcCh, TRANS_MASTER eMaster,u8 ucFastQosEn,u16 usFastQosCnt, u8 ucQosEn, u16 usQosCnt);



#endif //__DMC_H__



