
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "option.h"
#include "library.h"
#include "def.h"
#include "dma.h"
#include "intc.h"

#include "audi_ondc.h"

//JHHEO:2008/8/6 ==> 
//#include "ondc_test.h"
#include "string.h"
//JHHEO:2008/8/6 <== 

//static ONDC oOndc;
//static INTC oIntc;

volatile static u8 bIsOndcTestAll;
volatile static u8 bIsOKOndcTestAll;

//static u8 bIsOndcAutoTest;

#define AUTO_TEST 
extern volatile u8 gAuto_test;
extern void ChangeBufferSize(u32 PageSize);

static void TestSetSyncMode(void)
{
	u32 sel,prefetch;
	Disp(" Select prefetch enable or not\n");
	Disp("  0: disable    1: enable \n");
	prefetch = UART_GetIntNum(); 
	
	Disp(" Select OND Dram Access Method\n");
	Disp("  0: Async\n");
	Disp("  1: Sync burst continuous\n"); 
	Disp("  2: Sync burst4\n");
	Disp("  3: Sync burst8\n");
	Disp("  4: Sync burst16\n"); 
	Disp("  5: Sync burst32\n");
	Disp("  6: Sync burst1K\n");
	Disp("  Input Number : ");
	sel = UART_GetIntNum();
	if (sel == 0)
		OND_SetSyncMode(OND_ASYNC,prefetch);
	else if (sel == 1)
		OND_SetSyncMode(OND_SYNC_BURST_CONT,prefetch);
	else if (sel == 2)
		OND_SetSyncMode(OND_SYNC_BURST4,prefetch);
	else if (sel == 3)
		OND_SetSyncMode(OND_SYNC_BURST8,prefetch);
	else if (sel == 4)
		OND_SetSyncMode(OND_SYNC_BURST16,prefetch);
	else if (sel == 5)
		OND_SetSyncMode(OND_SYNC_BURST32,prefetch);
	else if (sel == 6)
		OND_SetSyncMode(OND_SYNC_BURST1K,prefetch);	
	else
		Disp(" Invalid Selection\n");
}

static void TestWarmReset(void)
{
	Disp(" Warm Reset\n");
	OND_ResetDevice(OND_WARM_RESET);
}

static void TestCoreReset(void)
{
	Disp(" Core Reset\n");
	OND_ResetDevice(OND_CORE_RESET);
}

static void TestHotReset(void)
{
	Disp(" Hot Reset\n");
	OND_ResetDevice(OND_HOT_RESET);
}

static void TestEraseAllBlocks(void)
{
	u8 bIsOK;
	
	bIsOK = OND_EraseAllBlocks();
	if (bIsOK==false) 
		Disp(" Fail erase all\n");
	else 
		Disp(" O.K. erase all\n");	
}

static void TestProtectionOneBlock(void)
{
	u32 uBlkAddr;
	u8 bIsOK = true;
	Disp(" Input block index : ");
	uBlkAddr = UART_GetIntNum();

	// 1. unlockall
	bIsOK = OND_UnlockAll();
	if ( bIsOK == false )
		Disp( " Fail UnlockAll\n" );
	else
		Disp( " O.K. UnlockAll\n" );
	// 2. lock
	bIsOK = OND_LockBlocks( uBlkAddr,1 );
	if ( bIsOK == false )
		Disp( " Fail LockOneBlock\n" );
	else
		Disp( " O.K. LockOneBlock\n" );	
	// 3. unlock
	bIsOK = OND_UnlockBlocks( uBlkAddr,1 );
	if ( bIsOK == false )
		Disp( " Fail UnlockOneBlock\n" );
	else
		Disp( " O.K. UnlockOneBlock\n" );
	// 4. erase
	bIsOK = OND_EraseBlocks( uBlkAddr,1 );
	if ( bIsOK == false )
		Disp( " Fail EraseOneBlock\n" );
	else
		Disp( " O.K. EraseOneBlock\n" );	
	// 5. lock
	bIsOK = OND_LockBlocks( uBlkAddr,1 );
	if ( bIsOK == false )
		Disp( " Fail LockOneBlock\n" );
	else
		Disp( " O.K. LockOneBlock\n" );	
	// 6. locktight
	bIsOK = OND_LockBlocksTightly( uBlkAddr,1 );
	if ( bIsOK == false )
		Disp( " Fail LockTightOneBlock\n" );
	else
		Disp( " O.K. LockTightOneBlock\n" );	
	// 7. warm reset
	OND_ResetDevice(OND_WARM_RESET); Disp( " Warm reset\n" );
	// 8. unlock
	bIsOK = OND_UnlockBlocks( uBlkAddr,1 );
	if ( bIsOK == false )
		Disp( " Fail UnlockOneBlock\n" );
	else
		Disp( " O.K. UnlockOneBlock\n" );
	
	// 9. unlockall
	bIsOK = OND_UnlockAll();
	if ( bIsOK == false )
		Disp( " Fail UnlockAll\n" );
	else
		Disp( " O.K. UnlockAll\n" );
}

static void TestProtectionMultiBlocks(void)
{
	u8 bIsOK = true;
	u32 uStartBlkAddr;
	u32 uNumOfBlocks;
	
	Disp(" Input start block index : ");
	uStartBlkAddr = UART_GetIntNum();

	Disp(" How many blocks : ");
	uNumOfBlocks = UART_GetIntNum();

	// 1. unlockall
	bIsOK = OND_UnlockAll();
	if ( bIsOK == false )
		Disp( " Fail UnlockAll\n" );
	else
		Disp( " O.K. UnlockAll\n" );
	// 2. lock
	bIsOK = OND_LockBlocks( uStartBlkAddr, uNumOfBlocks );
	if ( bIsOK == false )
		Disp( " Fail LockMultiBlocks\n" );
	else
		Disp( " O.K. LockMultiBlocks\n" );		
	// 3. unlock
	bIsOK = OND_UnlockBlocks( uStartBlkAddr, uNumOfBlocks );
	if ( bIsOK == false )
		Disp( " Fail UnlockMultiBlocks\n" );
	else
		Disp( " O.K. UnlockMultiBlocks\n" );
	// 4. erase
	bIsOK = OND_EraseBlocks( uStartBlkAddr, uNumOfBlocks );
	if ( bIsOK == false )
		Disp( " Fail EraseMultiBlocks\n" );
	else
		Disp( " O.K. EraseMultiBlocks\n" );		
	// 5. lock
	bIsOK = OND_LockBlocks( uStartBlkAddr, uNumOfBlocks );
	if ( bIsOK == false )
		Disp( " Fail LockMultiBlocks\n" );
	else
		Disp( " O.K. LockMultiBlocks\n" );		
	// 6. locktight
	bIsOK = OND_LockBlocksTightly( uStartBlkAddr, uNumOfBlocks );
	if ( bIsOK == false )
		Disp( " Fail LockTightMultiBlocks\n" );
	else
		Disp( " O.K. LockTightMultiBlocks\n" );		
	// 7. warm reset
	OND_ResetDevice(OND_WARM_RESET); Disp( " Warm reset\n" );

	// 8. unlock
	bIsOK = OND_UnlockBlocks( uStartBlkAddr, uNumOfBlocks );
	if ( bIsOK == false )
		Disp( " Fail UnlockMultiBlocks\n" );
	else
		Disp( " O.K. UnlockMultiBlocks\n" );	
	// 9. unlockall
	bIsOK = OND_UnlockAll();
	if ( bIsOK == false )
		Disp( " Fail UnlockAll\n" );
	else
		Disp( " O.K. UnlockAll\n" );	
}

static void TestProgramAndLoad(void)
{		
	u8 bIsOK = true;
	u32 uSrcAddr = CODEC_MEM_ST+0x10000;
	u32 uDstAddr = CODEC_MEM_ST+0x20000;
	u32 uBlockAddr;
	u32 uPageAddr;
	u32 uPageByteSize;
	u32 i;
	 
	// 1. Input block and page index
	// -----------------------------
	u32 uTotalNumOfBlocks;


	OND_INT_SET_VEC();

	OND_GetTotalNumOfBlocks(&uTotalNumOfBlocks);
	Disp(" Input block index(0~%d) : ", uTotalNumOfBlocks-1);
	uBlockAddr = UART_GetIntNum();
	Disp(" Input page index(0~63) : ");
	uPageAddr = UART_GetIntNum();

	// 2. Init and clear buffer
	// ------------------------
	
	OND_GetPageSz(&uPageByteSize);
	Disp("uPageByteSize = %d",uPageByteSize);
	for (i=uSrcAddr; i<uSrcAddr+uPageByteSize; i+=4 )	
		Outp32( i, rand() );
	for (i=uDstAddr; i<uDstAddr+uPageByteSize; i+=4 )	
		Outp32( i, 0 );

	// 3. Erase block
	// --------------
//	OND_EraseAllBlocks();
	bIsOK = OND_EraseBlocks( uBlockAddr,1 );
	if ( bIsOK == false )
		Disp( " Fail to erase\n");
	else
		Disp( " O.K. Erase\n");

	
	// 4. Program page
	// ---------------
	bIsOK = OND_ProgramPages( uSrcAddr, uBlockAddr, uPageAddr,1);
	if ( bIsOK == false )
		Disp( " Fail to program\n" );
	else
		Disp( " O.K. Program\n" );

	// 5. Load page
	// ------------
	bIsOK = OND_ReadPages( uDstAddr, uBlockAddr, uPageAddr ,1);
	if ( bIsOK == false )
		Disp( " Fail to load\n" );
	else
		Disp( " O.K. Load\n" );

	// 6. Compare
	// ----------
	//bIsOK = Compare8( uSrcAddr, uDstAddr, uPageByteSize );
	bIsOK = memcmp( (void*)uSrcAddr, (void*)uDstAddr, uPageByteSize );
	//if ( !bIsOndcTestAll )
	//{	
	Disp( " Src Addr=0x%x, Dst Addr=0x%x uPageByteSize = %d \n", uSrcAddr, uDstAddr,uPageByteSize );
	Dump32( uSrcAddr, 32 );
	Dump32( uDstAddr, 32 );
	if( bIsOK != 0 )
		Disp(" Fail Compare\n");
	else
		Disp(" O.K. Compare\n");	
//}
//	else // Test All
	//	if (bIsOK != 0) uErrCnt++;
		
	if ( bIsOK == 0 )
		bIsOKOndcTestAll = true;
	else
		bIsOKOndcTestAll = false;	

}

static void TestProgramAndLoad_SQC(void)
{		
	u8 bIsOK = true;
	u32 uSrcAddr = CODEC_MEM_ST+0x10000;
	u32 uDstAddr = CODEC_MEM_ST+0x20000;
	u32 uBlockAddr;
	u32 uPageAddr;
	u32 uPageByteSize;
	u32 i;
	 
	// 1. Input block and page index
	// -----------------------------
	u32 uTotalNumOfBlocks;

	OND_SQC_Init();

	
	OND_GetTotalNumOfBlocks(&uTotalNumOfBlocks);
	Disp(" Input block index(0~%d) : ", uTotalNumOfBlocks-1);
	uBlockAddr = UART_GetIntNum();
	Disp(" Input page index(0~63) : ");
	uPageAddr = UART_GetIntNum();

	// 2. Init and clear buffer
	// ------------------------
	
	OND_GetPageSz(&uPageByteSize);
	for (i=uSrcAddr; i<uSrcAddr+uPageByteSize; i+=4 )	
		Outp32( i, rand() );

	for (i=uDstAddr; i<uDstAddr+uPageByteSize; i+=4 )	
		Outp32( i, 0 );

	// 3. Erase block
	// --------------
//	OND_EraseAllBlocks();
	bIsOK = OND_EraseBlocks( uBlockAddr,1 );
	if ( bIsOK == false )
		Disp( " Fail to erase\n");
	else
		Disp( " O.K. Erase\n");
	
	// 4. Program page
	// ---------------
	bIsOK = OND_SQC_ProgramPages( uSrcAddr, uBlockAddr, uPageAddr,1 );
	if ( bIsOK == false )
		Disp( " Fail to program\n" );
	else
		Disp( " O.K. Program\n" );
	
	// 5. Load page
	// ------------
	bIsOK = OND_SQC_ReadPages( uDstAddr, uBlockAddr, uPageAddr ,1);
	if ( bIsOK == false )
		Disp( " Fail to load\n" );
	else
		Disp( " O.K. Load\n" );

	// 6. Compare
	// ----------
	//bIsOK = Compare8( uSrcAddr, uDstAddr, uPageByteSize );
	bIsOK = memcmp( (void*)uSrcAddr, (void*)uDstAddr, uPageByteSize );
	//if ( !bIsOndcTestAll )
	//{	
	Disp( " Src Addr=0x%x, Dst Addr=0x%x uPageByteSize = %d \n", uSrcAddr, uDstAddr,uPageByteSize );
	Dump32( uSrcAddr, 32 );
	Dump32( uDstAddr, 32 );
	if( bIsOK != 0 )
		Disp(" Fail Compare\n");
	else
		Disp(" O.K. Compare\n");	


//}
//	else // Test All
	//	if (bIsOK != 0) uErrCnt++;
		
	if ( bIsOK == 0 )
		bIsOKOndcTestAll = true;
	else
		bIsOKOndcTestAll = false;	

}



static void TestMultipleProgramAndLoad(void)
{	
	u8 bIsOK = true;
	u32 uSrcAddr = CODEC_MEM_ST+0x10000;
	u32 uDstAddr = CODEC_MEM_ST+0x20000;

	// 1. Input block and page index
	// -----------------------------
	u32 uTotalNumOfBlocks;
	u32 uBlockAddr;
	u32 uPageAddr;
	u32 uNumOfPages;
	u32 uPageByteSize;
	u32 i;
	u32 uErrCnt = 0;
	u32 uTime=0;

	OND_INT_SET_VEC();

#if 1
	OND_GetTotalNumOfBlocks(&uTotalNumOfBlocks);
	Disp(" Input block index(0~%d) : ", uTotalNumOfBlocks-1);
	uBlockAddr = UART_GetIntNum();
	Disp(" Input page index(0~63) : ");
	uPageAddr = UART_GetIntNum();
	Disp(" Input Num. of Pages : ");
	uNumOfPages = UART_GetIntNum();
#else
	if(gAuto_test==0)
	{
		OND_GetTotalNumOfBlocks(&uTotalNumOfBlocks);
		Disp(" Input block index(0~%d) : ", uTotalNumOfBlocks-1);
		uBlockAddr = UART_GetIntNum();
		Disp(" Input page index(0~63) : ");
		uPageAddr = UART_GetIntNum();
		Disp(" Input Num. of Pages : ");
		uNumOfPages = UART_GetIntNum();
	}
	else
	{
		Disp(" Input block index(0~%d) : 0 ", uTotalNumOfBlocks-1);
		uBlockAddr = 0;
		Disp(" Input page index(0~63) : 0 ");
		uPageAddr = 0;
		Disp(" Input Num. of Pages : 10");
		uNumOfPages = 63;
	}
#endif

	Disp("uSrcAddr= 0x%x\n",uSrcAddr);
	Disp("uDstAddr= 0x%x\n",uDstAddr);

	// 2. Init and clear buffer
	// ------------------------
	
	OND_GetPageSz(&uPageByteSize);
		Disp("uPageByteSize = %d",uPageByteSize);
	for (i=uSrcAddr; i<uSrcAddr+(uPageByteSize*uNumOfPages); i+=4 )	
		Outp32( i, rand() );
	for (i=uDstAddr; i<uDstAddr+(uPageByteSize*uNumOfPages); i+=4 )	
		Outp32( i, 0 );

	// 3. Erase block
	// --------------
	bIsOK = OND_EraseBlocks( uBlockAddr,1 );
	if ( bIsOK == false )
		Disp( " Fail to erase\n");
	else
		Disp( " O.K. Erase\n" );

	// 4. Program page
	// ---------------
	
	bIsOK = OND_ProgramPages( uSrcAddr, uBlockAddr, uPageAddr,uNumOfPages);
	if ( bIsOK == false )
		Disp( " Fail to program\n" );
	else
		Disp( " O.K. Program\n" );

			
	// 5. Load page
	// ------------
	
	bIsOK = OND_ReadPages( uDstAddr, uBlockAddr, uPageAddr, uNumOfPages );
	if ( bIsOK == false )
		Disp( " Fail to load\n" );
	else
		Disp( " O.K. Load\n" );
	
	// 6. Compare
	// ----------
	//bIsOK = Compare8( uSrcAddr, uDstAddr, (uPageByteSize*uNumOfPages) );
	bIsOK = memcmp( (void*)uSrcAddr, (void*)uDstAddr, uPageByteSize*1);
	
		if ( !bIsOndcTestAll )
		{
			Disp( " Src Addr=0x%x, Dst Addr=0x%x\n", uSrcAddr, uDstAddr );
			Dump32( uSrcAddr, 8 );
	        Dump32( uDstAddr, 8 );
			if( bIsOK != 0 )
				Disp(" Fail Compare\n");
			else
				Disp(" O.K. Compare\n");
		}
		else // Test All
			if (bIsOK != 0) uErrCnt++;
			
		if ( bIsOK == 0 )
			bIsOKOndcTestAll = true;
		else
			bIsOKOndcTestAll = false;	

}

static void TestMultipleProgramAndLoad_SQC(void)
{	
	u8 bIsOK = true;
	u32 uSrcAddr = CODEC_MEM_ST+0x100000;
	u32 uDstAddr = CODEC_MEM_ST+0x200000;

	// 1. Input block and page index
	// -----------------------------
	u32 uTotalNumOfBlocks;
	u32 uBlockAddr;
	u32 uPageAddr;
	u32 uNumOfPages;
	u32 uPageByteSize;
	u32 i;
	u32 uErrCnt = 0;
	u32 uTime=0;

	OND_SQC_Init();


	
	OND_GetTotalNumOfBlocks(&uTotalNumOfBlocks);
	Disp(" Input block index(0~%d) : ", uTotalNumOfBlocks-1);
	uBlockAddr = UART_GetIntNum();
	Disp(" Input page index(0~63) : ");
	uPageAddr = UART_GetIntNum();
	Disp(" Input Num. of Pages : ");
	uNumOfPages = UART_GetIntNum();
	
	// 2. Init and clear buffer
	// ------------------------
	
	OND_GetPageSz(&uPageByteSize);
	for (i=uSrcAddr; i<uSrcAddr+(uPageByteSize*uNumOfPages); i+=4 )	
		Outp32( i, rand() );
	for (i=uDstAddr; i<uDstAddr+(uPageByteSize*uNumOfPages); i+=4 )	
		Outp32( i, 0 );

	// 3. Erase block
	// --------------
//	OND_EraseAllBlocks();
	bIsOK = OND_EraseBlocks( uBlockAddr,1 );
	if ( bIsOK == false )
		Disp( " Fail to erase\n");
	else
		Disp( " O.K. Erase\n" );
		
	StartTimer(0);

	// 4. Program page
	// ---------------
//	bIsOK = OND_ProgramPages( uSrcAddr, uBlockAddr, uPageAddr,uNumOfPages );
	bIsOK = OND_SQC_ProgramPages( uSrcAddr, uBlockAddr, uPageAddr, uNumOfPages);
	if ( bIsOK == false )
		Disp( " Fail to program\n" );
	else
		Disp( " O.K. Program\n" );

	uTime = StopTimer(0);
	
	Disp("(%3.3fMB/s,%3.3fs)\n",((float)uNumOfPages*uPageByteSize/uTime*1000000/1024/1024.),((float)uTime/1000000));
/*	OND_WaitForIntStatus(ONDC_INTACT);
	OND_ClearPending(ONDC_INTACT);
	OND_WaitForIntStatus(ONDC_PGMCMP);
	OND_ClearPending(ONDC_PGMCMP); */
	
	// 5. Load page
	// ------------
	StartTimer(0);

//	bIsOK = OND_ReadPages( uDstAddr, uBlockAddr, uPageAddr, uNumOfPages );
	bIsOK = OND_SQC_ReadPages( uDstAddr, uBlockAddr, uPageAddr, uNumOfPages );
	if ( bIsOK == false )
		Disp( " Fail to load\n" );
	else
		Disp( " O.K. Load\n" );

	uTime = StopTimer(0);
	
	Disp("(%3.3fMB/s,%3.3fs)\n",((float)uNumOfPages*uPageByteSize/uTime*1000000/1024/1024.),((float)uTime/1000000));
/*	OND_WaitForIntStatus(ONDC_INTACT);
	OND_ClearPending(ONDC_INTACT);
	OND_WaitForIntStatus(ONDC_LOADCMP);
	OND_ClearPending(ONDC_LOADCMP); */



	// 6. Compare
	// ----------
	//bIsOK = Compare8( uSrcAddr, uDstAddr, (uPageByteSize*uNumOfPages) );
	bIsOK = memcmp( (void*)uSrcAddr, (void*)uDstAddr, uPageByteSize*uNumOfPages);
	
		if ( !bIsOndcTestAll )
		{
			Disp( " Src Addr=0x%x, Dst Addr=0x%x\n", uSrcAddr, uDstAddr );
			Dump32( uSrcAddr, 32 );
	        Dump32( uDstAddr, 32 );
			if( bIsOK != 0 )
				Disp(" Fail Compare\n");
			else
				Disp(" O.K. Compare\n");
		}
		else // Test All
			if (bIsOK != 0) uErrCnt++;
			
		if ( uErrCnt == 0 )
			bIsOKOndcTestAll = true;
		else
			bIsOKOndcTestAll = false;	
}

static void ProgramBootImage(void)
{
	// Assert Flex-OND
	// -------------------
	
	u8 bIsOK = true;
	u32 uSrcAddr = CODEC_MEM_ST+0x100000;
	u32 uDstAddr = CODEC_MEM_ST+0x200000;
	u32 uBlockAddr;
	u32 uPageAddr;
	u32 uNumOfPages;
	u32 uPageByteSize;
	u32 uErrCnt = 0;
	
	// 1. Input block and page index
	// -----------------------------
	u32 uTotalNumOfBlocks;
	OND_GetTotalNumOfBlocks(&uTotalNumOfBlocks);
	Disp(" Input block index(0~%d) : ", uTotalNumOfBlocks-1);
	uBlockAddr = UART_GetIntNum();
	Disp(" Input page index(0~63) : ");
	uPageAddr = UART_GetIntNum();
	Disp(" Input Num. of Pages : ");
	uNumOfPages = UART_GetIntNum();
	
	// 2. Init and clear buffer
	// ------------------------
	
	OND_GetPageSz(&uPageByteSize);
	Disp(" Download Boot Program to 0x%x with RVDS\n", uSrcAddr);
	UART_GetIntNum();
	
	// 3. Erase block
	// --------------
	bIsOK = OND_EraseBlocks( uBlockAddr,1 );
	if ( bIsOK == false )
		Disp( " Fail to erase\n");

	// 4. Program page
	// ---------------
	bIsOK = OND_ProgramPages( uSrcAddr, uBlockAddr, uPageAddr, uNumOfPages);
	if ( bIsOK == false )
		Disp( " Fail to program\n" );
	else
		Disp( " O.K. Program Page\n" );
/*	OND_WaitForIntStatus(ONDC_INTACT);
	OND_ClearPending(ONDC_INTACT);
	OND_WaitForIntStatus(ONDC_PGMCMP);
	OND_ClearPending(ONDC_PGMCMP); */

	
	// 5. Load page
	// ------------
	bIsOK = OND_ReadPages( uDstAddr, uBlockAddr, uPageAddr, uNumOfPages );
	if ( bIsOK == false )
		Disp( " Fail to load\n" );
	else
		Disp( " O.K. Load Page\n" );
/*	OND_WaitForIntStatus(ONDC_INTACT);
	OND_ClearPending(ONDC_INTACT);
	OND_WaitForIntStatus(ONDC_LOADCMP);
	OND_ClearPending(ONDC_LOADCMP); */
	
	// 6. Compare
	// ----------
	//bIsOK = Compare8( uSrcAddr, uDstAddr, (uPageByteSize*uNumOfPages) );
	bIsOK = memcmp( (void*)uSrcAddr, (void*)uDstAddr, (uPageByteSize*uNumOfPages) );
	if ( !bIsOndcTestAll )
		{
			Disp( " Src Addr=0x%x, Dst Addr=0x%x\n", uSrcAddr, uDstAddr );
			Dump32( uDstAddr+2032, 32 );
			if( bIsOK == 0 )
				Disp(" O.K Compare \n");
			else
				Disp(" Fail Compare \n");
		}
		else // Test All
			if (bIsOK != 0) uErrCnt++;
			
		if ( uErrCnt == 0 )
			bIsOKOndcTestAll = true;
		else
			bIsOKOndcTestAll = false;	
}

static void TestUnlockAllBlocks(void)
{
	u8 bIsOK;

	bIsOK = OND_UnlockAll();
	if (bIsOK==false) 
		Disp(" Fail Unlock all\n");
	else 
		Disp(" O.K. Unlock all\n");
}

static TestLockBlocksTightly(void)
{
	u8 bIsOK;
	u32 uBlockIndex,uNumOfBlocks;
	u32 uTotalNumOfBlocks;

	OND_GetTotalNumOfBlocks(&uTotalNumOfBlocks);
	Disp(" Input block index(0~%d) : ", uTotalNumOfBlocks-1);
	uBlockIndex = UART_GetIntNum();
	Disp(" Input number of block(%d~) : ",uBlockIndex);
	uNumOfBlocks = UART_GetIntNum();
	

	bIsOK =OND_LockBlocksTightly(uBlockIndex, uNumOfBlocks );
	if (bIsOK==false) 
		Disp(" Fail Lock tight all\n");
	else 
		Disp(" O.K. Lock tight %d ~ %d \n",uBlockIndex,uBlockIndex+uNumOfBlocks);
}


static void TestCopyBack(void)
{
	u8 bIsOK;
	u32 uTotalNumOfBlocks;
	u32 uSrcBlkAddr;
	u32 uSrcPageAddr;
	u32 uDstBlkAddr ;
	u32 uDstPageAddr;
	u32 uPageCount;
	u32 Data;
	u32 uReceiveData;
	u32* pData;
	u32* pRData;
	u32 i;
	u32 uPageByteSize;
	
	
	OND_GetTotalNumOfBlocks(&uTotalNumOfBlocks);
	Disp(" Input src block index(0~%d) : ", uTotalNumOfBlocks-1);
	uSrcBlkAddr = UART_GetIntNum();
	Disp(" Input src page index(0~63) : ");
	uSrcPageAddr = UART_GetIntNum();
	Disp(" Input dst block index(0~%d) : ", uTotalNumOfBlocks-1);
	uDstBlkAddr = UART_GetIntNum();
	Disp(" Input dst page index(0~63) : ");
	uDstPageAddr = UART_GetIntNum();
	Disp(" Num. Of Page : ");	
	uPageCount = UART_GetIntNum();
	
	Data = CODEC_MEM_ST+0x10000;	
	uReceiveData = CODEC_MEM_ST+0x20000;
	pData = (u32*)Data;
	pRData = (u32*)uReceiveData;

	// 1. Erase Src block addr and Dst block addr
	bIsOK = OND_EraseBlocks(uSrcBlkAddr,1);
	bIsOK = OND_EraseBlocks(uDstBlkAddr,1);
	if (bIsOK==false) 
		Disp(" Fail to erase src and dst\n");
	else 
		Disp(" O.K. Erase src and dst\n");		
	
	
	OND_GetPageSz(&uPageByteSize);
	for (i=0x0; i<uPageByteSize*uPageCount; i+=4)	
	{
		*pData = rand();
		pData++;
		*pRData = 0x0;
		pRData++;
	}
	
	// 2. Map01 program
	bIsOK = OND_ProgramPages(Data, uSrcBlkAddr, uSrcPageAddr, uPageCount);
	if (bIsOK==false) 
		Disp(" Fail Program\n");
	else 
		Disp(" O.K. Program\n");

	// 3. Copy Back operation
	bIsOK = OND_CopyBack(uSrcBlkAddr, uSrcPageAddr, uDstBlkAddr, uDstPageAddr, uPageCount);
	if (bIsOK==false) 
		Disp(" Fail Copyback\n");
	else 
		Disp(" O.K. Copyback\n");

	// 4. Map01 load
	bIsOK = OND_ReadPages(uReceiveData, uDstBlkAddr, uDstPageAddr, uPageCount);
	if (bIsOK==false) 
		Disp(" Fail Load\n");
	else 
		Disp(" O.K. Load\n");

	// 5. Compare Data with UReceiveData and Verify the result
	//bIsOK = Compare8((u32)Data, (u32)uReceiveData, uPageByteSize*uPageCount);
	bIsOK = memcmp( (void*)Data, (void*)uReceiveData, uPageByteSize*uPageCount );
	Disp(" Data's addr=0x%x, uReceiveData's addr=0x%x\n", (u32)Data, (u32)uReceiveData);
	Dump32( uReceiveData, 32 );
	if( bIsOK != 0 )
		Disp(" Fail Compare\n");
	else
		Disp(" O.K. Compare\n");	
//}
//	else // Test All
	//	if (bIsOK != 0) uErrCnt++;
		
	if ( bIsOK == 0 )
		bIsOKOndcTestAll = true;
	else
		bIsOKOndcTestAll = false;	
	
}

// erase block 0 -> program block0, same page -> load block0, same page -> load otp area -> 
// compare (if the two differ, right result)
static void TestOTPAccess(void)
{
	u8 bIsOK;
	u32 uPageAddr ;
	u32 uPageCount ;
	u32 Data ;
	u32 uReceiveData ;
	u32 uRecvBlk0Data;
	u32* pData ;
	u32* pReceiveData ;
	u32* pRecvBlk0Data ;
	u32 i;
	u32 uPageByteSize;
	u32 uBlockAddr;
	
	Disp(" Input Page Index : ");
	
	uPageAddr = UART_GetIntNum();
	Disp(" Num. Of Pages : ");
	uPageCount = UART_GetIntNum();
	Data = CODEC_MEM_ST+0x10000;
	uReceiveData = CODEC_MEM_ST+0x20000;
	uRecvBlk0Data = CODEC_MEM_ST+0x30000;
	pData = (u32*)Data;
	pReceiveData = (u32*)uReceiveData;
	pRecvBlk0Data = (u32*)uRecvBlk0Data;


	OND_GetPageSz(&uPageByteSize);
	for (i=0; i<uPageCount*uPageByteSize; i+=4)
	{
		Outp32( Data+i, rand() );
		Outp32( uReceiveData+i, 0 );
		Outp32( uRecvBlk0Data+i, 0 );
	}

	// 1. erase block 0
	uBlockAddr = 0;
	bIsOK = OND_EraseBlocks(uBlockAddr,1);
	if (bIsOK==false) 
		Disp(" Fail to erase first block\n");
	else 
		Disp(" O.K. Erase first block\n");	
	
	// 2. program block0, same page	
	bIsOK = OND_ProgramPages(Data, uBlockAddr, uPageAddr, uPageCount );
	if (bIsOK==false) 
		Disp(" Fail Program\n");
	else 
		Disp(" O.K. Program\n");

	// 3. load block0, same page
	bIsOK = OND_ReadPages(uRecvBlk0Data, uBlockAddr, uPageAddr, uPageCount  );
	if (bIsOK==false) 
		Disp(" Fail Load\n");
	else 
		Disp(" O.K. Load\n");

	/*
	OND_ProgramOTPArea(uPageAddr, uPageCount, pData);
	OND_InitIp();
	OND_UnlockAll();
	*/
	
	// 4. load otp area
	OND_ReadOTPArea(uPageAddr, uPageCount, uReceiveData);

	// 5. compare (if the two differ, right result)
//	bIsOK = Compare8((u32)uRecvBlk0Data, (u32)uReceiveData, uPageCount*uPageByteSize);
	if(memcmp((void *)uRecvBlk0Data, (void *)uReceiveData, uPageCount*uPageByteSize))
	{
		bIsOK = false;
	}
	Disp(" uRecvBlk0Data's addr=0x%x, uReceiveData's addr=0x%x\n", (u32)uRecvBlk0Data, (u32)uReceiveData);
	if(bIsOK==false)
		Disp(" O.K. OTP Operation is worked\n");
	else
		Disp(" Fail OTP Operation is not worked\n");
}

// Erase -> map01 program -> Config spare area access -> data read from spare area 
//  -> Check that ecc area is written by some value except 0xffffffff, the number written after the block is erased
// -> Config main area only
static void TestEcc(void)
{
	u8 error;
	
	u32 uBlkAddr;
	u32 uPageAddr;
	u32 uReadPageCnt;
	u32 uStartBlkAddr = 762;
	u32 uStartPageAddr = 0;
	u32 uPageCount = 5;
	
	u32 uReceiveData = CODEC_MEM_ST+0x10000;
	u32 uSpareData = CODEC_MEM_ST+0x20000;
	u32 uWriteData = CODEC_MEM_ST+0x30000;
	u32* pReceiveData = (u32*)uReceiveData;
	u32* pSpareData = (u32*)uSpareData;
	u32* pWriteData = (u32*)uWriteData;
	
	u32 i;
	u32 uPageByteSize;
	u32 uSpareByteSize;
	
	Disp("Ecc Test\n");

	// 1. Erase one block
	error = OND_EraseBlocks(uStartBlkAddr,1);
	if (error==false) 
		Disp("\nOND Erase single block #%d FAILED!!!\n", uStartBlkAddr);
	else 
		Disp("\nOND Erase single block #%d SUCCESS\n", uStartBlkAddr);	
		
	// 2. Map01 program
	
	OND_GetPageSz(&uPageByteSize);
	for (i=0x0; i<uPageByteSize*uPageCount; i+=4)	
	{
		*pWriteData = i+1 + 0x55664000;
		pWriteData++;
		*pSpareData = 0x0;
		pSpareData++;
	}

	OND_ProgramPages(uWriteData, uStartBlkAddr, uStartPageAddr, uPageCount );
	Disp("Map01 program\n");

	// 3. Config spare area access
	OND_SetEccMode(true); // To enable ECC check (default status)
	for(i=0; i<uPageCount; i++)
	{
		///OND_EnableSpareTransfer(true);	
		OND_SetSpareAreaAccessCmd(uStartBlkAddr, uStartPageAddr+i); // access to spare area only
	}

	// 4. Read data from spare area
	uReadPageCnt = 0;
	uBlkAddr = uStartBlkAddr;
	uPageAddr = uStartPageAddr;	
	
	OND_GetSpareSz(&uSpareByteSize);
	while (uReadPageCnt < uPageCount)
	{		
		pSpareData = (u32*)(uSpareData+uSpareByteSize*uReadPageCnt);
		OND_ReadSpareArea(uBlkAddr, uPageAddr, pSpareData);

		uPageAddr++;
		if(uPageAddr == 64) //m_uNumOfPages
		{
			uPageAddr = 0;
			uBlkAddr++;
		}
		uReadPageCnt++;
		Disp("R:uReadPageCnt=%d\n", uReadPageCnt);
	}

	// 5. Config main area only
	for(i=0; i<uPageCount; i++)
	{
		///OND_EnableSpareTransfer(false);
		OND_SetMainAreaAccessCmd(uStartBlkAddr, uStartPageAddr+i); // access to main area only
	}
	
	Disp("Look at the addr 0x%x\n", uSpareData); ///
	UART_Getc();
}

static void TestProgramPIBlock(void)
{
	u32 uData;
	OND_WritePartitionInfo(0x11); // 90
	OND_ReadPartitionInfo(&uData);
	Disp("uData = %x\n",uData);
	if(uData ==0x10)
		Disp("Test OK\n");
	else
		Disp("Test fail\n");
    
}


bool OneNAND_FullFunction_autotest(void)
{
	u8 i=0;
	u8 j=0;
	u8 k=0;
	u8 l=0;
	u8 m=0;
	
	gAuto_test=1;

//	OND_InitIp(0);
	
//	TestUnlockAllBlocks();
	InitForAutoTest();
	
#ifdef AUTO_TEST
	
	for(i=0;i<12;i++)
	{
		if (i<6)
			OND_SetSyncMode(i,0);
		else
			OND_SetSyncMode(12-i,1);
		for(j=0;j<2;j++)
		{
			SetUseDMA(j);
			for(k=0;k<3;k++)
			{
				SetDmaBurstLength(k);
				for(l=1;l<2;l++)
				{
					SetDmaDataWidth(l);
					//m=1;
					for(m=0;m<2;m++)
					{	
						SetUseINT(m);
						Disp("\sync mode = %d usedma = %d burstlength = %d dmadatawidth = %d useint =%d \n",i,j,k,l,m);
						TestMultipleProgramAndLoad();		
						if(bIsOKOndcTestAll==false)
							return false;
							
					}
				}
			
			}

		}
	}
#else 
	
	
	//OND_SetSyncMode(0,1);
	TestMultipleProgramAndLoad();		
	if(bIsOKOndcTestAll==false)
		return false;
							
	

#endif 
	EndOfAutoTest();

	return true;
}


static void ONENAND_WriteTool(void)
{	

	OND_MODE n;
	u8 bIsOK = true;
	u32 uSrcAddr = CODEC_MEM_ST;
	u32 uDstAddr = CODEC_MEM_ST+0x1000000;
	u32 uBlockAddr,uLastBlockAddr;
	u32 uPageAddr;
	u32 uPageByteSize;
	u32 uNumOfBlocks,uNumOfPages;
	u32 uDataSize;
	u32 i;
	int sel;
	u32 uIfType, temp;

	u8 buffer;
	u32 checkSum=0;
	u32 dataLength = (8*1024)-4;
	u8 uErrCnt=0;
	
	// 1. Input block and page index
	// -----------------------------
	u32 uTotalNumOfBlocks;

	OND_InitIp();

	// Mux or Muxed
	Disp( " 0: Mux type		 1: Demux type \n" );
	uIfType = UART_GetIntNum();
	temp = *(volatile u32 *)(0xb0600100);
	temp = (temp & ~(1<<31)) | (uIfType<<31);
	*(volatile u32 *)(0xb0600100) = temp;
	
	//OND_UnlockAll();
//	ChangeBufferSize(0x800);

	TestUnlockAllBlocks();

//	OND_GetBootBufSz(2048);
	
	if ( OND_IsFlexDev() ) 
		Disp( " Flex-OneNAND\n" );
	else
		Disp( " Normal OneNAND\n" );


	OND_GetSyncMode(&n);
	if (n == OND_ASYNC)
		Disp(" OND_ASYNC\n");
	else if (n == OND_SYNC_BURST_CONT)
		Disp(" OND_SYNC_BURST_CONST\n");
	else if (n == OND_SYNC_BURST4)
		Disp(" OND_SYNC_BURST4\n");
	else if (n == OND_SYNC_BURST8)
		Disp(" OND_SYNC_BURST8\n");
	else if (n == OND_SYNC_BURST16)
		Disp(" OND_SYNC_BURST16\n");
	else if (n == OND_SYNC_BURST32)
		Disp(" OND_SYNC_BURST32\n");

	OND_INT_SET_VEC();

	OND_GetTotalNumOfBlocks(&uTotalNumOfBlocks);
	Disp(" Input block index(0~%d) : ", uTotalNumOfBlocks-1);
	uBlockAddr = UART_GetIntNum();
	Disp(" Input page index(0~63) : ");
	uPageAddr = UART_GetIntNum();
	Disp(" Input Num. of DataSize : ");
	uDataSize = UART_GetIntNum();

#if 1
	CheckSumData_Write(0x41000000 );
#else
	for(i=0;i<dataLength;i+=1)
	{
		buffer = Inp8(uSrcAddr+i);
		checkSum = checkSum + buffer;	// Check Sum.
	}
	Outp32(uSrcAddr+i, checkSum);
	UART_Printf(" uSrcAddr : %x, checkSum :%x ",uSrcAddr+i, checkSum);
#endif

	OND_GetPageSz(&uPageByteSize);

	uNumOfPages = uDataSize/uPageByteSize;
	if(uNumOfPages*uPageByteSize<uDataSize)
		uNumOfPages+=1;	
	uNumOfBlocks = uNumOfPages/64;
	uNumOfPages-=uNumOfBlocks*64;

	Disp( " uNumOfBlocks = %d  uNumOfPages = %d\n",uNumOfBlocks,uNumOfPages);	
	
	for (i=uSrcAddr; i<uSrcAddr+uDataSize; i+=4 )	
		Outp32( i, rand() );
	for (i=uDstAddr; i<uDstAddr+uDataSize; i+=4 )	
		Outp32( i, 0 );
	
	// 3. Erase block
	// --------------
	bIsOK = OND_EraseBlocks( uBlockAddr,uNumOfBlocks+1 ); 
	if ( !bIsOK ) uErrCnt++;

	if ( uErrCnt ==0)
			Disp( " O.K. Erase\n");		
		else
			Disp( " Fail to erase\n");

	temp =64;

   
	// 4. Program page
	// ---------------
	uErrCnt =0;
	for(i=0;i<uNumOfBlocks;i++)
	{
		
		bIsOK =	OND_ProgramMultiPages( uSrcAddr+(i*temp*uPageByteSize), uBlockAddr+i, uPageAddr,temp,OND_NORMAL );
		if ( !bIsOK ) uErrCnt++;
	}
	
	uLastBlockAddr = uBlockAddr+i;
	
	bIsOK =OND_ProgramMultiPages( uSrcAddr+(uNumOfBlocks*temp*uPageByteSize), uLastBlockAddr, 0,uNumOfPages,OND_NORMAL );
    if ( !bIsOK ) uErrCnt++;

	if ( uErrCnt ==0)
		Disp( " O.K. Program\n");		
	else
		Disp( " Fail to Program\n");

	// 5. Load page
	// ------------
	uErrCnt =0;
	for(i=0;i<uNumOfBlocks;i++)
	{
//		Disp("uDstAddr+(i*temp*uPageByteSize) = 0x%x\n",uDstAddr+(i*temp*uPageByteSize));
		bIsOK =	OND_ReadMultiPages( uDstAddr+(i*temp*uPageByteSize), uBlockAddr+i, uPageAddr,temp,OND_NORMAL );
		if ( !bIsOK ) uErrCnt++;
	}
	uLastBlockAddr = uBlockAddr+i;
//	Disp("uDstAddr+(uNumOfBlocks*temp*uPageByteSize) = 0x%x\n",uDstAddr+(uNumOfBlocks*temp*uPageByteSize));
	bIsOK =OND_ReadMultiPages( uDstAddr+(uNumOfBlocks*temp*uPageByteSize), uLastBlockAddr, uPageAddr,uNumOfPages,OND_NORMAL );
    if ( !bIsOK ) uErrCnt++;

	if ( uErrCnt ==0)
		Disp( " O.K. Load\n");		
	else
	{
		Disp( " Fail to Load\n");
		Disp( " uErrCnt = %d \n",uErrCnt);
		
	}
	

	// 6. Compare
	// ----------
	bIsOK = memcmp( (void*)(uSrcAddr), (void*)(uDstAddr), uDataSize );
	
	Disp( " Src Addr=0x%x  ~ 0x%x,  Dst Addr=0x%x ~0x%x  uPageByteSize = %d \n", 
		  uSrcAddr,uSrcAddr+uDataSize, uDstAddr,uDstAddr+uDataSize,uPageByteSize );
	Dump32( uSrcAddr, 32 );
	Dump32( uDstAddr, 32 );

	if( bIsOK != 0 )
		Disp(" Fail Compare\n");
	else
		Disp(" O.K. Compare\n");	


	
}



static void TestLoad(void)
{		
	u8 bIsOK = true;
	u32 uSrcAddr = CODEC_MEM_ST+0x10000;
	u32 uDstAddr = CODEC_MEM_ST+0x20000;
	u32 uBlockAddr;
	u32 uPageAddr;
	u32 uPageByteSize;
	u32 i;
	 
	// 1. Input block and page index
	// -----------------------------
	u32 uTotalNumOfBlocks;


	OND_INT_SET_VEC();

	OND_GetTotalNumOfBlocks(&uTotalNumOfBlocks);
	Disp(" Input block index(0~%d) : ", uTotalNumOfBlocks-1);
	uBlockAddr = UART_GetIntNum();
	Disp(" Input page index(0~63) : ");
	uPageAddr = UART_GetIntNum();

	// 2. Init and clear buffer
	// ------------------------
	
	OND_GetPageSz(&uPageByteSize);
	//for (i=uSrcAddr; i<uSrcAddr+uPageByteSize; i+=4 )	
	//	Outp32( i, rand() );
	for (i=uDstAddr; i<uDstAddr+uPageByteSize; i+=4 )	
		Outp32( i, 0 );

	// 3. Erase block
	// --------------
//	OND_EraseAllBlocks();
//	bIsOK = OND_EraseBlocks( uBlockAddr,1 );
//	if ( bIsOK == false )
//		Disp( " Fail to erase\n");
//	else
//		Disp( " O.K. Erase\n");

	
	// 4. Program page
	// ---------------
//	bIsOK = OND_ProgramPages( uSrcAddr, uBlockAddr, uPageAddr,1);
//	if ( bIsOK == false )
//		Disp( " Fail to program\n" );
//	else
//		Disp( " O.K. Program\n" );

	// 5. Load page
	// ------------
	bIsOK = OND_ReadPages( uDstAddr, uBlockAddr, uPageAddr ,1);
	if ( bIsOK == false )
		Disp( " Fail to load\n" );
	else
		Disp( " O.K. Load\n" );

	// 6. Compare
	// ----------
	//bIsOK = Compare8( uSrcAddr, uDstAddr, uPageByteSize );
	bIsOK = memcmp( (void*)uSrcAddr, (void*)uDstAddr, uPageByteSize );
	//if ( !bIsOndcTestAll )
	//{	
//	Disp( " Src Addr=0x%x, Dst Addr=0x%x uPageByteSize = %d \n", uSrcAddr, uDstAddr,uPageByteSize );
//	Dump32( uSrcAddr, 32 );
	Dump32( uDstAddr, 32 );
	if( bIsOK != 0 )
		Disp(" Fail Compare\n");
	else
		Disp(" O.K. Compare\n");	
//}
//	else // Test All
	//	if (bIsOK != 0) uErrCnt++;
		
	if ( bIsOK == 0 )
		bIsOKOndcTestAll = true;
	else
		bIsOKOndcTestAll = false;	

}


static void TestProgram(void)
{		
	u8 bIsOK = true;
	u32 uSrcAddr = CODEC_MEM_ST+0x10000;
	u32 uDstAddr = CODEC_MEM_ST+0x20000;
	u32 uBlockAddr;
	u32 uPageAddr;
	u32 uPageByteSize;
	u32 i;
	 
	// 1. Input block and page index
	// -----------------------------
	u32 uTotalNumOfBlocks;


	OND_INT_SET_VEC();

	OND_GetTotalNumOfBlocks(&uTotalNumOfBlocks);
	Disp(" Input block index(0~%d) : ", uTotalNumOfBlocks-1);
	uBlockAddr = UART_GetIntNum();
	Disp(" Input page index(0~63) : ");
	uPageAddr = UART_GetIntNum();

	// 2. Init and clear buffer
	// ------------------------
	
	OND_GetPageSz(&uPageByteSize);
	for (i=uSrcAddr; i<uSrcAddr+uPageByteSize; i+=4 )	
		Outp32( i, rand() );
	//for (i=uDstAddr; i<uDstAddr+uPageByteSize; i+=4 )	
	//	Outp32( i, 0 );

	// 3. Erase block
	// --------------
//	OND_EraseAllBlocks();
	bIsOK = OND_EraseBlocks( uBlockAddr,1 );
	if ( bIsOK == false )
		Disp( " Fail to erase\n");
	else
		Disp( " O.K. Erase\n");

	
	// 4. Program page
	// ---------------
	bIsOK = OND_ProgramPages( uSrcAddr, uBlockAddr, uPageAddr,1);
	if ( bIsOK == false )
		Disp( " Fail to program\n" );
	else
		Disp( " O.K. Program\n" );

	// 5. Load page
	// ------------
//	bIsOK = OND_ReadPages( uDstAddr, uBlockAddr, uPageAddr ,1);
//	if ( bIsOK == false )
//		Disp( " Fail to load\n" );
//	else
//		Disp( " O.K. Load\n" );

	// 6. Compare
	// ----------
	//bIsOK = Compare8( uSrcAddr, uDstAddr, uPageByteSize );
	bIsOK = memcmp( (void*)uSrcAddr, (void*)uDstAddr, uPageByteSize );
	//if ( !bIsOndcTestAll )
	//{	
//	Disp( " Src Addr=0x%x, Dst Addr=0x%x uPageByteSize = %d \n", uSrcAddr, uDstAddr,uPageByteSize );
	Dump32( uSrcAddr, 32 );
//	Dump32( uDstAddr, 32 );
	if( bIsOK != 0 )
		Disp(" Fail Compare\n");
	else
		Disp(" O.K. Compare\n");	
//}
//	else // Test All
	//	if (bIsOK != 0) uErrCnt++;
		
	if ( bIsOK == 0 )
		bIsOKOndcTestAll = true;
	else
		bIsOKOndcTestAll = false;	

}



static void TestMultipleProgram(void)
{	
	u8 bIsOK = true;
	u32 uSrcAddr = CODEC_MEM_ST+0x10000;
	u32 uDstAddr = CODEC_MEM_ST+0x20000;

	// 1. Input block and page index
	// -----------------------------
	u32 uTotalNumOfBlocks;
	u32 uBlockAddr;
	u32 uPageAddr;
	u32 uNumOfPages;
	u32 uPageByteSize;
	u32 i;
	u32 uErrCnt = 0;
	u32 uTime=0;

	OND_INT_SET_VEC();
	
	if(gAuto_test == 0) 
	{
		OND_GetTotalNumOfBlocks(&uTotalNumOfBlocks);
		Disp(" Input block index(0~%d) : ", uTotalNumOfBlocks-1);
		uBlockAddr = UART_GetIntNum();
		Disp(" Input page index(0~63) : ");
		uPageAddr = UART_GetIntNum();
		Disp(" Input Num. of Pages : ");
		uNumOfPages = UART_GetIntNum();
	}
	else 
	{
		OND_GetTotalNumOfBlocks(&uTotalNumOfBlocks);
		Disp(" Input block index(0~%d) : ", uTotalNumOfBlocks-1);
		uBlockAddr = 10;
		Disp(" Input page index(0~63) : ");
		uPageAddr = 0;
		Disp(" Input Num. of Pages : ");
		uNumOfPages = 10;
	}

	Disp("uSrcAddr= 0x%x\n",uSrcAddr);
	Disp("uDstAddr= 0x%x\n",uDstAddr);

	// 2. Init and clear buffer
	// ------------------------
	
	OND_GetPageSz(&uPageByteSize);
	for (i=uSrcAddr; i<uSrcAddr+(uPageByteSize*uNumOfPages); i+=4 )	
		Outp32( i, rand() );
	//for (i=uDstAddr; i<uDstAddr+(uPageByteSize*uNumOfPages); i+=4 )	
	//	Outp32( i, 0 );

		
		
	// 3. Erase block
	// --------------
	bIsOK = OND_EraseBlocks( uBlockAddr,1 );
	if ( bIsOK == false )
		Disp( " Fail to erase\n");
	else
		Disp( " O.K. Erase\n" );

	// 4. Program page
	// ---------------
	
	#if 1
	bIsOK = OND_ProgramPages( uSrcAddr, uBlockAddr, uPageAddr,uNumOfPages );
	if ( bIsOK == false )
		Disp( " Fail to program\n" );
	else
		Disp( " O.K. Program\n" );

	#endif
			
	// 5. Load page
	// ------------
	
	//bIsOK = OND_ReadPages( uDstAddr, uBlockAddr, uPageAddr, uNumOfPages );
	//if ( bIsOK == false )
	//	Disp( " Fail to load\n" );
	//else
	//	Disp( " O.K. Load\n" );
	
/*	OND_WaitForIntStatus(ONDC_INTACT);
	OND_ClearPending(ONDC_INTACT);
	OND_WaitForIntStatus(ONDC_LOADCMP);
	OND_ClearPending(ONDC_LOADCMP); */

	// 6. Compare
	// ----------
	//bIsOK = Compare8( uSrcAddr, uDstAddr, (uPageByteSize*uNumOfPages) );
	bIsOK = memcmp( (void*)uSrcAddr, (void*)uDstAddr, uPageByteSize*uNumOfPages);
	
		if ( !bIsOndcTestAll )
		{
			Disp( " Src Addr=0x%x, Dst Addr=0x%x\n", uSrcAddr, uDstAddr );
			Dump32( uSrcAddr, 8 );
	        Dump32( uDstAddr, 8 );
			if( bIsOK != 0 )
				Disp(" Fail Compare\n");
			else
				Disp(" O.K. Compare\n");
		}
		else // Test All
			if (bIsOK != 0) uErrCnt++;
			
		if ( bIsOK == 0 )
			bIsOKOndcTestAll = true;
		else
			bIsOKOndcTestAll = false;	

	



}



static void TestMultipleLoad(void)
{	
	u8 bIsOK = true;
	u32 uSrcAddr = CODEC_MEM_ST+0x10000;
	u32 uDstAddr = CODEC_MEM_ST+0x20000;

	// 1. Input block and page index
	// -----------------------------
	u32 uTotalNumOfBlocks;
	u32 uBlockAddr;
	u32 uPageAddr;
	u32 uNumOfPages;
	u32 uPageByteSize;
	u32 i;
	u32 uErrCnt = 0;
	u32 uTime=0;

	OND_INT_SET_VEC();
	
	if(gAuto_test == 0) 
	{
		OND_GetTotalNumOfBlocks(&uTotalNumOfBlocks);
		Disp(" Input block index(0~%d) : ", uTotalNumOfBlocks-1);
		uBlockAddr = UART_GetIntNum();
		Disp(" Input page index(0~63) : ");
		uPageAddr = UART_GetIntNum();
		Disp(" Input Num. of Pages : ");
		uNumOfPages = UART_GetIntNum();
	}
	else 
	{
		OND_GetTotalNumOfBlocks(&uTotalNumOfBlocks);
		Disp(" Input block index(0~%d) : ", uTotalNumOfBlocks-1);
		uBlockAddr = 10;
		Disp(" Input page index(0~63) : ");
		uPageAddr = 0;
		Disp(" Input Num. of Pages : ");
		uNumOfPages = 10;
	}

	Disp("uSrcAddr= 0x%x\n",uSrcAddr);
	Disp("uDstAddr= 0x%x\n",uDstAddr);

	// 2. Init and clear buffer
	// ------------------------
	
	OND_GetPageSz(&uPageByteSize);
	//for (i=uSrcAddr; i<uSrcAddr+(uPageByteSize*uNumOfPages); i+=4 )	
	//	Outp32( i, rand() );
	for (i=uDstAddr; i<uDstAddr+(uPageByteSize*uNumOfPages); i+=4 )	
		Outp32( i, 0 );

		
		
	// 3. Erase block
	// --------------
	//bIsOK = OND_EraseBlocks( uBlockAddr,1 );
	//if ( bIsOK == false )
	//	Disp( " Fail to erase\n");
	//else
	//	Disp( " O.K. Erase\n" );

	// 4. Program page
	// ---------------
	
	#if 0
	bIsOK = OND_ProgramPages( uSrcAddr, uBlockAddr, uPageAddr,uNumOfPages );
	if ( bIsOK == false )
		Disp( " Fail to program\n" );
	else
		Disp( " O.K. Program\n" );

	#endif
			
	// 5. Load page
	// ------------
	
	bIsOK = OND_ReadPages( uDstAddr, uBlockAddr, uPageAddr, uNumOfPages );
	if ( bIsOK == false )
		Disp( " Fail to load\n" );
	else
		Disp( " O.K. Load\n" );
	
/*	OND_WaitForIntStatus(ONDC_INTACT);
	OND_ClearPending(ONDC_INTACT);
	OND_WaitForIntStatus(ONDC_LOADCMP);
	OND_ClearPending(ONDC_LOADCMP); */

	// 6. Compare
	// ----------
	//bIsOK = Compare8( uSrcAddr, uDstAddr, (uPageByteSize*uNumOfPages) );
	bIsOK = memcmp( (void*)uSrcAddr, (void*)uDstAddr, uPageByteSize*uNumOfPages);
	
		if ( !bIsOndcTestAll )
		{
			Disp( " Src Addr=0x%x, Dst Addr=0x%x\n", uSrcAddr, uDstAddr );
			Dump32( uSrcAddr, 8 );
	        Dump32( uDstAddr, 8 );
			if( bIsOK != 0 )
				Disp(" Fail Compare\n");
			else
				Disp(" O.K. Compare\n");
		}
		else // Test All
			if (bIsOK != 0) uErrCnt++;
			
		if ( bIsOK == 0 )
			bIsOKOndcTestAll = true;
		else
			bIsOKOndcTestAll = false;	

	



}

const testFuncMenu ondc_menu[]=
	{
		NULL,                   	                 "Exit",
		OND_Info,									 "Onenand information",

		TestSetSyncMode,			                 "Test Set Sync Mode",
		
		TestWarmReset,                               "Test Warm Reset",
		TestCoreReset,                               "Test Core Reset",
		TestHotReset,                                "Test Hot Reset\n",

        TestLockBlocksTightly,						 "Test Lock Blocks Tightly",
		TestUnlockAllBlocks,		                 "Test Unlock All Blocks",
		
		TestEraseAllBlocks,                          "Test Erase All Blocks\n",
		
		TestProtectionOneBlock,                      "Test Protection OneBlock",
		TestProtectionMultiBlocks,                   "Test Protection MultiBlocks\n",

		TestProgramPIBlock,                          "TestProgramPIBlock\n",

		TestProgramAndLoad,                          "Test Single page Program And Load",
		TestProgramAndLoad_SQC,                      "Test Single page Program And Load by micro sequencer",
		TestMultipleProgramAndLoad,                  "Test Multiple page Program And Load",
		TestMultipleProgramAndLoad_SQC,				 "Test Multiple page Program And Load by micro sequencer",
		ProgramBootImage,                            "Program Boot Image\n",
		OneNAND_FullFunction_autotest,				 "Auto test code\n ",
		ONENAND_WriteTool,							 "ONENAND_WriteTool\n",
//		TestWriteReadXipBufferWithMap00Cmd,          "Test Write/Read XIP Buffer With Map00",
//		TestWriteReadFlashDevWithMap01Cmd,           "Test Write/Read Flash Device with Map01 Cmd",
//		TestWriteReadFlashDevWithMap01Cmd_DMA,       "TestWriteReadFlashDevWithMap01Cmd_DMA\n",
		
		TestCopyBack,                                "Test CopyBack",
		TestOTPAccess,                               "Test OTP Access",
//		TestSpareAreaAccess,                         "Test Spare Area Access\n",
		
//		TestPipelineReadAheadInSingleArea,           "Test Pipeline Read Ahead in Single area",
//		TestPipelineReadAheadInMultipleAreas,        "Test Pipeline Read Ahead in multiple areas",		
//		TestReadModifyWriteInXipBuffer,			     "Test Read/Modify/Write In XIP Buffer",		
//		TestDirectInterfaceCacheProgramMap11Cmd,     "TestDirectInterfaceCacheProgramMap11Cmd",
//		TestSyncWrite,                               "Test Sync Write",
		TestEcc,                                     "Test ECC",
//		TestPipeline2WayReadAheadInMultipleAreas,    "Test Pipeline 2Way Read Ahead In MultipleAreas",
//		TestPipeline2xWriteAndRead,                   "TestPipeline2xWriteAndRead",
//		TestAboveAll,				                 "Above All Test",
		VectorTest,						 "Test Vector",
		TestProgram,						 "Test Program",		
		TestLoad,						 "Test Load",
		TestMultipleLoad,				 "TestMultipleLoad",
		TestMultipleProgram,				 "TestMultipleProgram",
		0,                                           0
	};



void Test_OND(void)
{
	OND_MODE n;
	int i;
	int sel;

	//SYSC_SetClkDiv(eCLKDIV_ONENAND, 1)
    
	OND_InitIp();
	
	TestUnlockAllBlocks();

	if ( OND_IsFlexDev() ) 
		Disp( " Flex-OneNAND\n" );
	else
		Disp( " Normal OneNAND\n" );


	OND_GetSyncMode(&n);
	if (n == OND_ASYNC)
		Disp(" OND_ASYNC\n");
	else if (n == OND_SYNC_BURST_CONT)
		Disp(" OND_SYNC_BURST_CONST\n");
	else if (n == OND_SYNC_BURST4)
		Disp(" OND_SYNC_BURST4\n");
	else if (n == OND_SYNC_BURST8)
		Disp(" OND_SYNC_BURST8\n");
	else if (n == OND_SYNC_BURST16)
		Disp(" OND_SYNC_BURST16\n");
	else if (n == OND_SYNC_BURST32)
		Disp(" OND_SYNC_BURST32\n");

	while(1)
	{
		Disp("\n");
		for (i=0; (int)(ondc_menu[i].desc)!=0; i++)
			Disp("%2d: %s\n", i, ondc_menu[i].desc);

		

		Disp("\nSelect the function to test : ");
		sel = UART_GetIntNum();
		Disp("\n");

		if (sel == 0)
			break;
		else if (sel>0 && sel<(sizeof(ondc_menu)/8-1))
			(ondc_menu[sel].func)();
	}
}
