#ifndef __AUDI_ONDC_H__
#define __AUDI_ONDC_H__

//#define ONDC_BASE 0x6fff0000
//#define OND_BASE  0xB0000000



typedef enum 
{
	OND_ASYNC, OND_SYNC_BURST_CONT, OND_SYNC_BURST4, OND_SYNC_BURST8, OND_SYNC_BURST16, OND_SYNC_BURST32, OND_SYNC_BURST1K
}OND_MODE;

typedef enum 
{
	OND_BOOT_RAM, OND_DATARAM0, OND_DATARAM1, OND_RMW_BUF
}OND_BUF_RAM;

typedef enum 
{
	OND_INT=15, OND_RI=7, OND_WI=6, OND_EI=5, OND_RSTI=4 ,OND_CACHE_PI= 0x8040
}OND_INT_STATUS;

typedef enum 
{
	OND_WARM_RESET, OND_CORE_RESET, OND_HOT_RESET
}OND_RESET_TYPE;

typedef enum 
{
	//OND_NO_USE_PIPELINE, OND_PIPELINE_READ, OND_PIPELINE_2X_WRITE, OND_2WAY_PIPELINE_READ
	OND_NORMAL, OND_CACHE_2X_WRITE, OND_2X_WRITE, OND_CACHE_READ, OND_SUPER_LOAD,OND_CACHE_WRITE
}ONDC_TRANS_MODE;

typedef enum 
{
	ONDC_MAP_00_11, ONDC_MAP_01_10
}ONDC_OP_MODE;

typedef enum 
{
	ONDC_LD_FAIL_OR_ECC_ERR,
	ONDC_TIMEOUT,  
	ONDC_PGM_FAIL,    
	ONDC_ERASE_FAIL,
	ONDC_LOAD_COMPLETE, 
	ONDC_PGM_COMPLETE, 
	ONDC_ERS_COMPLETE,
	ONDC_BLK_RW_COMPLETE,  
	ONDC_LOCKED_BLK,
	ONDC_UNSUP_CMD, 	
	ONDC_DEV_INTR,
	ONDC_RST_COMPLETE, 
	ONDC_CACHE_OP_ERR
}ONDC_INT_ERROR;

//class ONDC
//{
//public:
	void OND_InitIp(void);
	void OND_ResetDevice(OND_RESET_TYPE eResetType);
	void OND_INT_SET_VEC(void);
	
	// Write Protection
	u8 OND_UnlockAll(void); 
	u8 OND_UnlockBlocks(u32 uBlockIndex, u32 uNumOfBlocks); 
	u8 OND_LockBlocks(u32 uBlockIndex, u32 uNumOfBlocks); 
	u8 OND_LockBlocksTightly(u32 uBlockIndex, u32 uNumOfBlocks);

	// Erase, Program, Read
	u8 OND_EraseAllBlocks(void);
	u8 OND_EraseBlocks(u32 uBlockIndex, u32 uNumOfBlocks);
	u8 OND_ProgramPages( u32 uDataAddr, u32 uBlockAddr, u32 uPageAddr, u32 uNumOfPages );
	u8 OND_ReadPages( u32 uDataAddr, u32 uBlockAddr, u32 uPageAddr, u32 uNumOfPages);

	// Flex-OneNAND
	u8 OND_WritePartitionInfo(u32 uPIValue);
	void OND_ReadPartitionInfo(u32 *uData);
	
	// Copy-back operation	
	u8 OND_CopyBack(u32 uSrcBlockIndex, u32 uSrcPageIndex, 
		u32 uDstBlockIndex, u32 uDstPageIndex, u32 uNumOfPages);

	// OTP(One Time Programmable) Area
	void OND_ProgramOTPArea(u32 uPageIndex, u32 uNumOfPages, u32 uDataAddr);
	void OND_ReadOTPArea(u32 uPageIndex, u32 uNumOfPages, u32 uDataAddr);
	
	// Interrupt
	void OND_GetIntStatus(ONDC_INT_ERROR *eIntErr);
	void OND_ClearPending(ONDC_INT_ERROR eIntErr);

	// get, set method
	void OND_GetTotalNumOfBlocks( u32 *uBlocks );
	void OND_GetBootBufSz(u32 *uBootBufSize);
	void OND_GetDataBufSz(u32 *uDataBufSize);
	void OND_GetPageSz(u32 *uPageSize);
	void OND_GetSpareSz(u32 *uSpareSize);
	void OND_GetSyncMode(OND_MODE *eMode);
	void OND_GetManufactId( u32 *uManuId );
	void OND_GetDeviceId( u32 *uDevId );
	void OND_ClearDataBuf(void);
	void OND_SetEccMode(u8 bEccEnable);
//	void OND_SetSyncMode( OND_MODE eMode, u8 bUseDMA);
	void OND_SetSyncMode( OND_MODE eMode, u32 ePrefetch);
	u8 OND_IsDdpDev(void);
	u8 OND_IsFlexDev(void);

	// Spare area
	void OND_SetSpareAreaAccessCmd(u32 uBlkAddr, u8 uPageAddr); 
	void OND_SetMainAreaAccessCmd(u32 uBlkAddr, u8 uPageAddr);
	void OND_EnableSpareAreaTransfer(u8 bEnable);
	u8 OND_ReadSpareArea(u32 uBlkAddr, u8 uPageAddr, u32 *aSpare);
	u8 OND_WriteIntoSpareArea(u32 uBlkAddr, u8 uPageAddr, u32 *aSpare);	

//protected:
//JHHEO:2008/8/5 ==> OneNAND interface config functions
	u32 OND_ConfigOndInf(void);
	
//	u32 OND_ConfigOndInf_real(u8 nReadMode, u8 nBRWL, u8 nBL, u8 nHF, u8 nWriteMode, u8 nReadPrefetch, u32 nPrefetchSize);
	u32 OND_ConfigOndInf_real(u8 nReadMode, u8 nBRWL, u8 nBL, u8 nHF, u8 nWriteMode, u8 nReadPrefetch);
//JHHEO:2008/8/5 <== 


	u8 OND_ProgramMultiPages( u32 uDataAddr, u32 uBlockAddr, u32 uPageAddr, u32 uNumOfPages, 
		                      ONDC_TRANS_MODE eMode );
	u8 OND_ProgramOnePage(u32 uDataAddr, u32 uBlockIndex, u32 uPageIndex ,
		                  ONDC_TRANS_MODE eMode );
	
//  u8 OND_ProgramMultiPages(u32 uDataAddr, u32 uBlockIndex, u32 uPageIndex, u32 uNumOfPages );
//	u8 OND_ProgramOnePage(u32 uDataAddr, u32 uBlockIndex, u32 uPageIndex );
	u8 OND_ReadMultiPages(u32 uDataAddr, u32 uBlockAddr, u32 uPageAddr, u32 uNumOfPages ,ONDC_TRANS_MODE eMode);
	u8 OND_ReadOnePage(u32 uDataAddr, u32 uBlockIndex, u32 uPageIndex );	
	void OND_WriteIntoBufferRam(OND_BUF_RAM eBufRam, u32 uOffset, u32 uData);
	void OND_ReadBufferRam(OND_BUF_RAM eBufRam, u32 uOffset, u32 *uData);	
	u8 OND_EraseMultiBlocksWithin64Blocks(u32 uStartBlkAddr, u32 uEndBlkAddr);
	u8 OND_VerifyWrProtectionStatus(u32 uBlockIndex, u32 uProtStatus);
	void OND_WriteIntoDataram(u32 uChipSel, u32 uAddr, u32 uData);
	void OND_WriteIntoDataram8W(u32 uChipSel, u32 uSrcAddr, u32 uDstAddr, u32 uCnt);
	void OND_ReadDataram(u32 uChipSel, u32 uAddr, u32 *uData);	
//	void OND_ReadDataram(u32 uChipSel, u32 uAddr, u32 *uData, u32 , u32 uCnt );	
	void OND_ReadDataram8W(u32 uChipSel, u32 uSrcAddr, u32 uDstAddr, u32 uCnt);
//	void WriteIntoFlash(u32 uBlockAddr, u8 ucPageAddr, u32 uData);
//	void WriteIntoFlash(u32 uChipSel, u32 BlockAddr, u8 PageAddr, u32 Data);
//	void ReadFlash(u32 uBlockAddr, u8 ucPageAddr, u32& uData);
//	void ReadFlash(u32 uChipSel, u32 uBlockAddr, u8 uPageAddr, u32& uData);
//	void WriteCmd(u32 uBlockAddr, u32 uData);
//	void WriteCmd(u32 uBlockAddr, u32 uPageAddr, u32 uData);
//	void WriteCmd(u32 uChipSel, u32 uBlockAddr, u32 uPageAddr, u32 uData);
//	void ReadCmd(u32 uBlockAddr, u32& uData);
//	void ReadCmd(u32 uBlockAddr, u32 uPageAddr, u32& uData);
//	void ReadCmd(u32 uChipSel, u32 uBlockAddr, u32 uPageAddr, u32& uData);
	void OND_WaitForDeviceCmdDone( OND_INT_STATUS eWhichInt );
	u8 OND_IsDeviceCmdCompleted(void);
	
	u8 OND_IsLockErrorOccured(void);
	u8 OND_VerifyErasedBlock(u32 uBlkAddr);
	void OND_EnterOTP(u32 uBlkAddr); 
//JHHEO:2008/8/7 ==> 
	void OND_EnterPI(u32 uBlkAddr); 	
//JHHEO:2008/8/7 <== 
	void OND_AccessSfr(void);
	void OND_WaitForIntStatus(ONDC_INT_ERROR eIntErr);

void OND_Dma_Go(void);
void OND_Dma_Tranfer_Error_Clear(void);
void OND_Dma_Tranfer_Done_Clear(void);
void OND_Dma_Setting(u32 uSrcAddr,u32 uSrcBurstLength,u8 uScrAddrMode,u8 uSrcDataWidth,
	                 u32 uDstAddr,u32 uDstBurstLength,u8 uDstAddrMode,u8 uDstDataWidth, 
	                 u32 uTransSize,u8 uTransDir);

void OND_SQC_Init(void);
u8 OND_SQC_ReadPages( u32 uDataAddr, u32 uBlockAddr, u32 uPageAddr, u32 uNumOfPages);
u8 OND_SQC_ProgramPages( u32 uDataAddr, u32 uBlockAddr, u32 uPageAddr, u32 uNumOfPages);

int	OND_SQC_Wait(void);

void OND_INT_SET_VEC(void);
void OND_INT_SET_VEC_SQC(void);

u8 OND_ProgramPage_2xWrite( u32 uDataAddr, u32 uBlockAddr, u32 uPageAddr ,ONDC_TRANS_MODE eMode);
u8 OND_ProgramPage_2xCacheWrite( u32 uDataAddr, u32 uBlockAddr, u32 uPageAddr ,ONDC_TRANS_MODE eMode);
u8 OND_CacheReadPages(u32 uDataAddr, u32 uBlockAddr, u32 uPageAddr , u32 uNumOfPages );
u8 OND_SuperLoadPage(u32 uDataAddr, u32 uBlockAddr, u32 uPageAddr , u32 uNumOfPages );
u8 OND_ProgramPage_CacheWrite( u32 uDataAddr, u32 uBlockAddr, u32 uPageAddr ,ONDC_TRANS_MODE eMode);
u8 OND_ProgramPage_CacheWrite_Finish( u32 uDataAddr, u32 uBlockAddr, u32 uPageAddr ,ONDC_TRANS_MODE eMode);


void OND_WaitForLoadDone(void );

void VectorTest(void);
void InitForAutoTest(void);
void EndOfAutoTest(void);


void SetUseDMA(u8 uUseDMA);				
void SetDmaBurstLength(u8 uDmaBurstLength);
void SetDmaDataWidth(u8 uDmaDataWidth);
void SetUseINT(u8 uUseINT);


void OND_Mux_DeMux_setting(u8 value);
void OND_Mux_DeMux_Change(void);


void OND_Info(void);

void ChangeBufferSize(u32 uPageSize);

typedef struct {
	volatile u32 m_uNumOfBlocks;
	volatile u32 m_uNumOfSectors;
	volatile u32 m_uChipSelBitOffset;
	volatile u32 m_uBlockBitOffset;
	volatile u32 m_uPageBitOffset;
	volatile u32 m_uBlockBitMask;
	volatile u32 m_uPageBitMask;
	volatile u32 m_uIsDDP;
	volatile u32 m_uBootBufByteSize;
	volatile u32 m_uNumOfDataBuf;
	volatile u32 m_uDataBufByteSize;
	
	volatile u32 m_uNumOfPages;
	volatile u32 m_uPageByteSize;
	volatile u32 m_uSpareByteSize;

	volatile u8 m_uDmaDataWidth;
	volatile u8 m_bUseINT;
	volatile u8 m_bOND_INT_Occur;
	volatile u8 m_bDMA_INT_Occur;

	volatile u8 m_bSQC_INT_Occur;
	volatile u8 m_bIsFlexDev;
	volatile u8 m_uNumFlexSlcOfPages;
	volatile u8 m_uNumFlexMlcOfPages;

	volatile u8 m_2xwrite;
	volatile u8 m_2xCachewrite;
	volatile u8 m_LastCacheWrite;
	volatile u8 m_MuxDemux;

	volatile u8 m_bUseDMA;
	volatile u8 m_uDmaBurstLength;
	volatile OND_MODE m_eSyncMode;
	volatile ONDC_OP_MODE m_eOpMode;

	
//};
}ONDC;

#endif 
