
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "option.h"
#include "library.h"
#include "def.h"
#include "dma.h"
#include "intc.h"
#include "gpio.h"
#include "sysc.h"

#include "audi_ondc.h"

//#define HCLK_FREQ (HCLK0_FREQ)

//#define DISP_ONDC_REG

//#define FPGA 1
#define MEMCPY 1

#ifdef DBG_ONDC
#define onDbg(x) Dbg x
#else
#define onDbg(x) 0
#endif




#ifdef DISP_ONDC_REG
#define Inp32_audi(addr, data) (data = (*(volatile u32 *)(addr)))
#define Inp16_audi(addr, data) (data = (*(volatile u16 *)(addr)))

#define ondOutp32(a, d) {u32 a2, d2; a2=a; d2=d; Disp("Outp32(0x%08x, 0x%08x);\n", a2, d2); Outp32(a2, d2); }
#define ondInp32 Inp32
//#define ondInp32(a, d) {u32 a2, d2; a2=a; Inp32_audi(a2, d2); d=d2; Dbg("Inp1w(\'h%08x, d); // d=0x%08x\n", a2, d2); }
#define ondOutp16(a, d) {u32 a2, d2; a2=a; d2=d; Disp("Outp16(0x%08x, 0x%08x);\n", a2, d2); Outp16(a2, d2); }
//#define ondInp16(a, d) {u16 a2, d2; a2=a; Inp16_audi(a2, d2); d=d2; Dbg("Inp1w(\'h%08x, d); // d=0x%08x\n", a2, d2); }
#define ondInp16 Inp16

#else
#define ondOutp32 Outp32
#define ondInp32 Inp32
#define ondOutp16 Outp16
#define ondInp16 Inp16
#endif

#define OND_MULTIERASE_BLOCK_COUNT 64

#define	OND_READ_SYNC_MODE		(u16)(1<<15)
#define	OND_READ_ASYNC_MODE		(u16)(~OND_READ_SYNC_MODE)

#define	OND_WRITE_SYNC_MODE		(u16)(1<<1)
#define	OND_WRITE_ASYNC_MODE	(u16)(~OND_WRITE_SYNC_MODE)

#define	OND_BRWL_3				(u16)(3<<12)	// under 40MHz
#define	OND_BRWL_4				(u16)(4<<12)	// 40~66MHz(min)
#define	OND_BRWL_5				(u16)(5<<12)	// 40~66MHz
#define	OND_BRWL_6				(u16)(6<<12)	// over 66MHz(min)
#define	OND_BRWL_7				(u16)(7<<12)	// over 66MHz

#define	OND_BL_CLR				(u16)(0xF1FF)
#define	OND_BL_CONT				(u16)(0)
#define	OND_BL_4				(u16)(1<<9)
#define	OND_BL_8				(u16)(2<<9)
#define	OND_BL_16				(u16)(3<<9)
#define	OND_BL_32				(u16)(4<<9)
#define	OND_BL_1K				(u16)(5<<9)

#define	OND_HF_ON				(u16)(1<<2)
#define	OND_HF_OFF				(u16)(~OND_HF_ON)

#define	OND_ECC_OFF				(u16)(1<<8)
#define	OND_ECC_ON				(u16)(~OND_ECC_OFF)

#define	OND_RDYPOL_HIGH			(u16)(1<<7)
#define	OND_RDYPOL_LOW			(u16)(~OND_RDYPOL_HIGH)

#define	OND_INTPOL_HIGH			(u16)(1<<6)
#define	OND_INTPOL_LOW			(u16)(~OND_INTPOL_HIGH)

#define	OND_IOBE_ON				(u16)(1<<5)
#define	OND_IOBE_OFF			(u16)(~OND_IOBE_ON)

#define	OND_RDYCONF_HIGH		(u16)(1<<4)
#define	OND_RDYCONF_LOW			(u16)(~OND_RDYCONF_HIGH)


#define	OND_RD_PREF_ON		(u32)(1<<17)
#define	OND_RD_PREF_OFF	(u32)(~OND_RD_PREF_ON)

#define DMA_DW_8 (u8)(0<<0)
#define DMA_DW_16 (u8)(1<<0)
#define DMA_DW_32 (u8)(2<<0)

#define DMA_BL_SINGLE (u32)(0)
#define DMA_BL_4BURST (u32)(2)
#define DMA_BL_8BURST (u32)(3)
#define DMA_BL_16BURST (u32)(4)

#define	DMA_SRC_INC_ADDR_MODE		(u8)(0<<8)
#define	DMA_SRC_CONST_ADDR_MODE		(u8)(~DMA_INC_ADDR_MODE)

#define	DMA_DST_INC_ADDR_MODE		(u8)(0<<8)
#define	DMA_DST_CONST_ADDR_MODE		(u8)(~DMA_INC_ADDR_MODE)

#define DMA_TRANS_DONE (u8)(1<<18)
#define DMA_TRANS_BUSY (u8)(1<<17)
#define DMA_TRANS_ERROR (u8)(1<<16)

#define	DMA_IN2OUT		(u8)(1<<0)
#define	DMA_OUT2IN		(u8)(~DMA_IN2OUT)

//AUDI Control Memory
#define AUDI_CTRL_MEM_BASE              0xb0400000
#define	AUDI_CODE_START_ADDR			(AUDI_CTRL_MEM_BASE+0x00000000)
#define	AUDI_CODE_END_ADDR				(AUDI_CTRL_MEM_BASE+0x000017F0)
#define	AUDI_PARAMS_BASE_ADDR			(AUDI_CTRL_MEM_BASE+0x00001800)

#define	OND_CH_INT_CLEAR				0x00FF0000

#define AUDI_DONE_CLR_BIT				18
#define AUDI_ERR_CLR_BIT				16
#define AUDI_RUN_BIT					0
#define AUDI_DONE_BIT					18
#define AUDI_BUSY_BIT					17
#define AUDI_ERR_BIT					16

//COMMAND
#define	FC_SCTR_READ					0x0
#define	FC_SCTR_WRITE					0x1
#define	FC_SCTR_ERASE					0x2
#define	FC_SCTR_2X_WRITE				0x3

#define MUX								0
#define DEMUX							1

//#define BOOT						

typedef	struct
{
	volatile u32		nFuncCode;
	volatile u32		nHostBufAddr;
	volatile u32		nDevIdx;
	volatile u32		nNumOfDescs;
}AUDI_HEADER_OF_PB, *PAUDI_HEADER_OF_PB;

typedef struct
{
	volatile u32		nFBA;
	volatile u32		nFPA_FSA;
	volatile u32		nSctCnt;
}AUDI_PARAMS, *PAUDI_PARAMS;

static PAUDI_HEADER_OF_PB	gpstAudiHeaderOfPb;
static PAUDI_PARAMS			gpstAudiParamsArray;

static const volatile u32	*g_pAudiPbAddr = (u32 *)AUDI_PARAMS_BASE_ADDR;
//JHHEO:2008/12/3 <== 


typedef enum 
{
	OND_BUFFER_RAM_ADDR		= (OND_BASE + 0x0000),
	OND_DATA00_RAM_ADDR		= (OND_BASE + 0x0400),
	OND_DATA10_RAM_ADDR		= (OND_BASE + 0x0C00),
	OND_SPARE00_RAM_ADDR	= (OND_BASE + 0x00010020),
	OND_SPARE10_RAM_ADDR	= (OND_BASE + 0x00010060),
}OND_BASE_ADDR;

typedef enum 
{
	WARM_RESET		= 0,
	CORE_RESET		= 0x00F0,
	HOT_RESET		= 0x00F3,
}OND_COMMANDS;
//JHHEO:2008/8/4 <== 

typedef enum 
{
	ONDC_CTRL_REG		     = (ONDXL_BASE + 0x0100),
	ONDC_CTRL_CMD_REG		 = (ONDXL_BASE + 0x0104),	
	ONDC_ASYNC_TIME_CTRL     = (ONDXL_BASE + 0x0108),
	ONDC_STATUS_REG          = (ONDXL_BASE + 0x010C),
	ONDC_DMA_SRC_ADDR        = (ONDXL_BASE + 0x0400),
	ONDC_DMA_SRC_CFG         = (ONDXL_BASE + 0x0404),
	ONDC_DMA_DST_ADDR        = (ONDXL_BASE + 0x0408),
	ONDC_DMA_DST_CFG         = (ONDXL_BASE + 0x040C),
	ONDC_DMA_TRANS_SIZE      = (ONDXL_BASE + 0x0414),
	ONDC_DMA_TRANS_CMD       = (ONDXL_BASE + 0x0418),
	ONDC_DMA_TRANS_STATUS    = (ONDXL_BASE + 0x041C),
	ONDC_DMA_TRANS_DIR       = (ONDXL_BASE + 0x0420),
	ONDC_SQC_SAO             = (ONDXL_BASE + 0x0600),
	ONDC_SQC_CMD             = (ONDXL_BASE + 0x0608),
	ONDC_SQC_STATUS          = (ONDXL_BASE + 0x060C),
	ONDC_SQC_CAO             = (ONDXL_BASE + 0x0610),
	ONDC_SQC_REG_CTRL        = (ONDXL_BASE + 0x0614),
	ONDC_SQC_REG_VAL         = (ONDXL_BASE + 0x0618),
	ONDC_SQC_BRPAO_0         = (ONDXL_BASE + 0x0620),
	ONDC_SQC_BRPAO_1         = (ONDXL_BASE + 0x0624),
	ONDC_INTC_SQC_CLR        = (ONDXL_BASE + 0x1000),
	ONDC_INTC_DMA_CLR        = (ONDXL_BASE + 0x1004),
	ONDC_INTC_OND_CLR        = (ONDXL_BASE + 0x1008),
	ONDC_INTC_SQC_MASK       = (ONDXL_BASE + 0x1020),
	ONDC_INTC_DMA_MASK       = (ONDXL_BASE + 0x1024),
	ONDC_INTC_OND_MASK       = (ONDXL_BASE + 0x1028),
	ONDC_INTC_SQC_PEND       = (ONDXL_BASE + 0x1040),
	ONDC_INTC_DMA_PEND       = (ONDXL_BASE + 0x1044),
	ONDC_INTC_OND_PEND       = (ONDXL_BASE + 0x1048),
	ONDC_INTC_SQC_STATUS     = (ONDXL_BASE + 0x1060),
	ONDC_INTC_DMA_STATUS     = (ONDXL_BASE + 0x1064),
	ONDC_INTC_OND_STATUS     = (ONDXL_BASE + 0x1068),
	
	
}ONDC_REGS;
//JHHEO:2008/8/4 <== 

typedef enum 
{
	OND_MANUFACT_ID         = (OND_BASE + 0x1E000),
	OND_DEVICE_ID           = (OND_BASE + 0x1E002),
	OND_VER_ID              = (OND_BASE + 0x1E004),
	OND_DATA_BUFSIZE        = (OND_BASE + 0x1E006),
	OND_BOOT_BUFSIZE        = (OND_BASE + 0x1E008),
	OND_AMOUNT_OF_BUFSIZE   = (OND_BASE + 0x1E00A),
	OND_TECHNOLOGY          = (OND_BASE + 0x1E00C),
	OND_START_ADDR1         = (OND_BASE + 0x1E200), // 0xF100
	OND_START_ADDR2         = (OND_BASE + 0x1E202), // 0xF101
	OND_START_ADDR3         = (OND_BASE + 0x1E204), // 0xF102
	OND_START_ADDR4         = (OND_BASE + 0x1E206), // 0xF103
	OND_START_ADDR5         = (OND_BASE + 0x1E208), // 0xF104
	OND_START_ADDR6         = (OND_BASE + 0x1E20A), // 0xF105
	OND_START_ADDR7         = (OND_BASE + 0x1E20C), // 0xF106
	OND_START_ADDR8         = (OND_BASE + 0x1E20E), // 0xF107
	OND_START_BUF           = (OND_BASE + 0x1E400), // 0xF200
	OND_COMMAND             = (OND_BASE + 0x1E440), // 0xF220
	OND_SYS_CONFIG1         = (OND_BASE + 0x1E442), // 0xF221
	OND_CTRL_STATUS         = (OND_BASE + 0x1E480), // 0xF240
	OND_REG_INT_STATUS      = (OND_BASE + 0x1E482), // 0xF241
	OND_START_BLOCK_ADDR    = (OND_BASE + 0x1E498), // 0xF24C
	OND_WPROT_STATUS        = (OND_BASE + 0x1E49C), // 0xF24E
	OND_PI_INFORMATION      = (OND_BASE + 0x1F800), // 0xFC00 
	OND_ECC_STATUS          = (OND_BASE + 0x1FE00), // 0xFF00
	OND_ECC_RESULT_1ST_SECTOR_MAIN_AREA     = (OND_BASE + 0x1FE02), // 0xFF01
	OND_ECC_RESULT_1ST_SECTOR_SPARE_AREA    = (OND_BASE + 0x1FE04), // 0xFF02
	OND_ECC_RESULT_2ND_SECTOR_MAIN_AREA     = (OND_BASE + 0x1FE06), // 0xFF03
	OND_ECC_RESULT_2ND_SECTOR_SPARE_AREA    = (OND_BASE + 0x1FE08), // 0xFF04
	OND_ECC_RESULT_3RD_SECTOR_MAIN_AREA     = (OND_BASE + 0x1FE0A), // 0xFF05
	OND_ECC_RESULT_3RD_SECTOR_SPARE_AREA    = (OND_BASE + 0x1FE0C), // 0xFF06
	OND_ECC_RESULT_4TH_SECTOR_MAIN_AREA     = (OND_BASE + 0x1FE0E), // 0xFF07
	OND_ECC_RESULT_4TH_SECTOR_SPARE_AREA    = (OND_BASE + 0x1FE10), // 0xFF08
	FOND_ECC_STATUS1          = (OND_BASE + 0x1FE00), // 0xFF00
	FOND_ECC_STATUS2          = (OND_BASE + 0x1FE02), // 0xFF00
	FOND_ECC_STATUS3          = (OND_BASE + 0x1FE04), // 0xFF00
	FOND_ECC_STATUS4          = (OND_BASE + 0x1FE06), // 0xFF00

}OND_REGS;

// Direct Access(Map11) - Write Protection Reg (at 0xF24E)
#define UNLOCKED_STATUS             0x4
#define LOCKED_STATUS               0x2
#define LOCKED_TIGHT_STATUS         0x1

// Device Command
#define OND_LD_MS_TO_BUF            0x0000 // Load single/multiple sector data unit into buffer
#define	FOND_SPLD_MS_TO_BUF			0x0003 // Superload a page unit from buffer
#define	FOND_LSB_RCVRD_PI_UP		0x0005 // LSB page recovery Read. PI update
#define OND_LD_SS_TO_BUF            0x0013 // Load single/multiple spare sector into buffer
#define OND_PG_MS_FR_BUF            0x0080 // Program single/multiple sector data unit from buffer
#define OND_PG_SS_FR_BUF            0x001A // Program single/multiple spare data unit from buffer
#define OND_CP_BACK_PRG             0x001B // Copy back Program operation
#define OND_2X_PRG                  0x007D // 2X Program operation
#define OND_2X_CACHE_PRG            0x007F // 2X Program operation
#define	FOND_CACHE_PRG				0x007F // Cache Program operation
#define	FOND_CACHE_PRG_FINISH		0x0080 // Cache Program Finish operation
#define OND_UNLOCK                  0x0023 // Unlock NAND array a block
#define OND_LOCK                    0x002A // Lock NAND array a block
#define OND_LOCK_TIGHT              0x002C // Lock-tight NAND array a block
#define OND_UNLOCK_ALL              0x0027 // All Block Unlock
#define OND_ERASE_VERIFY            0x0071 // Erase Verify Read
#define OND_START_CACHE_READ        0x000E // Cache Read
#define OND_FINISH_CACHE_READ       0x000C // Finich Cache Read
#define OND_SYNC_BURST_READ         0x000A // Synchronous Burst Block Read
#define OND_BLK_ERASE               0x0094 // Block Erase
#define OND_MULTY_ERASE             0x0095 // Multi-Block Erase
#define OND_ERASE_SUS               0x00B0 // Erase Suspend
#define OND_ERASE_RESUME            0x0030 // Erase Resume
#define OND_RST_CORE                0x00F0 // Reset NAND Flash Core
#define OND_RST_OND                 0x00F3 // Reset MuxOND
#define OND_OTP_ACS                 0x0065 // OTP Access
#define	FOND_PI_ACS					0x0066 // Access to Partition Information(PI) Block
// Flex-OND
#define OND_CACHE_PRG               0x007f
#define OND_FIN_CACHE_PRG           0x0080

volatile static ONDC pONDC;
volatile u8 gAuto_test = 0;

#ifndef Interrupt    //There is no meaning..just INDEX of program
void __irq Isr_ONDC(void)
{
	//oIntc.Mask(INT_ONENAND); 

	u32 uONDIntPend;
	u32 uDMAIntPend;
	u32 uSQCIntPend;
	ONDC_INT_ERROR eIntErrStatus;

//	Disp("Int occur\n");
	OND_GetIntStatus(&eIntErrStatus);

    uONDIntPend = ondInp32(ONDC_INTC_OND_PEND);
	uDMAIntPend = ondInp32(ONDC_INTC_DMA_PEND);
	uSQCIntPend = ondInp32(ONDC_INTC_SQC_PEND);
//   UART_Printf("uONDIntPend= %x\n",uONDIntPend);
//	UART_Printf("uDMAIntPend= %x\n",uDMAIntPend);
//	UART_Printf("uSQCIntPend= %x\n",uSQCIntPend);
	
	//if(uONDIntPend!=0)
	//{
	//	Disp("OND Int occur\n");
	//	ondOutp32(ONDC_INTC_OND_CLR,uONDIntStatus);
    //	pONDC.m_bOND_INT_Occur =1;
	//}
	//else if(uDMAIntStatus!=0)
	if(uDMAIntPend!=0)
	{
		if(uDMAIntPend==(0x1<<24))
		{
//			Disp("DMA transfer done\n");
			ondOutp32(ONDC_DMA_TRANS_CMD,(0x1<<18));
		}
		else if(uDMAIntPend==(0x1<<16))
		{
			Disp("DMA transfer error\n");
			ondOutp32(ONDC_DMA_TRANS_CMD,(0x1<<16));
		}	
		ondOutp32(ONDC_INTC_DMA_CLR,uDMAIntPend);
		
		pONDC.m_bDMA_INT_Occur =1;
	}
	if(uSQCIntPend!=0)
	{
		if(uSQCIntPend==(0x1<<24))
		{
//			Disp("SQC done\n");
			ondOutp32(ONDC_SQC_CMD,(0x1<<18));
		}
		else if(uSQCIntPend==(0x1<<16))
		{
			Disp("SQC error occur\n");
			ondOutp32(ONDC_SQC_CMD,(0x1<<16));
		}
		
		ondOutp32(ONDC_INTC_SQC_CLR,uSQCIntPend);
		pONDC.m_bSQC_INT_Occur =1;
	}
	/*
	switch(eIntErrStatus)
	{
		case ONDC_LDFAILECCERR:
			break;
		case ONDC_INTTO:
			break;
		case ONDC_PGMFAIL:
			break;
		case ONDC_ERSFAIL:
			break;
		case ONDC_LOADCMP:
			break;
		case ONDC_PGMCMP:
			break;
		case ONDC_ERSCMP:
			break;
		case ONDC_BLKRWCMP:
			break;
		case ONDC_LOCKEDBLK:
			break;
		case ONDC_UNSUPCMD:
			break;
		case ONDC_INTACT:
			break;
		case ONDC_RSTCMP:
			break;
		case ONDC_CACHEOPERR:
			break;
		default:
			break;
	}
    */
//	Disp(" @");
	
	OND_ClearPending(eIntErrStatus);
	INTC_ClearVectAddr();
	
}

void OND_INT_SET_VEC(void)
{
	ONDC_INT_ERROR eIntErrStatus;
	

    pONDC.m_bOND_INT_Occur=0;
	pONDC.m_bDMA_INT_Occur=0;
	pONDC.m_bSQC_INT_Occur=0;
	if(pONDC.m_bUseINT==1)
    {
		INTC_SetVectAddr(NUM_ONENAND_AUDI,Isr_ONDC);
		INTC_Enable(NUM_ONENAND_AUDI);
        ondOutp32(ONDC_INTC_OND_MASK,0xff);
//        ondOutp32(ONDC_INTC_OND_MASK,0x00);
		ondOutp32(ONDC_INTC_DMA_MASK,0);
		ondOutp32(ONDC_INTC_SQC_MASK,0x01010000);
	
	}
	else
	{
		ondOutp32(ONDC_INTC_OND_MASK,0xff);
//		ondOutp32(ONDC_INTC_OND_MASK,0x00);
		ondOutp32(ONDC_INTC_DMA_MASK,0x01010000);
		ondOutp32(ONDC_INTC_SQC_MASK,0x01010000);
	}


	OND_GetIntStatus(&eIntErrStatus);
	OND_ClearPending(eIntErrStatus);
	INTC_ClearVectAddr();
}

void OND_INT_SET_VEC_SQC(void)
{
	ONDC_INT_ERROR eIntErrStatus;
	
    pONDC.m_bOND_INT_Occur=0;
	pONDC.m_bDMA_INT_Occur=0;
	pONDC.m_bSQC_INT_Occur=0;
	if(pONDC.m_bUseINT==1)
    {
		INTC_SetVectAddr(NUM_ONENAND_AUDI,Isr_ONDC);
		INTC_Enable(NUM_ONENAND_AUDI);
        ondOutp32(ONDC_INTC_OND_MASK,0xff);
		ondOutp32(ONDC_INTC_DMA_MASK,0x01010000);
		ondOutp32(ONDC_INTC_SQC_MASK,0);
	
	}
	OND_GetIntStatus(&eIntErrStatus);
	OND_ClearPending(eIntErrStatus);
	INTC_ClearVectAddr();
}


void OND_ClearPending(ONDC_INT_ERROR eIntErr)
{
//	u32 wData;
//	wData =
//		(eIntErr == ONDC_LDFAILECCERR) ? (0x1<<0) :
//		(eIntErr == ONDC_INTTO) ? (0x1<<1) :
//		(eIntErr == ONDC_PGMFAIL) ? (0x1<<2) :
//		(eIntErr == ONDC_ERSFAIL) ? (0x1<<3) :
//		(eIntErr == ONDC_LOADCMP) ? (0x1<<4) :
//		(eIntErr == ONDC_PGMCMP) ? (0x1<<5) :
//		(eIntErr == ONDC_ERSCMP) ? (0x1<<6) :
//		(eIntErr == ONDC_BLKRWCMP) ? (0x1<<7) :
//		(eIntErr == ONDC_LOCKEDBLK) ? (0x1<<8) :
//		(eIntErr == ONDC_UNSUPCMD) ? (0x1<<9) :
//		(eIntErr == ONDC_INTACT) ? (0x1<<10) :
//		(eIntErr == ONDC_RSTCMP) ? (0x1<<12) :
//		(eIntErr == ONDC_CACHEOPERR) ? (0x1<<13) :  0;
//	ondOutp32(INT_ERR_ACK, wData);
}



void OND_WaitForIntStatus(ONDC_INT_ERROR eIntErr)
{
	u32 rData;
	u32 uBitPos;
	rData = ondInp32(OND_REG_INT_STATUS);

	//onDbg(("INTR_ERR_STATUS: 0x%x\n", rData));

	uBitPos =
		(eIntErr == ONDC_LD_FAIL_OR_ECC_ERR) ? (0) :
		(eIntErr == ONDC_TIMEOUT) ? (1) :
		(eIntErr == ONDC_PGM_FAIL) ? (2) :
		(eIntErr == ONDC_ERASE_FAIL) ? (3) :
		(eIntErr == ONDC_LOAD_COMPLETE) ? (4) :
		(eIntErr == ONDC_PGM_COMPLETE) ? (5) :
		(eIntErr == ONDC_ERS_COMPLETE) ? (6) :
		(eIntErr == ONDC_BLK_RW_COMPLETE) ? (7) :
		(eIntErr == ONDC_LOCKED_BLK) ? (8) :
		(eIntErr == ONDC_UNSUP_CMD) ? (9) :
		(eIntErr == ONDC_DEV_INTR) ? (10) :
		(eIntErr == ONDC_RST_COMPLETE) ? (12) :
		(eIntErr == ONDC_CACHE_OP_ERR) ? (13) : 0xff;
	Assert(uBitPos != 0xff);

	while(((rData>>uBitPos) & 0x1) == 0)
		rData = Inp32(OND_REG_INT_STATUS);
	//ondDispVector(("d=0xf; while( ((d>>%d)&0x1)==0 ) Inp32 (0x%x, d); // d=0x%x\n", 
	//	uBitPos, INTR_ERR_STATUS, rData ));

}
// [Get Interrupt Status]
void OND_GetIntStatus(ONDC_INT_ERROR *eIntErr)
{
//	u32 rData;
//	ondInp32(INT_ERR_STATUS, rData);
//	//onDbg(("INT_ERR_STATUS: 0x%x\n", rData));
//	eIntErr =
//		(rData & (0x1<<0)) ? ONDC_LDFAILECCERR :
//		(rData & (0x1<<1)) ? ONDC_INTTO :
//		(rData & (0x1<<2)) ? ONDC_PGMFAIL :
//		(rData & (0x1<<3)) ? ONDC_ERSFAIL :
//		(rData & (0x1<<4)) ? ONDC_LOADCMP :
//		(rData & (0x1<<5)) ? ONDC_PGMCMP :
//		(rData & (0x1<<6)) ? ONDC_ERSCMP :
//		(rData & (0x1<<7)) ? ONDC_BLKRWCMP :
//		(rData & (0x1<<8)) ? ONDC_LOCKEDBLK :
//		(rData & (0x1<<9)) ? ONDC_UNSUPCMD :
//		(rData & (0x1<<10)) ? ONDC_INTACT :
//		(rData & (0x1<<12)) ? ONDC_RSTCMP :
//		(rData & (0x1<<13)) ? ONDC_CACHEOPERR : ONDC_NOERROR;
}


#endif
#ifndef Init  //There is no meaning..just INDEX of program

void OND_GPIO_Init(void)
{
	//GPIO_SetFunctionEach(eGPIO_J1, eGPIO_5, eGFunc_3); //INT[1]
	GPIO_SetFunctionEach(eGPIO_MP0_1, eGPIO_4, eGFunc_3); //CSn[0]
	GPIO_SetFunctionEach(eGPIO_MP0_1, eGPIO_5, eGFunc_3); //CSn[1]
	GPIO_SetFunctionEach(eGPIO_MP0_3, eGPIO_0, eGFunc_3); //AVD
	GPIO_SetFunctionEach(eGPIO_MP0_3, eGPIO_1, eGFunc_3); //SMCLK
	GPIO_SetFunctionEach(eGPIO_MP0_3, eGPIO_2, eGFunc_3); //RPn
	GPIO_SetFunctionEach(eGPIO_MP0_3, eGPIO_4, eGFunc_3); //INT[0]
	GPIO_SetFunctionEach(eGPIO_MP0_3, eGPIO_5, eGFunc_3); //INT[1]

//	GPIO_SetDRVRegAll(eGPIO_MP0_1, 0x5555);
//	GPIO_SetDRVRegAll(eGPIO_MP0_3, 0x5555);
//	GPIO_SetDRVRegAll(eGPIO_MP0_6, 0x5555);
//	GPIO_SetDRVRegAll(eGPIO_MP0_7, 0x5555);
	//Outp32(0xe02002ec,0x5555);
	//Outp32(0xe020032c,0x5555);
	//Outp32(0xe020038c,0x5555);
	//Outp32(0xe02003ac,0x5555);

	Outp32(0xe02002ec,0xffff);
	Outp32(0xe020032c,0xffff);
	Outp32(0xe020038c,0xffff);
	Outp32(0xe02003ac,0xffff);


	
}

// [Init Ip]
void OND_InitIp(void)
{
	u32 uManuId;
	u32 uDevId;
	u32 bIsDDP;
	u32 uAmount;
	
	u32 uDensity;
	u32 *uData;
	u8 sel;
	u32 uOmsetting;

	OND_GPIO_Init();
	SYSC_SetClkMuxState(eCLKMUX_OND_HCLKDSYS); //83Mhz
//	SYSC_SetClkMuxState(eCLKMUX_OND_HCLKPSYS); //66Mhz

//#ifdef BOOT
//	uOmsetting = (u32)SYSC_GetOperatingMode;
//	if(uOmsetting&0x2==0x2)
//		OND_Mux_DeMux_setting(1);
//#else
//	OND_Mux_DeMux_Change();
//#endif	

	
	
	OND_ResetDevice(OND_WARM_RESET);

	Disp( " 0: Dma not use       1: Dma use \n" );
	sel = UART_GetIntNum();
	
	pONDC.m_bUseDMA = sel;

	if(pONDC.m_bUseDMA==1)
	{
		Disp("DMA Burst Length \n");
		Disp("0: Single  1: 4 Burst  2: 8 Burst  3: 16 Burst \n");
		sel = UART_GetIntNum();	

	    switch(sel)
		{
			case 0 :
			        pONDC.m_uDmaBurstLength =  DMA_BL_SINGLE ;
					break;
			case 1 :
				    pONDC.m_uDmaBurstLength =  DMA_BL_4BURST ;
					break;
			case 2 :
			        pONDC.m_uDmaBurstLength =  DMA_BL_8BURST ;
					break;
			case 3 :
			        pONDC.m_uDmaBurstLength =  DMA_BL_16BURST ;
					break;
			default :
			        pONDC.m_uDmaBurstLength =  DMA_BL_SINGLE ;
					break;
		}

		Disp("DMA Data Width \n");
		Disp("0: 8bit  1: 16bit  2: 32bit  \n");
		sel = UART_GetIntNum();	

	    switch(sel)
		{
			case 0 :
			        pONDC.m_uDmaDataWidth =  DMA_DW_8 ;
					break;
			case 1 :
				    pONDC.m_uDmaDataWidth =  DMA_DW_16 ;
					break;
			case 2 :
			        pONDC.m_uDmaDataWidth =  DMA_DW_32 ;
					break;
			default :
			        pONDC.m_uDmaDataWidth =  DMA_DW_16 ;
					break;
		}	

	}
	
    UART_Printf( " 0: INT not use       1: INT use \n" );
	if(gAuto_test == 0) 
	{
		sel = UART_GetIntNum();
		if (sel ==1)
			pONDC.m_bUseINT =1;
		else 
			pONDC.m_bUseINT =0;	    
	}
	else 
		pONDC.m_bUseINT =1;

    OND_INT_SET_VEC();
//JHHEO:2008/8/5 ==> Configuration of OneNAND interface 
	OND_ConfigOndInf();
//JHHEO:2008/8/5 <== 

	
	OND_GetManufactId(&uManuId);
	onDbg((" Manufacture ID = 0x%x\n", uManuId));
	UART_Printf(" Manufacture ID = 0x%x\n", uManuId);
	
	OND_GetDeviceId(&uDevId);
	onDbg((" Device ID = 0x%x\n", uDevId));
	UART_Printf(" Device ID = 0x%x\n", uDevId);


	
	OND_GetBootBufSz( &pONDC.m_uBootBufByteSize );
	OND_GetDataBufSz( &pONDC.m_uDataBufByteSize );


	(u16)uAmount = ondInp16(OND_AMOUNT_OF_BUFSIZE);
	pONDC.m_uNumOfDataBuf = (uAmount>>8) & 0x3;

	pONDC.m_uPageByteSize =(pONDC.m_uDataBufByteSize *2)/pONDC.m_uNumOfDataBuf;
	

	uDensity = (uDevId>>4)&0x7;
	UART_Printf(" uDensity = 0x%d\n", uDensity);
	
	pONDC.m_bIsFlexDev = OND_IsFlexDev();
	
	
	if ( pONDC.m_uNumOfDataBuf ==2 )
	{
		onDbg((" This is a Flex-OneNAND or 4KB pagesize OneNAND \n"));
		if(pONDC.m_bIsFlexDev == 1)
		{
			//OND_ReadPartitionInfo( uData );
			//Disp(" SLC size = %x\n", *uData);
			pONDC.m_uNumFlexSlcOfPages = 64;
			pONDC.m_uNumFlexMlcOfPages = 128;
			pONDC.m_uPageByteSize =0x1000; //4KB size
			pONDC.m_uSpareByteSize = 128;
		}
		else
		{	
			onDbg((" This is a Normal OneNAND\n"));
			pONDC.m_uNumOfPages = 64; 
			pONDC.m_uSpareByteSize = 64; 
		}
	

	}
	else // normal OND
	{
		onDbg((" This is a Normal OneNAND\n"));
		pONDC.m_uNumOfPages = 64; 
		//pONDC.m_uPageByteSize = pONDC.m_uDataBufByteSize;
		pONDC.m_uSpareByteSize = 64; 
	}

	if ( uDensity == 0 )// 128Mb
		pONDC.m_uNumOfBlocks = 128*1024*1024/8/64/(pONDC.m_uPageByteSize);
	else if ( uDensity == 1 ) // 256Mb
		pONDC.m_uNumOfBlocks = 256*1024*1024/8/64/(pONDC.m_uPageByteSize);
	else if ( uDensity == 2 ) // 512Mb
		pONDC.m_uNumOfBlocks = 512*1024*1024/8/64/(pONDC.m_uPageByteSize); 
	else if ( uDensity == 3 ) // 1Gb
		pONDC.m_uNumOfBlocks =   1*1024*1024/8/64/(pONDC.m_uPageByteSize)*1024;
	else if ( uDensity == 4 ) // 2Gb
		pONDC.m_uNumOfBlocks =   2*1024*1024/8/64/(pONDC.m_uPageByteSize)*1024;  // u32's limit value is 4Gb.
	else if ( uDensity == 5 ) // 4Gb
		pONDC.m_uNumOfBlocks =   4*1024*1024/8/64/(pONDC.m_uPageByteSize)*1024;  // u32's limit value is 4Gb.
	else if ( uDensity == 6 ) // 8Gb
		pONDC.m_uNumOfBlocks =   8*1024*1024/8/64/(pONDC.m_uPageByteSize)*1024;  // u32's limit value is 4Gb.
	else if ( uDensity == 7 ) // 16Gb
		pONDC.m_uNumOfBlocks =  16*1024*1024/8/64/(pONDC.m_uPageByteSize)*1024;  // u32's limit value is 4Gb.
	else
		pONDC.m_uNumOfBlocks = 128*1024*1024/8/64/(pONDC.m_uPageByteSize);

	
	Disp(" pONDC.m_uNumOfBlocks = 0x%x\n", pONDC.m_uNumOfBlocks);

	bIsDDP = OND_IsDdpDev();
	pONDC.m_uIsDDP = (bIsDDP) ? 1 : 0;
	onDbg(( " pONDC.m_uIsDDP = %d(1=DDP)\n", pONDC.m_uIsDDP));

	if(pONDC.m_uIsDDP ==1)
		pONDC.m_uNumOfBlocks =pONDC.m_uNumOfBlocks*2;
}

#endif
#ifndef INFO_FUNC  //There is no meaning..just INDEX of program
void OND_Info(void)
{
	UART_Printf(" m_uNumOfBlocks = 0x%x\n",pONDC.m_uNumOfBlocks);
	UART_Printf(" m_uIsDDP = 0x%x\n",pONDC.m_uIsDDP);
	UART_Printf(" m_uBootBufByteSize = 0x%x\n",pONDC.m_uBootBufByteSize);
	UART_Printf(" m_uNumOfDataBuf = 0x%x\n",pONDC.m_uNumOfDataBuf);
	UART_Printf(" m_uDataBufByteSize = 0x%x\n",pONDC.m_uDataBufByteSize);
	UART_Printf(" m_eSyncMode = 0x%x\n",pONDC.m_eSyncMode);
	UART_Printf(" m_uNumOfPages = 0x%x\n",pONDC.m_uNumOfPages);
	UART_Printf(" m_uPageByteSize = 0x%x\n",pONDC.m_uPageByteSize);
	UART_Printf(" m_uSpareByteSize = 0x%x\n",pONDC.m_uSpareByteSize);
	UART_Printf(" m_bUseDMA = 0x%x\n",pONDC.m_bUseDMA);
	UART_Printf(" m_uSpareByteSize = 0x%x\n",pONDC.m_uSpareByteSize);
	UART_Printf(" m_bIsFlexDev = 0x%x\n",pONDC.m_bIsFlexDev);
	UART_Printf(" m_uNumFlexSlcOfPages = 0x%x\n",pONDC.m_uNumFlexSlcOfPages);
	UART_Printf(" m_uNumFlexMlcOfPages = 0x%x\n",pONDC.m_uNumFlexMlcOfPages);
	 
}

// [Get Total Number Of Blocks]
void OND_GetTotalNumOfBlocks( u32 *uBlocks )
{
	*uBlocks = pONDC.m_uNumOfBlocks;
}

// [Get Boot Byte Size]
void OND_GetBootBufSz( u32 *uSz )
{
	u16 x;
	x= ondInp16(OND_BOOT_BUFSIZE);
	*uSz = (u32)x*2;
}

// [Get Data Buf Byte Size]
void OND_GetDataBufSz( u32 *uSz )
{
	u16 x;
	x= ondInp16(OND_DATA_BUFSIZE);
	*uSz = (u32)x;
}

// [Get Page Byte Size]
void OND_GetPageSz( u32 *uPageByteSz )
{
	*uPageByteSz = pONDC.m_uPageByteSize;
}

// [Get Spare Byte Size]
void OND_GetSpareSz( u32 *uSpareByteSz )
{
	*uSpareByteSz = pONDC.m_uSpareByteSize;
}

// [Get Sync Mode]
void OND_GetSyncMode(OND_MODE *eMode)
{
	*eMode = pONDC.m_eSyncMode;
}

// [Get Manufacture ID]
void OND_GetManufactId(u32 *uManuId )
{
	u16 x;
	x = ondInp16(OND_MANUFACT_ID);
	*uManuId = (u32)x;
}

// [Get Device ID]
void OND_GetDeviceId( u32 *uDevId )
{
	u16 x;
	x = ondInp16(OND_DEVICE_ID);
	*uDevId = (u32)x;
}

// [Is DualDiePlan Device]
u8 OND_IsDdpDev()
{
	u16 x;
	x = ondInp16(OND_DEVICE_ID);
	if( x & 0x0008 )
		return true;
	else
		return false;
}

// [Is Flex Device]
u8 OND_IsFlexDev()
{
	u16 x;
	x = ondInp16(OND_DEVICE_ID);
	if ( x & 0x0200 )
		return true;
	else
		return false;
}

#endif



#ifndef BASIC_FUNC  //There is no meaning..just INDEX of program

void OND_Mux_DeMux_setting(u8 value)
{
	u16 temp;
	temp = ondInp16(ONDC_CTRL_REG);
	temp = (~0x1)<<31|value;
	ondOutp16(ONDC_CTRL_REG,temp);
	pONDC.m_MuxDemux = value;
}


void OND_Mux_DeMux_Change(void)
{
	u16 temp;
	u8 sel;
	
	Disp("Mux or Demux \n");
	Disp("0: Mux  1: Demux \n");
	sel = UART_GetIntNum();	
	OND_Mux_DeMux_setting(sel);
	
}

// [Reset Device]
void OND_ResetDevice(OND_RESET_TYPE eMode)
{
	
	
	if ( eMode == OND_WARM_RESET )
	{
		ondOutp16( ONDC_CTRL_CMD_REG, 0x2 );
		//ondOutp32( OND_COMMAND, OND_RST_OND );
	}
	else if ( eMode == OND_CORE_RESET )
	{
		ondOutp16( OND_COMMAND, OND_RST_CORE );
	}
	else if ( eMode == OND_HOT_RESET )
	{
		ondOutp16( OND_COMMAND, OND_RST_OND );
	}
	else
	{
		Assert(0);
	}
	
	OND_WaitForDeviceCmdDone(OND_RSTI);
}

// [Unlock All Blocks]
u8 OND_UnlockAll(void)
{
	u32 bIsOK;
	u32 uErrCnt = 0;
	u32 i;
	
	ondOutp16( OND_START_ADDR2, 0 );	// DBS(Device BufferRAM Select)
	ondOutp16( OND_START_ADDR1, 0 );	// DFS(Device Flash Core Select)
	ondOutp16( OND_START_BLOCK_ADDR, 0 ); 		// Start Block Address
	ondOutp16( OND_REG_INT_STATUS, 0 );
	ondOutp16( OND_COMMAND, OND_UNLOCK_ALL );
	OND_WaitForDeviceCmdDone( OND_INT );	
	onDbg(("[ULA.C-"));
	bIsOK = OND_IsDeviceCmdCompleted();
	if ( bIsOK == false ) uErrCnt++;

	ondOutp16( OND_START_ADDR2, 0x8000 );	// DBS(Device BufferRAM Select)
	ondOutp16( OND_START_ADDR1, 0x8000 );	// DFS(Device Flash Core Select)
	ondOutp16( OND_START_BLOCK_ADDR, 0 ); 	// Start Block Address
	ondOutp16( OND_REG_INT_STATUS, 0 );
	ondOutp16( OND_COMMAND, OND_UNLOCK_ALL );
	OND_WaitForDeviceCmdDone( OND_INT );	
	onDbg(("[ULA.C-"));
	bIsOK = OND_IsDeviceCmdCompleted();
	if ( bIsOK == false ) uErrCnt++;
	for( i=0; i<pONDC.m_uNumOfBlocks; i++ )
	{
		onDbg(("["));
		bIsOK = OND_VerifyWrProtectionStatus( i, UNLOCKED_STATUS );
		if ( bIsOK == false ) uErrCnt++;
	}
	
	if ( uErrCnt == 0 ) 
		return true;
	else
		return false;

}

// [Unlock Blocks]
u8 OND_UnlockBlocks( u32 uBlockIndex, u32 uNumOfBlocks )
{
	u32 bIsOK;
	u32 uErrCnt = 0;
	u16 nDFS = 0;
	u16 nDBS = 0;
    u32 i;
    
    Assert( uBlockIndex < pONDC.m_uNumOfBlocks );
	    
	for ( i=uBlockIndex; i<(uBlockIndex+uNumOfBlocks); i++ )
	{
		if(pONDC.m_uIsDDP)
		{
			if(uBlockIndex>((pONDC.m_uNumOfBlocks )/2))
			{
				nDBS |= 1<<15;
				nDFS |= 1<<15;

			}
		}
		ondOutp16( OND_START_ADDR2, nDBS ); // DBS(Device BufferRAM Select)
//		ondOutp16( OND_START_ADDR1, nDFS|(pONDC.m_uBlockBitMask&i) ); // DFS(Device Flash Core Select)				
		ondOutp16( OND_START_ADDR1, nDFS|i ); // DFS(Device Flash Core Select)
		ondOutp16( OND_START_BLOCK_ADDR, i ); // Start Block Address
		ondOutp16( OND_REG_INT_STATUS, 0 );
		ondOutp16( OND_COMMAND, OND_UNLOCK );
		OND_WaitForDeviceCmdDone( OND_INT );
		onDbg(("[UL.C-"));
		bIsOK = OND_IsDeviceCmdCompleted();
		if ( bIsOK == false ) uErrCnt++;
		onDbg(("[UL.V-"));
		bIsOK = OND_VerifyWrProtectionStatus( i, UNLOCKED_STATUS );
		if ( bIsOK == false ) uErrCnt++;
	}
	
	if ( uErrCnt == 0 ) 
		return true;
	else
		return false;
}

// [Erase All Block]
u8 OND_EraseAllBlocks(void)
{
	u32 bIsOK;
	bIsOK = OND_EraseBlocks( 0, pONDC.m_uNumOfBlocks );


	return bIsOK;
}

// [Erase Blocks]
u8 OND_EraseBlocks( u32 uBlockIndex, u32 uNumOfBlocks )
{
	
	u32 bIsOK;
	u32 uErrCnt = 0;
	u32 x, i;
	u16 nDFS,nDBS;
	u16 nWritePrtection;
	u16 nBBs[100];
	
	Assert( uBlockIndex < pONDC.m_uNumOfBlocks );
	
	for ( i=uBlockIndex; i<(uBlockIndex+uNumOfBlocks); i++ )
	{
		if(pONDC.m_uIsDDP)
		{
			if(uBlockIndex>((pONDC.m_uNumOfBlocks)/2))
			{
				nDBS |= 1<<15;
				nDFS |= 1<<15;

			}
		}
		ondOutp16( OND_START_ADDR2, nDFS );		
		//ondOutp16( OND_START_ADDR1, nDFS|(pONDC.m_uBlockBitMask&i));
		ondOutp16( OND_START_ADDR1, nDFS|i);
		nWritePrtection = ondInp16( OND_WPROT_STATUS );
		if( nWritePrtection & LOCKED_STATUS )
		{
			Disp("OND_ProgramOnePage: This block is locked.\n");
			return false;
		}
		else
		if( nWritePrtection & LOCKED_TIGHT_STATUS )
		{
			Disp("OND_ProgramOnePage: This block is locked-tight.\n");
			return false;
		}
		ondOutp16( OND_REG_INT_STATUS, 0 );
		ondOutp16( OND_COMMAND, OND_BLK_ERASE );
		OND_WaitForDeviceCmdDone( OND_EI );
		onDbg(("[E.C-"));
		bIsOK = OND_IsDeviceCmdCompleted();
		if ( bIsOK == false ) 
		{
			nBBs[uErrCnt++] = i;
			continue;
		}
		if(!pONDC.m_bIsFlexDev)
		{
			onDbg(("[E.V-"));
			bIsOK = OND_VerifyErasedBlock( i ); // Verify erase block
			if ( bIsOK == false ) 
			{
				nBBs[uErrCnt++] = i;
			}
		}
	}

	if(uErrCnt)
	{
		Disp("Bad Block Status--------------\n");
		for ( i=0; i<uErrCnt; i++)
		{
			Disp("%3d. %4d(0x%04x)block is bad.\n", uErrCnt, nBBs[i], nBBs[i]);	
		}
		Disp("Total : %dblocks\n", uErrCnt);
		Disp("------------------------------\n");
	}	
	return true;
}


// [Lock Blocks]
u8 OND_LockBlocks( u32 uBlockIndex, u32 uNumOfBlocks )
{

	u32 bIsOK;
	u32 uErrCnt = 0;
	u16 nDFS = 0;
	u16 nDBS = 0;
	u32 i;

	Assert( uBlockIndex < pONDC.m_uNumOfBlocks );

	for (i=uBlockIndex; i<(uBlockIndex+uNumOfBlocks); i++ )
	{
		if(pONDC.m_uIsDDP)
		{
			if(uBlockIndex>(uNumOfBlocks/2))
			{
				nDBS |= 1<<15;
				nDFS |= 1<<15;

			}
		}
		ondOutp16( OND_START_ADDR2, nDBS );		// DBS(Device BufferRAM Select)
//		ondOutp16( OND_START_ADDR1, nDFS|(pONDC.m_uBlockBitMask&i) ); // DFS(Device Flash Core Select)
		ondOutp16( OND_START_ADDR1, nDFS|(i) ); // DFS(Device Flash Core Select)
		ondOutp16( OND_START_BLOCK_ADDR, i ); // Start Block Address
		ondOutp16( OND_REG_INT_STATUS, 0 );
		ondOutp16( OND_COMMAND, OND_LOCK );
		OND_WaitForDeviceCmdDone( OND_INT );
		onDbg(("[L.C-"));
		bIsOK = OND_IsDeviceCmdCompleted();
		if ( bIsOK == false ) uErrCnt++;
		onDbg(("[L.V-"));
		bIsOK = OND_VerifyWrProtectionStatus( i, LOCKED_STATUS );
		if ( bIsOK == false ) uErrCnt++;
	}
	
	if ( uErrCnt == 0 ) 
		return true;
	else
		return false;
}

// [Lock Blocks Tightly]
u8 OND_LockBlocksTightly( u32 uBlockIndex, u32 uNumOfBlocks )
{
	
	u32 bIsOK;
	u32 uErrCnt = 0;
	u16 nDFS = 0;
	u16 nDBS = 0;
	u32 i;

	Assert( uBlockIndex < pONDC.m_uNumOfBlocks );
	
	for (i=uBlockIndex; i<(uBlockIndex+uNumOfBlocks); i++ )
	{
		if(pONDC.m_uIsDDP)
		{
			if(uBlockIndex>(uNumOfBlocks/2))
			{
				nDBS |= 1<<15;
				nDFS |= 1<<15;

			}
		}
		ondOutp16( OND_START_ADDR2, nDBS );		// DBS(Device BufferRAM Select)
		ondOutp16( OND_START_ADDR1, nDFS|(i) ); // DFS(Device Flash Core Select)
		ondOutp16( OND_START_BLOCK_ADDR, i );	// Start Block Address
		ondOutp16( OND_REG_INT_STATUS, 0 );
		ondOutp16( OND_COMMAND, OND_LOCK_TIGHT );
		OND_WaitForDeviceCmdDone( OND_INT );
		onDbg(("[LT.C-"));
		bIsOK = OND_IsDeviceCmdCompleted();
		if ( bIsOK == false ) uErrCnt++;
		onDbg(("[LT.V-"));
		bIsOK = OND_VerifyWrProtectionStatus( i, LOCKED_TIGHT_STATUS );
		if ( bIsOK == false ) uErrCnt++;
	}
	
	if ( uErrCnt == 0 ) 
		return true;
	else
		return false;
}

// [Set Sync. Mode]
void OND_SetSyncMode( OND_MODE eMode, u32 ePrefetch)
{

	volatile u16	rOndSysConfig1Reg;
	volatile u32	rOndCtrlReg;
    volatile u32	rOndIfStatus;
	u32 sel;
	u32 nCnt;	


    rOndSysConfig1Reg = ondInp16(OND_SYS_CONFIG1);
	UART_Printf("rOndSysConfig1Reg = %x \n",rOndSysConfig1Reg);
	rOndCtrlReg = ondInp32(ONDC_CTRL_REG);

		
	rOndIfStatus = ondInp32(ONDC_STATUS_REG);
    while(rOndIfStatus&0x1 ==1)
    {
		rOndIfStatus = ondInp32(ONDC_STATUS_REG);	// check ORWB bit 0:not busy 1:busy
	}
	

	pONDC.m_eSyncMode = eMode;
	
	rOndSysConfig1Reg	|= (OND_READ_SYNC_MODE | OND_WRITE_SYNC_MODE);
	rOndSysConfig1Reg	&= OND_BL_CLR;
	rOndCtrlReg		|= (OND_READ_SYNC_MODE | OND_WRITE_SYNC_MODE);	
	rOndCtrlReg		&= OND_BL_CLR;

	if ( eMode == OND_ASYNC )
	{
        Disp("0: Async read \ Async write      1: Async read \ Sync write\n");
		if(gAuto_test == 0) 
			sel = UART_GetIntNum();	
		else
			sel = 0;	
        if(sel==1)
		{
			rOndSysConfig1Reg	&= (~OND_WRITE_SYNC_MODE );		
			rOndCtrlReg		&= (~OND_WRITE_SYNC_MODE );		
        }
		else
		{
			rOndSysConfig1Reg	&= (~OND_READ_SYNC_MODE | ~OND_WRITE_SYNC_MODE);		
			rOndCtrlReg		&= (~OND_READ_SYNC_MODE | ~OND_WRITE_SYNC_MODE);		
		}
	}
	else if ( eMode == OND_SYNC_BURST_CONT )
	{
		rOndSysConfig1Reg	|= OND_BL_CONT;
		rOndCtrlReg		|= OND_BL_CONT;
	}
	else if ( eMode == OND_SYNC_BURST4 )
	{
		rOndSysConfig1Reg	|= OND_BL_4;
		rOndCtrlReg		|= OND_BL_4;
	}
	else if ( eMode == OND_SYNC_BURST8 )
	{
		rOndSysConfig1Reg	|= OND_BL_8;
		rOndCtrlReg		|= OND_BL_8;
	}
	else if ( eMode == OND_SYNC_BURST16 )
	{
		rOndSysConfig1Reg	|= OND_BL_16;
		rOndCtrlReg		|= OND_BL_16;
	}
	else if ( eMode == OND_SYNC_BURST32 )
	{
		rOndSysConfig1Reg	|= OND_BL_32;
		rOndCtrlReg		|= OND_BL_32;
	}
	else if ( eMode == OND_SYNC_BURST1K )
	{
		rOndSysConfig1Reg	|= OND_BL_1K;
		rOndCtrlReg		|= OND_BL_1K;
	}
	
	else
		Assert(0);

	if(ePrefetch==1)
		rOndCtrlReg |= OND_RD_PREF_ON;
	else 
		rOndCtrlReg &= OND_RD_PREF_OFF;

	UART_Printf("rOndSysConfig1Reg setting value= %x\n",rOndSysConfig1Reg);
	
	ondOutp16(OND_SYS_CONFIG1,rOndSysConfig1Reg);
	
	 rOndSysConfig1Reg = ondInp16(OND_SYS_CONFIG1);
	 rOndSysConfig1Reg = ondInp16(OND_SYS_CONFIG1);	 
	UART_Printf("ond = %x \n",rOndSysConfig1Reg);

	if(pONDC.m_MuxDemux==DEMUX)
		rOndCtrlReg|=(0x1<<31);
		
	ondOutp32(ONDC_CTRL_REG,rOndCtrlReg);

	//nCnt = 10000;
	//while(nCnt--);	
	

}


// [Verify Write Protection Status]
u8 OND_VerifyWrProtectionStatus( u32 uBlockIndex, u32 uProtStatus )
{
	u32 bIsOK = true;
	u32 status;
	u16	nDFS = 0;
	u16	nDBS = 0;
	
	if(pONDC.m_uIsDDP)
		{
			if(uBlockIndex>((pONDC.m_uNumOfBlocks)/2))
			{
				nDBS |= 1<<15;
				nDFS |= 1<<15;

			}
		}
	//ondOutp16( OND_START_ADDR1, nDFS|(pONDC.m_uBlockBitMask&uBlockIndex) );
	ondOutp16( OND_START_ADDR1, nDFS|(pONDC.m_uBlockBitMask&uBlockIndex) );
	status = ondInp16( OND_WPROT_STATUS);

	if ( uProtStatus == UNLOCKED_STATUS && status == UNLOCKED_STATUS )
	{
		bIsOK = true;
		onDbg(("O]"));
	}
	else if ( uProtStatus == LOCKED_STATUS && status == LOCKED_STATUS )
	{
		bIsOK = true;
		onDbg(("O]"));
	}
	else if ( uProtStatus == LOCKED_TIGHT_STATUS && status == LOCKED_TIGHT_STATUS )
	{
		bIsOK = true;
		onDbg(("O]"));
	}
	else
	{
		bIsOK = false;
		onDbg(("X]"));
	}

	return bIsOK;
}

// [Verify Erased Block]
u8 OND_VerifyErasedBlock( u32 uBlkAddr )
{
	
	u32 bIsOK = true;
	u16 rData16 = 0;
	u16 nDFS = 0;
	u16 nDBS = 0;

	Assert( uBlkAddr < pONDC.m_uNumOfBlocks );
	
	if(pONDC.m_uIsDDP)
		{
			if( uBlkAddr >((pONDC.m_uNumOfBlocks)/2))
			{
				nDBS |= 1<<15;
				nDFS |= 1<<15;

			}
		}

	if (pONDC.m_bIsFlexDev == false )
	{
		ondOutp16( OND_START_ADDR2, nDFS );		  // DBS(Device BufferRAM Select)
//		ondOutp16( OND_START_ADDR1, nDFS|(pONDC.m_uBlockBitMask&uBlkAddr));// DFS(Device Flash Core Select)
		ondOutp16( OND_REG_INT_STATUS, 0 );
		ondOutp16( OND_COMMAND, OND_ERASE_VERIFY );
		OND_WaitForDeviceCmdDone( OND_INT );
		bIsOK = OND_IsDeviceCmdCompleted();
		rData16 = ondInp16( OND_CTRL_STATUS);
		if(rData16 & 0x4000/*Locked state*/)
		{
			onDbg(("X-Locked]"));
			bIsOK=false;
		}else
		if(rData16 & 0x0400/*Error state*/)
		{
			onDbg(("X-Failed]"));
			bIsOK=false;
		}else
		{
			onDbg(("O]"));
			bIsOK=true;
		}
		
		return bIsOK;
	}
	else // DIRECT ACCESS
	{
		onDbg(("O]"));
		bIsOK=true;
	}

	return false;
}


// [Read Patition Information]
void OND_ReadPartitionInfo(u32 *uData)
{
	u32	uBlockAddr  = 0;
	u32	uPageAddr	= 0;
	u32 i;
	u32 *uTempData;
	u8 bIsOK;
	
	if(!pONDC.m_bIsFlexDev)
	{
		Disp("Error : Only FlexOneNAND can use PI Block Access.\n");
		return;
	}

	OND_EnterPI(uBlockAddr);

	ondOutp16(OND_START_ADDR1, 0 );
	ondOutp16(OND_START_ADDR8, 0 );
	ondOutp16(OND_START_BUF, 0x800 );

	OND_SetEccMode(0);
	
	ondOutp16(OND_REG_INT_STATUS, 0);
	ondOutp16(OND_COMMAND, OND_LD_MS_TO_BUF);
	OND_WaitForDeviceCmdDone(OND_INT);
	bIsOK = OND_IsDeviceCmdCompleted();
	if ( bIsOK == false )
		Disp("Read PI fail\n");
	

	// 5. NAND Core Reset
	OND_ResetDevice(OND_CORE_RESET);

	uTempData = (u32*)OND_DATA00_RAM_ADDR;
	*uData = ((*uTempData)&0x3ff);
	
}


// [Write Partition Information]
u8 OND_WritePartitionInfo(u32 uPIValue)
{
	u32	uBlockAddr	= 0;
	u32	uPageAddr	= 0; 

	u32 bIsOK;

	u16 uTemp;

	if(!pONDC.m_bIsFlexDev)
	{
		Disp("Error : Only FlexOneNAND can use PI Block Access.\n");
		return false;
	}

	// 1. Enter Access Mode
	OND_EnterPI(uBlockAddr);

	// 2. Erase PI block	
	OND_EraseBlocks(uBlockAddr, 1);

	// 3. Program PI block
	OND_WriteIntoBufferRam(OND_DATARAM0, 0, 0xf000|uPIValue);
	ondOutp16(OND_START_ADDR1, 0 );
	ondOutp16(OND_START_ADDR8, 0 );
	ondOutp16(OND_START_BUF, 0x800 );

	OND_SetEccMode(0);
	
	ondOutp16(OND_REG_INT_STATUS, 0);
	ondOutp16(OND_COMMAND, OND_PG_MS_FR_BUF);
	OND_WaitForDeviceCmdDone(OND_INT);
	bIsOK = OND_IsDeviceCmdCompleted();
	if ( bIsOK == false )
		return bIsOK;
	
	// 4. Update PI block
	ondOutp16(OND_REG_INT_STATUS, 0);
	ondOutp16(OND_COMMAND, FOND_LSB_RCVRD_PI_UP);
	OND_WaitForDeviceCmdDone(OND_INT);	

	// 5. NAND Core Reset
	OND_ResetDevice(OND_CORE_RESET);

//	uTemp= ondInp16(OND_PI_INFORMATION);
//	Disp("OND_PI_INFORMATION = %x\n",uTemp);

	
	return bIsOK;
}

void OND_EnterOTP(u32 uBlkAddr)
{
	u16 nDFS = 0;
	u16 nDBS = 0;
	u16 x;

	if(pONDC.m_uIsDDP)
	{
		if(uBlkAddr>((pONDC.m_uNumOfBlocks)/2))
		{
			nDBS |= 1<<15;
			nDFS |= 1<<15;

		}
	}
	ondOutp16( OND_START_ADDR2, nDBS );		// DBS(Device BufferRAM Select)
//	ondOutp16( OND_START_ADDR1, nDFS|(pONDC.m_uBlockBitMask&uBlkAddr) );
	ondOutp16( OND_START_ADDR1, nDFS|(uBlkAddr) );
	ondOutp16( OND_REG_INT_STATUS, 0 );
	ondOutp16( OND_COMMAND, OND_OTP_ACS );
	
	x  = ondInp16( OND_REG_INT_STATUS);
	while ( !((x>>15)&0x1) ) // wait until INT=1
		x = ondInp16( OND_REG_INT_STATUS);
}

// [Set PI Access Command]
void OND_EnterPI(u32 uBlkAddr)
{
	u16 nDFS = 0;
	u16 nDBS = 0;
	u16 x;

	if(pONDC.m_uIsDDP)
	{
		if(uBlkAddr>((pONDC.m_uNumOfBlocks)/2))
		{
			nDBS |= 1<<15;
			nDFS |= 1<<15;

		}
	}

		
	ondOutp16( OND_START_ADDR2, nDBS );		// DBS(Device BufferRAM Select)
	ondOutp16( OND_START_ADDR1, nDFS|(uBlkAddr) );
	ondOutp16( OND_REG_INT_STATUS, 0 );
	ondOutp16( OND_COMMAND, FOND_PI_ACS );

	
	x = ondInp16( OND_REG_INT_STATUS);
	while ( !((x>>15)&0x1) ) // wait until INT=1
		x = ondInp16( OND_REG_INT_STATUS);
}



//JHHEO:2008/8/5 ==> OneNAND interface config functions
u32 OND_ConfigOndInf(void)
{
	u8	nReadMode;
	u8	nWriteMode;
	u8	nHF;
	u8	nBRWL;
	u8	nBL;
	u8	nReadPrefetch;
	//u32	nPrefetchSize;
	u32	nCnt;

	nReadMode	= 0;
	nWriteMode	= 0;
	
	nHF		= 1;

#ifdef FPGA
	nBRWL	= 3;
#else
	nBRWL	= 7;
#endif 

	nBL		= 0;
	nReadPrefetch = 1;
//	nPrefetchSize = 0x80;//0x100;

//	OND_ConfigOndInf_real(nReadMode, nBRWL, nBL, nHF, nWriteMode, nReadPrefetch, nPrefetchSize);
	OND_ConfigOndInf_real(nReadMode, nBRWL, nBL, nHF, nWriteMode, nReadPrefetch);
	
	return 1;
}

//u32 OND_ConfigOndInf_real(u8 nReadMode, u8 nBRWL, u8 nBL, u8 nHF, u8 nWriteMode, u8 nReadPrefetch, u32 nPrefetchSize)
u32 OND_ConfigOndInf_real(u8 nReadMode, u8 nBRWL, u8 nBL, u8 nHF, u8 nWriteMode, u8 nReadPrefetch)
{
	volatile u16 *rOndSysConf1Reg	= (u16 *)OND_SYS_CONFIG1;
	volatile u32 *rOndCtrlReg		= (u32 *)ONDC_CTRL_REG;
	u16	nRegVal		= 0;
	u32	nRegVal32	= 0;
	u32	nCnt;
	u32 uTemp;
	volatile u32	rOndIfStatus;

	switch(nReadMode)
	{
		case 0x0:	nRegVal &= (u16)OND_READ_ASYNC_MODE; break;
		case 0x1:	nRegVal |= (u16)OND_READ_SYNC_MODE;  break;
		default:	return 0;
	}

	switch(nBRWL)
	{
		case 0x3:	nRegVal |= (u16)OND_BRWL_3; break;
		case 0x4:	nRegVal |= (u16)OND_BRWL_4; break;
		case 0x5:	nRegVal |= (u16)OND_BRWL_5; break;
		case 0x6:	nRegVal |= (u16)OND_BRWL_6; break;
		case 0x7:	nRegVal |= (u16)OND_BRWL_7; break;
		default :	return 0;
	}

	switch(nBL)
	{
		case 0x000:	nRegVal |= (u16)OND_BL_CONT; break;
		case 0x004:	nRegVal |= (u16)OND_BL_4;    break;
		case 0x008:	nRegVal |= (u16)OND_BL_8;    break;
		case 0x010:	nRegVal |= (u16)OND_BL_16;   break;
		case 0x020:	nRegVal |= (u16)OND_BL_32;   break;
		case 0x400:	nRegVal |= (u16)OND_BL_1K;   break;
		default:	return 0;
	}

	switch(nHF)
	{
		case 0x0:	nRegVal &= (u16)OND_HF_OFF; break;
		case 0x1:	nRegVal |= (u16)OND_HF_ON;  break;
		default:	return 0;
	}

	switch(nWriteMode)
	{
		case 0x0:	nRegVal &= (u16)OND_WRITE_ASYNC_MODE; break;
		case 0x1:	nRegVal |= (u16)OND_WRITE_SYNC_MODE;  break;
		default:	return 0;
	}

	nRegVal32 = (u16)nRegVal;

	// ECC ON
	nRegVal &= OND_ECC_ON;
	// RDY, INT POL HIGH & IOBE ON
	nRegVal |= (OND_RDYPOL_HIGH | OND_INTPOL_HIGH | OND_IOBE_ON);
	// RDY CONF LOW
	nRegVal &= OND_RDYCONF_LOW;

	rOndIfStatus = ondInp32(ONDC_STATUS_REG);
    while(rOndIfStatus&0x1 ==1)
    {
		rOndIfStatus = ondInp32(ONDC_STATUS_REG);	// check ORWB bit 0:not busy 1:busy
	}
	
	


//// Complete OneNAND Register Setting 
	*rOndSysConf1Reg  = nRegVal;

	uTemp = ondInp16(OND_SYS_CONFIG1); //dummy read
	uTemp = ondInp16(OND_SYS_CONFIG1); //dummy read	 	
	
	switch (nReadPrefetch)
	{
		case 0x0:	nRegVal32 &= OND_RD_PREF_OFF; break;
		case 0x1:	nRegVal32 |= OND_RD_PREF_ON;  break;
		default:	return 0;
	}
	
	if(pONDC.m_MuxDemux==DEMUX)
		nRegVal32|=(0x1<<31);
	*rOndCtrlReg = nRegVal32;

	
	nCnt = 10000;
	while(nCnt--);	

	return 1;
}

void OND_WaitForDeviceCmdDone( OND_INT_STATUS eWhichInt )
{
// [Wait for Device Command done]
#define WAIT_CMD_DONE_COUNT 10000
   
	u32 i, x;

	OND_INT_STATUS	eOndInt = OND_INT;
	for ( i=0; i<WAIT_CMD_DONE_COUNT; i++ )
	{
		x = ondInp16( OND_REG_INT_STATUS);
		if ( ((x>>eOndInt)&0x1) ) // command done
		{
			if ( ((x>>eWhichInt)&0x1) ) // which command done ?
				break;
		}
	}
	if ( i == WAIT_CMD_DONE_COUNT )
	   Disp(" [NO INT]\n");
	
}

// [Is Device Command Completed]
u8 OND_IsDeviceCmdCompleted(void)
{
	u32 bIsOK;
	u32 x;
	x = ondInp16( OND_CTRL_STATUS );
	if ( (x>>10)&0x1 ) // Error
	{
		bIsOK = false;
		//bIsOK = true;
		Disp("X]\n");
	}
	else
	{
		bIsOK = true;
		onDbg(("O]"));
	}
	return bIsOK;
}

void OND_WaitForLoadDone(void )
{
// [Wait for Device Command done]
#define WAIT_CMD_DONE_COUNT 10000
   
	u32 i, x;

	for ( i=0; i<WAIT_CMD_DONE_COUNT; i++ )
	{
		x = ondInp16( OND_CTRL_STATUS);
		if ( ((x>>15)&0x1) ) // OnGo bit check
		{
			if ( ((x>>13)&0x1) ) // load done bit check
				break;
		}
	}
	if ( i == WAIT_CMD_DONE_COUNT )
	   onDbg((" [NO INT]\n"));
	
}


// [Enable ECC Correction]
void OND_SetEccMode(u8 bEccEnable)
{
	u16 uOndSysConfig1Data;

	uOndSysConfig1Data = ondInp16(OND_SYS_CONFIG1);

	if(bEccEnable)
	{
		uOndSysConfig1Data &= OND_ECC_ON;
	}else
	{
		uOndSysConfig1Data |= OND_ECC_OFF;
	}

	ondOutp16(OND_SYS_CONFIG1, uOndSysConfig1Data);

	onDbg((" OneNAND Sys config1=0x%x\n", uOndSysConfig1Data));

}
#endif
#ifndef READ_FUNC //There is no meaning..just INDEX of program
// [Read Pages]
u8 OND_ReadPages( u32 uDataAddr, u32 uBlockAddr, u32 uPageAddr, u32 uNumOfPages)
{
//	if ( eMode == OND_PIPELINE_READ )
//		WriteCmd(uBlockAddr, uPageAddr, (0x4000|(u8)uNumOfPages));
//	else if ( eMode == OND_2WAY_PIPELINE_READ )
//		WriteCmd(uBlockAddr, uPageAddr, (0x4300|(u8)uNumOfPages));
	u8 ret;
	u32 uTime;
    u32	uTransferMode;
	
	

	if(gAuto_test == 0) 
	{
		//    if (pONDC.m_bIsFlexDev== 0)
	    if (pONDC.m_uPageByteSize== 2048)
	    {
			Disp("0: OND_NOMAL   1: OND_CACHE_READ\n");
			uTransferMode = UART_GetIntNum();
			if(uTransferMode ==1)
				uTransferMode=OND_CACHE_READ;
		}
		else
		{
			Disp("0: OND_NOMAL   1: OND_SUPER_LOAD\n");
			uTransferMode = UART_GetIntNum();
			if(uTransferMode ==1)
				uTransferMode=OND_SUPER_LOAD;
		}
	}
	else
	{
		if (pONDC.m_uPageByteSize== 2048)
	    {
			Disp("0: OND_NOMAL   1: OND_CACHE_READ\n");
			uTransferMode = 0;
			if(uTransferMode ==1)
				uTransferMode=OND_CACHE_READ;
		}
		else
		{
			Disp("0: OND_NOMAL   1: OND_SUPER_LOAD\n");
			uTransferMode = 0;
			if(uTransferMode ==1)
				uTransferMode=OND_SUPER_LOAD;
		}
	}

	StartTimer(0);
	ret = OND_ReadMultiPages(uDataAddr, uBlockAddr, uPageAddr, uNumOfPages , uTransferMode);
	uTime = StopTimer(0);
	
	Disp("(%3.3fMB/s,%3.6fs)\n",((float)uNumOfPages*pONDC.m_uPageByteSize/uTime*1000000/1024/1024.),((float)uTime/1000000));
	
	return ret;
}




// [Normal Read Pages]
u8 OND_ReadMultiPages(u32 uDataAddr, u32 uBlockAddr, u32 uPageAddr, u32 uNumOfPages ,ONDC_TRANS_MODE eMode)
{
	u32 bIsOK;
	u32 uErrCnt=0;
	u32 i;

    switch (eMode)
   	{
		case OND_NORMAL  :
			if(pONDC.m_2xwrite==0)
			{
				for ( i=uPageAddr; i<(uNumOfPages+uPageAddr); i++ )
				{	
					bIsOK = OND_ReadOnePage( uDataAddr+(pONDC.m_uPageByteSize*(i-uPageAddr)), uBlockAddr, i );
					if ( !bIsOK ) uErrCnt++;
				}
			}
			else
			{
				for ( i=uPageAddr; i<(uNumOfPages+uPageAddr); i+=2 )
				{	
					bIsOK = OND_ReadOnePage( uDataAddr+(pONDC.m_uPageByteSize*(i-uPageAddr)), uBlockAddr, i );
					if ( !bIsOK ) uErrCnt++;
				}
				for ( i=uPageAddr; i<(uNumOfPages+uPageAddr); i+=2 )
				{	
					bIsOK = OND_ReadOnePage( uDataAddr+(pONDC.m_uPageByteSize*(i-uPageAddr+1)), uBlockAddr+1, i );
					if ( !bIsOK ) uErrCnt++;
				}

			}
			break;

		case OND_CACHE_READ	:
			
				bIsOK = OND_CacheReadPages( uDataAddr, uBlockAddr, uPageAddr , uNumOfPages);
				if ( !bIsOK ) uErrCnt++;
			
			break;

		case OND_SUPER_LOAD	:
			//for ( i=uPageAddr; i<(uNumOfPages+uPageAddr); i++ )
			//{	
				bIsOK = OND_SuperLoadPage( uDataAddr, uBlockAddr, uPageAddr,uNumOfPages );
			
				if ( !bIsOK ) uErrCnt++;
		//	}
			break;

	    default :
			if(pONDC.m_2xwrite==0)
			{
				for ( i=uPageAddr; i<(uNumOfPages+uPageAddr); i++ )
				{	
					bIsOK = OND_ReadOnePage( uDataAddr+(pONDC.m_uPageByteSize*(i-uPageAddr)), uBlockAddr, i );
					if ( !bIsOK ) uErrCnt++;
				}
			}
			else
			{
				for ( i=uPageAddr; i<(uNumOfPages+uPageAddr); i+=2 )
				{	
					bIsOK = OND_ReadOnePage( uDataAddr+(pONDC.m_uPageByteSize*(i-uPageAddr)), uBlockAddr, i );
					if ( !bIsOK ) uErrCnt++;
				}
				for ( i=uPageAddr; i<(uNumOfPages+uPageAddr); i+=2 )
				{	
					bIsOK = OND_ReadOnePage( uDataAddr+(pONDC.m_uPageByteSize*(i-uPageAddr+1)), uBlockAddr+1, i );
					if ( !bIsOK ) uErrCnt++;
				}

			}
			break;

	}
		
	
	
	if (uErrCnt==0)
		return true;
	else
		return false;
}

// [Normal Read One Page]
u8 OND_ReadOnePage(u32 uDataAddr, u32 uBlockAddr, u32 uPageAddr )
{
	u32 bIsOK = true;
	u16 nDFS = 0,nDBS=0, nSysConfig1;
	u16 nEccStatus1, nEccStatus2, nEccStatus3, nEccStatus4;
	u32 uAddr;
	u32 *uData;
	u32 i;
	u32 uStatus=0;
	u32 uDMAIntPend;
	
	
	if(pONDC.m_uIsDDP)
	{
		if(uBlockAddr>((pONDC.m_uNumOfBlocks)/2))
		{
			nDBS |= 1<<15;
			nDFS |= 1<<15;
		}
	}

	if( nSysConfig1 & OND_ECC_OFF )//IF ECC OFF, 
	{
		nSysConfig1 &= OND_ECC_ON;
		ondOutp16( OND_SYS_CONFIG1, nSysConfig1 );
	}
	
	ondOutp16( OND_START_ADDR2, nDBS);								// DBS(Device BufferRAM Select)
	ondOutp16( OND_START_ADDR1, nDFS|uBlockAddr) ;                 // DFS(Device Flash Core Select)
	ondOutp16( OND_START_ADDR8, uPageAddr<<2|0 );
	ondOutp16( OND_START_BUF, 0x0800 );
	ondOutp16( OND_REG_INT_STATUS, 0 );
	ondOutp16( OND_COMMAND, OND_LD_MS_TO_BUF );
	OND_WaitForDeviceCmdDone( OND_RI );
	onDbg(("[LD.C-"));
	bIsOK = OND_IsDeviceCmdCompleted();
	//if(bIsOK == false)
	//	return false;
	nSysConfig1 = ondInp16( OND_SYS_CONFIG1 );
	
	if(pONDC.m_bIsFlexDev)
	{
		nEccStatus1  = ondInp16( FOND_ECC_STATUS1);		
		nEccStatus2 = ondInp16( FOND_ECC_STATUS2 );		
		nEccStatus3 = ondInp16( FOND_ECC_STATUS3 );		
		nEccStatus4 = ondInp16( FOND_ECC_STATUS4 );		
		if( nEccStatus1 | nEccStatus2 | nEccStatus3 | nEccStatus4 )
		{
			Disp("ReadOnePage : ECC Error\n");
			Disp("ECC Status Register 1 : 0x%04x\n", nEccStatus1);
			Disp("ECC Status Register 2 : 0x%04x\n", nEccStatus2);
			Disp("ECC Status Register 3 : 0x%04x\n", nEccStatus3);
			Disp("ECC Status Register 4 : 0x%04x\n", nEccStatus4);
			return false;
		}
	}	
	
    

	if(pONDC.m_bUseDMA ==1)
	{
		uAddr = OND_BUFFER_RAM_ADDR +pONDC.m_uBootBufByteSize;  // data ram position = one base + boot buf size 
		//	OND_ReadDataram8W(0, uAddr, uDataAddr, pONDC.m_uDataBufByteSize);
		
		OND_Dma_Setting(uAddr    ,pONDC.m_uDmaBurstLength,DMA_SRC_INC_ADDR_MODE,pONDC.m_uDmaDataWidth,
			            uDataAddr,pONDC.m_uDmaBurstLength,DMA_DST_INC_ADDR_MODE,pONDC.m_uDmaDataWidth,
			            pONDC.m_uPageByteSize,DMA_OUT2IN);	
		//OND_Dma_Setting(uAddr    ,DMA_SBL_SINGLE,DMA_SRC_INC_ADDR_MODE,DMA_SDW_16,
		//	            uDataAddr,DMA_DBL_SINGLE,DMA_DST_INC_ADDR_MODE,DMA_SDW_16,
		//	            0x40,DMA_OUT2IN);	
	    
		OND_Dma_Go();
		if(pONDC.m_bUseINT==1)
		{
			while(pONDC.m_bDMA_INT_Occur!=1);
			pONDC.m_bDMA_INT_Occur=0;
		}
		else
		{
			while(uStatus != 1)
			{
				uStatus = ondInp32(ONDC_DMA_TRANS_STATUS);
				uStatus = uStatus>>18;
			}
			ondOutp32(ONDC_DMA_TRANS_CMD,(0x1<<18));
			ondOutp32(ONDC_INTC_DMA_CLR,uDMAIntPend);

		}
	}
	else
	{
		uAddr = pONDC.m_uBootBufByteSize;	// data ram position = one base + boot buf size 
		//	OND_ReadDataram8W(0, uAddr, uDataAddr, pONDC.m_uDataBufByteSize);
		(u32)uData = uDataAddr;

		#ifndef MEMCPY
			for (i=0;i<(pONDC.m_uPageByteSize)/4;i++)
			{
				OND_ReadDataram(0, uAddr, uData);
				uAddr+=4;
				uData++;
			//	UART_Printf("uAddr= %x \n ",uAddr);
			}
			//UART_Printf("uAddr= %x \n ",uAddr);
		#else if
			uAddr = OND_BUFFER_RAM_ADDR + pONDC.m_uBootBufByteSize ;
			memcpy((void *)uDataAddr,(void *)uAddr, pONDC.m_uPageByteSize);
		#endif

	}
	return bIsOK;
}

// [cache read Page]
u8 OND_CacheReadPages(u32 uDataAddr, u32 uBlockAddr, u32 uPageAddr , u32 uNumOfPages )
{
	u32 bIsOK = true;
	u16 nDFS = 0,nDBS=0, nSysConfig1;
	u16 nEccStatus1, nEccStatus2, nEccStatus3, nEccStatus4;
	u32 uAddr;
	u32 *uData;
	u32 i;
	u32 uStatus=0;
	u32 uDMAIntPend;
	
	ondOutp16( OND_START_ADDR3, uBlockAddr);
	ondOutp16( OND_START_ADDR4, (uPageAddr)<<2|0);
	ondOutp16( OND_START_BUF, 0x0800 );

	uPageAddr+=1;
	
	if(pONDC.m_uIsDDP)
	{
		if(uBlockAddr>((pONDC.m_uNumOfBlocks)/2))
		{
			nDBS |= 1<<15;
			nDFS |= 1<<15;
		}
	}

	ondOutp16( OND_START_ADDR2, nDBS);								// DBS(Device BufferRAM Select)
	ondOutp16( OND_START_ADDR1, nDFS|uBlockAddr) ;                 // DFS(Device Flash Core Select)
	ondOutp16( OND_START_ADDR8, uPageAddr<<2|0 );
	
	ondOutp16( OND_REG_INT_STATUS, 0 );
	ondOutp16( OND_COMMAND, OND_START_CACHE_READ );

	OND_WaitForLoadDone();

	uPageAddr+=1;
    for ( i=uPageAddr; i<(uNumOfPages+uPageAddr-2); i++ )
    {
		ondOutp16( OND_START_ADDR1, nDFS|uBlockAddr) ;                 // DFS(Device Flash Core Select)
		ondOutp16( OND_START_ADDR8, i<<2|0 );

		OND_WaitForDeviceCmdDone( OND_INT );

		bIsOK = OND_IsDeviceCmdCompleted();
		if(bIsOK == false)
			return false;
		
		ondOutp16( OND_REG_INT_STATUS, 0 );
		ondOutp16( OND_COMMAND, OND_START_CACHE_READ );

		if(pONDC.m_bUseDMA ==1)
		{
			if(((i-uPageAddr)&0x1)==0)
				uAddr = OND_BUFFER_RAM_ADDR +pONDC.m_uBootBufByteSize;  // data ram position = one base + boot buf size 
			else 
				uAddr = OND_DATA10_RAM_ADDR; 					
			//	OND_ReadDataram8W(0, uAddr, uDataAddr, pONDC.m_uDataBufByteSize);

			
			(u32)uData = uDataAddr+(pONDC.m_uPageByteSize*(i-uPageAddr));
			//Disp("uDataAddr= %x  i=%x\n",uData,i);

			OND_Dma_Setting(uAddr    ,pONDC.m_uDmaBurstLength,DMA_SRC_INC_ADDR_MODE,pONDC.m_uDmaDataWidth,
				            (u32)uData,pONDC.m_uDmaBurstLength,DMA_DST_INC_ADDR_MODE,pONDC.m_uDmaDataWidth,
				            pONDC.m_uPageByteSize,DMA_OUT2IN);	
            OND_Dma_Go();
			if(pONDC.m_bUseINT==1)
			{
				while(pONDC.m_bDMA_INT_Occur!=1);
				pONDC.m_bDMA_INT_Occur=0;
			}
			else
			{
				while(uStatus != 1)
				{
					uStatus = ondInp32(ONDC_DMA_TRANS_STATUS);
					uStatus = uStatus>>18;
				}
				ondOutp32(ONDC_DMA_TRANS_CMD,(0x1<<18));
				ondOutp32(ONDC_INTC_DMA_CLR,uDMAIntPend);

			}
		}
		else
		{
			uAddr = pONDC.m_uBootBufByteSize;	// data ram position = one base + boot buf size 
			//	OND_ReadDataram8W(0, uAddr, uDataAddr, pONDC.m_uDataBufByteSize);
			(u32)uData = uDataAddr+pONDC.m_uPageByteSize;
            uDataAddr = uDataAddr+pONDC.m_uPageByteSize;
			#ifndef MEMCPY
				for (i=0;i<(pONDC.m_uPageByteSize)/4;i++)
				{
					OND_ReadDataram(0, uAddr, uData);
					uAddr+=4;
					uData++;
				//	UART_Printf("uAddr= %x \n ",uAddr);
				}
				//UART_Printf("uAddr= %x \n ",uAddr);
			#else if
				uAddr = OND_BUFFER_RAM_ADDR + pONDC.m_uBootBufByteSize ;
				memcpy((void *)uDataAddr,(void *)uAddr, pONDC.m_uPageByteSize);
			#endif

		}
	
	}

	OND_WaitForDeviceCmdDone( OND_INT );
	bIsOK = OND_IsDeviceCmdCompleted();
		if(bIsOK == false)
			return false;
    ondOutp16( OND_REG_INT_STATUS, 0 );
    ondOutp16( OND_COMMAND, OND_FINISH_CACHE_READ );

	(u32)uData += pONDC.m_uPageByteSize;
    //i++;
	
    if(pONDC.m_bUseDMA ==1)
	{
		if(((i-uPageAddr)&0x1)==0)
			uAddr = OND_BUFFER_RAM_ADDR +pONDC.m_uBootBufByteSize;  // data ram position = one base + boot buf size 
		else 
			uAddr = OND_DATA10_RAM_ADDR; 					
			//	OND_ReadDataram8W(0, uAddr, uDataAddr, pONDC.m_uDataBufByteSize);

		
		OND_Dma_Setting(uAddr    ,pONDC.m_uDmaBurstLength,DMA_SRC_INC_ADDR_MODE,pONDC.m_uDmaDataWidth,
				            (u32)uData,pONDC.m_uDmaBurstLength,DMA_DST_INC_ADDR_MODE,pONDC.m_uDmaDataWidth,
				            pONDC.m_uPageByteSize,DMA_OUT2IN);	
	    
		OND_Dma_Go();
		if(pONDC.m_bUseINT==1)
		{
			while(pONDC.m_bDMA_INT_Occur!=1);
			pONDC.m_bDMA_INT_Occur=0;
		}
		else
		{
			while(uStatus != 1)
			{
				uStatus = ondInp32(ONDC_DMA_TRANS_STATUS);
				uStatus = uStatus>>18;
			}
			ondOutp32(ONDC_DMA_TRANS_CMD,(0x1<<18));
			ondOutp32(ONDC_INTC_DMA_CLR,uDMAIntPend);

		}
	}
	else
	{
		uAddr = pONDC.m_uBootBufByteSize;	// data ram position = one base + boot buf size 
		//	OND_ReadDataram8W(0, uAddr, uDataAddr, pONDC.m_uDataBufByteSize);
		(u32)uData = uDataAddr;

		#ifndef MEMCPY
			for (i=0;i<(pONDC.m_uPageByteSize)/4;i++)
			{
				OND_ReadDataram(0, uAddr, uData);
				uAddr+=4;
				uData++;
			//	UART_Printf("uAddr= %x \n ",uAddr);
			}
			//UART_Printf("uAddr= %x \n ",uAddr);
		#else if
			uAddr = OND_BUFFER_RAM_ADDR + pONDC.m_uBootBufByteSize ;
			memcpy((void *)uDataAddr,(void *)uAddr, pONDC.m_uPageByteSize);
		#endif

	}
	
    OND_WaitForDeviceCmdDone( OND_INT );

	onDbg(("[LD.C-"));
	bIsOK = OND_IsDeviceCmdCompleted();
	if(bIsOK == false)
		return false;

	(u32)uData += pONDC.m_uPageByteSize;
	i++;
	if(pONDC.m_bUseDMA ==1)
	{
		if(((i-uPageAddr)&0x1)==0)
			uAddr = OND_BUFFER_RAM_ADDR +pONDC.m_uBootBufByteSize;  // data ram position = one base + boot buf size 
		else 
			uAddr = OND_DATA10_RAM_ADDR; 					
			//	OND_ReadDataram8W(0, uAddr, uDataAddr, pONDC.m_uDataBufByteSize);

		
		OND_Dma_Setting(uAddr    ,pONDC.m_uDmaBurstLength,DMA_SRC_INC_ADDR_MODE,pONDC.m_uDmaDataWidth,
				            (u32)uData,pONDC.m_uDmaBurstLength,DMA_DST_INC_ADDR_MODE,pONDC.m_uDmaDataWidth,
				            pONDC.m_uPageByteSize,DMA_OUT2IN);	
	    
		OND_Dma_Go();
		if(pONDC.m_bUseINT==1)
		{
			while(pONDC.m_bDMA_INT_Occur!=1);
			pONDC.m_bDMA_INT_Occur=0;
		}
		else
		{
			while(uStatus != 1)
			{
				uStatus = ondInp32(ONDC_DMA_TRANS_STATUS);
				uStatus = uStatus>>18;
			}
			ondOutp32(ONDC_DMA_TRANS_CMD,(0x1<<18));
			ondOutp32(ONDC_INTC_DMA_CLR,uDMAIntPend);

		}
	}
	else
	{
		uAddr = pONDC.m_uBootBufByteSize;	// data ram position = one base + boot buf size 
		//	OND_ReadDataram8W(0, uAddr, uDataAddr, pONDC.m_uDataBufByteSize);
		(u32)uData = uDataAddr;

		#ifndef MEMCPY
			for (i=0;i<(pONDC.m_uPageByteSize)/4;i++)
			{
				OND_ReadDataram(0, uAddr, uData);
				uAddr+=4;
				uData++;
			//	UART_Printf("uAddr= %x \n ",uAddr);
			}
			//UART_Printf("uAddr= %x \n ",uAddr);
		#else if
			uAddr = OND_BUFFER_RAM_ADDR + pONDC.m_uBootBufByteSize ;
			memcpy((void *)uDataAddr,(void *)uAddr, pONDC.m_uPageByteSize);
		#endif

	}
	return bIsOK;
}

u8 OND_SuperLoadPage(u32 uDataAddr, u32 uBlockAddr, u32 uPageAddr , u32 uNumOfPages )
{
	u32 bIsOK = true;
	u16 nDFS = 0,nDBS=0, nSysConfig1;
	u16 nEccStatus1, nEccStatus2, nEccStatus3, nEccStatus4;
	u32 uAddr;
	u32 *uData;
	u32 i;
	u32 uStatus=0;
	u32 uDMAIntPend;
	u16 temp;

	//Disp("Sync burst mode be setting.. !!\n");
	//OND_SetSyncMode(OND_SYNC_BURST_CONT,1);
	
	if(pONDC.m_uIsDDP)
	{
		if(uBlockAddr>((pONDC.m_uNumOfBlocks)/2))
		{
			nDBS |= 1<<15;
			nDFS |= 1<<15;
		}
	}

	ondOutp16( OND_START_ADDR2, nDBS);								// DBS(Device BufferRAM Select)
	ondOutp16( OND_START_ADDR1, nDFS|uBlockAddr) ;                 // DFS(Device Flash Core Select)
	ondOutp16( OND_START_ADDR8, uPageAddr<<2|0 );
	ondOutp16(OND_START_BUF, 0x800 );

	nSysConfig1 = ondInp16( OND_SYS_CONFIG1 );
	if( nSysConfig1 & OND_ECC_OFF )//IF ECC OFF, 
	{
		nSysConfig1 &= OND_ECC_ON;
		ondOutp16( OND_SYS_CONFIG1, nSysConfig1 );
	}

	//ondOutp16( OND_REG_INT_STATUS, 0 );
	ondOutp16( OND_COMMAND, OND_LD_MS_TO_BUF );

	OND_WaitForDeviceCmdDone( OND_INT );

	nEccStatus1 = ondInp16( FOND_ECC_STATUS1);		
	nEccStatus2 = ondInp16( FOND_ECC_STATUS2 );		
	nEccStatus3 = ondInp16( FOND_ECC_STATUS3 );		
	nEccStatus4 = ondInp16( FOND_ECC_STATUS4 );		
	if( nEccStatus1 | nEccStatus2 | nEccStatus3 | nEccStatus4 )
	{
		Disp("ReadOnePage : ECC Error\n");
		Disp("ECC Status Register 1 : 0x%04x\n", nEccStatus1);
		Disp("ECC Status Register 2 : 0x%04x\n", nEccStatus2);
		Disp("ECC Status Register 3 : 0x%04x\n", nEccStatus3);
		Disp("ECC Status Register 4 : 0x%04x\n", nEccStatus4);
		return false;
	}

   
    uPageAddr +=1;
	for ( i=uPageAddr; i<(uNumOfPages+uPageAddr); i++ )
    {
	
	//	ondOutp16( OND_START_ADDR2, nDBS);								// DBS(Device BufferRAM Select)
		ondOutp16( OND_START_ADDR1, nDFS|uBlockAddr) ;                 // DFS(Device Flash Core Select)
		ondOutp16( OND_START_ADDR8, i<<2|0 );
		//ondOutp16(OND_START_BUF, 0x800 );
		ondOutp16( OND_REG_INT_STATUS, 0 );
		
	    ondOutp16( OND_COMMAND, FOND_SPLD_MS_TO_BUF );
		
		if(pONDC.m_bUseDMA ==1)
		{
			//if(((i-uPageAddr)&0x1)==0)
				uAddr = OND_BUFFER_RAM_ADDR +pONDC.m_uBootBufByteSize;  // data ram position = one base + boot buf size 
			//else 
			//	uAddr = OND_DATA10_RAM_ADDR; 					
			//	OND_ReadDataram8W(0, uAddr, uDataAddr, pONDC.m_uDataBufByteSize);

			
			(u32)uData = uDataAddr+(pONDC.m_uPageByteSize*(i-uPageAddr));
			//Disp("uDataAddr= %x  i=%x\n",uData,i);

			OND_Dma_Setting(uAddr    ,pONDC.m_uDmaBurstLength,DMA_SRC_INC_ADDR_MODE,pONDC.m_uDmaDataWidth,
				            (u32)uData,pONDC.m_uDmaBurstLength,DMA_DST_INC_ADDR_MODE,pONDC.m_uDmaDataWidth,
				            pONDC.m_uPageByteSize,DMA_OUT2IN);	
	        OND_Dma_Go();
			if(pONDC.m_bUseINT==1)
			{
				while(pONDC.m_bDMA_INT_Occur!=1);
				pONDC.m_bDMA_INT_Occur=0;
			}
			else
			{
				while(uStatus != 1)
				{
					uStatus = ondInp32(ONDC_DMA_TRANS_STATUS);
					uStatus = uStatus>>18;
				}
				ondOutp32(ONDC_DMA_TRANS_CMD,(0x1<<18));
				ondOutp32(ONDC_INTC_DMA_CLR,uDMAIntPend);

			}
		}
		else
		{
			uAddr = pONDC.m_uBootBufByteSize;	// data ram position = one base + boot buf size 
			//	OND_ReadDataram8W(0, uAddr, uDataAddr, pONDC.m_uDataBufByteSize);
			(u32)uData = uDataAddr+pONDC.m_uPageByteSize;
	        uDataAddr = uDataAddr+pONDC.m_uPageByteSize;
			#ifndef MEMCPY
				for (i=0;i<(pONDC.m_uPageByteSize)/4;i++)
				{
					OND_ReadDataram(0, uAddr, uData);
					uAddr+=4;
					uData++;
				//	UART_Printf("uAddr= %x \n ",uAddr);
				}
				//UART_Printf("uAddr= %x \n ",uAddr);
			#else if
				uAddr = OND_BUFFER_RAM_ADDR + pONDC.m_uBootBufByteSize ;
				memcpy((void *)uDataAddr,(void *)uAddr, pONDC.m_uPageByteSize);
			#endif

		}
	
		temp = Inp16(0xb001009e);
		
		OND_WaitForDeviceCmdDone( OND_INT );

		
		
		nEccStatus1 = ondInp16( FOND_ECC_STATUS1);		
		nEccStatus2 = ondInp16( FOND_ECC_STATUS2 );		
		nEccStatus3 = ondInp16( FOND_ECC_STATUS3 );		
		nEccStatus4 = ondInp16( FOND_ECC_STATUS4 );	
		if( nEccStatus1 | nEccStatus2 | nEccStatus3 | nEccStatus4 )
		{
			Disp("ReadOnePage : ECC Error\n");
			Disp("ECC Status Register 1 : 0x%04x\n", nEccStatus1);
			Disp("ECC Status Register 2 : 0x%04x\n", nEccStatus2);
			Disp("ECC Status Register 3 : 0x%04x\n", nEccStatus3);
			Disp("ECC Status Register 4 : 0x%04x\n", nEccStatus4);
			return false;
		}
		
		
	}
	
    if(pONDC.m_bUseDMA ==1)
	{
		//if(((i-uPageAddr)&0x1)==0)
			uAddr = OND_BUFFER_RAM_ADDR +pONDC.m_uBootBufByteSize;  // data ram position = one base + boot buf size 
		//else 
		//	uAddr = OND_DATA10_RAM_ADDR; 					
			//	OND_ReadDataram8W(0, uAddr, uDataAddr, pONDC.m_uDataBufByteSize);

		(u32)uData = uDataAddr+(pONDC.m_uPageByteSize*uNumOfPages);
		OND_Dma_Setting(uAddr    ,pONDC.m_uDmaBurstLength,DMA_SRC_INC_ADDR_MODE,pONDC.m_uDmaDataWidth,
				            (u32)uData,pONDC.m_uDmaBurstLength,DMA_DST_INC_ADDR_MODE,pONDC.m_uDmaDataWidth,
				            pONDC.m_uPageByteSize,DMA_OUT2IN);	
	    
		OND_Dma_Go();
		if(pONDC.m_bUseINT==1)
		{
			while(pONDC.m_bDMA_INT_Occur!=1);
			pONDC.m_bDMA_INT_Occur=0;
		}
		else
		{
			while(uStatus != 1)
			{
				uStatus = ondInp32(ONDC_DMA_TRANS_STATUS);
				uStatus = uStatus>>18;
			}
			ondOutp32(ONDC_DMA_TRANS_CMD,(0x1<<18));
			ondOutp32(ONDC_INTC_DMA_CLR,uDMAIntPend);

		}
	}
	else
	{
		uAddr = pONDC.m_uBootBufByteSize;	// data ram position = one base + boot buf size 
		//	OND_ReadDataram8W(0, uAddr, uDataAddr, pONDC.m_uDataBufByteSize);
		(u32)uData = uDataAddr;

		#ifndef MEMCPY
			for (i=0;i<(pONDC.m_uPageByteSize)/4;i++)
			{
				OND_ReadDataram(0, uAddr, uData);
				uAddr+=4;
				uData++;
			//	UART_Printf("uAddr= %x \n ",uAddr);
			}
			//UART_Printf("uAddr= %x \n ",uAddr);
		#else if
			uAddr = OND_BUFFER_RAM_ADDR + pONDC.m_uBootBufByteSize ;
			memcpy((void *)uDataAddr,(void *)uAddr, pONDC.m_uPageByteSize);
		#endif

	}
	
	return bIsOK;
}




// [Read Data Ram]
void OND_ReadDataram(u32 uChipSel, u32 Addr, u32 *Data)
{
	//int i;
	//for(i=0;i<uCnt ; i++)
		*Data = ondInp32(OND_BUFFER_RAM_ADDR+ (uChipSel<<17) + ((0x1fffe & Addr)<<0));
}

// [Read Data Ram 8Word]
void OND_ReadDataram8W(u32 uChipSel, u32 uSrcAddr, u32 uDstAddr, u32 uCnt)
{
	
	//	void Move8w(u32 uSrcAddr, u32 uDstAddr, u32 uCnt);
//	Move8w(OND_BUFFER_RAM_ADDR + (uChipSel<<17) + ((0x1fffe & uSrcAddr)<<0), uDstAddr, uCnt);
}

// [Read Flash]
//void OND_ReadFlash(u32 uBlockAddr, u8 uPageAddr, u32& uData)
//{
//	ReadFlash(0, uBlockAddr, uPageAddr, uData);
//}

// [Read flash]
//void OND_ReadFlash(u32 uChipSel, u32 uBlockAddr, u8 uPageAddr, u32& uData)
//{
//	Assert(uChipSel < 2);
//	ondInp32(OND_ARRAY_BASE + ((uChipSel&0x1)<<pONDC.m_uChipSelBitOffset)
//		+ ((pONDC.m_uBlockBitMask & uBlockAddr)<<pONDC.m_uBlockBitOffset)
//		+ ((pONDC.m_uPageBitMask & uPageAddr)<<pONDC.m_uPageBitOffset), uData);
//}

// erase, lock, unlock, lock-tight, copy back, OTP access, spare area access,
// verify read, pipeline read, pipeline write and read/modify/write

// [Write command]
//void OND_WriteCmd(u32 uBlockAddr, u32 uData)
//{
//	WriteCmd(0, uBlockAddr, 0, uData);
//}

// [Write commnad]
//void OND_WriteCmd(u32 uBlockAddr, u32 uPageAddr, u32 uData)
//{
//	WriteCmd(0, uBlockAddr, uPageAddr, uData);
//}

// [write command]
//void OND_WriteCmd(u32 uChipSel, u32 uBlockAddr, u32 uPageAddr, u32 uData)
//{
//	Assert(uChipSel < 2);
//	ondOutp32(OND_CMD_BASE + ((uChipSel&0x1)<<pONDC.m_uChipSelBitOffset)
//		+ ((pONDC.m_uBlockBitMask & uBlockAddr)<<pONDC.m_uBlockBitOffset)
//		+ ((pONDC.m_uPageBitMask & uPageAddr)<<pONDC.m_uPageBitOffset), uData);
//}

// [read command]
//void OND_ReadCmd(u32 uBlockAddr, u32& uData)
//{
//	ReadCmd(0, uBlockAddr, 0,  uData);
//}

// [read command]
//void OND_ReadCmd(u32 uBlockAddr, u32 uPageAddr, u32& uData)
//{
//	ReadCmd(0, uBlockAddr, uPageAddr,   uData);
//}

// [read command]
//void OND_ReadCmd(u32 uChipSel, u32 uBlockAddr, u32 uPageAddr, u32& uData)
//{
//	Assert(uChipSel < 2);
//	ondInp32(OND_CMD_BASE + ((uChipSel&0x1)<<pONDC.m_uChipSelBitOffset)
//		+ ((pONDC.m_uBlockBitMask & uBlockAddr)<<pONDC.m_uBlockBitOffset)
//		+ ((pONDC.m_uPageBitMask & uPageAddr)<<pONDC.m_uPageBitOffset), uData);
//}



// [Read Buffer Ram]
void OND_ReadBufferRam(OND_BUF_RAM eBufRam, u32 uOffset, u32 * uData)
{
	u32 uChipSel = 0;
	u32 uAddr;

	if (eBufRam == OND_BOOT_RAM)
	{
		uAddr = 0 + uOffset;
		OND_ReadDataram(uChipSel, uAddr, uData);
	}
	else if (eBufRam == OND_DATARAM0)
	{
		uAddr = pONDC.m_uBootBufByteSize + uOffset;
		OND_ReadDataram(uChipSel, uAddr, uData);
	}
	else if (eBufRam == OND_DATARAM1)
	{
		uAddr = pONDC.m_uBootBufByteSize + pONDC.m_uDataBufByteSize + uOffset;
		OND_ReadDataram(uChipSel, uAddr, uData);
	}
	else if (eBufRam == OND_RMW_BUF)
	{
		uAddr = uOffset;
		OND_ReadDataram(uChipSel, uAddr, uData);
	}
	else
	{
		Assert(0);
	}
}


// [Load OTP Area]
void OND_ReadOTPArea(u32 uStartPageAddr, u32 uNumOfPages, u32 uDataAddr)
{
	const	u32 uBlockAddr = 0;
	u32	nBufPos = 0, nPage;

	OND_EnterOTP(uBlockAddr);

	OND_ReadMultiPages(uDataAddr, uBlockAddr, uStartPageAddr, uNumOfPages,0);
/*
	for( nPage=uStartPageAddr; nPage<(uStartPageAddr+uNumOfPages); nPage++)
	{
		ReadM

		ondOutp16( OND_START_ADDR7, nPage<<2 );
		ondOutp16( OND_START_BUF, 0x0800 );

		ondOutp16( OND_REG_INT_STATUS, 0 );
		ondOutp16( OND_COMMAND, OND_LD_MS_TO_BUF );

		WaitForDeviceCmdDone( OND_INT );

		u32 uAddr = pONDC.m_uBootBufByteSize;
		ReadDataram8W(0, uAddr, uDataAddr+nBufPos, pONDC.m_uDataBufByteSize);

		nBufPos += pONDC.m_uDataBufByteSize;
	}
*/
	OND_ResetDevice(OND_CORE_RESET);
}


#endif
#ifndef WRITE_FUNC //There is no meaning..just INDEX of program
u8 OND_ProgramPages( u32 uDataAddr, u32 uBlockAddr, u32 uPageAddr, u32 uNumOfPages)
{
	u32 uTransferMode;
	u32 uTime;
	u8 ret;

	if(gAuto_test == 0) 
	{
	//    if (pONDC.m_bIsFlexDev== 0)
		if (pONDC.m_uPageByteSize== 2048)
	    {
			Disp(" 0: OND_NORMAL   1: OND_CACHE_2X_WRITE    2: OND_2X_WRITE \n ");
			uTransferMode = UART_GetIntNum();
			
	    }
		else
		{
			Disp(" 0: OND_NORMAL   1: OND_CACHE_WRITE    \n ");
			uTransferMode = UART_GetIntNum();

			if(uTransferMode==1)
				uTransferMode = OND_CACHE_WRITE;
		}
	}
	else
	{
		if (pONDC.m_uPageByteSize== 2048)
	    {
			Disp(" 0: OND_NORMAL   1: OND_CACHE_2X_WRITE    2: OND_2X_WRITE \n ");
			uTransferMode = 0;
	    }
		else
		{
			Disp(" 0: OND_NORMAL   1: OND_CACHE_WRITE    \n ");
			uTransferMode = 0;
			if(uTransferMode==1)
				uTransferMode = OND_CACHE_WRITE;
		}
	}	


	StartTimer(0);

	ret = OND_ProgramMultiPages(uDataAddr, uBlockAddr, uPageAddr, uNumOfPages ,uTransferMode ); 
	uTime = StopTimer(0);
	Disp("(%3.3fMB/s,%3.6fs)\n",((float)uNumOfPages*pONDC.m_uPageByteSize/uTime*1000000/1024/1024.),((float)uTime/1000000));

		
	return ret;
}


u8 OND_ProgramMultiPages( u32 uDataAddr, u32 uBlockAddr, u32 uPageAddr, u32 uNumOfPages,ONDC_TRANS_MODE eMode )
{
	u32 bIsOK;
	u32 uErrCnt=0;
	u32 i,j=0;

	if (pONDC.m_uPageByteSize== 2048)
    {
		switch(eMode)
		{
			case OND_NORMAL:
				for (i=uPageAddr; i<(uPageAddr+uNumOfPages); i++ )
				{
					bIsOK = OND_ProgramOnePage( uDataAddr+(pONDC.m_uPageByteSize*(i-uPageAddr)), uBlockAddr, i ,eMode);
					if ( !bIsOK ) uErrCnt++;
				}
				break;
		
			case OND_CACHE_2X_WRITE:
				bIsOK = OND_EraseBlocks( uBlockAddr+1,1 );
				if ( bIsOK == false )
					Disp( " Fail to erase\n");
				else
					Disp( " O.K. Erase\n");
				if ( !bIsOK ) uErrCnt++;
				
				pONDC.m_2xwrite =1;
				for (i=uPageAddr; i<(uPageAddr+uNumOfPages-2); i+=2 )
				{
					bIsOK = OND_ProgramPage_2xCacheWrite( uDataAddr+(pONDC.m_uPageByteSize*(i-uPageAddr)), uBlockAddr, i ,eMode);
					if ( !bIsOK ) uErrCnt++;
				}
				
				bIsOK = OND_ProgramPage_2xWrite( uDataAddr+(pONDC.m_uPageByteSize*(i-uPageAddr)), uBlockAddr, i ,eMode);
				if ( !bIsOK ) uErrCnt++;
				
				break;
			case OND_2X_WRITE:
				bIsOK = OND_EraseBlocks( uBlockAddr+1,1 );
				if ( bIsOK == false )
					Disp( " Fail to erase\n");
				else
					Disp( " O.K. Erase\n");
				if ( !bIsOK ) uErrCnt++;
				
				for (i=uPageAddr; i<(uPageAddr+uNumOfPages); i+=2 )
				{
					pONDC.m_2xwrite =1;
					bIsOK = OND_ProgramPage_2xWrite( uDataAddr+(pONDC.m_uPageByteSize*(i-uPageAddr)), uBlockAddr, i ,eMode);
					if ( !bIsOK ) uErrCnt++;
				}
				break;
			default:
				for (i=uPageAddr; i<(uPageAddr+uNumOfPages); i++ )
				{
					bIsOK = OND_ProgramOnePage( uDataAddr+(pONDC.m_uPageByteSize*(i-uPageAddr)), uBlockAddr, i ,eMode);
					if ( !bIsOK ) uErrCnt++;
				}
				break;
		}
	}
	else
	{
		switch(eMode)
		{
			case OND_NORMAL:
				for (i=uPageAddr; i<(uPageAddr+uNumOfPages); i++ )
				{
					bIsOK = OND_ProgramOnePage( uDataAddr+(pONDC.m_uPageByteSize*(i-uPageAddr)), uBlockAddr, i ,eMode);
					if ( !bIsOK ) uErrCnt++;
				}
				break;
		
			case OND_CACHE_WRITE:
				//bIsOK = OND_EraseBlocks( uBlockAddr+1,1 );
				//if ( bIsOK == false )
				//	Disp( " Fail to erase\n");
				//else
				//	Disp( " O.K. Erase\n");
				//if ( !bIsOK ) uErrCnt++;
				
				for (i=uPageAddr; i<(uPageAddr+uNumOfPages); i++)
				{
					//pONDC.m_2xwrite =1;
					if(i==uPageAddr+uNumOfPages)		
						pONDC.m_LastCacheWrite=1;
					bIsOK = OND_ProgramPage_CacheWrite( uDataAddr+(pONDC.m_uPageByteSize*(i-uPageAddr)), uBlockAddr, i ,eMode);
					if ( !bIsOK ) uErrCnt++;
				}
				if ( !bIsOK ) uErrCnt++;
				
				break;
			default:
				for (i=uPageAddr; i<(uPageAddr+uNumOfPages); i++ )
				{
					bIsOK = OND_ProgramOnePage( uDataAddr+(pONDC.m_uPageByteSize*(i-uPageAddr)), uBlockAddr, i ,eMode);
					if ( !bIsOK ) uErrCnt++;
				}
				break;
		}
	}

	if (uErrCnt==0)
		return true;
	else
		return false;
					
    
  	
}

u8 OND_ProgramPage_2xWrite( u32 uDataAddr, u32 uBlockAddr, u32 uPageAddr ,ONDC_TRANS_MODE eMode)
{
	u32 bIsOK = true;
	u32	nData;
	u16 nSysConfig1, nWritePrtection;
	u16 nDFS = 0;
	u16 nDBS = 0;
	u32 i;
	u32 uAddr; 
	u32 uTime[3];
	u32 uStatus =0 ;
	u32 uDMAIntPend;
	
	//StartTimer(0);

	if(pONDC.m_uIsDDP)
	{
		if(uBlockAddr>((pONDC.m_uNumOfBlocks)/2))
		{
			nDBS |= 1<<15;
			nDFS |= 1<<15;

		}
	}
	ondOutp16( OND_START_ADDR2, nDBS );		// DBS(Device BufferRAM Select)
	

    //StartTimer(0);
	if(pONDC.m_bUseDMA==1) // use audi's own DMA 
    {
		uAddr = OND_BUFFER_RAM_ADDR +pONDC.m_uBootBufByteSize;  
		
		
		OND_Dma_Setting(uDataAddr,pONDC.m_uDmaBurstLength,DMA_SRC_INC_ADDR_MODE,pONDC.m_uDmaDataWidth,
			            uAddr    ,pONDC.m_uDmaBurstLength,DMA_DST_INC_ADDR_MODE,pONDC.m_uDmaDataWidth,
			            pONDC.m_uPageByteSize,DMA_IN2OUT);	
	
		OND_Dma_Go();



		if(pONDC.m_bUseINT==1)
		{
			while(pONDC.m_bDMA_INT_Occur!=1);
			pONDC.m_bDMA_INT_Occur=0;
		}
		else
		{
			while(uStatus !=1)
			{
				uStatus = ondInp32(ONDC_DMA_TRANS_STATUS);
				uStatus = uStatus>>18;
			}
			ondOutp32(ONDC_DMA_TRANS_CMD,(0x1<<18));
			ondOutp32(ONDC_INTC_DMA_CLR,uDMAIntPend);
		}

		uAddr = OND_DATA10_RAM_ADDR;  
		
		
		OND_Dma_Setting(uDataAddr+pONDC.m_uPageByteSize,pONDC.m_uDmaBurstLength,DMA_SRC_INC_ADDR_MODE,pONDC.m_uDmaDataWidth,
			            uAddr    ,pONDC.m_uDmaBurstLength,DMA_DST_INC_ADDR_MODE,pONDC.m_uDmaDataWidth,
			            pONDC.m_uPageByteSize,DMA_IN2OUT);	
	
		OND_Dma_Go();



		if(pONDC.m_bUseINT==1)
		{
			while(pONDC.m_bDMA_INT_Occur!=1);
			pONDC.m_bDMA_INT_Occur=0;
		}
		else
		{
			while(uStatus !=1)
			{
				uStatus = ondInp32(ONDC_DMA_TRANS_STATUS);
				uStatus = uStatus>>18;
			}
			ondOutp32(ONDC_DMA_TRANS_CMD,(0x1<<18));
			ondOutp32(ONDC_INTC_DMA_CLR,uDMAIntPend);
		}
		
	}
	else
	{
		#ifndef MEMCPY
			for ( i=0; i<pONDC.m_uPageByteSize; i+=4)
			{
				uAddr = pONDC.m_uBootBufByteSize + i;
				nData  = Inp32( uDataAddr);
				OND_WriteIntoDataram(0, uAddr, nData);
				uDataAddr += 4;
			}
		#else if
			uAddr = OND_BUFFER_RAM_ADDR + pONDC.m_uBootBufByteSize ;
			//nData  = Inp32( uDataAddr);
			Disp("pONDC.m_uPageByteSize = %d\n",pONDC.m_uPageByteSize);
			memcpy((void *)uAddr,(void *)uDataAddr, pONDC.m_uPageByteSize);
			uAddr = OND_DATA10_RAM_ADDR  ;
			//nData  = Inp32( uDataAddr);
			memcpy((void *)uAddr,(void *)(uDataAddr+pONDC.m_uPageByteSize), pONDC.m_uPageByteSize);
		#endif
	}
    //uTime[1] = 	StopTimer(0);

	//StartTimer(0);

//	ondOutp16( OND_START_ADDR1, nDFS|(pONDC.m_uBlockBitMask&uBlockAddr) ); // DFS(Device Flash Core Select)
	ondOutp16( OND_START_ADDR1, nDFS|(uBlockAddr) ); // DFS(Device Flash Core Select)
	nWritePrtection  = ondInp16( OND_WPROT_STATUS);
	if( nWritePrtection & LOCKED_STATUS )
	{
		Disp("OND_ProgramOnePage: This block is locked.\n");
		return false;
	}
	else if( nWritePrtection & LOCKED_TIGHT_STATUS )
	{
		Disp("OND_ProgramOnePage: This block is locked-tight.\n");
		return false;
	}
	
	ondOutp16( OND_START_ADDR8, uPageAddr<<2|0 ); // if 2x write FSA must be '0'
	ondOutp16( OND_START_BUF, 0x0800 ); // if 2x write FSA must be '0'
	
	nSysConfig1 = ondInp16( OND_SYS_CONFIG1 );
	if( nSysConfig1 & OND_ECC_OFF )//IF ECC OFF, 
	{
		nSysConfig1 &= OND_ECC_ON;
		ondOutp16( OND_SYS_CONFIG1, nSysConfig1 );
	}
	ondOutp16( OND_REG_INT_STATUS, 0 );
	
	ondOutp16( OND_COMMAND, OND_2X_PRG );
	
	
	
	OND_WaitForDeviceCmdDone( OND_WI );
	onDbg(("[PG.C-"));
	bIsOK = OND_IsDeviceCmdCompleted();
    //uTime[2] = 	StopTimer(0);

	//Disp("(uTime[0] = %3.3fs) (uTime[1] = %3.3fs) (uTime[2] = %3.3fs)\n",((float)uTime[0]/1000000),((float)uTime[1]/1000000),((float)uTime[2]/1000000));
	
	return bIsOK;
}


u8 OND_ProgramPage_2xCacheWrite( u32 uDataAddr, u32 uBlockAddr, u32 uPageAddr ,ONDC_TRANS_MODE eMode)
{
	u32 bIsOK = true;
	u32	nData;
	u16 nSysConfig1, nWritePrtection;
	u16 nDFS = 0;
	u16 nDBS = 0;
	u32 i;
	u32 uAddr; 
	u32 uTime[3];
	u32 uStatus =0 ;
	u32 uDMAIntPend;
	
	//StartTimer(0);

	if(pONDC.m_uIsDDP)
	{
		if(uBlockAddr>((pONDC.m_uNumOfBlocks)/2))
		{
			nDBS |= 1<<15;
			nDFS |= 1<<15;

		}
	}
	ondOutp16( OND_START_ADDR2, nDBS );		// DBS(Device BufferRAM Select)
	

    //StartTimer(0);
	if(pONDC.m_bUseDMA==1) // use audi's own DMA 
    {
		uAddr = OND_BUFFER_RAM_ADDR +pONDC.m_uBootBufByteSize;  
		
		
		OND_Dma_Setting(uDataAddr,pONDC.m_uDmaBurstLength,DMA_SRC_INC_ADDR_MODE,pONDC.m_uDmaDataWidth,
			            uAddr    ,pONDC.m_uDmaBurstLength,DMA_DST_INC_ADDR_MODE,pONDC.m_uDmaDataWidth,
			            pONDC.m_uPageByteSize,DMA_IN2OUT);	
	
		OND_Dma_Go();



		if(pONDC.m_bUseINT==1)
		{
			while(pONDC.m_bDMA_INT_Occur!=1);
			pONDC.m_bDMA_INT_Occur=0;
		}
		else
		{
			while(uStatus !=1)
			{
				uStatus = ondInp32(ONDC_DMA_TRANS_STATUS);
				uStatus = uStatus>>18;
			}
			ondOutp32(ONDC_DMA_TRANS_CMD,(0x1<<18));
			ondOutp32(ONDC_INTC_DMA_CLR,uDMAIntPend);
		}

		uAddr = OND_DATA10_RAM_ADDR;  
		
		
		OND_Dma_Setting(uDataAddr+pONDC.m_uPageByteSize,pONDC.m_uDmaBurstLength,DMA_SRC_INC_ADDR_MODE,pONDC.m_uDmaDataWidth,
			            uAddr    ,pONDC.m_uDmaBurstLength,DMA_DST_INC_ADDR_MODE,pONDC.m_uDmaDataWidth,
			            pONDC.m_uPageByteSize,DMA_IN2OUT);	
	
		OND_Dma_Go();



		if(pONDC.m_bUseINT==1)
		{
			while(pONDC.m_bDMA_INT_Occur!=1);
			pONDC.m_bDMA_INT_Occur=0;
		}
		else
		{
			while(uStatus !=1)
			{
				uStatus = ondInp32(ONDC_DMA_TRANS_STATUS);
				uStatus = uStatus>>18;
			}
			ondOutp32(ONDC_DMA_TRANS_CMD,(0x1<<18));
			ondOutp32(ONDC_INTC_DMA_CLR,uDMAIntPend);
		}
		
	}
	else
	{
		#ifndef MEMCPY
			for ( i=0; i<pONDC.m_uPageByteSize; i+=4)
			{
				uAddr = pONDC.m_uBootBufByteSize + i;
				nData  = Inp32( uDataAddr);
				OND_WriteIntoDataram(0, uAddr, nData);
				uDataAddr += 4;
			}
		#else if
			uAddr = OND_BUFFER_RAM_ADDR + pONDC.m_uBootBufByteSize ;
			//nData  = Inp32( uDataAddr);
			Disp("pONDC.m_uPageByteSize = %d\n",pONDC.m_uPageByteSize);
			memcpy((void *)uAddr,(void *)uDataAddr, pONDC.m_uPageByteSize);
			uAddr = OND_DATA10_RAM_ADDR  ;
			//nData  = Inp32( uDataAddr);
			memcpy((void *)uAddr,(void *)(uDataAddr+pONDC.m_uPageByteSize), pONDC.m_uPageByteSize);
		#endif
	}
    //uTime[1] = 	StopTimer(0);

	//StartTimer(0);

//	ondOutp16( OND_START_ADDR1, nDFS|(pONDC.m_uBlockBitMask&uBlockAddr) ); // DFS(Device Flash Core Select)
	ondOutp16( OND_START_ADDR1, nDFS|(uBlockAddr) ); // DFS(Device Flash Core Select)

	ondOutp16( OND_START_ADDR8, uPageAddr<<2|0 ); // if 2x write FSA must be '0'
	ondOutp16( OND_START_BUF, 0x0800 ); // if 2x write FSA must be '0'
	
	ondOutp16( OND_REG_INT_STATUS, 0 );
    ondOutp16( OND_COMMAND, OND_2X_CACHE_PRG );
	OND_WaitForDeviceCmdDone( OND_WI );


    bIsOK = OND_IsDeviceCmdCompleted();
	
	return bIsOK;
}

u8 OND_ProgramPage_CacheWrite( u32 uDataAddr, u32 uBlockAddr, u32 uPageAddr ,ONDC_TRANS_MODE eMode)
{
	u32 bIsOK = true;
	u32	nData;
	u16 nSysConfig1, nWritePrtection;
	u16 nDFS = 0;
	u16 nDBS = 0;
	u32 i;
	u32 uAddr; 
	u32 uTime[3];
	u32 uStatus =0 ;
	u32 uDMAIntPend;
	
	//StartTimer(0);

	if(pONDC.m_uIsDDP)
	{
		if(uBlockAddr>((pONDC.m_uNumOfBlocks)/2))
		{
			nDBS |= 1<<15;
			nDFS |= 1<<15;

		}
	}
	ondOutp16( OND_START_ADDR2, nDBS );		// DBS(Device BufferRAM Select)
	

    //StartTimer(0);
	if(pONDC.m_bUseDMA==1) // use audi's own DMA 
    {
		uAddr = OND_BUFFER_RAM_ADDR +pONDC.m_uBootBufByteSize;  
		
		
		OND_Dma_Setting(uDataAddr,pONDC.m_uDmaBurstLength,DMA_SRC_INC_ADDR_MODE,pONDC.m_uDmaDataWidth,
			            uAddr    ,pONDC.m_uDmaBurstLength,DMA_DST_INC_ADDR_MODE,pONDC.m_uDmaDataWidth,
			            pONDC.m_uPageByteSize,DMA_IN2OUT);	
	
		OND_Dma_Go();



		if(pONDC.m_bUseINT==1)
		{
			while(pONDC.m_bDMA_INT_Occur!=1);
			pONDC.m_bDMA_INT_Occur=0;
		}
		else
		{
			while(uStatus !=1)
			{
				uStatus = ondInp32(ONDC_DMA_TRANS_STATUS);
				uStatus = uStatus>>18;
			}
			ondOutp32(ONDC_DMA_TRANS_CMD,(0x1<<18));
			ondOutp32(ONDC_INTC_DMA_CLR,uDMAIntPend);
		}

		uAddr = OND_DATA10_RAM_ADDR;  
		
		
		OND_Dma_Setting(uDataAddr+((pONDC.m_uPageByteSize)/2),pONDC.m_uDmaBurstLength,DMA_SRC_INC_ADDR_MODE,pONDC.m_uDmaDataWidth,
			            uAddr    ,pONDC.m_uDmaBurstLength,DMA_DST_INC_ADDR_MODE,pONDC.m_uDmaDataWidth,
			            pONDC.m_uPageByteSize,DMA_IN2OUT);	
	
		OND_Dma_Go();



		if(pONDC.m_bUseINT==1)
		{
			while(pONDC.m_bDMA_INT_Occur!=1);
			pONDC.m_bDMA_INT_Occur=0;
		}
		else
		{
			while(uStatus !=1)
			{
				uStatus = ondInp32(ONDC_DMA_TRANS_STATUS);
				uStatus = uStatus>>18;
			}
			ondOutp32(ONDC_DMA_TRANS_CMD,(0x1<<18));
			ondOutp32(ONDC_INTC_DMA_CLR,uDMAIntPend);
		}
		
	}
	else
	{
		#ifndef MEMCPY
			for ( i=0; i<pONDC.m_uPageByteSize; i+=4)
			{
				uAddr = pONDC.m_uBootBufByteSize + i;
				nData  = Inp32( uDataAddr);
				OND_WriteIntoDataram(0, uAddr, nData);
				uDataAddr += 4;
			}
		#else if
			uAddr = OND_BUFFER_RAM_ADDR + pONDC.m_uBootBufByteSize ;
			//nData  = Inp32( uDataAddr);
			Disp("pONDC.m_uPageByteSize = %d\n",pONDC.m_uPageByteSize);
			memcpy((void *)uAddr,(void *)uDataAddr, pONDC.m_uPageByteSize);
			uAddr = OND_DATA10_RAM_ADDR  ;
			//nData  = Inp32( uDataAddr);
			memcpy((void *)uAddr,(void *)(uDataAddr+pONDC.m_uPageByteSize), pONDC.m_uPageByteSize);
		#endif
	}
    //uTime[1] = 	StopTimer(0);

	//StartTimer(0);

//	ondOutp16( OND_START_ADDR1, nDFS|(pONDC.m_uBlockBitMask&uBlockAddr) ); // DFS(Device Flash Core Select)
	ondOutp16( OND_START_ADDR1, nDFS|(uBlockAddr) ); // DFS(Device Flash Core Select)

	nWritePrtection = ondInp16( OND_WPROT_STATUS );
	if( nWritePrtection & LOCKED_STATUS )
	{
		Disp("OND_ProgramOnePage: This block is locked.\n");
		return false;
	}
	else
	if( nWritePrtection & LOCKED_TIGHT_STATUS )
	{
		Disp("OND_ProgramOnePage: This block is locked-tight.\n");
		return false;
	}
		
	ondOutp16( OND_START_ADDR8, uPageAddr<<2|0 ); // if 2x write FSA must be '0'
	ondOutp16( OND_START_BUF, 0x0800 ); // if 2x write FSA must be '0'
	
	ondOutp16( OND_REG_INT_STATUS, 0 );
	if(pONDC.m_LastCacheWrite==0)
	    ondOutp16( OND_COMMAND, FOND_CACHE_PRG );
	else
	    ondOutp16( OND_COMMAND, FOND_CACHE_PRG_FINISH );
		
	OND_WaitForDeviceCmdDone( OND_WI );


    bIsOK = OND_IsDeviceCmdCompleted();
	
	return bIsOK;
}



// [Normal Program One page]
u8 OND_ProgramOnePage( u32 uDataAddr, u32 uBlockAddr, u32 uPageAddr ,ONDC_TRANS_MODE eMode)
{
	u32 bIsOK = true;
	u32	nData;
	u16 nSysConfig1, nWritePrtection;
	u16 nDFS = 0;
	u16 nDBS = 0;
	u32 i;
	u32 uAddr; 
	u32 uTime[3];
	u32 uStatus =0 ;
	u32 uDMAIntPend;
	
	//StartTimer(0);

	if(pONDC.m_uIsDDP)
	{
		if(uBlockAddr>((pONDC.m_uNumOfBlocks)/2))
		{
			nDBS |= 1<<15;
			nDFS |= 1<<15;

		}
	}
	ondOutp16( OND_START_ADDR2, nDBS );		// DBS(Device BufferRAM Select))
	//UART_Printf("OND_START_ADDR2= %x \n",nDFS);

	//UART_Printf("pONDC.m_bUseDMA= %x \n",pONDC.m_bUseDMA);
	//uTime[0] = 	StopTimer(0);


    //StartTimer(0);
	if(pONDC.m_bUseDMA==1) // use audi's own DMA 
    {
		uAddr = OND_BUFFER_RAM_ADDR +pONDC.m_uBootBufByteSize;  
		
		
		OND_Dma_Setting(uDataAddr,pONDC.m_uDmaBurstLength,DMA_SRC_INC_ADDR_MODE,pONDC.m_uDmaDataWidth,
			            uAddr    ,pONDC.m_uDmaBurstLength,DMA_DST_INC_ADDR_MODE,pONDC.m_uDmaDataWidth,
			            pONDC.m_uPageByteSize,DMA_IN2OUT);	
		//OND_Dma_Setting(uDataAddr,DMA_SBL_SINGLE,DMA_SRC_INC_ADDR_MODE,DMA_SDW_16,
		//	            uAddr    ,DMA_DBL_SINGLE,DMA_DST_INC_ADDR_MODE,DMA_SDW_16,
		//	            0x40,DMA_IN2OUT);	
	    

		OND_Dma_Go();
		if(pONDC.m_bUseINT==1)
		{
			while(pONDC.m_bDMA_INT_Occur!=1);
			pONDC.m_bDMA_INT_Occur=0;
		}
		else
		{
			while(uStatus !=1)
			{
				uStatus = ondInp32(ONDC_DMA_TRANS_STATUS);
				uStatus = uStatus>>18;
			}
			ondOutp32(ONDC_DMA_TRANS_CMD,(0x1<<18));
			ondOutp32(ONDC_INTC_DMA_CLR,uDMAIntPend);
		}
		
	}
	else
	{
		#ifndef MEMCPY
			for ( i=0; i<pONDC.m_uPageByteSize; i+=4)
			{
				uAddr = pONDC.m_uBootBufByteSize + i;
				nData  = Inp32( uDataAddr);
				OND_WriteIntoDataram(0, uAddr, nData);
				uDataAddr += 4;
			}
		#else if
			uAddr = OND_BUFFER_RAM_ADDR + pONDC.m_uBootBufByteSize ;
			nData  = Inp32( uDataAddr);
			memcpy((void *)uAddr,(void *)uDataAddr, pONDC.m_uPageByteSize);
		#endif
	}
    //uTime[1] = 	StopTimer(0);

	//StartTimer(0);

	ondOutp16( OND_START_ADDR1, nDFS|(uBlockAddr) ); // DFS(Device Flash Core Select)
	nWritePrtection  = ondInp16( OND_WPROT_STATUS);
	if( nWritePrtection & LOCKED_STATUS )
	{
		Disp("OND_ProgramOnePage: This block is locked.\n");
		return false;
	}
	else if( nWritePrtection & LOCKED_TIGHT_STATUS )
	{
		Disp("OND_ProgramOnePage: This block is locked-tight.\n");
		return false;
	}

	ondOutp16( OND_START_ADDR8, uPageAddr<<2|0 ); // if 2x write FSA must be '0'
	ondOutp16( OND_START_BUF, 0x0800 ); // if 2x write FSA must be '0'

	nSysConfig1 = ondInp16( OND_SYS_CONFIG1 );
	if( nSysConfig1 & OND_ECC_OFF )//IF ECC OFF, 
	{
		nSysConfig1 &= OND_ECC_ON;
		ondOutp16( OND_SYS_CONFIG1, nSysConfig1 );
	}
	
	ondOutp16( OND_REG_INT_STATUS, 0 );
	if(eMode == OND_NORMAL)
	{
			ondOutp16( OND_COMMAND, OND_PG_MS_FR_BUF );
	}
	else if(eMode == OND_2X_WRITE)
	{
			ondOutp16( OND_COMMAND, OND_2X_PRG );
	}
	

	OND_WaitForDeviceCmdDone( OND_WI );
	onDbg(("[PG.C-"));
	bIsOK = OND_IsDeviceCmdCompleted();
    //uTime[2] = 	StopTimer(0);

	//Disp("(uTime[0] = %3.3fs) (uTime[1] = %3.3fs) (uTime[2] = %3.3fs)\n",((float)uTime[0]/1000000),((float)uTime[1]/1000000),((float)uTime[2]/1000000));
	
	return bIsOK;
}


// [Write into Buffer Ram]
void OND_WriteIntoBufferRam(OND_BUF_RAM eBufRam, u32 uOffset, u32 uData)
{
	u32 uChipSel = 0;
	u32 uAddr;

	if (eBufRam == OND_BOOT_RAM)
	{
		uAddr = 0 + uOffset;
		OND_WriteIntoDataram(uChipSel, uAddr, uData);
	}
	else if (eBufRam == OND_DATARAM0)
	{
		uAddr = pONDC.m_uBootBufByteSize + uOffset;
		OND_WriteIntoDataram(uChipSel, uAddr, uData);
	}
	else if (eBufRam == OND_DATARAM1)
	{
		uAddr = pONDC.m_uBootBufByteSize + pONDC.m_uDataBufByteSize + uOffset;
		OND_WriteIntoDataram(uChipSel, uAddr, uData);
	}
	else if (eBufRam == OND_RMW_BUF)
	{
		uAddr = uOffset;
		OND_WriteIntoDataram(uChipSel, uAddr, uData);
	}
	else
	{
		Assert(0);
	}
}

// [Write into Data Ram]
void OND_WriteIntoDataram(u32 uChipSel, u32 Addr, u32 Data)
{
	ondOutp32(OND_BUFFER_RAM_ADDR + (uChipSel<<17) + ((0x1fffe & Addr)<<0), Data);
	
}


// [Clear Data Ram]
void OND_ClearDataBuf()
{
	u32 i;
	for (i=0; i<pONDC.m_uDataBufByteSize; i+=4)
	{
		u32 uAddr = pONDC.m_uBootBufByteSize + i;
		OND_WriteIntoDataram(0, uAddr, 0x0);
	}
}


// [Copy Back]
u8 OND_CopyBack(u32 uSrcBlkAddr, u32 uSrcPageAddr, u32 uDstBlkAddr, u32 uDstPageAddr, u32 uPageCount)
{
	u32	bIsOK = false;
	u32		nPageCnt = 0, nTotalPages = uPageCount;
	u16		nDfsForSrc = 0, nDfsForDst = 0;
	u16		nDbsForSrc = 0, nDbsForDst = 0;
	
	if ( pONDC.m_bIsFlexDev == true )
	{
		Disp("FlexOneNAND does not have Copy-back function.\n");
		return false;
	}

	if( uPageCount>64 )
		return false;

	if(pONDC.m_uIsDDP)
	{
		if(uSrcBlkAddr>((pONDC.m_uNumOfBlocks)/2))
		{
			nDbsForSrc |= 1<<15;
			nDfsForSrc |= 1<<15;
		}
		if(uSrcBlkAddr>((pONDC.m_uNumOfBlocks)/2))
		{
			nDbsForDst |= 1<<15;
			nDfsForDst |= 1<<15;
		}
		if(nDfsForSrc != nDfsForDst)
			return false;
	}

	for( nPageCnt=0; nPageCnt<nTotalPages; nPageCnt++)
	{
		ondOutp16( OND_START_ADDR2, nDbsForSrc );								// DBS(Device BufferRAM Select)
		ondOutp16( OND_START_ADDR1, nDfsForSrc|(uSrcBlkAddr) );	// DFS(Device Flash Core Select)
		ondOutp16( OND_START_ADDR8, (uSrcPageAddr+nPageCnt)<<2|0 );
		ondOutp16( OND_START_ADDR3, uDstBlkAddr );					// FCBA(Flash Copy-back Block Address)
		ondOutp16( OND_START_ADDR4, (uDstPageAddr+nPageCnt)<<2|0 );	// FCPA(Flash Copy-back Page Address)
		ondOutp16( OND_START_BUF, 0x0800 );
		ondOutp16( OND_REG_INT_STATUS, 0 );
		ondOutp16( OND_COMMAND, OND_CP_BACK_PRG );
		OND_WaitForDeviceCmdDone( OND_INT );
		bIsOK = OND_IsDeviceCmdCompleted();
		if ( bIsOK == false ) 
			return false;
	}

	return true;
}

// [Program OTP Area]
void OND_ProgramOTPArea(u32 uStartPageAddr, u32 uNumOfPages, u32 uDataAddr)
{
	const	u32 uBlockAddr = 0;
	u32 uPageAddr;
	u32 uWrittenPageCount;
	u16 uOtpCtrlStatus = 0x0040;
	u32 bIsOK = true;

	OND_EnterOTP(uBlockAddr);

	OND_ProgramMultiPages(uDataAddr, uBlockAddr, uStartPageAddr, uNumOfPages,OND_NORMAL);
/*
	for(uPageAddr=uStartPageAddr; uPageAddr<(uStartPageAddr+uNumOfPages); uPageAddr++)
	{

		ondOutp16( OND_START_ADDR1, uBlkAddr ); 
		ondOutp16( OND_START_ADDR7, uPageAddr<<2 );
		ondOutp16( OND_START_BUF, 0x0800 );
		ondOutp16( OND_REG_INT_STATUS, 0 );
		ondOutp16( OND_COMMAND, OND_PG_MS_FR_BUF );
		while( uOtpCtrlStatus & 0x0040 ) ondInp16( OND_CTRL_STATUS, uOtpCtrlStatus);
		WaitForDeviceCmdDone(OND_INT);
		bIsOK = IsDeviceCmdCompleted();
		
		if(!bIsOK)
		{
			Disp("Error : ProgramOTPArea (when %dpage is programed)\n", uPageAddr);
			while(1);
		}

	}
*/
	OND_ResetDevice(OND_CORE_RESET);

}
#endif

#ifndef DMA_FUNC //There is no meaning..just INDEX of program
void OND_Dma_Go(void)
{
	ondOutp32( ONDC_DMA_TRANS_CMD, 1<<0 );
}

void OND_Dma_Tranfer_Error_Clear(void)
{
	ondOutp32( ONDC_DMA_TRANS_CMD, 1<<16 );
}


void OND_Dma_Tranfer_Done_Clear(void)
{
	ondOutp32( ONDC_DMA_TRANS_CMD, 1<<18 );
}


void OND_Dma_Setting(u32 uSrcAddr,u32 uSrcBurstLength,u8 uScrAddrMode,u8 uSrcDataWidth,
	                 u32 uDstAddr,u32 uDstBurstLength,u8 uDstAddrMode,u8 uDstDataWidth, 
	                 u32 uTransSize,u8 uTransDir)
{
	ondOutp32( ONDC_DMA_SRC_ADDR,uSrcAddr  );
	ondOutp32( ONDC_DMA_SRC_CFG, (uSrcBurstLength<<16)|(uScrAddrMode<<8)|(uSrcDataWidth));
    ondOutp32( ONDC_DMA_DST_ADDR,uDstAddr  );
	ondOutp32( ONDC_DMA_DST_CFG, (uDstBurstLength<<16)|(uDstAddrMode<<8)|(uDstDataWidth));
	ondOutp32( ONDC_DMA_TRANS_SIZE, uTransSize  );
	ondOutp32( ONDC_DMA_TRANS_DIR, uTransDir  );

}
#endif
#ifndef SQC_FUNC  //There is no meaning..just INDEX of program

void OND_SQC_Init(void)
{

	OND_INT_SET_VEC_SQC();

	ondOutp32(ONDC_SQC_SAO,AUDI_CODE_START_ADDR);// Sequener Start address
    //*(volatile u32*)(ONDC_SQC_SAO)			= AUDI_CODE_START_ADDR;		// Sequener Start address
	//*(volatile u32*)(ONDC_SQC_EAO)			= AUDI_CODE_END_ADDR;		// Sequener End address
    ondOutp32(AUDI_CODE_END_ADDR,AUDI_PARAMS_BASE_ADDR);
	//*(volatile u32*)(AUDI_CODE_END_ADDR)	= AUDI_PARAMS_BASE_ADDR;
    ondOutp32(ONDC_CTRL_CMD_REG,OND_CH_INT_CLEAR);
	//*(volatile u32*)ONDC_CTRL_CMD_REG		= OND_CH_INT_CLEAR;

//#if defined(AUDI_DEBUG_MODE)
//	*(volatile u32*)(ONDC_SQC_CMD)			= 0x00080000;
//	*(volatile u32*)(ONDC_SQC_REG_CTRL)		= 0x00030000;
//#endif
}

// [Read Pages]
u8 OND_SQC_ReadPages( u32 uDataAddr, u32 uBlockAddr, u32 uPageAddr, u32 uNumOfPages)
{
	u32 bIsOK;
	u32 uErrCnt=0;
	u32 i;
	u16 nDFS = 0,nDBS=0, nSysConfig1;
	u32 uTime[3];

	StartTimer(0);
	gpstAudiHeaderOfPb	= (PAUDI_HEADER_OF_PB)g_pAudiPbAddr;
	gpstAudiParamsArray	= (PAUDI_PARAMS)(g_pAudiPbAddr+sizeof(AUDI_HEADER_OF_PB)/4);
		
	gpstAudiHeaderOfPb->nFuncCode		= FC_SCTR_READ;
	gpstAudiHeaderOfPb->nHostBufAddr	= uDataAddr;
	gpstAudiHeaderOfPb->nDevIdx			= 0;
	gpstAudiHeaderOfPb->nNumOfDescs		= uNumOfPages;

	nSysConfig1 = ondInp16( OND_SYS_CONFIG1 );
	if( nSysConfig1 & OND_ECC_OFF )//IF ECC OFF, 
	{
		nSysConfig1 &= OND_ECC_ON;
		ondOutp16( OND_SYS_CONFIG1, nSysConfig1 );
	}
	
	if(pONDC.m_uIsDDP)
		{
			if(uBlockAddr>((pONDC.m_uNumOfBlocks)/2))
			{
				nDBS |= 1<<15;
				nDFS |= 1<<15;

			}
		}
	ondOutp16( OND_START_ADDR2, nDFS );								// DBS(Device BufferRAM Select)
	
	for ( i=uPageAddr; i<(uNumOfPages+uPageAddr); i++ )
	{
	
		gpstAudiParamsArray[i-uPageAddr].nFBA		= (uBlockAddr);
		gpstAudiParamsArray[i-uPageAddr].nFPA_FSA	= (i<<2|0);
		if (pONDC.m_bIsFlexDev ==0)
//			gpstAudiParamsArray[i-uPageAddr].nSctCnt	= 4;
			gpstAudiParamsArray[i-uPageAddr].nSctCnt	= 8;
		else 
			gpstAudiParamsArray[i-uPageAddr].nSctCnt	= 8;
	}

	ondOutp32(ONDC_CTRL_CMD_REG,OND_CH_INT_CLEAR);
	//*(volatile u32*)(ONDC_CTRL_CMD_REG)	= OND_CH_INT_CLEAR;		
	ondOutp32(ONDC_SQC_CMD,(1 << AUDI_RUN_BIT));
	//*(volatile u32*)(ONDC_SQC_CMD)		= (1 << AUDI_RUN_BIT);

	OND_SQC_Wait();
	uTime[0] = StopTimer(0);

	Disp("(uTime[0] = %3.6fs) (uTime[1] = %3.6fs) \n",((float)uTime[0]/1000000),((float)uTime[1]/1000000));
	
	return true;
}

u8 OND_SQC_ProgramPages( u32 uDataAddr, u32 uBlockAddr, u32 uPageAddr, u32 uNumOfPages)
{
	u32 bIsOK;
	u16 nSysConfig1, nWritePrtection;
	u16 nDFS = 0;
	u16 nDBS = 0;
	u32 i;
	u32 uTime[3];
	
	StartTimer(0);

	gpstAudiHeaderOfPb	= (PAUDI_HEADER_OF_PB)g_pAudiPbAddr;
	gpstAudiParamsArray	= (PAUDI_PARAMS)(g_pAudiPbAddr+sizeof(AUDI_HEADER_OF_PB)/4);
		
	gpstAudiHeaderOfPb->nFuncCode		= FC_SCTR_WRITE;
	gpstAudiHeaderOfPb->nHostBufAddr	= uDataAddr;
	gpstAudiHeaderOfPb->nDevIdx			= 0;
	gpstAudiHeaderOfPb->nNumOfDescs		= uNumOfPages;
	
	nSysConfig1 = ondInp16( OND_SYS_CONFIG1 );
	if( nSysConfig1 & OND_ECC_OFF )//IF ECC OFF, 
	{
		nSysConfig1 &= OND_ECC_ON;
		ondOutp16( OND_SYS_CONFIG1, nSysConfig1 );
	}

	
	if(pONDC.m_uIsDDP)
	{
		if(uBlockAddr>((pONDC.m_uNumOfBlocks)/2))
		{
			nDBS |= 1<<15;
			nDFS |= 1<<15;
		}
	}
	ondOutp16( OND_START_ADDR2, nDFS ); // DBS(Device BufferRAM Select)
	
	for (i=uPageAddr; i<(uPageAddr+uNumOfPages); i++ )
	{
		gpstAudiParamsArray[i-uPageAddr].nFBA		= (uBlockAddr);
		gpstAudiParamsArray[i-uPageAddr].nFPA_FSA	= (i<<2|0);
		if (pONDC.m_bIsFlexDev ==0)
//			gpstAudiParamsArray[i-uPageAddr].nSctCnt	= 4;
		gpstAudiParamsArray[i-uPageAddr].nSctCnt	= 8;
		else 
			gpstAudiParamsArray[i-uPageAddr].nSctCnt	= 8;
	}

	ondOutp32(ONDC_CTRL_CMD_REG,OND_CH_INT_CLEAR);
	//*(volatile u32*)(ONDC_CTRL_CMD_REG)	= OND_CH_INT_CLEAR;		
	ondOutp32(ONDC_SQC_CMD,(1 << AUDI_RUN_BIT));
	//*(volatile u32*)(ONDC_SQC_CMD)		= (1 << AUDI_RUN_BIT);
	//uTime[0] = StopTimer(0);


	OND_SQC_Wait();
	uTime[0] = StopTimer(0);

	Disp("(uTime[0] = %3.6fs) (uTime[1] = %3.6fs) \n",((float)uTime[0]/1000000),((float)uTime[1]/1000000));
	
	return true;
}

int	OND_SQC_Wait(void)
{
	volatile u32 *rSQCStatus = (volatile u32*)(ONDC_SQC_STATUS);
	
	while(1)
	{
		if(pONDC.m_bSQC_INT_Occur ==1)
			break;
	}

	/*
	while(1)
	{
		if( *rSQCStatus & (1<<AUDI_ERR_BIT) )
		{
			Disp("  Sequencer error generate!! .........\n");
			ondOutp32(ONDC_SQC_CMD,(1 << AUDI_ERR_CLR_BIT));
			//*(volatile u32*)(ONDC_SQC_CMD) = (1 << AUDI_ERR_CLR_BIT);				// Sqc error clear Command
			while(1);
 			return 0;
		}else	
		if( *rSQCStatus & (1<<AUDI_DONE_BIT) )
		{
			ondOutp32(ONDC_SQC_CMD,(1 << AUDI_DONE_CLR_BIT));
			//*(volatile u32*)(ONDC_SQC_CMD) = (1 << AUDI_DONE_CLR_BIT);				// Sqc done clear Command
			break;
		}else
		{
			continue;
		}
	}
*/
	return 1;
}

#endif

#ifndef SPARE_FUNC //There is no meaning..just INDEX of program
// [Set OTP Access Command]



// [Enable Spare Area Transfer]
void OND_EnableSpareAreaTransfer(u8 bEnable)
{
// 0 = Transfers main area only or both main and spare areas, based on the Map 10 command type used.
// 1 = Increase transfer size. Always transfers main area and spare area.
//     The main data area for the page will be transferred first and then the spare area.

//	u32 uData = (bEnable == true) ? 1 : 0;
//	ondOutp32(TRANSFER_SPARE, uData);
}

// [Read Spare Area]
u8 OND_ReadSpareArea(u32 uBlkAddr, u8 uPageAddr, u32 *aSpare)
{
//	ondOutp32(INT_ERR_MASK, 1<<10|1<<7|1<<4); // unmask bit[10], bit[7], and bit[4] (1 means unmask)
//	u32 i;
//	for(i=0; i<pONDC.m_uSpareByteSize; i+=4)
//	{
//		ReadFlash(uBlkAddr, uPageAddr, *aSpare);
//		aSpare++;
//	}
//	WaitForIntStatus(ONDC_INTACT);
/// WaitForIntStatus(ONDC_BLKRWCMP);
/// WaitForIntStatus(ONDC_LOADCMP);
//	ClearPending(ONDC_INTACT);
/// ClearPending(ONDC_BLKRWCMP);
/// ClearPending(ONDC_LOADCMP);
//	return true;
	u32 bIsOK = true;
	u16 nDFS = 0;
	u16 nDBS = 0;
    u32 uAddr ;
    
	if(pONDC.m_uIsDDP)
	{
		if(uBlkAddr>((pONDC.m_uNumOfBlocks)/2))
		{
			nDBS |= 1<<15;
			nDFS |= 1<<15;

		}
	}
	ondOutp16( OND_START_ADDR2, nDBS );		// DBS(Device BufferRAM Select)
//	ondOutp16( OND_START_ADDR1, nDFS|(pONDC.m_uBlockBitMask&uBlkAddr) ); // DFS(Device Flash Core Select)
	ondOutp16( OND_START_ADDR1, nDFS|(uBlkAddr) ); // DFS(Device Flash Core Select)
	ondOutp16( OND_START_ADDR8, uPageAddr<<2|0 );
	ondOutp16( OND_START_BUF, 0x0800 );
	ondOutp16( OND_REG_INT_STATUS, 0 );
	ondOutp16( OND_COMMAND, OND_LD_MS_TO_BUF );
	OND_WaitForDeviceCmdDone( OND_RI );
	onDbg(("[LD.C-"));
	bIsOK = OND_IsDeviceCmdCompleted();

	if(bIsOK == false)
		return false;
	
	uAddr = pONDC.m_uBootBufByteSize + OND_SPARE00_RAM_ADDR;
	OND_ReadDataram8W(0, uAddr, (u32)aSpare, pONDC.m_uSpareByteSize);

	return bIsOK;
}

// [Write into Spare Area]
u8 OND_WriteIntoSpareArea(u32 uBlkAddr, u8 uPageAddr, u32 *aSpare)
{
//JHHEO:2008/8/6 ==> 
//	ondOutp32(INT_ERR_MASK, 1<<10|1<<7|1<<4); // unmask bit[10], bit[7], and bit[4] (1 means unmask)
//	u32 i;
//	for(i=0; i<pONDC.m_uSpareByteSize; i+=4)
//	{
//		WriteIntoFlash(uBlkAddr, uPageAddr, *aSpare);
//		aSpare++;
//	}
//	WaitForIntStatus(ONDC_INTACT);
/// WaitForIntStatus(ONDC_BLKRWCMP);
/// WaitForIntStatus(ONDC_LOADCMP);
//	ClearPending(ONDC_INTACT);
/// ClearPending(ONDC_BLKRWCMP);
/// ClearPending(ONDC_LOADCMP);
//	return true;
	u32 bIsOK = true;
	u32 x;
	u16 nDFS = 0;
	u16 nDBS = 0;
	u32 uDataAddr;
	u32 i;

	if(pONDC.m_uIsDDP)
	{
		if(uBlkAddr>((pONDC.m_uNumOfBlocks)/2))
		{
			nDBS |= 1<<15;
			nDFS |= 1<<15;

		}
	}
	ondOutp16( OND_START_ADDR2, nDBS );		// DBS(Device BufferRAM Select)
	uDataAddr = (u32)aSpare;
	for (i=0; i<pONDC.m_uSpareByteSize; i+=4)
	{
		u32 uAddr = pONDC.m_uBootBufByteSize + OND_SPARE00_RAM_ADDR + i;
		x = Inp32( uDataAddr );
		OND_WriteIntoDataram(0, uAddr, x);
		uDataAddr += 4;
	}	
//	ondOutp16( OND_START_ADDR1, nDFS|(pONDC.m_uBlockBitMask&uBlkAddr) ); // DFS(Device Flash Core Select)
	ondOutp16( OND_START_ADDR1, nDFS|(uBlkAddr) ); // DFS(Device Flash Core Select)
	ondOutp16( OND_START_ADDR8, uPageAddr<<2|0 );
	ondOutp16( OND_START_BUF, 0x0800 );
	ondOutp16( OND_REG_INT_STATUS, 0 );
	ondOutp16( OND_COMMAND, OND_PG_SS_FR_BUF );
	OND_WaitForDeviceCmdDone( OND_WI );
	onDbg(("[PG.C-"));
	bIsOK = OND_IsDeviceCmdCompleted();

	return bIsOK;
//JHHEO:2008/8/6 <== 
}

// [Set Spare Area Access]
void OND_SetSpareAreaAccessCmd(u32 uBlkAddr, u8 uPageAddr)
{
//JHHEO:2008/8/6 ==> 
//	ondOutp32(INT_ERR_MASK, 1<<10); // unmask bit[10] (1 means unmask)
//	WriteCmd(uBlkAddr, uPageAddr, 0x13); // Set up for spare area access only
//JHHEO:2008/8/6 <== 
	///WaitForIntStatus(ONDC_INTACT);
	///ClearPending(ONDC_INTACT);
}

// [Set Main Area Access]
void OND_SetMainAreaAccessCmd(u32 uBlkAddr, u8 uPageAddr)
{
//JHHEO:2008/8/6 ==> 
//	ondOutp32(INT_ERR_MASK, 1<<10); // unmask bit[10] (1 means unmask)
//	WriteCmd(uBlkAddr, uPageAddr, 0x14); // Set up for main area access only
//JHHEO:2008/8/6 <== 
	///WaitForIntStatus(ONDC_INTACT);
	///ClearPending(ONDC_INTACT);
}



// [Write Into Data Ram 8Word]
//void OND_WriteIntoDataram8W(u32 uChipSel, u32 uSrcAddr, u32 uDstAddr, u32 uCnt)
//{
	//	void Move8w(u32 uSrcAddr, u32 uDstAddr, u32 uCnt);
//	Move8w(uSrcAddr, OND_BUFFER_RAM_ADDR + (uChipSel<<17) + ((0x1fffe & uDstAddr)<<0), uCnt);
//}

// [Write into flash]
//void OND_WriteIntoFlash(u32 BlockAddr, u8 PageAddr, u32 Data)
//{
//	WriteIntoFlash(0, BlockAddr, PageAddr, Data);
//}

// [Write into flash]
//void OND_WriteIntoFlash(u32 uChipSel, u32 BlockAddr, u8 PageAddr, u32 Data)
//{
//	Assert(uChipSel < 2);
//	ondOutp32(OND_ARRAY_BASE + ((uChipSel&0x1)<<pONDC.m_uChipSelBitOffset)
//		+ ((pONDC.m_uBlockBitMask & BlockAddr)<<pONDC.m_uBlockBitOffset)
//		+ ((pONDC.m_uPageBitMask & PageAddr)<<pONDC.m_uPageBitOffset), Data);
//}


#endif
#ifndef ETC  //There is no meaning..just INDEX of program
void VectorTest(void)
{
	Outp32(0xb001e200, 0x00000000);

	Outp16(0xb001e442, 0x0000c4e2);  // device sync 8 burst setting
	Outp32(0xb0600100, 0x0002c402);  // audi   sync 8 burst setting 

	Outp16(0xb001e202, 0x00000001);  //erase
	Outp16(0xb001e200, 0x00000001);
	Outp16(0xb001e482, 0x00000000);
	Outp16(0xb001e440, 0x00000094);
	Outp16(0xb001e202, 0x00000000);
	Outp16(0xb001e482, 0x00000000);
	Outp16(0xb001e440, 0x00000071);

	Outp16(0xb001e202, 0x00000000);  //write
	Outp32(0xb0600400, 0x21010000);
	Outp32(0xb0600404, 0x00000002);
	Outp32(0xb0600408, 0xb0000400);
	Outp32(0xb060040c, 0x00000002);
	Outp32(0xb0600414, 0x00000800);
	Outp32(0xb0600420, 0x00000001);
	Outp32(0xb0600418, 0x00000001);
	Outp32(0xb0600418, 0x00040000);
	Outp32(0xb0601004, 0x71657320);
	Outp16(0xb001e200, 0x00000001);
	Outp16(0xb001e20e, 0x00000000);
	Outp16(0xb001e400, 0x00000800);
	Outp16(0xb001e482, 0x00000000);
	Outp16(0xb001e440, 0x00000080);
}

void InitForAutoTest(void)
{
	pONDC.m_bUseDMA =0; //use dma 
	pONDC.m_uDmaBurstLength=DMA_BL_16BURST; //
	pONDC.m_uDmaDataWidth=DMA_DW_32;
	pONDC.m_bUseINT =1; //use int
	gAuto_test =1;
	
}

void EndOfAutoTest(void)
{
	
	gAuto_test =0;
	
}

void ChangeBufferSize(u32 uPageSize)
{
	pONDC.m_uPageByteSize = uPageSize;
}

void SetUseDMA(u8 uUseDMA)
{
	pONDC.m_bUseDMA =uUseDMA;
}
				
void SetDmaBurstLength(u8 uDmaBurstLength)
{
	if(uDmaBurstLength>=1)
		uDmaBurstLength+=1;
	pONDC.m_uDmaBurstLength=uDmaBurstLength;
}

void SetDmaDataWidth(u8 uDmaDataWidth)
{
	pONDC.m_uDmaDataWidth=uDmaDataWidth;
}

void SetUseINT(u8 uUseINT)
{
	pONDC.m_bUseINT=uUseINT;
}
#endif


