/**************************************************************************************
* 
*	Project Name : S3C6400 Validation
*
*	Copyright 2006 by Samsung Electronics, Inc.
*	All rights reserved.
*
*	Project Description :
*		This software is only for validating functions of the S3C6400.
*		Anybody can use this software without our permission.
*  
*--------------------------------------------------------------------------------------
* 
*	File Name : Timer_test.c
*  
*	File Description : This file implements the API functons for Timer (PWM, WDT) test.
*
*	Author : Woojin.Kim
*	Dept. : AP Development Team
*	Created Date : 2006/12/27
*	Version : 0.1 
* 
*	History
*	- Created(Woojin.Kim 2006/12/27)
*     - Added more test function ( Prescaler,MUX234) (Woojin.Kim 2007/02/12)
*  
**************************************************************************************/


/* Include Files */

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include "def.h"
#include "option.h"
#include "library.h"
#include "v210_sfr.h"
#include "system.h"
#include "sysc.h"
#include "intc.h"
#include "gpio.h"
#include "BootCodeWrite.h "
#include "Sdhc.h"
#include "Audi_ondc.h"
#include "nand.h"
#include "am29f800.h"

#include "string.h"

static u8 bIsOndcTestAll;
static u8 bIsOKOndcTestAll;

#define 	OK		(1)
#define	FAIL	(0)

#define	READ_COMPARE	0

extern NANDINFO	sNandInfo;
extern SDHC SDHC_descriptor;

unsigned int SDHC_eMMC;

extern void SDHC_MoviBootloaderCopy(void) ;
extern void ChangeBufferSize(u32 uPageSize);
void SDHC_eMMCBootWrite(void);
void SDHC_eMMC8BootWrite(void);

const testFuncMenu g_aBootCodeWriteFunc[] =
{	
      	SDHC_BootWrite,			"SD/MMC boot code write",
	SDHC_eMMCBootWrite,	"eMMC 4bit boot code write",
	SDHC_eMMC8BootWrite, 	"eMMC 8bit boot code write",
	ONENAND_BootWrite,		"Audi OneNand boot code write",
	NAND_BootWrite,		"Nand boot code write",	
	ProgramAM29F800,		"Nor boot code write",
	0,0
};


void BOOTCODEWRITE(void)
{
	u32 uCountFunc=0;
	s32 iSel=0;

	Outp32(0xe02002ec,0xffff);
	Outp32(0xe020032c,0xffff);
	Outp32(0xe020038c,0xffff);
	Outp32(0xe02003ac,0xffff);

	Outp32(0xe02001ac,0x3fff);

	SDHC_descriptor.m_eChannel = SDHC_CHANNEL_0;
	//SDHC_descriptor.m_eClockSource = SDHC_EPLL;
	SDHC_descriptor.m_eClockSource = SDHC_HCLK;
	SDHC_descriptor.m_eOpMode = SDHC_SDMA_MODE;
	SDHC_descriptor.m_uStartBlockPos =0;// start Block address.
	SDHC_descriptor.m_ucBandwidth = 4;	// bandwidth.
	SDHC_descriptor.m_uClockDivision = 4;	// clock division
	SDHC_descriptor.m_uOneBlockSize = 2048;	// block size.

	while(1)
	{

	UART_Printf("\n\n================== Timer Function Test =====================\n\n");

	for (uCountFunc=0; (u32)(g_aBootCodeWriteFunc[uCountFunc].desc)!=0; uCountFunc++)
		UART_Printf("%2d: %s\n", uCountFunc, g_aBootCodeWriteFunc[uCountFunc].desc);

	UART_Printf("\nSelect the function to test : ");
	iSel =UART_GetIntNum();
	UART_Printf("\n");
	if(iSel == -1) 
		break;

	if(iSel==5) {
		GPIO_SetFunctionAll(eGPIO_J1,0x444444);
		GPIO_SetPullUpDownAll(eGPIO_J1, 0);
		GPIO_SetDSAll(eGPIO_J1,0xffff);
		
		GPIO_SetFunctionAll(eGPIO_J4,0x4<<16);
		GPIO_SetPullUpDownAll(eGPIO_J4, 0);
		GPIO_SetDSAll(eGPIO_J4,0xffff);
		
		Outp32(0xe8000000,1);
		Outp32(0xe8000004,0xfffffffc);
		
		UART_Printf("\n[ NOR Flash Memory Writer Ver 0.1 ]\n\n");
		UART_Printf("The program buffer : 0x41000000 ~ 0x41ff0000\n");	
		}
	
	if (iSel>=0 && iSel<(sizeof(g_aBootCodeWriteFunc)/8-1))
		(g_aBootCodeWriteFunc[iSel].func) ();
	}
}	




//////////
void SDHC_BootWrite(void) {
	SDHC* oSdhc;
	u32* tempPtr0;
	u32* tempPtr1;
	u32* tempPtr2;
	u32* tempPtr3;
	extern unsigned int SDHC_global_card_size;
	unsigned int *source_addr;
	//SDHC SDHC_descriptor;
/*
	tempPtr0 = SDHC_getBuffer_Boot(3, FALSE, TRUE);
	tempPtr1 = SDHC_getBuffer_Boot(2, FALSE, TRUE);
	tempPtr2 = SDHC_getBuffer_Boot(1, FALSE, TRUE);
	tempPtr3 = SDHC_getBuffer_Boot(0, FALSE, TRUE);
*/

	oSdhc = &SDHC_descriptor;

	SDHC_eMMC = FALSE;

	if ( !SDHC_OpenMediaWithMode(oSdhc->m_ucBandwidth, oSdhc->m_eOpMode, oSdhc->m_eClockSource,
								oSdhc->m_uClockDivision, oSdhc->m_eChannel, oSdhc)) {
		UART_Printf(" OpenMedia() failed !!!\n");
		return;
	}


	////// Test Code Or OS Code.
	//source_addr = (unsigned int*)CODEC_MEM_ST+0x200000+0x1000; // Size 2MB(4096 Block)
	source_addr = (unsigned int*)0x41004000; // Size 2MB(4096 Block)
	// write bootloader2
	if ( SDHC_WriteBlocks(SDHC_global_card_size-(600+26), 600, (u32)source_addr, oSdhc) == FALSE ) {
		UART_Printf( "mon writing fail\n");
	}
	else {
		UART_Printf( "mon writing success\n");
	}
#if READ_COMPARE
	// read bootloader2
	if ( SDHC_ReadBlocks(SDHC_global_card_size-(600+26), 600, (u32)tempPtr3, oSdhc ) == FALSE ) {
		UART_Printf( "mon reading fail\n");
	}
	else {
		UART_Printf( "mon reading success\n");
	}
	// compare bootloader2
	if ( memcmp( (void*)tempPtr3, source_addr, 512*0x8000 ) == 0 ) {
		UART_Printf( "mon compare success\n" );
	}
	else {
		UART_Printf( "mon Compare Error... \n ");
	}
#endif
	
	////// BL2
	//source_addr = (unsigned int*)CODEC_MEM_ST+0x1000; //BL1 size 4KB
	source_addr = (unsigned int*)0x41003000; //BL1 size 4KB
	// write bootloader2
	if ( SDHC_WriteBlocks(SDHC_global_card_size-(18+8), 8, (u32)source_addr, oSdhc) == FALSE ) {
		UART_Printf( "bootloader 2 writing fail\n");
	}
	else {
		UART_Printf( "bootloader 2 writing success\n");
	}

#if READ_COMPARE
	// read bootloader2
	if ( SDHC_ReadBlocks(SDHC_global_card_size-(18+8), 8, (u32)tempPtr2, oSdhc ) == FALSE ) {
		UART_Printf( "bootloader 2 reading fail\n");
	}
	else {
		UART_Printf( "bootloader 2 reading success\n");
	}
	// compare bootloader2
	if ( memcmp( tempPtr2, source_addr, 512*18 ) == 0 ) {
		UART_Printf( "compare success\n" );
	}
	else {
		UART_Printf( "Bootloader 2 Compare Error... \n ");
	}
#endif


	////// BL1
	//source_addr = (unsigned int*)0x20500000;
	//source_addr = (unsigned int*)CODEC_MEM_ST;
	source_addr = (unsigned int*)0x41000000 ; //BL1 size 4KB

	CheckSumData_Write(0x41000000 );

	// write bootloader1
	if ( SDHC_WriteBlocks(SDHC_global_card_size-18, 16, (u32)source_addr, oSdhc) == FALSE ) {
		UART_Printf( "bootloader 1 writing fail\n");
	}
	else {
		UART_Printf( "bootloader 1 writing success\n");
	}
#if READ_COMPARE
	// read bootloader2
	if ( SDHC_ReadBlocks(SDHC_global_card_size-18, 16, (u32)tempPtr1, oSdhc ) == FALSE ) {
		UART_Printf( "bootloader 1 reading fail\n");
	}
	else {
		UART_Printf( "bootloader 1 reading success\n");
	}
	// compare bootloader2
	if ( memcmp( tempPtr1, source_addr, 512*18 ) == 0 ) {
		UART_Printf( "compare success\n" );
	}
	else {
		UART_Printf( "Bootloader 1 Compare Error... \n ");
	}
#endif

	SDHC_ReadBlocks(SDHC_global_card_size-18, 16, (u32)0x42000000, oSdhc );

	// close media
	SDHC_CloseMedia(oSdhc);
}


//////////
void SDHC_eMMCBootWrite(void) {
	u32 uVendorCmd;

	SDHC* oSdhc;
	u32* tempPtr;
	extern unsigned int SDHC_global_card_size;
	unsigned int *source_addr;
/*
	// get 4MB.
	tempPtr = SDHC_getBuffer(3, FALSE, TRUE);
	tempPtr = SDHC_getBuffer(2, FALSE, TRUE);
	tempPtr = SDHC_getBuffer(1, FALSE, TRUE);
	tempPtr = SDHC_getBuffer(0, FALSE, TRUE);
*/
	oSdhc = &SDHC_descriptor;

	if ( !SDHC_OpenMediaWithMode(oSdhc->m_ucBandwidth, oSdhc->m_eOpMode, oSdhc->m_eClockSource,
								oSdhc->m_uClockDivision, oSdhc->m_eChannel, oSdhc)) {
		UART_Printf(" OpenMedia() failed !!!\n");
		return;
	}

	SDHC_IssueCommand(oSdhc, 62, 0xEFAC62EC, SDHC_CMD_AC_TYPE, SDHC_RES_R1_TYPE);  // Enter Backdoor Mode		
	
	SDHC_IssueCommand(oSdhc, 62, 0xCBAEA7, SDHC_CMD_AC_TYPE, SDHC_RES_R1_TYPE); // Boot Partition Changing Mode		

	UART_Printf("Input Vendor Command (0x80?) :");
	uVendorCmd=UART_GetIntNum();
	SDHC_IssueCommand(oSdhc, 62, uVendorCmd, SDHC_CMD_AC_TYPE, SDHC_RES_R1_TYPE); //ARG: Boot Partition Size		
	Delay(100);
	
//	SDHC_IssueCommand(oSdhc, 62, 0xaa, SDHC_CMD_AC_TYPE, SDHC_RES_R1_TYPE); //ARG: Boot Partition Size		

	// Boot ACK enable, Boot partition enable , Boot Partition Access.
	SDHC_IssueCommand(oSdhc, 6, ((3<<24)|(179<<16)|(0x49<<8)), SDHC_CMD_AC_TYPE, SDHC_RES_R1B_TYPE);
	Delay(100);

	// Bus width setting at booting time.
	SDHC_IssueCommand(oSdhc, 6, ((3<<24)|(177<<16)|(1<<8)), SDHC_CMD_AC_TYPE, SDHC_RES_R1B_TYPE);
	// [8] -> 1 (4bit)
	// [8] -> 2 (8bit)
	Delay(100);

	////// BL1
	//source_addr = (unsigned int*)0x20500000;
	source_addr = (unsigned int*)0x41000000;
	CheckSumData_Write(0x41000000 );

#if 0
	SDHC_IssueCommand(oSdhc, 62, 0x80, SDHC_CMD_AC_TYPE, SDHC_RES_R1_TYPE); //ARG: Boot Partition Size	
	
	if ( SDHC_WriteBlocks(0, 500, (u32)source_addr, oSdhc) == FALSE ) {
		UART_Printf( "BL 1,2, MON writing fail\n");
	}
	else {
		UART_Printf( "BL 1,2, MON writing success\n");
	}

	SDHC_WriteBlocks(0, 10, (u32)0x42000000, oSdhc);

#else
	// write bootloader1
	if ( SDHC_WriteBlocks(0, 16, (u32)source_addr, oSdhc) == FALSE ) {
		UART_Printf( "bootloader 1 loading fail\n");
	}
	else {
		UART_Printf( "bootloader 1 loading success\n");
	}

	// write bootloader2
	if ( SDHC_WriteBlocks(16, 8, (u32)0x41003000, oSdhc) == FALSE ) {
		UART_Printf( "bootloader 2 loading fail\n");
	}
	else {
		UART_Printf( "bootloader 2 loading success\n");
	}

	// write OS
	if ( SDHC_WriteBlocks(24, 400, (u32)0x41004000, oSdhc) == FALSE ) {
		UART_Printf( "OS loading fail\n");
	}
	else {
		UART_Printf( "OS loading success\n");
	}

//	SDHC_ReadBlocks(0, 16, (u32)0x42000000, oSdhc);
//	SDHC_ReadBlocks(16, 8, (u32)0x42100000, oSdhc);

#endif

	SDHC_IssueCommand(oSdhc, 6, ((3<<24)|(179<<16)|(0x48<<8)), SDHC_CMD_AC_TYPE, SDHC_RES_R1B_TYPE);
	// close media
	SDHC_CloseMedia(oSdhc);
}


//////////
void SDHC_eMMC8BootWrite(void) {
	SDHC* oSdhc;
	u32* tempPtr;
	extern unsigned int SDHC_global_card_size;
	unsigned int *source_addr;
/*
	// get 4MB.
	tempPtr = SDHC_getBuffer(3, FALSE, TRUE);
	tempPtr = SDHC_getBuffer(2, FALSE, TRUE);
	tempPtr = SDHC_getBuffer(1, FALSE, TRUE);
	tempPtr = SDHC_getBuffer(0, FALSE, TRUE);
*/
	oSdhc = &SDHC_descriptor;

//	SDHC_descriptor.m_ucBandwidth = 8;	// 8bit bandwidth.

	if ( !SDHC_OpenMediaWithMode(oSdhc->m_ucBandwidth, oSdhc->m_eOpMode, oSdhc->m_eClockSource,
								oSdhc->m_uClockDivision, oSdhc->m_eChannel, oSdhc)) {
		UART_Printf(" OpenMedia() failed !!!\n");
		return;
	}

	SDHC_IssueCommand(oSdhc, 62, 0xEFAC62EC, SDHC_CMD_AC_TYPE, SDHC_RES_R1_TYPE);  // Enter Backdoor Mode		
	
	SDHC_IssueCommand(oSdhc, 62, 0xCBAEA7, SDHC_CMD_AC_TYPE, SDHC_RES_R1_TYPE); // Boot Partition Changing Mode		
	
	SDHC_IssueCommand(oSdhc, 62, 0xaa, SDHC_CMD_AC_TYPE, SDHC_RES_R1_TYPE); //ARG: Boot Partition Size		
	Delay(100);

	// Boot ACK enable, Boot partition enable , Boot Partition Access.
	SDHC_IssueCommand(oSdhc, 6, ((3<<24)|(179<<16)|(0x49<<8)), SDHC_CMD_AC_TYPE, SDHC_RES_R1B_TYPE);
	Delay(100);

	// Bus width setting at booting time.
	SDHC_IssueCommand(oSdhc, 6, ((3<<24)|(177<<16)|(2<<8)), SDHC_CMD_AC_TYPE, SDHC_RES_R1B_TYPE);
	// [8] -> 1 (4bit)
	// [8] -> 2 (8bit)
	Delay(100);

	////// BL1
	//source_addr = (unsigned int*)0x20500000;
	source_addr = (unsigned int*)0x41000000;
	CheckSumData_Write(0x41000000 );

#if 0
	SDHC_IssueCommand(oSdhc, 62, 0x80, SDHC_CMD_AC_TYPE, SDHC_RES_R1_TYPE); //ARG: Boot Partition Size	
	
	if ( SDHC_WriteBlocks(0, 500, (u32)source_addr, oSdhc) == FALSE ) {
		UART_Printf( "BL 1,2, MON writing fail\n");
	}
	else {
		UART_Printf( "BL 1,2, MON writing success\n");
	}

	SDHC_WriteBlocks(0, 10, (u32)0x42000000, oSdhc);

#else
	// write bootloader1
	if ( SDHC_WriteBlocks(0, 16, (u32)source_addr, oSdhc) == FALSE ) {
		UART_Printf( "bootloader 1 loading fail\n");
	}
	else {
		UART_Printf( "bootloader 1 loading success\n");
	}

	// write bootloader2
	if ( SDHC_WriteBlocks(16, 8, (u32)0x41003000, oSdhc) == FALSE ) {
		UART_Printf( "bootloader 2 loading fail\n");
	}
	else {
		UART_Printf( "bootloader 2 loading success\n");
	}

	// write OS
	if ( SDHC_WriteBlocks(24, 400, (u32)0x41004000, oSdhc) == FALSE ) {
		UART_Printf( "OS loading fail\n");
	}
	else {
		UART_Printf( "OS loading success\n");
	}

//	SDHC_ReadBlocks(0, 16, (u32)0x42000000, oSdhc);
//	SDHC_ReadBlocks(16, 8, (u32)0x42100000, oSdhc);

#endif

	SDHC_IssueCommand(oSdhc, 6, ((3<<24)|(179<<16)|(0x48<<8)), SDHC_CMD_AC_TYPE, SDHC_RES_R1B_TYPE);
	// close media
	SDHC_CloseMedia(oSdhc);
}


void CheckSumData_Write(u32 uSrcAddr)
{
	u32 k,l;
	u8 buffer;
	u32 checkSum=0;
	u32 dataLength = (8*1024)-4;
	//u32 uSrcAddr = 0x31000000;//CODEC_MEM_ST+0x100000;

	UART_Printf("Do you want to insert CheckSum into BL1? [0:No, 1:Yes]");
	if(UART_GetIntNum()==0) return;

	for(k=0;k<dataLength;k+=1)
	{
		buffer = (*(volatile u8*)(uSrcAddr+k));
		checkSum = checkSum + buffer;
	}

	(*(volatile unsigned int*)(uSrcAddr+k)) = checkSum;

	UART_Printf(" uSrcAddr : %x, checkSum :%x ",uSrcAddr+k, checkSum);

}

u32* SDHC_getBuffer_Boot(int index, u8 sequence, u8 clear) {
	u32* result, *p;
	int buffer_size = 0x200000;
	int i;
	int reqNum;

	//6410
	//result = (u32*)(0x51000000 + index * buffer_size);
	// S5PV210
	result = (u32*)(0x23000000 + index * buffer_size);
	
	if ( clear == TRUE ) {
		memset( result, 0, buffer_size );
	}
	p=result;
	if ( sequence == TRUE ) {
		reqNum = (int)(rand() & 0xfffffff);	// auto offset.
		for(i=buffer_size>>2;i>0;i--) {
			*p++=reqNum++;
			//*p++ = (i&1)?(0x55555555):(0xaaaaaaaa);
		}
	}
	return result;
}

void ONENAND_BootWrite(void)
{
	OND_MODE n;
	u8 bIsOK = true;
	u32 uSrcAddr = CODEC_MEM_ST;
	u32 uDstAddr = CODEC_MEM_ST+0x1000000;
	u32 uBlockAddr,uLastBlockAddr;
	u32 uPageAddr;
	u32 uPageByteSize;
	u32 uNumOfBlocks,uNumOfPages;
	u32 uDataSize;
	u32 i;
	int sel;
	u32 uIfType, temp;

	u8 buffer;
	u32 checkSum=0;
	u32 dataLength = (8*1024)-4;
	u8 uErrCnt=0;
	
	// 1. Input block and page index
	// -----------------------------
	u32 uTotalNumOfBlocks;

	OND_InitIp();

	// Mux or Muxed
	Disp( " 0: Mux type		 1: Demux type \n" );
	uIfType = UART_GetIntNum();
	temp = *(volatile u32 *)(0xb0600100);
	temp = (temp & ~(1<<31)) | (uIfType<<31);
	*(volatile u32 *)(0xb0600100) = temp;
	
	//OND_UnlockAll();
	ChangeBufferSize(0x800);

	TestUnlockAllBlocks();

//	OND_GetBootBufSz(2048);
	
	if ( OND_IsFlexDev() ) 
		Disp( " Flex-OneNAND\n" );
	else
		Disp( " Normal OneNAND\n" );


	OND_GetSyncMode(&n);
	if (n == OND_ASYNC)
		Disp(" OND_ASYNC\n");
	else if (n == OND_SYNC_BURST_CONT)
		Disp(" OND_SYNC_BURST_CONST\n");
	else if (n == OND_SYNC_BURST4)
		Disp(" OND_SYNC_BURST4\n");
	else if (n == OND_SYNC_BURST8)
		Disp(" OND_SYNC_BURST8\n");
	else if (n == OND_SYNC_BURST16)
		Disp(" OND_SYNC_BURST16\n");
	else if (n == OND_SYNC_BURST32)
		Disp(" OND_SYNC_BURST32\n");

	OND_INT_SET_VEC();

	OND_GetTotalNumOfBlocks(&uTotalNumOfBlocks);
	Disp(" Input block index(0~%d) : ", uTotalNumOfBlocks-1);
	uBlockAddr = UART_GetIntNum();
	Disp(" Input page index(0~63) : ");
	uPageAddr = UART_GetIntNum();
	Disp(" Input Num. of pages : ");
	uNumOfPages = UART_GetIntNum();



#if 1
	CheckSumData_Write(0x41000000 );
#else
	for(i=0;i<dataLength;i+=1)
	{
		buffer = Inp8(uSrcAddr+i);
		checkSum = checkSum + buffer;	// Check Sum.
	}
	Outp32(uSrcAddr+i, checkSum);
	UART_Printf(" uSrcAddr : %x, checkSum :%x ",uSrcAddr+i, checkSum);
#endif

	OND_GetPageSz(&uPageByteSize);
	// 2. Init and clear buffer
	// ------------------------
	for (i=0;i<(uNumOfPages/64);i++)
	{
	
		// 3. Erase block
		// --------------
		bIsOK = OND_EraseBlocks( uBlockAddr+i,128 );
		if ( bIsOK == false )
			Disp( " Fail to erase\n");
		else
			Disp( " O.K. Erase\n");

		// 4. Program page
		// ---------------
//		bIsOK = OND_ProgramPages( uSrcAddr+i*2048*64, uBlockAddr+i, uPageAddr,64);
		bIsOK = OND_ProgramMultiPages( uSrcAddr+i*2048*64, uBlockAddr+i, uPageAddr,64,OND_NORMAL);
		if ( bIsOK == false )
			Disp( " Fail to program\n" );
		else
			Disp( " O.K. Program\n" );
	
		// 5. Load page
		// ------------
		bIsOK = OND_ReadMultiPages( uDstAddr+i*2048*64, uBlockAddr+i, uPageAddr ,64,OND_NORMAL);
		if ( bIsOK == false )
			Disp( " Fail to load\n" );
		else
			Disp( " O.K. Load\n" );
		// 6. Compare
		// ----------
		//bIsOK = Compare8( uSrcAddr, uDstAddr, uPageByteSize );
		bIsOK = memcmp( (void*)(uSrcAddr+i*2048*64), (void*)(uDstAddr+i*2048*64), uPageByteSize*64 );
		//if ( !bIsOndcTestAll )
		//{ 
		Disp( " Src Addr=0x%x, Dst Addr=0x%x uPageByteSize = %d \n", uSrcAddr+i*2048*64, uDstAddr+i*2048*64,uPageByteSize );
		Dump32( uSrcAddr+i*2048*64, 32 );
		Dump32( uDstAddr+i*2048*64, 32 );
		if( bIsOK != 0 )
			Disp(" Fail Compare\n");
		else
			Disp(" O.K. Compare\n");	
	//}
	//	else // Test All
		//	if (bIsOK != 0) uErrCnt++;
			
		if ( bIsOK == 0 )
			bIsOKOndcTestAll = true;
		else
			bIsOKOndcTestAll = false;	
	}

}


static void TestUnlockAllBlocks(void)
{
	u8 bIsOK;

	bIsOK = OND_UnlockAll();
	if (bIsOK==false) 
		Disp(" Fail Unlock all\n");
	else 
		Disp(" O.K. Unlock all\n");
}

void NAND_BootWrite(void)
{

//    unsigned long interrupt_reservoir;
	int i;
	int programError=0;
	u8 *srcPt,*saveSrcPt;
	u32 blockIndex;

	static volatile u32 srcAddress;
	static u32 targetBlock;	    // Block number (0 ~ 4095)
	u32 targetSize;	    // Total byte size 

	u32 j;
	u32 uSrcAddr = CODEC_MEM_ST;//CODEC_MEM_ST+0x100000;
	u8 buffer;
	u32 checkSum=0;
	u32 dataLength = (8*1024)-4;

	UART_Printf("\n[ NAND Flash writing program ]\n");
	UART_Printf("The program buffer: 0x41000000~0x41ffffff(16MB)\n");

	ReadID();
	DisplayConfiguration();
	//SetConfiguration(ECC_8BIT, 5,  3, 2048, 64, 2048, 64);
	SetConfiguration( ECC_8BIT, sNandInfo.uAddrCycle, sNandInfo.uRowCycle,\
					sNandInfo.uPageSize, sNandInfo.uPagesPerBlock,sNandInfo.uTotalBlockNum,\
					sNandInfo.uRedundantAreaSize*sNandInfo.u512BytesPerPage);

//	NF8_Init();

//   rINTMSK = BIT_ALLMSK; 	
    	srcAddress=(CODEC_MEM_ST); 

	for(i=0;i<dataLength;i+=1)
	{
		buffer = Inp8(uSrcAddr+i);
		checkSum = checkSum + buffer;	// Check Sum.
	}
	Outp32(uSrcAddr+i, checkSum);
	Disp(" uSrcAddr : %x, checkSum :%x ",uSrcAddr+i, checkSum);


    	UART_Printf("\nAvailable target block number: 0~2047\n");
	UART_Printf("Input target block number:");
    	targetBlock=UART_GetIntNum();	// Block number(0~4095)

	#if 0
	UART_Printf("Input target size(0x4000*n):");
	targetSize=UART_GetIntNum();	// Total byte size
	#else
	UART_Printf("Input program file size(bytes): ");
	targetSize=UART_GetIntNum();	// Total byte size
	#endif

	
	UART_Printf("File:%d[%d-block,%d-page,%d-bytes].\n", targetSize,(u32)((targetSize/2048)/64), (u32)((targetSize/2048)%64), (u32)(targetSize%2048));

	srcPt=(u8 *)srcAddress;
	blockIndex=targetBlock;

	ECC8_SETDIR_ENC();
	SetECCMsgLen(512);

     	while(1) {
        saveSrcPt=srcPt;	

#if 0
		if(NF8_IsBadBlock(blockIndex)==FAIL) {
		    blockIndex++;   // for next block
		    continue;
		}
#endif

		if(EraseBlock(blockIndex)==FAIL) {
		    blockIndex++;   // for next block
		    continue;
		}
		UART_Printf(".");		//	if(i==0)  UART_Printf(".");
		// After 1-Block erase, Write 1-Block(32 pages).
		for(i=0;i<sNandInfo.uPagesPerBlock;i++) {
		
		    if(WritePage8(srcPt,blockIndex,i)==FAIL) {// block num, page num, buffer
		        programError=1;
		        break;
			}

#if 0
		    if(ReadPage(srcPt, blockIndex,i)) {
				UART_Printf("ECC Error(block=%d,page=%d!!!\n",blockIndex,i);
		    }
#endif
			
		srcPt+=sNandInfo.uPageSize;	// Increase buffer addr one pase size
		
			//UART_Printf("\b\b\b\b\b\b\b\b%04d,%02d]", blockIndex, i);
		if((u32)srcPt>=(srcAddress+targetSize)) // Check end of buffer
		break;	// Exit for loop
		}
		
		if(programError==1) {
		    blockIndex++;
		    srcPt=saveSrcPt;
		    programError=0;
		    continue;
		}

		if((u32)srcPt>=(srcAddress+targetSize)) break;	// Exit while loop

		blockIndex++;
		
    }
}
