
/**************************************************************************************
* 
*	Project Name : S5PV210 Validation
*
*	Copyright 2006 by Samsung Electronics, Inc.
*	All rights reserved.
*
*	Project Description :
*		This software is only for validating functions of the S5PV210.
*		Anybody can use this software without our permission.
*  
*--------------------------------------------------------------------------------------
* 
*	File Name : usbhost_test.c
*  
*	File Description : This file implements the API functons for Timer USB HOST test.
*
*	Author : Haksoo,Kim
*	Dept. : AP Development Team
*	Created Date : 2007/01/16
*	Version : 0.1 
* 
*	History
*	- Create (Haksoo,Kim 2009/07/15)
**************************************************************************************/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#include "option.h"
#include "library.h"
#include "v210_sfr.h"
#include "system.h"
#include "usbhost.h"
#include "sysc.h"
#include "intc.h"

USB_EP_SPEED eUsbEpSpeed;

#define OHCI_ENABLE

static void __irq Isr_UsbHost(void)
{
	INTC_Disable(NUM_UHOST);

	USBHOST_HandleEvent();
	
	INTC_Enable(NUM_UHOST);
	
	INTC_ClearVectAddr();
}


//////////
// Function Name : NormalOpTest
// Function Desctiption : This function test normal operation test of usb host controller
// Input : NONE
// Output : NONE
// Version :
static void NormalOpTest(void)
{	
	USBHOST_Init();

	USBHOST_WaitCableInsertion();

	Delay(100);	// need in order for reset operation to complete properly

	USBHOST_EhciPortReset(&eUsbEpSpeed);
	
	if (eUsbEpSpeed == USB_EP_HIGH_SPEED)
	{
		UART_Printf("\n>>> High Speed!");
	}
	else
	{
		UART_Printf("\n>>> Full Speed!");
#ifdef OHCI_ENABLE
		USBHOST_PortOwnerChange(OHCI_OWNER);
		USBHOST_InitOhciCon();
		USBHOST_OhciPortReset();
#else
		return;
#endif
	}

	if (eUsbEpSpeed == USB_EP_HIGH_SPEED)
	{
		USBHOST_EhciEnumerate();
	}
	else
	{
#ifdef OHCI_ENABLE
		USBHOST_OhciEnumerate();
#else
		return;
#endif		
	}
}


//////////
// Function Name : DisplayDeviceInform
// Function Desctiption : This function display information of configured device if exists
// Input : NONE
// Output : NONE
// Version :
static void DisplayDeviceInform(void)
{
	if (USBHOST_CheckDeviceEnumerated() != true)
	{
		UART_Printf("\nError : There is no configured USB device!!\n");
		
		return;
	}
	
	USBHOST_DisplayDeviceInform();
}


//////////
// Function Name : BulkOutXferTest
// Function Desctiption : This function is for testing Bulk Out Transfer
// Input : NONE
// Output : NONE
// Version :
static void BulkOutXferTest(void)
{
	u32 uDownAddr, uDownSize;
	
	if (USBHOST_CheckDeviceEnumerated() != true)
	{
		UART_Printf("\nError : There is no configured USB device!!\n");
		
		return;
	}
	
	if (USBHOST_CheckSamsungAP() != true)
	{
		UART_Printf("\nError : Only Samsung AP is available for this test!!\n");
		
		return;
	}

if (1)	// org
{
	Disp("\nEnter the Download Address : ");
	uDownAddr = UART_GetIntNum();
	
	Disp("\nEnter the Download Size : ");
	uDownSize = UART_GetIntNum();
}
else	 if (0)	// temp1
{
	u32 uThLvl;	

	uThLvl = Inp32(0xec200094);
	uThLvl = uThLvl &0xffff;
	
	Disp("\nEnter the Out Threshold level : ");
	Outp32(0xec200094, (UART_GetIntNum()<<16)|uThLvl);
	
	Disp("\nEnter the Download Address : ");
	uDownAddr = UART_GetIntNum();
	
	Disp("\nEnter the Download Size : ");
	uDownSize = UART_GetIntNum();
}
else	 if (0)	// temp2
{
	u32 uThLvl;	

	uThLvl = Inp32(0xec200094);
	uThLvl = uThLvl &0xffff;
	
	Disp("\nEnter the Out Threshold level : ");
	Outp32(0xec200094, (UART_GetIntNum()<<16)|uThLvl);
	
	uDownAddr = 0x41000000;
//	uDownSize = 10240;		// 10KB
//	uDownSize = 92160;		// 90KB
	uDownSize = 0x00100000;	// 1MB
}
else		// temp3
{
	uDownAddr = 0x41000000;
//	uDownSize = 10240;		// 10KB
//	uDownSize = 92160;		// 90KB
//	uDownSize = 0x00100000;	// 1MB
	uDownSize = 0x00a00000;	// 10MB
}
	
	USBHOST_TestBulkOut(uDownAddr, uDownSize);
	
}


//////////
// Function Name : BulkInXferTest
// Function Desctiption : This function is for testing Bulk In Transfer
// Input : NONE
// Output : NONE
// Version :
static void BulkInXferTest(void)
{
	u32 uUpAddr, uUpSize;
	
	if (USBHOST_CheckDeviceEnumerated() != true)
	{
		UART_Printf("\nError : There is no configured USB device!!\n");
		
		return;
	}
	
	if (USBHOST_CheckSamsungAP() != true)
	{
		UART_Printf("\nError : Only Samsung AP is available for this test!!\n");
		
		return;
	}

if (1)	// org
{
	Disp("\nEnter the Upload Address : ");
	uUpAddr = UART_GetIntNum();
	
	Disp("\nEnter the Upload Size : ");
	uUpSize = UART_GetIntNum();
}
else	 if (0)	// temp1
{
	u32 uThLvl;	

	uThLvl = Inp32(0xec200094);
	uThLvl = uThLvl &0xffff0000;
	
	Disp("\nEnter the In Threshold level : ");
	Outp32(0xec200094, UART_GetIntNum()|uThLvl);

	Disp("\nEnter the Upload Address : ");
	uUpAddr = UART_GetIntNum();
	
	Disp("\nEnter the Upload Size : ");
	uUpSize = UART_GetIntNum();
}
else	 if (0)	// temp2
{
	u32 uThLvl;
	

	uThLvl = Inp32(0xec200094);
	uThLvl = uThLvl &0xffff0000;
	
	Disp("\nEnter the In Threshold level : ");
	Outp32(0xec200094, UART_GetIntNum()|uThLvl);

	uUpAddr = 0x41000000;
//	uUpSize = 0x00100000;		// 1MB
	uUpSize = 0x00a00000;		// 10MB
}
else		// temp3
{
	uUpAddr = 0x41000000;
	uUpSize = 0x00100000;		// 1MB
}


	USBHOST_TestBulkIn(uUpAddr, uUpSize);

	
}

//////////
// Function Name : CheckEyePattern
// Function Desctiption : This function is for checking eye-pattern
// Input : NONE
// Output : NONE
// Version :
static void CheckEyePattern(void)
{
	USBHOST_Init();
	
	USBHOST_EnterTestMode(TEST_PACKET);

	UART_Printf("If you want to exit test mode, press 'x' key\n");

	if (UART_Getc() == 'x')
	{		
		USBHOST_ExitTestMode();		
		
		return;
	}
}


void Test_USBHOST(void)
{
	int i, sel;

	const testFuncMenu menu[]=
	{
		NULL,                                  		"Exit\n",
		NormalOpTest,					"Normal Operation Test",
		DisplayDeviceInform, 			"Display Information of Configured Device",
		BulkOutXferTest,					"Bulk Out Transfer Test",
		BulkInXferTest,					"Bulk In Transfer Test",
		CheckEyePattern,				"Check Eye-Pattern",
		0,0
	};
	
	INTC_SetVectAddr(NUM_UHOST, Isr_UsbHost);
	
	while(1)
	{
	
		Disp("\n");
		for (i=0; (int)(menu[i].desc)!=0; i++)
			Disp("%2d: %s\n", i, menu[i].desc);

		Disp("\nSelect the function to test : ");
		sel = UART_GetIntNum();
		Disp("\n");

		if (sel == 0)
		{
			INTC_Disable(NUM_UHOST);
			break;
		}
		else if (sel>0 && sel<(sizeof(menu)/8-1))
			(menu[sel].func)();
	}	
}


//=====================================================
// AUTO TEST
extern u8 USBHOST_Init_autotest(void);
extern u8 USBHOST_EhciEnumerate_autotest(void);

u8 USBHOST_autotest(void)
{
	INTC_SetVectAddr(NUM_UHOST, Isr_UsbHost);
	
	if (USBHOST_Init_autotest() != true)
	{
		return false;
	}

	USBHOST_WaitCableInsertion();

	Delay(100);	// need in order for reset operation to complete properly

	USBHOST_EhciPortReset(&eUsbEpSpeed);
	
	if (eUsbEpSpeed == USB_EP_HIGH_SPEED)
	{
		UART_Printf("\n>>> High Speed!");
	}
	else
	{
		UART_Printf("\n>>> Full Speed!");
		return false;
	}

	if (USBHOST_EhciEnumerate_autotest() != true)
	{
		return false;
	}

	DisplayDeviceInform();

	return true;
}


