
/**************************************************************************************
* 
*	Project Name : S5PV210 Validation
*
*	Copyright 2006 by Samsung Electronics, Inc.
*	All rights reserved.
*
*	Project Description :
*		This software is only for validating functions of the S5PV210.
*		Anybody can use this software without our permission.
*  
*--------------------------------------------------------------------------------------
* 
*	File Name : usbhost.h
*  
*	File Description : This file declares prototypes of USB HOST API funcions.
*
*	Author : Haksoo,Kim
*	Dept. : AP Development Team
*	Created Date : 2007/01/16
*	Version : 0.1 
* 
*	History
*	- Create (Haksoo,Kim 2009/07/15)
**************************************************************************************/

#ifndef __USBHOST_H__
#define __USBHOST_H__


#ifdef __cplusplus
extern "C" {
#endif

#include <stdio.h>

#include "def.h"

//==================================================================
//

#define FULL_SPEED_CONTROL_PKT_SIZE	64
#define FULL_SPEED_BULK_PKT_SIZE		64

#define HIGH_SPEED_CONTROL_PKT_SIZE	64
#define HIGH_SPEED_BULK_PKT_SIZE		512

typedef enum
{
	USB_EP_FULL_SPEED, USB_EP_LOW_SPEED, USB_EP_HIGH_SPEED
} USB_EP_SPEED; 

typedef enum 
{
	EHCI_OWNER, OHCI_OWNER
}USB_PORT_OWNER;

typedef enum 
{
	TEST_MODE_DISABLED, TEST_J_STATE, TEST_K_STATE, TEST_SE0_NAK, TEST_PACKET, TEST_FORCE_ENABLE
}USB_PORT_TEST;

typedef enum
{
	OHCI_USB_RESET, OHCI_USB_RESUME, OHCI_USB_OPERATIONAL, OHCI_USB_SUSPEND
}USB_OHCI_HC_STATE;


typedef struct
{
	u8 bLength;
	u8 bDescriptorType;
	u8 bcdUSBL;
	u8 bcdUSBH;
	u8 bDeviceClass;
	u8 bDeviceSubClass;
	u8 bDeviceProtocol;
	u8 bMaxPacketSize0;
	u8 idVendorL;
	u8 idVendorH;
	u8 idProductL;
	u8 idProductH;
	u8 bcdDeviceL;
	u8 bcdDeviceH;
	u8 iManufacturer;
	u8 iProduct;
	u8 iSerialNumber;
	u8 bNumConfigurations;
} USB_DEVICE_DESCRIPTOR;

typedef struct
{
	u8 bLength;
	u8 bDescriptorType;
	u8 wTotalLengthL;
	u8 wTotalLengthH;
	u8 bNumInterfaces;
	u8 bConfigurationValue;
	u8 iConfiguration;
	u8 bmAttributes;
	u8 maxPower;
} USB_CONFIGURATION_DESCRIPTOR;

typedef struct
{
	u8 bLength;
	u8 bDescriptorType;
	u8 bInterfaceNumber;
	u8 bAlternateSetting;
	u8 bNumEndpoints;
	u8 bInterfaceClass;
	u8 bInterfaceSubClass;
	u8 bInterfaceProtocol;
	u8 iInterface;
} USB_INTERFACE_DESCRIPTOR;

typedef struct
{
	u8 bLength;
	u8 bDescriptorType;
	u8 bEndpointAddress;
	u8 bmAttributes;
	u8 wMaxPacketSizeL;
	u8 wMaxPacketSizeH;
	u8 bInterval;
} USB_ENDPOINT_DESCRIPTOR;

typedef struct
{
	u8 bLength;
	u8 bDescriptorType;
	u8 *pString;
} USB_STRING_DESCRIPTOR;

typedef struct
{
	u8 bmRequestType;  
	u8 bRequest;       
	u8 wValue_L;       
	u8 wValue_H;       
	u8 wIndex_L;       
	u8 wIndex_H;       
	u8 wLength_L;      
	u8 wLength_H;      
} DEVICE_REQUEST, *DEVICE_REQUEST_PTR;

typedef enum 
{
	EHCI_STATE_INIT, 
	EHCI_STATE_ATTACHED,
	EHCI_STATE_READY,
	EHCI_STATE_GD_DEV_BEFORE,
	EHCI_STATE_SET_ADDR,
	EHCI_STATE_GD_DEV_AFTER,
	EHCI_STATE_GD_CFG,
	EHCI_STATE_GD_STR0,
	EHCI_STATE_GD_STR1,
	EHCI_STATE_GD_STR2,
	EHCI_STATE_GD_STR3,
	EHCI_STATE_SET_CFG, 
	EHCI_STATE_CONFIGURED
} EHCI_STATE;

typedef enum 
{
	OHCI_STATE_INIT, 
	OHCI_STATE_ATTACHED,
	OHCI_STATE_READY,
	OHCI_STATE_GD_DEV_BEFORE,
	OHCI_STATE_SET_ADDR,
	OHCI_STATE_GD_DEV_AFTER,
	OHCI_STATE_GD_CFG,
	OHCI_STATE_GD_STR0,
	OHCI_STATE_GD_STR1,
	OHCI_STATE_GD_STR2,
	OHCI_STATE_GD_STR3,
	OHCI_STATE_SET_CFG, 
	OHCI_STATE_CONFIGURED
} OHCI_STATE;

typedef struct
{
	volatile EHCI_STATE m_eEhciState;
	volatile OHCI_STATE m_eOhciState;
	
	u16 m_usDevAddr;
} USBHOST;

typedef struct
{
	USB_DEVICE_DESCRIPTOR oDescDevice;
	USB_CONFIGURATION_DESCRIPTOR oDescConfig;
	USB_INTERFACE_DESCRIPTOR oDescInterface;
	USB_ENDPOINT_DESCRIPTOR oDescEp0;
	USB_ENDPOINT_DESCRIPTOR oDescEp1;
	USB_ENDPOINT_DESCRIPTOR oDescEp2;
	USB_ENDPOINT_DESCRIPTOR oDescEp3;
	USB_STRING_DESCRIPTOR oDescStr0;
	USB_STRING_DESCRIPTOR oDescStr1;
	USB_STRING_DESCRIPTOR oDescStr2;
	USB_STRING_DESCRIPTOR oDescStr3;
} USB_DESCRIPTORS;

typedef struct
{
	USB_DESCRIPTORS m_oDesc;
	
	u16 m_usDevAddr;

	u8 m_ucControlEPMaxPktSize;
	u16 m_usBulkEPMaxPktSize;

	u8 m_ucBulkInEpNum;
	u8 m_ucBulkOutEpNum;
} USBDEVICE;


//==================================================================
// register structure
//
// <EHCI>
//
//HCCPBASE
typedef union
{
	u32 data;
	struct {
		// bit[7:0] : offset of the beginning of the operational register space
		unsigned cap_length : 8;
		// bit[15:8]
		unsigned reserved15_8 : 8;
		// bit[31:16] : BCD encoding of the ehci revision number(0x0100)
		unsigned hci_revision : 16;
	}b;
}ehci_hccpbase_t;

// HCSPARAMS
typedef union
{
	u32 data;
	struct {
		// bit[3:0] : # of downstream ports
		unsigned n_ports : 4;
		// bit[4] : port power control ( '1' means that port has port power switch)
		unsigned p_pwr_ctrl : 1;
		// bit[6:5] : reserved
		unsigned reserved6_5 : 2;
		// bit[7] : port routing rules
		unsigned p_routing_rule : 1;
		// bit[11:8] : # of ports per companion controller
		unsigned n_pcc : 4;
		// bit[15:12] : # of companion controller
		unsigned n_cc : 4;
		// bit[16] : whether the ports support port indicator control
		unsigned p_indicator : 1;
		// bit[19:17]
		unsigned reserved19_17 : 3;
		// bit[23:20] : # of debug port ?khs
		unsigned n_dbg_p : 4;
		// bit[31:24]
		unsigned reserved31_24 : 8;
	}b;
}ehci_hcsparams_t;

// HCCPARAMS	
typedef union
{
	u32 data;
	struct {
		// bit[0] : 64-bit addressing capability
		unsigned _64bit_addressing: 1;
		// bit[1] : programmable frame list flag
		unsigned frm_lst_flg: 1;
		// bit[2] : asynchronous schedule park capability
		unsigned async_sched_park: 1;
		// bit[3] :
		unsigned reserved3: 1;
		// bit[7:4] : isochronous scheduling threshold
		unsigned iso_sched_thresh: 4;
		// bit[15:8] :
		unsigned eecp: 8;
		// bit[31:16] :
		unsigned reserved31_16: 16;
	}b;
}ehci_hccparams_t;

// USBCMD
typedef union
{
	u32 data;
	struct {
		// bit[0] : run(1), stop(0)
		unsigned run_stop: 1;
		// bit[1] : host controller reset
		unsigned hc_reset: 1;
		// bit[3:2] : frame list size (r/w only if programmable frame list flag in HCCPARAMS reg. is set to '1'
		unsigned frm_lst_sz: 2;
		// bit[4] : periodic schedule enable
		unsigned periodic_sched_en: 1;
		// bit[5] : async. schedule enable
		unsigned async_sched_en: 1;
		// bit[6] : interrupt on async advance doorbell ?khs
		unsigned intr_async_adv_doorbell_en: 1;
		// bit[7] : light host controller reset
		unsigned light_hc_reset: 1;
		// bit[9:8] : asynch schedule park mode count ?khs
		unsigned async_sched_park_cnt: 2;
		// bit[10] :
		unsigned reserved10: 1;
		// bit[11] : asynch schedule park mode enable
		unsigned async_sched_park_en: 1;
		// bit[15:12] :
		unsigned reserved15_12: 4;
		// bit[23:16] : interrupt threshold control (in unit of 1 micro-frame)
		unsigned intr_thresh_ctrl: 8;
		// bit[31:24] :
		unsigned reserved31_24: 8;
	}b;
}ehci_usbcmd_t;

// USBSTS
typedef union
{
	u32 data;
	struct {
		// bit[0] : usb interrupt
		unsigned usbint: 1;
		// bit[1] : usb error interrupt
		unsigned usberrint: 1;
		// bit[2] : port change detect
		unsigned p_chng_detect: 1;
		// bit[3] : frame list rollover
		unsigned frm_lst_rollover: 1;
		// bit[4] : host system error
		unsigned host_sys_error: 1;
		// bit[5] : interrupt on async advance
		unsigned intr_async_adv: 1;
		// bit[11:6] : 
		unsigned reserved11_6: 6;
		// bit[12] : HC halted
		unsigned hc_halted: 1;
		// bit[13] : reclamation ?khs
		unsigned reclamation: 1;
		// bit[14] : periodic schedule status
		unsigned periodic_sched_sts: 1;
		// bit[15] : async schedule status
		unsigned async_sched_sts: 1;
		// bit[31:16] : 
		unsigned reserved31_16: 16;
	}b;
}ehci_usbsts_t;

// USBINTR
typedef union
{
	u32 data;
	struct {
		// bit[0] : usb interrupt enable
		unsigned usbint_en: 1;
		// bit[1] : usb error interrupt enable
		unsigned usberrint_en: 1;
		// bit[2] : port change interrupt enable
		unsigned p_chng_int_en: 1;
		// bit[3] : frame list rollover enable
		unsigned frm_lst_rollover_en: 1;
		// bit[4] : host system error enable
		unsigned host_sys_error_en: 1;
		// bit[5] : interrupt on async advance enable
		unsigned async_adv_en: 1;
		// bit[31:6] : 
		unsigned reserved31_6: 26;
	}b;
}ehci_usbintr_t;

// FRINDEX
typedef union
{
	u32 data;
	struct {
		// bit[13:0] : frame index
		unsigned frm_idx: 14;
		// bit[31:14] :
		unsigned reserved31_14: 18;
	}b;
}ehci_frindex_t;

// CTRLDSSEGMENT
// PERIODICLISTBASE
// ASYNCLISTADDR
//CONFIGFLAG
typedef union
{
	u32 data;
	struct {
		// bit[0] : configured flag ( 0:default-route is classic host controller, 1: default-route is ehci hc)
		unsigned cf: 1;
		// bit[31:1] :
		unsigned reserved31_1: 31;
	}b;
}ehci_configflag_t;

// PORTSC
typedef union
{
	u32 data;
	struct {
		// bit[0] : current connect status
		unsigned cur_con_sts : 1;
		// bit[1] : connect status change
		unsigned con_sts_chng : 1;
		// bit[2] : port enabled disabled
		unsigned p_en_dis : 1;
		// bit[3] : port enabled/disabled chagne
		unsigned p_en_dis_chng : 1;
		// bit[4] : over-current active
		unsigned over_current : 1;
		// bit[5] : over_current change
		unsigned over_current_chng : 1;
		// bit[6] : force port resume
		unsigned p_resume : 1;
		// bit[7] : port suspend
		unsigned p_suspend : 1;
		// bit[8] : port reset
		unsigned p_reset : 1;
		// bit[9] : reserved
		unsigned resered9 : 1;
		// bit[11:10] : line status
		unsigned line_sts : 2;
		// bit[12] : port power
		unsigned p_power : 1;
		// bit[13] : port owner
		unsigned p_owner : 1;
		// bit[15:14] : port indicator control, this field has no meaning when P_INDICATOR bit of HCSPARAMS is '0'
		unsigned p_indicator_ctrl : 2;
		// bit[19:16] : port test control
		unsigned p_test_ctrl : 4;
		// bit[20] : wake on connect enable
		unsigned wkcnnt_e : 1;
		// bit[21] : wake on disconnect enable
		unsigned wkdscnnt_e : 1;
		// bit[22] : wake on over-current enable
		unsigned wkoc_e : 1;
		// bit[31:23] : reserved
		unsigned reserved31_23 : 9;
	}b;
}ehci_portsc_t;

//==================================================================
// register structure
//
// <OHCI>
//
//-------------------------------------------------------------------
// control & status partition

typedef union
{
	u32 data;
	struct {
		// bit[7:0] : revision
		unsigned revision : 8;
		// bit[31:8] : reserved
		unsigned reserved31_8 : 24;
	}b;
}ohci_revision_t;

typedef union
{
	u32 data;
	struct {
		// bit[1:0] : 
		unsigned control_bulk_service_ratio : 2;
		// bit[2] : 
		unsigned periodic_list_enable : 1;
		// bit[3] : 
		unsigned isochronous_enable : 1;
		// bit[4] : 
		unsigned control_list_enable : 1;
		// bit[5] : 
		unsigned bulk_list_enable : 1;
		// bit[7:6] :
		unsigned hc_function_state : 2;
		// bit[8] :
		unsigned interrupt_routing : 1;
		// bit[9] : 
		unsigned remote_wakeup_connected : 1;
		// bit[10] :
		unsigned remote_wakeup_enable : 1;
		// bit[31:11] :
		unsigned reserved31_11 : 21;
	}b;
}ohci_control_t;

typedef union
{
	u32 data;
	struct {
		// bit[0] : 
		unsigned hc_reset : 1;
		// bit[1] : 
		unsigned control_list_filled : 1;
		// bit[2] : 
		unsigned bulk_list_filled : 1;
		// bit[3] : 
		unsigned ownership_change_request : 1;
		// bit[15:4] : 
		unsigned reserved15_4 : 12;
		// bit[17:16] : 
		unsigned sheduling_overrun_count : 2;
		// bit[31:18] : 
		unsigned reserved31_18 : 14;
	}b;
}ohci_commandstatus_t;

typedef union
{
	u32 data;
	struct {
		// bit[0] : 
		unsigned scheduling_overrun : 1;
		// bit[1] : 
		unsigned writeback_donehead : 1;
		// bit[2] : 
		unsigned start_of_frame : 1;
		// bit[3] : 
		unsigned resume_detected : 1;
		// bit[4] : 
		unsigned unrecoverable_error : 1;
		// bit[5] : 
		unsigned frame_number_overflow : 1;
		// bit[6] : 
		unsigned root_hub_status_change : 1;
		// bit[29_7] : 
		unsigned reserved29_7 : 23;
		// bit[30] : 
		unsigned ownership_change : 1;
		// bit[31] : should be zero
		unsigned reserved31 : 1;
	}b;
}ohci_interruptstatus_t;

typedef union
{
	u32 data;
	struct {
		// bit[0] : 
		unsigned scheduling_overrun : 1;
		// bit[1] : 
		unsigned writeback_donehead : 1;
		// bit[2] : 
		unsigned start_of_frame : 1;
		// bit[3] : 
		unsigned resume_detected : 1;
		// bit[4] : 
		unsigned unrecoverable_error : 1;
		// bit[5] : 
		unsigned frame_number_overflow : 1;
		// bit[6] : 
		unsigned root_hub_status_change : 1;
		// bit[29_7] : 
		unsigned reserved29_7 : 23;
		// bit[30] : 
		unsigned ownership_change : 1;
		// bit[31] : 
		unsigned master_interrupt_enable : 1;
	}b;
}ohci_interruptenable_t;

typedef union
{
	u32 data;
	struct {
		// bit[0] : 
		unsigned scheduling_overrun : 1;
		// bit[1] : 
		unsigned writeback_donehead : 1;
		// bit[2] : 
		unsigned start_of_frame : 1;
		// bit[3] : 
		unsigned resume_detected : 1;
		// bit[4] : 
		unsigned unrecoverable_error : 1;
		// bit[5] : 
		unsigned frame_number_overflow : 1;
		// bit[6] : 
		unsigned root_hub_status_change : 1;
		// bit[29_7] : 
		unsigned reserved29_7 : 23;
		// bit[30] : 
		unsigned ownership_change : 1;
		// bit[31] : 
		unsigned master_interrupt_disable : 1;
	}b;
}ohci_interruptdisable_t;

//-------------------------------------------------------------------
// memory pointer partition

typedef union
{
	u32 data;
	struct {
		// bit[7:0] : should be zero
		unsigned reserved7_0 : 8;
		// bit[31:8] :
		unsigned hcca_base_addr : 24;
	}b;
}ohci_hcca_t;

typedef union
{
	u32 data;
	struct {
		// bit[3:0] : 
		unsigned reserved3_0 : 4;
		// bit[31:4]
		unsigned period_current_ed : 28;
	}b;
}ohci_periodcurrented_t;

typedef union
{
	u32 data;
	struct {
		// bit[3:0] : 
		unsigned reserved3_0 : 4;
		// bit[31:4]
		unsigned control_head_ed : 28;
	}b;
}ohci_controlheaded_t;

typedef union
{
	u32 data;
	struct {
		// bit[3:0] : 
		unsigned reserved3_0 : 4;
		// bit[31:4]
		unsigned control_current_ed : 28;
	}b;
}ohci_controlcurrented_t;

typedef union
{
	u32 data;
	struct {
		// bit[3:0] : 
		unsigned reserved3_0 : 4;
		// bit[31:4]
		unsigned bulk_head_ed : 28;
	}b;
}ohci_bulkheaded_t;

typedef union
{
	u32 data;
	struct {
		// bit[3:0] : 
		unsigned reserved3_0 : 4;
		// bit[31:4]
		unsigned bulk_current_ed : 28;
	}b;
}ohci_bulkcurrented_t;

typedef union
{
	u32 data;
	struct {
		// bit[3:0] : 
		unsigned reserved3_0 : 4;
		// bit[31:4]
		unsigned done_head : 28;
	}b;
}ohci_donehead_t;

//-------------------------------------------------------------------
// frame counter partition

typedef union
{
	u32 data;
	struct {
		// bit[13:0] :
		unsigned frame_interval : 14;
		// bit[15:14] :
		unsigned reserved15_14 : 2;
		// bit[30:16] : 
		unsigned fs_largest_data_packet : 15;
		// bit[31] : 
		unsigned frame_interval_toggle : 1;
	}b;
}ohci_fminterval_t;

typedef union
{
	u32 data;
	struct {
		// bit[13:0] : 
		unsigned frame_remaining : 14;
		// bit[30:14] : 
		unsigned reserved30_14 : 17;
		// bit[31] : 
		unsigned frame_remaing_toggle : 1;
	}b;
}ohci_fmremaining_t;

typedef union
{
	u32 data;
	struct {
		// bit[15:0] : 
		unsigned frame_number : 16;
		// bit[31:16] : 
		unsigned reserved31_16 : 16;
	}b;
}ohci_fmnumber_t;

typedef union
{
	u32 data;
	struct {
		// bit[13:0]
		unsigned periodic_start : 14;
		// bit[31:14]
		unsigned reserved31_14 : 18;
	}b;
}ohci_periodicstart_t;

typedef union
{
	u32 data;
	struct {
		// bit[11:0]
		unsigned ls_threshold : 12;
		// bit[31:12]
		unsigned reserved31_12 : 20;
	}b;
}ohci_lsthreshold_t;

//-------------------------------------------------------------------
// root hub partition

typedef union
{
	u32 data;
	struct {
		// bit[7:0]
		unsigned number_downstream_ports : 8;
		// bit[8]
		unsigned power_switching_mode : 1;
		// bit[9]
		unsigned no_power_switching : 1;
		// bit[10] : should read/write zero
		unsigned device_type : 1;
		// bit[11]
		unsigned overcurrent_protection_mode : 1;
		// bit[12]
		unsigned no_overcurrent_prodection : 1;
		// bit[23:13]
		unsigned reserved23_13 : 11;
		// bit[31:24]
		unsigned power_on_to_power_good_time : 8;
	}b;
}ohci_rhdescriptorA_t;

typedef union
{
	u32 data;
	struct {
		// bit[15:0] : 0 -> removable, 1 -> not removable
		unsigned device_removable : 16;
		// bit[31:16]
		unsigned port_power_control_mask : 16;
	}b;
}ohci_rhdescriptorB_t;

typedef union
{
	u32 data;
	struct {
		// bit[0] : read-> local power status, write-> clear global power
		unsigned lps_cgp : 1;
		// bit[1]
		unsigned overcurrent_indicator : 1;
		// bit[14:2]
		unsigned reserved14_2 : 13;
		// bit[15] : read-> device remote wakeup enable, write-> set remote wakeup enable
		unsigned drwe_srwe : 1;
		// bit[16] : read -> loacl power status change, write-> set global power
		unsigned lpsc_sgp : 1;
		// bit[17]
		unsigned overcurrent_indicator_change : 1;
		// bit[30:18]
		unsigned reserved30_18 : 13;
		// bit[31]
		unsigned clear_remote_wakeup_enable : 1;
	}b;
}ohci_rhstatus_t;

typedef union
{
	u32 data;
	struct {
		// bit[0] : read-> current connect status, write-> clear port enable
		unsigned ccs_cpe : 1;
		// bit[1] : read-> port enable status, write-> set port enable
		unsigned pes_spe : 1;
		// bit[2] : read-> port suspend status, write-> set port suspend
		unsigned pss_sps : 1;
		// bit[3] : read-> port over-current indicator, write-> clear suspend status
		unsigned poci_css : 1;
		// bit[4] : read-> port reset status, write-> set port reset
		unsigned prs_spr : 1;
		// bit[7:5] 
		unsigned reserved7_5 : 3;
		// bit[8] : read-> port power status, write-> set port power
		unsigned pps_spp : 1;
		// bit[9] read->low speed device attached, write-> clear port power
		unsigned lsda_cpp : 1;
		// bit[15:10] 
		unsigned reserved15_10 : 6;
		// bit[16] 
		unsigned connect_status_change : 1;
		// bit[17] 
		unsigned port_enable_status_change : 1;
		// bit[18] 
		unsigned port_suspend_status_change : 1;
		// bit[19] 
		unsigned port_overcurrent_indicator_change : 1;
		// bit[20] 
		unsigned port_reset_status_change : 1;
		// bit[31:21] 
		unsigned reserved31_21 : 11;
	}b;
}ohci_rhportstatus1_t;

//==================================================================
// data structure
//
// <EHCI>
//

typedef union
{
	u32 data;
	struct {
		// bit[0] : terminate
		unsigned t : 1;
		// bit[2:1] : type
		unsigned typ : 2;
		// bit[4:3]
		unsigned reserved4_3 : 2;
		// bit[31:5]
		unsigned qhlp : 27;
	}b;
}qh_dw0_t;

typedef union 
{
	u32 data;
	struct {
		// bit[6:0] : device address
		unsigned dev_addr : 7;
		// bit[7] : inactivate on next transaction, only valid qh is in periodic schedule and eps field indicates FS or LS
		unsigned i : 1;
		// bit[11:8] : endpoint number
		unsigned ep_num : 4;
		// bit[13:12] : endpoint speed
		unsigned eps : 2;
		// bit[14] : data toggle control
		unsigned dtc : 1;
		// bit[15] : head of reclamation list flag
		unsigned h : 1;
		// bit[26:16] : maximum packet length
		unsigned max_pkt_sz : 11;
		// bit[27] : control endpoint flag
		unsigned c : 1;
		// bit[31:28] : nak count reload
		unsigned rl : 4;
	}b;
}qh_dw1_t;

typedef union 
{
	u32 data;
	struct {
		// bit[7:0] : interrupt schedule mask
		unsigned uframe_s_mask : 8;
		// bit[15:8] : split competion mask
		unsigned uframe_c_mask : 8;
		// bit[22:16] : hub addr
		unsigned hub_addr : 7;
		// bit[29:23] : port number
		unsigned port_num : 7;
		// bit[31:30] : high-bandwidth pipe multiplier
		unsigned mult : 2;
	}b;
}qh_dw2_t;

typedef struct 
{
	qh_dw0_t next_qh_ptr;
	qh_dw1_t info1;
	qh_dw2_t info2;
	u32 current_qtd_ptr;
	u32 next_qtd_ptr;
	u32 alt_next_qtd_ptr;
	u32 qtd_token;
	u32 buf_ptr0;
	u32 buf_ptr1;
	u32 buf_ptr2;
	u32 buf_ptr3;
	u32 buf_ptr4;
}ehci_qh_t, *ehci_qh_t_ptr;

typedef union 
{
	u32 data;
	struct {
		// bit[7:0] : status
		unsigned sts : 8;
		// bit[9:8] : pid code
		unsigned pid : 2;
		// bit[11:10] : error counter
		unsigned cerr:2;
		// bit[14:12] : current page
		unsigned c_page : 3;
		// bit[15] : interrupt on complete
		unsigned ioc : 1;
		// bit[30:16] : total bytes to transfer
		unsigned xfer_total_bytes : 15;
		// bit[31] : data toggle
		unsigned data_toggle : 1;
	}b;
}ehci_qtd_token_t;

typedef struct
{
	u32 next_qtd_ptr;
	u32 alt_next_qtd_prt;
	ehci_qtd_token_t qtd_token;
	u32 buf_ptr0;
	u32 buf_ptr1;
	u32 buf_ptr2;
	u32 buf_ptr3;
	u32 buf_ptr4;
}ehci_qtd_t, *ehci_qtd_t_ptr;


//==================================================================
// data structure
//
// <OHCI>
//

typedef union 
{
	u32 data;
	struct {
		// bit[6:0] : function address
		unsigned func_addr : 7;
		// bit[10:7] : endpoint number
		unsigned ep_num : 4;
		// bit[12:11] : direction
		unsigned direction : 2;
		// bit[13] : speed
		unsigned  speed : 1;
		// bit[14] : skip (1->skip this ED)
		unsigned  skip : 1;
		// bit[15] : format (0->gTD, 1->isoTD)
		unsigned  format : 1;		
		// bit[26:16] : maximum packet size
		unsigned mps : 11;
		// bit[31:27] : 
		unsigned reserved31_27 : 5;
	}b;
}ed_info_t;

typedef struct 
{
	ed_info_t ed_info;
	u32 tail_td_ptr;
	u32 head_td_ptr;
	u32 next_ed;
}ohci_ed_t, *ohci_ed_t_ptr;

typedef union 
{
	u32 data;
	struct {
		// bit[17:0] : 
		unsigned reserved17_0 : 18;
		// bit[18] : buffer rounding (0->exactly fill the defined buffer, 1->may be smaller than the defined buffer)
		unsigned  buffer_rounding : 1;
		// bit[20:19] : pid (0->setup, 1->out, 2->in, 3->reserved)
		unsigned pid : 2;
		// bit[23:21] : delay interrupt
		unsigned delay_interrupt : 3;
		// bit[25:24] : data toggle
		unsigned data_toggle : 2;
		// bit[27:26] : error count
		unsigned error_count : 2;
		// bit[31:28] : condition code
		unsigned condition_code : 4;
	}b;
}gtd_info_t;

typedef struct 
{
	gtd_info_t gtd_info;
	u32 current_buf_ptr;
	u32 next_td;
	u32 buffer_end;
}ohci_gtd_t, *ohci_gtd_t_ptr;

//==================================================================
// prototypes of API functions
void USBHOST_Init(void);

void USBHOST_HandleEvent(void);
void USBHOST_HandleEhciEvent(void);
void USBHOST_HandleOhciEvent(void);


//-------------------------------------------------------------------------------------
// prototypes of sub functions
void USBHOST_InitPhyCon(void);
void USBHOST_InitEhciCon(void);
void USBHOST_InitOhciCon(void);
void USBHOST_WaitEhciHcHalted(void);
void USBHOST_WaitCableInsertion(void);
void USBHOST_EhciPortReset(USB_EP_SPEED *eUsbEpSpeed);
void USBHOST_OhciPortReset(void);
void USBHOST_PortOwnerChange(USB_PORT_OWNER ePortOwner);

void USBHOST_EhciWaitEhciStateChange(EHCI_STATE eEhciState);
void USBHOST_OhciWaitEhciStateChange(OHCI_STATE eOhciState);


void USBHOST_EhciEnumerate(void);
void USBHOST_OhciEnumerate(void);
u32 USBHOST_AllocateDataStructure(u32 uSize, u32 uAlign);

void USBHOST_EhciEnableAsyncSched(void);
void USBHOST_EhciDisableAsyncSched(void);

void USBHOST_OhciEnableList(u8 bControl, u32 uListAddr, u32 uLastTdAddr);
void USBHOST_OhciDisableList(u8 bControl);

u8 USBHOST_CheckDeviceEnumerated(void);
u8 USBHOST_CheckSamsungAP(void);

void USBHOST_ParseDeviceInform(void);
void USBHOST_DisplayDeviceInform(void);

void USBHOST_TestBulkOut(u32 uAddr, u32 uSize);
void USBHOST_TestBulkIn(u32 uAddr, u32 uSize);

void USBHOST_EnterTestMode(USB_PORT_TEST eTestMode);
void USBHOST_ExitTestMode(void);


#ifdef __cplusplus
}
#endif

#endif //__USBHOST_H__
