#include <stdio.h>
#include  <string.h>
#include "def.h"
//#include "sdhc.h"
#include "gpio.h"
#include "option.h"
#include "tx_tsi.h"

#define TX_TSI_BUFFER_BASE	(CODEC_MEM_ST+0x01000000)
#define TX_TSI_SMALL_BUFFER_BASE	(TX_TSI_BUFFER_BASE -(47*4*2))

extern TX_TSI_SIGNAL TxTsiSignal;
static u32 uFileSize;			// byte

/*
typedef struct {
	void (*func)(void); 
	const char *desc;
} FUNC_MENU;
*/

static void SetTsiSignal(void)
{
	u32 sel;

	Disp("Now, TSI signal setting value.\n");
	if(TxTsiSignal.TX_TS_CLK==eRising_Edge) Disp("TS_CLK : Rising_Edge\n");
	else	Disp("TS_CLK : Falling_Edge\n");
	if(TxTsiSignal.TX_TS_SYNC==e1Bit_TsSync) Disp("TS_SYNC : 1-Bit TS_SYNC\n");
	else	Disp("TS_SYNC : 8-Bit TS_SYNC\n");
	if(TxTsiSignal.TX_TS_VALID==eActive_Low) Disp("TS_VALID : Active_Low\n");
	else	Disp("TS_VALID : Active_High\n");
	if(TxTsiSignal.TX_TS_ERROR==eActive_Low) Disp("TS_ERROR : Active_Low\n");
	else	Disp("TS_ERROR : Active_High\n");
	Disp("TS_CLK duration delay : %d\n", TxTsiSignal.uDelay);

	Disp("Skip: 0, No skip: 1\n");
	sel = UART_GetIntNum();

	if(sel==1)
	{

	while(1)
	{
		Disp("TS_CLK : \n");
		Disp("0: Skip,	1: Rising_Edge,	2: Falling_Edge\n");
		sel =UART_GetIntNum();
		if(sel==0) break;
		else if(sel==1)	{TxTsiSignal.TX_TS_CLK = eRising_Edge; break;}	
		else if(sel==2)	{TxTsiSignal.TX_TS_CLK = eFalling_Edge; break;}	
		else	Disp("Wrong number!\n");	
	}
	while(1)
	{
		Disp("TS_SYNC : \n");
		Disp("0: Skip,	1: 1-Bit TS_SYNC,	2: 8-Bit TS_SYNC\n");
		sel =UART_GetIntNum();
		if(sel==0) break;
		else if(sel==1)	{TxTsiSignal.TX_TS_SYNC = e1Bit_TsSync; break;}	
		else if(sel==2)	{TxTsiSignal.TX_TS_SYNC = e8Bit_TsSync; break;}	
		else	Disp("Wrong number!\n");	
	}
	while(1)
	{
		Disp("TS_VALID : \n");
		Disp("0: Skip,	1: Active_Low,	2: Active_High\n");
		sel =UART_GetIntNum();
		if(sel==0) break;
		else if(sel==1)	{TxTsiSignal.TX_TS_VALID = eActive_Low; break;}	
		else if(sel==2)	{TxTsiSignal.TX_TS_VALID = eActive_High; break;}	
		else	Disp("Wrong number!\n");	
	}
	while(1)
	{
		Disp("TS_ERROR : \n");
		Disp("0: Skip,	1: Active_Low,	2: Active_High\n");
		sel =UART_GetIntNum();
		if(sel==0) break;
		else if(sel==1)	{TxTsiSignal.TX_TS_ERROR = eActive_Low; break;}	
		else if(sel==2)	{TxTsiSignal.TX_TS_ERROR = eActive_High; break;}	
		else	Disp("Wrong number!\n");	
	}
	while(1)
	{
		Disp("TS_CLK duration delay : \n");
		Disp("0: Skip,	1: change delay\n");
		sel =UART_GetIntNum();
		if(sel==0) break;
		else if(sel==1)	
		{			
			TxTsiSignal.uDelay = UART_GetIntNum(); break;
		}	
		else	Disp("Wrong number!\n");	
	}	

	Disp("Now, TSI signal changing the setting value.\n");
	if(TxTsiSignal.TX_TS_CLK==eRising_Edge) Disp("TS_CLK : Rising_Edge\n");
	else	Disp("TS_CLK : Falling_Edge\n");
	if(TxTsiSignal.TX_TS_SYNC==e1Bit_TsSync) Disp("TS_SYNC : 1-Bit TS_SYNC\n");
	else	Disp("TS_SYNC : 8-Bit TS_SYNC\n");
	if(TxTsiSignal.TX_TS_VALID==eActive_Low) Disp("TS_VALID : Active_Low\n");
	else	Disp("TS_VALID : Active_High\n");
	if(TxTsiSignal.TX_TS_ERROR==eActive_Low) Disp("TS_ERROR : Active_Low\n");
	else	Disp("TS_ERROR : Active_High\n");
	Disp("TS_CLK duration delay : %d\n", TxTsiSignal.uDelay);
	}
}

static void SendTsiSignals(void)
{
	u32 i, uSrcAddr, uTsiStreamSize, uTsiStreamNum, uExit;

	uExit = 0;
	
	uTsiStreamSize = uFileSize; 		// 

	uTsiStreamNum = uTsiStreamSize/(47*4);
		
	TTSI_InitIp();

//	while(!GetKey())
//	{
		uSrcAddr = TX_TSI_BUFFER_BASE;
		for(i=0; i < uTsiStreamNum; i++)
		{
			TTSI_SendOnePacket(uSrcAddr);
			uSrcAddr += 47*4;
			Disp(".");
		}
//	}	
}

static void SendTsiSignalsForAgingTest(void)
{
	u32 i, uSrcAddr, uTsiStreamSize, uTsiStreamNum, uExit;

	uExit = 0;
	
	uTsiStreamSize = uFileSize; 		// 

	uTsiStreamNum = uTsiStreamSize/(47*4);
		
	TTSI_InitIp();
	
	UART_Printf("If you want to exit, please press any key\n");	
	while(!UART_GetKey())
	{
		uSrcAddr = TX_TSI_BUFFER_BASE;
		for(i=0; i < uTsiStreamNum; i++)
		{
			TTSI_SendOnePacket(uSrcAddr);
			uSrcAddr += 47*4;
			Disp(".");
		}
	}	
}

static void LoadTsiStreams(void)
{
//	uFileSize = LoadFromFile("..\stream\data.ts", TX_TSI_BUFFER_BASE);
	uFileSize = 10152;
	Disp("Completed. File Size(byte) : %x\n", uFileSize);
}

static void DumpTsiStreams(void)
{
	u32 i,j;

	for(i=0; i<47*4*2; i++)
	{
		if((i%16==0)||(i==0))
		Disp("\n0x%08x:  ", (TX_TSI_BUFFER_BASE+i));
		Disp("%02x ", *(u8 *)(TX_TSI_BUFFER_BASE+i));
	}	

	Disp("\n");
}

static void LoadRandomTsiStream(void)
{
	u32 i;

	*(u8 *)(TX_TSI_SMALL_BUFFER_BASE + 0) = 0x47; 

	for(i=1; i<47*4*1; i++)
	{
		*(u8 *)(TX_TSI_SMALL_BUFFER_BASE + i) = rand(); 
	}	

}

static void DumpTsiOneStream(void)
{
	u32 i,j;

	for(i=0; i<47*4*2; i++)
	{
		if((i%16==0)||(i==0))
		Disp("\n0x%08x:  ", (TX_TSI_SMALL_BUFFER_BASE+i));
		Disp("%02x ", *(u8 *)(TX_TSI_SMALL_BUFFER_BASE+i));
	}	

	Disp("\n");
}

static void ClearTxTsiBuffer(void)
{
	u32 i;

	for(i=0; i<47*4*2; i++)
	*(u8 *)(TX_TSI_SMALL_BUFFER_BASE+i) = 0;

}

static void SendTsiOneSignal(void)
{
	u32 i, uSrcAddr, uTsiStreamSize, uTsiStreamNum;
	
	uTsiStreamSize = 47*4*1; 		// 

	uTsiStreamNum = uTsiStreamSize/(47*4);
		
	TTSI_InitIp();

	while(!UART_GetKey())
	{
		uSrcAddr = TX_TSI_SMALL_BUFFER_BASE;
		for(i=0; i < uTsiStreamNum; i++)
		{
			TTSI_SendOnePacket(uSrcAddr);
			uSrcAddr += 47*4;
		}

		Delay(100);
	}	
}

static void SendTsiSignalsForPsuf(void)
{
	u32 i, uSrcAddr, uTsiStreamSize, uTsiStreamNum, uExit, uNum;

	Disp("Input the number of packet that you want to happen the psuf error: ");
	uNum = UART_GetIntNum();

	uExit = 0;
	
	uTsiStreamSize = uFileSize; 		// 

	uTsiStreamNum = uTsiStreamSize/(47*4);
		
	TTSI_InitIp();

//	while(!GetKey())
//	{
		uSrcAddr = TX_TSI_BUFFER_BASE;
		for(i=0; i < uTsiStreamNum; i++)
		{
			if(uNum==i ||i==3 || i==5)
			TTSI_SendOnePacketForPsuf(TX_TSI_SMALL_BUFFER_BASE);			
			else
			{
			TTSI_SendOnePacket(uSrcAddr);
			uSrcAddr += 47*4;
			}
		//	Disp(".");
		}
//	}	
}

static void SendTsiSignalsForPsof(void)
{
	u32 i, uSrcAddr, uTsiStreamSize, uTsiStreamNum, uExit, uNum;

	Disp("Input the number of packet that you want to happen the psuf error: ");
	uNum = UART_GetIntNum();

	uExit = 0;
	
	uTsiStreamSize = uFileSize; 		// 

	uTsiStreamNum = uTsiStreamSize/(47*4);
		
	TTSI_InitIp();

//	while(!GetKey())
//	{
		uSrcAddr = TX_TSI_BUFFER_BASE;
		for(i=0; i < uTsiStreamNum; i++)
		{
			if(uNum==i ||i==3 || i==5)
			TTSI_SendOnePacketForPsof(TX_TSI_SMALL_BUFFER_BASE);			
			else
			{
			TTSI_SendOnePacket(uSrcAddr);
			uSrcAddr += 47*4;
			}
		//	Disp(".");
		}
//	}	
}


void Test_TxTsi(void)
{
	int i, sel;
	const testFuncMenu menu[] =
	{
		0,    		         	  		"Exit",
		SetTsiSignal,				"Set TSI signals",		
		LoadTsiStreams,			"Load TSI Streams",
		DumpTsiStreams,			"Dump TSI Streams",
		SendTsiSignals,			"Send TSI signals",	
		SendTsiSignalsForAgingTest,	"Send TSI signals For Aging Test",			
		SendTsiSignalsForPsuf,		"Send TSI signals for psuf",		
		SendTsiSignalsForPsof,		"Send TSI signals for psof",					
		ClearTxTsiBuffer,			"Clear TX TSI Buffer",		
		LoadRandomTsiStream,		"Load Random TSI Stream",
		DumpTsiOneStream,		"Dump TSI One Stream",		
		SendTsiOneSignal,			"Send TSI one signal",			
		0, 0
	};


	TTSI_SetTsiSignalByDefault();
 
	while(1)
	{
		Disp("\n");
		for (i=0; (int)(menu[i].desc)!=0; i++)
			Disp("%2d: %s\n", i, menu[i].desc);

		Disp("\nSelect the function to test : ");
		sel = UART_GetIntNum();
		Disp("\n");
		if(sel==0)break;
		if (sel>0 && sel<(sizeof(menu)/8-1))
			(menu[sel].func) ();
	}
}


