
#ifndef __TX_TSI_H__
#define __TX_TSI_H__

#include "system.h"
//#include "dma.h"

typedef enum
{
	eRising_Edge=0,
	eFalling_Edge=1
} CLK_EDGE;

typedef enum
{
	eActive_Low=0,
	eActive_High=1
} ACTIVE_STATUS;

typedef enum
{
	eNo_TsSync=0,
	e1Bit_TsSync=1,
	e8Bit_TsSync=3
} SYNC_STATUS;

typedef struct
{
	CLK_EDGE TX_TS_CLK;
	SYNC_STATUS TX_TS_SYNC;
	ACTIVE_STATUS TX_TS_VALID;
	ACTIVE_STATUS TX_TS_ERROR;
	u32 uDelay;
} TX_TSI_SIGNAL;

extern TX_TSI_SIGNAL TxTsiSignal;

void TTSI_InitSignal(void);
void TTSI_InitIp(void);
void TTSI_SendByte(CLK_EDGE eClk_Edge, SYNC_STATUS eSync_Active, ACTIVE_STATUS eValid_Active, ACTIVE_STATUS eError_Active, u8 uData, u32 uByteOder, u32 uDelay);
void TTSI_SendOnePacket(u32 uTsiStreamBase);
void TTSI_SetTsiSignalByDefault(void);
void TTSI_SendOnePacketForPsuf(u32 uTsiStreamBase);
void TTSI_SendOnePacketForPsof(u32 uTsiStreamBase);
void TTSI_SendByteForPsuf(CLK_EDGE eClk_Edge, SYNC_STATUS eSync_Active, ACTIVE_STATUS eValid_Active, ACTIVE_STATUS eError_Active, u8 uData, u32 uByteOder, u32 uDelay);
void TTSI_SendByteForPsof(CLK_EDGE eClk_Edge, SYNC_STATUS eSync_Active, ACTIVE_STATUS eValid_Active, ACTIVE_STATUS eError_Active, u8 uData, u32 uByteOder, u32 uDelay);

#endif //__TX_TSI_H__
