#include <stdio.h>
#include  <string.h>
#include "intc.h"
#include "tx_tsi.h"
#include "gpio.h"

#ifndef DBG_TTSI
#define ttsiDbg(x) Dbg x
#else
#define ttsiDbg(x)    0
#endif
/*
#ifndef DISP_TTSI_REG
#define TtsiOutp32(offset, x) Outp32(TSI_BASE+offset, x)
#define TtsiInp32(offset, x) Inp32(TSI_BASE+offset, x)
#else
#define TtsiOutp32(offset, x) Disp("Outp1w(\'h%08X, \'h%08x);\n", TSI_BASE+offset, x), Outp32(TSI_BASE+offset, x)
#define TtsiInp32(offset, x) (Disp("Inp1w (\'h%08x); ", TSI_BASE+offset), Inp32(TSI_BASE+offset, x), Disp("// d=0x%08x\n", x))
#endif
*/

#define TSI_CLK	eGPIO_2
#define TSI_SYNC	eGPIO_3
#define TSI_VALID	eGPIO_4
#define TSI_DATA	eGPIO_5
#define TSI_ERROR	eGPIO_6

TX_TSI_SIGNAL TxTsiSignal;

/******************************************************************************
*					TX TSI I/O Functions									
 ******************************************************************************/	

void TTSI_InitSignal(void)
{
	GPIO_SetDataEach(eGPIO_J0, eGPIO_2, 0x0);		
	GPIO_SetDataEach(eGPIO_J0, eGPIO_3, 0x0);
	GPIO_SetDataEach(eGPIO_J0, eGPIO_4, 0x0);
	GPIO_SetDataEach(eGPIO_J0, eGPIO_5, 0x0);
	GPIO_SetDataEach(eGPIO_J0, eGPIO_6, 0x0);
}

void TTSI_InitIp(void)
{
	GPIO_Init();
	GPIO_SetFunctionEach(eGPIO_J0, eGPIO_2, 0x1);		// set GPJ0_2 output for ts_clk
	GPIO_SetFunctionEach(eGPIO_J0, eGPIO_3, 0x1);		// set GPA3 output for ts_sync
	GPIO_SetFunctionEach(eGPIO_J0, eGPIO_4, 0x1);		// set GPA4 output for ts_val
	GPIO_SetFunctionEach(eGPIO_J0, eGPIO_5, 0x1);		// set GPA5 output for ts_data
	GPIO_SetFunctionEach(eGPIO_J0, eGPIO_6, 0x1);		// set GPA6 output for ts_error

	TTSI_InitSignal();	// Tx TSI All signal low 	
}

void TTSI_SendByte(CLK_EDGE eClk_Edge, SYNC_STATUS eSync_Active, ACTIVE_STATUS eValid_Active, ACTIVE_STATUS eError_Active, u8 uData, u32 uByteOder, u32 uDelay)
{
	u32 i;
	
	for(i=0; i < 8; i++)
	{
		GPIO_SetDataEach(eGPIO_J0, TSI_CLK, eClk_Edge);
		if(((eSync_Active==e1Bit_TsSync)&&(i==0)&&(uByteOder==0))||((eSync_Active==e8Bit_TsSync)&&(uByteOder==0)))
			GPIO_SetDataEach(eGPIO_J0, TSI_SYNC, eSync_Active&1);
		//	GPIO_SetDataEach(eGPIO_J0, TSI_SYNC, 0);
		else
			GPIO_SetDataEach(eGPIO_J0, TSI_SYNC, 0);			
		//	GPIO_SetDataEach(eGPIO_J0, TSI_SYNC, 1);			
		GPIO_SetDataEach(eGPIO_J0, TSI_DATA, (uData>>(7-i))&1);
		Delay(uDelay);	// 10
		GPIO_SetDataEach(eGPIO_J0, TSI_CLK, (~eClk_Edge)&0x1);
		Delay(uDelay);
	}
}

void TTSI_SendByteForPsuf(CLK_EDGE eClk_Edge, SYNC_STATUS eSync_Active, ACTIVE_STATUS eValid_Active, ACTIVE_STATUS eError_Active, u8 uData, u32 uByteOder, u32 uDelay)
{
	u32 i;
	
	for(i=0; i < 8; i++)
	{
		GPIO_SetDataEach(eGPIO_J0, TSI_CLK, eClk_Edge);
		if(((eSync_Active==e1Bit_TsSync)&&(i==0)&&(uByteOder==0))||((eSync_Active==e8Bit_TsSync)&&(uByteOder==0))||((eSync_Active==e1Bit_TsSync)&&(i==3)&&(uByteOder==7)))
			GPIO_SetDataEach(eGPIO_J0, TSI_SYNC, eSync_Active&1);
		//	GPIO_SetDataEach(eGPIO_J0, TSI_SYNC, 0);
		else
			GPIO_SetDataEach(eGPIO_J0, TSI_SYNC, 0);			
		//	GPIO_SetDataEach(eGPIO_J0, TSI_SYNC, 1);			
		GPIO_SetDataEach(eGPIO_J0, TSI_DATA, (uData>>(7-i))&1);
		Delay(uDelay);	// 10
		GPIO_SetDataEach(eGPIO_J0, TSI_CLK, (~eClk_Edge)&0x1);
		Delay(uDelay);
	}
}

void TTSI_SendByteForPsof(CLK_EDGE eClk_Edge, SYNC_STATUS eSync_Active, ACTIVE_STATUS eValid_Active, ACTIVE_STATUS eError_Active, u8 uData, u32 uByteOder, u32 uDelay)
{
	u32 i;
	
	for(i=0; i < 8; i++)
	{
		GPIO_SetDataEach(eGPIO_J0, TSI_CLK, eClk_Edge);
		if(((eSync_Active==e1Bit_TsSync)&&(i==0)&&(uByteOder==0))||((eSync_Active==e8Bit_TsSync)&&(uByteOder==0)))
		//	GPIO_SetDataEach(eGPIO_J0, TSI_SYNC, eSync_Active&1);
			GPIO_SetDataEach(eGPIO_J0, TSI_SYNC, 0);
		else
			GPIO_SetDataEach(eGPIO_J0, TSI_SYNC, 0);			
		//	GPIO_SetDataEach(eGPIO_J0, TSI_SYNC, 1);			
		GPIO_SetDataEach(eGPIO_J0, TSI_DATA, (uData>>(7-i))&1);
		Delay(uDelay);	// 10
		GPIO_SetDataEach(eGPIO_J0, TSI_CLK, (~eClk_Edge)&0x1);
		Delay(uDelay);
	}
}

void TTSI_SendOnePacket(u32 uTsiStreamBase)
{
	u32 i;
	u8 uSrcData;

	GPIO_SetDataEach(eGPIO_J0, TSI_VALID, TxTsiSignal.TX_TS_VALID);
	GPIO_SetDataEach(eGPIO_J0, TSI_ERROR, ~(TxTsiSignal.TX_TS_ERROR)&1);		
	for(i=0; i < 47*4; i++)
	{
		uSrcData = *(u8 *)(uTsiStreamBase+i);
		TTSI_SendByte(TxTsiSignal.TX_TS_CLK, TxTsiSignal.TX_TS_SYNC, TxTsiSignal.TX_TS_VALID, TxTsiSignal.TX_TS_ERROR, uSrcData, i, TxTsiSignal.uDelay);	
	}
	GPIO_SetDataEach(eGPIO_J0, TSI_VALID, ~(TxTsiSignal.TX_TS_VALID)&1);
	GPIO_SetDataEach(eGPIO_J0, TSI_ERROR, TxTsiSignal.TX_TS_ERROR);	
}

void TTSI_SendOnePacketForPsuf(u32 uTsiStreamBase)
{
	u32 i;
	u8 uSrcData;

	GPIO_SetDataEach(eGPIO_J0, TSI_VALID, TxTsiSignal.TX_TS_VALID);
	GPIO_SetDataEach(eGPIO_J0, TSI_ERROR, ~(TxTsiSignal.TX_TS_ERROR)&1);		
	for(i=0; i < (47*4-1); i++)
	{
		uSrcData = *(u8 *)(uTsiStreamBase+i);
		TTSI_SendByte(TxTsiSignal.TX_TS_CLK, TxTsiSignal.TX_TS_SYNC, TxTsiSignal.TX_TS_VALID, TxTsiSignal.TX_TS_ERROR, uSrcData, i, TxTsiSignal.uDelay);	
	}
	GPIO_SetDataEach(eGPIO_J0, TSI_VALID, ~(TxTsiSignal.TX_TS_VALID)&1);
	GPIO_SetDataEach(eGPIO_J0, TSI_ERROR, TxTsiSignal.TX_TS_ERROR);	
}


/*
void TTSI_SendOnePacketForPsuf(u32 uTsiStreamBase)
{
	u32 i;
	u8 uSrcData;

	GPIO_SetDataEach(eGPIO_J0, TSI_VALID, TxTsiSignal.TX_TS_VALID);
	GPIO_SetDataEach(eGPIO_J0, TSI_ERROR, ~(TxTsiSignal.TX_TS_ERROR)&1);		
	for(i=0; i < (47*4); i++)
	{
		uSrcData = *(u8 *)(uTsiStreamBase+i);
		TTSI_SendByteForPsuf(TxTsiSignal.TX_TS_CLK, TxTsiSignal.TX_TS_SYNC, TxTsiSignal.TX_TS_VALID, TxTsiSignal.TX_TS_ERROR, uSrcData, i, TxTsiSignal.uDelay);	
	}
	GPIO_SetDataEach(eGPIO_J0, TSI_VALID, ~(TxTsiSignal.TX_TS_VALID)&1);
	GPIO_SetDataEach(eGPIO_J0, TSI_ERROR, TxTsiSignal.TX_TS_ERROR);	
}
*/

void TTSI_SendOnePacketForPsof(u32 uTsiStreamBase)
{
	u32 i;
	u8 uSrcData;

	GPIO_SetDataEach(eGPIO_J0, TSI_VALID, TxTsiSignal.TX_TS_VALID);
	GPIO_SetDataEach(eGPIO_J0, TSI_ERROR, ~(TxTsiSignal.TX_TS_ERROR)&1);		
	for(i=0; i < (47*4); i++)
	{
		uSrcData = *(u8 *)(uTsiStreamBase+i);
		TTSI_SendByteForPsof(TxTsiSignal.TX_TS_CLK, TxTsiSignal.TX_TS_SYNC, TxTsiSignal.TX_TS_VALID, TxTsiSignal.TX_TS_ERROR, uSrcData, i, TxTsiSignal.uDelay);	
	}
	GPIO_SetDataEach(eGPIO_J0, TSI_VALID, ~(TxTsiSignal.TX_TS_VALID)&1);
	GPIO_SetDataEach(eGPIO_J0, TSI_ERROR, TxTsiSignal.TX_TS_ERROR);	
}

void TTSI_SetTsiSignalByDefault(void)
{
	TxTsiSignal.TX_TS_CLK = eRising_Edge;
	TxTsiSignal.TX_TS_SYNC = e1Bit_TsSync;
	TxTsiSignal.TX_TS_VALID = eActive_Low;
	TxTsiSignal.TX_TS_ERROR = eActive_High;
	TxTsiSignal.uDelay = 1;
}

