
#ifndef __TSI_H__
#define __TSI_H__

#include "system.h"
#include "dma.h"

//#define USING_CHANNEL_BOARD

typedef enum
{
	TS_SYNC_8_bit=0,
	TS_SYNC_1_bit=1,
	SYNC_byte_47h=2
} sync_det_mode;

typedef enum
{
	ts_error_flag=0,
	ts_error_timeout_flag=1,
	psof_flag=2,
	psuf_flag=3,
	sync_mismatch_flag=4,
	int_fifo_full_flag=5,
	output_buffer_full_flag=6,
	dma_complete_flag=7	
} tsi_int_flag;

typedef enum
{
	eFalling_Edge=0,
	eRising_Edge=1
} CLK_EDGE;

typedef enum
{
	eActive_High=0,
	eActive_Low=1		
} ACTIVE_STATUS;

typedef enum
{
	eNo_TsSync=0,
	e1Bit_TsSync=1,
	e8Bit_TsSync=3
} SYNC_STATUS;

typedef struct
{
	CLK_EDGE TSI_CLK;
	ACTIVE_STATUS TSI_SYNC;
	ACTIVE_STATUS TSI_VALID;
	ACTIVE_STATUS TSI_ERROR;
	u32 TSI_PACKET_NUM;
} TSI_SIGNAL;

typedef enum
{
	eCLK_TSI_OFF = 0,
	eCLK_TSI_ON = 1
} CLK_GATE_TSI;

extern TSI_SIGNAL TsiSignal;

/******************************************************************************
*					  TSI I/O Functions	Definition
 ******************************************************************************/
void TSI_Reset(void);
void TSI_ClearPidFilter(void);
void TSI_ClockOn(void);
void TSI_ClockOff(void);
void TSI_EnableClkTimeoutInt(void);
void TSI_DisableClkInt(void);
void TSI_SetSyncDetMode(sync_det_mode eSyncDecMode);
u32 TSI_ReadIntFlag(void);
void TSI_ClearIntFlag(tsi_int_flag eTsiIntFlag);
void TSI_InitIp(u32 uBufferAddr, u32 uStreamPacketNum);
void TSI_EnablePidFilter(void);
void TSI_AfterResetReadAllReg(void);
void TSI_ReadAllReg(void);
void TSI_TransferStream(u32 uSrcAddr, u32 uDstAddr, u32 uStreamPacketNum);
void TSI_SetGpio(void);
void TSI_CLK_GATE(CLK_GATE_TSI eClkTsiSel);
void TSI_WriteRegTsBase(u32 uBaseAddr);

#endif //__TSI_H__
