/*******************************************************************************

	File Name: tsi.c
	Description: SNAP FPGA Board TSI(VEGA) Controller Function Test Code
			    TSI(Transport Stream Interface)
   	Version:  
   	History:
             R0.0(2008.06.24): 

        Memo:
     	    
        Copyright (c) 2008 SAMSUNG Electronics.
        
********************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "def.h"
#include "option.h"
#include "util.h"
#include "v210_sfr.h"
#include "system.h"
#include "intc.h"
#include "dma.h"
#include "gpio.h"

#include "sysc.h"
#include "tsi.h"

#ifndef DBG_TSI
#define tsiDbg(x) Dbg x
#else
#define tsiDbg(x)    0
#endif

#ifndef DISP_TSI_REG
#define TsiOutp32(a, d) Outp32(a, d)
#define TsiInp32(a, d) Inp32(a, d)
#else
#define TsiOutp32(a, d) Disp("Outp1w(\'h%08X, \'h%08x);\n", a, d), Outp32(a, d)
#define TsiInp32(a, d) Inp32(a, d)
#endif

enum TSI_SFR
{
	TS_CLKCON = TSI_BASE + 0x00,
	TS_CON = TSI_BASE + 0x04,
	TS_SYNC = TSI_BASE + 0x08,
	TS_CNT = TSI_BASE + 0x0c,
	TS_BASE = TSI_BASE + 0x10,
	TS_SIZE = TSI_BASE + 0x14,
	TS_CADDR = TSI_BASE + 0x18,
	TS_INT_MASK = TSI_BASE + 0x1c,
	TS_INT = TSI_BASE + 0x20,
	TS_PID0 = TSI_BASE + 0x24,
	TS_PID1 = TSI_BASE + 0x28,
	TS_PID2 = TSI_BASE + 0x2c,
	TS_PID3 = TSI_BASE + 0x30,	
	TS_PID4 = TSI_BASE + 0x34,
	TS_PID5 = TSI_BASE + 0x38,
	TS_PID6 = TSI_BASE + 0x3c,
	TS_PID7 = TSI_BASE + 0x40,
	TS_PID8 = TSI_BASE + 0x44,
	TS_PID9 = TSI_BASE + 0x48,
	TS_PID10 = TSI_BASE + 0x4c,
	TS_PID11 = TSI_BASE + 0x50,
	TS_PID12 = TSI_BASE + 0x54,
	TS_PID13 = TSI_BASE + 0x58,
	TS_PID14 = TSI_BASE + 0x5c,
	TS_PID15 = TSI_BASE + 0x60,
	TS_PID16 = TSI_BASE + 0x64,
	TS_PID17 = TSI_BASE + 0x68,
	TS_PID18 = TSI_BASE + 0x6c,
	TS_PID19 = TSI_BASE + 0x70,
	TS_PID20 = TSI_BASE + 0x74,
	TS_PID21 = TSI_BASE + 0x78,
	TS_PID22 = TSI_BASE + 0x7c,
	TS_PID23 = TSI_BASE + 0x80,
	TS_PID24 = TSI_BASE + 0x84,
	TS_PID25 = TSI_BASE + 0x88,
	TS_PID26 = TSI_BASE + 0x8c,
	TS_PID27 = TSI_BASE + 0x90,
	TS_PID28 = TSI_BASE + 0x94,
	TS_PID29 = TSI_BASE + 0x98,
	TS_PID30 = TSI_BASE + 0x9c,
	TS_PID31 = TSI_BASE + 0xa0,
	TS_BYTE_SWAP = TSI_BASE + 0xbc,	
};

// clock controller Reg Definition
#define rCLK_GATE_IP2		0xE0100468

// Global value
TSI_SIGNAL TsiSignal;

/******************************************************************************
*					TSI I/O Functions									
 ******************************************************************************/	
void TSI_Reset(void)
{
	u32 i;
	volatile u32 uRead;

	uRead = Inp32(TS_CON);
	uRead=(uRead&~(1<<31))|(1<<31);		// Reset , Initialize all registers and states of TSI block 
	TsiOutp32(TS_CON, uRead);
}

void TSI_ClearPidFilter(void)
{
	u32 i;

	for(i=0; i<32; i++)
	{
		TsiOutp32(TS_PID0+i*4, 0);
	}
}

void TSI_ClockOn(void)
{
	volatile u32 uRead;

	uRead = Inp32(TS_CLKCON);
	uRead = (uRead&~(1<<0))|(1<<0);
	TsiOutp32(TS_CLKCON, uRead);
}

void TSI_ClockOff(void)
{
	volatile u32 uRead;

	uRead = Inp32(TS_CLKCON);
	uRead = (uRead&~(1<<0))|(0<<0);
	TsiOutp32(TS_CLKCON, uRead);
}

void TSI_EnableClkTimeoutInt(void)
{
	volatile u32 uRead;

	uRead = Inp32(TS_CON);
	uRead = (uRead&~(1<<19))|(0<<19);
	TsiOutp32(TS_CON, uRead);	

	uRead = Inp32(TS_INT_MASK);
	uRead = (uRead&~(1<<1))|(1<<1);
	TsiOutp32(TS_INT_MASK, uRead);	
}

void TSI_DisableClkInt(void)
{
	volatile u32 uRead;

	uRead = Inp32(TS_CON);
	uRead = (uRead&~(1<<19))|(1<<19);
	TsiOutp32(TS_CON, uRead);	

	uRead = Inp32(TS_INT_MASK);
	uRead = (uRead&~(1<<1))|(0<<1);
	TsiOutp32(TS_INT_MASK, uRead);	
}

void TSI_SetSyncDetMode(sync_det_mode eSyncDecMode)
{
	volatile u32 uRead;

	uRead = Inp32(TS_SYNC);
	uRead = (uRead&~(0xf<<4))|(0x0<<4);		// sync detect count
	TsiOutp32(TS_SYNC, uRead);		

	uRead = Inp32(TS_SYNC);
	uRead = (uRead&~(3<<0))|(eSyncDecMode<<0);
	TsiOutp32(TS_SYNC, uRead);	
}
	
u32 TSI_ReadIntFlag(void)
{
	volatile u32 uRead;

	uRead = Inp32(TS_INT);

	return uRead; 
}

void TSI_WriteRegTsBase(u32 uBaseAddr)
{
	TsiOutp32(TS_BASE, uBaseAddr);	
}

void TSI_ClearIntFlag(tsi_int_flag eTsiIntFlag)
{
	volatile u32 uRead;

	uRead = Inp32(TS_INT);	
	uRead = (uRead&~(1<<eTsiIntFlag))|(1<<eTsiIntFlag);	
	TsiOutp32(TS_INT, uRead);	
}

//PID: packet identifier
void TSI_EnablePidFilter(void)
{
	u32 i;
	volatile u32 uRead;

	uRead = Inp32(TS_CON);
	uRead |= 1<<7;			// pid filter enable
	TsiOutp32(TS_CON, uRead);

	#if 1
	TsiOutp32(TS_PID0, (1<<13)|(0x1fff&0x1fff));
	TsiOutp32(TS_PID1, (1<<13)|(0x1023&0x1fff));
	TsiOutp32(TS_PID31, (1<<13)|(0x0500&0x1fff));	
	#endif

	#if 0
	TsiOutp32(TS_PID1, (1<<13)|(0x1023&0x1fff));
	#endif
}

void TSI_InitIp(u32 uBufferAddr, u32 uStreamPacketNum)
{
	volatile u32 uRead;
	
	TSI_Reset();
//	TSI_ClearPidFilter();

	TsiOutp32(TS_CNT, 0x00ffffff);
	TsiOutp32(TS_BASE, uBufferAddr);
	TsiOutp32(TS_SIZE, uStreamPacketNum*47);		// 47-word is One Stream Packet Size
	TsiOutp32(TS_INT_MASK, 0xff);	

	uRead = Inp32(TS_CON);

#ifndef USING_CHANNEL_BOARD	

	//TSI FW test
	uRead = (uRead&~((1<<30)|(3<<28)|(1<<27)|(1<<26)|(3<<24)|(3<<22)|(3<<20)|(7<<16)|(0xff<<8)|(1<<7)|(1<<6)|(1<<5)|(1<<4)|(1<<3)|(1<<2))) |\
				       ((0<<30)|(0<<28)|(1<<27)|(1<<26)|(2<<24)|(2<<22)|(2<<20)|(6<<16)|(0x47<<8)|(0<<7)|(TsiSignal.TSI_ERROR<<6)|(0<<5)|(TsiSignal.TSI_VALID<<4)|(TsiSignal.TSI_SYNC<<3)|(TsiSignal.TSI_CLK<<2));
					//                                                                                                                           5[ordering],2[TS_CLK]
					//                                                                                                                           5[0:MSB/1:LSB],2[0:non-inverting/1:inverting]

					//    5[ordering: 0.MSB first],  4[TS_VALID: 0.active high],  3[TS_SYNC: 0.active high],  2[TS_CLK : 1.Inverting] : channel B/D setting
#else
// for channel B/D test
	uRead = (uRead&~((1<<30)|(3<<28)|(1<<27)|(1<<26)|(3<<24)|(3<<22)|(3<<20)|(7<<16)|(1<<7)|(1<<6)|(1<<5)|(1<<4)|(1<<3)|(1<<2))) |\
				       ((0<<30)|(0<<28)|(1<<27)|(1<<26)|(2<<24)|(2<<22)|(2<<20)|(6<<16)|(0<<7)|(0<<6)|(0<<5)|(0<<4)|(0<<3)|(1<<2));
					//                                                                                                                           5[ordering],2[TS_CLK]
					//                                                                                                                           5[0:MSB/1:LSB],2[0:non-inverting/1:inverting]

					//    5[ordering: 0.MSB first],  4[TS_VALID: 0.active high],  3[TS_SYNC: 0.active high],  2[TS_CLK : 1.Inverting] : channel B/D setting
#endif 

	TsiOutp32(TS_CON, uRead);
	TsiOutp32(TS_BYTE_SWAP, 0x01);		// enable Little endian
	
}

void TSI_ReadAllReg(void)
{
	volatile u32 uRead;
	u32 i;

	uRead = Inp32(TS_CLKCON);
		tsiDbg((" TS_CLKCON : 0x%08x\n", uRead));
	uRead = Inp32(TS_CON);
		tsiDbg((" TS_CON : 0x%08x\n", uRead));
	uRead = Inp32(TS_SYNC);
		tsiDbg((" TS_SYNC : 0x%08x\n", uRead));
	uRead = Inp32(TS_CNT);
		tsiDbg((" TS_CNT : 0x%08x\n", uRead));
	uRead = Inp32(TS_BASE);
		tsiDbg((" TS_BASE : 0x%08x\n", uRead));
	uRead = Inp32(TS_SIZE);
		tsiDbg((" TS_SIZE : 0x%08x\n", uRead));
	uRead = Inp32(TS_CADDR);
		tsiDbg((" TS_CADDR : 0x%08x\n", uRead));
	uRead = Inp32(TS_INT_MASK);
		tsiDbg((" TS_INT_MASK : 0x%08x\n", uRead));
	uRead = Inp32(TS_INT);
		tsiDbg((" TS_INT : 0x%08x\n", uRead));
	for(i=0; i<32; i++)
	{
		uRead = Inp32(TS_PID0 + i*4);
			tsiDbg((" TS_PID%d : 0x%08x\n", i, uRead));
	}

	uRead = Inp32(TS_BYTE_SWAP);
		tsiDbg((" TS_BYTE_SWAP : 0x%08x\n", uRead));

}

void TSI_AfterResetReadAllReg(void)
{
	volatile u32 uRead;
	u32 i;

	uRead = Inp32(TS_CLKCON);
		if(uRead != 0x00000002)
		tsiDbg(("The reset value of TS_CLKCON is wrong, now read : 0x%08x\n", uRead));
	uRead = Inp32(TS_CON);
		if(uRead != 0x10000000)
		tsiDbg(("The reset value of TS_CON is wrong, now read : 0x%08x\n", uRead));
	uRead = Inp32(TS_SYNC);
		if(uRead != 0x000000f0)
		tsiDbg(("The reset value of TS_SYNC is wrong, now read : 0x%08x\n", uRead));
	uRead = Inp32(TS_CNT);
		if(uRead != 0x00ffffff)
		tsiDbg(("The reset value of TS_CNT is wrong, now read : 0x%08x\n", uRead));
	uRead = Inp32(TS_BASE);
		if(uRead != 0x00000000)
		tsiDbg(("The reset value of TS_BASE is wrong, now read : 0x%08x\n", uRead));
	uRead = Inp32(TS_SIZE);
		if(uRead != 0x00000000)
		tsiDbg(("The reset value of TS_SIZE is wrong, now read : 0x%08x\n", uRead));
	uRead = Inp32(TS_CADDR);
		if(uRead != 0x00000000)
		tsiDbg(("The reset value of TS_CADDR is wrong, now read : 0x%08x\n", uRead));
	uRead = Inp32(TS_INT_MASK);
		if(uRead != 0x00000000)
		tsiDbg(("The reset value of TS_INT_MASK is wrong, now read : 0x%08x\n", uRead));
	uRead = Inp32(TS_INT);
		if(uRead != 0x00000000)
		tsiDbg(("The reset value of TS_INT is wrong, now read : 0x%08x\n", uRead));
	for(i=0; i<32; i++)
	{
		uRead = Inp32(TS_PID0 + i*4);
			if(uRead != 0x00000000)
			tsiDbg(("The reset value of TS_PID%d is wrong, now read : 0x%08x\n", i, uRead));
	}

	uRead = Inp32(TS_BYTE_SWAP);
		if(uRead != 0x00000001)
		tsiDbg(("The reset value of TS_BYTE_SWAP is wrong, now read : 0x%08x\n", uRead));

}

void TSI_WriteAllReg(void)
{
	volatile u32 uRead;
	u32 i;

	TsiOutp32(TS_CLKCON, 0xffffffff);
	TsiOutp32(TS_CON, 0x7fffffff);
	TsiOutp32(TS_SYNC, 0xffffffff);
	TsiOutp32(TS_CNT, 0xffffffff);
	TsiOutp32(TS_BASE, 0xffffffff);
	TsiOutp32(TS_SIZE, 0xffffffff);
	TsiOutp32(TS_CADDR, 0xffffffff);
	TsiOutp32(TS_INT_MASK, 0xffffffff);
	TsiOutp32(TS_INT, 0xffffffff);
	for(i=0; i<32; i++)
	{
		TsiOutp32(TS_PID0 + i*4, 0xffffffff);
	}
	
	TsiOutp32(TS_BYTE_SWAP, 0xffffffff);

}

void TSI_AfterWriteAllRegReadAllReg(void)
{
	volatile u32 uRead;
	u32 i;

	uRead = Inp32(TS_CLKCON);
		if(uRead != 0x00000001)
		tsiDbg(("The value of TS_CLKCON is wrong, now read : 0x%08x\n", uRead));
	uRead = Inp32(TS_CON);
		if(uRead != 0x7ffffffc)
		tsiDbg(("The value of TS_CON is wrong, now read : 0x%08x\n", uRead));
	uRead = Inp32(TS_SYNC);
		if(uRead != 0x000000f3)
		tsiDbg(("The value of TS_SYNC is wrong, now read : 0x%08x\n", uRead));
	uRead = Inp32(TS_CNT);
		if(uRead != 0xffffffff)
		tsiDbg(("The value of TS_CNT is wrong, now read : 0x%08x\n", uRead));
	uRead = Inp32(TS_BASE);
		if(uRead != 0xfffffffc)
		tsiDbg(("The value of TS_BASE is wrong, now read : 0x%08x\n", uRead));
	uRead = Inp32(TS_SIZE);
		if(uRead != 0x0000ffff)
		tsiDbg(("The value of TS_SIZE is wrong, now read : 0x%08x\n", uRead));
	uRead = Inp32(TS_CADDR);
		if(uRead != 0xfffffffc)
		tsiDbg(("The value of TS_CADDR is no problem,only Read register, now read : 0x%08x\n", uRead));
	uRead = Inp32(TS_INT_MASK);
		if(uRead != 0x000000ff)
		tsiDbg(("The value of TS_INT_MASK is wrong, now read : 0x%08x\n", uRead));
	uRead = Inp32(TS_INT);
		if(uRead != 0x00000080)
		tsiDbg(("The value of TS_INT is different as the condition of TS_CON, now read : 0x%08x\n", uRead));
	for(i=0; i<32; i++)
	{
		uRead = Inp32(TS_PID0 + i*4);
			if(uRead != 0x00003fff)
			tsiDbg(("The value of TS_PID%d is wrong, now read : 0x%08x\n", i, uRead));
	}

	uRead = Inp32(TS_BYTE_SWAP);
		if(uRead != 0x01)
		tsiDbg(("The value of TS_BYTE_SWAP is wrong, now read : 0x%08x\n", uRead));

}

void TSI_TransferStream(u32 uSrcAddr, u32 uDstAddr, u32 uStreamPacketNum)
{
	volatile u32 uRead;
	u32 i, temp;

	for(i=0; i < 47*4*uStreamPacketNum; i++)
	{
		*(u8 *)(uDstAddr + i) = *(u8 *)(uSrcAddr + i);

	}
}

void TSI_SetGpio(void)
{
	Outp32(0xe0200240, 0x05555500);		// 

}

void TSI_CLK_GATE(CLK_GATE_TSI eClkTsiSel)
{

	volatile u32 uRead;
	
	uRead = Inp32(rCLK_GATE_IP2);
	if(eClkTsiSel == eCLK_TSI_ON)
		uRead = (uRead & ~(1<<20)) | (1<<20);		//  CLK GATE ON
	else if(eClkTsiSel == eCLK_TSI_OFF)
		uRead = (uRead & ~(1<<20)) | (0<<20);		//  CLK GATE OFF		
	Outp32(rCLK_GATE_IP2, uRead);	
}
	
