/*----------------------------------------------------------------------
 *
 * Filename: wavefile.c
 *
 * Contents: 
 *
 * 
 *
 *
 * Copyright (c) 2003 SAMSUNG Electronics.
 *
 *----------------------------------------------------------------------
 */

//#include "stdafx.h"
#include "wavefile.h"
#include <string.h>

typedef struct
{
	char scRiffID[4];
	u32  uRiffSIZE;
	char scRiffFORMAT[4];
} RIFF;
	
typedef struct
{
	char scFmtID[4]; //4
	u32  uFmtSize; 
	
	u16  usFormatTag; 
	u16  usChannelType; 
	u32  uSampleRate;  
	u32  uAvgBytesPerSec; 
	u16  usBlockAlign; 
	u16  usBitsPerSample; 
} FMT;

typedef struct
{
	char scDataID[4]; 
	u32  uPcmSize;
} DATA;

void WAVEFILE_ParseHeader(u32 uWaveFileAddr, u32* uPcmSize, u32* uChannelType, u32* uSampleRate, u32* uBitPerSample)
{
	FMT *pFmt = (FMT*)(uWaveFileAddr + sizeof(RIFF));
	DATA *pData;

	*uChannelType = pFmt->usChannelType;	
	*uSampleRate = pFmt->uSampleRate;
	*uBitPerSample = pFmt->usBitsPerSample;

	pData = (DATA*)(uWaveFileAddr + sizeof(RIFF) + sizeof(FMT));
	*uPcmSize = pData->uPcmSize;
}

void WAVEFILE_PutHeader(u32 uWaveFileAddr, u32 uPcmSize, u32 uChannelType, u32 uSampleRate, u32 uBitPerSample)
{
	RIFF *pRiff = (RIFF*)uWaveFileAddr;
	FMT *pFmt;
	DATA *pData;

	strcpy(pRiff->scRiffID, "RIFF");
	pRiff->uRiffSIZE= uPcmSize+ sizeof(FMT) + sizeof(DATA) + 0x04;
	strcpy(pRiff->scRiffFORMAT,"WAVE");

	pFmt = (FMT*)(uWaveFileAddr + sizeof(RIFF));

	strcpy(pFmt->scFmtID,"fmt ");
	pFmt->uFmtSize= sizeof(FMT) - 0x04 - 0x04;
    pFmt->usFormatTag = 0x01;
	pFmt->usChannelType = (u16)uChannelType;
	pFmt->uSampleRate = uSampleRate;
	pFmt->uAvgBytesPerSec = (uSampleRate*uChannelType*uBitPerSample)>>3;
	pFmt->usBlockAlign = (uBitPerSample*(u16)uChannelType)>>3;
	pFmt->usBitsPerSample = (u16)uBitPerSample;

	pData = (DATA*)(uWaveFileAddr + sizeof(RIFF) + sizeof(FMT));
	
	strcpy(pData->scDataID,"data");
	pData->uPcmSize = uPcmSize;

}
