#ifndef __SPDIF_H__
#define __SPDIF_H__

#include "dma.h"
#include "def.h"

//#define DISP_SPDIF_REG

typedef enum
{
	FS_256,
	FS_384,
	FS_512,
	FS_768
} FS_SEL;

typedef enum
{
	INTERNAL_CLK,
	EXTERNAL_CLK
} CLK_SEL;

typedef enum
{
	stream_end_flag=7,
	buffer_empty_flag=9,
	user_data_flag=11,
	fifo_level_flag=16
} spdif_int_flag;

void SPDIF_InitIpForPcm(CODEC_TYPE eData, u32 uChannelType, u32 uSampleRate, u32 uBitsPerSample);
void SPDIF_InitIpForAc3(u32 uAc3DataSize, CODEC_TYPE eData, u32 uSampleRate, u32 uBitRate, u32 uFrameSizeCode);	
void SPDIF_StartPlayingPcmByDma(u32 uCurPcmAddr, u32 uPcmDataSize, CODEC_TYPE eData, u32 uChannelType, u32 uSampleRate, u32 uBitsPerSample);
void SPDIF_StartPlayingAc3ByDma(u32 uCurAc3Addr, u32 uAc3DataSize, CODEC_TYPE eData, u32 uSampleRate, u32 uBitRate, u32 uFrameSizeCode);	
void SPDIF_IntHandler(void);
void SPDIF_TurnOnSpdifoutClock(void);
void SPDIF_TurnOffSpdifoutClock(void);
void SPDIF_SetGpio(u32 uPort);
void SPDIF_SetAudioClock(u32 uSampleRate, FS_SEL eFsSel);
void SPDIF_SelectMainClock(CLK_SEL eSpdifMainClock);
void SPDIF_StartPlayingPcmByCpu(u32 uCurPcmAddr, u32 uPcmDataSize, CODEC_TYPE eData, u32 uChannelType, u32 uSampleRate, u32 uBitsPerSample);
void SPDIF_StartPlayingAc3ByCpu(u32 uCurAc3Addr, u32 uAc3DataSize, CODEC_TYPE eData, u32 uSampleRate, u32 uBitRate, u32 uFrameSizeCode);
u32 SPDIF_IsFifoFull(void);
u32 SPDIF_ReadIntFlag(void);
void SPDIF_TestInterruptByCpu(u32 uCurPcmAddr, u32 uPcmDataSize, CODEC_TYPE eData, u32 uChannelType, u32 uSampleRate, u32 uBitsPerSample);
void SPDIF_ClearIntFlag(spdif_int_flag eSpdifIntFlag);
void SPDIF_StartPlayingAc3ByDmaForInterrupt(u32 uCurAc3Addr, u32 uAc3DataSize, CODEC_TYPE eData, u32 uSampleRate, u32 uBitRate, u32 uFrameSizeCode);

#endif // __SPDIF_H__

