/*******************************************************************************

	File Name: ac3file.cpp
	Description: This was made for parsing AC3 file. 
	
   	Version: 0.0 
   	History:
             R0.0(2007): HakSong.Kim First draft

        Memo:
		  - It was not applicated as Sampling rate 96Khz.	
                
********************************************************************************/

#include "ac3file.h"
#include <string.h>
//#include "library.h"
#include "util.h"

#ifdef DBG_AC3
#define ac3Dbg(x) Dbg x
#else
#define ac3Dbg(x)    0
#endif

typedef struct
{
	u16 syncword;						// 0x0B77 Transmission of data is left bit first also known as Big Endian.
	u16 CRC;
	u8 FrameSizeCode:6;
	u8 Samplingfrequency:2;				// '11'=reserved '10'=32KHz '01'=44.1 '00'=48	
	u8 BitStreamMode:3;					// '000'=main audio service
	u8 BitStreamIdentification:5;
	u8 DolbySurroundModeLSB:1;			// '00'=not indicated '01'=Not surround encoded '10'=Yes, surround encoded
	u8 SurroundMixLevel:2;
	u8 CenterMixlevel:2;
	u8 AudioCodingMode:3;					// '010'=left, right channel ordering
	u8 DummyData:7;
	u8 DolbySurroundModeMSB:1;			// '00'=not indicated '01'=Not surround encoded '10'=Yes, surround encoded	
} AC3_HEADER_S;

#define frmsizecod_num 	0x26

static const u16 FrameSizeCode_Table[frmsizecod_num][5] =
{
		{0x00,32,96,69,64},
		{0x01,32,96,70,64},
		{0x02,40,120,87,80},
		{0x03,40,120,88,80},			
		{0x04,48,144,104,96},			
		{0x05,48,144,105,96},			
		{0x06,56,168,121,112},			
		{0x07,56,168,122,112},			
		{0x08,64,192,139,128},			
		{0x09,64,192,140,128},			
		{0x0a,80,240,174,160},			
		{0x0b,80,240,175,160},			
		{0x0c,96,288,208,192},			
		{0x0d,96,288,209,192},			
		{0x0e,112,336,243,224},			
		{0x0f,112,336,244,224},			
		{0x10,128,384,278,256},					
		{0x11,128,384,279,256},					
		{0x12,160,480,348,320},					
		{0x13,160,480,349,320},					
		{0x14,192,576,417,384},					
		{0x15,192,576,418,384},					
		{0x16,224,672,487,448},					
		{0x17,224,672,488,448},					
		{0x18,256,768,557,512},					
		{0x19,256,768,558,512},					
		{0x1a,320,960,696,640},					
		{0x1b,320,960,697,640},					
		{0x1c,384,1152,835,768},					
		{0x1d,384,1152,836,768},					
		{0x1e,448,1344,975,896},					
		{0x1f,448,1344,976,896},					
		{0x20,512,1536,1114,1024},					
		{0x21,512,1536,1115,1024},					
		{0x22,576,1728,1253,1152},					
		{0x23,576,1728,1254,1152},					
		{0x24,640,1920,1393,1280},					
		{0x25,640,1920,1394,1280}					
};

void AC3FILE_ParseHeader(u32 uAc3FileAddr,u32* uSyncword, u32* uSamplingFrq, u32* uBitRate, u32* uFrameSizeCode)
{
	AC3_HEADER_S *pAC3_HEADER_S = (AC3_HEADER_S*)(uAc3FileAddr);
	u32 i;

	*uSyncword = pAC3_HEADER_S->syncword;
	*uSyncword = ((*uSyncword & 0xff00)>>8) |((*uSyncword & 0x00ff)<<8);
	
	if(pAC3_HEADER_S->Samplingfrequency==0)
	*uSamplingFrq = 48000;
	else if(pAC3_HEADER_S->Samplingfrequency==1)
	*uSamplingFrq = 44100;
	else if(pAC3_HEADER_S->Samplingfrequency==2)
	*uSamplingFrq = 32000;
	else if(pAC3_HEADER_S->Samplingfrequency==3)
	*uSamplingFrq = 0;
	else
	Assert(0);
	
	for( i=0; i<frmsizecod_num; i++)
	{
		if(FrameSizeCode_Table[i][0] == (u16)pAC3_HEADER_S->FrameSizeCode)
			{
				*uBitRate = (u32)FrameSizeCode_Table[i][1];		// Normal Bit rate
				
				if(*uSamplingFrq == 48000)
				*uFrameSizeCode =(u32)FrameSizeCode_Table[i][4];
				else if(*uSamplingFrq == 44100)
				*uFrameSizeCode =(u32)FrameSizeCode_Table[i][3];
				else if(*uSamplingFrq == 32000)
				*uFrameSizeCode =(u32)FrameSizeCode_Table[i][2];
				else
				Assert(0);
					
				break;
			}
	}

}

