/**************************************************************************************
* 
*	Project Name : S3C6400 Validation
*
*	Copyright 2006 by Samsung Electronics, Inc.
*	All rights reserved.
*
*	Project Description :
*		This software is only for validating functions of the S3C6400.
*		Anybody can use this software without our permission.
*  
*--------------------------------------------------------------------------------------
* 
*	File Name : sdhc_test.c
*  
*	File Description : This file implements the API functon for High Speed MMC.
*
*	Author : Youngbo.song
*	Dept. : AP Development Team
*	Created Date : 08.JAN.2007
*	Version : 0.1
* 
*	History
*	 1) 1st Made
*  
**************************************************************************************/
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "def.h"
#include "option.h"
#include "library.h"
//#include "sfr6410.h"
#include "system.h"
#include "intc.h"
#include "gpio.h"
#include "sdhc.h"
#include "sysc.h"
//#include "fat.h"
#include "timer.h"
#include	"Max8698.h"

#define SDHC_TEST_CHANNEL SDHC_CHANNEL_0
#define SDHC_MOVINAND_BOOTLOAD_ADDRESS 0x50500000

//static INTC oIntc;
SDHC SDHC_descriptor;

bool SDHC_Test_autotest(void); 
bool SDHC_CH0_Test_autotest(void);
bool SDHC_CH2_Test_autotest(void);
bool SDHC_CH3_Test_autotest(void);
void SDHC_temp_test(void);

/*
 * print setting values.
 */
void SDHC_DispCurrParams(void)
{
	SDHC* card = &SDHC_descriptor;
	UART_Printf("\n");

	if (card->m_eClockSource== SDHC_HCLK)
		UART_Printf(" eClkSrc = SDHC_HCLK,");
	else if (card->m_eClockSource == SDHC_EPLL)
		UART_Printf(" eClkSrc = SDHC_EPLL,");
	else if (card->m_eClockSource == SDHC_EXTCLK)
		UART_Printf("eClkSrc = SDHC_EXTCLK,");
	else
		UART_Printf("No Clock Selected.");
	UART_Printf(" SDMMC Channel = %d,      ", (u32)card->m_eChannel);
	UART_Printf(" uClkDiv = %d,      ", card->m_uClockDivision);
	UART_Printf(" uBusWidth = %d,    ", card->m_ucBandwidth);
	UART_Printf(" uStBlock = %d,   uBlocks = %d,    ", card->m_uStartBlockPos, card->m_uOneBlockSize);

	if ( card->m_eOpMode == SDHC_POLLING_MODE )
		UART_Printf("SDHC_POLLING_MODE, ");
	else if ( card->m_eOpMode == SDHC_INTERRUPT_MODE )
		UART_Printf("SDHC_INTERRUPT_MODE, ");
	else if ( card->m_eOpMode == SDHC_SDMA_MODE )
		UART_Printf("SDHC_SDMA_MODE, ");
	else if ( card->m_eOpMode == SDHC_ADMA2_MODE )
		UART_Printf("SDHC_ADMA2_MODE, ");
	else
		UART_Printf( "NO Operation Mode, " );
	UART_Printf("\n");
}


//////////
// File Name : SDHC_getBuffer
// File Description : get from mmc_test_buffer  from non-cachable area.
// Input : buffer index(per 1MB), is sequence data, clear buffer.
// Output : buffer pointer.
u32* SDHC_getBuffer(int index, u8 sequence, u8 clear) {
	u32* result, *p;
	int buffer_size = 0x800000;
	int i;
	int reqNum;

	result = (u32*)(_DRAM_BaseAddress + 0x2000000 + index * buffer_size);
	
	if ( clear == TRUE ) {
		memset( result, 0, buffer_size );
	}
	p=result;
	if ( sequence == TRUE ) {
		reqNum = (int)(rand() & 0xfffffff);	// auto offset.
		for(i=buffer_size>>2;i>0;i--) {
			*p++=reqNum++;
			//*p++ = (i&1)?(0x55555555):(0xaaaaaaaa);
		}
	}
	return result;
}




//////////
// File Name : SDHC_DataCompare
// File Description : data compare function.
// Input : source1 pointer, source2 pointer, compare size( byte size ).
// Output : NONE.
u8 SDHC_DataCompare(u32* source1, u32* source2, u32 bytes)
{	
	u32  ErrCnt = 0;
	u32 i;

	bytes = bytes >> 2;	// consider u32 type.
	for (i=0; i<bytes; i++) {
		if (*source1 != *source2) {
			if ( ErrCnt < 5 ) {
				UART_Printf("%08x=%08x <-> %08x=%08x\n", source1, *source1, source2, *source2);
			}
			ErrCnt++;
		}
		source1++;
		source2++;
	}

	if(ErrCnt == 0) {
		return TRUE;
	}
	UART_Printf("Total Error byte = %d\n",ErrCnt << 2);
	return FALSE;
}





/**
 * Single Card write-read test.
 */
void SDHC_ComplexRWTest(void)
{
	SDHC* oSdhc;
	volatile u32* uSrcAddr = SDHC_getBuffer(0, TRUE, TRUE);
	volatile u32* uDstAddr = SDHC_getBuffer(1, FALSE, TRUE);
	u32 startAddress, blockSize;
	u8 result;
	
	oSdhc = &SDHC_descriptor;

	blockSize = oSdhc->m_uOneBlockSize;
	//blockSize = 1;
	
	startAddress = oSdhc->m_uStartBlockPos;

//	Outp32( oSdhc->m_uBaseAddr+SDHC_CONTROL2, Inp32(oSdhc->m_uBaseAddr+SDHC_CONTROL2)|
//		(1<<6)|(1<<3)|(1<<2)|(1<<1)|(1<<0) );

	if (!SDHC_OpenMediaWithMode(oSdhc->m_ucBandwidth, oSdhc->m_eOpMode, oSdhc->m_eClockSource,
								oSdhc->m_uClockDivision, oSdhc->m_eChannel, oSdhc)) {
		UART_Printf(" SDHC_OpenMediaWithMode() failed !!!\n");
		return;
	}

	result = SDHC_WriteBlocks(startAddress, blockSize, (u32)uSrcAddr, oSdhc);
	if (result == TRUE)
		UART_Printf(" Writing done\n");
	else
		UART_Printf(" Writing failed !!\n");

	result = SDHC_ReadBlocks(startAddress, blockSize, (u32)uDstAddr, oSdhc);
	if (result == TRUE)
		UART_Printf(" Reading done\n" );
	else
		UART_Printf(" Reading failed !!\n");

	SDHC_CloseMedia(oSdhc);

	if (SDHC_DataCompare( uSrcAddr, uDstAddr, blockSize<<9))
		UART_Printf(" Compare Ok\n");
	else
		UART_Printf(" Mismatches !!\n");
}

/**
 * Single Card read test.
 */
void SDHC_ReadTest(void)
{
	SDHC* oSdhc;
//	volatile u32* uSrcAddr = SDHC_getBuffer(0, TRUE, TRUE);
	volatile u32* uDstAddr = SDHC_getBuffer(1, FALSE, TRUE);
	u32 startAddress, blockSize;
	u8 result;
	
	oSdhc = &SDHC_descriptor;

	blockSize = oSdhc->m_uOneBlockSize;
	//blockSize = 1;
	
	startAddress = oSdhc->m_uStartBlockPos;

//	Outp32( oSdhc->m_uBaseAddr+SDHC_CONTROL2, Inp32(oSdhc->m_uBaseAddr+SDHC_CONTROL2)|
//		(1<<6)|(1<<3)|(1<<2)|(1<<1)|(1<<0) );

	if (!SDHC_OpenMediaWithMode(oSdhc->m_ucBandwidth, oSdhc->m_eOpMode, oSdhc->m_eClockSource,
								oSdhc->m_uClockDivision, oSdhc->m_eChannel, oSdhc)) {
		UART_Printf(" SDHC_OpenMediaWithMode() failed !!!\n");
		return;
	}

	result = SDHC_ReadBlocks(startAddress, blockSize, (u32)uDstAddr, oSdhc);
	if (result == TRUE)
		UART_Printf(" Reading done\n" );
	else
		UART_Printf(" Reading failed !!\n");
	
}


void SDHC_SetStartBlock(void)
{
	int x;

	UART_Printf("Enter the starting block to test :\n");
	x = UART_GetIntNum();

	if (x != -1) {
		SDHC_descriptor.m_uStartBlockPos = x;
	}

	UART_Printf( "start Block addresss : %d\n" , SDHC_descriptor.m_uStartBlockPos );
}

void SDHC_SetBusWidth(void)
{
	u32 x;

	UART_Printf(" Enter the bus width (1, 4, 8): ");
	x = UART_GetIntNum();

	if (x == 1 || x == 4 || x == 8) {
		SDHC_descriptor.m_ucBandwidth = x;
	}
	UART_Printf ( "bus width : %d\n", SDHC_descriptor.m_ucBandwidth );
}
 


void SDHC_SetClockSource(void)
{
	u8 x;

	UART_Printf("Enter the clk source (1=HCLK, 2=SCLK_MMC, 3=EXTCLK) : ");
	x = UART_GetIntNum();

	if (x == 2) {
		SDHC_descriptor.m_eClockSource = SDHC_EPLL;
		UART_Printf ( "SDHC_EPLL select\n");
	}
	else if (x == 3) {
		SDHC_descriptor.m_eClockSource = SDHC_EXTCLK;
		UART_Printf ( "SDHC_EXTCLK select\n");
	}
	else {	// x==1 default
		SDHC_descriptor.m_eClockSource = SDHC_HCLK;
		UART_Printf ( "SDHC_HCLK select\n");
	}

/*
	SYSC_SetClkMuxState(CLKMUX_STATE_ID eId);

		
	rCLK_SRC4
	rCLK_SRC_MASK0
	rCLK_DIV4
	rCLK_GATE_IP2
	rCLK_GATE_BLOCK
	rCLK_DIV_STAT0

	eCLKMUX_MMC3_XXTI, eCLKMUX_MMC3_XUSBXTI, eCLKMUX_MMC3_SHDMI27M, eCLKMUX_MMC3_SUSBPHY0, eCLKMUX_MMC3_SUSBPHY1, eCLKMUX_MMC3_SHDMIPHY, eCLKMUX_MMC3_SMPLL, eCLKMUX_MMC3_SEPLL, eCLKMUX_MMC3_SVPLL,
	eCLKMUX_MMC2_XXTI, eCLKMUX_MMC2_XUSBXTI, eCLKMUX_MMC2_SHDMI27M, eCLKMUX_MMC2_SUSBPHY0, eCLKMUX_MMC2_SUSBPHY1, eCLKMUX_MMC2_SHDMIPHY, eCLKMUX_MMC2_SMPLL, eCLKMUX_MMC2_SEPLL, eCLKMUX_MMC2_SVPLL,
	eCLKMUX_MMC1_XXTI, eCLKMUX_MMC1_XUSBXTI, eCLKMUX_MMC1_SHDMI27M, eCLKMUX_MMC1_SUSBPHY0, eCLKMUX_MMC1_SUSBPHY1, eCLKMUX_MMC1_SHDMIPHY, eCLKMUX_MMC1_SMPLL, eCLKMUX_MMC1_SEPLL, eCLKMUX_MMC1_SVPLL,
	eCLKMUX_MMC0_XXTI, eCLKMUX_MMC0_XUSBXTI, eCLKMUX_MMC0_SHDMI27M, eCLKMUX_MMC0_SUSBPHY0, eCLKMUX_MMC0_SUSBPHY1, eCLKMUX_MMC0_SHDMIPHY, eCLKMUX_MMC0_SMPLL, eCLKMUX_MMC0_SEPLL, eCLKMUX_MMC0_SVPLL,
*/
	
}


void SDHC_SetSdClkDivisor(void)
{
	u32 x;

	UART_Printf("Enter the clk divisor ( 1,2,4,8,16,32,64,128,256) : ");
	x = UART_GetIntNum();

	if  (x==0||x == 1||x == 2||x == 4||x == 8||x == 16||x == 32||x == 64||x == 128||x == 256) {
		SDHC_descriptor.m_uClockDivision = x;
	}
	UART_Printf( "Clock divisor : %d\n", SDHC_descriptor.m_uClockDivision );
}


void SDHC_SetNumOfBlocks(void)
{
	int num;

	UART_Printf("Enter the num. of blocks to test : ");
	num = UART_GetIntNum();

	if (num != -1) {
		SDHC_descriptor.m_uOneBlockSize = num;
	}
	UART_Printf("Block size = %d\n" , SDHC_descriptor.m_uOneBlockSize );
}

void SDHC_SetOperationMode(void)
{
	int sel;

	UART_Printf(" 1: SDHC_POLLING_MODE\n");
	UART_Printf(" 2: SDHC_INTERRUPT_MODE\n");
	UART_Printf(" 3: SDHC_SDMA_MODE\n");
	UART_Printf(" 4: SDHC_ADMA2_MODE\n");
	UART_Printf("Select the op mode : ");

	sel = UART_GetIntNum();

	if (sel == 1) {
		SDHC_descriptor.m_eOpMode = SDHC_POLLING_MODE;
		UART_Printf( "SDHC_POLLING_MODE\n");
	}
	else if (sel == 2) {
		SDHC_descriptor.m_eOpMode = SDHC_INTERRUPT_MODE;
		UART_Printf( "SDHC_INTERRUPT_MODE\n");
	}
	else if (sel == 3) {
		SDHC_descriptor.m_eOpMode = SDHC_SDMA_MODE;
		UART_Printf( "SDHC_SDMA_MODE\n");
	}
	else { //sel == 4
		SDHC_descriptor.m_eOpMode = SDHC_ADMA2_MODE;
		UART_Printf( "SDHC_ADMA2_MODE\n");
	}
}

void SDHC_SetPullUP(void)
{
	int selno;

	UART_Printf(" Select using Internal Pull up or Not:\n");
	UART_Printf(" 0: Disable                 1: Pull up \n");
	selno = (u32)UART_GetIntNum();
	if(selno==0)selno=eGPUDdis;
	else selno = eGPUen;
	SDHC_GPIO_PullUPDown(selno);
}

void SDHC_SetChannel(void) {
	int sel;

	UART_Printf(" 0: Channel 0\n");
	UART_Printf(" 1: Channel 1\n");
	UART_Printf(" 2: Channel 2\n");
	UART_Printf(" 3: Channel 3\n");
	UART_Printf("Select the channel: ");

	sel = (SDHC_channel)UART_GetIntNum();
	SDHC_descriptor.m_eChannel = sel;
	UART_Printf( "SDHC_CHANNEL_%x\n",sel);


#if 0
	if (sel == 1) {
		SDHC_descriptor.m_eChannel = SDHC_CHANNEL_0;
		UART_Printf( "SDHC_CHANNEL_0\n");
	}
	else if (sel == 2) {
		SDHC_descriptor.m_eChannel = SDHC_CHANNEL_1;
		UART_Printf( "SDHC_CHANNEL_1\n");
	}
	else if (sel == 3) {
		SDHC_descriptor.m_eChannel = SDHC_CHANNEL_2;
		UART_Printf( "SDHC_CHANNEL_2\n");
	}
	else if (sel == 4) {
		SDHC_descriptor.m_eChannel = SDHC_CHANNEL_3;
		UART_Printf( "SDHC_CHANNEL_2\n");
	}
	else {
		SDHC_descriptor.m_eChannel = SDHC_CHANNEL_0;
		UART_Printf( "default : SDHC_CHANNEL_0\n");
	}
#endif
	
	SDHC_SetGPIO(SDHC_descriptor.m_eChannel, SDHC_descriptor.m_ucBandwidth);
	
}

u32 SDHC_CardDetection_test(void)
{
	#if 1
	SDHC_InitCh(SDHC_descriptor.m_eChannel, 	&SDHC_descriptor);
	///  card insertion or removal  status enable
	Outp16( SDHC_descriptor.m_uBaseAddr+SDHC_NORMAL_INT_STAT_ENABLE,
		        (Inp16( SDHC_descriptor.m_uBaseAddr+SDHC_NORMAL_INT_STAT_ENABLE)) |SDHC_CARD_INSERT_SIG_INT_EN|SDHC_CARD_REMOVAL_SIG_INT_EN);

	//// Card insertion or removal interrupt enable
	Outp16( SDHC_descriptor.m_uBaseAddr+SDHC_NORMAL_INT_SIGNAL_ENABLE,
		        (Inp16( SDHC_descriptor.m_uBaseAddr+SDHC_NORMAL_INT_SIGNAL_ENABLE)) |SDHC_CARD_INSERT_SIG_INT_EN|SDHC_CARD_REMOVAL_SIG_INT_EN);

	INTC_SetVectAddr( SDHC_descriptor.m_ucIntChannelNum, SDHC_descriptor.m_fIntFn);  ///   
	INTC_Enable( SDHC_descriptor.m_ucIntChannelNum );

	UART_Printf("Insert or remove a Card...\n");
	UART_Getc();
	//while(1);
	//// Card insertion or removal interrupt disable
	Outp16( SDHC_descriptor.m_uBaseAddr+SDHC_NORMAL_INT_SIGNAL_ENABLE,
		        (Inp16( SDHC_descriptor.m_uBaseAddr+SDHC_NORMAL_INT_SIGNAL_ENABLE)) &(~(SDHC_CARD_INSERT_SIG_INT_EN|SDHC_CARD_REMOVAL_SIG_INT_EN)));	
	INTC_Disable( SDHC_descriptor.m_ucIntChannelNum );		
	#endif

	#if 0
///////////////////////////////////////
	SDHC_InitCh(SDHC_descriptor.m_eChannel, 	&SDHC_descriptor);
	UART_Printf("Insert or remove a Card...\n");
	Outp16( SDHC_descriptor.m_uBaseAddr+SDHC_NORMAL_INT_STAT_ENABLE,
		        (Inp16( SDHC_descriptor.m_uBaseAddr+SDHC_NORMAL_INT_STAT_ENABLE)) |SDHC_CARD_INSERT_SIG_INT_EN|SDHC_CARD_REMOVAL_SIG_INT_EN);

	while(1)
	{
if(Inp16( SDHC_descriptor.m_uBaseAddr+SDHC_NORMAL_INT_STAT) &(SDHC_CARD_INSERT_SIG_INT_EN|SDHC_CARD_REMOVAL_SIG_INT_EN))
break;

	}
	
	UART_Printf("!!!...\n");

	#endif
	return 1;

}


/*
//////////
// File Name : SDHC_SetBlockCountReg (Inline Macro)
// File Description : This function set block count register.
// Input : SDHC, block count 
// Output : NONE.
#define SDHC_SetBlockCountReg( sCh, uBlkCnt) \
	Outp16( (sCh)->m_uBaseAddr + SDHC_BLK_COUNT, (uBlkCnt) );

//////////
// File Name : SDHC_SetSystemAddressReg (Inline Macro)
// File Description : This function set DMA start address.
// Input : SDHC, start address.
// Output : NONE.
#define SDHC_SetSystemAddressReg( sCh, SysAddr) \
	Outp32( (sCh)->m_uBaseAddr + SDHC_SYS_ADDR, (SysAddr) );

//////////
// File Name : SDHC_SetBlockSizeReg (Inline Macro)
// File Description : This function set block size and buffer size.
// Input : SDHC, DMA buffer boundary, One block size.
// Output : NONE.
#define SDHC_SetBlockSizeReg( sCh, uDmaBufBoundary, uBlkSize ) \
	Outp16( (sCh)->m_uBaseAddr + SDHC_BLK_SIZE, (((uDmaBufBoundary)<<12)|(uBlkSize)) );
*/


void SDHC_Test(void)
{
	int i,sel;

	const testFuncMenu menu[]=
	{
		SDHC_ComplexRWTest,			"SDHC_ComplexRWTest",
		SDHC_SetBusWidth,				"Set uBusWidth",
		SDHC_SetStartBlock,				"Set uStBlock",
		SDHC_SetNumOfBlocks,			"Set uBlocks", 
		SDHC_SetClockSource,			"Set eClkSrc",
		SDHC_SetSdClkDivisor,			"Set uClkDiv",
		SDHC_SetOperationMode,			"Set Operation Mode",
		SDHC_SetChannel,				"Set Channel",
		SDHC_SetPullUP,				"Set Internal Pull-up",
//		SDHC_MoviBootloaderCopy,		"SDHC_MoviBootloaderCopy",
		SDHC_DispCurrParams,			"Display current parameter",
//		SDHC_CardDetection_test,		"Card detection test",
//		SDHC_Card_Interrupt_test,	"Card Interrupt test",
		SDHC_ReadTest,		 		"SDHC Read Teset",
		SDHC_CH0_Test_autotest,		 		"SDHC_CH0_Test_autotest",
		SDHC_CH2_Test_autotest,		 		"SDHC_CH2_Test_autotest",
		SDHC_CH3_Test_autotest,		"SDHC_CH3_Test_autotest",
		SDHC_temp_test,				"SDHC temp test",
		0,0
	};
	
	// EPLL_Setting.
//	SYSC_SetLockTime( eEPLL, 300);
//	SYSC_CtrlCLKOUT(eCLKOUT_EPLLOUT, 0);

	//modify by HEAD
	//SYSC_SetPLL(PLL_eTYPE  ePLL, u32 uMdiv, u32 uPdiv, u32 uSdiv, u32 uKdiv)
	//SYSC_SetPLL(eEPLL, 100, 3, 2, 0);		// EPLL => 100MHz
	//SYSC_SetPLL(eEPLL, 96, 3, 2, 0);
//	SYSC_SetPLL(eEPLL, 100, 3, 2, 0);
	//  SYSC_SetPLL() Լ վ ϴµ,
	// SDHC_IdentifyCard(SDHC* sCh), SDHC_Set_InitClock(); ȣϿ,
	// PLL Ͽ ϳ(⿡ մ°) ִܽ.
		
	//SYSC_SetPLL(eEPLL, 66, 3, 2, 0);		// EPLL => 66MHz
//	Outp32( 0x7E00F01C, 7 );

	// Turn on USB Clock.
//	*((volatile u32*)0x7E00F900) |= (1<<16);

/*
	// 1. MMC EPLL - source Setting.
	*((volatile u32*)0x7E00F01C) &= ~(0x3F<<18);
	//     Channel 0
	*((volatile u32*)0x7E00F01C) |= (0x0<<18);
	//     Channel 1
	*((volatile u32*)0x7E00F01C) |= (0x0<<20);
	//     Channel 2
	*((volatile u32*)0x7E00F01C) |= (0x0<<22);

	// 2. MMC EPLL - ratio setting.
	*((volatile u32*)0x7E00F024) &= ~(0xFFF<<0);
	//     Channel 0
	*((volatile u32*)0x7E00F024) |= (0x0<<0);
	//     Channel 1
	*((volatile u32*)0x7E00F024) |= (0x0<<4);
	//     Channel 2
	*((volatile u32*)0x7E00F024) |= (0x0<<8);

	// 3. MMC HCLK-Gate
	//     Channel 0
//	*((volatile u32*)0x7E00F030) &= ~(0x1<<17);
	//     Channel 1
//	*((volatile u32*)0x7E00F030) &= ~(0x1<<18);
	//     Channel 2
//	*((volatile u32*)0x7E00F030) &= ~(0x1<<19);

	// 4. MMC SCLK Gate
	//     SCLK_MMC2_48
//	*((volatile u32*)0x7E00F038) &= ~(0x1<<29);
	//     SCLK_MMC1_48
//	*((volatile u32*)0x7E00F038) &= ~(0x1<<28);
	//     SCLK_MMC0_48
//	*((volatile u32*)0x7E00F038) &= ~(0x1<<27);
	//     SCLK_MMC2
//	*((volatile u32*)0x7E00F038) &= ~(0x1<<26);
	//     SCLK_MMC1
//	*((volatile u32*)0x7E00F038) &= ~(0x1<<25);
	//     SCLK_MMC0
//	*((volatile u32*)0x7E00F038) &= ~(0x1<<24);
*/
	// initial value.
	//SDHC_descriptor.m_eChannel = SDHC_TEST_CHANNEL;

#if 1	
	SDHC_descriptor.m_eChannel = SDHC_CHANNEL_0;
	SDHC_descriptor.m_eClockSource = SDHC_EPLL;
	//SDHC_descriptor.m_eClockSource = SDHC_HCLK;
	SDHC_descriptor.m_eOpMode = SDHC_POLLING_MODE;
	SDHC_descriptor.m_uStartBlockPos =1000;// start Block address.
	SDHC_descriptor.m_ucBandwidth = 4;	// bandwidth.
	SDHC_descriptor.m_uClockDivision = 1;	// clock division
	SDHC_descriptor.m_uOneBlockSize = 1000;	// block size.

	SDHC_SetGPIO(SDHC_descriptor.m_eChannel, SDHC_descriptor.m_ucBandwidth);
	SDHC_GPIO_PullUPDown(eGPUDdis);			// pull up disable
	SDHC_GPIO_DrvStr();
	//MAX8698_SetVoltageLDO5(LDO45679_VOL_30);
#endif
	while(1)
	{
		UART_Printf("\n ----------------------------------------------\n");
		for (i=0; (int)(menu[i].desc)!=0; i++) {
			UART_Printf("%2d: %s\n", i, menu[i].desc);
		}

		SDHC_DispCurrParams();

		UART_Printf("\nSelect the function to test : ");
		sel = UART_GetIntNum();
		UART_Printf("\n");
		if(sel==-1) {
	   		break;		// return.
		}
		if (sel>=0 && sel<(sizeof(menu)/8-1)) {
			(menu[sel].func)();
		}
	}
}




bool SDHC_CH0_Test_autotest(void)
{
	SDHC* oSdhc;
	u32* uSrcAddr = SDHC_getBuffer(0, TRUE, TRUE);
	u32* uDstAddr = SDHC_getBuffer(1, FALSE, TRUE);
	u32* uBackupAddr = SDHC_getBuffer(2, FALSE, TRUE);
	u32 startAddress, blockSize;
	u8 result;


	// initial value.
	//SDHC_descriptor.m_eChannel = SDHC_TEST_CHANNEL;
	SDHC_descriptor.m_eChannel = SDHC_CHANNEL_0;
	SDHC_descriptor.m_eClockSource = SDHC_EPLL;
	//SDHC_descriptor.m_eClockSource = SDHC_HCLK;
	SDHC_descriptor.m_eOpMode = SDHC_ADMA2_MODE;
	SDHC_descriptor.m_uStartBlockPos =3200;// start Block address.
	SDHC_descriptor.m_ucBandwidth = 8;	// bandwidth.
	SDHC_descriptor.m_uClockDivision = 4;	// clock division
	SDHC_descriptor.m_uOneBlockSize = 2048;	// block size.

//	SDHC_DispCurrParams();
	

	
	oSdhc = &SDHC_descriptor;

	blockSize = oSdhc->m_uOneBlockSize;
	startAddress = oSdhc->m_uStartBlockPos;

	SDHC_InitCh(SDHC_descriptor.m_eChannel, &SDHC_descriptor);

	SDHC_SetGPIO(SDHC_descriptor.m_eChannel, SDHC_descriptor.m_ucBandwidth);

	SDHC_ResetController(&SDHC_descriptor);			//?
	SDHC_SetSdClockOnOff(0,&SDHC_descriptor);		//?
	
	SDHC_GPIO_PullUPDown(eGPUen);
	SDHC_GPIO_DrvStr();

	//SDHC_CMD_LO_HI(SDHC_descriptor.m_eChannel);



	if (!SDHC_OpenMediaWithMode(oSdhc->m_ucBandwidth, oSdhc->m_eOpMode, oSdhc->m_eClockSource,
								oSdhc->m_uClockDivision, oSdhc->m_eChannel, oSdhc)) {
		UART_Printf(" SDHC_OpenMediaWithMode() failed !!!\n");
		return false;
	}

	/* back up original data */
	result = SDHC_ReadBlocks(startAddress, blockSize, (u32)uBackupAddr, oSdhc);
	if (result == TRUE)
		UART_Printf(" Reading done\n" );
	else{
		UART_Printf(" Reading failed !!\n");
		return false;
		}

	
	result = SDHC_WriteBlocks(startAddress, blockSize, (u32)uSrcAddr, oSdhc);
	if (result == TRUE)
		UART_Printf(" Writing done\n");
	else{
		UART_Printf(" Writing failed !!\n");
		return false;
		}
	Delay(10);
	result = SDHC_ReadBlocks(startAddress, blockSize, (u32)uDstAddr, oSdhc);
	if (result == TRUE)
		UART_Printf(" Reading done\n" );
	else{
		UART_Printf(" Reading failed !!\n");
		return false;
		}

	/* recovery original data */
	result = SDHC_WriteBlocks(startAddress, blockSize, (u32)uBackupAddr, oSdhc);
	if (result == TRUE)
		UART_Printf(" Writing done\n");
	else{
		UART_Printf(" Writing failed !!\n");
		return false;
		}

	
	SDHC_CloseMedia(oSdhc);

	if (SDHC_DataCompare( uSrcAddr, uDstAddr, blockSize<<7)){
		UART_Printf(" Compare Ok\n");
		return true;
		}
	else{
		UART_Printf(" Mismatches !!\n");
		return false;
		}

}


bool SDHC_CH2_Test_autotest(void)
{
	SDHC* oSdhc;
	u32* uSrcAddr = SDHC_getBuffer(0, TRUE, TRUE);
	u32* uDstAddr = SDHC_getBuffer(1, FALSE, TRUE);
	u32* uBackupAddr = SDHC_getBuffer(2, FALSE, TRUE);
	u32 startAddress, blockSize;
	u8 result;


	// initial value.
	//SDHC_descriptor.m_eChannel = SDHC_TEST_CHANNEL;
	SDHC_descriptor.m_eChannel = SDHC_CHANNEL_2;
	SDHC_descriptor.m_eClockSource = SDHC_EPLL;
	//SDHC_descriptor.m_eClockSource = SDHC_HCLK;
	SDHC_descriptor.m_eOpMode = SDHC_ADMA2_MODE;
	SDHC_descriptor.m_uStartBlockPos =3200;// start Block address.
	SDHC_descriptor.m_ucBandwidth = 4;	// bandwidth.
	SDHC_descriptor.m_uClockDivision = 4;	// clock division
	SDHC_descriptor.m_uOneBlockSize = 2048;	// block size.

	//SDHC_DispCurrParams();
	

	
	oSdhc = &SDHC_descriptor;

	blockSize = oSdhc->m_uOneBlockSize;
	startAddress = oSdhc->m_uStartBlockPos;

	SDHC_InitCh(SDHC_descriptor.m_eChannel, &SDHC_descriptor);

	SDHC_SetGPIO(SDHC_descriptor.m_eChannel, SDHC_descriptor.m_ucBandwidth);

	SDHC_ResetController(&SDHC_descriptor);			//?
	SDHC_SetSdClockOnOff(0,&SDHC_descriptor);		//?
	
	SDHC_GPIO_PullUPDown(eGPUen);
	SDHC_GPIO_DrvStr();

	if (!SDHC_OpenMediaWithMode(oSdhc->m_ucBandwidth, oSdhc->m_eOpMode, oSdhc->m_eClockSource,
								oSdhc->m_uClockDivision, oSdhc->m_eChannel, oSdhc)) {
		UART_Printf(" SDHC_OpenMediaWithMode() failed !!!\n");
		return false;
	}

	/* back up original data */
	result = SDHC_ReadBlocks(startAddress, blockSize, (u32)uBackupAddr, oSdhc);
	if (result == TRUE)
		UART_Printf(" Reading done\n" );
	else{
		UART_Printf(" Reading failed !!\n");
		return false;
		}

	
	result = SDHC_WriteBlocks(startAddress, blockSize, (u32)uSrcAddr, oSdhc);
	if (result == TRUE)
		UART_Printf(" Writing done\n");
	else{
		UART_Printf(" Writing failed !!\n");
		return false;
		}

	result = SDHC_ReadBlocks(startAddress, blockSize, (u32)uDstAddr, oSdhc);
	if (result == TRUE)
		UART_Printf(" Reading done\n" );
	else{
		UART_Printf(" Reading failed !!\n");
		return false;
		}

	/* recovery original data */
	result = SDHC_WriteBlocks(startAddress, blockSize, (u32)uBackupAddr, oSdhc);
	if (result == TRUE)
		UART_Printf(" Writing done\n");
	else{
		UART_Printf(" Writing failed !!\n");
		return false;
		}

	
	SDHC_CloseMedia(oSdhc);

	if (SDHC_DataCompare( uSrcAddr, uDstAddr, blockSize<<7)){
		UART_Printf(" Compare Ok\n");
		return true;
		}
	else{
		UART_Printf(" Mismatches !!\n");
		return false;
		}

}
bool SDHC_Test_autotest(void)
{}
 
bool SDHC_CH3_Test_autotest(void)
{
	SDHC* oSdhc;
	u32* uSrcAddr = SDHC_getBuffer(0, TRUE, TRUE);
	u32* uDstAddr = SDHC_getBuffer(1, FALSE, TRUE);
	u32* uBackupAddr = SDHC_getBuffer(2, FALSE, TRUE);
	u32 startAddress, blockSize;
	u8 result;


	// initial value.
	//SDHC_descriptor.m_eChannel = SDHC_TEST_CHANNEL;
	SDHC_descriptor.m_eChannel = SDHC_CHANNEL_3;
	SDHC_descriptor.m_eClockSource = SDHC_EPLL;
	//SDHC_descriptor.m_eClockSource = SDHC_HCLK;
	SDHC_descriptor.m_eOpMode = SDHC_ADMA2_MODE;
	SDHC_descriptor.m_uStartBlockPos =3200;// start Block address.
	SDHC_descriptor.m_ucBandwidth = 4;	// bandwidth.
	SDHC_descriptor.m_uClockDivision = 4;	// clock division
	SDHC_descriptor.m_uOneBlockSize = 2048;	// block size.

//	SDHC_DispCurrParams();
	

	
	oSdhc = &SDHC_descriptor;

	blockSize = oSdhc->m_uOneBlockSize;
	startAddress = oSdhc->m_uStartBlockPos;

	SDHC_InitCh(SDHC_descriptor.m_eChannel, &SDHC_descriptor);

	SDHC_SetGPIO(SDHC_descriptor.m_eChannel, SDHC_descriptor.m_ucBandwidth);

	SDHC_ResetController(&SDHC_descriptor);			//?
	SDHC_SetSdClockOnOff(0,&SDHC_descriptor);		//?
	
	SDHC_GPIO_PullUPDown(eGPUen);
	SDHC_GPIO_DrvStr();



	if (!SDHC_OpenMediaWithMode(oSdhc->m_ucBandwidth, oSdhc->m_eOpMode, oSdhc->m_eClockSource,
								oSdhc->m_uClockDivision, oSdhc->m_eChannel, oSdhc)) {
		UART_Printf(" SDHC_OpenMediaWithMode() failed !!!\n");
		return false;
	}

	/* back up original data */
	result = SDHC_ReadBlocks(startAddress, blockSize, (u32)uBackupAddr, oSdhc);
	if (result == TRUE)
		UART_Printf(" Reading done\n" );
	else{
		UART_Printf(" Reading failed !!\n");
		return false;
		}

	
	result = SDHC_WriteBlocks(startAddress, blockSize, (u32)uSrcAddr, oSdhc);
	if (result == TRUE)
		UART_Printf(" Writing done\n");
	else{
		UART_Printf(" Writing failed !!\n");
		return false;
		}

	result = SDHC_ReadBlocks(startAddress, blockSize, (u32)uDstAddr, oSdhc);
	if (result == TRUE)
		UART_Printf(" Reading done\n" );
	else{
		UART_Printf(" Reading failed !!\n");
		return false;
		}

	/* recovery original data */
	result = SDHC_WriteBlocks(startAddress, blockSize, (u32)uBackupAddr, oSdhc);
	if (result == TRUE)
		UART_Printf(" Writing done\n");
	else{
		UART_Printf(" Writing failed !!\n");
		return false;
		}

	
	SDHC_CloseMedia(oSdhc);

	if (SDHC_DataCompare( uSrcAddr, uDstAddr, blockSize<<7)){
		UART_Printf(" Compare Ok\n");
		return true;
		}
	else{
		UART_Printf(" Mismatches !!\n");
		return false;
		}

}
void SDHC_temp_test(void)
{
//SDHC SDDevice;
/* SD INIT */
	SDHC* oSdhc;
	u32* uSrcAddr = SDHC_getBuffer(0, TRUE, TRUE);
	u32* uDstAddr = SDHC_getBuffer(1, FALSE, TRUE);
	u32* uBackupAddr = SDHC_getBuffer(2, FALSE, TRUE);
	u32 startAddress, blockSize;
	u8 result;


	// initial value.
	//SDHC_descriptor.m_eChannel = SDHC_TEST_CHANNEL;
	SDHC_descriptor.m_eChannel = SDHC_CHANNEL_3;
	SDHC_descriptor.m_eClockSource = SDHC_EPLL;
	//SDHC_descriptor.m_eClockSource = SDHC_HCLK;
	SDHC_descriptor.m_eOpMode = SDHC_SDMA_MODE;
	SDHC_descriptor.m_uStartBlockPos =3200;// start Block address.
	SDHC_descriptor.m_ucBandwidth = 4;	// bandwidth.
	SDHC_descriptor.m_uClockDivision = 4;	// clock division
	SDHC_descriptor.m_uOneBlockSize = 2048;	// block size.

//	SDHC_DispCurrParams();
	

	
	oSdhc = &SDHC_descriptor;

	blockSize = oSdhc->m_uOneBlockSize;
	startAddress = oSdhc->m_uStartBlockPos;

	SDHC_InitCh(SDHC_descriptor.m_eChannel, &SDHC_descriptor);

	SDHC_SetGPIO(SDHC_descriptor.m_eChannel, SDHC_descriptor.m_ucBandwidth);

	SDHC_ResetController(&SDHC_descriptor);			//?
	SDHC_SetSdClockOnOff(0,&SDHC_descriptor);		//?
	
	SDHC_GPIO_PullUPDown(eGPUen);
	SDHC_GPIO_DrvStr();
	
	
	SDHC_OpenMedia(1, &SDHC_descriptor);

	SDHC_ReadBlocks(0, 1, (u32)0x41000000, &SDHC_descriptor);


}
