#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "system.h"
#include "max8698.h"


void Test_PMIC(void);
void PMIC_InitSetting(void);
void PMIC_Buck1SetVoltage(void);
void PMIC_Buck2SetVoltage(void);
void PMIC_Buck3SetVoltage(void);
void PMIC_LDO2SetVoltage(void);
void PMIC_LDO3SetVoltage(void);
void PMIC_LDO4SetVoltage(void);
void PMIC_LDO5SetVoltage(void);
void PMIC_LDO6SetVoltage(void);
void PMIC_LDO7SetVoltage(void);
void PMIC_LDO8SetVoltage(void);
void PMIC_LDO9SetVoltage(void);

void PMIC_I2C_Aging_Test(void)
{
	s32	retVal = OK;
	
	UART_Printf("\n\n[PMIC-max8698c] V210 Default voltage ");
	UART_Printf("\n ARM 1.2V, INT 1.2V, PLL 1.1V");

	while(1)
	{
		retVal = PMIC_InitIp(MAX8698c);
		if( retVal != OK )
		{
			UART_Printf("\n[PMIC] I2C NG");
			break;
		}
		else
			UART_Printf("\n[PMIC] I2C OK");
		
		retVal = MAX8698_SetVoltageBUCK1(BUCK12_VOL_120);
		if( retVal != OK )
		{
			UART_Printf("\n[PMIC] I2C NG");
			break;
		}
		else
			UART_Printf("\n[PMIC] I2C OK");		
	};
}

void Test_PMIC(void)
{
	u32 uCountFunc=0;
	s32 uSel=0;
	u32 addr;


	const testFuncMenu g_aPMICTestFunc[]=
	{

		PMIC_InitSetting,                              "PMIC[8698c] Initial Setting",
		PMIC_Buck1SetVoltage,						   "PMIC[8698c] Buck1(ARM) voltage Setting",
		PMIC_Buck2SetVoltage,						   "PMIC[8698c] Buck2(INT) voltage Setting",		
		PMIC_Buck3SetVoltage,						   "PMIC[8698c] Buck3(Memory) voltage Setting",
		PMIC_LDO2SetVoltage, 						   "PMIC[8698c] LDO2(Alive) voltage Setting",
		PMIC_LDO3SetVoltage, 						   "PMIC[8698c] LDO3(OTG,HOST Digital) voltage Setting",
		PMIC_LDO4SetVoltage,						   "PMIC[8698c] LDO4(MIPI) voltage Setting",
		PMIC_LDO5SetVoltage,						   "PMIC[8698c] LDO5() voltage Setting",		
		PMIC_LDO6SetVoltage,						   "PMIC[8698c] LDO6() voltage Setting",
		PMIC_LDO7SetVoltage,						   "PMIC[8698c] LDO7() voltage Setting",
		PMIC_LDO8SetVoltage,						   "PMIC[8698c] LDO8() voltage Setting",
		PMIC_LDO9SetVoltage,						   "PMIC[8698c] LDO9() voltage Setting",

		PMIC_I2C_Aging_Test,                              "PMIC[8698c] I2C Aging Test",
	
		0, 0
	};

	UART_Printf("\n");
	while(1)
	{
		UART_Printf("\n\n========== PMIC(8698c) Voltage Setting =============\n\n");

		for (uCountFunc=0; (u32)(g_aPMICTestFunc[uCountFunc].desc)!=0; uCountFunc++)
			UART_Printf("%2d: %s\n", uCountFunc, g_aPMICTestFunc[uCountFunc].desc);

		UART_Printf("\nSelect the function to test : ");
		uSel = UART_GetIntNum();
		UART_Printf("\n");
		if(uSel == -1) 
			break;

		if (uSel>=0 && uSel<(sizeof(g_aPMICTestFunc)/8-1))
			(g_aPMICTestFunc[uSel].func) ();
	}

	
}


void PMIC_InitSetting(void)
{
	s32	retVal = OK;
	
	UART_Printf("\n\n[PMIC-max8698c] v210 Default voltage ");
	UART_Printf("\n ARM 1.2V, INT 1.2V, PLL 1.1V");

	retVal = PMIC_InitIp(MAX8698c);
	if( retVal == ERROR )
	{
		UART_Printf("\n [PMIC] I2C Error occurred..\n!!");
	}
}

void PMIC_Buck1SetVoltage(void)
{
	s32   sSel=0;
	u8  ucData=0;
	MAX8698_BUCK12_VOLVAL eVolVal;

	s32 retVal = OK;
	
	UART_Printf("\n\n== ARM_Buck1 Set Voltage :: \n");
	UART_Printf(" ex) 1.00V :: 5 \t 1.10V :: 7 \t 1.20V :: 9, \t 1.30V :: 11..Voltage Step :: 50mV \n");
	UART_Printf(" OFF (-1) min(0) : 0.75V, Max(15) : 1.50V, Default(9): 1.2V  \n");
	UART_Printf(" Please, enter the Number from 0 to 15 :: ");

	while (1)
	{
		sSel = UART_GetIntNum();
		if ((sSel>=-1)&&(sSel<=15))
		{
			eVolVal = (MAX8698_BUCK12_VOLVAL)sSel;
			break;
		}
	}

	retVal = MAX8698_SetVoltageBUCK1(eVolVal);
	if( retVal != OK )
		UART_Printf("\n[PMIC]VoltageBUCK1 ERROR !!! \n");
}

void PMIC_Buck2SetVoltage(void)
{
	s32 sSel=0;
	u8  ucData=0;
	MAX8698_BUCK12_VOLVAL eVolVal;
	
	s32 retVal = OK;
	
	UART_Printf("\n\n== INT_Buck2 Set Voltage :: \n");
	UART_Printf(" ex) 1.00V :: 5 \t 1.10V :: 7 \t 1.20V :: 9, \t 1.30V :: 11..Voltage Step :: 50mV \n");
	UART_Printf(" OFF (-1) min(0) : 0.75V, Max(15) : 1.50V, Default(9): 1.2V \n");
	UART_Printf(" Please, enter the Number from 0 to 15 :: ");

	while(1)
	{
		sSel = UART_GetIntNum();
		if((sSel>=-1)&&(sSel<=15))
		{
			eVolVal = (MAX8698_BUCK12_VOLVAL)sSel;
			break;
		}
	}

	retVal = MAX8698_SetVoltageBUCK2(eVolVal);
	if( retVal != OK )
		UART_Printf("\n[PMIC]VoltageBUCK2 ERROR !!! \n");
	
	retVal = MAX8698_SetVoltageBUCK2(eVolVal);
	if( retVal != OK )
		UART_Printf("\n[PMIC]VoltageBUCK2 ERROR !!! \n");
}

void PMIC_Buck3SetVoltage(void)
{
	s32 sSel=0;
	u8  ucData=0;
	MAX8698_BUCK3_VOLVAL eVolVal;

	UART_Printf("\n\n== Memory_Buck3 Set Voltage :: \n");
	UART_Printf(" ex) 1.60V :: 0 \t 1.80V :: 2 \t 1.90V :: 3...Voltage Step :: 100mV \n");
	UART_Printf(" min(0) : 1.60V, Max(20) : 3.6V, Default (2):1.8V \n");
	UART_Printf(" Please, enter the Number from 0 to 4 :: ");

	while(1)
	{
		sSel = UART_GetIntNum();
		if((sSel>=-1)&&(sSel<=4))
		{
			eVolVal = (MAX8698_BUCK3_VOLVAL)sSel;
			break;
		}
	}

	MAX8698_SetVoltageBUCK3(eVolVal);

}

void PMIC_LDO2SetVoltage(void)
{
	s32 sSel=0;
	u8	ucData=0;
	MAX8698_LDO23_VOLVAL eVolVal;
	
 UART_Printf("\n\n== LDO 2 Set Voltage :: \n");
 UART_Printf(" ex) 1.00V::4 \t1.10V(default)::6 \t 1.20V ::8...Voltage Step::50mV \n");
 UART_Printf(" min(0) : 0.80V, Max(10) : 1.30V \n");
 UART_Printf(" Please, enter the Number from 0 to 10 :: ");

	while(1)
	{
	sSel = UART_GetIntNum();
	if((sSel>=-1)&&(sSel<=10))// Voltage Limit Selection
		{
			eVolVal = (MAX8698_LDO23_VOLVAL)sSel;
			break;
		}
	}

 MAX8698_SetVoltageLDO2(eVolVal);

}



void PMIC_LDO3SetVoltage(void)
{
	s32 sSel=0;
	u8	 ucData=0;
	MAX8698_LDO23_VOLVAL eVolVal;
		
 UART_Printf("\n\n== LDO3(OTG, Host D) Set Voltage :: \n");
 UART_Printf(" ex) 1.00V :: 4 \t 1.10V :: 6 \t 1.20V :: 8...Voltage Step :: 50mV \n");
 UART_Printf(" min(0) : 0.80V, Max(10) : 1.30V \n");
 UART_Printf(" Please, enter the Number from 0 to 10 \n");

	while(1)
	{
	sSel = UART_GetIntNum();
	if((sSel>=-1)&&(sSel<=10))  // Voltage Limit Selection
		{
			eVolVal = (MAX8698_LDO23_VOLVAL)sSel;
			break;
		}
	}

 MAX8698_SetVoltageLDO3(eVolVal);

}

void PMIC_LDO4SetVoltage(void)
{
	s32 sSel=0;
	u8 ucData=0;
	MAX8698_LDO45679_VOLVAL eVolVal;
		
 UART_Printf("\n\n== LDO4(MIPI) Set Voltage :: \n");
 UART_Printf(" ex) 1.60V :: 0 \t 1.80V :: 2 \t 2.0V :: 4...Voltage Step :: 100mV \n");
 UART_Printf(" min(0) : 1.60V, Max(20) : 3.6V , Default(2) : 1.8V\n");
 UART_Printf(" Please, enter the Number from 0 to 20 :: ");

	while(1)
	{
	sSel = UART_GetIntNum();
	if((sSel>=0)&&(sSel<=14)) // Voltage Limit Selection
		{
			eVolVal = (MAX8698_LDO45679_VOLVAL)sSel;
			break;
		}	
	}

 MAX8698_SetVoltageLDO4(eVolVal);

}

void PMIC_LDO5SetVoltage(void)
{
	s32 sSel=0;
	u8	 ucData=0;
	MAX8698_LDO45679_VOLVAL eVolVal;
	
 UART_Printf("\n\n== LDO5(Aud,EXT0,1,2,MMC) Set Voltage :: \n");
 UART_Printf(" ex) 1.60V :: 0 \t 1.80V :: 2 \t 2.0V :: 4...Voltage Step :: 100mV \n");
 UART_Printf(" min(0) : 1.60V, Max(20) : 3.6V , Default(12) : 2.8V\n");
 UART_Printf(" Please, enter the Number from 0 to 20 :: ");

	while(1)
	{
	sSel = UART_GetIntNum();
	if((sSel>=0)&&(sSel<=20))  // Voltage Limit Selection
		{
			eVolVal = (MAX8698_LDO45679_VOLVAL)sSel;
			break;
		}
	}

 MAX8698_SetVoltageLDO5(eVolVal);

}

void PMIC_LDO6SetVoltage(void)
{
	s32 sSel=0;
	u8	 ucData=0;
	MAX8698_LDO45679_VOLVAL eVolVal;
	
 UART_Printf("\n\n== LDO6(Modem,MSM) Set Voltage :: \n");
 UART_Printf(" ex) 1.60V :: 0 \t 1.80V :: 2 \t 2.0V :: 4...Voltage Step :: 100mV \n");
 UART_Printf(" min(0) : 1.60V, Max(20) : 3.6V , Default(10) : 2.6V\n");
 UART_Printf(" Please, enter the Number from 0 to 20 :: ");

	while(1)
	{
	sSel = UART_GetIntNum();
	if((sSel>=0)&&(sSel<=20))  // Voltage Limit Selection
	{
		eVolVal = (MAX8698_LDO45679_VOLVAL)sSel;
		break;
	}
	}

 MAX8698_SetVoltageLDO6(eVolVal);

}

void PMIC_LDO7SetVoltage(void)
{
	s32 sSel=0;
	u8	 ucData=0;
	MAX8698_LDO45679_VOLVAL eVolVal;

 UART_Printf("\n\n== LDO7(LCD) Set Voltage :: \n");
 UART_Printf(" ex) 1.60V :: 0 \t 1.80V :: 2 \t 2.0V :: 4...Voltage Step :: 100mV \n");
 UART_Printf(" min(0) : 1.60V, Max(20) : 3.6V , Default(14) :3.0V\n");
 UART_Printf(" Please, enter the Number from 0 to 20 :: ");

	while(1)
	{
	sSel = UART_GetIntNum();
	if((sSel>=0)&&(sSel<=20))  // Voltage Limit Selection
		{
			eVolVal = (MAX8698_LDO45679_VOLVAL)sSel;
			break;
		}
	}

 MAX8698_SetVoltageLDO7(eVolVal);

}

void PMIC_LDO8SetVoltage(void)
{
	s32 sSel=0;
	u8	 ucData=0;
	MAX8698_LDO8_VOLVAL eVolVal;

 UART_Printf("\n\n== LDO8(OTG,HOST Analog) Set Voltage :: \n");
 UART_Printf(" ex) 3.0V :: 0 \t 3.3V :: 3 \t Voltage Step :: 100mV \n");
 UART_Printf(" min(0) : 3.0V, Max(6) : 3.6V , Default(3) :3.3V\n");
 UART_Printf(" Please, enter the Number from 0 to 6 :: ");

	while(1)
	{
	sSel = UART_GetIntNum();
	if((sSel>=0)&&(sSel<=6))  // Voltage Limit Selection
		{
			eVolVal = (MAX8698_LDO8_VOLVAL)sSel;
			break;
		}
	}

 MAX8698_SetVoltageLDO8(eVolVal);

}

void PMIC_LDO9SetVoltage(void)
{
	   s32 sSel=0;
	   u8  ucData=0;
	   MAX8698_LDO45679_VOLVAL eVolVal;
	   
	UART_Printf("\n\n== LDO9(DAC,ADC,SYS) Set Voltage :: \n");
	UART_Printf("ex) 1.60V::0 \t1.80V::2 \t 2.0V::4...Voltage Step::100mV \n");
	UART_Printf("min(0):1.60V, Max(20):3.6V , Default(14) :3.0V\n");
	UART_Printf(" Please, enter the Number from 0 to 20 ::");
	
	   while(1)
	   {
	   sSel = UART_GetIntNum();
	   if((sSel>=0)&&(sSel<=20))  // Voltage Limit Selection
		{
			eVolVal = (MAX8698_LDO45679_VOLVAL)sSel;
			break;
		}
	   }
	
	MAX8698_SetVoltageLDO9(eVolVal);


}


