#ifndef __MAX8698_H__
#define __MAX8698_H__

#define MAX8698_ADDR 0xcc // when SRAD pin = 0, CC/CDh is selected

typedef enum 
{
	BUCK12_VOL_OFF = -1,
	BUCK12_VOL_075 = 0, // 0.75V
	BUCK12_VOL_080,
	BUCK12_VOL_085,	
	BUCK12_VOL_090,
	BUCK12_VOL_095,	
	BUCK12_VOL_100,
	BUCK12_VOL_105,	
	BUCK12_VOL_110,
	BUCK12_VOL_115,	
	BUCK12_VOL_120, // =9, 1.2v
	BUCK12_VOL_125,	 
	BUCK12_VOL_130,
	BUCK12_VOL_135,	
	BUCK12_VOL_140, // =0xd
	BUCK12_VOL_145, // =0xe	
	BUCK12_VOL_150	  // =0xf
}MAX8698_BUCK12_VOLVAL;

typedef enum 
{
	BUCK3_VOL_OFF = -1, // turn off
	BUCK3_VOL_16 = 0, // 1.6V
	BUCK3_VOL_17,	
	BUCK3_VOL_18,
	BUCK3_VOL_19,	
	BUCK3_VOL_20,
	BUCK3_VOL_21,	
	BUCK3_VOL_22,
	BUCK3_VOL_23,	
	BUCK3_VOL_24,
	BUCK3_VOL_25,	
	BUCK3_VOL_26,
	BUCK3_VOL_27,	
	BUCK3_VOL_28,
	BUCK3_VOL_29,	
	BUCK3_VOL_30,
	BUCK3_VOL_31,
	BUCK3_VOL_32,
	BUCK3_VOL_33,
	BUCK3_VOL_34,
	BUCK3_VOL_35,
	BUCK3_VOL_36
}MAX8698_BUCK3_VOLVAL;

typedef enum 
{
	LDO23_VOL_OFF = -1, // turn off
	LDO23_VOL_080 = 0, // 0.80V
	LDO23_VOL_085,	
	LDO23_VOL_090,
	LDO23_VOL_095,	
	LDO23_VOL_100,
	LDO23_VOL_105,	
	LDO23_VOL_110,
	LDO23_VOL_115,	
	LDO23_VOL_120,
	LDO23_VOL_125,	
	LDO23_VOL_130
}MAX8698_LDO23_VOLVAL;

typedef enum 
{
	LDO45679_VOL_OFF = -1, // turn off
	LDO45679_VOL_16 = 0, // 1.6V
	LDO45679_VOL_17,	
	LDO45679_VOL_18,
	LDO45679_VOL_19,	
	LDO45679_VOL_20,
	LDO45679_VOL_21,	
	LDO45679_VOL_22,
	LDO45679_VOL_23,	
	LDO45679_VOL_24,
	LDO45679_VOL_25,	
	LDO45679_VOL_26,
	LDO45679_VOL_27,	
	LDO45679_VOL_28,
	LDO45679_VOL_29,	
	LDO45679_VOL_30,
	LDO45679_VOL_31,
	LDO45679_VOL_32,
	LDO45679_VOL_33,
	LDO45679_VOL_34,
	LDO45679_VOL_35,
	LDO45679_VOL_36
}MAX8698_LDO45679_VOLVAL;

typedef enum 
{
	LDO8_VOL_OFF = -1, // turn off
	LDO8_VOL_30 = 0, // 3.0V
	LDO8_VOL_31,	
	LDO8_VOL_32,
	LDO8_VOL_33,	
	LDO8_VOL_34,
	LDO8_VOL_35,	
	LDO8_VOL_36
}MAX8698_LDO8_VOLVAL;

typedef enum {MAX8698c, NS}PMIC_MODEL;


s32 MAX8698_SetVoltageBUCK1(MAX8698_BUCK12_VOLVAL val);
s32 MAX8698_SetVoltageBUCK2(MAX8698_BUCK12_VOLVAL val);
s32 MAX8698_SetVoltageBUCK3(MAX8698_BUCK3_VOLVAL val);
s32 MAX8698_SetVoltageLDO2(MAX8698_LDO23_VOLVAL val);
s32 MAX8698_SetVoltageLDO3(MAX8698_LDO23_VOLVAL val);
s32 MAX8698_SetVoltageLDO4(MAX8698_LDO45679_VOLVAL val);
s32 MAX8698_SetVoltageLDO5(MAX8698_LDO45679_VOLVAL val);
s32 MAX8698_SetVoltageLDO6(MAX8698_LDO45679_VOLVAL val);
s32 MAX8698_SetVoltageLDO7(MAX8698_LDO45679_VOLVAL val);
s32 MAX8698_Set8VoltageLDO8(MAX8698_LDO8_VOLVAL val);
s32 MAX8698_SetVoltageLDO9(MAX8698_LDO45679_VOLVAL val);
s32 MAX8698_Init(void);
s32 MAX8698_InitForBL1(MAX8698_BUCK12_VOLVAL varm, MAX8698_BUCK12_VOLVAL vint);

u8 PMIC_WriteByIic(u8 cSlaveAddr, u8 cAddr, u8 cData);
u32 PMIC_ReadByIic(u8 cSlaveAddr,u8 cAddr,u8 *cData);
s32 PMIC_InitIp(PMIC_MODEL eModel);

void PMIC_InitSetting(void);


#endif // __MAX8698_H__

