#include "def.h"
#include "system.h"
//#include "util.h"
#include "max8698.h"
#include "iic.h"
#include "sysc.h"
#include "i2c_pmic.h"


//#define MAX8698_ADDR 0xcc // when SRAD pin = 0, CC/CDh is selected

// Set voltage for the Buck1 (DVSARM1)
// SET1 & SET2 are all grounded, so only DVSARM1 is available for BUCK1 output
// BUCK2 can't be turned off

// Set voltage for the Buck2 (DVSINT1)
// SET3 is grounded, so only DVSINT1 is available for BUCK2 output
// BUCK2 can't be turned off

// Set voltage for the LDO2
// LDO2 can be turned off

// Set voltage for the LDO3
// LDO3 can be turned off

// Set voltage for the LDO4
// LDO4 can be turned off

// Set voltage for the LDO5
// LDO5 can be turned off

// Set voltage for the LDO6
// LDO6 can be turned off

// Set voltage for the LDO7
// LDO7 can be turned off

// Set voltage for the LDO8
// LDO8 can be turned off

// Set voltage for the LDO9
// LDO9 can be turned off

// PMIC setup at boot time (LDO8 off)

// PMIC setup at boot time (LDO8 on)

// Set voltage for the Buck3 (VCC_MEM)
// BUCK3 can be turned off

// Set voltage for the Buck1 (DVSARM1)
// SET1 & SET2 are all grounded, so only DVSARM1 is available for BUCK1 output
// BUCK2 can't be turned off when XPWRRGTON is high



///////////// IIC Control ////////////////////////////
u8 PMIC_WriteByIic(u8 cSlaveAddr, u8 cAddr, u8 cData)
{
	u8 cD[3];

#if 1
	cD[0]=(cAddr & 0xff00) >> 8;			//MSB First Address
	cD[1]=cAddr & 0xff;					//LSB Last Address
	cD[2]=cData;
	
	IIC_Set_StopSignal(true);
	IIC0_SetWrite(cSlaveAddr, cD, 3);	
#else
//KS24C080C_SLAVEADDRESS control with IIC1
	cD[0]= cAddr;
	cD[1]= cData;
	
	IIC_Set_StopSignal(true);
	IIC0_SetWrite(cSlaveAddr, cD, 2);	

#endif
	return true;
}


//for EEPRPOM random address Byte read 
//u32 IIC1_Read_EEPROM(u8 cSlaveAddr,u16 cAddr,u8 *cData)
u32 PMIC_ReadByIic(u8 cSlaveAddr,u8 cAddr,u8 *cData)
{
	u8 cD[2];


	cD[0]=(cAddr & 0xff00) >> 8;			//MSB First Address
	cD[1]=cAddr & 0xff;					//LSB Last Address 
	
	IIC_Set_StopSignal(true);
#if 1	
	IIC0_SetWrite( cSlaveAddr, &cD[0], 2);			// following EEPROM random address access procedure	
	IIC0_SetRead( cSlaveAddr, cData, 1);	
#else
//KS24C080C_SLAVEADDRESS control with IIC1
	IIC0_SetWrite(cSlaveAddr, &cAddr, 1);			// following EEPROM random address access procedure	
	IIC0_SetRead(cSlaveAddr, cData, 1);
#endif	

	
	return true;
}
//////////////////////////////////////////////////////////

 extern u32  g_PCLK ;
 extern  u32 	g_HCLK;
 extern  u32 	g_HCLKx2;

s32 PMIC_InitIp(PMIC_MODEL eModel)
{
	u8 buff[2] = {0, };

	if (eModel == MAX8698c)
	{
		// PMIC initialize...
		I2Cpmic_Init();	
		
		// PMIC Buck1,2,3 disable setting
		buff[0] = 0x00;
		buff[1] = 0x3E;		
		if (I2CPMIC_Write(MAX8698_ADDR, 2, buff) != OK)
			return ERROR;
		
		buff[0] = 0x01;
		buff[1] = 0xF0;		
		if (I2CPMIC_Write(MAX8698_ADDR, 2, buff) != OK)
			return ERROR;

		// PMIC Buck1 1.1V setting (v210) DVS1,2,3,4		
		buff[0] = 0x04;
		buff[1] = 0x99;		// 77:1.10V, 99: 1.2V , AA:1.25V(EVT 0 : 1.2V, EVT 1: 1.1V)
		if (I2CPMIC_Write(MAX8698_ADDR, 2, buff) != OK)	
			return ERROR;

		buff[0] = 0x05;
		buff[1] = 0x99;		// 77:1.10V, 99: 1.2V , AA:1.25V(EVT 0 : 1.2V, EVT 1: 1.1V)
		if (I2CPMIC_Write(MAX8698_ADDR, 2, buff) != OK)	
			return ERROR;

		buff[0] = 0x06;
		buff[1] = 0x99;		// 77:1.10V, 99: 1.2V , AA:1.25V
		if (I2CPMIC_Write(MAX8698_ADDR, 2, buff) != OK)	
			return ERROR;

		buff[0] = 0x07;
		buff[1] = 0x02;		// 02: 1.8V
		if (I2CPMIC_Write(MAX8698_ADDR, 2, buff) != OK)
			return ERROR;

		//	 v210 Alive 1.1V, C100 Alive 1.2V
		buff[0] = 0x08;
		buff[1] = 0x66;		// 66:1.10V, 88: 1.2V , AA:1.30V LDO2,3
		if (I2CPMIC_Write(MAX8698_ADDR, 2, buff) != OK)	
			return ERROR;

		buff[0] = 0x09;
		buff[1] = 0x02;		// 02:1.8V  LDO4
		if (I2CPMIC_Write(MAX8698_ADDR, 2, buff) != OK)	
			return ERROR;

		buff[0] = 0x0A;
		buff[1] = 0x0C; 	// 0C:2.8V Default value
		if (I2CPMIC_Write(MAX8698_ADDR, 2, buff) != OK) 
			return ERROR;

		buff[0] = 0x0B;
		buff[1] = 0x0A; 	
		if (I2CPMIC_Write(MAX8698_ADDR, 2, buff) != OK) 
			return ERROR;

		buff[0] = 0x0C;
		buff[1] = 0x0E; 	
		if (I2CPMIC_Write(MAX8698_ADDR, 2, buff) != OK) 
			return ERROR;

		buff[0] = 0x0D;
		buff[1] = 0x33; 	
		if (I2CPMIC_Write(MAX8698_ADDR, 2, buff) != OK) 
			return ERROR;

		buff[0] = 0x0E;
		buff[1] = 0x0E; 	
		if (I2CPMIC_Write(MAX8698_ADDR, 2, buff) != OK)
			return ERROR;

		// PMIC Deinitialize...
		I2Cpmic_DeInit();
	}
	else
	{
		UART_Printf("Error occurred..\n!!");
		while(1);
	}	
}



// Set voltage for the Buck2 (DVSint1)
// SET1.2 is grounded, so only DVSINT1 is available for BUCK1 output
// BUCK2 can't be turned off when XPWRRGTON is high

s32 MAX8698_SetVoltageBUCK1(MAX8698_BUCK12_VOLVAL val)
{
	u16 data;
	u8 buff[2] = {0,};
	u8 pReadBuffer[2] = {0, };
    	u8 i;

	I2Cpmic_Init();

	if(val == BUCK12_VOL_OFF)
	{
		buff[0] = 0x00;
		buff[1] = 0x3E; 
		UART_Printf("PWREN & Buck off -> ARM Power OFF \n");
		if (I2CPMIC_Write(MAX8698_ADDR, 2, buff) != OK)
		{
			UART_Printf("\n[I2CPMIC_Write 1]\n");
			return ERROR;
		}
	}
	else
	{
		buff[0] = 0x04;
		buff[1] = (0x00 | val<<4 |val<<0); 
		if (I2CPMIC_Write(MAX8698_ADDR, 2, buff) != OK)
		{
			UART_Printf("\n[I2CPMIC_Write 2]\n");
			return ERROR;
		}
		
		buff[0] = 0x05;
		buff[1] = (0x00 | val<<4 |val<<0); 
		if (I2CPMIC_Write(MAX8698_ADDR, 2, buff) != OK)
		{
			UART_Printf("\n[I2CPMIC_Write 3]\n");
			return ERROR;
		}
	}
	
	// read data
	buff[0] = 0x04;
	if (I2CPMIC_Write(MAX8698_ADDR, 1, buff) != OK)
	{
		UART_Printf("\n[I2CPMIC_Write 4]\n");
		return ERROR;
	}
	
	if (I2Cpmic_Read(MAX8698_ADDR, 2, pReadBuffer) != OK)
	{
		UART_Printf("I2CPMICRead() failed.\n");
		return ERROR;
	}

	for (i=0; i < 1; i++)
	{
		data = (pReadBuffer[i]&0x0F)*50+750;
		UART_Printf("Current ARM Voltage :: %d [mVoltage]",data);
		if (i % 8)
		{
			UART_Printf(" ");
		}
		else
		{
			UART_Printf("\n");
		}
	}

	I2Cpmic_DeInit();

	return	OK;
}

// Set voltage for the Buck2 (DVSint1)
// SET3 is grounded, so only DVSINT1 is available for BUCK2 output
// BUCK2 can't be turned off when XPWRRGTON is high
s32 MAX8698_SetVoltageBUCK2(MAX8698_BUCK12_VOLVAL val)
{
	u16 data;
	u8 buff[2] = {0, };
	u8 pReadBuffer[2] = {0, };
	u8 i;

	I2Cpmic_Init();

	if(val == BUCK12_VOL_OFF)
	{
		buff[0] = 0x00;
		buff[1] = 0x3E; //Buck1,2 Disable
		UART_Printf("PWREN & Buck off -> Int Power OFF \n");
		if (I2CPMIC_Write(MAX8698_ADDR, 2, buff) != OK)
			return ERROR;
	}
	else
	{
		buff[0] = 0x06;  //Buck2 Address
		buff[1] = (0x00 |  val<<4 | val<<0); 
		if (I2CPMIC_Write(MAX8698_ADDR, 2, buff) != OK)
		{
			UART_Printf("I2CPMIC_Write1() failed.\n");
			return ERROR;
		}
	}	

	// read data
	buff[0] = 0x06;
	if (I2CPMIC_Write(MAX8698_ADDR, 1, buff) != OK)
	{
		UART_Printf("I2CPMIC_Write2() failed.\n");
		return ERROR;
	}
	
	if (I2Cpmic_Read(MAX8698_ADDR, 2, pReadBuffer) != 0)
	{
		UART_Printf("I2CPMICRead() failed.\n");
		return ERROR;
	}

	for (i=0; i < 1; i++)
	{
		data = (pReadBuffer[i]&0x0F)*50+750;
		UART_Printf("Current INT Voltage :: %d [mVoltage]",data);
		if (i % 8)
		{
			UART_Printf(" ");
		}
		else
		{
			UART_Printf("\n");
		}
	}

	I2Cpmic_DeInit();

	return	OK;	
}

// Set voltage for the Buck3 (VCC_MEM)
// BUCK3 can be turned off
s32 MAX8698_SetVoltageBUCK3(MAX8698_BUCK3_VOLVAL val)
{
	u16 data;
	u8 buff[2] = {0, };
	u8 pReadBuffer[2] = {0, };
    u8 i;

	I2Cpmic_Init();

	if(val == BUCK3_VOL_OFF)
	{
		buff[0] = 0x00;
		buff[1] = 0x1E; //Buck3 Disable(Buck1,2 Disable)
		UART_Printf("PWREN & Buck off -> Memory Power OFF \n");
		if (I2CPMIC_Write(MAX8698_ADDR, 2, buff) != OK)
			return ERROR;
	}
	else
	{
		buff[0] = 0x07; //Buck3 Address
		buff[1] = (0x00 |val<<0); 
		if (I2CPMIC_Write(MAX8698_ADDR, 2, buff) != OK)
			return ERROR;	
	}

	// read data
	buff[0] = 0x07;
	if (I2CPMIC_Write(MAX8698_ADDR, 1, buff) != OK)
		return ERROR;
	if (I2Cpmic_Read(MAX8698_ADDR, 2, pReadBuffer) != 0)
	{
		UART_Printf("I2CPMICRead() failed.\n");
		return ERROR;
	}

	for (i=0; i < 1; i++)
	{
		data = (pReadBuffer[i]&0x0F)*100+1600;
		UART_Printf("Current Memory Voltage :: %d [mVoltage]",data);
		if (i % 8)
		{
			UART_Printf(" ");
		}
		else
		{
			UART_Printf("\n");
		}
	}

	return	OK;
}

// Set voltage for the LDO2
// LDO2 can be turned off
s32 MAX8698_SetVoltageLDO2(MAX8698_LDO23_VOLVAL val)
{
	u16 data;
	u8 buff[2];
	u8 pReadBuffer[0x02]={0, };
    u8 i;
	I2Cpmic_Init();



	if(val == LDO23_VOL_OFF)
	{
		//1)Enable Address Setting
			buff[0] = 0x00; 
			if (I2CPMIC_Write(MAX8698_ADDR, 1, buff) != OK)return ERROR;
			
	    //2) Buck, LDO En/Disable information Read
			if (I2Cpmic_Read(MAX8698_ADDR, 2, pReadBuffer) != 0)
			{
				UART_Printf("I2CPMICRead() failed.\n");
				return ERROR;
			}
		//3)LDO2 Disable
			buff[0] = 0x00; //L
			buff[1] = (pReadBuffer[0] & 0<<4); 
			if (I2CPMIC_Write(MAX8698_ADDR, 2, buff) != OK)return ERROR;

			UART_Printf("PWREN & Buck off -> LDO2 Power OFF \n");
	}
	else
	{	

		//1)Enable Address Setting
		buff[0] = 0x00; 
		if (I2CPMIC_Write(MAX8698_ADDR, 1, buff) != OK)return ERROR;
	    //2) LDO En/Disable information Read
			if (I2Cpmic_Read(MAX8698_ADDR, 2, pReadBuffer) != 0)
			{
				UART_Printf("I2CPMICRead() failed.\n");
				return ERROR;
			}
		//3)LDO2 enable
			buff[0] = 0x00; //L
			buff[1] = (pReadBuffer[0] | 1<<4); 
			if (I2CPMIC_Write(MAX8698_ADDR, 2, buff) != OK)return ERROR;
		// 4)LDO2 Address Setting
		buff[0] = 0x08; //LDO2 Address
		if (I2CPMIC_Write(MAX8698_ADDR, 1, buff) != OK)return ERROR;
	    // 5)LDO2/3 Setting Value Read
		if (I2Cpmic_Read(MAX8698_ADDR, 2, pReadBuffer) != 0)
		{
			UART_Printf("I2CPMICRead() failed.\n");
			return ERROR;
		}
		// 6)LDO2 Voltage Value Setting
		buff[0] = 0x08; //LDO2 Address
		buff[1] = ((pReadBuffer[0] & 0xF0) |val<<0); //
	
	if (I2CPMIC_Write(MAX8698_ADDR, 2, buff) != OK)return ERROR;	
	}
	
	// 7) LDO2 Setting Value Read
	if (I2Cpmic_Read(MAX8698_ADDR, 2, pReadBuffer) != 0)
	{
		UART_Printf("I2CPMICRead() failed.\n");
		return ERROR;
	}
		for (i=0; i < 1; i++)
		{
			data = (pReadBuffer[i]&0x0F)*50+800;
			UART_Printf("Current LDO2(Alive) Voltage :: %d [mVoltage]",data);
			if (i % 8)
			{
				UART_Printf(" ");
			}
			else
			{
				UART_Printf("\n");
			}
		}

}

// Set voltage for the LDO3
// LDO3 can be turned off
s32 MAX8698_SetVoltageLDO3(MAX8698_LDO23_VOLVAL val)
{
	u16 data;
	u8 buff[2];
	u8 pReadBuffer[0x02]={0, };
    u8 i;


	I2Cpmic_Init();


	if(val == LDO23_VOL_OFF)
	{
		//1)Enable Address Setting
			buff[0] = 0x00; 
			if (I2CPMIC_Write(MAX8698_ADDR, 1, buff) != OK)return ERROR;
			
	    //2) Buck, LDO En/Disable information Read
			if (I2Cpmic_Read(MAX8698_ADDR, 2, pReadBuffer) != 0)
			{
				UART_Printf("I2CPMICRead() failed.\n");
				return ERROR;
			}
		//3)LDO3 Disable
			buff[0] = 0x00; 
			buff[1] = (pReadBuffer[0] & 0<<3); 
			if (I2CPMIC_Write(MAX8698_ADDR, 2, buff) != OK)return ERROR;

			UART_Printf("PWREN & Buck off -> LDO3 Power OFF \n");
	}
	else
	{
		//LDO6,7,8,9 enable
		buff[0] = 0x00; //L
		buff[1] = 0x3E ; //LDO6,7,8,9 enable
		if (I2CPMIC_Write(MAX8698_ADDR, 2, buff) != OK)return ERROR;
		
		// Address Setting
		buff[0] = 0x08; //LDO3 Address
		if (I2CPMIC_Write(MAX8698_ADDR, 1, buff) != OK)return ERROR;	
		
		// Voltage Value Read
		if (I2Cpmic_Read(MAX8698_ADDR, 2, pReadBuffer) != 0)
		{
			UART_Printf("I2CPMICRead() failed.\n");
			return ERROR;
		}

		buff[0] = 0x08; //LDO3 Address
		buff[1] = ((pReadBuffer[0] & 0x0F) |val<<4); //
	
	if (I2CPMIC_Write(MAX8698_ADDR, 2, buff) != OK)return ERROR;	
	}
//////////////////////////////////////////////////////////////
		if (I2Cpmic_Read(MAX8698_ADDR, 2, pReadBuffer) != 0)
	{
		UART_Printf("I2CPMICRead() failed.\n");
		return ERROR;
	}

	for (i=0; i < 1; i++)
	{
		data = ((pReadBuffer[i] & 0xF0)>>4)*50+800;
		UART_Printf("Current LDO3(OTG,HOST D) Voltage :: %d [mVoltage]",data);
		if (i % 8)
		{
			UART_Printf(" ");
		}
		else
		{
			UART_Printf("\n");
		}
	}

}

// Set voltage for the LDO4
// LDO4 can be turned off
s32 MAX8698_SetVoltageLDO4(MAX8698_LDO45679_VOLVAL val)
{
	u16 data;
	u8 buff[2];
	u8 pReadBuffer[0x02]={0, };
    u8 i;


	I2Cpmic_Init();


	if(val == LDO45679_VOL_OFF)
	{

	//1)Enable Address Setting
		buff[0] = 0x00; 
		if (I2CPMIC_Write(MAX8698_ADDR, 1, buff) != OK)return ERROR;
		
	//2) Buck, LDO En/Disable information Read
		if (I2Cpmic_Read(MAX8698_ADDR, 2, pReadBuffer) != 0)
		{
			UART_Printf("I2CPMICRead() failed.\n");
			return ERROR;
		}
	//3)LDO4 Disable
		buff[0] = 0x00; 
		buff[1] = (pReadBuffer[0] & 0<<2); 
		if (I2CPMIC_Write(MAX8698_ADDR, 2, buff) != OK)return ERROR;
	
		UART_Printf("PWREN & Buck off -> LDO4 Power OFF \n");

	}
	else
	{
					//LDO6,7,8,9 enable
		buff[0] = 0x00; //L
		buff[1] = 0x3E ; //LDO6,7,8,9 enable
		if (I2CPMIC_Write(MAX8698_ADDR, 2, buff) != OK)return ERROR;
		
		buff[0] = 0x09; //LDO4 Address
		buff[1] = (0x00 |val<<0); //LDO4 Voltage setting value
	if (I2CPMIC_Write(MAX8698_ADDR, 2, buff) != OK)return ERROR;	
	}
///////////////////////////////////////////////////////////////
	if (I2Cpmic_Read(MAX8698_ADDR, 2, pReadBuffer) != 0)
	{
		UART_Printf("I2CPMICRead() failed.\n");
		return ERROR;
	}

	   for (i=0; i < 1; i++)
	   {
		   data = ((pReadBuffer[i] & 0xFF))*100+1600;
		   UART_Printf("urrent LDO4(MIPI) Voltage :: %d [mVoltage]",data);
		   if (i % 8)
		   {
			   UART_Printf(" ");
		   }
		   else
		   {
			   UART_Printf("\n");
		   }
	   }
}

// Set voltage for the LDO5
// LDO5 can be turned off
s32 MAX8698_SetVoltageLDO5(MAX8698_LDO45679_VOLVAL val)
{
	u16 data;
	u8 buff[2];
	u8 pReadBuffer[0x02]={0, };
    u8 i;


	I2Cpmic_Init();


	if(val == LDO45679_VOL_OFF)
	{
		
		//1)Enable Address Setting
			buff[0] = 0x00; 
			if (I2CPMIC_Write(MAX8698_ADDR, 1, buff) != OK)return ERROR;
			
		//2) Buck, LDO En/Disable information Read
			if (I2Cpmic_Read(MAX8698_ADDR, 2, pReadBuffer) != 0)
			{
				UART_Printf("I2CPMICRead() failed.\n");
				return ERROR;
			}
		//3)LDO5 Disable
			buff[0] = 0x00; 
			buff[1] = (pReadBuffer[0] & 0<<1); 
			if (I2CPMIC_Write(MAX8698_ADDR, 2, buff) != OK)return ERROR;
		
			UART_Printf("PWREN & Buck off -> LDO5 Power OFF \n");

	}
	else
	{
				//LDO6,7,8,9 enable
		buff[0] = 0x00; //L
		buff[1] = 0x3E ; //LDO6,7,8,9 enable
		if (I2CPMIC_Write(MAX8698_ADDR, 2, buff) != OK)return ERROR;
		
		buff[0] = 0x0A; //LDO5 Address
		buff[1] = (0x00 |val<<0); //LDO5 Voltage setting value
	if (I2CPMIC_Write(MAX8698_ADDR, 2, buff) != OK)return ERROR;
	}
////////////////////////////////////////////////////////////////
	if (I2Cpmic_Read(MAX8698_ADDR, 2, pReadBuffer) != 0)
	{
		UART_Printf("I2CPMICRead() failed.\n");
		return ERROR;
	}

	   for (i=0; i < 1; i++)
	   {
		   data = ((pReadBuffer[i] & 0xFF))*100+1600;
		   UART_Printf("urrent LDO5() Voltage :: %d [mVoltage]",data);
		   if (i % 8)
		   {
			   UART_Printf(" ");
		   }
		   else
		   {
			   UART_Printf("\n");
		   }
	   }

}

// Set voltage for the LDO6
// LDO6 can be turned off
s32 MAX8698_SetVoltageLDO6(MAX8698_LDO45679_VOLVAL val)
{
	u16 data;
	u8 buff[2];
	u8 pReadBuffer[0x02]={0, };
    u8 i;


	I2Cpmic_Init();


	if(val == LDO45679_VOL_OFF)
	{
		//1)Addres Setting ONOFF Register
			buff[0] = 0x01; 
			if (I2CPMIC_Write(MAX8698_ADDR, 1, buff) != OK)return ERROR;
			
		//2) Buck, LDO En/Disable information Read
			if (I2Cpmic_Read(MAX8698_ADDR, 2, pReadBuffer) != 0)
			{
				UART_Printf("I2CPMICRead() failed.\n");
				return ERROR;
			}
		//3)LDO6 Disable
			buff[0] = 0x01; 
			buff[1] = (pReadBuffer[0] & 0<<7); 
			if (I2CPMIC_Write(MAX8698_ADDR, 2, buff) != OK)return ERROR;
		
			UART_Printf("PWREN & Buck off -> LDO6 Power OFF \n");


	}
	else
	{
				//LDO6,7,8,9 enable
		buff[0] = 0x01; //L
		buff[1] = 0xF0 ; //LDO6,7,8,9 enable
		if (I2CPMIC_Write(MAX8698_ADDR, 2, buff) != OK)return ERROR;
		
		buff[0] = 0x0B; //LDO6 Address
		buff[1] = (0x00 |val<<0); //LDO6 Voltage setting value
	if (I2CPMIC_Write(MAX8698_ADDR, 2, buff) != OK)return ERROR;
	}

//////////////////////////////////////////////////////////////
	if (I2Cpmic_Read(MAX8698_ADDR, 2, pReadBuffer) != 0)
	{
		UART_Printf("I2CPMICRead() failed.\n");
		return ERROR;
	}

	   for (i=0; i < 1; i++)
	   {
		   data = ((pReadBuffer[i] & 0xFF))*100+1600;
		   UART_Printf("urrent LDO6() Voltage :: %d [mVoltage]",data);
		   if (i % 8)
		   {
			   UART_Printf(" ");
		   }
		   else
		   {
			   UART_Printf("\n");
		   }
	   }

	
}

// Set voltage for the LDO7
// LDO7 can be turned off
s32 MAX8698_SetVoltageLDO7(MAX8698_LDO45679_VOLVAL val)
{
	u16 data;
	u8 buff[2];
	u8 pReadBuffer[0x02]={0, };
    u8 i;


	I2Cpmic_Init();


	if(val == LDO45679_VOL_OFF)
	{
		//1)Addres Setting ONOFF Register
			buff[0] = 0x01; 
			if (I2CPMIC_Write(MAX8698_ADDR, 1, buff) != OK)return ERROR;
			
		//2) Buck, LDO En/Disable information Read
			if (I2Cpmic_Read(MAX8698_ADDR, 2, pReadBuffer) != 0)
			{
				UART_Printf("I2CPMICRead() failed.\n");
				return ERROR;
			}
		//3)LDO6 Disable
			buff[0] = 0x01; 
			buff[1] = (pReadBuffer[0] & 0<<6); 
			if (I2CPMIC_Write(MAX8698_ADDR, 2, buff) != OK)return ERROR;
		
			UART_Printf("PWREN & Buck off -> LDO6 Power OFF \n");
	}
	else
	{
		// LDO 7 Enable
		buff[0] = 0x01; //L
		buff[1] = 0xF0 ; //LDO6,7,8,9 enable
		if (I2CPMIC_Write(MAX8698_ADDR, 2, buff) != OK)return ERROR;
		
		buff[0] = 0x0C; //LDO7 Address
		buff[1] = (0x00 |val<<0); //LDO7 Voltage setting value
		if (I2CPMIC_Write(MAX8698_ADDR, 2, buff) != OK)return ERROR;
	}
/////////// Voltage Value Setting //////////////////////
	if (I2Cpmic_Read(MAX8698_ADDR, 2, pReadBuffer) != 0)
	{
		UART_Printf("I2CPMICRead() failed.\n");
		return ERROR;
	}

	   for (i=0; i < 1; i++)
	   {
		   data = ((pReadBuffer[i] & 0xFF))*100+1600;
		   UART_Printf("urrent LDO7() Voltage :: %d [mVoltage]",data);
		   if (i % 8)
		   {
			   UART_Printf(" ");
		   }
		   else
		   {
			   UART_Printf("\n");
		   }
	   }

}

// Set voltage for the LDO8
// LDO8 can be turned off
s32 MAX8698_SetVoltageLDO8(MAX8698_LDO8_VOLVAL val)
{
	u16 data;
	u8 buff[2];
	u8 pReadBuffer[0x02]={0, };
    u8 i;


	I2Cpmic_Init();


	if(val == LDO8_VOL_OFF)
	{
		//1)Addres Setting ONOFF Register
			buff[0] = 0x01; 
			if (I2CPMIC_Write(MAX8698_ADDR, 1, buff) != OK)return ERROR;
			
		//2) Buck, LDO En/Disable information Read
			if (I2Cpmic_Read(MAX8698_ADDR, 2, pReadBuffer) != 0)
			{
				UART_Printf("I2CPMICRead() failed.\n");
				return ERROR;
			}
		//3)LDO8 Disable
			buff[0] = 0x01; 
			buff[1] = (pReadBuffer[0] & 0<<5); 
			if (I2CPMIC_Write(MAX8698_ADDR, 2, buff) != OK)return ERROR;
		
			UART_Printf("PWREN & Buck off -> LDO8 Power OFF \n");
	}
	else
	{
			// LDO 8 Enable
		buff[0] = 0x01; //L
		buff[1] = 0xF0 ; //LDO6,7,8,9 enable
		if (I2CPMIC_Write(MAX8698_ADDR, 2, buff) != OK)return ERROR;
		
		buff[0] = 0x0D; //LDO8 Address
		buff[1] = (0x03 |val<<4); //LDO8 Voltage setting value
		if (I2CPMIC_Write(MAX8698_ADDR, 2, buff) != OK)return ERROR;
	}

	if (I2Cpmic_Read(MAX8698_ADDR, 2, pReadBuffer) != 0)
	{
		UART_Printf("I2CPMICRead() failed.\n");
		return ERROR;
	}

	   for (i=0; i < 1; i++)
	   {
		   data = ((pReadBuffer[i] & 0xF0)>>4)*100+3000;
		   UART_Printf("urrent LDO9() Voltage :: %d [mVoltage]",data);
		   if (i % 8)
		   {
			   UART_Printf(" ");
		   }
		   else
		   {
			   UART_Printf("\n");
		   }
	   }
}
 
// Set voltage for the LDO9
// LDO9 can be turned off
s32 MAX8698_SetVoltageLDO9(MAX8698_LDO45679_VOLVAL val)
{
	u16 data;
	u8 buff[2];
	u8 pReadBuffer[0x02]={0, };
    u8 i;


	I2Cpmic_Init();


	if(val == LDO45679_VOL_OFF)
	{
		//1)Addres Setting ONOFF Register
			buff[0] = 0x01; 
			if (I2CPMIC_Write(MAX8698_ADDR, 1, buff) != OK)return ERROR;
			
		//2) Buck, LDO En/Disable information Read
			if (I2Cpmic_Read(MAX8698_ADDR, 2, pReadBuffer) != 0)
			{
				UART_Printf("I2CPMICRead() failed.\n");
				return ERROR;
			}
		//3)LDO8 Disable
			buff[0] = 0x01; 
			buff[1] = (pReadBuffer[0] & 0<<4); 
			if (I2CPMIC_Write(MAX8698_ADDR, 2, buff) != OK)return ERROR;
		
			UART_Printf("PWREN & Buck off -> LDO9 Power OFF \n");


	}
	else
	{
			//LDO6,7,8,9 enable
		buff[0] = 0x01; //L
		buff[1] = 0xF0 ; //LDO6,7,8,9 enable
		if (I2CPMIC_Write(MAX8698_ADDR, 2, buff) != OK)return ERROR;
		
		buff[0] = 0x0E; //LDO9 Address
		buff[1] = (0x00 |val<<0); //LDO9 Voltage setting value
	if (I2CPMIC_Write(MAX8698_ADDR, 2, buff) != OK)return ERROR;
	}
	
	if (I2Cpmic_Read(MAX8698_ADDR, 2, pReadBuffer) != 0)
	{
		UART_Printf("I2CPMICRead() failed.\n");
		return ERROR;
	}

	   for (i=0; i < 1; i++)
	   {
		   data = ((pReadBuffer[i] & 0xFF))*100+1600;
		   UART_Printf("urrent LDO9() Voltage :: %d [mVoltage]",data);
		   if (i % 8)
		   {
			   UART_Printf(" ");
		   }
		   else
		   {
			   UART_Printf("\n");
		   }
	   }
}

s32 MAX8698_InitForBL1(MAX8698_BUCK12_VOLVAL varm, MAX8698_BUCK12_VOLVAL vint)
{	

	varm=BUCK12_VOL_120;
	vint=BUCK12_VOL_115;




//	InitBaseHwForI2C(IP_I2C_A);
//	oIic.InitIp();
//	oIic.SetCh(I2C_A);
	IIC0_Open(256000);

//	oIic.InitIp(I2C_512KHZ);

	// ONOFF (1-2) REGISTER
	PMIC_WriteByIic(MAX8698_ADDR, (u8)0x01, (u8)0xF0); // LDO8-on

	// BUCK1, VARM : SET1-2 are grounded, so use DVSARM1
	// 0x8: 1.15V, 0x9: 1.20V, 0xa: 1.25V, 0xb: 1.30V, 0xc: 1.35V, 0xd: 1.40V
	PMIC_WriteByIic(MAX8698_ADDR, (u8)0x04, (u8)varm); // DVSARM1=1.25V
	PMIC_WriteByIic(MAX8698_ADDR, (u8)0x05, (u8)0x00); // DVSARM4, DVSARM3

	// BUCK2, VCORE : SET3 is grounded, so use DVSINT1
	// 0x9: 1.20, 0xa: 1.25, 0xb: 1.30
	PMIC_WriteByIic(MAX8698_ADDR, (u8)0x06, (u8)vint); // DVSINT1=1.15V

	// BUCK3, VCC, 1.8V
	// 0x1: 1.7V, 0x2: 1.8V, 0x3: 1.9V
	PMIC_WriteByIic(MAX8698_ADDR, (u8)0x07, (u8)0x01);
}

