/********************************************************************************
* 
*	Project Name : S5PV210 FPGA Validation
*
*	Copyright 2009 by Samsung Electronics, Inc.
*	All rights reserved.
*
*	Project Description :
*		This software is only for verifying functions of the S5PV210 FPGA
*		Anybody can use this software without our permission.
*  
*--------------------------------------------------------------------------------
* 
*	File Name : PCM_test.c
*  
*	File Description :
*
*	Author	: Jongseok,Park
*	Dept. : AP Development Team
*	Created Date : 2009/04/16
*	Version : 0.4 
*
*	Author	: Yoh-Han Lee
*	Dept. : AP Development Team
*	Created Date : 2007/03/16
*	Version : 0.3 
* 
* 
*	History
*	- Version 0.1 (2007/03/16)
*	  -> Available with AK2440 PCM Codec.
*   - Version 0.2 (2007/04/
*	  -> Available with 8753/9713
*   - Version 0.3 (2008/04/ :
*	  -> updated 9713 part, orgarnize source structure
*   - Version 0.4 (2009/04/16 :
*	  -> S5PV210 FPGA Validation, test under WM8580, By Jongseok,Park
*********************************************************************************/

#include "def.h"
#include "option.h"
#include "library.h"
#include "v210_sfr.h"
#include "system.h"
//#include "intc.h"

//#include "gpio.h"
#include "audiolibrary\audiocodecs.h"

#include "SfrReadWriten.h"
#include "sysc.h"
#include "dma.h"
#include "pcm\pcm.h"
#include "smdk.h"


//#include "pcmvoice.h"
extern unsigned int pcmvoice[];
extern unsigned int ptada[];
extern unsigned int sin1khz[];
#include "audiolibrary\sin500hz8.h"

/////////////////////////////////////////////////////
// Global variable
/////////////////////////////////////////////////////
PCM_State 		g_oPCMState;
extern int g_interrupt_cnt;
extern PCM_IRQstat g_pcmirqstat[PCM_IRQ_STAT_MAX];;


/////////////////////////////////////////////////////
// Externs SFR & IP Functions
/////////////////////////////////////////////////////

extern u8 PCM_SFR_testsub(int Port);
extern u8 PCM_DATA_2chpattern_making( unsigned int* destsizeByte,
							  unsigned int destaddr, unsigned int totrepeat, int eachrepeat, int BitperCh);

/////////////////////////////////////////////////////
// Test Functions
/////////////////////////////////////////////////////
static void PCM_SFR_test(void);
static void PCMSet(void);
//static void PCMCodecRegWR(void);

//static void PCMOut(u8 buserinput, int autoselect);
static void PCMIn(u8 buserinput, int autoselect);

static void PCMOutsample(void);
static void PCMmemOut(void);
static void PCMInOutSametime(void);
extern void PCM_fifostat(void);

void TZPC_NonSecureInit(void);
bool TestPCM_autotest(void);
	
/////////////////////////////////////////////////////
// Configure Functions
/////////////////////////////////////////////////////
void PCMTEST_SelectPort(void);
void PCMTEST_SelectCodec(void);
void PCMTEST_SelectPCMCLKSOURCE(void);
void PCMTEST_SelectPCMSYNC(void);
void PCMTEST_Sel_BFS(void);
void PCMTEST_Sel_RFS(void);
void PCMTEST_SelectSyncPosition(void);
void PCMTEST_SelectRecSecond(void);
void PCMTEST_DMA_Burst(void);

extern void PCM_TXInterruptTest(void);
extern void PCM_RXInterruptTest(void);
	
/////////////////////////////////////////////////////
// Test functions Lists & Calls routine
/////////////////////////////////////////////////////
void * func_pcm_test[][2]=
{	
	//  									"123456789012345678901"
	(void *)PCMTEST_SelectPort, 			"Select PCM port",
	//IIS Function Test Item	
   	(void *)PCM_SFR_test,	       		"PCM SFR reset & read/write test ",
   	(void *)PCMSet,						"Configuration\n",

	(void *)PCMOutsample,				"Tada PCM out ",	
	(void *)PCMIn,						"PCM In Test (REC with LINEIN)",
	(void *)PCMmemOut,					"PCM out Test (PLAY)",	
	(void *)PCMInOutSametime,			"PCM OUT->IN Test at same time (DMA)\n",

	(void *)PCM_TXInterruptTest,               	"PCM TX Interrupt Status Test",	
	(void *)PCM_RXInterruptTest,                	"PCM RX Interrupt Status Test\n",		

	(void *)TestPCM_autotest,                	"PCM AutoTest (for Sorting, Only PCM#1 available)\n",		
	(void *)PCM_fifostat,                          	"Dump PCM FIFO Status",
    0,0
};

void * pcmset_function[][2]=
{
	(void *)PCMTEST_SelectCodec,				"PCM Codec select",
	(void *)PCMTEST_SelectPCMCLKSOURCE,	"PCMSOURCE_CLK Source Select",
	(void *)PCMTEST_SelectPCMSYNC,			"PCMSYNC Frequency(Sampling rate)",
	(void *)PCMTEST_Sel_BFS,					"SCLK fs select(BFS)",
	(void *)PCMTEST_Sel_RFS,					"CDCLK fs select(RFS)",
	(void *)PCMTEST_SelectSyncPosition,		"MSB Position",	
	(void *)PCMTEST_SelectRecSecond,		"(Play) / Record second",		
	(void *)PCMTEST_DMA_Burst,				"DMA Burst Size",		
	0,							 0
};

char* PCM_CLKSRC_string[]=
{
	 "PCM_EXTCLK", "PCLK","SCLK_EPLL"
};
char* PCM_MSBPOS_string[]=
{
	"",
	"",
	"",
	"AFTER HIGH Mode(DSP Mode A)"
	"DURING HIGH Mode (DSP Mode B)",
};


static void PCM_Display(PCM_State test)
{
	u8 uClksrc ;
	
	uClksrc = test.PCMClkSrc ;
	
	Disp("\n");
		Disp("\n=================  PCM Configuration ====================\n");
	Disp("\nPCM Configuration");
	Disp("\n1.PCM Codec : %s  2.Port :%d  3.MSB Position : %d", "WM8580", (test.PCMIpNum), test.PCMMSBPosition);
	Disp("\n4.Source_Clk : %s(%dfs),   %dHz  5.PCM_SCLK : %dKHz(%d fs)",
			(PCM_CLKSRC_string[uClksrc]),         test.m_RFS, g_oPCMState.EXTCDCLKFreq, (test.PCMSync*test.m_BFS)/1000 , test.m_BFS);
	Disp("\n6.Sync Rate(Sampling Frquency) : %dKHz",	(test.PCMSync)/1000);
	Disp("\n7.Record second : %d sec", test.RECsec);
	Disp("\n8.Transfer Unit (BYTE,HWORD,WORD,DWORD) :  %d ",g_oPCMState.DMAtu );	
	Disp("\n9.DMA Burst Size Index (SINGLE,BURST4,BURST8....) : %d ",g_oPCMState.DMABurst );

	Disp("\n\nSMDKv210 CFG pin Check");
	Disp("\n-----------------------");
	if (g_oPCMState.PCMIpNum == PCM_IP1)
	{
		Disp("\n1. CFGB10  : ");
		Disp("\n2. CFGB11  : ");	
	}else if (g_oPCMState.PCMIpNum == PCM_IP0)
	{
		Disp("\n1. CFGB10  : ");
		Disp("\n2. CFGB11  : ");	
	}else if (g_oPCMState.PCMIpNum == PCM_IP2)
	{
		Disp("\n1. CFGB10  : Dont Care");
		Disp("\n2. CFGB11  : ");	
	
}
	Disp("\n3. CFGB12  : \n\n");	
}


void Test_PCM(void)
{
	int i;

//	MAX8698_SetVoltageLDO5(14); //VDD_AUD = 3.0V
//	MAX8698_SetVoltageLDO5(17); //VDD_AUD = 3.3V	
	MAX8698_SetVoltageLDO5(18); //VDD_AUD = 3.4V	(for SMDK enough power)
	
	TZPC_NonSecureInit();
	//init	
	PCM_Init();
		
	while(1)
	{
	
		PCM_Display(g_oPCMState);
		
		i=0;
		Disp("\n================== PCM Function Test =====================\n");
		
		while(1)
		{   //display menu
			Disp("%2d:%s",i,func_pcm_test[i][1]);
			i++;
			if((int)(func_pcm_test[i][0])==0)
			{
				Disp("\n");
				break;
			}
			if((i%1)==0)
			Disp("\n");
		}
		Disp("\n==========================================================\n");
		Disp("Select Item or Press Enter key to exit : ");
		i = UART_GetIntNum(); 
		if(i==-1) break;		// return.

		PCM_SetPort(g_oPCMState.PCMIpNum);


		if(i>=0 && (i<((sizeof(func_pcm_test)-1)/8)) )	// select and execute...
			( (void (*)(void)) (func_pcm_test[i][0]) )();



	}	
}



static void PCM_SFR_test(void)
{
	PCM_SFR_testsub(0);
	PCM_SFR_testsub(1);
	PCM_SFR_testsub(2);
}



static void PCMSet(void)
{
	int i;

	while(1)
	{
	
		i=0;
		Disp("\n\n================== Select the function =====================\n\n");
		
		while(1)
		{   //display menu
			Disp("%2d:%s",i,pcmset_function[i][1]);
			i++;
			if((int)(pcmset_function[i][0])==0)
			{
				Disp("\n");
				break;
			}
			if((i%1)==0)
			Disp("\n");
		}
		Disp("\n==========================================================\n");
		Disp("Select #Item or Press Enter key to exit : ");
		i = UART_GetIntNum(); 
		if(i==-1) break;		// return.


		if(i>=0 && (i<((sizeof(pcmset_function)-1)/8)) )	// select and execute...
			( (void (*)(void)) (pcmset_function[i][0]) )();
	}
	
}


static void PCMOutsample(void)
{
	int i,umode,playselect;
	unsigned int destsizeByte,Backup_PCMSync;
	
	Backup_PCMSync = g_oPCMState.PCMSync;

	Disp("\nSelect PCM In/Out Operation Mode\n");
	Disp("0: Interrupt, 1: DMA(D)\n");
	umode= UART_GetIntNum();

	Disp("\nOutput Sample Select \n");
	Disp("0: Tada Sound(22.05Khz), 1: Voice (8Khz) \n");
	playselect= UART_GetIntNum();

	switch(playselect)
		{
			case 1: //sine1Khz sound
					Disp("\nVoice Sample Playing...(8Khz)\n");		
					Disp("\nAre you Ready? Press any key to continue...");
					UART_Getc();
					
					g_oPCMState.PCMSync = 8000;			
					destsizeByte= 165776;
					for (i=0;i<destsizeByte/4;i++)
					*((u32*)PCM_PLAY_BUF+i) = pcmvoice[i];
					break;

		
			default:    //tada sound
					Disp("\nTada Sample Playing...(22.05Khz)\n");
					Disp("\nAre you Ready? Press any key to continue...");
					UART_Getc();
					
					g_oPCMState.PCMSync = 22050;			
					destsizeByte=171008;
					for (i=0;i<destsizeByte/4;i++)
					*((u32*)PCM_PLAY_BUF+i) = ptada[i];
					break;
		}


	if (g_oPCMState.PCMIpNum==PCM_IP2)
	{
		Disp("\n %x %x %x ",g_oPCMState.PCMMSBPosition,g_oPCMState.PCMSync, g_oPCMState.m_RFS);
		//init for Primary Port WM8580(for PCM#2)
		WM8580_CodecInitPCMOut(g_oPCMState.PCMMSBPosition, (u32) g_oPCMState.PCMSync, 
									Master,  Word16, PRIMARY_PORT, g_oPCMState.m_RFS);
	}
	else
	{
		//init
		WM8580_CodecInitPCMOut(g_oPCMState.PCMMSBPosition, (u32) g_oPCMState.PCMSync, 
									Master,  Word16, WM8580_INTERFACE, g_oPCMState.m_RFS);
	}

	
	if (umode==0)
	{
	//FIFO mode playback			
		g_oPCMState.Playmode = PCM_INTERRUPT;
		PCM_PCMSetting();	
		PCM_PCMOutInt2( PCM_PLAY_BUF, destsizeByte);				
	}
	else 
	{
	//DMA mode playback			
		g_oPCMState.Playmode = PCM_DMA;
		PCM_PCMSetting();
		PCM_PCMOutDMA(PCM_PLAY_BUF, destsizeByte, NULL);
	}

	g_oPCMState.PCMSync = Backup_PCMSync ;	

}




#include "autotest_api.h"
static void PCMOutsampleAuto(void)
{
	int i,umode,playselect;
	unsigned int destsizeByte,Backup_PCMSync;
	
	Backup_PCMSync = g_oPCMState.PCMSync;

	Disp("\n DMA output");
	Disp("\nTada Sample Playing...(22.05Khz)\n");
	g_oPCMState.PCMSync = 22050;			
	destsizeByte=171008;
	for (i=0;i<destsizeByte/4;i++)
		*((u32*)PCM_PLAY_BUF+i) = ptada[i];

	//init
	WM8580_CodecInitPCMOut(g_oPCMState.PCMMSBPosition, (u32) g_oPCMState.PCMSync, 
								Master,  Word16, WM8580_INTERFACE, g_oPCMState.m_RFS);

	//DMA mode playback			
		g_oPCMState.Playmode = PCM_DMA;
		PCM_PCMSetting();
		PCM_PCMOutDMA(PCM_PLAY_BUF, destsizeByte, NULL);

	g_oPCMState.PCMSync = Backup_PCMSync ;	

}


static void PCMmemOut(void)
{
	int i;
	unsigned int destsizeByte=g_oPCMState.PCMSync*2*g_oPCMState.RECsec;
	
	u8 bret;
	u8 bauto=0;
	
	//init
	WM8580_CodecInitPCMOut(g_oPCMState.PCMMSBPosition, (u32) g_oPCMState.PCMSync, 
								Master,  Word16, WM8580_INTERFACE,g_oPCMState.m_RFS);
	PCM_SetPort(g_oPCMState.PCMIpNum);		

	Disp("\nListen to Sound via Speak Out Connector.");
	
	//select mode
	Disp("\nSelect PCM In/Out Operation Mode");
	Disp("\n0: Interrupt, 1: DMA(D)  ");
	i = UART_GetIntNum();
	
	//interrupt
	if(i==0)
	{
		g_oPCMState.Playmode = PCM_INTERRUPT;
		Disp("\nset auto [a] to continue test 10 times");
		if(UART_Getc() =='a') bauto = 1;		
		while(1)
		{
			if(!bauto)
			{
				Disp("\nPress any key to play.x to exit");
		    		if( UART_Getc() == 'x')break;							
			}
			PCM_PCMSetting();
			PCM_PCMOutInt2( PCM_PLAY_BUF, destsizeByte);
			if(i>10) break;
			i++;
		}		
	}
	else //dma	
	{			
		g_oPCMState.Playmode = PCM_DMA;
		PCM_PCMSetting();
		PCM_PCMOutDMA( PCM_PLAY_BUF, destsizeByte, NULL);
	}
	
	//deinit
}

static void PCMIn(u8 buserinput, int autoselect)
{
	int i;
	u8 bret;
	unsigned int destsizeByte=g_oPCMState.PCMSync*2*g_oPCMState.RECsec;
	
	
	Disp("\nSelect PCM In/Out Operation Mode\n");
	Disp("0: Interrupt, 1: DMA(D)   : ");

	if(buserinput!=1) 		i = UART_GetIntNum();
	else 				i = autoselect;	
	Disp("%d\n", i);

	 PCM_Data_init(PCM_PLAY_BUF, destsizeByte);
	WM8580_CodecInitPCMIn(g_oPCMState.PCMMSBPosition, (u32) g_oPCMState.PCMSync, 
							Master,  Word16, LINEIN, WM8580_INTERFACE,0);
	PCM_SetPort(g_oPCMState.PCMIpNum);
	PCM_PCMSetting();
	if(i==0)
	{
		g_oPCMState.Playmode = PCM_INTERRUPT;
		PCM_PCMInInt(PCM_PLAY_BUF, destsizeByte );
	}
	else
	{
		g_oPCMState.Playmode = PCM_DMA;
		PCM_PCMInDMA(PCM_PLAY_BUF,destsizeByte, NULL);	//set internal interface controller				
	}
}


//scenario : 
// store pcm to memory(by loading or by recording prior)
// play pcm, tie sdo->sdi ,playrec same time
// play recorded
static void PCMInOutSametime()
{
	u8 bret;
	unsigned int destsizeByte=g_oPCMState.PCMSync*2*g_oPCMState.RECsec;

	Disp("\n###################################################\n");
	Disp("Before test, You Connect PCM IN/OUT at test pcm port \n");	
	Disp("ex) PCM ch1  PCMSOUT <-> PCMSIN     \n");
	Disp("    PCM_PLAY_BUF ==> PCM_REC_BUF \n");	
	Disp("###################################################");
	
	
	g_oPCMState.Playmode = PCM_DMA;
	PCM_SetPort(g_oPCMState.PCMIpNum);
	PCM_Data_init(PCM_REC_BUF, destsizeByte);
	*((u32 *)PCM_PLAY_BUF) = 0x000109FE; //inital value for complete compare (jspark) : ó PLAYBUFF 0 ƴ  ,
	                                                             //0x0001 TXFIFO 16bit Valid flag... 

	Disp("\nPress any key to continue...");	
	UART_Getc();
	
	//Audio Codec Active for play & record
	WM8580_CodecInitPCMOut(g_oPCMState.PCMMSBPosition, (u32) g_oPCMState.PCMSync, 
							Master,  Word16, SECONDARY_PORT, g_oPCMState.m_RFS);
	PCM_PCMSetting();
	PCM_PCMInOutDMA(PCM_PLAY_BUF, PCM_REC_BUF, destsizeByte, NULL);


	Disp("\nPress any key to hear recored pcm");
	UART_Getc();

	//play
	WM8580_CodecInitPCMOut(g_oPCMState.PCMMSBPosition, (u32) g_oPCMState.PCMSync, 
							Master,  Word16, SECONDARY_PORT, g_oPCMState.m_RFS);
	PCM_PCMSetting();
	PCM_PCMOutDMA(PCM_REC_BUF, destsizeByte , NULL);
	
	//compare data
	Disp("\nComparing PLAY_BUF with REC_BUF....");
	// why are you use + 04 offset at REC_BUF? : because No PCMSYNC at PCM TX start, RX-data is shifted by one unit. 
	bret = PCM_Compare32(PCM_PLAY_BUF, PCM_REC_BUF+0x04, (destsizeByte/4) - 1 ,1,0);
	if(bret) 
		Disp("\n-> PCM Full Duplex Check OK!!(TX->RX) \n");
	else
		Disp("\n-> compared result : Error!!");	

}


#if 1 //jspark AutoTest
////////////////////////////////////////////////////////////////////
//
// auto test
//
////////////////////////////////////////////////////////////////////

#include "Autotest_api.h"
extern unsigned int ptada[];


void TZPC_NonSecureInit(void)
{
		Outp32(0xF1500804,0xff );
		Outp32(0xF1500810,0xff );
		Outp32(0xF150081C,0xff );
		Outp32(0xF1500828,0xff );
		
		Outp32(0xFAD00804,0xff );
		Outp32(0xFAD00810,0xff );
		Outp32(0xFAD0081C,0xff );
		Outp32(0xFAD00828,0xff );
		
		Outp32(0xE0600804,0xff );
		Outp32(0xE0600810,0xff );
		Outp32(0xE060081C,0xff );
		Outp32(0xE0600828,0xff );
		
		Outp32(0xE1C00804,0xff ); //correct for i2s0, i2s2, pcm2 [TZPC3, TZPCDECPROTO[3] ] - set decode region to non-secure
//		Outp32(0xE1C00810,0xff );
//		Outp32(0xE1C0081C,0xff );
//		Outp32(0xE1C00828,0xff );		
		
		Outp32(0xE060081C,0x20 );
	
}

u8 PCM_WM8580_ConnnectionTest(void)
{
	u8 ret=0;
	
	UART_Printf("\n* IIC(0) <---> WM8580 Conection Test");
	IIC0_OpenPolling(100000); //100Khz

	if (Device_ACK_Check_Polling(0,WM8580ID))
	{
		UART_Printf("\n Device ACK : OK !");
		ret = 1;
	}	
	return ret;
}

bool TestPCM_autotest(void)
{
	TZPC_NonSecureInit();

	if (!PCM_WM8580_ConnnectionTest())
	{
		UART_Printf("\n I2C Error!! PCM test FAIL....!!");
		return;
	}

	UART_Printf("\n We will test PCM channel #1 with Tada Sound(22.05Khz)");
	PCM_Init();
	//PCMOutsample(); //tada sound test
	PCM_SetPort(g_oPCMState.PCMIpNum);	
	PCMOutsampleAuto(); //DMA output


//	return AUTO_askresult(-1, "Did you hear the tada sound playing?");	
	return 1;
}
#endif


/*---------------------------------- APIs of PCM Configuration ---------------------------------*/
	
void PCMTEST_SelectSyncPosition(void)
{
	unsigned char selTemp;
	
	Disp("\nSelect PCM data MSB Postion\n");
	Disp("0.DURING_PCMSYNC_HIGH(DSP Mode B)[D]]	1.AFTER_PCMSYNC_HIGH(DSP Mode A)\n ");
	selTemp = UART_GetIntNum();

	if (selTemp == 1)
		g_oPCMState.PCMMSBPosition = AFTER_PCMSYNC_HIGH;		
	else 
		g_oPCMState.PCMMSBPosition = DURING_PCMSYNC_HIGH;
}

void PCMTEST_SelectRecSecond(void)
{
	u32 uSec;
	
	Disp("\nInput Record second : \n");
	uSec = UART_GetIntNum();
	uSec =(uSec>60)? 10 : uSec ;
	g_oPCMState.RECsec = uSec;
}



void PCMTEST_SelectPort(void)
{
	unsigned char selTemp;
	
	Disp("Select PCM IP \n");
	Disp("0. PCM0     (GPIO_C1, I2S_Ch2) \n");
	Disp("1. PCM1(*) (GPIO_C0, I2C_Ch1,AC97) \n");
	Disp("2. PCM2     (GPIO_I,    I2C_Ch0 (5.1ch) \n");
	
	selTemp = UART_GetIntNum();

	if (selTemp>=PCM_IP0 && selTemp<=PCM_IP2)
		g_oPCMState.PCMIpNum=selTemp;
	else
		g_oPCMState.PCMIpNum=PCM_IP1;	//defualt
		
	//PCM_SetPort(g_oPCMState.PCMIpNum);
}


void PCMTEST_SelectCodec(void)
{
	//g_oPCMState.CodecID =PCM_WM8580;
	g_oPCMState.useMic= 0;

}

void PCMTEST_SelectPCMCLKSOURCE(void)
{
	s32 selTemp;
	
	Disp("Select PCM Source CLK\n");
	Disp("0.PCM EXTCLK(*)	1. PCLK	2.EPLL ");
	selTemp = UART_GetIntNum();
	selTemp = (selTemp<0)? 0 : selTemp;

	if(selTemp == 0)
	{
		Disp("Select EXTCLK freq.\n");
		Disp("0. 16.9344MHz	1. 2.0 Mhz	2. enter own value\n");
		selTemp = UART_GetIntNum();		
		if(selTemp ==2){
			unsigned int iNum;
			Disp("enter [Hz]: ");
			iNum = UART_GetIntNum();			
			g_oPCMState.EXTCDCLKFreq = iNum;
		}else if (selTemp ==1)
		{	
			g_oPCMState.EXTCDCLKFreq = I2S_PCMCDCLK_HZ_2M;
		}
		else {
			g_oPCMState.EXTCDCLKFreq = I2S_PCMCDCLK_HZ;	
		}	

		g_oPCMState.PCMClkSrc = PCM_EXTCLK;
	} 
	else if(selTemp == 1)
	{
		g_oPCMState.PCMClkSrc = PCM_PCLK;
	}	
	else
		g_oPCMState.PCMClkSrc = PCM_EPLL;

}

void PCMTEST_SelectPCMSYNC(void)
{
	unsigned short i;
	unsigned short selTemp;
	unsigned int sourceclkfreq;
	
	Disp("Select PCM Sampling Freqency)\n");	
#if 1  //jspark test
	Disp("[0] 8Khz  [1]11.025Khz  [2]12KHz  [3]16Khz  [4]22.050Khz  [5]24Khz  [6]32Khz  [7]44.1Khz  [8]48Khz \n");		
	selTemp = UART_GetIntNum();
	switch(selTemp)
	{
		case 0:	g_oPCMState.PCMSync= SYNC_8000;		break;
		case 1:	g_oPCMState.PCMSync= SYNC_11025;		break;
		case 2:	g_oPCMState.PCMSync= SYNC_12000;		break;
		case 3:	g_oPCMState.PCMSync= SYNC_16000;		break;
		case 4:	g_oPCMState.PCMSync= SYNC_22050;		break;
		case 5:	g_oPCMState.PCMSync= SYNC_24000;		break;
		case 6:	g_oPCMState.PCMSync= SYNC_32000;		break;
		case 7:	g_oPCMState.PCMSync= SYNC_44100;		break;
		case 8:	g_oPCMState.PCMSync= SYNC_48000;		break;		
		default:	g_oPCMState.PCMSync= SYNC_44100;		break;				
	}	
#else
	Disp("0. 8Khz		1.44.1KHz");		
	selTemp = UART_GetIntNum();
	
	switch(selTemp)
	{
		case 1:	g_oPCMState.PCMSync= SYNC_44100;	break;
		default:	g_oPCMState.PCMSync= SYNC_8K;		break;		
	}	
#endif
}



void PCMTEST_Sel_RFS(void)
{
	u32 uSelection;
	UART_Printf("Select CDCLK fs(RFS)\n");
	UART_Printf("1. 256fs		2. 384fs		3. user input\n");
	uSelection = UART_GetIntNum();
	if(uSelection ==3)
	{
		Disp("enter [fs]: ");
		g_oPCMState.m_RFS = UART_GetIntNum();
	}
	else 
	{
		g_oPCMState.m_RFS =  (uSelection == 2) ? 384 : 256;
	}
}

void PCMTEST_Sel_BFS(void)
{
	u32 uSelection;
	UART_Printf("Select SCLK fs(BFS)\n");
	UART_Printf("1. 32fs		2. 48fs		3. user input\n");
	uSelection = UART_GetIntNum();

	if(uSelection ==3)
	{
		Disp("enter [fs]: ");
		g_oPCMState.m_BFS = UART_GetIntNum();
	}
	else 
	{
		if (uSelection == 2)
			g_oPCMState.m_BFS = 48;
		else	 
			g_oPCMState.m_BFS = 32;
	}
}



void PCMTEST_DMA_Burst(void)
{
	u32 uSelection;
	Disp("Select DMA Burst Size\n");
	Disp("0. SINGLE  1. BURST4  2. BURST8  3. BURST16  4. BURST16x2  5. BURST32 \n");  
	Disp("6. SINGLE64  7. BURST128  8. BURST256 \n");

	uSelection = UART_GetIntNum();

	if (uSelection >=0 && uSelection<=8)
		g_oPCMState.DMABurst = uSelection;
	else {
		g_oPCMState.DMABurst = SINGLE;		
		Disp("\nInput Error !!");
	}	
}


