/********************************************************************************
* 
*	Project Name : S5PV210 FPGA Validation
*
*	Copyright 2009 by Samsung Electronics, Inc.
*	All rights reserved.
*
*	Project Description :
*		This software is only for verifying functions of the S5PV210 FPGA
*		Anybody can use this software without our permission.
*  
*--------------------------------------------------------------------------------
* 
*	File Name : PCM.c
*  
*	File Description :
*
*	Author	: Jongseok,Park
*	Dept. : AP Development Team
*	Created Date : 2009/04/16
*	Version : 0.4 
*
*	Author	: Yoh-Han Lee
*	Dept. : AP Development Team
*	Created Date : 2007/03/16
*	Version : 0.3 
* 
* 
*	History
*	- Version 0.1 (2007/03/16)
*	  -> Available with AK2440 PCM Codec.
*   - Version 0.2 (2007/04/
*	  -> Available with 8753/9713
*   - Version 0.3 (2008/04/ :
*	  -> updated 9713 part, orgarnize source structure
*   - Version 0.4 (2009/04/16 :
*	  -> S5PV210 FPGA Validation, test under WM8580, By Jongseok,Park
*********************************************************************************/


#ifndef __PCM_H__
#define __PCM_H__


#define FPGA_PCMTEST		//jspark
#define rCLK_SRC6			(0xE0100000+0x218)	/*	(SYSCON_CLK_BASE+0x218)*/


typedef enum 
{
	rPCMCTRL = 0x0,		
	rPCMCLKCTL = 0x4,		
	rPCMTXFIFO = 0x8,		
	rPCMRXFIFO = 0xc,   	
	rPCMIRQCTL = 0x10,		
	rPCMIRQSTAT= 0x14,		
	rPCMFIFOSTAT = 0x18,	
	rPCMCLRINT = 0x20		
}PCM_SFR;

  


///////////////////////////////////////////////////////////////
//#define PCM_PLAY_BUF  				0x41a00000
//#define PCM_REC_BUF  				0x42000000

#define PCM_PLAY_BUF  				(DMAC_CODE_BASE + 0x100000)
#define PCM_REC_BUF  				(DMAC_CODE_BASE + 0x800000)



//#define PCM_REC_LEN 				0xfffff
#define PCM_REC_LEN 				(8000*2*10)//bytes  8KHz mono 16bit 10sec

#define PCM_SCLK_EN				(1<<19)
#define PCM_PCM_ENABLE			(1<<0)
#define PCM_RXFIFO_EN   			(1<<1)
#define PCM_TXFIFO_EN				(1<<2)
#define RX_MSB_POS0				(0<<3)
#define RX_MSB_POS1				(1<<3)
#define TX_MSB_POS0				(0<<4)
#define TX_MSB_POS1				(1<<4)
#define PCM_RX_DMA_EN			(1<<5)
#define PCM_TX_DMA_EN			(1<<6)
#define RXFIFO_DIPSTICK(n)		(((n)&0x3f) <<7)
#define TXFIFO_DIPSTICK(n)		(((n)&0x3f) <<13)

///////////////////////////////////////////////////////////////////////////////////////


//PCM_IP;
#define PCM_IP2	2
#define PCM_IP1 	1
#define PCM_IP0	0


//play mode
#define PCM_POLLING		0
#define PCM_INTERRUPT	1
#define PCM_DMA			2

//PCM_CLKSRC;
#define 	PCM_EXTCLK		0
#define 	PCM_PCLK		1
#define 	PCM_EPLL		2	//I2C block Clock PCM master clock ̿ 



//PCM_SCLK
#define SCLK_128K 	128000
#define SCLK_256K 	256000
#define SCLK_512K 	512000
#define SCLK_768K 	768000
#define SCLK_1536K 	1536000

//PCM_SYNC_CLK;
/*
#define SYNC_8K 	8000
#define SYNC_44100	44100
*/

#define SYNC_8000 		8000
#define SYNC_11025 	11025
#define SYNC_12000 	12000
#define SYNC_16000 	16000
#define SYNC_22050 	22050
#define SYNC_24000 	24000
#define SYNC_32000 	32000
#define SYNC_44100	44100
#define SYNC_48000 	48000


//PCM_Configuration;
#define Init	0
#define Set		1


///////////////////////////////////////////
// STATUS registers
//

//PCM_CTRL
#define RXFIFO_DIPSTICK0			( (PCM_Inp32(PCM_IP0, rPCMCTRL)>>7) & 0x3f )
#define TXFIFO_DIPSTICK0			( (PCM_Inp32(PCM_IP0, rPCMCTRL)>>13) & 0x3f )
#define RXFIFO_DIPSTICK1			( (PCM_Inp32(PCM_IP1, rPCMCTRL)>>7) & 0x3f )
#define TXFIFO_DIPSTICK1			( (PCM_Inp32(PCM_IP1, rPCMCTRL)>>13) & 0x3f )
#define RXFIFO_DIPSTICK2			( (PCM_Inp32(PCM_IP2, rPCMCTRL)>>7) & 0x3f )
#define TXFIFO_DIPSTICK2			( (PCM_Inp32(PCM_IP2, rPCMCTRL)>>13) & 0x3f )


//PCM_FIFO(//1)
#define FIFO_TXFIFO_COUNT0			( (PCM_Inp32(PCM_IP0, rPCMFIFOSTAT)>>14) & 0x3f )
#define FIFO_RXFIFO_COUNT0			( (PCM_Inp32(PCM_IP0, rPCMFIFOSTAT)>>4) & 0x3f )
#define FIFO_TXFIFO_COUNT1			( (PCM_Inp32(PCM_IP1, rPCMFIFOSTAT)>>14) & 0x3f )
#define FIFO_RXFIFO_COUNT1			( (PCM_Inp32(PCM_IP1, rPCMFIFOSTAT)>>4) & 0x3f )
#define FIFO_TXFIFO_COUNT2			( (PCM_Inp32(PCM_IP2, rPCMFIFOSTAT)>>14) & 0x3f )
#define FIFO_RXFIFO_COUNT2			( (PCM_Inp32(PCM_IP2, rPCMFIFOSTAT)>>4) & 0x3f )

///////////////////////////////////////////
// CONTROL registers
//

//PCM_FIFO
#define FIFO_TXFIFO_EMPTY			(1<<13)
#define FIFO_TXFIFO_ALMOST_EMPTY	(1<<12)
#define FIFO_TXFIFO_FULL			(1<<11)
#define FIFO_TXFIFO_ALMOST_FULL	(1<<10)
#define FIFO_RXFIFO_EMPTY			(1<<3)
#define FIFO_RXFIFO_ALMOST_EMPTY	(1<<2)
#define FIFO_RXFIFO_FULL			(1<<1)
#define FIFO_RXFIFO_ALMOST_FULL	(1<<0)


//PCM_INT
#define EN_IRQ_TO_ARM			(1<<14)//ctrl
#define IRQ_PENDING				(1<<13)//stat
#define TRANSFER_DONE			(1<<12)

#define TXFIFO_EMPTY			(1<<11)
#define TXFIFO_ALMOST_EMPTY	(1<<10)
#define TXFIFO_FULL				(1<<9)
#define TXFIFO_ALMOST_FULL		(1<<8)
#define TXFIFO_ERROR_STARVE	(1<<7)
#define TXFIFO_ERROR_OVERFLOW	(1<<6)

#define RXFIFO_EMPTY			(1<<5)
#define RXFIFO_ALMOST_EMPTY	(1<<4)
#define RXFIFO_FULL				(1<<3)
#define RXFIFO_ALMOST_FULL		(1<<2)
#define RXFIFO_ERROR_STARVE	(1<<1)
#define RXFIFO_ERROR_OVERFLOW	(1<<0)

#define CLRINT	(1<<0)//clrint
///////////////////////////////////////////////////////////////////////////////////////

typedef struct
{
	unsigned int		CodecID;
	unsigned char		PCMIpNum;

	AUDIO_CLKSRC	m_AudioCLKSRC;		
	unsigned char		PCMClkSrc;
	
	unsigned int 		EXTCDCLKFreq;

	unsigned int		PCMSync;
//	unsigned int		PCMSClk;	
	unsigned int 		m_RFS;
	unsigned int 		m_BFS;

	
	unsigned char		PCMMSBPosition;	
	
	unsigned char		Playmode;//0.polling 1. interrupt 2. dma
	unsigned char		DMAtu;//transfer unit : 1-byte 2-2byte 4-4byte(word)
	unsigned char		DMABurst;//transfer unit : 1-byte 2-2byte 4-4byte(word)	
	unsigned char		RECsec;
	u8 				useMic;
}PCM_State;

typedef struct
{
	unsigned int 	irqstat1;//before clearint
	unsigned int 	irqstat2;//after clearint	
}PCM_IRQstat;
#define PCM_IRQ_STAT_MAX	20
///////////////////////////////////////////////////////////////////////////////////////

//Inits.
void PCM_Init(void);
void PCM_SetPort(unsigned char eIPnum);

//APIs
void PCM_TXFIFOwaitTillFULL();
void PCM_TXFIFOwaitTillEmpty();

u8 PCM_CLKGenerate(unsigned char eIPnum);
void PCM_PCMSetting();
void PCM_ClearInt(void);
void PCM_EnableInt(void);
void PCM_DisableInt(void);
void PCM_SetInt(unsigned int ePcmInt);

void PCM_Outp32(unsigned char  eIPnum, PCM_SFR offset, u32 x) ;
void PCM_Outp16(unsigned char  eIPnum, PCM_SFR offset, u32 x) ;
u32  PCM_Inp32(unsigned char  eIPnum, PCM_SFR offset);
u16 PCM_Inp16(unsigned char  eIPnum, PCM_SFR offset);


//Test base
u8 PCM_PCMInDMA(unsigned int uRecBufferAddr, unsigned int uPcmSize, u8 (*fn_extra)(void));
u8 PCM_PCMOutDMA(unsigned int uRecBufferAddr, unsigned int uPcmSize, u8 (*fn_extra)(void));

void PCM_PCMInInt(unsigned int uRecBufferAddr, unsigned int uPcmSize);
void PCM_PCMOutInt(unsigned int uRecBufferAddr, unsigned int uPcmSize);

void PCM_PCMOutInt2(unsigned int uBufferAddr, unsigned int uPcmSize);

//extra bit by bit test
void PCM_pcmtest4(void);


void PCM_ISRInit(void (*handler)(void) __irq);
void PCM_ISRInit2(void);
void PCM_ISRDeInit(void);
void __irq Isr_PCM_Interrupt(void);
void __irq Isr_PCM_InterruptTEST(void);
void __irq Isr_PCM_PCMIn_DMADone(void);
void __irq Isr_PCM_PCMOut_DMADone(void);
void __irq Isr_PCM_PCMInOut_DMADone(void);
void __irq Isr_PCM_PCMIn(void);
void __irq Isr_PCM_PCMOut(void);
void __irq Isr_PCM_PCMOut2(void);


//void PCM_WM8753MasterCLKGen(unsigned char eIPnum);



#ifdef __cplusplus
}
#endif

#endif /*__PCM_H__*/

