/********************************************************************************
* 
*	Project Name : S5PV210 FPGA Validation
*
*	Copyright 2009 by Samsung Electronics, Inc.
*	All rights reserved.
*
*	Project Description :
*		This software is only for verifying functions of the S5PV210 FPGA
*		Anybody can use this software without our permission.
*  
*--------------------------------------------------------------------------------
* 
*	File Name : PCM.c
*  
*	File Description :
*
*	Author	: Jongseok,Park
*	Dept. : AP Development Team
*	Created Date : 2009/04/16
*	Version : 0.4 
*
*	Author	: Yoh-Han Lee
*	Dept. : AP Development Team
*	Created Date : 2007/03/16
*	Version : 0.3 
* 
* 
*	History
*	- Version 0.1 (2007/03/16)
*	  -> Available with AK2440 PCM Codec.
*   - Version 0.2 (2007/04/
*	  -> Available with 8753/9713
*   - Version 0.3 (2008/04/ :
*	  -> updated 9713 part, orgarnize source structure
*   - Version 0.4 (2009/04/16 :
*	  -> S5PV210 FPGA Validation, test under WM8580, By Jongseok,Park
*********************************************************************************/


#include "def.h"
#include "option.h"
#include "library.h"
#include "v210_sfr.h"
#include "system.h"
#include "intc.h"
#include "dma.h"
#include "gpio.h"
#include "audiolibrary\audiocodecs.h"

#include "sysc.h"
#include "pcm.h"
#include "SfrReadWriten.h"
#include "smdk.h"


// Global variables
int g_interrupt_cnt=0;
PCM_IRQstat g_pcmirqstat[PCM_IRQ_STAT_MAX];
extern PCM_State 		g_oPCMState;

volatile DMAC 		oPCMDma[3];

// SFR test	
REGINFOn	sRegInfoPCM0[] = 
{ 
    //01234567890123            address               reset        uPrivateBitMask(1:do check)
    //												  value       
	{"PCM_CTL0 ",		PCM0_BASE+0x00, 19-1, RW, 0x0		, DPDB, 0,0},	    
	{"PCM_CLKCTL0 ",		PCM0_BASE+0x04, 20-1, RW, 0x0		, DPDB, 0,0},	    
	{"PCM_TXFIFO0 ",		PCM0_BASE+0x08, 17-1, RW, 0x10000	, DPDB, 0,0},//r/w should be check via pcm link
	{"PCM_RXFIFO0 ",		PCM0_BASE+0x0c, 17-1, RW, 0x10000	, DPDB, 0,0},//r/w should be check via pcm link
	{"PCM_IRQ_CTL0 ",	PCM0_BASE+0x10, 15-1, RW, 0x0		, DPDB, 0,0},	    
	{"PCM_IRQ_STAT0 ",	PCM0_BASE+0x14, 14-1, RO, 0x0		, DPDB, 0,0},	    
	{"PCM_FIFO_STAT0 ",	PCM0_BASE+0x18, 20-1, RO, 0x0		, DPDB, 0,0},	    
	{"PCM_CLRINT0 ",		PCM0_BASE+0x20, 1-1 , WO, 0x0		, DPDB, 0,0},
};

REGINFOn	sRegInfoPCM1[] = 
{ 
    //01234567890123            address               reset        uPrivateBitMask(1:do check)
    //												  value       
	{"PCM_CTL1 ",		PCM1_BASE+0x00, 19-1, RW, 0x0		, DPDB, 0,0},	    
	{"PCM_CLKCTL1 ",		PCM1_BASE+0x04, 20-1, RW, 0x0		, DPDB, 0,0},	    
	{"PCM_TXFIFO1 ",		PCM1_BASE+0x08, 17-1, RW, 0x10000	, DPDB, 0,0},//r/w should be check via pcm link
	{"PCM_RXFIFO1 ",		PCM1_BASE+0x0c, 17-1, RW, 0x10000	, DPDB, 0,0},//r/w should be check via pcm link
	{"PCM_IRQ_CTL1 ",	PCM1_BASE+0x10, 15-1, RW, 0x0		, DPDB, 0,0},	    
	{"PCM_IRQ_STAT1 ",	PCM1_BASE+0x14, 14-1, RO, 0x0		, DPDB, 0,0},	    
	{"PCM_FIFO_STAT1 ",	PCM1_BASE+0x18, 20-1, RO, 0x0		, DPDB, 0,0},	    
	{"PCM_CLRINT1 ",		PCM1_BASE+0x20, 1-1 , WO, 0x0		, DPDB, 0,0},
};

REGINFOn	sRegInfoPCM2[] = 
{ 
    //01234567890123            address               reset        uPrivateBitMask(1:do check)
    //												  value       
	{"PCM_CTL2 ",		PCM2_BASE+0x00, 19-1, RW, 0x0		, DPDB, 0,0},	    
	{"PCM_CLKCTL2 ",		PCM2_BASE+0x04, 20-1, RW, 0x0		, DPDB, 0,0},	    
	{"PCM_TXFIFO2 ",		PCM2_BASE+0x08, 17-1, RW, 0x10000	, DPDB, 0,0},//r/w should be check via pcm link
	{"PCM_RXFIFO2 ",		PCM2_BASE+0x0c, 17-1, RW, 0x10000	, DPDB, 0,0},//r/w should be check via pcm link
	{"PCM_IRQ_CTL2 ",	PCM2_BASE+0x10, 15-1, RW, 0x0		, DPDB, 0,0},	    
	{"PCM_IRQ_STAT2 ",	PCM2_BASE+0x14, 14-1, RO, 0x0		, DPDB, 0,0},	    
	{"PCM_FIFO_STAT2 ",	PCM2_BASE+0x18, 20-1, RO, 0x0		, DPDB, 0,0},	    
	{"PCM_CLRINT2 ",		PCM2_BASE+0x20, 1-1 , WO, 0x0		, DPDB, 0,0},
};



// Externs
extern PCM_State 		g_oPCMState;
//extern	unsigned int ARMCLK, HCLK, PCLK;


//should execute at first
u8 PCM_SFR_testsub(int Port)
{
	u8 bret;
	if(Port == 0)
		bret=TestSFRn(sRegInfoPCM0, sizeof(sRegInfoPCM0)/sizeof(REGINFOn));
	else if(Port == 1)
		bret=TestSFRn(sRegInfoPCM1, sizeof(sRegInfoPCM1)/sizeof(REGINFOn));
	else if(Port == 2)
		bret=TestSFRn(sRegInfoPCM2, sizeof(sRegInfoPCM2)/sizeof(REGINFOn));	
	return bret;
}

volatile char g_PcmRecDone;
volatile char g_PcmPlayDone;

unsigned short* g_uPcmRecBuffer;
unsigned short* g_uPcmEndRecBuffer;

unsigned int* g_uPcmBuffer32;
unsigned int* g_uPcmEndBuffer32;

unsigned int	g_uPcmIrqStateFlag=0;

//prototype
u8 IS_TXFIFO_Status(unsigned char PCMIpNum,unsigned int CheckStatus);
	

//////////
// Function Name : PCM_Configure
// Function Desctiption : This fucntion initialize S3C6400  sturct of PCM State.
// Input : None
// Output : ocPCMstate (PCM State Structure)
// Version : 0.0
// Author : Sung-Hyun, Na


void PCM_Init(void)
{
	//Codec ID
//	g_oPCMState.CodecID = PCM_CODEC_NAME;
	
	//Set Gpio Port 
	g_oPCMState.PCMIpNum = PCM_IP1;

	g_oPCMState.PCMClkSrc = PCM_EXTCLK;
	g_oPCMState.m_AudioCLKSRC= eAUDIO_PCMCDCLK;	
	g_oPCMState.EXTCDCLKFreq = I2S_PCMCDCLK_HZ;//384fs(16.9344Mhz), 256fs (2048kHz)
	
	//PCMSCLK Selection 
	//g_oPCMState.PCMSClk= SCLK_256K;//32fs
	
//	g_oPCMState.m_RFS= RFS_384fs;
	g_oPCMState.m_RFS= 384;
	g_oPCMState.m_BFS= 32;//32fs
	
	//Sync CLK Selection 
	g_oPCMState.PCMSync = 44100;	
	
	//MSB Postion Selection
	g_oPCMState.PCMMSBPosition = DURING_PCMSYNC_HIGH;
	g_oPCMState.Playmode = PCM_DMA;
	g_oPCMState.DMAtu = WORD; //BYTE, HWORD, WORD, DWORD
	g_oPCMState.RECsec = 10;
	g_oPCMState.DMABurst = SINGLE;	
	
	//Init GPIO Port
	//	PCM_SetPort(g_oPCMState.PCMIpNum);
	//	PCM_SetAudioPath(g_oPCMState.PCMIpNum);
	//	PCM_SelClkSrc(g_oPCMState.PCMIpNum, g_oPCMState.PCMClkSrc, 1);
}



//set pcmclk src before this // or when changed do one more time.
void PCM_SetPort(unsigned char eIPnum)
{
	AUDIO_GPIOPORT eGPIOPort;
		
	eGPIOPort = (eIPnum == PCM_IP1)?AUDIO_GPIOPORT1 :
				(eIPnum == PCM_IP0)? AUDIO_GPIOPORT2:
				(eIPnum == PCM_IP2)? AUDIO_GPIOPORT0:					
									AUDIO_GPIOPORT_NONE;


	if (eGPIOPort == AUDIO_GPIOPORT0)// gpio port share with audio port1(i2s0)
	{
		GPIO_SetFunctionEach(eGPIO_I,eGPIO_0,eGFunc_1);//PCM2  sclk
		GPIO_SetFunctionEach(eGPIO_I,eGPIO_1,eGFunc_1);//pcm2 extclk
		GPIO_SetFunctionEach(eGPIO_I,eGPIO_2,eGFunc_1);//pcm2 fsync
		GPIO_SetFunctionEach(eGPIO_I,eGPIO_3,eGFunc_1);//pcm sdi
		GPIO_SetFunctionEach(eGPIO_I,eGPIO_4,eGFunc_1);//pcm sdo
									
		GPIO_SetPullUpDownEach(eGPIO_I,eGPIO_0,eGPUDdis);
		GPIO_SetPullUpDownEach(eGPIO_I,eGPIO_1,eGPUDdis);			
		GPIO_SetPullUpDownEach(eGPIO_I,eGPIO_2,eGPUDdis);
		GPIO_SetPullUpDownEach(eGPIO_I,eGPIO_3,eGPUDdis);
		GPIO_SetPullUpDownEach(eGPIO_I,eGPIO_4,eGPUDdis);// pull-up/down disable

		//master
		GPIO_SetDSEach(eGPIO_I,eGPIO_0,1);  /// 2X - sclk out for Codec primary in case of recording from codec line in
		GPIO_SetDSEach(eGPIO_I,eGPIO_1,0);  /// 2X 
		GPIO_SetDSEach(eGPIO_I,eGPIO_2,1);  /// 2X - fsync
		GPIO_SetDSEach(eGPIO_I,eGPIO_3,0);  /// 2X 		
		GPIO_SetDSEach(eGPIO_I,eGPIO_4,1);  /// 2X - Sdo
		
	} 
	else if (eGPIOPort == AUDIO_GPIOPORT1)//clock source is from audio 1, gpio port share with audio port1(i2s1)
	{

		GPIO_SetFunctionEach(eGPIO_C0,eGPIO_0,eGFunc_1);//PCM1  sclk
		GPIO_SetFunctionEach(eGPIO_C0,eGPIO_1,eGFunc_1);//pcm1 extclk
		GPIO_SetFunctionEach(eGPIO_C0,eGPIO_2,eGFunc_1);//fsync
		GPIO_SetFunctionEach(eGPIO_C0,eGPIO_3,eGFunc_1);//sdi
		GPIO_SetFunctionEach(eGPIO_C0,eGPIO_4,eGFunc_1);//sdo
									
		GPIO_SetPullUpDownEach(eGPIO_C0,eGPIO_0,eGPUDdis);
		GPIO_SetPullUpDownEach(eGPIO_C0,eGPIO_1,eGPUDdis);			
		GPIO_SetPullUpDownEach(eGPIO_C0,eGPIO_2,eGPUDdis);
		GPIO_SetPullUpDownEach(eGPIO_C0,eGPIO_3,eGPUDdis);
		GPIO_SetPullUpDownEach(eGPIO_C0,eGPIO_4,eGPUDdis);// pull-up/down disable

		//master
		GPIO_SetDSEach(eGPIO_C0,eGPIO_0,1);  /// 2X - sclk out for Codec primary in case of recording from codec line in
		GPIO_SetDSEach(eGPIO_C0,eGPIO_1,0);  /// 2X 
		GPIO_SetDSEach(eGPIO_C0,eGPIO_2,1);  /// 2X - fsync
		GPIO_SetDSEach(eGPIO_C0,eGPIO_3,0);  /// 2X 		
		GPIO_SetDSEach(eGPIO_C0,eGPIO_4,1);  /// 2X - Sdo
		
	} 
	else if(eGPIOPort == AUDIO_GPIOPORT2)// gpio port share with audio port2(i2s2)
	{
		GPIO_SetFunctionEach(eGPIO_C1,eGPIO_0,eGFunc_0);//PCM0 sclk
	 	GPIO_SetFunctionEach(eGPIO_C1,eGPIO_1,eGFunc_0);//pcm0 extclk
		GPIO_SetFunctionEach(eGPIO_C1,eGPIO_2,eGFunc_0);//pcm0 fsync
		GPIO_SetFunctionEach(eGPIO_C1,eGPIO_3,eGFunc_0);//pcm0 sdi
		GPIO_SetFunctionEach(eGPIO_C1,eGPIO_4,eGFunc_0);//pcm0 sdo
									
		GPIO_SetPullUpDownEach(eGPIO_C1,eGPIO_0,eGPUDdis);
		GPIO_SetPullUpDownEach(eGPIO_C1,eGPIO_1,eGPUen);	//pcm0 extclk Pullup enable		
		GPIO_SetPullUpDownEach(eGPIO_C1,eGPIO_2,eGPUDdis);
		GPIO_SetPullUpDownEach(eGPIO_C1,eGPIO_3,eGPUDdis);
		GPIO_SetPullUpDownEach(eGPIO_C1,eGPIO_4,eGPUDdis);// pull-up/down disable

		//master
		GPIO_SetDSEach(eGPIO_C1,eGPIO_0,3);  /// 2X - sclk out for Codec primary in case of recording from codec line in
		GPIO_SetDSEach(eGPIO_C1,eGPIO_1,0);  ///  
		GPIO_SetDSEach(eGPIO_C1,eGPIO_2,3);  /// 2X - fsync
		GPIO_SetDSEach(eGPIO_C1,eGPIO_3,0);  /// 		
		GPIO_SetDSEach(eGPIO_C1,eGPIO_4,3);  /// 2X - Sdo		
	}



}





////////////////////////////////////////////////////////////////////////////////////////////////////////////////




void PCM_fifostat()
{
	int fifostat=PCM_Inp32(g_oPCMState.PCMIpNum, rPCMFIFOSTAT);
	int irqstat=PCM_Inp32(g_oPCMState.PCMIpNum, rPCMIRQSTAT);
	int	irqctrl=PCM_Inp32(g_oPCMState.PCMIpNum, rPCMIRQCTL);
	Disp("FIFO STAT : 0x%x tx_fifo_cnt : %d rx_fifo_cnt : %d %s%s%s%s %s%s%s%s \n", fifostat, fifostat>>14, (fifostat>>4)&0x3f,
								(fifostat & FIFO_TXFIFO_EMPTY  			)?"TX empty  ":"",
								(fifostat & FIFO_TXFIFO_ALMOST_EMPTY	)?"TX almost empty  ":"",
								(fifostat & FIFO_TXFIFO_FULL   			)?"TX full  ":"",
								(fifostat & FIFO_TXFIFO_ALMOST_FULL 	)?"TX almost full  ":"",
								
								(fifostat & FIFO_RXFIFO_EMPTY  			)?"RX empty  ":"",
								(fifostat & FIFO_RXFIFO_ALMOST_EMPTY	)?"RX almost empty  ":"",
								(fifostat & FIFO_RXFIFO_FULL   			)?"RX full  ":"",
								(fifostat & FIFO_RXFIFO_ALMOST_FULL 	)?"RX almost full  ":""								
								);
	Disp("IRQ  STAT : 0x%x  %s%s %s%s%s%s%s%s %s%s%s%s%s%s\n", irqstat,
								(irqstat & IRQ_PENDING			)?"irq pending  ":"",
								(irqstat & TRANSFER_DONE 		)?"transfer done  ":"",
								
								(irqstat & TXFIFO_EMPTY  		)?"TX empty  ":"",
								(irqstat & TXFIFO_ALMOST_EMPTY	)?"TX almost empty  ":"",								
								(irqstat & TXFIFO_FULL   		)?"TX full  ":"",
								(irqstat & TXFIFO_ALMOST_FULL 	)?"TX almost full  ":"",
								(irqstat & TXFIFO_ERROR_STARVE 	)?"TX starve  ":"",
								(irqstat & TXFIFO_ERROR_OVERFLOW)?"TX overflow  ":"",
								
								(irqstat & RXFIFO_EMPTY  		)?"RX empty  ":"",
								(irqstat & RXFIFO_ALMOST_EMPTY	)?"RX almost empty  ":"",								
								(irqstat & RXFIFO_FULL   		)?"RX full  ":"",
								(irqstat & RXFIFO_ALMOST_FULL 	)?"RX almost full  ":"",
								(irqstat & RXFIFO_ERROR_STARVE 	)?"RX starve  ":"",
								(irqstat & RXFIFO_ERROR_OVERFLOW)?"RX overflow  ":""								
								 );
	Disp("IRQ  CTRL : 0x%x %s%s %s%s%s%s%s%s %s%s%s%s%s%s\n", irqctrl,	
								(irqctrl & EN_IRQ_TO_ARM 		)?"en irq to arm  ":"",
								(irqctrl & TRANSFER_DONE 		)?"transfer done  ":"",
								
								(irqctrl & TXFIFO_EMPTY  		)?"TX empty  ":"",
								(irqctrl & TXFIFO_ALMOST_EMPTY	)?"TX almost empty  ":"",								
								(irqctrl & TXFIFO_FULL   		)?"TX full  ":"",
								(irqctrl & TXFIFO_ALMOST_FULL 	)?"TX almost full  ":"",
								(irqctrl & TXFIFO_ERROR_STARVE 	)?"TX starve  ":"",
								(irqctrl & TXFIFO_ERROR_OVERFLOW)?"TX overflow  ":"",
								
								(irqctrl & RXFIFO_EMPTY  		)?"RX empty  ":"",
								(irqctrl & RXFIFO_ALMOST_EMPTY	)?"RX almost empty  ":"",								
								(irqctrl & RXFIFO_FULL   		)?"RX full  ":"",
								(irqctrl & RXFIFO_ALMOST_FULL 	)?"RX almost full  ":"",
								(irqctrl & RXFIFO_ERROR_STARVE 	)?"RX starve  ":"",
								(irqctrl & RXFIFO_ERROR_OVERFLOW)?"RX overflow  ":""								
								 );
	
}




void __irq Isr_PCM_PCMOut_DMADone(void)
{
	u32 uDmaIntStatus;

	INTC_Disable(NUM_PDMA1);//NUM_PDMA0
	UART_Printf("\n[OUT DMA DONE !]");
	DMA_GetIntrSrc(&uDmaIntStatus, &(oPCMDma[g_oPCMState.PCMIpNum]));
	//UART_Printf("\nPCMOut_DMADone!(%d,%d)\n",uDmaIntStatus,oPCMDma[g_oPCMState.PCMIpNum].m_eDreqSrc);		
	DMA_ClearIntPending(uDmaIntStatus, &(oPCMDma[g_oPCMState.PCMIpNum]));	// Interrupt Clear

	INTC_ClearVectAddr();
	//UART_Printf("PCM TX DMA Done ~~~\n");	
	g_PcmPlayDone=1;
}



//ISR fifo access unit : 32bit
u8 PCM_PCMOutDMA(unsigned int uPlayBufferAddr, unsigned int uPcmSize, u8 (*fn_extra)(void))
{
	unsigned char uChar;
	int i;

	int cnt=0;
	u8 bret = TRUE;
	u32 temp1, temp2;
	DREQ_SRC u_eSrc;
	
	g_PcmPlayDone=0;

	//PCM_SetInt(TXFIFO_ERROR_STARVE);	//underrun
	INTC_SetVectAddr(NUM_PDMA1 ,Isr_PCM_PCMOut_DMADone);//ok. NUM_PDMA0 dma interrpt
	INTC_Enable(NUM_PDMA1);//by only dma1


	//DMA setting
	if(g_oPCMState.PCMIpNum==PCM_IP0)
		u_eSrc = PCM0_TX;
	else  if(g_oPCMState.PCMIpNum==PCM_IP1)
		u_eSrc = PCM1_TX;
	else
		u_eSrc = PCM2_TX;

	DMA_SetCh(DMA_12,&(oPCMDma[g_oPCMState.PCMIpNum]));//ok. peri 0
	DMA_InitCh(g_oPCMState.DMAtu/*WORD*/ , u_eSrc, DMA_M2P, g_oPCMState.DMABurst/*SINGLE*/, &(oPCMDma[g_oPCMState.PCMIpNum]));//ok

								
	//Disp("\nListen to Sound via Speak Out Connector.\n");
	//Disp("Press any key to play.\n");
	//if(fn_extra==NULL) UART_Getc();
  	
	//Enable

	PCM_Outp32(g_oPCMState.PCMIpNum, rPCMCTRL, (TXFIFO_DIPSTICK(0x8) | PCM_TX_DMA_EN | PCM_TXFIFO_EN ) );//fifo flush, dma enable

	if (g_oPCMState.PCMIpNum==PCM_IP1)
		DMA_StartCh((u32)uPlayBufferAddr, (u32)(PCM1_BASE+rPCMTXFIFO),uPcmSize/4, &(oPCMDma[g_oPCMState.PCMIpNum]));//ok
	else if (g_oPCMState.PCMIpNum==PCM_IP0)
		DMA_StartCh((u32)uPlayBufferAddr, (u32)(PCM0_BASE+rPCMTXFIFO),uPcmSize/4, &(oPCMDma[g_oPCMState.PCMIpNum]));//ok
	else
		DMA_StartCh((u32)uPlayBufferAddr, (u32)(PCM2_BASE+rPCMTXFIFO),uPcmSize/4, &(oPCMDma[g_oPCMState.PCMIpNum]));//ok		

		
//	PCM_TXFIFOwaitTillFULL();//wait till fifo is almost full - dma not work at this point...)if pcm_enable is 1, it work...)
//	PCM_EnableInt();
	temp1=PCM_Inp32(g_oPCMState.PCMIpNum, rPCMCLKCTL);
	temp2=PCM_Inp32(g_oPCMState.PCMIpNum, rPCMCTRL);
	PCM_Outp32(g_oPCMState.PCMIpNum, rPCMCLKCTL, (temp1 | PCM_SCLK_EN)  );
	PCM_Outp32(g_oPCMState.PCMIpNum, rPCMCTRL,    (temp2 | PCM_PCM_ENABLE)  );
	
	Disp("\nIf you want to exit, Press the 'x' key.\n");
	while(g_PcmPlayDone==0)
	{		
		uChar = UART_GetKey();
		
		if( (uChar == 'x') | (uChar == 'X'))  
		{
			Disp("User Break~!!\n");
			break;
		}	
		
		if(cnt == 2 && fn_extra!=NULL) 
		{
			bret = fn_extra();
			Disp("What Break ??\n");
			break;
		} 
		cnt++;
	} 
	
	//Disp("g_PcmPlayDone flag : %d\n",g_PcmPlayDone);

	DMA_StopCh( &(oPCMDma[g_oPCMState.PCMIpNum]) );
//	PCM_DisableInt();
	PCM_TXFIFOwaitTillEmpty();
	temp1=PCM_Inp32(g_oPCMState.PCMIpNum, rPCMCLKCTL);
	temp2=PCM_Inp32(g_oPCMState.PCMIpNum, rPCMCTRL);
	PCM_Outp32(g_oPCMState.PCMIpNum, rPCMCLKCTL, (temp1 & ~PCM_SCLK_EN)  );
	PCM_Outp32(g_oPCMState.PCMIpNum, rPCMCTRL,    (temp2 & ~(PCM_PCM_ENABLE|PCM_TXFIFO_EN|PCM_TX_DMA_EN) )   );
  	Disp("\nEnd of Play!\n");

  	
  	return bret;
}


void __irq Isr_PCM_PCMIn_DMADone(void)
{
	u32 uDmaIntStatus;

	INTC_Disable(NUM_PDMA1);//NUM_PDMA1
	UART_Printf("\n[IN DMA DONE !]");
	
	DMA_GetIntrSrc(&uDmaIntStatus, &(oPCMDma[g_oPCMState.PCMIpNum]));
	//UART_Printf("\nPCMIn_DMADone!(%d,%d)\n",uDmaIntStatus,oPCMDma[g_oPCMState.PCMIpNum].m_eDreqSrc);			
	DMA_ClearIntPending(uDmaIntStatus, &(oPCMDma[g_oPCMState.PCMIpNum]));	// Interrupt Clear

	INTC_ClearVectAddr();
	//UART_Printf("PCM RX DMA Done ~~~\n");	
	g_PcmRecDone=1;
}

//pcmsize(byte) 16bit mono continous format
//ISR fifo access unit : 32bit
u8 PCM_PCMInDMA(unsigned int uRecBufferAddr, unsigned int uPcmSize, u8 (*fn_extra)(void))
{
	unsigned char uChar;
	
	int i;
	int cnt=0;	
	u8 bret = TRUE;
	u32 temp1, temp2;
	DREQ_SRC u_eSrc;
	
	g_PcmRecDone = 0;
	
	INTC_SetVectAddr(NUM_PDMA1 ,Isr_PCM_PCMIn_DMADone);//ok. NUM_PDMA1 dma interrpt
	INTC_Enable(NUM_PDMA1);//by only dma1

	//DMA setting
	if(g_oPCMState.PCMIpNum==PCM_IP0)
		u_eSrc = PCM0_RX;
	else  if(g_oPCMState.PCMIpNum==PCM_IP1)
		u_eSrc = PCM1_RX;
	else
		u_eSrc = PCM2_RX;

	DMA_SetCh(DMA_13,&(oPCMDma[g_oPCMState.PCMIpNum]));//ok. peri 1
	DMA_InitCh(g_oPCMState.DMAtu/*WORD*/ , u_eSrc, DMA_P2M, g_oPCMState.DMABurst/*SINGLE*/, &(oPCMDma[g_oPCMState.PCMIpNum]));//ok
	
   	Disp("Supply Sound to PCM CODEC via Line In(WM8580)/Mic(WM8580) Connector.\n");
    	Disp("Press any key to record.\n");
    
   	 if(fn_extra==NULL) getchar();
   		Disp("Recording...\n");

	//Enable
	//for dma rxfifo dipstick is don't care
	PCM_Outp32(g_oPCMState.PCMIpNum, rPCMCTRL, (RXFIFO_DIPSTICK(0x8) | PCM_RX_DMA_EN | PCM_RXFIFO_EN ) );//fifo flush, dma enable
	if (g_oPCMState.PCMIpNum==PCM_IP1)
		DMA_StartCh( (u32)(PCM1_BASE+rPCMRXFIFO), (u32)uRecBufferAddr, uPcmSize/4, &(oPCMDma[g_oPCMState.PCMIpNum]));//ok
	else if (g_oPCMState.PCMIpNum==PCM_IP0)
		DMA_StartCh(  (u32)(PCM0_BASE+rPCMRXFIFO), (u32)uRecBufferAddr, uPcmSize/4, &(oPCMDma[g_oPCMState.PCMIpNum]));//ok
	else
		DMA_StartCh(  (u32)(PCM2_BASE+rPCMRXFIFO), (u32)uRecBufferAddr, uPcmSize/4, &(oPCMDma[g_oPCMState.PCMIpNum]));//ok
	
	//PCM_EnableInt();
	temp1=PCM_Inp32(g_oPCMState.PCMIpNum, rPCMCLKCTL);
	temp2=PCM_Inp32(g_oPCMState.PCMIpNum, rPCMCTRL);
	PCM_Outp32(g_oPCMState.PCMIpNum, rPCMCLKCTL, (temp1 | PCM_SCLK_EN)  );
	PCM_Outp32(g_oPCMState.PCMIpNum, rPCMCTRL,    (temp2 | PCM_PCM_ENABLE)  );


	while(g_PcmRecDone ==0)
    {
		//Disp(".");
        	//Delay(1000);
        
		uChar = UART_GetKey();
		if( (uChar == 'x') | (uChar == 'X')) 		break;
			
		if(cnt == 2 && fn_extra!=NULL) 
		{
			bret = fn_extra();
			break;
		} 
		cnt++;
    }

	DMA_StopCh( &(oPCMDma[g_oPCMState.PCMIpNum]) );
	//PCM_DisableInt();	
	temp1=PCM_Inp32(g_oPCMState.PCMIpNum, rPCMCLKCTL);
	temp2=PCM_Inp32(g_oPCMState.PCMIpNum, rPCMCTRL);
	PCM_Outp32(g_oPCMState.PCMIpNum, rPCMCLKCTL, (temp1 & ~PCM_SCLK_EN)  );
	PCM_Outp32(g_oPCMState.PCMIpNum, rPCMCTRL,    (temp2 & ~(PCM_PCM_ENABLE|PCM_RXFIFO_EN|PCM_RX_DMA_EN) )   );
  	Disp("\nEnd of Record!\n");

  	return bret;
}


void __irq Isr_PCM_PCMInOut_DMADone(void)
{
	u32 i=0;
	u32 uDmaIntStatus0,uDmaIntStatus1;
	u32 TX_DMAdone=0,RX_DMAdone=0;;	
	
	Delay(100); //for waiting RX DMA interrupt Done..(jspark)
	UART_Printf("\n[IN/OUT DMA DONE !]");
	
	INTC_Disable(NUM_PDMA1);//NUM_PDMA0

//	DMA_GetIntrSrc(&uDmaIntStatus0, &(oPCMDma[0])); //for TX
//	DMA_GetIntrSrc(&uDmaIntStatus1, &(oPCMDma[1])); //for RX

	uDmaIntStatus0 = Inp32(oPCMDma[0].m_uBaseAddr+0x28 /*DMA_INTSTATUS*/);
//	uDmaIntStatus1 = Inp32(oPCMDma[1].m_uBaseAddr+0x28 /*DMA_INTSTATUS*/);

	//UART_Printf("\nPCM_INOUT DMA_DONE!(%d,%d,%d) ",uDmaIntStatus0,oPCMDma[0].m_uChNum,oPCMDma[1].m_uChNum);

	if (uDmaIntStatus0 & (1<<oPCMDma[0].m_uChNum))
		TX_DMAdone=1;
	if (uDmaIntStatus0 & (1<<oPCMDma[1].m_uChNum))
		RX_DMAdone=1;

			
	
	//Interrupt Pending Bit Clear / Flag Active!	
	if(TX_DMAdone)
	{
		DMA_ClearIntPending(oPCMDma[0].m_uChNum, &(oPCMDma[0]));	// Interrupt Clear
		//UART_Printf("\nTX DMA Done!");	
		g_PcmPlayDone=1;
	}

	if(RX_DMAdone)
	{
		DMA_ClearIntPending(oPCMDma[1].m_uChNum, &(oPCMDma[1]));	// Interrupt Clear
		//UART_Printf("\nRX DMA Done!");	
		g_PcmRecDone=1;
	}

	//Pending Bit ALL Clear
	for (i=0;i<32;i++) 
	{
		DMA_ClearIntPending(i, &(oPCMDma[0]));		
		DMA_ClearIntPending(i, &(oPCMDma[1]));
	}
	INTC_ClearVectAddr();

}



//ISR fifo access unit : 32bit
u8 PCM_PCMInOutDMA(unsigned int uPlayBufferAddr, unsigned int uRecBufferAddr, unsigned int uPcmSize, u8 (*fn_extra)(void))
{
	unsigned char uChar;
	int cnt=0;
	int i;
	u32 temp1, temp2;

	g_PcmRecDone = 0;
    	g_PcmPlayDone = 0;

	INTC_SetVectAddr(NUM_PDMA1 ,Isr_PCM_PCMInOut_DMADone);//ok. NUM_PDMA0 dma interrpt
	INTC_Enable(NUM_PDMA1);//by only dma1

	if(g_oPCMState.PCMIpNum==PCM_IP1)
	{
		DMA_SetCh(DMA_12,&(oPCMDma[0]));//ok. peri 1 -  tx
		DMA_InitCh(g_oPCMState.DMAtu/*WORD*/ , PCM1_TX, DMA_M2P, g_oPCMState.DMABurst/*SINGLE*/, &(oPCMDma[0]));//ok
		DMA_SetCh(DMA_13,&(oPCMDma[1]));//ok. peri 1 - rx
		DMA_InitCh(g_oPCMState.DMAtu/*WORD*/ , PCM1_RX, DMA_P2M, g_oPCMState.DMABurst/*SINGLE*/, &(oPCMDma[1]));//ok

	}else if (g_oPCMState.PCMIpNum==PCM_IP0)
	{
		DMA_SetCh(DMA_12,&(oPCMDma[0]));//ok. peri 1
		DMA_InitCh(g_oPCMState.DMAtu/*WORD*/ , PCM0_TX, DMA_M2P, g_oPCMState.DMABurst/*SINGLE*/, &(oPCMDma[0]));//ok
		DMA_SetCh(DMA_13,&(oPCMDma[1]));//ok. peri 1
		DMA_InitCh(g_oPCMState.DMAtu/*WORD*/ , PCM0_RX, DMA_P2M, g_oPCMState.DMABurst/*SINGLE*/, &(oPCMDma[1]));//ok
	}
	else
	{
		DMA_SetCh(DMA_12,&(oPCMDma[0]));//ok. peri 1
		DMA_InitCh(g_oPCMState.DMAtu/*WORD*/ , PCM2_TX, DMA_M2P, g_oPCMState.DMABurst/*SINGLE*/, &(oPCMDma[0]));//ok
		DMA_SetCh(DMA_13,&(oPCMDma[1]));//ok. peri 1
		DMA_InitCh(g_oPCMState.DMAtu/*WORD*/ , PCM2_RX, DMA_P2M, g_oPCMState.DMABurst/*SINGLE*/, &(oPCMDma[1]));//ok
	}


	//Enable
	PCM_Outp32(g_oPCMState.PCMIpNum, rPCMCTRL, (TXFIFO_DIPSTICK(0x8) | PCM_TX_DMA_EN | PCM_TXFIFO_EN |
											          RXFIFO_DIPSTICK(0x8) | PCM_RX_DMA_EN | PCM_RXFIFO_EN) );//fifo flush, dma enable
	
	if (g_oPCMState.PCMIpNum==PCM_IP1)
	{
		DMA_StartCh( (u32)(PCM1_BASE+rPCMRXFIFO), (u32)uRecBufferAddr, uPcmSize/4, &(oPCMDma[1]));//ok
		DMA_StartCh((u32)uPlayBufferAddr, (u32)(PCM1_BASE+rPCMTXFIFO),uPcmSize/4, &(oPCMDma[0]));//ok		
	}	
	else if (g_oPCMState.PCMIpNum==PCM_IP0)
	{
		DMA_StartCh(  (u32)(PCM0_BASE+rPCMRXFIFO), (u32)uRecBufferAddr, uPcmSize/4, &(oPCMDma[1]));//ok
		DMA_StartCh((u32)uPlayBufferAddr, (u32)(PCM0_BASE+rPCMTXFIFO),uPcmSize/4, &(oPCMDma[0]));//ok		
	}	
	else
	{
		DMA_StartCh(  (u32)(PCM2_BASE+rPCMRXFIFO), (u32)uRecBufferAddr, uPcmSize/4, &(oPCMDma[1]));//ok
		DMA_StartCh((u32)uPlayBufferAddr, (u32)(PCM2_BASE+rPCMTXFIFO),uPcmSize/4, &(oPCMDma[0]));//ok				
	}	

	
 
	temp1=PCM_Inp32(g_oPCMState.PCMIpNum, rPCMCLKCTL);
	temp2=PCM_Inp32(g_oPCMState.PCMIpNum, rPCMCTRL);
	PCM_Outp32(g_oPCMState.PCMIpNum, rPCMCLKCTL, (temp1 |PCM_SCLK_EN));
	PCM_Outp32(g_oPCMState.PCMIpNum, rPCMCTRL,    (temp2 |PCM_PCM_ENABLE)); 

   	Disp("Press the 'x' key to exit\n");	
	
	while(!g_PcmPlayDone | !g_PcmRecDone)
	{
		uChar = UART_GetKey();		
		if( (uChar == 'x') | (uChar == 'X')) break;
	} 
	
	//Disp("g_PcmPlayDone/g_PcmRecDone : %d,%d \n ",g_PcmPlayDone,g_PcmRecDone);

	
 	//pcm out dma finish
	DMA_StopCh( &(oPCMDma[0]) );//DMA-play stop	
	DMA_StopCh( &(oPCMDma[1]) );//DMA-rec stop	

	PCM_TXFIFOwaitTillEmpty();
	temp1=PCM_Inp32(g_oPCMState.PCMIpNum, rPCMCLKCTL);
	temp2=PCM_Inp32(g_oPCMState.PCMIpNum, rPCMCTRL);
	PCM_Outp32(g_oPCMState.PCMIpNum, rPCMCLKCTL, (temp1 & ~PCM_SCLK_EN)  );
	PCM_Outp32(g_oPCMState.PCMIpNum, rPCMCTRL,    (temp2 & ~(PCM_PCM_ENABLE|PCM_TXFIFO_EN|PCM_TX_DMA_EN |
														     PCM_RXFIFO_EN|PCM_RX_DMA_EN) )   );


  	Disp("\n->End of full duplex Play/record!");  	
  	
  	return 0;
}



//memory : 16bit stereo continous expected(16bit mono left, first 16bit is available to play)
//ISR fifo access unit : 32bit
void PCM_PCMOutInt2(unsigned int uBufferAddr, unsigned int uPcmSize)
{
	char uChar;
	u8 bret;
	u32 temp1, temp2;
	
	//init variable
	g_PcmPlayDone =0;
	g_uPcmBuffer32 = (unsigned int *) uBufferAddr;
	g_uPcmEndBuffer32 = g_uPcmBuffer32 + uPcmSize/4;
    
	//IRQ Initialization
	PCM_DisableInt();	
	PCM_ISRInit(Isr_PCM_PCMOut2);//32bit
	
	//IRQ Setting
	PCM_ClearInt();
	PCM_SetInt(TXFIFO_ALMOST_EMPTY);

	//setting
	PCM_Outp32(g_oPCMState.PCMIpNum, rPCMCTRL, (TXFIFO_DIPSTICK(0x8) | PCM_TXFIFO_EN ) );//fifo flush
	PCM_EnableInt();
	PCM_TXFIFOwaitTillFULL();//wait till fifo is almost full
	temp1=PCM_Inp32(g_oPCMState.PCMIpNum, rPCMCLKCTL);
	temp2=PCM_Inp32(g_oPCMState.PCMIpNum, rPCMCTRL);
	PCM_Outp32(g_oPCMState.PCMIpNum, rPCMCLKCTL, (temp1 | PCM_SCLK_EN)  );
	PCM_Outp32(g_oPCMState.PCMIpNum, rPCMCTRL,    (temp2 | PCM_PCM_ENABLE)  );


	//playing
	while(g_PcmPlayDone==0)
	{
		uChar = UART_GetKey();		
		if( (uChar == 'x') | (uChar == 'X'))  break;	
	}
	
	//stop   	
	PCM_TXFIFOwaitTillEmpty();
	PCM_DisableInt();	
	temp1=PCM_Inp32(g_oPCMState.PCMIpNum, rPCMCLKCTL);
	temp2=PCM_Inp32(g_oPCMState.PCMIpNum, rPCMCTRL);
	PCM_Outp32(g_oPCMState.PCMIpNum, rPCMCLKCTL, (temp1 & ~PCM_SCLK_EN)  );
	PCM_Outp32(g_oPCMState.PCMIpNum, rPCMCTRL,    (temp2 & ~(PCM_PCM_ENABLE|PCM_TXFIFO_EN) )   );

	PCM_ISRDeInit();
	Disp("\nEnd of Play!\n");
}





//uPcmSize : byte size
//ISR fifo access unit : 32bit
void PCM_PCMInInt(unsigned int uRecBufferAddr, unsigned int uPcmSize)
{
	char uChar;	
	u32 temp1, temp2;

	//init variable
	g_PcmRecDone =0;
	g_uPcmBuffer32 = (unsigned int *) uRecBufferAddr;
	g_uPcmEndBuffer32 = g_uPcmBuffer32 + uPcmSize/4;
    
	//IRQ Initialization
	PCM_DisableInt();	
	PCM_ISRInit(Isr_PCM_PCMIn);//32bit
	

   	Disp("Supply Sound to PCM CODEC via Line In(WM8753)/Mic(WM9714) Connector.\n");
   	Disp("Press any key to record.\n");
	UART_Getc();
   	Disp("Recording...\n");

	//IRQ Setting
	PCM_ClearInt();
	PCM_SetInt(RXFIFO_ALMOST_FULL);//rx fifo not empty, then read as soon as possible.

	//Setting
	PCM_Outp32(g_oPCMState.PCMIpNum, rPCMCTRL, (RXFIFO_DIPSTICK(0x20) | PCM_RXFIFO_EN ) );//fifo flush
	PCM_EnableInt();	
	temp1=PCM_Inp32(g_oPCMState.PCMIpNum, rPCMCLKCTL);
	temp2=PCM_Inp32(g_oPCMState.PCMIpNum, rPCMCTRL);
	PCM_Outp32(g_oPCMState.PCMIpNum, rPCMCLKCTL, (temp1 | PCM_SCLK_EN)  );
	PCM_Outp32(g_oPCMState.PCMIpNum, rPCMCTRL,    (temp2 | PCM_PCM_ENABLE)  );

	//recording
	while(g_PcmRecDone==0)
	{
		uChar = UART_GetKey();		
		if( (uChar == 'x') | (uChar == 'X'))  break;	
	}	
   	
	//Finish
	PCM_DisableInt();	
	temp1=PCM_Inp32(g_oPCMState.PCMIpNum, rPCMCLKCTL);
	temp2=PCM_Inp32(g_oPCMState.PCMIpNum, rPCMCTRL);
	PCM_Outp32(g_oPCMState.PCMIpNum, rPCMCLKCTL, (temp1 & ~PCM_SCLK_EN)  );
	PCM_Outp32(g_oPCMState.PCMIpNum, rPCMCTRL,    (temp2 & ~(PCM_PCM_ENABLE|PCM_RXFIFO_EN) )   );

	PCM_ISRDeInit();
	Disp("\nEnd of Record!\n");
	
	
}



//fifo access unit : 32bit
void __irq Isr_PCM_PCMOut2(void)
{
	unsigned int i, uPcmFifoStat,pcmch,uPcmIrqStat,uPcmIrqCtl; 
	u32 baseaddr;
	pcmch = g_oPCMState.PCMIpNum;

	baseaddr= (pcmch == PCM_IP0)? PCM0_BASE : 
			  (pcmch == PCM_IP1)? PCM1_BASE :
								PCM2_BASE;


	INTC_Disable(pcmch);

	uPcmIrqStat = Inp32(baseaddr+rPCMIRQSTAT) & 0x3fff;
	uPcmIrqCtl  =  Inp32(baseaddr+rPCMIRQCTL) & 0x01fff;;

	//Disp("\n<uPcmIrqCtl:uPcmIrqStatl=%x %x>",uPcmIrqCtl,uPcmIrqStat);


	if (uPcmIrqStat& IRQ_PENDING)
	{
		g_uPcmIrqStateFlag |=IRQ_PENDING;	
		//Disp("\n[TX IRQ_PENDING]");
	}		
	if (uPcmIrqStat&TRANSFER_DONE)
	{
		g_uPcmIrqStateFlag |=TRANSFER_DONE;			
		//Disp("\n[TX TRANSFER_DONE]");
	}		



	 if ((uPcmIrqCtl&TXFIFO_ALMOST_EMPTY) && (uPcmIrqStat&TXFIFO_ALMOST_EMPTY))
//	 if (uPcmIrqStat&TXFIFO_ALMOST_EMPTY)
	 {
		if (IS_TXFIFO_Status(pcmch,FIFO_TXFIFO_ALMOST_EMPTY))
			g_uPcmIrqStateFlag |=TXFIFO_ALMOST_EMPTY;	

	 
		#if 1 //jspark
		 uPcmFifoStat = (Inp32(baseaddr+rPCMFIFOSTAT)>>14) & 0x3f;
		#else
		uPcmFifoStat = FIFO_TXFIFO_COUNT0 ;
		#endif
 	
		//Disp("%d", uPcmFifoStat );
		for(i=0; i<(32-uPcmFifoStat); i++) 	{
			#if 1 //jspark for fast operation (FPGA)
	 		Outp32(baseaddr+rPCMTXFIFO, *(g_uPcmBuffer32++));
			#else
			PCM_Outp32(g_oPCMState.PCMIpNum, rPCMTXFIFO, *(g_uPcmBuffer32++));
			#endif
			if(g_uPcmBuffer32 >= g_uPcmEndBuffer32)
			break;	
		}
		//Disp("\n[TX Almost Empty]");
	}

 	if ((uPcmIrqCtl&TXFIFO_EMPTY) && (uPcmIrqStat&TXFIFO_EMPTY))	 
	{
		//Disp("\n[TX Empty]");
		if (IS_TXFIFO_Status(pcmch,FIFO_TXFIFO_EMPTY))		
			g_uPcmIrqStateFlag |=TXFIFO_EMPTY;		
	}	 
	if ((uPcmIrqCtl&TXFIFO_ERROR_STARVE) && (uPcmIrqStat&TXFIFO_ERROR_STARVE)) 
	{
		//Disp("\n[TX UnderFlow]");		
		g_uPcmIrqStateFlag |=TXFIFO_ERROR_STARVE;		
	}

	if ((uPcmIrqCtl&TXFIFO_ALMOST_FULL) && (uPcmIrqStat&TXFIFO_ALMOST_FULL))	 
	{
		//Disp("\n[TX ALMOST FULL]");		
		if (IS_TXFIFO_Status(pcmch,FIFO_TXFIFO_ALMOST_FULL))		
			g_uPcmIrqStateFlag |=TXFIFO_ALMOST_FULL;		
	}
	  
	if ((uPcmIrqCtl&TXFIFO_FULL) && (uPcmIrqStat&TXFIFO_FULL))	 
	{
		//Disp("\n[TX FULL]");		
		if (IS_TXFIFO_Status(pcmch,FIFO_TXFIFO_FULL))						
			g_uPcmIrqStateFlag |=TXFIFO_FULL;

	}

	if ((uPcmIrqCtl&TXFIFO_ERROR_OVERFLOW) &&  (uPcmIrqStat&TXFIFO_ERROR_OVERFLOW)) 
	{
		//Disp("\n[TX Overflow]");	
		g_uPcmIrqStateFlag |=TXFIFO_ERROR_OVERFLOW;				
	}
	 
 	
	if(pcmch == PCM_IP0)	
		INTC_Enable(NUM_PCM0);
	else if(pcmch == PCM_IP1)	
		INTC_Enable(NUM_PCM1);
	else
		INTC_Enable(NUM_PCM2);
	
	if(g_uPcmBuffer32 >= g_uPcmEndBuffer32) {			
		PCM_DisableInt();
		Disp("\n[g_PcmPlayDone]");			
		g_PcmPlayDone=1;
	}	

	PCM_ClearInt();			
	INTC_ClearVectAddr();

	//UART_Printf("\n[OUT Interrupt DONE !]");

}


	 
void __irq Isr_PCM_PCMIn(void)
{
	unsigned int i, uPcmFifoStat,uPcmIrqStat,uPcmIrqCtl; 

	u32 baseaddr,pcmch;
	pcmch = g_oPCMState.PCMIpNum;

	baseaddr= (pcmch == PCM_IP0)? PCM0_BASE : 
			  (pcmch == PCM_IP1)? PCM1_BASE :
								PCM2_BASE;

	INTC_Disable(pcmch);
	 uPcmIrqStat = Inp32(baseaddr+rPCMIRQSTAT)  & 0x3fff;
	uPcmIrqCtl  =  Inp32(baseaddr+rPCMIRQCTL) & 0x01fff;

//	Disp("\n<uPcmIrqCtl:uPcmIrqStatl=%x %x>",uPcmIrqCtl,uPcmIrqStat);
	

	if (uPcmIrqStat& IRQ_PENDING)
	{
		g_uPcmIrqStateFlag |=IRQ_PENDING;	
		//Disp("\n[TX IRQ_PENDING]");
	}		
	if (uPcmIrqStat&TRANSFER_DONE)
	{
		g_uPcmIrqStateFlag |=TRANSFER_DONE;			
		//Disp("\n[TX TRANSFER_DONE]");
	}		

	 if ((uPcmIrqCtl&RXFIFO_EMPTY) && (uPcmIrqStat&RXFIFO_EMPTY))	 
	 {
	 
		//Disp("\n[RX Empty]");
		if (IS_TXFIFO_Status(pcmch,FIFO_RXFIFO_EMPTY))				
			g_uPcmIrqStateFlag |=RXFIFO_EMPTY;		
	 }
	 	
	 if ((uPcmIrqCtl&RXFIFO_ALMOST_EMPTY) && (uPcmIrqStat&RXFIFO_ALMOST_EMPTY)) 
	 {

		//Disp("\n[RX Almost Empty]");	 
		if (IS_TXFIFO_Status(pcmch,FIFO_RXFIFO_ALMOST_EMPTY))						
			g_uPcmIrqStateFlag |=RXFIFO_ALMOST_EMPTY;				
	 }
	 	
	 if  ((uPcmIrqCtl&RXFIFO_FULL) && (uPcmIrqStat&RXFIFO_FULL))	 
	 {
		//Disp("\n[RX Full]");	 	
		if (IS_TXFIFO_Status(pcmch,FIFO_RXFIFO_FULL))								
			g_uPcmIrqStateFlag |=RXFIFO_FULL;				
	 }
	 	
		 
	  if ((uPcmIrqCtl&RXFIFO_ALMOST_FULL) && (uPcmIrqStat&RXFIFO_ALMOST_FULL))	 
	  {
		if (IS_TXFIFO_Status(pcmch,FIFO_RXFIFO_ALMOST_FULL))				
			g_uPcmIrqStateFlag |=RXFIFO_ALMOST_FULL;							
	  
	  		uPcmFifoStat = (Inp32(baseaddr+rPCMFIFOSTAT)>>4) & 0x3f;	
		
			//Disp("%d", uPcmFifoStat );
			for(i=0; i< uPcmFifoStat; i++)
			{
				#if 1 //jspark
		 		*(g_uPcmBuffer32++) = Inp32(baseaddr+rPCMRXFIFO);
				#else
				*(g_uPcmBuffer32++) = PCM_Inp32(g_oPCMState.PCMIpNum, rPCMRXFIFO);
				#endif

				if(g_uPcmBuffer32 >=g_uPcmEndBuffer32)
				break;	
			}


		//Disp("\n[RX Almost Full]");
		
	  }
	 if ((uPcmIrqCtl&RXFIFO_ERROR_STARVE) && (uPcmIrqStat&RXFIFO_ERROR_STARVE))	 	 	
	 {
 		//Disp("\n[RX UnderRun]");	 
		g_uPcmIrqStateFlag |=RXFIFO_ERROR_STARVE;										
	 }
	 if ((uPcmIrqCtl&RXFIFO_ERROR_OVERFLOW) && (uPcmIrqStat&RXFIFO_ERROR_OVERFLOW))	 	 		 
	 {
 		//Disp("\n[RX Overflow]");	 	 
		g_uPcmIrqStateFlag |=RXFIFO_ERROR_OVERFLOW;										
	 }
	

	if(g_oPCMState.PCMIpNum == PCM_IP0)
		INTC_Enable(NUM_PCM0);
	else if(g_oPCMState.PCMIpNum == PCM_IP1)
		INTC_Enable(NUM_PCM1);
	else
		INTC_Enable(NUM_PCM2);
	
	if(g_uPcmBuffer32 >=g_uPcmEndBuffer32){
		PCM_DisableInt();
		g_PcmRecDone=1;
		Disp("\n[g_PcmRecDone]");		
	}

	PCM_ClearInt();			
	INTC_ClearVectAddr();
 


	
	//UART_Printf("\n[IN Interrupt DONE !]");
}

void PCM_ISRInit(void (*handler)(void) __irq)
{
	if(g_oPCMState.PCMIpNum == PCM_IP0)	
	{
		INTC_ClearVectAddr();
		INTC_SetVectAddr(NUM_PCM0 ,handler);
		INTC_Enable(NUM_PCM0 );		
	}
	else if(g_oPCMState.PCMIpNum == PCM_IP1)	
	{
		INTC_ClearVectAddr();
		INTC_SetVectAddr(NUM_PCM1 ,handler);
		INTC_Enable(NUM_PCM1 );
	}	
	else
	{
		INTC_ClearVectAddr();
		INTC_SetVectAddr(NUM_PCM2 ,handler);
		INTC_Enable(NUM_PCM2 );
	}	
}


void PCM_ISRDeInit(void)
{
	//rINTMSK2|=(g_oPCMState.PCMIpNum == PCM_IP0)? (BIT_PCM0) : (BIT_PCM1);
	if(g_oPCMState.PCMIpNum == PCM_IP0)	
		INTC_Disable(NUM_PCM0);
	else if(g_oPCMState.PCMIpNum == PCM_IP0)	
		INTC_Disable(NUM_PCM1);
	else
		INTC_Disable(NUM_PCM2);		
}














/*---------------------------------- APIs of PCM interface ---------------------------------*/



void PCM_ClearInt(void)
{
	PCM_Outp32(g_oPCMState.PCMIpNum, rPCMCLRINT, CLRINT );
}

void PCM_EnableInt(void)
{
	u32 temp1=PCM_Inp32(g_oPCMState.PCMIpNum, rPCMIRQCTL);

	temp1 |= EN_IRQ_TO_ARM;
	PCM_Outp32(g_oPCMState.PCMIpNum, rPCMIRQCTL, temp1 );
}

void PCM_DisableInt(void)
{		
	u32 temp1;
	temp1=PCM_Inp32(g_oPCMState.PCMIpNum, rPCMIRQCTL);

	temp1 &= ~EN_IRQ_TO_ARM;
	PCM_Outp32(g_oPCMState.PCMIpNum, rPCMIRQCTL, temp1 );
}


void PCM_SetInt(unsigned int ePcmInt)
{	
#if 1 //jspark
	u32 temp1=PCM_Inp32(g_oPCMState.PCMIpNum, rPCMIRQCTL);
	temp1 = (temp1 & ~0x1fff) | ePcmInt;
#else
	u32 temp1=PCM_Inp32(g_oPCMState.PCMIpNum, rPCMIRQCTL);
	temp1 = (temp1 | EN_IRQ_TO_ARM) | ePcmInt;
#endif	
	PCM_Outp32(g_oPCMState.PCMIpNum, rPCMIRQCTL, temp1 );
}


void PCM_TXFIFOwaitTillFULL()
{
	if(g_oPCMState.PCMIpNum == PCM_IP0)
	{
		while( FIFO_TXFIFO_COUNT0<16) ;
	}
	else if(g_oPCMState.PCMIpNum == PCM_IP1)
	{
		while( FIFO_TXFIFO_COUNT1<16) ;			
	}	
	else
	{
		while( FIFO_TXFIFO_COUNT2<16) ;			
	}	
		
}

void PCM_TXFIFOwaitTillEmpty()
{
	int cnt=0;
	if(g_oPCMState.PCMIpNum == PCM_IP0)
	{
		while( FIFO_TXFIFO_COUNT0!=0) 
		{
			if( cnt++>0x1000) break;//for secure
		}
	}
	else if(g_oPCMState.PCMIpNum == PCM_IP1)
	{
		while( FIFO_TXFIFO_COUNT1!=0)
		{
			if( cnt++>0x1000) break;//for secure
		}
	}
	else
	{
		while( FIFO_TXFIFO_COUNT2!=0)
		{
			if( cnt++>0x1000) break;//for secure
		}
	}

}

u8	PCM_GetTXFIFOCount(unsigned char PCMIpNum)
{
	if(PCMIpNum == PCM_IP0)
		return FIFO_TXFIFO_COUNT0;
	else if(PCMIpNum == PCM_IP1)
		return FIFO_TXFIFO_COUNT1;
	else
		return FIFO_TXFIFO_COUNT2;		
}
u8	PCM_GetRXFIFOCount(unsigned char PCMIpNum)
{
	if(PCMIpNum == PCM_IP0)
		return FIFO_RXFIFO_COUNT0;
	else if(PCMIpNum == PCM_IP1)
		return FIFO_RXFIFO_COUNT1;
	else
		return FIFO_RXFIFO_COUNT2;		
}

u8 IS_TXFIFO_Status(unsigned char PCMIpNum,unsigned int CheckStatus)
{
	u32 temp = PCM_Inp32(PCMIpNum, rPCMFIFOSTAT); 
	//Disp("\nIS_TXFIFO_Status = %x, %x",temp,CheckStatus);
	if (temp & CheckStatus)
		return 1;	
	else
		return 0;		
}




//////////
// Function Name : PCMCLKCTL_SetDivideLogic
// Function Description : 
//   This function implements Enabe Divider Logic, Put SCLK_DIV and SYNC_DIV value and select source of PCMSCLK
//   before operating PCM interaface
// Input : 	eIPnum		- PCM I/F controller number
// 			uSclkDiv	- PCMSCLK Divider Value
// 			uSyncDiv	- PCMSYNC Divider Value
// Output : NONE
// Version : v0.1
void PCMCLKCTL_SetDivideLogic(unsigned char eIPnum, u8 uPCMClkSrc, u32 uSclkDiv, u32  uSyncDiv)
{
	u32 urPCMCLKCTL = 0;

	if (uPCMClkSrc== PCM_PCLK) 
		urPCMCLKCTL =  (0<<19)|(1 << 18) | (uSclkDiv << 9) | (uSyncDiv << 0);//divider logic disabled
	else  	
		urPCMCLKCTL =  (0<<19)|(0 << 18) | (uSclkDiv << 9) | (uSyncDiv << 0);//divider logic disabled

	PCM_Outp32(eIPnum, rPCMCLKCTL, urPCMCLKCTL);
}


void PCM_PCMSetting()
{
	u8 bret;
	unsigned int uTxMsbPos, uRxMsbPos;
	

 	bret=PCM_CLKGenerate(g_oPCMState.PCMIpNum);//set clk ctl.
   	if(!bret)
   	{
   		Disp("clock can not be made, exit");
   		return;
   	}
	if(g_oPCMState.PCMMSBPosition == AFTER_PCMSYNC_HIGH)//min 17fs is needed for recording
	{
		uTxMsbPos = TX_MSB_POS1;
		uRxMsbPos = RX_MSB_POS1;	
	}
	else if(g_oPCMState.PCMMSBPosition == DURING_PCMSYNC_HIGH)//min 16fs is needed
	{
		uTxMsbPos = TX_MSB_POS0;
		uRxMsbPos = RX_MSB_POS0	;
	}

	//PCM Clock Setting & Transfer data setting
	//PCM_Outp32(g_oPCMState.PCMIpNum, rPCMCLKCTL, ( uSclkSel | (uSclkDiv<<9) | (uSyncDiv<<0) ) );
	PCM_Outp32(g_oPCMState.PCMIpNum, rPCMCTRL, ( uTxMsbPos |uRxMsbPos) );//pcm_txfifo_disable
}





/*---------------------------------- APIs of Clock ---------------------------------*/




//input : pcm_audio clk
//output : divider for sclk, and sync clock.
//return : false - with current configuration impossible to make.
u8 PCM_CalDividers(u32 uAudioClk, unsigned int* uSclkDiv, unsigned int* uSyncDiv)
{
	double dTmpVal, dVclkSrc;
	unsigned int uTmp;

	dVclkSrc =(double)uAudioClk;

	//sclk divider
	dTmpVal= dVclkSrc/ (double)(g_oPCMState.PCMSync*g_oPCMState.m_BFS);
	dTmpVal = (dTmpVal+0.5)*10;
	uTmp = (int)(dTmpVal/10.0);
	uTmp = uTmp/2 -1;
	if( uTmp>511)return 0;

	*uSclkDiv = uTmp;

	// Calculate SYNC_DIV for PCMSYNC
	uTmp = g_oPCMState.m_BFS;
	if( uTmp>511)return 0;
	*uSyncDiv = uTmp-1;

	return 1;

 }



u32 PCM_GetTargetRCLK(void)
{	
	u32 dTempRCLK;
	dTempRCLK = g_oPCMState.PCMSync * g_oPCMState.m_RFS;
	return dTempRCLK;
}

#if 0 //jspark (i2s  PCM main clock ͼ ÿ ǹ̰ ʳ? 
// Function Description : in case of EPLL, set EPLL, then set divider if needed
//					 in other source(MPLL, ) then divide to fullfil RCLK
//					 in case of FIN, then bypass.
// Input : 	eIPnum,
//			eClkSrc(audio clock source)
//			 uRCLK(target frequency)
// Output : Output Frequency of audio clock[Hz]
u32 PCM_SetSysAudioClk(unsigned char eIPnum, AUDIO_CLKSRC eClkSrc, u32 uRootClk)
{
	u32 uAudioClkSpeed;
	u32 temp;
//set speed(EPLL), get speed (other source)
	if(eClkSrc == eAUDIO_MOUT_EPLL)
		uAudioClkSpeed = Sys_SetAudioEPLL(uRootClk);
	else if(eClkSrc== eAUDIO_DOUT_MPLL) {
		//mpll divider
		temp = Inp32(0xE0100304/*rCLK_DIV1*/);
		temp =( temp>>4) & 0x3;
		uAudioClkSpeed  = g_uMPLL/(temp+1);//divider
	}else if(eClkSrc== eAUDIO_FIN)
		uAudioClkSpeed =  AUDIO_FIN; 	//should be changed according to your system clock condition
	else if(eClkSrc == eAUDIO_I2SCDCLK)
		uAudioClkSpeed  = I2S_EXTERNALCLK;
	else if(eClkSrc == eAUDIO_PCMCDCLK)
		uAudioClkSpeed  = g_oPCMState.EXTCDCLKFreq;
	else if(eClkSrc == eAUDIO_MOUT_HPLL)
		uAudioClkSpeed  = g_HCLKD0;		//should be changed according to your system clock condition
//set audio divider
	//implement here

//return audio clock for eIPnum.
	return uAudioClkSpeed;
}
#endif

#include "assclkcon.h"

u32 EPLL_SetAudioClock(u32 SampleRate , u32 FsVal,u32 AudioSel)
{

	volatile u32 uRead;
	u32 uTrg_Fout, uVSEL=0, uP_Value=0, uM_Value=0, uS_Value=0;
	u32 uCal, uInp_Clk, uDiv;
	u32 uSampleRate;
	u32	uAddr;

	if ((SampleRate==44100) || (SampleRate==22050) || (SampleRate==11025))
		uSampleRate = 44100;
	else if ((SampleRate==48000) || (SampleRate==24000) || (SampleRate==12000))
		uSampleRate = 48000;
	else if ((SampleRate==32000) || (SampleRate==16000) || (SampleRate==8000))	
		uSampleRate = 32000;		
	else
		uSampleRate = 44100;
	
	uTrg_Fout = uSampleRate*FsVal;   
	Disp("\n -EPLL_SetAudioClock() : SampleRate * FsVal = %d x %d = %d",uSampleRate,FsVal,uTrg_Fout);

	/// 2. Target FOUT(MHz), EPLL Table
	switch(uTrg_Fout)
	{
		case  48000000:	
			uVSEL=0;	uP_Value = 6;	uM_Value = 96;	uS_Value = 3; 
			if(uTrg_Fout== 48000000) uDiv=0; 
			break;	
		case  96000000:	
			uVSEL=0;	uP_Value = 6;	uM_Value = 96;	uS_Value = 2; 
			if(uTrg_Fout== 96000000) uDiv=0; 
			break;	
		case 144000000:	
			uVSEL=1;	uP_Value = 6;	uM_Value = 144;	uS_Value = 2; 
			if(uTrg_Fout== 144000000) uDiv=0; 
			break;	
		case 192000000:	
			uVSEL=0;	uP_Value = 6;	uM_Value = 96;	uS_Value = 1; 
			if(uTrg_Fout== 192000000) uDiv=0; 
			break;		
		case 288000000:	
			uVSEL=1;	uP_Value = 6;	uM_Value = 144;	uS_Value = 1; 
			if(uTrg_Fout== 288000000) uDiv=0; 
			break;		
		case 84000000:	
			uVSEL=0;	uP_Value = 6;	uM_Value = 84;	uS_Value = 2; 
			if(uTrg_Fout== 84000000) uDiv=0; 
			break;	
		case 50000000:	
			uVSEL=0;	uP_Value = 6;	uM_Value = 100;	uS_Value = 3; 
			if(uTrg_Fout== 50000000) uDiv=0; 
			break;	
		case 80000000:	
			uVSEL=1;	uP_Value = 6;	uM_Value = 160;	uS_Value = 3; 
			if(uTrg_Fout== 80000000) uDiv=0; 
			break;
		case 16384000:	
		case 8192000:	
		case 32768000:	
			uVSEL=1;	uP_Value = 6;	uM_Value = 131;	uS_Value = 4; 
			if (uTrg_Fout== 32768000) uDiv=0; 
			else if (uTrg_Fout== 8192000) uDiv=3; 
			else if (uTrg_Fout== 16384000) uDiv=1; 
			break;
		case 12288000:	
		case 24576000:	
		case 49152000:
			uVSEL=0;	uP_Value = 8;	uM_Value = 131;	uS_Value = 3; 
			if(uTrg_Fout== 49152000) uDiv=0; 
			else if(uTrg_Fout == 24576000) uDiv=1; 
			else if(uTrg_Fout == 12288000) uDiv=3; 			
			break;	
		case 16934400:		
		case 33868800:	
		case 67737600:
			uVSEL=1;	uP_Value = 12;	uM_Value = 271;	uS_Value = 3; 
			if (uTrg_Fout== 67738000) uDiv=0; 
			else if (uTrg_Fout== 33868800) uDiv=1; 
			else if (uTrg_Fout== 16934400) uDiv=3; 
			break;
		case 36864000:
		case 18432000:
		case 73728000:
			uVSEL=1;	uP_Value = 12;	uM_Value = 295;	uS_Value = 3; 
			if (uTrg_Fout== 73728000) uDiv=0;
			else if (uTrg_Fout== 18432000) uDiv=3; 
			else if (uTrg_Fout== 36864000) uDiv=1; 			
			break;	
		case 11289600:	
		case 22579200:	
		case 45158400:
			uVSEL=0;	uP_Value = 18;	uM_Value = 271;	uS_Value = 3; 
			if (uTrg_Fout== 45158400) uDiv=0; 
			else if (uTrg_Fout== 22579200) uDiv=1;
			else if (uTrg_Fout== 11289600) uDiv=3;
			break;	
		default:
			Disp("\n -Not selection");
			Assert(0); 
			break;
	}

	Disp("\n -uVSEL/uP_Value/uM_Value/uS_Value/uDiv = %d %d %d %d %d",uVSEL, uP_Value,uM_Value,uS_Value,uDiv);


	/// 3.3 EPLL Lock Time, 300us
	uAddr = /*rEPLL_LOCK*/SYSCON_BASE+0x0010;	
	uRead = Inp32(uAddr);
	uRead = (uRead & ~(0xffff<<0)) | (0xe10<<0);
	Outp32(uAddr, uRead);	

	/// 3.4 EPLL control setting
	uAddr = /*rEPLL_CON*/SYSCON_BASE+0x0110;		
	uRead = Inp32(uAddr);
	uRead = (uRead & ~((1<<31)|(1<<27)|(0x3ff<<16)|(0x3f<<8)|(7<<0))) | ((1<<31)|(uVSEL<<27)|(uM_Value<<16)|(uP_Value<<8)|(uS_Value<<0));
	Outp32(uAddr, uRead);	
	while(!(Inp32(uAddr)>>29)&0x1);		// lock time is done

	uAddr = /*rCLK_DIV6*/SYSCON_BASE+0x0318;
	Outp32(uAddr, (Inp32(uAddr)&~(0x0f<<(AudioSel*4)) | uDiv<<(AudioSel*4)));	
	
	return uTrg_Fout;
}

#if 1 //jspark EPLL test
void PCM_UsingI2S0_EPLL(void)
{
	//I2S Block #0 Master clock output

//AUdioSubSystem Clock setting
	SYSC_SetAudioBlockPowerOn();
	AudioSS_CLKCON_SetGate(HCLK_I2SV5_1_PASS|	I2SCLK_PASS);
//	AudioSS_CLKCON_SetSource(MUX_FOUT_EPLL, Main_CLK, MUXI2SA_SCLK_AUDIO0);	
	AudioSS_CLKCON_SetTypicalConf(I2S_Master, MOUTI2SA_MainCLK_FOUTEPLL);
	AudioSS_CLKCON_SetDivider(4-1,1-1);//(i2sclk, audio bus)-smdk.
	I2SV5_1_Init(I2S_Master, I2STX, I2SFormat, 0, 0, 16,2/* RFS_384fs*/, 0/*BFS_32fs*/, 0/*CDCLK_Out*/, 0);//SD1-0,SD2-0, PreSaler_Value-0

//	Outp32(0xEEE10000,(2)<<2);  //AudioSubSystem CLKCON, SCLK_AUDIO0 Selection(2), 
//	Outp32(0xEEE10004,0);  		//No divided

	GPIO_SetFunctionEach(eGPIO_I,eGPIO_1,eGFunc_0);//I2S0_CDCLK (pcm2 extclk)
	GPIO_SetDSEach(eGPIO_I,eGPIO_1,3);  // CDCLK strength

//I2S ch#0 setting	
//	I2S_Outp32(0,/*rI2SCON*/0,1<<31);  //unreset.
//	I2S_Outp32(0,/*rI2SMOD*/4,1<<10); //RCLK clock source is SCLK_AUDIO0
//	I2S_Outp32(0,/*rI2SCON*/0,1<<0);  //I2S active

	Outp32(I2S0_BASE+0, 1<<31);
	Outp32(I2S0_BASE+4, 1<<10);
	Outp32(I2S0_BASE+0, 1<<0);

}
#endif


u8 PCM_CLKGenerate(unsigned char eIPnum)
{
	u32 uPRSVal, uTemp, uAudioClkFreq, uRootClkFreq;
	u32 Sclkdivider, Syncdivider;
	u8 bret = 1;
	double cdclk, sclk, syncclk;
	u32 uAddr;
	
//	uRootClkFreq=PCM_GetTargetRCLK();

	Disp("\n<PCM_CLKGenerate>");
	if(g_oPCMState.PCMClkSrc== PCM_PCLK)			//PCLK is master clock for PCM
	{
	Disp("\n -PCLK mode");
		uAudioClkFreq = g_uPclkPsys;
	}	
	else if(g_oPCMState.PCMClkSrc== PCM_EXTCLK)		//EXT-CLK is master clock for PCM
	{
	Disp("\n -EXT-CLK mode");	
		uAudioClkFreq = g_oPCMState.EXTCDCLKFreq;

		if (g_oPCMState.PCMIpNum==PCM_IP2)
		{
			Outp32(rCLK_SRC6, (Inp32(rCLK_SRC6) & 0xfffff0ff) | (1<<8)); //AUDIO2_SEL <= PCMCDCLK0						
		}	
		else if (g_oPCMState.PCMIpNum==PCM_IP1)
		{
			Outp32(rCLK_SRC6, (Inp32(rCLK_SRC6) & 0xffffff0f) | (1<<4)); //AUDIO1_SEL <= PCMCDCLK1
		}	
		else if (g_oPCMState.PCMIpNum==PCM_IP0)
		{
			Outp32(rCLK_SRC6, (Inp32(rCLK_SRC6) & 0xfffffff0) | (1<<0)); //AUDIO0_SEL <= PCMCDCLK2
		}	
		
		uAddr = /*rCLK_DIV6*/SYSCON_BASE+0x0318;
		Outp32(uAddr, Inp32(uAddr)&~(0x0fff));  //CLK_DIV6 , AUDIO div all clear.
			
	}	
	else	 if (g_oPCMState.PCMClkSrc== PCM_EPLL)//this is for EPLL
	{
	Disp("\n -EPLL mode");	
		uAudioClkFreq = EPLL_SetAudioClock(g_oPCMState.PCMSync/*44100*/, g_oPCMState.m_RFS,g_oPCMState.PCMIpNum);

		if (g_oPCMState.PCMIpNum==PCM_IP2)
		{
			Outp32(rCLK_SRC6, (Inp32(rCLK_SRC6) & 0xfffff0ff) | (7<<8)); //AUDIO2_SEL <= SCLK_EPLL
		}	
		else if (g_oPCMState.PCMIpNum==PCM_IP1)
		{
			Outp32(rCLK_SRC6, (Inp32(rCLK_SRC6) & 0xffffff0f) | (7<<4)); //AUDIO1_SEL <= SCLK_EPLL
		}	
		else if (g_oPCMState.PCMIpNum==PCM_IP0)
		{
			Outp32(rCLK_SRC6, (Inp32(rCLK_SRC6) & 0xfffffff0) | (7<<0)); //AUDIO0_SEL <= SCLK_EPLL
		}	

#if 1 //jspark EPLL test
			PCM_UsingI2S0_EPLL(); //I2S#0 CDCLK -> PCM2_EXTCLK			
#endif			
	}

		
	//sclk div, sync div set.
	bret =PCM_CalDividers(uAudioClkFreq, &Sclkdivider, &Syncdivider);
	Disp("\n -uAudioClkFreq	: %d ",uAudioClkFreq);	
	Disp("\n -Sclkdivider	: %d ",Sclkdivider);	
	Disp("\n -Syncdivider	: %d ",Syncdivider);		
	
	PCMCLKCTL_SetDivideLogic(eIPnum, g_oPCMState.PCMClkSrc, Sclkdivider, Syncdivider);

	cdclk = (double)uAudioClkFreq;
	sclk 	= cdclk/(2*(Sclkdivider+1));
	syncclk = sclk /(Syncdivider+1);
		

	Disp("\n -PCMCODEC_CLK	: %f KHZ	",cdclk/1000);
	Disp("\n -PCM_SCLK	: %f KHz",sclk/1000);
	Disp("\n -PCM_FSYNC	: %f KHz\n", syncclk/1000);

	return bret;
}



void PCM_TXInterruptTest(void)	
{
	u8 uChar,uCurFIFOLevel;
	u32 i,temp1, temp2,uPcmFifoStat;
	u32 baseaddr,pcmch;
	pcmch = g_oPCMState.PCMIpNum;

	baseaddr= (pcmch == PCM_IP0)? PCM0_BASE : 
			  (pcmch == PCM_IP1)? PCM1_BASE :
								PCM2_BASE;

	Disp("\n\n###############################");
	Disp("\n<PCM Channel #%d FIFO mode TX Interrupt Status Test> ",pcmch);
	Disp("\n-TX_EMPTY");
	Disp("\n-TX_ERROR_STARVE");
	Disp("\n-TX_ALMOST_EMPTY");
	Disp("\n-TX_ALMOST_FULL");
	Disp("\n-TX_FULL");	
	Disp("\n-TX_OVERFLOW");
	Disp("\n###############################\n");	

	//init variable for testing
	g_uPcmBuffer32 = (unsigned int *) PCM_PLAY_BUF;
	g_uPcmEndBuffer32 = g_uPcmBuffer32 ;
	
	g_oPCMState.Playmode = PCM_INTERRUPT;
	PCM_PCMSetting();
	
	//IRQ Initialization
	PCM_DisableInt();	
	PCM_ISRInit(Isr_PCM_PCMOut2);//32bit
	
	//setting
	PCM_Outp32(g_oPCMState.PCMIpNum, rPCMCTRL, (TXFIFO_DIPSTICK(0x8) | PCM_TXFIFO_EN ) );//fifo flush
	
	temp1=PCM_Inp32(g_oPCMState.PCMIpNum, rPCMCLKCTL);
	temp2=PCM_Inp32(g_oPCMState.PCMIpNum, rPCMCTRL);
			
	//PCM Pause
	PCM_Outp32(g_oPCMState.PCMIpNum, rPCMCLKCTL, (temp1 & ~PCM_SCLK_EN)  );
	PCM_Outp32(g_oPCMState.PCMIpNum, rPCMCTRL,    (temp2 & ~PCM_PCM_ENABLE)  );

	PCM_ClearInt();

//wait till fifo empty
	g_uPcmIrqStateFlag = 0;
	uCurFIFOLevel = PCM_GetTXFIFOCount(g_oPCMState.PCMIpNum);
	//ALL TX Buffer read
	for (i=0;i<uCurFIFOLevel;i++)
		PCM_Inp32(g_oPCMState.PCMIpNum, rPCMTXFIFO);
	PCM_SetInt(TXFIFO_EMPTY);
	PCM_EnableInt();
	while(!(g_uPcmIrqStateFlag&TXFIFO_EMPTY));
	PCM_DisableInt();	
	Disp("\nTX FIFO Empty Check OK..");	

//wait till fifo underflow(starve)
	PCM_Inp32(g_oPCMState.PCMIpNum, rPCMTXFIFO);
	PCM_SetInt(TXFIFO_ERROR_STARVE);
	PCM_EnableInt();
	while(!(g_uPcmIrqStateFlag&TXFIFO_ERROR_STARVE));
	PCM_DisableInt();	
	Disp("\nTX FIFO underflow Check OK..");	


//wait till fifo almost empty
	for (i=0;i<8;i++)
		PCM_Outp32(g_oPCMState.PCMIpNum, rPCMTXFIFO, 0xffff);

	PCM_SetInt(TXFIFO_ALMOST_EMPTY);
	PCM_EnableInt();

	PCM_Inp32(g_oPCMState.PCMIpNum, rPCMTXFIFO);	
	while(!(g_uPcmIrqStateFlag&TXFIFO_ALMOST_EMPTY)); 
	PCM_DisableInt();	
	Disp("\nTX FIFO ALMOST Empty Check OK..");	
	//FIFO ALL Clear
	for (i=0;i<PCM_GetTXFIFOCount(g_oPCMState.PCMIpNum);i++)
		PCM_Inp32(g_oPCMState.PCMIpNum, rPCMTXFIFO);	
	
//wait till fifo is almost full
	for (i=0;i<32-(8-1);i++)
		PCM_Outp32(g_oPCMState.PCMIpNum, rPCMTXFIFO, 0xffff);	
	PCM_SetInt(TXFIFO_ALMOST_FULL);
	PCM_EnableInt();
	while(!(g_uPcmIrqStateFlag&TXFIFO_ALMOST_FULL));
	PCM_DisableInt();		
	Disp("\nTX FIFO ALMOST FULL Check OK");
	
//wait till fifo is  full	
	for (i=0;i<32;i++)
		PCM_Outp32(g_oPCMState.PCMIpNum, rPCMTXFIFO, 0xffff);	
	PCM_SetInt(TXFIFO_FULL);
	PCM_EnableInt();
	while(!(g_uPcmIrqStateFlag&TXFIFO_FULL));
	PCM_DisableInt();		
	Disp("\nTX FIFO FULL Check OK");


//wait till fifo is  overflow
	for (i=0;i<2;i++)
	PCM_Outp32(g_oPCMState.PCMIpNum, rPCMTXFIFO, 0xffff);	
	PCM_SetInt(TXFIFO_ERROR_OVERFLOW);
	PCM_EnableInt();
	while(!(g_uPcmIrqStateFlag&TXFIFO_ERROR_OVERFLOW));
	PCM_DisableInt();		
	Disp("\nTX FIFO OVERFLOW Check OK\n");


//PCM go to check TransferDone flag
	temp1=PCM_Inp32(g_oPCMState.PCMIpNum, rPCMCLKCTL);
	temp2=PCM_Inp32(g_oPCMState.PCMIpNum, rPCMCTRL);	
	PCM_SetInt(TRANSFER_DONE);
	PCM_EnableInt();	
	PCM_Outp32(g_oPCMState.PCMIpNum, rPCMCLKCTL, (temp1 | PCM_SCLK_EN)  );
	PCM_Outp32(g_oPCMState.PCMIpNum, rPCMCTRL,    (temp2 | PCM_PCM_ENABLE)  );
	PCM_Outp32(g_oPCMState.PCMIpNum, rPCMTXFIFO, 0xffff);		
	
	while(!(g_uPcmIrqStateFlag&TRANSFER_DONE)); 
	PCM_DisableInt();


	temp1=PCM_Inp32(g_oPCMState.PCMIpNum, rPCMCLKCTL);
	temp2=PCM_Inp32(g_oPCMState.PCMIpNum, rPCMCTRL);
	PCM_Outp32(g_oPCMState.PCMIpNum, rPCMCLKCTL, (temp1 & ~PCM_SCLK_EN)  );
	PCM_Outp32(g_oPCMState.PCMIpNum, rPCMCTRL,    (temp2 & ~(PCM_PCM_ENABLE|PCM_TXFIFO_EN) )   );
	PCM_ISRDeInit();


      if  (g_uPcmIrqStateFlag == (TXFIFO_EMPTY | TXFIFO_ALMOST_EMPTY | TXFIFO_FULL | 
	  						   TXFIFO_ALMOST_FULL | TXFIFO_ERROR_STARVE | TXFIFO_ERROR_OVERFLOW |
	  						   IRQ_PENDING | TRANSFER_DONE ))	  						   
		Disp("\nALL TX Interrupt Status Register GOOD!!...\n");
	else
		Disp("\nALL TX Interrupt Status Register FAIL!!...\n");

}

void PCM_RXInterruptTest(void)
{
	u8 uChar,uCurFIFOLevel;
	u32 i,temp1, temp2,uPcmFifoStat;
	u32 baseaddr,pcmch;
	pcmch = g_oPCMState.PCMIpNum;

	baseaddr= (pcmch == PCM_IP0)? PCM0_BASE : 
			  (pcmch == PCM_IP1)? PCM1_BASE :
								PCM2_BASE;

	Disp("\n\n###############################");
	Disp("\n<PCM Channel #%d FIFO mode RX Interrupt Status Test> ",pcmch);
	Disp("\n-RX_EMPTY");
	Disp("\n-RX_ERROR_STARVE");
	Disp("\n-RX_ALMOST_EMPTY");
	Disp("\n-RX_ALMOST_FULL");
	Disp("\n-RX_FULL");	
	Disp("\n-RX_OVERFLOW");
	Disp("\n###############################\n");	

	//init variable for testing
	g_uPcmBuffer32 = (unsigned int *) PCM_REC_BUF;
	g_uPcmEndBuffer32 = g_uPcmBuffer32 ;

	
	g_oPCMState.Playmode = PCM_INTERRUPT;
	PCM_PCMSetting();
	
	//IRQ Initialization
	PCM_DisableInt();	
	PCM_ISRInit(Isr_PCM_PCMIn);//32bit
	
	//setting
	PCM_Outp32(g_oPCMState.PCMIpNum, rPCMCTRL, (RXFIFO_DIPSTICK(0x8) | PCM_RXFIFO_EN ) );//fifo flush
	
	temp1=PCM_Inp32(g_oPCMState.PCMIpNum, rPCMCLKCTL);
	temp2=PCM_Inp32(g_oPCMState.PCMIpNum, rPCMCTRL);
			
	//PCM Pause
	PCM_Outp32(g_oPCMState.PCMIpNum, rPCMCLKCTL, (temp1 & ~PCM_SCLK_EN)  );
	PCM_Outp32(g_oPCMState.PCMIpNum, rPCMCTRL,    (temp2 & ~PCM_PCM_ENABLE)  );

	PCM_ClearInt();

//wait till fifo Full
	g_uPcmIrqStateFlag = 0;
	uCurFIFOLevel = PCM_GetRXFIFOCount(g_oPCMState.PCMIpNum);
//	Disp("\nCurrent RX FIFO Level : %d",uCurFIFOLevel);

	for(i=0;i<32-uCurFIFOLevel;i++)
		PCM_Outp32(g_oPCMState.PCMIpNum, rPCMRXFIFO,0x0);	
	
	PCM_SetInt(RXFIFO_FULL);
	PCM_EnableInt();
	
	while(!(g_uPcmIrqStateFlag&RXFIFO_FULL));
	PCM_DisableInt();	
	Disp("\nRX FIFO FULL Check OK..");	

//wait till fifo overflow
	PCM_Outp32(g_oPCMState.PCMIpNum, rPCMRXFIFO,0x0);	
	PCM_SetInt(RXFIFO_ERROR_OVERFLOW);
	PCM_EnableInt();
	while(!(g_uPcmIrqStateFlag&RXFIFO_ERROR_OVERFLOW));
	PCM_DisableInt();	
	Disp("\nRX FIFO Overflow Check OK..");	


//wait till fifo Almost Full
	PCM_SetInt(RXFIFO_ALMOST_FULL);
	PCM_EnableInt();
	for(i=0;i<8;i++)		
		PCM_Inp32(g_oPCMState.PCMIpNum, rPCMRXFIFO);	
	while(!(g_uPcmIrqStateFlag&RXFIFO_ALMOST_FULL));
	PCM_DisableInt();	
	Disp("\nRX FIFO ALMOST FULL Check OK..");	


//wait till fifo Almost Empty
	PCM_SetInt(RXFIFO_ALMOST_EMPTY);
	PCM_EnableInt();
	for(i=0;i<32-(8*2);i++)		
		PCM_Inp32(g_oPCMState.PCMIpNum, rPCMRXFIFO);	
	while(!(g_uPcmIrqStateFlag&RXFIFO_ALMOST_EMPTY));
	PCM_DisableInt();	
	Disp("\nRX FIFO ALMOST Empty Check OK..");	

//wait till fifo  Empty
	PCM_SetInt(RXFIFO_EMPTY);
	PCM_EnableInt();
	for(i=0;i<8;i++)		
		PCM_Inp32(g_oPCMState.PCMIpNum, rPCMRXFIFO);	
	while(!(g_uPcmIrqStateFlag&RXFIFO_EMPTY));
	PCM_DisableInt();	
	Disp("\nRX FIFO Empty Check OK..");	


//wait till fifo  Empty
	PCM_SetInt(RXFIFO_ERROR_STARVE);
	PCM_EnableInt();
	PCM_Inp32(g_oPCMState.PCMIpNum, rPCMRXFIFO);	
	while(!(g_uPcmIrqStateFlag&RXFIFO_ERROR_STARVE));
	PCM_DisableInt();	
	Disp("\nRX FIFO Empty UnderFlow Check OK..\n");	




//PCM go to check TransferDone flag
	temp1=PCM_Inp32(g_oPCMState.PCMIpNum, rPCMCLKCTL);
	temp2=PCM_Inp32(g_oPCMState.PCMIpNum, rPCMCTRL);	
	PCM_SetInt(TRANSFER_DONE);
	PCM_EnableInt();	
	PCM_Outp32(g_oPCMState.PCMIpNum, rPCMCLKCTL, (temp1 | PCM_SCLK_EN)  );
	PCM_Outp32(g_oPCMState.PCMIpNum, rPCMCTRL,    (temp2 | PCM_PCM_ENABLE)  );
	PCM_Inp32(g_oPCMState.PCMIpNum, rPCMRXFIFO);	
	while(!(g_uPcmIrqStateFlag&TRANSFER_DONE)); 
	PCM_DisableInt();
	
	temp1=PCM_Inp32(g_oPCMState.PCMIpNum, rPCMCLKCTL);
	temp2=PCM_Inp32(g_oPCMState.PCMIpNum, rPCMCTRL);
	PCM_Outp32(g_oPCMState.PCMIpNum, rPCMCLKCTL, (temp1 & ~PCM_SCLK_EN)  );
	PCM_Outp32(g_oPCMState.PCMIpNum, rPCMCTRL,    (temp2 & ~(PCM_PCM_ENABLE|PCM_TXFIFO_EN) )   );
	PCM_ISRDeInit();
	

      if  (g_uPcmIrqStateFlag == (RXFIFO_EMPTY | RXFIFO_ALMOST_EMPTY | RXFIFO_FULL | 
	  						   RXFIFO_ALMOST_FULL | RXFIFO_ERROR_STARVE|RXFIFO_ERROR_OVERFLOW |
	  						   IRQ_PENDING | TRANSFER_DONE ))
		Disp("\nALL RX Interrupt Status Register GOOD!!...\n");
	else
		Disp("\nALL RX Interrupt Status Register FAIL!!...\n");
}

/*
///////////////////////////////////////////////



void __irq Isr_PCM_Interrupt(void)
{
		unsigned int i, uPcmFifoStat; 
		int testreg;

	if(g_oPCMState.PCMIpNum == PCM_IP0)	
	{		
		rINTMSK2|=(BIT_PCM0);
		
		g_pcmirqstat[g_interrupt_cnt].irqstat1 = rPCM_IRQ_STAT0;
		
		if(rPCM_IRQ_CTL0 & RXFIFO_FULL) testreg = rPCM_RXFIFO0;	
		else if(rPCM_IRQ_CTL0 & RXFIFO_ALMOST_FULL) testreg = rPCM_RXFIFO0;	
		if(rPCM_IRQ_CTL0 & RXFIFO_EMPTY) rPCM_RXFIFO0=0x1111;	
		else if(rPCM_IRQ_CTL0 & RXFIFO_ALMOST_EMPTY) rPCM_RXFIFO0=0x1111;	
		
//		if(rPCM_IRQ_CTL0 & TXFIFO_FULL) testreg = rPCM_TXFIFO0;	
//		else if(rPCM_IRQ_CTL0 & TXFIFO_ALMOST_FULL) testreg = rPCM_TXFIFO0;			
		if(rPCM_IRQ_CTL0 & TXFIFO_EMPTY) rPCM_TXFIFO0=0x1111;	
		else if(rPCM_IRQ_CTL0 & TXFIFO_ALMOST_EMPTY) rPCM_TXFIFO0=0x1111;			
		
		
		PCM_ClearInt();		
		g_pcmirqstat[g_interrupt_cnt].irqstat2 = rPCM_IRQ_STAT0;
		g_interrupt_cnt++;
		
		
		Disp("interrupt occured\n");		
		
		if(g_interrupt_cnt>=PCM_IRQ_STAT_MAX) PCM_DisableInt();		
		ClearPending2(BIT_PCM0);		
		rINTMSK2&=~(BIT_PCM0);
	}
	else
	{
		rINTMSK2|=(BIT_PCM1);
		
		g_pcmirqstat[g_interrupt_cnt].irqstat1 = rPCM_IRQ_STAT1;
		
		if(rPCM_IRQ_CTL1 & RXFIFO_FULL) testreg = rPCM_RXFIFO1;	
		else if(rPCM_IRQ_CTL1 & RXFIFO_ALMOST_FULL) testreg = rPCM_RXFIFO1;	
		if(rPCM_IRQ_CTL1 & RXFIFO_EMPTY) rPCM_RXFIFO1=0x1111;	
		else if(rPCM_IRQ_CTL1 & RXFIFO_ALMOST_EMPTY) rPCM_RXFIFO1=0x1111;	
		
//		if(rPCM_IRQ_CTL1 & TXFIFO_FULL) testreg = rPCM_TXFIFO1;	
//		else if(rPCM_IRQ_CTL1 & TXFIFO_ALMOST_FULL) testreg = rPCM_TXFIFO1;			
		if(rPCM_IRQ_CTL1 & TXFIFO_EMPTY) rPCM_TXFIFO1=0x1111;	
		else if(rPCM_IRQ_CTL1 & TXFIFO_ALMOST_EMPTY) rPCM_TXFIFO1=0x1111;	
		
		
		PCM_ClearInt();		
		g_pcmirqstat[g_interrupt_cnt].irqstat2 = rPCM_IRQ_STAT1;
		g_interrupt_cnt++;
		
		Disp("interrupt occured\n");				
		
		if(g_interrupt_cnt>=PCM_IRQ_STAT_MAX) PCM_DisableInt();		
		ClearPending2(BIT_PCM1);		
		rINTMSK2&=~(BIT_PCM1);	
	}
}



void __irq Isr_PCM_InterruptTEST(void)
{
		unsigned int i, uPcmFifoStat; 
		int testreg;

	if(g_oPCMState.PCMIpNum == PCM_IP0)	
	{		
		rINTMSK2|=(BIT_PCM0);
		
		g_pcmirqstat[g_interrupt_cnt].irqstat1 = rPCM_IRQ_STAT0;
		
		if(rPCM_IRQ_CTL0 & RXFIFO_FULL) testreg = rPCM_RXFIFO0;	
		else if(rPCM_IRQ_CTL0 & RXFIFO_ALMOST_FULL) testreg = rPCM_RXFIFO0;	
		if(rPCM_IRQ_CTL0 & RXFIFO_EMPTY) rPCM_RXFIFO0=0x1111;	
		else if(rPCM_IRQ_CTL0 & RXFIFO_ALMOST_EMPTY) rPCM_RXFIFO0=0x1111;	
		
		if(rPCM_IRQ_CTL0 & TXFIFO_FULL) testreg = rPCM_TXFIFO0;	
		else if(rPCM_IRQ_CTL0 & TXFIFO_ALMOST_FULL) testreg = rPCM_TXFIFO0;			
		if(rPCM_IRQ_CTL0 & TXFIFO_EMPTY) rPCM_TXFIFO0=0x1111;	
		else if(rPCM_IRQ_CTL0 & TXFIFO_ALMOST_EMPTY) rPCM_TXFIFO0=0x1111;			
		
		
		PCM_ClearInt();		
		g_pcmirqstat[g_interrupt_cnt].irqstat2 = rPCM_IRQ_STAT0;
		g_interrupt_cnt++;
		
		
		Disp("interrupt occured\n");		
		
		if(g_interrupt_cnt>=PCM_IRQ_STAT_MAX) PCM_DisableInt();		
		ClearPending2(BIT_PCM0);		
		rINTMSK2&=~(BIT_PCM0);
	}
	else
	{
		rINTMSK2|=(BIT_PCM1);
		
		g_pcmirqstat[g_interrupt_cnt].irqstat1 = rPCM_IRQ_STAT1;
		
		if(rPCM_IRQ_CTL1 & RXFIFO_FULL) testreg = rPCM_RXFIFO1;	
		else if(rPCM_IRQ_CTL1 & RXFIFO_ALMOST_FULL) testreg = rPCM_RXFIFO1;	
		if(rPCM_IRQ_CTL1 & RXFIFO_EMPTY) rPCM_RXFIFO1=0x1111;	
		else if(rPCM_IRQ_CTL1 & RXFIFO_ALMOST_EMPTY) rPCM_RXFIFO1=0x1111;	
		
		if(rPCM_IRQ_CTL1 & TXFIFO_FULL) testreg = rPCM_TXFIFO1;	
		else if(rPCM_IRQ_CTL1 & TXFIFO_ALMOST_FULL) testreg = rPCM_TXFIFO1;			
		if(rPCM_IRQ_CTL1 & TXFIFO_EMPTY) rPCM_TXFIFO1=0x1111;	
		else if(rPCM_IRQ_CTL1 & TXFIFO_ALMOST_EMPTY) rPCM_TXFIFO1=0x1111;	
		
		
		PCM_ClearInt();		
		g_pcmirqstat[g_interrupt_cnt].irqstat2 = rPCM_IRQ_STAT1;
		g_interrupt_cnt++;
		
		Disp("interrupt occured\n");				
		
		if(g_interrupt_cnt>=PCM_IRQ_STAT_MAX) PCM_DisableInt();		
		ClearPending2(BIT_PCM1);		
		rINTMSK2&=~(BIT_PCM1);	
	}
}


*/


//////////
// Function Name : PCM_Outp32
// Function Description : This function write 32 bit value to SFR
// Input : 	eIPnum - PCM Port Number 
//			offset - SFR Offset
//			x - Register Value
// Output :	None
// Version : v0.0
static void PCM_Outp32(unsigned char  eIPnum, PCM_SFR offset, u32 x) 
{
	if (eIPnum == PCM_IP0)
		Outp32(PCM0_BASE+offset, x);
	else if (eIPnum == PCM_IP1)
		Outp32(PCM1_BASE+offset, x);		
	else	
		Outp32(PCM2_BASE+offset, x);
}

//////////
// Function Name : PCM_Outp16
// Function Description : This function write 16 bit value to SFR
// Input : 	eIPnum - PCM Port Number 
//			offset - SFR Offset
//			x - Register Value
// Output :	None
// Version : v0.0
static void PCM_Outp16(unsigned char  eIPnum, PCM_SFR offset, u32 x) 
{
	if (eIPnum == PCM_IP0)
		Outp16(PCM0_BASE+offset, x);
	else if (eIPnum == PCM_IP1)
		Outp16(PCM1_BASE+offset, x);
	else
		Outp16(PCM2_BASE+offset, x);
}

//////////
// Function Name : PCM_Inp32
// Function Description : This function read 32 bit value to SFR
// Input : 	eIPnum - PCM Port Number 
//			offset - SFR Offset			
// Output :	u32 - SFR Register Value
// Version : v0.0
static u32  PCM_Inp32(unsigned char  eIPnum, PCM_SFR offset)
{
	if (eIPnum == PCM_IP0)
		return Inp32(PCM0_BASE+offset);
	else if (eIPnum == PCM_IP1)
		return Inp32(PCM1_BASE+offset);
	else 
		return Inp32(PCM2_BASE+offset);
	
}

//////////
// Function Name : PCM_Inp16
// Function Description : This function read 16 bit value to SFR
// Input : 	eIPnum - PCM Port Number 
//			offset - SFR Offset			
// Output :	u16 - SFR Register Value
// Version : v0.0
static u16 PCM_Inp16(unsigned char  eIPnum, PCM_SFR offset)
{
	if (eIPnum == PCM_IP0)
		return Inp16(PCM0_BASE+offset);
	else if (eIPnum == PCM_IP1)
		return Inp16(PCM1_BASE+offset);
	else
		return Inp16(PCM2_BASE+offset);
	
}




