
#ifndef __MODEMIF_H__
#define __MODEMIF_H__

#ifdef __cplusplus
extern "C" {
#endif


/*******************************************************************************
* DEFINES
*******************************************************************************/
//#define	_S5PV210_MODEM_IF_FPGA

#define	_S5PV210_MODEM_IF_SROMC_		1	// For Standard Mode Test.
#define	_S5PV210_MODEM_IF_ONENANDC_	0	// For Muxed Mode Test.

#define	MODEM_PRINTF(x...)	UART_Printf(x)
//#define	MODEM_PRINTF(x...)	

#define	MODEMIF_Outp8(addr, data) 		Outp8(addr, data)
#define	MODEMIF_Inp8(addr)  			Inp8(addr)
#define 	MODEMIF_Outp16(addr, data) 	Outp16(addr, data)
#define 	MODEMIF_Inp16(addr)  			Inp16(addr)
#define 	MODEMIF_Outp32(addr, data) 	Outp32(addr, data)
#define 	MODEMIF_Inp32(addr)  			Inp32(addr)

/////////////////////
////MODEM I/F SFR////
/////////////////////
#ifdef _S5PV210_MODEM_IF_FPGA
#define 	DPSRAM_BASE_MODEM		(0x80000000)	// nCS0 for S5PV210
#else
#if _S5PV210_MODEM_IF_SROMC_
#define 	DPSRAM_BASE_MODEM		(0xA0000000)	// nCS4 to SROMC for S5PV210
#else if _S5PV210_MODEM_IF_ONENANDC_
#define 	DPSRAM_BASE_MODEM		(0xB0000000)	// nCS4 to ONE-NANDC	 for S5PV210
#endif
#endif

#define 	DPSRAM_BASE_AP			(0xED000000)	//	DPSRAM Addr for S5PV210

#define 	DPSRAM_SIZE				(0x1FF0)		// 8KB-16

#define 	AP_TX_Queue		(DPSRAM_BASE_AP + 0x00002000)
#define 	AP_RX_Queue		(DPSRAM_BASE_AP)

#define 	MSM_TX_Queue	(DPSRAM_BASE_MODEM)
#define 	MSM_RX_Queue	(DPSRAM_BASE_MODEM + 0x00002000)

#define 	AP_TX_BUFFER	(_DRAM_BaseAddress + 0x01000000)
#define 	AP_RX_BUFFER	(_DRAM_BaseAddress + 0x01100000)

#define 	MSM_TX_BUFFER	(_DRAM_BaseAddress + 0x01000000)
#define 	MSM_RX_BUFFER	(_DRAM_BaseAddress + 0x01100000)

#define	INT2AP_ADR		0x3FFE	// S5PV210 : Default Value.
#define	INT2MSM_ADR		0x3FFC	// S5PV210

#define 	BLK_COUNT	10	// AP 4KB BLOCK COUNT
#define 	DMA_COUNT	10	// MODEM DMA COUNT

//#define MODEM_TX_BUFLEN	(0x1000-0x10)	// 4KB-16B (16Bytes means DMA Request Addresses and Interrupt Reqeust addresses)
#define MODEM_TX_BUFLEN	0x100 
#define 	AP_TX_BUFLEN		0x100

#define 	MODEM_DMA_TX_BUFLEN		0x1000
#define 	AP_DMA_TX_BUFLEN		0x1000

#define	DMA_TX_ADDR1	0x17FE
#define	DMA_TX_ADDR0	0x13FE
#define	DMA_RX_ADDR1	0x1FFE
#define	DMA_RX_ADDR0	0x1BFE


#define	EXT_INT_3_CON		0xE0200E0C
#define	EXT_INT_3_FLTCON1	0xE0200E9C
#define	EXT_INT_3_PEND		0xE0200F4C
#define	EXT_INT_3_MASK		0xE0200F0C

/*******************************************************************************
* ENUM
*******************************************************************************/
enum MODEMIF_SFR
{
	rINT2AP		= MODEMIF_BASE + 0x8000,
	rINT2MSM		= MODEMIF_BASE + 0x8004,
	rMIFCON		= MODEMIF_BASE + 0x8008,
	rMIFPCON		= MODEMIF_BASE + 0x800C,
	rMSMINTCLR	= MODEMIF_BASE + 0x8010,
	rDMA_TX_ADR	= MODEMIF_BASE + 0x8014,
	rDMA_RX_ADR	= MODEMIF_BASE + 0x8018,
};

typedef enum
{
	MODEMIF_AP_TX=	0,
	MODEMIF_AP_RX,
	MODEMIF_MODEM_TX,
	MODEMIF_MODEM_RX
}
MODEMIF_XFER_MODE;

typedef enum
{
	MODEMIF_TX_0=0,
	MODEMIF_TX_1,
	MODEMIF_RX_0,
	MODEMIF_RX_1,	
}
MODEMIF_DMA_REQ_NUM;

typedef enum
{
	MODEM_AP_TX_INT = 0x0202,

	MODEM_AP_TX_INITIAL = 0x00AA,
	MODEM_AP_TX_DATA_XFER = 0x00BB,
	MODEM_AP_TX_XFER_DONE = 0x00CC,

//	MODEM_AP_DMA_TX_INITIAL = 0x00DD,
	MODEM_AP_DMA_TX_DATA_XFER = 0x00EE,
	MODEM_AP_DMA_TX_XFER_DONE = 0x00FF,

	MODEM_MSM_TX_INT = 0x2020,

	MODEM_MSM_TX_INITIAL = 0x0001, // 0xAA00,
	MODEM_MSM_TX_DATA_XFER = 0x0003, // 0xBB00,
	MODEM_MSM_TX_XFER_DONE = 0x0002, // 0xCC00,

//	MODEM_MSM_DMA_TX_INITIAL = 0xDD00,
	MODEM_MSM_DMA_TX_DATA_XFER = 0xEE00,
	MODEM_MSM_DMA_TX_XFER_DONE = 0xFF00,

	////////////////////////////////////////////////////
	////// SIMULTANEOUS DPSRAM ACCESS TEST /////
	///////////////////////////////////////////////////
	MODEM_AP_TO_MSM_TO_READ = 0x0004,
	MODEM_AP_TO_MSM_TO_WRITE = 0x0005,
	MODEM_MSM_TO_AP_TO_READ = 0x0006,
	MODEM_MSM_TO_AP_TO_WRITE = 0x0007,

	//////////////////////////////////
	////// PERFORMANCE TEST /////
	/////////////////////////////////
	MODEM_MSM_TX_AP_RX_INITIAL = 0x0011,
	MODEM_MSM_TX_AP_RX_DATA_XFER = 0x0022,
	MODEM_MSM_TX_AP_RX_XFER_DONE = 0x0033,

	MODEM_MSM_RX_AP_TX_INITIAL = 0x0044,
	MODEM_MSM_RX_AP_TX_DATA_XFER = 0x0055,
	MODEM_MSM_RX_AP_TX_XFER_DONE = 0x0066,

	///////////////////////////////////////
	////// DMA PERFORMANCE TEST /////
	//////////////////////////////////////
	MODEM_MSM_TX_AP_DMA_RX_INITIAL = 0x0110,
	MODEM_MSM_TX_AP_DMA_RX_READY = 0x0220,
	MODEM_MSM_TX_AP_DMA_RX_DATA_XFER = 0x0330,
	MODEM_MSM_TX_AP_DMA_RX_XFER_DONE = 0x0440,
	MODEM_MSM_TX_AP_DMA_RX_END = 0x0550,
	
	MODEM_MSM_RX_AP_DMA_TX_READY = 0x0660,
	MODEM_MSM_RX_AP_DMA_TX_XFER_DONE = 0x0770,
	MODEM_MSM_RX_AP_DMA_TX_END = 0x0880,
	
}MODEMIF_Events_et;

/*******************************************************************************
* STRUCTURES
*******************************************************************************/

/*******************************************************************************
* FUNCTION PROTOTYPES
*******************************************************************************/
// MODEM I/F ISR
void __irq Isr_AP2MODEM(void);
void __irq Isr_MODEM2AP(void);

// MODEM I/F Initialize function
void MODEMIF_AP_Init(u8 ucMode, u8 INT2MSMEN, u8 INT2APEN);
void MODEMIF_MODEM_Init(u8 INT2MSMEN, u8 INT2APEN);

// Interrupt address set function
void MODEMIF_Int2AP(u32 int_add);
void MODEMIF_Int2Modem(u32 int_add);

// Interrupt Clear function
void MODEMIF_IntClear_Int2AP(void);
u16 MODEMIF_IntClear_Int2MSM(void);

// MODEM I/F GPIO port setting function
void MODEMIF_AP_SetPort(void);
void MODEMIF_Modem_SetPort(void);

// MODEM DMA APIs
void MODEMIF_SET_APDMA(MODEMIF_XFER_MODE eRxTx, MODEMIF_DMA_REQ_NUM eSrcNum, u8 ucEn);
void MODEMIF_SET_DMA_REQ_ADDR(MODEMIF_XFER_MODE eRxTx, MODEMIF_DMA_REQ_NUM eSrcNum, u16 usAddr);

#ifdef __cplusplus
}
#endif

#endif/* __MODEMIF_H__ */
//__MODEMIF_H__
