
//===================================================================
// NAME		: modemif.c
// DESC		: S5PC100 DPSRAM test 
// History		: 10.22.2008 ver 0.1 by Sun il, Roe
//===================================================================

//#include "def.h"
//#include "sromc.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "option.h"
#include "library.h"
#include "v210_sfr.h"
#include "system.h"
#include "uart\uart.h"
#include "sysc.h"
#include "gpio.h"
#include "intc.h"
#include "dma.h"
#include "modemif.h"
#include "timer.h"
#include "util.h"

/*******************************************************************************
* GLOBAL VARIABLES
*******************************************************************************/
volatile int g_ApDataCnt;
volatile int g_MsmDataCnt;

volatile int g_APDMAReadReady;		// DMA Write Done flag of AP side
volatile int g_ApDMAReadReadyReply;
volatile int g_APDMAReadDone;			// DMA Read Done flag of AP side
volatile int g_ApDMAReadDoneReply;

volatile int g_ModemDMAReadReady;			// Read Done flag of Modem side
volatile int g_ModemDMAReadReadyReply;
volatile int g_ModemDMAReadDone;			// Read Done flag of Modem side
volatile int g_ModemDMAReadDoneReply;

volatile int g_APDMAWriteReady;		// DMA Write Done flag of AP side
volatile int g_ApDMAWriteReadyReply;
volatile int g_APDMAWriteDone;		// DMA Write Done flag of AP side
volatile int g_ApDMAWriteDoneReply;

volatile int g_ModemDMAWriteReady;
volatile int g_ModemDMAWriteReadyReply;
volatile int g_ModemDMAWriteDone;		// Write Done flag of Modem side
volatile int g_ModemDMAWriteDoneReply;

volatile int g_ApReadyReply;	
volatile int g_APReadDone;				// Read Done flag of AP side
volatile int g_ApReadDoneReply;

volatile int g_ModemReadyReply;		// Modem Ready Reply flag from Modem to AP
volatile int g_ModemReadDone;
volatile int g_ModemReadDoneReply;	// Read Done Reply flag from Modem to AP

volatile int g_ApWriteReadyReply;
volatile int g_ApWriteDone;
volatile int g_ApWriteDoneReply;

volatile int g_ModemWriteReadyReply;
volatile int g_ModemWriteDone;
volatile int g_ModemWriteDoneReply;


/*******************************************************************************
* EXTERNS
*******************************************************************************/
extern volatile int	g_DmaDoneMTx;
extern volatile int	g_DmaDoneMRx;
extern volatile int	g_DmaDoneATx;
extern volatile int	g_DmaDoneARx;

extern DMAC oAPRx0;
extern DMAC oAPTx0;

extern u8 ucModemDMAPort;


/*******************************************************************************
* FUNCTION PROTOTYPES
*******************************************************************************/
// TEST PURPOSE...2009.09.27
void __irq Isr_AP2MSM(void)
{
	u16 temp = 0;
	u16 length = 0;
	u16	i=0;
	u16 *rx_data = NULL;
	u16	*rx_buf = NULL;
	u16	*temp_rx_buf = NULL;
	
	u16 *tx_data = NULL;
	u16	*tx_buf = NULL;

	u16 *msm_tx_data = NULL;
	u16 *msm_tx_buf = NULL;

	INTC_Disable(NUM_GPIOINT);
	
	// EINT Pending Clear & AP2MODEM INT Clear & Message
	MODEMIF_Outp32(0xE0200A08, 0x00000001);	// GPB_INT_PEND : Clear pending interrupt of GPB_INT[0]

	temp = MODEMIF_IntClear_Int2MSM();
	MODEM_PRINTF("\n Modem Received = 0x%x\n", temp);

	//////////////////////////////
	////// MODEM TX ISR //////////
	/////////////////////////////	
	if ( temp == MODEM_MSM_TX_INITIAL )
	{
		MODEM_PRINTF("AP RX READY OK....\n");
		g_ApReadyReply = 1;
	}
	else if ( temp == MODEM_MSM_TX_DATA_XFER ) 
	{
		MODEM_PRINTF("AP RX....\n");
		g_ApReadDoneReply = 1;
	}
	
	////////////////////////////////////
	////////////// AP TX ISR //////////
	///////////////////////////////////	
	else if ( temp == MODEM_AP_TX_INITIAL )
	{
		MODEM_PRINTF("[AP TX Started.....MODEM OK!!!]\n");
		g_ApWriteReadyReply = 1;
	}
	else if ( temp == MODEM_AP_TX_DATA_XFER )
	{
		MODEM_PRINTF("[AP TX Data Transfered...]\n");
		g_ApWriteDoneReply = 1;
	}
	else if ( temp == MODEM_AP_TX_XFER_DONE )
	{
		MODEM_PRINTF("[MODEM RX Done]\n");
		g_ApWriteDone = 1;
	}
	else if ( temp == MODEM_AP_TX_INT )
	{
		MODEM_PRINTF("[MODEM RX : AP TX Interrupt Done]\n");
	}

	else
		MODEM_PRINTF("Error = 0x%04x\n", temp);

	
	INTC_ClearVectAddr();

	INTC_Enable(NUM_GPIOINT);
}


//for MODEM EINT
void __irq Isr_AP2MODEM(void)
{
	u16 temp = 0;
	u16 length = 0;
	u16	i=0;
	u16 *rx_data = NULL;
	u16	*rx_buf = NULL;
	u16	*temp_rx_buf = NULL;
	
	u16 *tx_data = NULL;
	u16	*tx_buf = NULL;

	u16 *msm_tx_data = NULL;
	u16 *msm_tx_buf = NULL;

	INTC_Disable(NUM_EINT16_31);
	
	// EINT Pending Clear & AP2MODEM INT Clear & Message
	MODEMIF_Outp32(EXT_INT_3_PEND, 0x00000010);	// EXT_INT_3_PEN : Clear pending interrupt of EXT_INT[28]
	
	temp = MODEMIF_IntClear_Int2MSM();
//	MODEM_PRINTF("\n Modem Received = 0x%x\n", temp);

	//////////////////////////////////////
	/////// MODEM DMA TX ISR //////////
	/////////////////////////////////////
	if ( temp == MODEM_MSM_DMA_TX_DATA_XFER )
	{
		MODEM_PRINTF("[AP DMA RX XFER... !!!]\n");
		g_ModemDMAWriteReady = 1;
	}
	else if ( temp == MODEM_MSM_DMA_TX_XFER_DONE )
	{
		MODEM_PRINTF("[MODEM DMA TX Done]\n"); 
		g_ModemDMAWriteDone = 1;
	}
	
	//////////////////////////////
	////// MODEM TX ISR //////////
	/////////////////////////////	
	else if ( temp == MODEM_MSM_TX_INITIAL )
	{
		MODEM_PRINTF("AP RX READY OK....\n");
		g_ApReadyReply = 1;
	}
	else if ( temp == MODEM_MSM_TX_DATA_XFER ) 
	{
		MODEM_PRINTF("AP RX....\n");
		g_ApReadDoneReply = 1;
	}

	////////////////////////////////////
	///////// AP DMA TX ISR //////////
	///////////////////////////////////	
	else if ( temp == MODEM_AP_DMA_TX_DATA_XFER )
	{
//		MODEM_PRINTF("[AP DMA TX XFER... !!!]\n");
		g_ModemDMAReadReady = 1;
	}
	else if( temp == MODEM_AP_DMA_TX_XFER_DONE )
	{
		MODEM_PRINTF("[AP DMA TX Done!!!]\n");
		g_ModemDMAReadDone = 1;
	}
	
	////////////////////////////////////
	////////////// AP TX ISR //////////
	///////////////////////////////////	
	else if ( temp == MODEM_AP_TX_INITIAL )
	{
		MODEM_PRINTF("[AP TX Started.....MODEM OK!!!]\n");
		g_ApWriteReadyReply = 1;
	}
	else if ( temp == MODEM_AP_TX_DATA_XFER )
	{
		MODEM_PRINTF("[AP TX Data Transfered...]\n");
		g_ApWriteDoneReply = 1;
	}
	else if ( temp == MODEM_AP_TX_XFER_DONE )
	{
		MODEM_PRINTF("[MODEM RX Done]\n");
		g_ApWriteDone = 1;
	}
	else if ( temp == MODEM_AP_TX_INT )
	{
		MODEM_PRINTF("[MODEM RX : AP TX Interrupt Done]\n");
	}
	
	////////////////////////////////////////////////////
	///// SIMULTANEOUS DPSRAM ACCESS TEST //////
	////////////////////////////////////////////////////
	else if( temp == MODEM_AP_TO_MSM_TO_READ )
	{
		MODEM_PRINTF("[AP_TO_MSM_TO_READ]\n");
		g_ApReadyReply = 1;
	}
	else if( temp == MODEM_AP_TO_MSM_TO_WRITE )
	{
		MODEM_PRINTF("[AP_TO_MSM_TO_WRITE]\n");
		g_ApReadyReply = 1;
	}

	//////////////////////////////////////////
	///// AP RX PERFORMANCE TEST /////
	/////////////////////////////////////////
	else if( temp == MODEM_MSM_TX_AP_RX_INITIAL )
	{
		MODEM_PRINTF("[AP RX READY OK]\n");
		g_ApReadyReply = 1;
	}
	else if ( temp == MODEM_MSM_TX_AP_RX_DATA_XFER ) 
	{
		g_ApReadDoneReply = 1;
	}

	//////////////////////////////////////////
	///// AP TX PERFORMANCE TEST /////
	/////////////////////////////////////////
	else if( temp == MODEM_MSM_RX_AP_TX_INITIAL )
	{
		MODEM_PRINTF("[AP TX READY OK]\n");
		g_ApWriteReadyReply = 1;
	}
	else if( temp == MODEM_MSM_RX_AP_TX_DATA_XFER )
	{
		g_ApWriteDoneReply = 1;
	}
	else if( temp == MODEM_MSM_RX_AP_TX_XFER_DONE )
	{
		g_ApWriteDone = 1;
	}
	
	/////////////////////////////////////////////
	///// AP DMA RX PERFORMANCE TEST /////
	////////////////////////////////////////////
	else if( temp == MODEM_MSM_TX_AP_DMA_RX_READY )
	{
//		MODEM_PRINTF("[AP DMA RX READY]\n");
		g_ModemDMAWriteReady = 1;
	}
	else if( temp == MODEM_MSM_TX_AP_DMA_RX_XFER_DONE )
	{
		g_ModemDMAWriteDoneReply = 1;	
	}
	
	/////////////////////////////////////////////
	///// AP DMA TX PERFORMANCE TEST /////
	////////////////////////////////////////////
	else if( temp == MODEM_MSM_RX_AP_DMA_TX_READY )
	{
//		MODEM_PRINTF("[AP TX READY OK]\n");
		g_ModemDMAReadReady = 1;
	}
	else if( temp == MODEM_MSM_RX_AP_DMA_TX_XFER_DONE )
	{
		g_ModemDMAReadDone = 1;
	}
	else if( temp == MODEM_MSM_RX_AP_DMA_TX_END )
	{
		g_ModemDMAReadDoneReply = 1;
	}
	
	else
		MODEM_PRINTF("Error = 0x%04x\n", temp);

	
	INTC_ClearVectAddr();

	INTC_Enable(NUM_EINT16_31);	
}

/**
* {Isr_MODEM2AP}
*
* @brief			AP ISR.
* @description	Interrupt Request from Modem to AP.
* @param[in]	(void)
* @return		void.
* @version		2009.07.17
* @author		Ho-June Byun(hjune.byun@samsung.com)
* 
*/
void __irq Isr_MODEM2AP(void)
{
	u16 length = 0;
	u16 temp = 0;
	u16 i=0;

	u16 *rx_data = NULL;
	u16	*rx_buf = NULL;
	u16	*temp_rx_buf = NULL;
	
	u16 *tx_data = NULL;
	u16	*tx_buf = NULL;
	
	
	INTC_Disable(NUM_MSM);
	
	temp = (MODEMIF_Inp16(DPSRAM_BASE_AP + INT2AP_ADR)) & 0xFFFF;
//	MODEM_PRINTF("\n AP Received = 0x%x\n", temp);
	MODEMIF_IntClear_Int2AP();

	/////////////////////////////////////
	////// MODEM DMA TX ISR //////////
	/////////////////////////////////////
 	if (temp == MODEM_MSM_DMA_TX_XFER_DONE)
	{
//		MODEM_PRINTF("[AP DMA RX Done]\n");		
		g_APDMAReadDone = 1;
	}
	//////////////////////////////
	////// MODEM TX ISR //////////
	/////////////////////////////	
	else if (temp == MODEM_MSM_TX_INITIAL)
	{
		MODEM_PRINTF("[MSM TX Ready...AP OK!!!]\n");
		g_ModemWriteReadyReply = 1;
	}
	else if (temp == MODEM_MSM_TX_DATA_XFER)
	{
		MODEM_PRINTF("[MSM TX Started.....AP OK!!!]\n");
		g_ModemWriteDoneReply = 1;
	}
	else if (temp == MODEM_MSM_TX_XFER_DONE)
	{
		MODEM_PRINTF("[AP RX Done]\n");
		g_APReadDone = 1;
	}
	else if (temp == MODEM_MSM_TX_INT)
	{
		MODEM_PRINTF("[AP RX : MODEM TX Interrupt Done]\n");
	}

	///////////////////////////
	////// AP DMA TX ISR /////
	///////////////////////////
	else if (temp == MODEM_AP_DMA_TX_XFER_DONE)
	{
//		MODEM_PRINTF("[AP DMA TX Done!!!]\n"); 
		g_APDMAWriteDone = 1;
	}
	
	//////////////////////
	////// AP TX ISR /////
	//////////////////////	
	else if (temp == MODEM_AP_TX_INITIAL)
	{
		MODEM_PRINTF("MODEM RX READY OK...\n");
		g_ModemReadyReply = 1;
	}
	else if (temp == MODEM_AP_TX_DATA_XFER) 
	{
		MODEM_PRINTF("MODEM RX OK... \n");
		g_ModemReadDoneReply = 1;
	}
	
	///////////////////////////////////////////////////
	///// SIMULTANEOUS DPSRAM ACCESS TEST /////
	//////////////////////////////////////////////////
	else if( temp == MODEM_MSM_TO_AP_TO_READ )
	{
		MODEM_PRINTF("[MSM_TO_AP_TO_READ]\n");
		g_ModemReadyReply = 1;
	}
	else if( temp == MODEM_MSM_TO_AP_TO_WRITE )
	{
		MODEM_PRINTF("[MSM_TO_AP_TO_WRITE]\n");
		g_ModemReadyReply = 1;
	}
	
	//////////////////////////////////////////
	///// AP RX PERFORMANCE TEST /////
	/////////////////////////////////////////
	else if ( temp == MODEM_MSM_TX_AP_RX_INITIAL )
	{
		MODEM_PRINTF("[MSM TX READY OK]\n");
		g_ModemWriteReadyReply = 1;
	}
	else if ( temp == MODEM_MSM_TX_AP_RX_DATA_XFER )
	{
		g_ModemWriteDoneReply = 1;
	}
	else if ( temp == MODEM_MSM_TX_AP_RX_XFER_DONE )
	{
		MODEM_PRINTF("[AP RX Done]\n");
		g_ModemWriteDone = 1;
	}

	//////////////////////////////////////////
	///// AP TX PERFORMANCE TEST /////
	/////////////////////////////////////////
	else if( temp == MODEM_MSM_RX_AP_TX_INITIAL )
	{
		MODEM_PRINTF("[MSM RX READY OK]\n");
		g_ModemReadyReply = 1;
	}
	else if( temp == MODEM_MSM_RX_AP_TX_DATA_XFER )
	{
		g_ModemReadDoneReply = 1;
	}

	//////////////////////////////////////////
	///// AP DMA RX PERFORMANCE TEST /////
	/////////////////////////////////////////
	else if( temp == MODEM_MSM_TX_AP_DMA_RX_INITIAL )
	{
		g_ApDMAReadReadyReply = 1;
	}
	else if( temp == MODEM_MSM_TX_AP_DMA_RX_READY )
	{
		g_ApDMAReadDoneReply = 1;
	}
	else if( temp == MODEM_MSM_TX_AP_DMA_RX_END )
	{
//		MODEM_PRINTF("[AP DMA RX Done]\n");
		g_APDMAReadDone = 1;
	}

	//////////////////////////////////////////
	///// AP DMA TX PERFORMANCE TEST /////
	/////////////////////////////////////////
	else if( temp == MODEM_MSM_RX_AP_DMA_TX_READY )
	{
		g_ApDMAWriteDoneReply = 1;
	}

	else
		MODEM_PRINTF("[Error!!!: 0x%x ]\n",temp);	


	INTC_ClearVectAddr();
	
	INTC_Enable(NUM_MSM);
}

void MODEMIF_Int2AP(u32 int_add)
{
	MODEMIF_Outp32(rINT2AP, int_add);
}

void MODEMIF_Int2Modem(u32 int_add)
{
	MODEMIF_Outp32(rINT2MSM, int_add);
}

void MODEMIF_IntClear_Int2AP(void)
{	
	MODEMIF_Outp16(rMSMINTCLR, 0xFFFF);

	MODEMIF_Outp16( DPSRAM_BASE_AP + INT2AP_ADR, 0x0000 );
}

u16 MODEMIF_IntClear_Int2MSM(void) 
{
	u16 temp;

	temp = (MODEMIF_Inp16( DPSRAM_BASE_MODEM + INT2MSM_ADR) ) & 0xFFFF;
	MODEMIF_Outp16( DPSRAM_BASE_MODEM + INT2MSM_ADR, temp );

	return temp;
}

void MODEMIF_AP_SetPort(void)
{
	// S5PV210, Set MODEM I/F GPIO Port : 
	//	GPJ0CON : 0xE020_0240
	//	GPJ1CON : 0xE020_0260
	//	GPJ2CON : 0xE020_0280
	//	GPJ3CON : 0xE020_02A0
	//	GPJ4CON : 0xE020_02C0
	#if _S5PV210_MODEM_IF_SROMC_
	GPIO_SetFunctionAll(eGPIO_J0, 0x22222222);	//GPJ0CON[31:0] -> MSM_ADDR[7:0]
	GPIO_SetFunctionAll(eGPIO_J1, 0x222222);	 	//GPJ1CON[23:0] -> MSM_ADDR[13:8]
	#endif
	GPIO_SetFunctionAll(eGPIO_J2, 0x22222222);	//GPJ2CON[31:0] -> MSM_DATA[7:0]
	GPIO_SetFunctionAll(eGPIO_J3, 0x22222222);	//GPJ3CON[31:0] -> MSM_DATA[15:8]
	GPIO_SetFunctionAll(eGPIO_J4, 0x22222);		//GPJ4CON[19:0] -> MSM Control Signals (MSM_CSn, MSM_WEn, MSM_Rn, MSM_IRQn, MSM_ADVn)
}

void	MODEMIF_Modem_SetPort(void)
{
	// SROMC write
#ifdef _S5PV210_MODEM_IF_FPGA
	//	SROMC BANK 0
	*(volatile unsigned *)0xE8000004 = (0<<28)|(4<<24)|(0xf<<16)|(1<<12)|(2<<8)|(0<<4)|(0<<0);	// ing. for SMDK S5PV210 Rev0.0
	*(volatile unsigned *)0xE8000000 = (1<<0);	// ing. for SMDK S5PV210 Rev0.0	/* SROM_BASE = 0xE8000000 */
#else	
	#if _S5PV210_MODEM_IF_SROMC_
	//	SROMC BANK 4
	u32	data = 0;

	data = (1<<16);	// Memory Bank 4(DPSRAM_BASE_MODEM : 0xA000_0000), 16 bit, half-word base address
	MODEMIF_Outp32(SROM_BASE, data);

	data = (0<<28)|(0<<24)|(0xF<<16)|(1<<12)|(0<<8)|(0<<4)|(0<<0); // Memory Bank 4(0xA000_0000), Out Enable hold clock
	// SROMC_BC4 : Bank 4 Control Register
	MODEMIF_Outp32(SROM_BASE + 0x14, data);
	
	// GPIO setting for SROMC
	// MP0_1CON ( 0xE020_02E0 )
	GPIO_SetFunctionAll(eGPIO_MP0_1, 0x22222222); // MP0_1CON ( 0xE020_02E0 ) : EBI_WEN, EBI_OEN, SROM_CSn[0~5].
	#else if _S5PV210_MODEM_IF_ONENANDC_
	/*
		IN MUXED MODE, MODEM I/F MUST INTERACT WITH ONENANDC.
	*/
	// GPIO Setting for OneNAND which is default setting.
	// MP0_1CON ( 0xE020_02E0 ) :
	GPIO_SetFunctionAll(eGPIO_MP0_1, 0x22553322); // EBI_WEN, EBI_OEN,

	GPIO_SetFunctionEach(eGPIO_MP0_1, eGPIO_4, eGFunc_3); //CSn[0]
	GPIO_SetFunctionEach(eGPIO_MP0_1, eGPIO_5, eGFunc_3); //CSn[1]
	GPIO_SetFunctionEach(eGPIO_MP0_3, eGPIO_0, eGFunc_3); //AVD
	GPIO_SetFunctionEach(eGPIO_MP0_3, eGPIO_1, eGFunc_3); //SMCLK
	GPIO_SetFunctionEach(eGPIO_MP0_3, eGPIO_2, eGFunc_3); //RPn
	GPIO_SetFunctionEach(eGPIO_MP0_3, eGPIO_4, eGFunc_3); //INT[0]
	GPIO_SetFunctionEach(eGPIO_MP0_3, eGPIO_5, eGFunc_3); //INT[1]

	/* Drive Strength */
	MODEMIF_Outp32(0xE02002EC,0xFFFF);
	MODEMIF_Outp32(0xE020032C,0xFFFF);
	MODEMIF_Outp32(0xE020038C,0xFFFF);
	MODEMIF_Outp32(0xE02003AC,0xFFFF);
	
	SYSC_SetClkDiv(eCLKDIV_ONENAND, 6);	
	#endif
#endif

// TEST PURPOSE...2009.08.27
#if 1
	// for S5PV210
	// Modem I/F Interrupt request GPIO setting : 0xE0200C68 
	GPIO_SetPullUpDownEach(eGPIO_H3, eGPIO_4, 0x0); // GPH3CON[4] : Pull Down Disable

	// S5PV210 : GPH3CON[4] : 0xE0200C60
	GPIO_SetFunctionEach(eGPIO_H3, eGPIO_4, 0xF);	// set functions as EXT_INT[28]
	
	// S5PV210 : EXT_INT_3_CON[4]
	#if 0
	/* NG : Sometimes, GPIO misses falling egde of EINT[28]. 2009.08.21 */
	MODEMIF_Outp32(EXT_INT_3_CON, 0x00020000);		// EXT_INT_3_CON : Set Falling edge triggered of EXT_INT[28]
	#else
	MODEMIF_Outp32(EXT_INT_3_CON, 0x00000000);		// EXT_INT_3_CON : Set Active Low triggered of EXT_INT[28]
	#endif
	
	// S5PV210 : EXT_INT_3_FLTCON1[4]
	MODEMIF_Outp32(EXT_INT_3_FLTCON1, 0x00000080);		// EXT_INT_3_FLTCON1 : Filter Enable, Select Delay Filter, Set Filtering width as 0 of EXT_INT[28]

	// Clear the previous pending states
	// S5PV210 : EXT_INT_3_PEND[4] : EXT_INT[28]
	MODEMIF_Outp32(EXT_INT_3_PEND, 0x00000010);	// EXT_INT_3_PEND : Clear pending interrupt of EXT_INT[28]

	// S5PV210 : EXT_INT_3_MASK
	MODEMIF_Outp32(EXT_INT_3_MASK, 0x00000000);	// EXT_INT_3_MASK : Enable Interrupt of EXT_INT[28]
#else

	// for S5PV210
	// Modem I/F Interrupt request GPIO setting : GPBCON[0]
	GPIO_SetPullUpDownEach(eGPIO_B, eGPIO_0, 0x0); // Pull Down Disable
	
	// S5PV210 : GPBCON[0]
	GPIO_SetFunctionEach(eGPIO_B, eGPIO_0, 0xF);	// set functions as GPB_INT[0]
	
	// S5PV210 : GPB_INT_CON[0]
	MODEMIF_Outp32(0xE0200708, 0x00000002);	// GPB_INT_CON[0] : Set Falling edge triggered of GPB_INT[0]
	
	// S5PV210 : GPB_INT_FLTCON0
	MODEMIF_Outp32(0xE0200810, 0x00000008);	// GPB_INT_FLTCON0 : Filter Enable, Select Delay Filter, Set Filtering width as 0 of GPB_INT[0]

	// Clear the previous pending states
	// S5PV210 : GPB_INT_PEND[0] : GPB_INT[0]
	MODEMIF_Outp32(0xE0200A08, 0x00000001);	// GPB_INT_PEND : Clear pending interrupt of GPB_INT[0]

	// S5PV210 : GPB_INT_MASK
	MODEMIF_Outp32(0xE0200908, 0x00000000);	// GPB_INT_MASK : Enable Interrupt of GPB_INT[0]
#endif
}

void MODEMIF_AP_Init(u8 ucMode, u8 INT2MSMEN, u8 INT2APEN)
{
	u8	ucADM_MODE = 0;	// Address Muxed Mode Selection : '0' = Demuxed Mode, '1' = Muxed Mode.
	/* 
		Interrupt to MSM Active High : 
		'0' = Disable, '1' = Enable 
		'1' is Spec-Out, Only '0' is used.
		2009.08.18 
	*/
	u8	ucINT2M_LEVEL = 0;
	
	// Modem I/F Set AP Port
	MODEMIF_AP_SetPort();

	//Interrupt Setting (MODEM, EINT)Isr_AP2MODEM
	INTC_SetVectAddr(NUM_MSM, Isr_MODEM2AP);		// for Modem Rx
	INTC_Enable(NUM_MSM);

	//MODEM I/F Interrupt enable, Direct mode select
	MODEMIF_Outp32(rMIFCON, (1<<20) | (INT2MSMEN<<3)|(INT2APEN<<2));

	//MODEM I/F Address Muxed Mode Selection
	#if _S5PV210_MODEM_IF_ONENANDC_
	ucADM_MODE = 1;
	#endif
	MODEMIF_Outp32(rMIFPCON, (ucADM_MODE<<6) | (ucINT2M_LEVEL<<4) );
	
	//INT Address Setting
	MODEMIF_Int2AP(INT2AP_ADR);
	MODEMIF_Int2Modem(INT2MSM_ADR);

	//INT2AP Clear
	MODEMIF_IntClear_Int2AP();
}

void MODEMIF_MODEM_Init(u8 INT2MSMEN, u8 INT2APEN)
{
	// Modem I/F Set Modem Port
	MODEMIF_Modem_SetPort();

#if	1
	// Interrupt Setting (MODEM : EINT)
	INTC_SetVectAddr(NUM_EINT16_31, Isr_AP2MODEM);	// NUM_EINT28 
	INTC_Enable(NUM_EINT16_31);
#else
	// TEST PURPOSE...2009.08.27
	INTC_SetVectAddr(NUM_GPIOINT, Isr_AP2MSM);
	INTC_Enable(NUM_GPIOINT);	
#endif

	// MODEM I/F Interrupt enable
	MODEMIF_Outp32(rMIFCON, (1<<20) | (INT2MSMEN<<3) | (INT2APEN<<2));	
	
	// AP2MODEM Interrupt Clear
	MODEMIF_IntClear_Int2MSM(); 
}

void MODEMIF_SET_APDMA(MODEMIF_XFER_MODE eRxTx, MODEMIF_DMA_REQ_NUM eSrcNum, u8 ucEn)
{
	u32	rTempReg = 0;
	
	Assert(eRxTx==MODEMIF_AP_TX || eRxTx==MODEMIF_AP_RX);

	rTempReg = MODEMIF_Inp32(rMIFCON);
	rTempReg = rTempReg | (ucEn<<(eSrcNum+16) );
	MODEMIF_Outp32(rMIFCON, rTempReg);
}

void MODEMIF_SET_DMA_REQ_ADDR(MODEMIF_XFER_MODE eRxTx, MODEMIF_DMA_REQ_NUM eSrcNum, u16 usAddr)
{
	Assert(eRxTx == MODEMIF_AP_TX || eRxTx == MODEMIF_AP_RX);
	
	if ( eRxTx == MODEMIF_AP_TX )			//	AP Tx --> Modem Rx
	{		
		MODEMIF_Outp32(rDMA_TX_ADR, (usAddr << (eSrcNum*16)) );
	}
	else if ( eRxTx == MODEMIF_AP_RX )		//	AP Rx <-- Modem Tx
	{
		MODEMIF_Outp32(rDMA_RX_ADR, (usAddr << ((eSrcNum-2)*16)) );
	}	
}

