/**************************************************************************************
*
*	Project Name : S5PV210 FPGA Validation
*
*	Copyright 2009 by Samsung Electronics, Inc.
*	All rights reserved.
*
*	Project Description :
*		This software is only for verifying functions of the S5PV210 FPGA
*		Anybody can use this software without our permission.
*  
*--------------------------------------------------------------------------------
* 
*	File Name : keypad.h
*  
*	File Description : This file implements the API functons for KEYPAD
*
*	Author	: Jongseok,Park
*	Dept. : AP Development Team
*	Created Date : 2009/04/16
*	Version : 0.2
*
*	Author : Sung-Hyun, Na
*	Dept. : AP Development Team
*	Created Date : 2008/11/03
*	Version : 0.1 
* 
*	History
*	- Version 0.1
*           ->Created(Sung-Hyun, Na 2008/11/03) for S5PC100  Validation
*	- Version 0.2
*           -> Modified(JongSeok,Park 2009/03/25) for S5PV210 FPGA verification
**************************************************************************************/



#ifndef __KEYPAD_SOFT_H__
#define __KEYPAD_SOFT_H__

#ifdef __cplusplus
extern "C" {
#endif

#include "def.h"
#include "gpio.h"

#define USE_AUTO_TEST_MODE	1

#ifndef AUTOTEST_OK
#define AUTOTEST_OK		1
#endif /* AUTOTEST_OK */

#ifndef AUTOTEST_FAIL
#define AUTOTEST_FAIL			0
#endif /* AUTOTEST_FAIL */

#define KEY_Falling_Press		0				//Default SMDK H/W Configurtion
#define KEY_Rising_Press		1
#define KEYHW				KEY_Falling_Press


//#define KEYPAD_8BY8_MODE	1
extern bool	gKEYPAD_Is8by8Mode;

#define KEYPAD_COLNUM		8

//#define KEYPAD_ROWNUM	8
extern u32 KEYPAD_ROWNUM;

#define KEY_ScanDelay		10
enum KEYPAD_SFR
{
	rKEYIFCON		= 0x0,
	rKEYIFSTSCLR		= 0x4,
	rKEYIFCOL		= 0x8,
	rKEYIFROW		= 0xc,
	rKEYIFFC			= 0x10
};

#define KEYSCANCODE		2

#define KEYPAD_EN_WakeupINT		(1 << 4)
#define KEYPAD_EN_FilterCounter		(1 << 3)
#define KEYPAD_EN_DebounceFilter		(1 << 2)
#define KEYPAD_EN_RisingINT			(1 << 1)
#define KEYPAD_EN_FallingINT			(1 << 0)

#define KEYPAD_ST_FallingINT			(0xff << 0)
#define KEYPAD_ST_RigingINT			(0xff << 8)

#define KEYPAD_ST_KeyCol			(0xff << 0)
#define KEYPAD_EN_KeyCol			(0xff << 8)

#define KEYPAD_ST_KeyRow			(0xff << 0)

typedef enum
{
	KeyPort0 = 0,
	KeyPort1 = 1,
}KEYPORT;

typedef enum
{
	DF_RTCCLK	= 0,
	DF_OSC		= 1
}DFSOURCE;

typedef enum
{
	Key_Falling 	= 1,
	Key_Rising	= 2,
	Key_Both		= 3,
}KEY_INTSOURCE;

typedef struct _KEYIF_TestInfor
{
	KEYPORT 		m_eRowPort;
	KEYPORT 		m_eColPort;
	GPIO_ePUD 		m_ePullUpDn;
	DFSOURCE		m_eDFilterSource;
	KEY_INTSOURCE	m_eIntSource;
	u32				m_uWakeup;
	u32				m_uFilterEn;
	u32 			m_uColEn;	
	u32				m_uFilterVal;
}KEYIF_Configuration;

typedef struct 
{
	KEYIF_Configuration m_oConfiguration;		
	//Key Scan	
	void (*m_fnCallback)(u32);			// callback function pointer - for generate transfer completed signal
	u32 m_uCallbackVar;					// callback function parameter
//	void (*m_fnKeyISR[KEYPAD_COLNUM][KEYPAD_ROWNUM])(u32);
	void (*m_fnKeyISR[KEYPAD_COLNUM][14])(u32);
//	u32 m_uVarKeyISR[KEYPAD_COLNUM][KEYPAD_ROWNUM];
	u32 m_uVarKeyISR[KEYPAD_COLNUM][14];
}KEYPAD_INFOR;

KEYIF_Configuration KEYPAD_DefaultConfiguration(void);
KEYPAD_INFOR* KEYPAD_GetInfor(void);
void KEYPAD_Create(KEYIF_Configuration pConfiguration, void (*callbackFn)(u32), u32 uCallBackVar);
void KEYPAD_Close(void);


void KEYPAD_OpenPort(KEYPORT eRowPort, KEYPORT eColPort, GPIO_ePUD eRowPullEn);
void KEYPAD_ClosePort(KEYPORT eRowPort, KEYPORT eColPort);
void KEYPAD_SetKEYIFCON(u32 uWakeUpEn, u32 uDFSource, u32 uFilterEn, KEY_INTSOURCE uIntrSrc);

void __irq Isr_KEYPAD(void);

void KEYPAD_FallingScan(void);
void KEYPAD_RisingScan(void);

void KEYPAD_EnableWakeup(u32);
void KEYPAD_EnableFilterCNT(u32);
void KEYPAD_EnableDBFilter(u32 uSel);
void KEYPAD_SelectINT(KEY_INTSOURCE eSel, u32 uEnable);
u8 KEYPAD_SetDFCNT(s32 uCntValue);
void KEYPAD_STSCLR(u32 ucP_INT, u32 ucR_INT);
void KEYPAD_STSCLRCon(KEY_INTSOURCE eInt, u8 ucClr);
u32 KEYIFSTSCLR_GetReg(void);

void KEYPAD_COL(u8 ucCOL,u8 ucCOLLEnable);
void KEYPAD_ColumnOut(u8 ucCol);
void KEYPAD_EnableCol(u8 ucColen);
u32 KEYPAD_ROW(void);
bool KEYPAD_SFR_Test(void);

#define	ENABLE					1
#define	DISABLE				0


bool KEYPAD_Configuration(KEYIF_Configuration* pConfiguration);
void KEYPAD_DispTestCon(KEYIF_Configuration* pConfiguration);
void KEYPADConf_Port(KEYIF_Configuration* pConfiguration);
void KEYPAD_Sel_Wakeup(KEYIF_Configuration* pConfiguration);
void KEYPADConf_FilterCNT(KEYIF_Configuration* pConfiguration);
void KEYPADConf_DBFilter(KEYIF_Configuration* pConfiguration);
void KEYPADConf_INTCond(KEYIF_Configuration* pConfiguration);
void KEYPADConf_DFCNT(KEYIF_Configuration* pConfiguration);

void KEYPAD_Test(void);
bool KEYPAD_HighToLowScan(KEYIF_Configuration* pConfiguration);
void KEYPAD_LowToHighScan(KEYIF_Configuration* pConfiguration);

bool KEYPAD_Set8by8(KEYIF_Configuration* pConfiguration);
bool KEYPAD_Set14by8(KEYIF_Configuration* pConfiguration);


bool KEYPAD_GetCheckedKeyEvent_8by8(bool *pIsKeyPressed, u8 *pRow, u8 *pCol);
bool KEYPAD_GetCheckedKeyEvent_14by8(bool *pIsKeyPressed, u8 *pRow, u8 *pCol);


#ifdef __cplusplus
}
#endif

#endif

