/**************************************************************************************
*
*	Project Name : S5PV210 FPGA Validation
*
*	Copyright 2009 by Samsung Electronics, Inc.
*	All rights reserved.
*
*	Project Description :
*		This software is only for verifying functions of the S5PV210 FPGA
*		Anybody can use this software without our permission.
*  
*--------------------------------------------------------------------------------
* 
*	File Name : iic.h
*  
*	File Description : This file implements the API functons for IIC
*
*	Author	: Jongseok,Park
*	Dept. : AP Development Team
*	Created Date : 2009/04/16
*	Version : 0.0 
*
*	History
*	- Version 0.1  : (2009/04/16) 
*         -> Created
**************************************************************************************/
 
#ifndef __IIC_H__
#define __IIC_H__

#include "def.h"
#include "v210_sfr.h"

enum IIC_CH
{
	IIC_CH0				= 0,	 //for Gerneral
	IIC_CH2				= 2,	 //for PMIC		
	IIC_CH_HDMI_DDC	= 1,  //for DDC
	IIC_CH_HDMI_PHY		= 3,	 //Internally only	
};

enum IIC0_SFR
{
	rIICCON0		= I2C0_BASE+0x00,
	rIICSTAT0		= I2C0_BASE+0x04,
	rIICADD0		= I2C0_BASE+0x08,
	rIICDS0		= I2C0_BASE+0x0C,
	rIICLC0		= I2C0_BASE+0x10
};

//I2C bus for HDMI_PHY is inernally conntected...
enum IIC_HDMI_PHY_SFR    	
{
	rIICCON_HDMI_PHY		= I2C_HDMI_PHY_BASE+0x00,
	rIICSTAT_HDMI_PHY		= I2C_HDMI_PHY_BASE+0x04,
	rIICADD_HDMI_PHY		= I2C_HDMI_PHY_BASE+0x08,
	rIICDS_HDMI_PHY			= I2C_HDMI_PHY_BASE+0x0C,
	rIICLC_HDMI_PHY			= I2C_HDMI_PHY_BASE+0x10
};

enum IIC_HDMI_DDC_SFR	
{
	rIICCON_HDMI_DDC		= I2C_HDMI_DDC_BASE+0x00,
	rIICSTAT_HDMI_DDC		= I2C_HDMI_DDC_BASE+0x04,
	rIICADD_HDMI_DDC		= I2C_HDMI_DDC_BASE+0x08,
	rIICDS_HDMI_DDC			= I2C_HDMI_DDC_BASE+0x0C,
	rIICLC_HDMI_DDC			= I2C_HDMI_DDC_BASE+0x10
};

enum IIC2_SFR	
{
	rIICCON2		= I2C2_BASE+0x00,
	rIICSTAT2		= I2C2_BASE+0x04,
	rIICADD2		= I2C2_BASE+0x08,
	rIICDS2		= I2C2_BASE+0x0C,
	rIICLC2		= I2C2_BASE+0x10
};

#define	SlaveRX			(0)
#define	SlaveTX			(1)
#define	MasterRX		(2)
#define	MasterTX		(3)


typedef struct IIC_REG_st
{
	u32 CON;
	u32 STAT;
	u32 ADD;
	u32 DS;
	u32 LC;
}st_IIC_REG;



void IIC_sfr_mapping_Init(u32 ch);
	
// Channel 0
void __irq Isr_IIC0(void);
void IIC0_Open(u32 ufreq);
void IIC0_OpenPolling(u32 ufreq);
void IIC0_Close(void);
void IIC0_SetWrite(u8 cSlaveAddr, u8 * pData, u32 uDataLen);
void IIC0_SetRead(u8 cSlaveAddr, u8 * pData, u32 uDataLen);
u8 IIC_Status(void);

void IIC0_MasterWrP(u8 cSlaveAddr,u8 * pData);
void IIC0_SlaveRdP(u8 *pSlaveAddr,u8 *pData);
void IIC0_MasterRdP(u8 cSlaveAddr,u8 * pData);
void IIC0_SlaveWrP(u8 *pSlaveAddr,u8 *pData);
void IIC0_SlaveWrInt(u8 *pSlaveAddr,u8 *pData);
void IIC0_SlaveRdInt(u8 *pSlaveAddr,u8 *pData);

void IIC0_Write(u8 cSlaveAddr,  u8 cAddr, u8 cData);
void IIC0_Write16(u8 cSlaveAddr, u8 cAddr, u16 cData);
void IIC0_WriteA16D16(u8 cSlaveAddr, u16 cAddr, u16 cData);	// Added by SOP on 2008/06/16
void IIC0_Read(u8 cSlaveAddr,  u8 cAddr, u8 * cData);
u16 IIC0_Read16(u8 cSlaveAddr,  u8 cAddr);		// Added for WM8990 by SOP on 2008/09/25
void IIC0_ReadA16D16(u8 cSlaveAddr, u16 cAddr, u8 *cData);	// Added by SOP on 2008/06/16
void IIC_Wait(void);

// Channel 2 (for PMIC)
void __irq Isr_IIC2(void);
void IIC2_Open(u32 ufreq);		
void IIC2_OpenPolling(u32 ufreq);
void IIC2_Close(void);			
void IIC2_SetWrite(u8 cSlaveAddr, u8 * pData, u32 uDataLen);
void IIC2_SetRead(u8 cSlaveAddr, u8 * pData, u32 uDataLen);

void IIC2_MasterWrP(u8 cSlaveAddr,u8 * pData);
void IIC2_SlaveRdP(u8 *pSlaveAddr,u8 *pData);
void IIC2_MasterRdP(u8 cSlaveAddr,u8 * pData);
void IIC2_SlaveWrP(u8 *pSlaveAddr,u8 *pData);
void IIC2_SlaveWrInt(u8 *pSlaveAddr,u8 *pData);
void IIC2_SlaveRdInt(u8 *pSlaveAddr,u8 *pData);

void IIC2_Write(u8 cSlaveAddr,  u16 cAddr, u8 cData);
void IIC2_Read(u8 cSlaveAddr, u16 cAddr, u8 *cData);

void ClockInform(void);			// Added by SOP on 2008/03/27

u32 IIC_CheckStop(void);			//added by jspark
u32 IIC_CheckAck(void);			//added by jspark
u32 IIC_Set_StopSignal(u8 uStop);	//added by jspark
void IIC2_Open_new( u32 PLCKmode, u32 Prescaler);		//added by jspark



/*******************************************************************************
* DEFINES
*******************************************************************************/
#define	I2C_MAX_FREQ		500000

/*
*	EEPROM Setting Condition for FPGA is different from the one for SMDK
*	EEPROM in FPGA :  One is KS24C080C for Ch0, the Other is S524AD0XD1 for Ch2.
*	EEPROM in SMDK :  One is S524AD0XD1 for Ch0 Only.
*	2007.07.17
*/
//#define	S5PV210_I2C_FPGA


#ifndef I2C_DISP_DEBUG
#define	I2C_Outp8(addr, data) 		Outp8(addr, data)
#define	I2C_Inp8(addr)  			Inp8(addr)
#define 	I2C_Outp32(addr, data) 		Outp32(addr, data)
#define 	I2C_Inp32(addr)  			Inp32(addr)
#else
#define 	I2C_Outp8(addr, data)		{UART_Printf("Outp8(\'h%08x, \'h%08x);\n", addr, data), Outp8(addr, data);}
#define 	I2C_Inp8(addr) 				{Inp8(addr); UART_Printf("Inp8(\'h%08x, d); // d=0x%08x\n", addr, Inp8(addr));}
#define 	I2C_Outp32(addr, data)	{UART_Printf("Outp32(\'h%08x, \'h%08x);\n", addr, data), Outp32(addr, data);}
#define 	I2C_Inp32(addr)  			{Inp32(addr); UART_Printf("Inp32(\'h%08x, d); // d=0x%08x\n", addr, Inp32(addr));}
#endif


/*
 * I2C related
 */
// i2c-bus control register(I2CCON)
#define 	I2CCON_ACK_ENABLE			(1<<7)
#define 	I2CCON_INT_ENABLE				(1<<5)
#define 	I2CCON_INT_PEND				(1<<4)

#define 	I2CCON_INT_CLEAR				(0<<4)

#define 	I2CCON_CLK						(0x40)	/* fPCLK / 512 */
#define 	I2CCON_PRESCALER				(0x0F)

// i2c-bus control/status register(I2CSTAT)
#define 	I2CSTAT_MASTER_TX_MODE		0xC0
#define 	I2CSTAT_MASTER_RX_MODE		0x80
#define 	I2CSTAT_SLAVE_TX_MODE		0x40
#define 	I2CSTAT_SLAVE_RX_MODE		0x00

#define 	I2CSTAT_START					(1<<5)
#define 	I2CSTAT_ENABLE					(1<<4)
#define 	I2CSTAT_DISABLE					(0<<4)

#define 	I2CSTAT_ARBITER					(1<<3)
#define 	I2CSTAT_ADDR_SLAVE			(1<<2)
#define 	I2CSTAT_ADDR_ZERO				(1<<1)
#define 	I2CSTAT_ACK_ERROR				(1<<0)

#define 	I2CSTAT_IDLE						0

#define	I2CLC_FILTER_ENABLE			(1<<2)
#define	I2CLC_FILTER_DISABLE			(0<<2)

#define 	EVENT_I2C_NO	  		(0)
#define 	EVENT_I2C_DONE  	(1<<0)
#define 	EVENT_I2C_ERROR	(1<<1)

/*******************************************************************************
* ENUM
*******************************************************************************/
enum I2C0_SFR
{
	rI2CCON0		= I2C0_BASE+0x00,
	rI2CSTAT0		= I2C0_BASE+0x04,
	rI2CADD0		= I2C0_BASE+0x08,
	rI2CDS0		= I2C0_BASE+0x0C,
	rI2CLC0		= I2C0_BASE+0x10
};

enum I2C2_SFR	
{
	rI2CCON2		= I2C2_BASE+0x00,
	rI2CSTAT2		= I2C2_BASE+0x04,
	rI2CADD2		= I2C2_BASE+0x08,
	rI2CDS2		= I2C2_BASE+0x0C,
	rI2CLC2		= I2C2_BASE+0x10
};

//I2C bus for HDMI_PHY is inernally conntected...
enum I2C_HDMI_PHY_SFR    	
{
	rI2CCON_HDMI_PHY		= I2C_HDMI_PHY_BASE+0x00,
	rI2CSTAT_HDMI_PHY		= I2C_HDMI_PHY_BASE+0x04,
	rI2CADD_HDMI_PHY		= I2C_HDMI_PHY_BASE+0x08,
	rI2CDS_HDMI_PHY			= I2C_HDMI_PHY_BASE+0x0C,
	rI2CLC_HDMI_PHY			= I2C_HDMI_PHY_BASE+0x10
};

enum I2C_HDMI_DDC_SFR	
{
	rI2CCON_HDMI_DDC		= I2C_HDMI_DDC_BASE+0x00,
	rI2CSTAT_HDMI_DDC		= I2C_HDMI_DDC_BASE+0x04,
	rI2CADD_HDMI_DDC		= I2C_HDMI_DDC_BASE+0x08,
	rI2CDS_HDMI_DDC		= I2C_HDMI_DDC_BASE+0x0C,
	rI2CLC_HDMI_DDC		= I2C_HDMI_DDC_BASE+0x10
};

enum I2C_CH
{
	I2C_CH0				= 0,	 //for Gerneral
	I2C_CH_HDMI_DDC	= 1,  //for DDC
	I2C_CH2				= 2,	 //for PMIC		
	I2C_CH_HDMI_PHY	= 3,	 //Internally only
	
	I2C_CH_NUM_END,
};

typedef enum
{
	I2C_IDLE_STATE,
	
	I2C_MASTER_TX_EDDC_SEGADDR_STATE,
	I2C_MASTER_TX_EDDC_SEGNUM_STATE,
	I2C_MASTER_TX_DDC_ADDR_STATE,
	I2C_MASTER_TX_DDC_OFFSET_STATE,
	I2C_MASTER_RX_DDC_ADDR_STATE,
	I2C_MASTER_RX_DDC_DATA_STATE,
	
	I2C_MASTER_RX_ADDR_STATE,
	I2C_MASTER_RX_DATA_STATE,
	I2C_MASTER_RX_STOP_STATE,
	I2C_MASTER_TX_ADDR_STATE,
	I2C_MASTER_TX_DATA_STATE,
	I2C_MASTER_TX_STOP_STATE,

	I2C_SLAVE_RX_ADDR_STATE,
	I2C_SLAVE_RX_DATA_STATE,
	I2C_SLAVE_RX_STOP_STATE	,
	I2C_SLAVE_TX_ADDR_STATE,
	I2C_SLAVE_TX_DATA_STATE,
	I2C_SLAVE_TX_STOP_STATE
}state_et;

/*******************************************************************************
* STRUCTURES
*******************************************************************************/
typedef struct {
	state_et		eState;
	u8			*buffer;			// Tx Buffer
	u8			*Rx_buffer;		// Rx Buffer
	s32			bytes;
	u8			offset;
	u8			addr;
	u8			segnum;
} I2C_Context_st;

/*******************************************************************************
* FUNCTION PROTOTYPES
*******************************************************************************/
void __irq I2C_MTx_IRQHandler(void);
void __irq I2C_MRx_IRQHandler(void);
void __irq I2C_STx_IRQHandler(void);
void __irq I2C_SRx_IRQHandler(void);

void __irq I2C_IRQHandler(void);

void I2C_SFR_Mapping_Init(u32 ch);
s32 I2C_Release(u32 ch);

s32	I2C_ClockPrescaler(u32 ch, u32 PLCKmode, u32 Prescaler);
s32	I2C_TxClockPrescaler(u32 ch, u32 ufreq);
void	I2C_SDAClockDelay( u32 ch, u8 sda_clk_delay );

s32 I2C_DeInitialize_Controller(u32 ch);
s32 I2C_Initialize_Controller(u32 ch);

void I2C_GPIO_Close(u32 ch);
s32 I2C_GPIO_Open(u32 ch);
s32 I2C_UnRegister_Interrupt(u32 ch);
s32 I2C_Register_Interrupt(u32 ch);

void	I2C_SlaveAddressMatch_Polling(u32 ch);
void	I2C_ACK_Check_Polling(u32 ch);
void	I2C_Pending_Bit_Clear(u32 ch);

///////////////////////////////////////////////////////////////////////////////////////////////////////
////////////////// I2C MASTER & SLAVE INTERRUPT & POLLING BASIC APIs : START ///////////////////
s32 I2C_Polling_InterruptWait(u32 ch);

s32 I2C_Slave_Polling_Read( u32 ch, u8 cSlaveAddr, u8 *pData, s32 uDataLen);
s32 I2C_Slave_Polling_Write(u32 ch, u8 cSlaveAddr, u8 *pData, s32 uDataLen);

s32 I2C_Slave_Interrupt_Read(u32 ch, u8 cSlaveAddr, u8 *pData, s32 uDataLen);
s32 I2C_Slave_Interrupt_Write( u32 ch, u8 cSlaveAddr,  u8 *pData, s32 uDataLen);

s32 I2C_Master_Polling_Read( u32 ch, u8 cSlaveAddr, u8 *pData, s32 uDataLen);
s32 I2C_Master_Polling_Write(u32 ch, u8 cSlaveAddr, u8 *pData, s32 uDataLen);

s32 I2C_Master_Interrupt_Read(u32 ch, u8 cSlaveAddr, u8 *pData, s32 uDataLen);
s32 I2C_Master_Interrupt_Write( u32 ch, u8 cSlaveAddr,  u8 *pData, s32 uDataLen);
////////////////// I2C MASTER & SLAVE INTERRUPT & POLLING BASIC APIs : END /////////////////////
//////////////////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////	I2C CH 0 & CH 2 R/W TEST APIs USING EEPROMs : START /////////////////////////////////////////
s32 I2C_Ch2_Master_Polling_Read_EEPROM(u32 ch, u8 cSlaveAddr, u8 cAddr, u8 *cData);
s32 I2C_Ch2_Master_Polling_Write_EEPROM(u32 ch, u8 cSlaveAddr, u8 cAddr, u8 cData);

s32 I2C_Ch0_Master_Polling_Read_EEPROM(u32 ch, u8 cSlaveAddr, u8 cAddr, u8 *cData);
s32 I2C_Ch0_Master_Polling_Write_EEPROM(u32 ch, u8 cSlaveAddr, u8 cAddr, u8 cData);

s32 I2C_Ch2_Master_Interrupt_Read_EEPROM(u32 ch, u8 cSlaveAddr, u8 cAddr, u8 *cData);
s32 I2C_Ch2_Master_Interrupt_Write_EEPROM(u32 ch, u8 cSlaveAddr, u8 cAddr, u8 cData);

s32 I2C_Ch0_Master_Interrupt_Read_EEPROM(u32 ch, u8 cSlaveAddr, u8 cAddr, u8 *cData);
s32 I2C_Ch0_Master_Interrupt_Write_EEPROM(u32 ch, u8 cSlaveAddr, u8 cAddr, u8 cData);
///////////////////	I2C CH 0 & CH 2 R/W TEST APIs USING EEPROMs : END /////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////// CLOCK DIVIDER & CLOCK GATING TEST APIs : START ////////////////////////////
u8	I2C0_CLKDIV( u32 uDividerValue );
u8	I2C0_CLKDIVTest(void);
u8	I2C0_CLKGateTest(void);

u8	I2C1_CLKDIV( u32 uDividerValue );
u8	I2C1_CLKDIVTest(void);
u8	I2C1_CLKGateTest(void);
///////////////////	CLOCK DIVIDER & CLOCK GATING TEST APIs : END ///////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////


/*******************************************************************************
 * HDMI PHY : START
 ******************************************************************************/
s32 I2C_HDMI_PHY_Init(void);
s32 I2C_HDMI_PHY_DeInit(void);
s32	I2C_HDMI_PHY_Read(u8 ucAddr, u8 ucBytes, u8 *pBuffer);
s32	I2C_HDMI_PHY_Write(u8 ucAddr, u8 ucBytes, u8 *pBuffer);
/*******************************************************************************
 * HDMI PHY : END
 ******************************************************************************/

/*******************************************************************************
 * HDMI DDC : START
 ******************************************************************************/
s32 I2C_HDMI_DDC_Init(void);
s32 I2C_HDMI_DDC_DeInit(void);
s32 I2C_HDMI_DDC_Read(u8 addr, u8 bytes, u8 *buffer);
s32	I2C_HDMI_DDC_Write(u8 addr, u8 bytes, u8 *buffer);
s32	I2C_HDMI_DDC_ReadHDCP(u8 addr, u8 offset, u8 bytes, u8 *buffer);
s32 I2C_HDMI_DDC_ReadEDDC(u8 segaddr, u8 segnum, u8 addr, u8 offset, u8 bytes, u8* buffer);
/*******************************************************************************
 * HDMI DDC : END
 ******************************************************************************/

/*******************************************************************************
 * PMIC : START
 ******************************************************************************/
s32 I2C_PMIC_Init(void);
s32 I2C_PMIC_DeInit(void);
s32	I2C_PMIC_Read(u8 ucAddr, u8 ucBytes, u8 *pBuffer);
s32 I2C_PMIC_Write(u8 ucAddr, u8 ucBytes, u8 *pBuffer);
/*******************************************************************************
 * PMIC : END
 ******************************************************************************/

/*******************************************************************************
 * OTHER IPs such as AUDIO, CAMERA I/F etc... : START
 ******************************************************************************/
//s32 I2C_General_IP_Init(u32 ufrequency);
s32 I2C_General_IP_Init(void);
s32 I2C_General_IP_DeInit(void);
s32	I2C_General_IP_Read(u8 ucAddr, u8 ucBytes, u8 *pBuffer);
s32 I2C_General_IP_Write(u8 ucAddr, u8 ucBytes, u8 *pBuffer);
/*******************************************************************************
 * OTHER IPs such as AUDIO, CAMERA I/F etc... : END
 ******************************************************************************/
 
/*******************************************************************************
* EXTERNS
*******************************************************************************/
extern	I2C_Context_st	I2C_Context;
extern	u32 gI2C_EventStatus;
extern	u32		gI2c_CH_Index;
extern	st_IIC_REG I2C_REG[];

extern	u32		gI2c_Tx_Ch;
extern	u32		gI2c_Rx_Ch;

#endif //__IIC_H__
