#include "option.h"
#include "library.h"
#include "v210_sfr.h"
#include "system.h"
#include "sysc.h"
#include "gpio.h"
#include "intc.h"
#include "i2c.h"
#include "def.h"

#define I2CBASE	I2C0_BASE

#define Delayfn	Delay




static const u32 I2CBUFSIZE = 0x20;

static const 	u8 m_ucConReg;
static const 	u8 m_ucStatReg;

enum I2C_SFR
{
	I2C_CON = I2CBASE + 0x00, // Control & Status
		// [7] Ack enable, 0=Disable, 1=Enable
		// [6] IICCLK(Source TxClk), 0=PCLK_FREQ/16, 1=PCLK_FREQ/512
		// [5] Int enable, 0=Disable, 1=Enable
		// [4] (Read) 1=Interrupt occurred, (Write) 0=Clear & Resume
		// [3:0] TxClk = IICCLK/(IICON[3:0]+1)
	I2C_STAT = I2CBASE + 0x04, // Control & Status
		// [7:6] Mode, 0=SlaveRx, 1=SlaveTx, 2=MasterRx, 3=MasterTx
		// [5] (Read) 1=Busy, (Write) 0=STOP, 1=START
		// [4] Data pin, 0=Disable, 1=Enable
		// [3] IIC-Bus arbitration status, 0=Successful, 1=Failed
		// [2] Address status as slave, 1=Matched address received
		// [1] 1=Addr '0' received.
		// [0] Last received bit, 0=ACK received, 1=NAK received.
	I2C_ADDR = I2CBASE + 0x08,
		// [7:1] Slave address
	I2C_DS = I2CBASE + 0x0C,
		// [7:0] Data
	I2C_LC = I2CBASE + 0x10
		// [2] SDA filter, 1=Enable
		// [1:0] SDA delay, 0=0clk, 1=5clk, 2=10clk, 3=15clk
};

//#define COMMON_CON (0<<7|0<<6|1<<5|0xf<<0) // Source of SrcTxClk=PCLK_FREQ/16, TxClk=PCLK/16/(0xf)
#define COMMON_CON (0<<7|1<<6|1<<5|0x1<<0) // Source of SrcTxClk=PCLK_FREQ/16, TxClk=PCLK/16/(0xf)
#define COMMON_STAT (1<<4)

#define icReadyTx() Outp32(I2C_STAT, 3<<6|COMMON_STAT)
#define icStartTx() Outp32(I2C_STAT, 3<<6|1<<5|COMMON_STAT)
#define icStopTx() Outp32(I2C_STAT, 3<<6|0<<5|COMMON_STAT)

#define icReadyRx()Outp32(I2C_STAT, 2<<6|COMMON_STAT)
#define icStartRx()Outp32(I2C_STAT, 2<<6|1<<5|COMMON_STAT)
#define icStopRx() Outp32(I2C_STAT, 2<<6|0<<5|COMMON_STAT)

#define icResumeWithAck() Outp32(I2C_CON, 1<<7|0<<4|COMMON_CON)
#define icResumeWithoutAck() Outp32(I2C_CON, 0<<7|0<<4|COMMON_CON)


void InitBaseHwForI2C(void)
{
#ifdef S5PV210
// I2C0_SDA
// I2C0_SCL
	GPIO_SetFunctionEach(eGPIO_D1,eGPIO_0,eGFunc_0);
	GPIO_SetFunctionEach(eGPIO_D1,eGPIO_1,eGFunc_0);	
	GPIO_SetPullUpDownEach(eGPIO_D1,eGPIO_0,eGPUDdis);
	GPIO_SetPullUpDownEach(eGPIO_D1,eGPIO_1,eGPUDdis);
#endif
}


void InitIp(void)
{
	Disp(("// InitIp()\n"));
	
	Outp32(I2C_ADDR, 0xa0);
	Outp32(I2C_CON, COMMON_CON);
	Outp32(I2C_STAT, COMMON_STAT);
	Outp32(I2C_LC, 
		(1<<2)| // filter enable
		(3<<0)); // SDA delay=15clk
}

u8 WaitForTxComplete(void)
{
	int i,j;
#if 1
	u32 d=0;
	do
	{
		d=Inp32(I2C_CON);
	} while ( d & (1<<4) == 0 );

	d=Inp32(I2C_STAT);
	if ( (d & 1) == 0 )
	{
		for(  i=0; i<20; i++ )
		for(  j=0; j<800; j++ );
//		Disp("ACK\n");
		return 1;
	}
	else // NACK
	{
		for(  i=0; i<20; i++ )
		for(  j=0; j<800; j++ );
//		Disp("NACK\n");
		return 0;
	}
	
	d=Inp8(I2C_CON);
	d &= ~(1<<4);
	Outp8(I2C_CON, d);
#else
	u8 d;

	do
	{
		d=Inp32(I2C_CON);
	} while ( d & (1<<4) == 0 );
	
	do
	{
		d=Inp8(I2C_STAT);
	} while ( (d&1) == 1 );
#endif
}

u8 WaitForBusFree(void)
{
	u32 d = 0;
	while ((d & 1<<5) != 0) {
		Disp(("\t")); 
		d=Inp32(I2C_STAT);
	}
	
	return 1;
}


#define SEND_RETRY 3
void Send(u8 ucSlvAddr, u8 ucRegAddr, u8 ucData)
{
	int i, j;	
	u32 uStatReg, uConReg;

	Disp("// Send()\n");

	for (  i=0; i<SEND_RETRY; i++ )
	{
		u32 uErrCnt=0;
		Delayfn(1);
		// 1. Send the slave addr
		icReadyTx();
		Outp32(I2C_DS, ucSlvAddr);
		icStartTx();
		if ( !WaitForTxComplete() ) uErrCnt++;
		
		// 2. Send the reg. addr
		Outp32(I2C_DS, ucRegAddr);
		for( j=0; j<100; j++ );
		icResumeWithAck(); 
		if ( !WaitForTxComplete() ) uErrCnt++;
			
		// 3. Send the data
		Outp32(I2C_DS, ucData);
		for( j=0; j<100; j++ );
		icResumeWithAck(); 
		if ( !WaitForTxComplete() ) uErrCnt++;
		
		// 4. Stop the master Tx mode.
		icStopTx(); 
		for( j=0; j<100; j++ );
		icResumeWithAck();
		WaitForBusFree(); // Check if the write operation of I2C is finished or not 

		if ( uErrCnt == 0 )
		{
			Delayfn(1);
			return;
		}
	}
}

