//S5PV210
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <stdarg.h>


#include "option.h"
#include "library.h"
#include "v210_sfr.h"
#include "system.h"
#include "intc.h"
#include "dma.h"

#include "rpetc.h"
#include "pcmutils.h"
#include "audiocodecs.h"

#include "i2s1.h"
#include "SfrReadWriten.h"

//Test defines
#define PCM_IN_WAVEFILE_ADDRESS1	0x42000000
#define I2S1_POLLING 0
#define I2S1_DMA 	1

#define I2S1_TEST I2S1_DMA


REGINFOn		sRegInfo_I2S1[] = 
{ 
    //01234567890123                 
	{"I2S1_CON [17]-interrupt status ",I2S1BASE+0x0, 	20-1, RW, 0xE00, DPPB, 0x5007f,0},		
	{"I2S1_MOD ",I2S1BASE+0x4,		15-2, RW, 0x0  , DPDB, 0x0,0},	
	{"I2S1_FIC ",I2S1BASE+0x8, 	16-1, RW, 0x0  , DPPB, 0x8080,0},		
	{"I2S1_PSR ",I2S1BASE+0xc,		16-1, RW, 0x0  , DPPB, 0xbfff,0},	
	{"I2S1_TXD ",I2S1BASE+0x10,	32-1, WO, 0x0  , DPDB, 0,0},	
	{"I2S1_RXD ",I2S1BASE+0x14,	32-1, RO, 0x0  , DPDB, 0,0},	
};

#define VecOutp32 Outp32

bool g_I2S1PlayDone;
bool g_I2S1RecDone;
DMAC 	oI2S1DmaTx;	
DMAC 	oI2S1DmaRx;	


////////////////////////////////////////////////////////////
//
//   APIs
//

//Input : uBitperCh of link bit length - 16,24,8 -  TX output or RX input
//ex: I2S1_Init(APMaster, I2SFormat, 16, RFS_384fs, BFS_32fs, CDCLK_Out, 0);
void I2S1_Init(I2SOPMode eI2SOpmode, I2SDIR eTXR, SerialDataFormat eFormat,
				 unsigned char uBitperCh, I2S_RFSLength	eRFS, I2S_BFSLength eBFS, I2S_CDCLKCON eCDCLKIn,
				unsigned char uPSVALA)
{
	unsigned temp;
	unsigned char uBLC=(uBitperCh==24)?2:
					   (uBitperCh==8)?1:0;//0-16bit
	eFormat=(eFormat>LSBJustified)?I2SFormat:eFormat;
	eTXR=(eTXR>2)?0:eTXR;	
	eCDCLKIn=(eCDCLKIn>1)?0:eCDCLKIn;	
	uPSVALA=(uPSVALA>63)?0:uPSVALA;

	Outp32(I2S1_CON, 0);//init.
	temp = ( uBLC<<13| eCDCLKIn<<12|eI2SOpmode<<11|1<<10 |
		     eTXR<<8|eFormat<<5 | eRFS<<3 | eBFS<<1);//master, 384fs, 48fs, [12-0]cdclk out
	Outp32( I2S1_MOD, temp);//IIS_MOD
	Outp32( I2S1_PSR, 1<<15 | uPSVALA<<8);//IIS_PSR, en, %1

	Outp32( I2S1_FIC, 1<<15);//IIS_FIC, tx flush
	Outp32( I2S1_FIC, 0);//IIS_FIC
	Outp32( I2S1_FIC, 1<<7);//rx flush
	Outp32( I2S1_FIC, 0);
}


//set RCLKsrc 
// 0 : PCLK
// 1 : I2S_SCLK
void I2S1_setRCLKsrc(I2SRCLK eRCLKSRC)
{
	unsigned int temp;
	eRCLKSRC	=(eRCLKSRC>1)?0:eRCLKSRC;


	temp = Inp32(I2S1_MOD);
	temp &= ~(1<<10);
	temp |=  (eRCLKSRC<<10);
	Outp32(I2S1_MOD, temp);
}

//input : TX_PDMAactive, RX_PDMAactive, 
//active External DMA(PDMA0 or 1)
void I2S1_ActiveEXTDMA(unsigned int TX, unsigned int RX)
{
	unsigned int temp;
	temp = Inp32(I2S1_CON);
	temp &= ~(1<<2| 1<<1);
	temp |=  (TX<<2| RX<<1);
	Outp32(I2S1_CON, temp);
}

void I2S1_LinkStart()
{
	unsigned int temp;
	temp = Inp32(I2S1_CON);
	temp &= ~(1<<0);
	temp |=  (1<<0);
	Outp32( I2S1_CON, temp);//IIS_CON, underrun interrupt, start link,
}


void	I2S1_Fill_TXBuffer(u32* uPcmDataAddr, u32* uPcmDataWSize)
{
	unsigned int * pPcmAddr = (unsigned int *)(*uPcmDataAddr);
	int i;
	for(i=0;i<64;i++) {
		Outp32( I2S1_TXD, *pPcmAddr++);
		*uPcmDataWSize=*uPcmDataWSize-1;
	}
	*uPcmDataAddr=(unsigned int )pPcmAddr;
}


void I2S1_Wait_TXBufferFull()
{
	int i;
	while( (I2S1_CON & 0x100)==0x000 )//wait during tx0 not full 
	{
		i++;
		if(i>0x2000000) {
			Disp("tx fifo time out \n");
			break;	
		}
	}	
}


#define I2S1_TX_FIFO_EMPTY 32
void I2S1_playbyCPU(u32 uPcmDataAddr, u32 uPcmDataWSize)
{
	unsigned int temp;
	unsigned int * pPcmAddr;
	int i, j;

	Disp("[I2S1 start play]\n");
	I2S1_Fill_TXBuffer(&uPcmDataAddr, &uPcmDataWSize);
	I2S1_LinkStart();

	pPcmAddr = (unsigned int *)uPcmDataAddr;

	//polling
	while(uPcmDataWSize>I2S1_TX_FIFO_EMPTY)
	{
		do {
			temp=Inp32 ( I2S1_FIC);			
		} while (((temp>>8)&0x7F) >I2S1_TX_FIFO_EMPTY);
			
		for(i=0;i<I2S1_TX_FIFO_EMPTY;i++)  Outp32( I2S1_TXD, *pPcmAddr++);
		uPcmDataWSize=uPcmDataWSize-I2S1_TX_FIFO_EMPTY;
		j++;
		if(j%100==0) Disp(".");
	}
}

#define I2S1_RX_FIFO_FULL 32
void I2S1_recbyCPU(u32 uPcmDataAddr, u32 uPcmDataSize)
{
	unsigned int temp;
	unsigned int * pPcmAddr = (unsigned int *)uPcmDataAddr;//;unsigned int *(CODEC_MEM_ST+0x1000)
	int i,j;

	Disp("[I2S1 start rec]\n");
	I2S1_LinkStart();

	//polling
	while(uPcmDataSize>I2S1_RX_FIFO_FULL)//ok
	{
		do {
			temp=Inp32 ( I2S1_FIC);			
		} while ((temp&0x7F) <I2S1_RX_FIFO_FULL); //wait until for RX fifo is full more than 8 words
			
		for(i=0;i<I2S1_RX_FIFO_FULL;i++)  *pPcmAddr++=Inp32( I2S1_RXD);
		uPcmDataSize=uPcmDataSize-I2S1_RX_FIFO_FULL;
		j++;
		if(j%400==0) Disp(".");
	}
}



void __irq ISR_I2S1DMAPlayDone(void)
{
	u32 uDmaIntStatus;
		
	INTC_Disable(NUM_PDMA0);//NUM_PDMA0
	UART_Printf("\n[OUT DMA DONE !]");
	
	// Interrupt Clear
	DMA_GetIntrSrc(&uDmaIntStatus, &oI2S1DmaTx);
	DMA_ClearIntPending(uDmaIntStatus, &oI2S1DmaTx);
	INTC_ClearVectAddr();

	g_I2S1PlayDone = 1;

}

void __irq ISR_I2S1DMARecDone(void)
{
	u32 uDmaIntStatus;

	INTC_Disable(NUM_PDMA1);

	g_I2S1RecDone = 1;
	
	// Interrupt Clear
	DMA_GetIntrSrc(&uDmaIntStatus, &oI2S1DmaRx);
	DMA_ClearIntPending(uDmaIntStatus, &oI2S1DmaRx);
	DMA_StopCh( &oI2S1DmaRx ); // Stop DMA	
	INTC_ClearVectAddr();

}


//DMA
//uPcmDataSize - word size - libra style.
void I2S1_playbyDMA(u32 uPcmDataAddr, u32 uPcmDataWSize)
{
	g_I2S1PlayDone=0;	
	
	Disp("[IRQ setting]\n");	
	INTC_SetVectAddr(NUM_PDMA0 ,ISR_I2S1DMAPlayDone);
	INTC_Enable(NUM_PDMA0);	

	Disp("[DMA setting]\n");
	DMA_SetCh(DMA_07,&oI2S1DmaTx);
	DMA_InitCh(WORD , I2S1_TX, DMA_M2P, SINGLE, &oI2S1DmaTx);

	Disp("[I2S1 start play]\n");
	I2S1_ActiveEXTDMA(1,0);//tx dma
	I2S1_LinkStart();
	DMA_StartCh((u32)uPcmDataAddr, (u32)I2S1_TXD,uPcmDataWSize, &oI2S1DmaTx);

	
	Disp("playing started\n");
	Disp("playing...\n");	
	while(!g_I2S1PlayDone) ;

	Disp("playing finished\n");
	;//wait until fifo emtpy.
	VecOutp32( I2S1_CON, 0);	
	DMA_StopCh( &oI2S1DmaTx );
}

void I2S1_recbyDMA(u32 uPcmDataAddr, u32 uPcmDataWSize)
{
	g_I2S1RecDone=0;		

	Disp("[IRQ setting]\n");	
	INTC_SetVectAddr(NUM_PDMA1 ,ISR_I2S1DMARecDone);
	INTC_Enable(NUM_PDMA1);	

	Disp("[DMA setting]\n");
//	oI2S1DmaRx.m_uChNum=10;
//	DMA_ClearIntPending(10, &oI2S1DmaRx);
	DMA_SetCh(DMA_10,&oI2S1DmaRx);
	DMA_InitCh(WORD , I2S1_RX, DMA_P2M, SINGLE, &oI2S1DmaRx);

	Disp("[I2S1 start rec]\n");
	I2S1_ActiveEXTDMA(0,1);// rx dma active
	I2S1_LinkStart();
	DMA_StartCh((u32)I2S1_RXD, (u32)uPcmDataAddr,uPcmDataWSize, &oI2S1DmaRx);

	Disp("recording started\n");
	Disp("recording...\n");	

	while(!g_I2S1RecDone) ;	
	Disp("recording finished\n");	

	;//wait until fifo emtpy.
	Outp32( I2S1_CON, 0);	
}


// I2S v5.1 SFR test
void T_I2S1_001_AH(void)
{

	TestSFRn(sRegInfo_I2S1, sizeof(sRegInfo_I2S1)/sizeof(REGINFOn));
}


///////////////////////////////////////////////////////////////////////////////////////////////
//    basic test
//

//Master TX(epll clk 384fs, 32fs)
void T_I2S1_002_AH(void)
{
	unsigned int pcmdataaddr;
	unsigned int pcmdatasizeb;
	unsigned int  i;
	unsigned short j,k;

	//parse file
	PCM_waveparser(PCM_IN_WAVEFILE_ADDRESS1,
							&j,//totch
							&i,//samplerate,
							&k,//bitperch,
							&pcmdatasizeb,
							&pcmdataaddr
							);

	//system setting
	AudioEPLL_Set(44100,384);

	Disp("[CLKSRC6 set]\n");
	SYSC_SCLK_AUDIO1_EPLL();//clk_src6[7:4]

	Disp("[I2S1 / I2S1 GPIO / Codec set]\n");	
	I2S1_Init(I2S_Master, I2STX, I2SFormat, 16, RFS_384fs, BFS_32fs, CDCLK_Out, 4-1);// PreSaler_Value-0
	GPIO_Set_I2S1();//gpc0
	WM8580_CodecInitPCMOutwithVol(SECONDARY_PORT, I2S_Slave,  I2SFormat, 0, 16,RFS_NA, 0xff);

#if I2S1_TEST==I2S1_DMA
	TZPC_NonSecureInit();	
	I2S1_playbyDMA(pcmdataaddr, pcmdatasizeb/4);
#else
	I2S1_playbyCPU(pcmdataaddr, pcmdatasizeb/4);
#endif
}


//Master TX(EXTCLK 384fs, 32fs)
void T_I2S1_003_AH(void)
{
	unsigned int pcmdataaddr;
	unsigned int pcmdatasizeb;
	unsigned int  i;
	unsigned short j,k;

	//parse file
	PCM_waveparser(PCM_IN_WAVEFILE_ADDRESS1,
							&j,//totch
							&i,//samplerate,
							&k,//bitperch,
							&pcmdatasizeb,
							&pcmdataaddr
							);

	//system setting
	Disp("[CLKSRC6 set]\n");
	SYSC_SCLK_AUDIO1_I2S1CDCLKIN();

	Disp("[I2S1 / I2S1 GPIO / Codec set]\n");	
	I2S1_Init(I2S_Master, I2STX, I2SFormat, 16, RFS_384fs, BFS_32fs, CDCLK_In, 0);// PreSaler_Value-0
	GPIO_Set_I2S1();//gpc0
	WM8580_CodecInitPCMOutwithVol(SECONDARY_PORT, I2S_Slave, I2SFormat, 0, 16, RFS_NA, 0xff);

#if I2S1_TEST==I2S1_DMA
	TZPC_NonSecureInit();	
	I2S1_playbyDMA(pcmdataaddr, pcmdatasizeb/4);
#else
	I2S1_playbyCPU(pcmdataaddr, pcmdatasizeb/4);
#endif
}

//Master RX(EXTCLK 384fs, 32fs)
void T_I2S1_004_AH(void)
{
	unsigned int pcmdataaddr;
	unsigned int pcmdatasizeb;
	unsigned int  i;
	unsigned short j,k;

	//parse file
	PCM_waveparser(PCM_IN_WAVEFILE_ADDRESS1,
							&j,//totch
							&i,//samplerate,
							&k,//bitperch,
							&pcmdatasizeb,
							&pcmdataaddr
							);

	//system setting
	Disp("[CLKSRC6 set]\n");
	SYSC_SCLK_AUDIO1_I2S1CDCLKIN();

	Disp("[I2S1 / I2S1 GPIO / Codec set]\n");	
	I2S1_Init(I2S_Master, I2SRX, I2SFormat, 16, RFS_384fs, BFS_32fs, CDCLK_In, 0);// PreSaler_Value-0
	GPIO_Set_I2S1();//gpc0
	WM8580_CodecInitPCMInwithVol(SECONDARY_PORT, I2S_Slave, I2SFormat,0, 16, RFS_NA, 0xff);

#if I2S1_TEST==I2S1_DMA
	TZPC_NonSecureInit();	
	I2S1_recbyDMA(pcmdataaddr, pcmdatasizeb/4);
#else
	I2S1_recbyCPU(pcmdataaddr, pcmdatasizeb/4);
#endif
}


// Slave TX(EXTCLK 384fs, 32fs)
void T_I2S1_005_AH(void)
{
	unsigned int pcmdataaddr;
	unsigned int pcmdatasizeb;
	unsigned int  i;
	unsigned short j,k;

	//parse file
	PCM_waveparser(PCM_IN_WAVEFILE_ADDRESS1,
							&j,//totch
							&i,//samplerate,
							&k,//bitperch,
							&pcmdatasizeb,
							&pcmdataaddr
							);

	//system setting
	Disp("[CLKSRC6 set]\n");
	SYSC_SCLK_AUDIO1_I2S1CDCLKIN();

	Disp("[I2S1 / I2S1 GPIO / Codec set]\n");	
	I2S1_Init(I2S_Slave, I2STX, I2SFormat, 16, RFS_384fs, BFS_32fs, CDCLK_In, 0);// PreSaler_Value-0
	GPIO_Set_I2S1();//gpc0
	WM8580_CodecInitPCMOutwithVol(SECONDARY_PORT, I2S_Master, I2SFormat, 0, 16, RFS_384fs, 0xff);

#if I2S1_TEST==I2S1_DMA
	TZPC_NonSecureInit();	
	I2S1_playbyDMA(pcmdataaddr, pcmdatasizeb/4);
#else
	I2S1_playbyCPU(pcmdataaddr, pcmdatasizeb/4);
#endif
}


//Slave RX(EXTCLK 384fs, 32fs),
void T_I2S1_006_AH(void)
{
	unsigned int pcmdataaddr;
	unsigned int pcmdatasizeb;
	unsigned int  i;
	unsigned short j,k;

	//parse file
	PCM_waveparser(PCM_IN_WAVEFILE_ADDRESS1,
							&j,//totch
							&i,//samplerate,
							&k,//bitperch,
							&pcmdatasizeb,
							&pcmdataaddr
							);

	//system setting
	Disp("[CLKSRC6 set]\n");
	SYSC_SCLK_AUDIO1_I2S1CDCLKIN();

	Disp("[I2S1 / I2S1 GPIO / Codec set]\n");	
	I2S1_Init(I2S_Slave, I2SRX, I2SFormat, 16, RFS_384fs, BFS_32fs, CDCLK_In, 0);// PreSaler_Value-0
	GPIO_Set_I2S1();//gpc0
	WM8580_CodecInitPCMInwithVol(SECONDARY_PORT, I2S_Master, I2SFormat, 0, 16, RFS_384fs, 0xff);

#if I2S1_TEST==I2S1_DMA
	TZPC_NonSecureInit();	
	I2S1_recbyDMA(pcmdataaddr, pcmdatasizeb/4);
#else
	I2S1_recbyCPU(pcmdataaddr, pcmdatasizeb/4);
#endif
}


///////////////////////////////////////////////////////////////////////////////////////////////
//   detail test
//



//Master TX(EXTCLK 256fs, 32fs)
void T_I2S1_0031_AH(void)
{
	unsigned int pcmdataaddr;
	unsigned int pcmdatasizeb;
	unsigned int  i;
	unsigned short j,k;

	//parse file
	PCM_waveparser(PCM_IN_WAVEFILE_ADDRESS1,
							&j,//totch
							&i,//samplerate,
							&k,//bitperch,
							&pcmdatasizeb,
							&pcmdataaddr
							);

	//system setting
	Disp("[CLKSRC6 set]\n");
	SYSC_SCLK_AUDIO1_I2S1CDCLKIN();

	Disp("[I2S1 / I2S1 GPIO / Codec set]\n");	
	I2S1_Init(I2S_Master, I2STX, I2SFormat, 16, RFS_256fs, BFS_32fs, CDCLK_In, 0);// PreSaler_Value-0
	GPIO_Set_I2S1();//gpc0
	WM8580_CodecInitPCMOutwithVol(SECONDARY_PORT, I2S_Slave, I2SFormat, 0, 16, RFS_NA, 0xff);

#if I2S1_TEST==I2S1_DMA
	TZPC_NonSecureInit();	
	I2S1_playbyDMA(pcmdataaddr, pcmdatasizeb/4);
#else
	I2S1_playbyCPU(pcmdataaddr, pcmdatasizeb/4);
#endif
}

//Master RX(EXTCLK 256fs, 32fs)
void T_I2S1_0041_AH(void)
{
	unsigned int pcmdataaddr;
	unsigned int pcmdatasizeb;
	unsigned int  i;
	unsigned short j,k;

	//parse file
	PCM_waveparser(PCM_IN_WAVEFILE_ADDRESS1,
							&j,//totch
							&i,//samplerate,
							&k,//bitperch,
							&pcmdatasizeb,
							&pcmdataaddr
							);

	//system setting
	Disp("[CLKSRC6 set]\n");
	SYSC_SCLK_AUDIO1_I2S1CDCLKIN();

	Disp("[I2S1 / I2S1 GPIO / Codec set]\n");	
	I2S1_Init(I2S_Master, I2SRX, I2SFormat, 16, RFS_256fs, BFS_32fs, CDCLK_In, 0);// PreSaler_Value-0
	GPIO_Set_I2S1();//gpc0
	WM8580_CodecInitPCMInwithVol(SECONDARY_PORT, I2S_Slave, I2SFormat,0, 16, RFS_NA, 0xff);

#if I2S1_TEST==I2S1_DMA
	TZPC_NonSecureInit();	
	I2S1_recbyDMA(pcmdataaddr, pcmdatasizeb/4);
#else
	I2S1_recbyCPU(pcmdataaddr, pcmdatasizeb/4);
#endif
}


// Slave TX(EXTCLK 256fs, 32fs)
void T_I2S1_0051_AH(void)
{
	unsigned int pcmdataaddr;
	unsigned int pcmdatasizeb;
	unsigned int  i;
	unsigned short j,k;

	//parse file
	PCM_waveparser(PCM_IN_WAVEFILE_ADDRESS1,
							&j,//totch
							&i,//samplerate,
							&k,//bitperch,
							&pcmdatasizeb,
							&pcmdataaddr
							);

	//system setting
	Disp("[CLKSRC6 set]\n");
	SYSC_SCLK_AUDIO1_I2S1CDCLKIN();

	Disp("[I2S1 / I2S1 GPIO / Codec set]\n");	
	I2S1_Init(I2S_Slave, I2STX, I2SFormat, 16, RFS_256fs, BFS_32fs, CDCLK_In, 0);// PreSaler_Value-0
	GPIO_Set_I2S1();//gpc0
	WM8580_CodecInitPCMOutwithVol(SECONDARY_PORT, I2S_Master, I2SFormat, 0, 16, RFS_256fs, 0xff);

#if I2S1_TEST==I2S1_DMA
	TZPC_NonSecureInit();	
	I2S1_playbyDMA(pcmdataaddr, pcmdatasizeb/4);
#else
	I2S1_playbyCPU(pcmdataaddr, pcmdatasizeb/4);
#endif
}


//Slave RX(EXTCLK 256fs, 32fs),
void T_I2S1_0061_AH(void)
{
	unsigned int pcmdataaddr;
	unsigned int pcmdatasizeb;
	unsigned int  i;
	unsigned short j,k;

	//parse file
	PCM_waveparser(PCM_IN_WAVEFILE_ADDRESS1,
							&j,//totch
							&i,//samplerate,
							&k,//bitperch,
							&pcmdatasizeb,
							&pcmdataaddr
							);

	//system setting
	Disp("[CLKSRC6 set]\n");
	SYSC_SCLK_AUDIO1_I2S1CDCLKIN();

	Disp("[I2S1 / I2S1 GPIO / Codec set]\n");	
	I2S1_Init(I2S_Slave, I2SRX, I2SFormat, 16, RFS_256fs, BFS_32fs, CDCLK_In, 0);// PreSaler_Value-0
	GPIO_Set_I2S1();//gpc0
	WM8580_CodecInitPCMInwithVol(SECONDARY_PORT, I2S_Master, I2SFormat, 0, 16, RFS_256fs, 0xff);

#if I2S1_TEST==I2S1_DMA
	TZPC_NonSecureInit();	
	I2S1_recbyDMA(pcmdataaddr, pcmdatasizeb/4);
#else
	I2S1_recbyCPU(pcmdataaddr, pcmdatasizeb/4);
#endif
}




void dummyi2s1fn()
{
}

////////////////////////////////////////////////////////////////////
//
// test call function
//
////////////////////////////////////////////////////////////////////

const testFuncMenu g_aI2S1TestFunc[] =
{	
	T_I2S1_001_AH,				"I2S1 SFR R/W test    ",

//basic test
	dummyi2s1fn,				"///////// Basic test  //////// ",
	T_I2S1_002_AH,				"SEC Master Tx 384fs ( epll out)    ",
	T_I2S1_003_AH,				"SEC Master Tx 44100Hz 384fs ( CDCLK in)    ",
	T_I2S1_004_AH,				"SEC Master Rx 44100Hz 384fs ( CDCLK in)    ",
	T_I2S1_005_AH,				"SEC Slave Tx 44100Hz 384fs ( external clock)    ",
	T_I2S1_006_AH,				"SEC Slave Rx 44100Hz 384fs ( external clock)   ",

//detail test
	dummyi2s1fn,				"///////// Detail test  //////// ",
	T_I2S1_0031_AH,			"SEC Master Tx 8000Hz 256fs ( CDCLK in)    ",
	T_I2S1_0041_AH,			"SEC Master Rx 8000Hz 256fs ( CDCLK in)    ",
	T_I2S1_0051_AH,			"SEC Slave Tx 8000Hz 256fs ( external clock)    ",
	T_I2S1_0061_AH,			"SEC Slave Rx 8000Hz 256fs ( external clock)   ",

	0,0
};


void I2S1_Test(void)
{
	u32 uCountFunc=0;
	s32 iSel=0;

	u32 uSizeLists=sizeof(g_aI2S1TestFunc);
	
	while(1)
	{
		UART_Printf("\n\n================== I2S1 Function Test  =====================\n\n");	
		
		for (uCountFunc=0; (u32)(g_aI2S1TestFunc[uCountFunc].desc)!=0; uCountFunc++)
			UART_Printf("%2d: %s\n", uCountFunc, g_aI2S1TestFunc[uCountFunc].desc);

		UART_Printf("\nSelect the function to test : ");
		iSel = UART_GetIntNum();
		UART_Printf("\n");
		if(iSel == -1) 
			break;

		if (iSel>=0 && iSel<(uSizeLists/8-1))
			(g_aI2S1TestFunc[iSel].func) ();
	}
}	

