
#ifndef __I2S_H__
#define __I2S_H__

#include "system.h"
#include "dma.h"
#include "def.h"
#include "gpio.h"

typedef enum
{
	I2S_0, I2S_1, I2S_2
} I2S_CH;

typedef enum
{
	TX_MODE, RX_MODE, TRX_MODE
} I2S_MODE;

typedef enum
{
	INTERNAL_MASTER, EXTERNAL_MASTER, INTERNAL_SLAVE, EXTERNAL_SLAVE
} I2S_SRCCLK;

typedef enum
{
	I2S_FMT,
	MSB_FMT,
	LSB_FMT
} I2S_FORMAT;

typedef struct
{
	u32 m_uBaseAddr;
	u32 m_uBitsPerSample;
	u32 m_uMode;
	I2S_FORMAT m_eDataFmt;
	DREQ_SRC m_eTxDmaSrc;
	DREQ_SRC m_eRxDmaSrc;
	DMAC m_oDmac;
} I2S;

typedef enum
{
	SPEAKER_MODE, 
	LINE_IN_MODE,
	FULL_DUPLEX
} AUDIO_MODE;

typedef enum
{
	AUDIO_UDA1341,
	AUDIO_UDA1342,
	AUDIO_WM8580
} AUDIO_CODEC;

#define	IISBASE		0xeee30000
#define	IIS_CON		(IISBASE+0)
#define	IIS_MOD		(IISBASE+0x4)
#define	IIS_FIC		(IISBASE+0x8)
#define	IIS_PSR		(IISBASE+0xC)
#define	IIS_FICS	(IISBASE+0x18)

#define	IIS_TXD		(IISBASE+0x10)
#define	IIS_RXD		(IISBASE+0x14)
#define	IIS_TXDS	(IISBASE+0x1C)

#define	IIS_AHB		(IISBASE+0x20)
#define	IIS_STR0	(IISBASE+0x24)
#define	IIS_SIZE	(IISBASE+0x28)
#define	IIS_STR1	(IISBASE+0x40)
#define	IIS_TRNCNT	(IISBASE+0x2C)

//CLKCON
#define 	CLKCON_BASE	 0xeee10000
#define	CLKCON_SRC		(CLKCON_BASE)
#define	CLKCON_DIV		(CLKCON_BASE+0x4)
#define	CLKCON_GATE	(CLKCON_BASE+0x8)

/******************************************************************************
*					  I2S I/O Functions	Definition
 ******************************************************************************/
void I2S_InitIp(I2S_MODE eMode, I2S_SRCCLK eSrcClk,u32 uChannelType, u32 uSampleRate, u32 uBitsPerSample, AUDIO_MODE eAudioMode, I2S_FORMAT eSdf,u32 uSrcClk , AUDIO_CODEC eCodec,I2S *sCh);
void I2S_PlayByCpu(u32 uPcmDataAddr, u32 uPcmDataSize, u32 uChannelType, I2S *sCh);
void I2S_PlayByDma(u32 uPcmStartAddr, u32 uPcmDataSize, u32 uBitsPerSample, I2S *sCh);
void I2S_InitWm8580(I2S_SRCCLK eSrcClk, AUDIO_MODE eAudioMode, u32 uChannelType, u32 uSampleRate, u32 uBitsPerSample, I2S_FORMAT eSdf, u32 uSrcClk );
void I2S_SendWm8580Data(u8 reg_addr, u16 data);
void I2S_IIC_SendData( unsigned char SlaveAddr, char reg_addr, unsigned short data);
void GPIO_SetFunctionForI2s(void);
void I2S_PlayByDmaForInterrupt(u32 uPcmStartAddr, u32 uPcmDataSize, u32 uBitsPerSample, I2S *sCh);

#endif //__I2S_H__

