#ifndef __HDMI_AUDIO_H__
#define __HDMI_AUDIO__

#include "dma.h"
#include "def.h"

typedef enum
{
	DVI_MODE, HDMI_MODE
} HDMI_RUN_MODE;

typedef enum
{
	NOT_AUTHENTICATED, BKSV_READ_DONE, AKSV_WRITE_DONE, SECOND_AUTHENTICATION_RDY, AUTHENTICATION_DONE
} HDCP_STATE;

// Below CSC_TYPE is temporary. CSC_TYPE enum. may be included in SetSD480pVars_60Hz etc.
// LR : Limited Range (16~235)
// FR : Full Range (0~255)
typedef enum
{
	YUV601_TO_RGB_LR, YUV601_TO_RGB_FR, YUV709_TO_RGB_LR, YUV709_TO_RGB_FR, HDMI_BYPASS
} CSC_TYPE;

typedef enum
{
	IntrHDCP_flag=0,
	IntrSPDIF_flag=1,
	IntrHPDunpluag_flag=2,
	IntrHPDpluag_flag=3,
	IntrCEC_flag=4,
	IntrI2S_flag=5,
	IntrAll_flag=6,
	IntrPolarity=7
} hdmi_audio_int_flag;

typedef enum
{
	I2c_init_int_flag=0,
	Watchdog_int_flag=1,
	An_write_int_flag=2,
	Update_ri_int_flag=4,
	Aud_fifo_ovf_flag=6,
	Authen_ack_flag=7		
} hdmi_audio_status_flag;

typedef enum
{
	Bit_per_channel_mismatch_flag=0,
	Wrong_register_setting_flag=1
} hdmi_audio_i2s_irq_status_flag;

typedef enum
{
	wrong_signal_ir_flag=0,
	ch_status_recovered_ir_flag=1,
	wrong_preamble_ir_flag=2,
	stream_header_not_detected_ir_flag=3,
	stream_header_detected_ir_flag=4,		
	buf_overflow_ir_flag=7		
} hdmi_audio_spdif_irq_status_flag;

typedef enum
{
	PCLK = 0,
	SPDIF_CLK = 1
} hdmi_audio_clk_sel;

void HDMI_AUDIO_InitBaseOfIp(HDMI_RUN_MODE eRunMode);
void HDMI_AUDIO_SetCsc(CSC_TYPE eCscType);
void HDMI_AUDIO_Spdif_InitAudioPath(CODEC_TYPE eAudioCodec, u32 uSampleRate, u32 uBits, u32 uFrameSizeCode);
void HDMI_AUDIO_EnableBlueScreen(u8 ucCh0Color, u8 ucCh1Color, u8 ucCh2Color);
void HDMI_AUDIO_SetOnOff(u32 uOnOff);
void HDMI_AUDIO_SendAviInfoFrame(void);
void HDMI_AUDIO_SetTgOn(IMG_RESOLUTION eImgSize, SCAN_MODE eScanMode, u32 uFreq);
void HDMI_AUDIO_SetTgOff(void);
void HDMI_AUDIO_I2s_InitAudioPath(CODEC_TYPE eAudioCodec, u32 uChannelType, u32 uSampleRate, u32 uBitsPerSample, u32 uFrameSizeCode);
u32 HDMI_AUDIO_ReadIntFlag(void);
u32 HDMI_AUDIO_ReadStatusFlag(void);
void HDMI_AUDIO_DisableAllIntCon(void);
void HDMI_AUDIO_DisableIntCon(hdmi_audio_int_flag eHdmiAudioIntFlag);
void HDMI_AUDIO_EnableIntCon(hdmi_audio_int_flag eHdmiAudioIntFlag);
u32 HDMI_AUDIO_ReadI2sIrqStatus(void);
void HDMI_AUDIO_ClearI2sIrqStatusFlag(hdmi_audio_i2s_irq_status_flag eHdmiAudioI2sIrqStatusFlag);
void HDMI_AUDIO_SelectClkSourc(hdmi_audio_clk_sel eClkSel);
u32 HDMI_AUDIO_ReadSpdifinIrqStatus(void);
void HDMI_AUDIO_ClearSpdifIrqStatusFlag(hdmi_audio_spdif_irq_status_flag eHdmiAudioSpdifIrqStatusFlag);
void HDMI_AUDIO_SetAudioClockRecovery(u32 freq);
void HDMI_AUDIO_DisableSpdifIrqMask(hdmi_audio_spdif_irq_status_flag eHdmiAudioSpdifIrqMask);
void HDMI_AUDIO_Spdif_InitAudioPathForInterrupt(CODEC_TYPE eAudioCodec, u32 uSampleRate, u32 uBits, u32 uFrameSizeCode);

#endif // __HDMI_AUDIO_H__

