#include <stdlib.h>
#include "dsim_test.h"
#include "max8698.h"			//to control PMIC for MIPI 1.8V

//////////
// Function Name : DSIMTest_AutoTest
// Function Description : This function display color bar for DSI Master test
// Input : NONE
// Output : u8 - Pass/Fail
// Version : v0.0
u8 DSIMTest_AutoTest(void)
{
	DSIM_Infor* pDSIInfor;
	DDI_Handler* pDDI_Handler;
	DCS_Infor* pDCSInfor; 
	
	u8 bPass = 0;
	u8 uSel1 = 0;

	//MIPI 1.8V Out
	MAX8698_SetVoltageLDO4(LDO45679_VOL_18);			

	SYSC_SetDispPath(eDISP_BYPASS);
	IEIP_Select(DISP_BYPASS);

	pDSIInfor = DSIM_Create(DSIM_DefaultLinkAndPhy(), false);
	pDDI_Handler  = DDI_Create(MIPI_Dummy, Link_DSIM, (u32)pDSIInfor,(u32)pDCSInfor, 0);
	pDCSInfor = DCS_Create(Link_DSIM, (u32)pDSIInfor, pDDI_Handler->m_pDDISpec->m_uParaMeter[DSI_VirtualChID]);
	
	LCDC_InitBase();
	DSIMTest_InitLcdDrawing(pDDI_Handler->m_pDDISpec, WIN0);
	
	do
	{
		//Test Initialization sequence
		PRESS_ANY("Press Any key to Init DSI Master\n");
		DSIM_InitLink(pDSIInfor);

		PRESS_ANY("Press Any Key to Transmit Init DDI Command on LPDT by CPU\n");

		DSIM_SetDisplayMode(pDSIInfor, pDDI_Handler->m_pDDISpec, NULL);
		LCDC_Start();			
		DSIM_SetHSEn(pDSIInfor);
		DSIM_SetDataTransferMode(pDSIInfor, Transfer_ByCPU, false);
		pDDI_Handler->m_fnInit(0,0);
		DSIM_EnBackLite(1);
		PRESS_ANY("Press Any Key to End Test\n");		
		bPass = 1;
	}while(0);
	if (bPass)
		Disp("Test Sucess\n");
	else
		Disp("Test Fail\n");
	pDDI_Handler->m_fnDown(0,0);
	LCDC_Stop();	
	DDI_Destory(pDDI_Handler, 0,0,0);
	DCS_Destory(pDCSInfor);
	DSIM_Destory(pDSIInfor);

	return bPass;
}

