#include "dsim_test.h"
#include "sysc.h"

#include "timer.h"	

//////////
// Function Name : DSIMTest_PartialUpdated
// Function Description : This function test partial update mode.
// Input : NONE
// Output : NONE
void DSIMTest_PartialUpdated(void)
{
	if ( g_eDSIMMainDisp & MIPI_Command )
	{
		DDI_Spec* pMainDisp = DDI_GetSpec(g_eDSIMMainDisp);
		DSIM_Infor* pDSIInfor = DSIM_Create(DSIM_DefaultLinkAndPhy(), false);
		DCS_Infor* pDCSInfor = DCS_Create(Link_DSIM, (u32)pDSIInfor, pMainDisp->m_uParaMeter[DSI_VirtualChID]);
		DDI_Handler* pDDI_Handler = DDI_Create(g_eDSIMMainDisp, Link_DSIM, (u32)pDSIInfor,(u32)pDCSInfor, 0);
		u32 uCnt0;
		u32 uSel1;
		u8 ucDSIMReadBuffer[512];		
		do
		{
			DSIM_InitLink(pDSIInfor);
			DSIM_SetHSEn(pDSIInfor);
			DSIM_SetDataTransferMode(pDSIInfor, Transfer_ByCPU, false);
			pDDI_Handler->m_fnInit(0,0);
			{
				PRESS_ANY("Press Any Key to Command Transfer by FIMD\n");
				{				
					u8 ucData[512];				
					LCDC_InitBase();				
					LCDC_InitWin(	pMainDisp->m_02eBgBpp, pMainDisp->m_00uHoriSize, pMainDisp->m_01uVertiSize, 0, 0, pMainDisp->m_00uHoriSize, pMainDisp->m_01uVertiSize, 0, 0,g_uDSIMFbAddr[0], WIN0, false);
					LCDC_InitWin(	pMainDisp->m_02eBgBpp, pMainDisp->m_00uHoriSize, pMainDisp->m_01uVertiSize, 0, 0, pMainDisp->m_00uHoriSize, pMainDisp->m_01uVertiSize, 0, 0,g_uDSIMFbAddr[1], WIN1, false);
					LCDC_Start();
					for (uCnt0 = 0; uCnt0 < 2; uCnt0++)
					{
						Disp("Select Image source WIN %d\n",uCnt0);
						Disp("0 : Draw[D]	1 : Download\n");
						uSel1 = UART_GetIntNum();
						if (uSel1 == 1)
						{
							u32 uFrmAddr;
							if ( uCnt0 == 0 )
								uFrmAddr = g_uDSIMFbAddr[0];
							else if ( uCnt0 == 1 )
								uFrmAddr = g_uDSIMFbAddr[1];
							Disp("Press Any key after Download BMP from PC to DUT 0x%x\n",g_uDownLoadBMPAddr);
							UART_Getc();
							if ( pMainDisp->m_02eBgBpp == RGB888 )
								ConvertBmpToRgb24bpp(g_uDownLoadBMPAddr, uFrmAddr, pMainDisp->m_00uHoriSize, pMainDisp->m_01uVertiSize);
							else if ( pMainDisp->m_02eBgBpp == RGB565 )
								ConvertBmpToRgb16bpp(g_uDownLoadBMPAddr, uFrmAddr, pMainDisp->m_00uHoriSize, pMainDisp->m_01uVertiSize);
						}
						else
						{
							if ( uCnt0 == 0 )
							{
								GLIB_InitInstance(g_uDSIMFbAddr[0], pMainDisp->m_00uHoriSize, pMainDisp->m_01uVertiSize, pMainDisp->m_02eBgBpp);	 	
								GLIB_DrawPattern(pDDI_Handler->m_pDDISpec->m_00uHoriSize, pDDI_Handler->m_pDDISpec->m_01uVertiSize);
							}
							else if (uCnt0 == 1)
							{
								GLIB_InitInstance(g_uDSIMFbAddr[1], pMainDisp->m_00uHoriSize, pMainDisp->m_01uVertiSize, pMainDisp->m_02eBgBpp);	 	
								GLIB_DrawPattern2(pDDI_Handler->m_pDDISpec->m_00uHoriSize, pDDI_Handler->m_pDDISpec->m_01uVertiSize);
							}
						}					
					}				
					DSIM_SetDataTransferMode(pDSIInfor, Transfer_ByLCDC, true);
					DCS_SetTearOn(pDCSInfor, 0);
					DSIM_ForceRead(pDSIInfor, (u32) ucDSIMReadBuffer, sizeof(ucDSIMReadBuffer));
					uCnt0 = 0;
					LCDC_Trigger();
					StartTimer(2);
					while(true)
					{
						if (LCDC_IsFrameDone() == true && DSIM_IsState(FrameDone))
						{
							Disp("%d msec\n",(u32)StopTimer(2));
							Disp("%d\n",uCnt0++);
							if ((uCnt0 % 2))
							{
								LCDC_SetWinOnOff(1, WIN0);
								LCDC_SetWinOnOff(0, WIN1);
							}
							else
							{
								LCDC_SetWinOnOff(1, WIN1);
								LCDC_SetWinOnOff(0, WIN0);
							}
							
							LCDC_Trigger();
							StartTimer(2);
							if ( uCnt0 == 2 )
							{
								StopTimer(2);
								break;
							}
						}							
					}
				}			
				// LCD Partial Display
				{
					u32 uSmallH = pMainDisp->m_00uHoriSize/2;
					u32 uSmallV = pMainDisp->m_01uVertiSize/2;
					u32 uFrameSize = uSmallH*uSmallV*3;
					u32 uSmallFramAddress = malloc(uSmallH*uSmallV*4);
					u32 uFramAddr = malloc(uFrameSize);				

					//GLIB_InitInstance(g_uDSIMFbAddr[0], uSmallH, uSmallV, pMainDisp->m_02eBgBpp);	 	
					//GLIB_DrawPattern(uSmallH, uSmallV);
					#if 0
					// Partial Update by CPU
					PRESS_ANY("Press Any Key to Partial Updata by CPU\n");

					DCS_SetColumnAddress(pDCSInfor, pMainDisp->m_00uHoriSize/3, pMainDisp->m_00uHoriSize*2/3-1);
					DCS_SetPageAddress(pDCSInfor, pMainDisp->m_01uVertiSize*1/4, pMainDisp->m_01uVertiSize*3/4-1);
					
					GLIB_InitInstance(uSmallFramAddress, uSmallH, uSmallV, pMainDisp->m_02eBgBpp);	 	
					GLIB_DrawPattern2(uSmallH, uSmallV);
					ConvertRGB24toPackedRGB24(uSmallFramAddress, uFramAddr, uSmallH, uSmallV);
					DCS_WriteMemoryStart(pDCSInfor, (u8 *) uSmallFramAddress, 120);				
					for ( uCnt0 = 0; uCnt0 < uFrameSize-120; uCnt0 = uCnt0+120)
					{
						uFramAddr += 120;
						DCS_WriteMemoryContinue(pDCSInfor, (u8 *) uFramAddr, 120);					
					}
					#endif
					PRESS_ANY("Press Any Key to Partial Updata by FIMD\n");
					// Partial Updatae by FIMD
					LCDC_SetWinOnOff(0, WIN1);
					LCDC_SetWinOnOff(1, WIN0);
					LCDC_DisplayPartialArea(0, 0,0, 0, uSmallH, uSmallV, g_uDSIMFbAddr[0], WIN0, (u32)pDCSInfor);
					//LCDC_DisplayPartialArea(pMainDisp->m_00uHoriSize/3, pMainDisp->m_01uVertiSize*1/4, pMainDisp->m_00uHoriSize/3, pMainDisp->m_01uVertiSize*1/4, uSmallH, uSmallV, g_uDSIMFbAddr, WIN0, (u32)pDCSInfor);
					
					LCDC_Trigger();

					PRESS_ANY("Press Any Key to Partial Updata by FIMD\n");
					LCDC_Trigger();
					
					PRESS_ANY("Press Any Key to Update Image Full Screen\n");
					DCS_SetPageAddress(pDCSInfor, 0, pMainDisp->m_01uVertiSize-1);
					DCS_SetColumnAddress(pDCSInfor, 0, pMainDisp->m_00uHoriSize-1);				
					LCDC_SetWinOnOff(0, WIN0);
					LCDC_SetWinOnOff(1, WIN1);
					LCDC_Trigger();
					
					free(uSmallFramAddress);
					free(uFramAddr);
				}

				if (0)
				{
					PRESS_ANY("Press Any Key to Enter Patial Mode\n");
					DCS_SetPartialArea(pDCSInfor, pMainDisp->m_01uVertiSize/4,0x0);
					DCS_EnterPartialMode(pDCSInfor);
					DCS_SetDisplayOn(pDCSInfor);
					LCDC_SetWinOnOff(1, WIN0);
					LCDC_SetWinOnOff(0, WIN1);
					LCDC_Trigger();
					PRESS_ANY("Press Any Key to Enter Normal Mode\n");
					DCS_EnterNormalMode(pDCSInfor);
					LCDC_SetWinOnOff(0, WIN0);
					LCDC_SetWinOnOff(1, WIN1);
					LCDC_Trigger();
				}
				
			PRESS_ANY("Press Any Key to End Test\n");
			TEST_FN(DSIM_SetStopState(pDSIInfor));	
		}	
				PRESS_ANY("Press Any Key to End Test\n");		
				TEST_FN(DSIM_SetStopState(pDSIInfor));	
			}	
		}while(0);	
		pDDI_Handler->m_fnDown(0,0);	
		DDI_Destory(pDDI_Handler, 0,0,0);
		DCS_Destory(pDCSInfor);
		DSIM_Destory(pDSIInfor);
	}
	else
	{
		Disp("This Lcd moduel is not supported DSI Command Mode\n");		
	}
}
