#include "dsim_test.h"
#include "sysc.h"

#include "timer.h"	

static u32  g_TransferSize  = 120;
static u8  g_ucDCSHandler  = false;		// 1 : LCDC 	0 : DSIM
static u8 g_ucTransfermode = false;

//////////
// Function Name : DSIMTest_CommandModeByCPU
// Function Description : This function test Command comde Display.
// Input : NONE
// Output : NONE
void DSIMTest_CommandModeByCPU(void)
{
	DDI_Spec* pMainDisp = DDI_GetSpec(g_eDSIMMainDisp);
	DSIM_Infor* pDSIInfor = DSIM_Create(DSIM_DefaultLinkAndPhy(), false);
	DCS_Infor* pDCSInfor = DCS_Create(Link_DSIM, (u32)pDSIInfor, pMainDisp->m_uParaMeter[DSI_VirtualChID]);
	DDI_Handler* pDDI_Handler  = DDI_Create(g_eDSIMMainDisp, Link_DSIM, (u32)pDSIInfor,(u32)pDCSInfor, 0);
	
	u32 uCnt0, uCnt1;
	u32 uSel0,uSel1;
	u8 ucDSIMReadBuffer[512];	
	
	if ( g_ucDCSHandler )
		SYSC_SetDispPath(eDISP_BYPASS);
	do
	{
		PRESS_ANY("Press Any Key to DSI Master\n");
		Disp("Select Enable to check Rx Ack\n");
		Disp("0 : Diable[D]	1 : Enable\n");
		uSel1 = UART_GetIntNum();
		if (uSel1 == 1)
			DCS_EnCheckRxAck(pDCSInfor, true);
		else
			DCS_EnCheckRxAck(pDCSInfor, false);
		
		DSIM_InitLink(pDSIInfor);
		DSIM_SetHSEn(pDSIInfor);
		DSIM_SetDataTransferMode(pDSIInfor, Transfer_ByCPU, g_ucTransfermode);
		pDDI_Handler->m_fnInit(0,0);
		{
			LCDC_InitBase();
			DSIMTest_InitLcdDrawing(pMainDisp, WIN0);
			{
				u32 uFramAddr = g_uDSIMFbAddr[0];
				u32 uFrameSize;
				PRESS_ANY("Press Any Key to Command Transfer by CPU\n");
				DSIM_SetDataTransferMode(pDSIInfor, Transfer_ByCPU, g_ucTransfermode);
				DCS_SetTearOn(pDCSInfor, 0);			//tearing effect signal on				
				
				if ( pMainDisp->m_02eBgBpp == RGB16 ) 
					uFrameSize = (pMainDisp->m_00uHoriSize) * (pMainDisp->m_01uVertiSize) * 2;
				else 
				{
					uFrameSize = (pMainDisp->m_00uHoriSize) * (pMainDisp->m_01uVertiSize) * 3;
					AlignPackedRGB24(uFramAddr, pMainDisp->m_00uHoriSize, pMainDisp->m_01uVertiSize);
				}				
				Disp("Write count is %d\n", uCnt1++);
				StartTimer(2);
				DCS_WriteMemoryStart(pDCSInfor, (u8 *) uFramAddr, g_TransferSize);
				for ( uCnt0 = 0; uCnt0 < uFrameSize-g_TransferSize; uCnt0 = uCnt0+g_TransferSize)
				{
					uFramAddr += g_TransferSize;
					DCS_WriteMemoryContinue(pDCSInfor, (u8 *) uFramAddr, g_TransferSize);
					Disp("Write count is 0x%x\n", uCnt1++);					
					if (uSel1 == 1)			// BTA for TE Signal
					{
						u8 ucReadBuffer[1024];
						DSIM_ForceRead(pDSIInfor, (u32)ucReadBuffer, 1024);
					}							
				}
				Disp("%d msec\n",(u32)StopTimer(2));
			}
			#if 0			// Read Frame Data 
			{
				
				u32 uCnt2;			
				s32 uTemp;
				u8 usReadFrame[1024];
				u32 uReadSize;
				uFramAddr = pDSIInfor->m_uMainDispFrameAddr;
				uTemp = (s32) (uFrameSize);
				Delay(100);
				DSIM_ForceRead(pDSIInfor,0,0);
				DCS_ReadMemoryContinue(pDCSInfor, usReadFrame, 1024, &uReadSize);
				DCS_ReadMemoryContinue(pDCSInfor, usReadFrame, 1024, &uReadSize);
				DCS_ReadMemoryContinue(pDCSInfor, usReadFrame, 1024, &uReadSize);
				if( uReadSize <= 1024 )
				{
					
					Disp("Read Data size of %d\n", uReadSize);
					uTemp = uTemp - uReadSize;
					for (uCnt2 = 0; uCnt2 < uReadSize; uCnt2++)
					{
						#if 0
						Disp("Read Data : 0x%x \n", usReadFrame[uCnt2]);
						Disp("Original Frame Data : 0x%x\n", *(u8 *)(uFramAddr++));
						#else
						if ( usReadFrame[uCnt2] != *(u8 *)(uFramAddr++))
						{
							Disp("Data is not matched\n");
							Disp("Read Data : 0x%x \n", usReadFrame[uCnt2]);	
							Disp("Original Frame Data : 0x%x\n", *(u8 *)(uFramAddr));
						}
						#endif
					}
				}
				else
				{
					Disp("Read Data size is larger than Read Frame Buffer size!!\n");
				}
				
				do
				{
					Delay(100);
					DCS_ReadMemoryContinue(pDCSInfor, usReadFrame, 1024, &uReadSize);
					if( uReadSize <= 1024 )
					{
						
						Disp("Read Data size of %d\n", uReadSize);
						for (uCnt2 = 0; uCnt2 < uReadSize; uCnt2++)
						{
							#if 0
							Disp("Read Data : 0x%x \n", usReadFrame[uCnt2]);
							Disp("Original Frame Data : 0x%x\n", *(u8 *)(uFramAddr++));
							#else
							if ( usReadFrame[uCnt2] != *(u8 *)(uFramAddr++))
							{
								Disp("Data is not matched\n");
								Disp("Read Data : 0x%x \n", usReadFrame[uCnt2]);	
								Disp("Original Frame Data : 0x%x\n", *(u8 *)(uFramAddr));
							}
							#endif					
						}
					}
					else
					{
						Disp("Read Data size is larger than Read Frame Buffer size!!\n");
					}
					uTemp = uTemp - uReadSize;
					if ( uTemp == 0 || uTemp < 0 )
						break;
				}while(1);
			}
			#endif			//Command by LCDC
			PRESS_ANY("Press Any Key to End Test\n");		
			TEST_FN(DSIM_SetStopState(pDSIInfor));	
		}	
	}while(0);
	
	pDDI_Handler->m_fnDown(0,0);
	
	DDI_Destory(pDDI_Handler, 0,0,0);
	DCS_Destory(pDCSInfor);
	DSIM_Destory(pDSIInfor);
}
