#include "dsim_test.h"
#include "sysc.h"

#include "timer.h"	

#define REPEAT_NO		11
#define RXTE_TEST		0
#define AUTOCMDTEST	0

//////////
// Function Name : DSIMTest_CommandModeByLCDC
// Function Description : This function test Command comde Display.
// Input : NONE
// Output : NONE
void DSIMTest_CommandModeByLCDC(void)
{
	static u32 uCnt0 = 0;
	u32 uCnt1,uSel1;
	u8 ucDSIMReadBuffer[512];
		
	DDI_Spec* pMainDisp = DDI_GetSpec(g_eDSIMMainDisp);
	DSIM_Infor* pDSIInfor = DSIM_Create(DSIM_DefaultLinkAndPhy(), RXTE_TEST);
	#if 1				// Through CPU FIFO to Access DSIM
	DCS_Infor* pDCSInfor = DCS_Create(Link_DSIM, (u32)pDSIInfor, pMainDisp->m_uParaMeter[DSI_VirtualChID]);
	DDI_Handler* pDDI_Handler = DDI_Create(g_eDSIMMainDisp, Link_DSIM, (u32)pDSIInfor,(u32)pDCSInfor, 0);
	#else				// Through FIMD I80 FIFO to Access DSIM
	DCS_Infor* pDCSInfor = DCS_Create(Link_LCDC_I80, (u32)MAIN, pMainDisp->m_uParaMeter[DSI_VirtualChID]);	
	DDI_Handler* pDDI_Handler = DDI_Create(S6E63J0, Link_LCDC_I80, (u32)MAIN,(u32)pDCSInfor, 0);
	#endif
	#if (AUTOCMDTEST)
	u32 uCmdVal[2];
	#endif
	#if(RXTE_TEST)	//for RXTE Interrupt Test
	DSIM_SetIsrCallBack(pDSIInfor, RxTE, IsrDSIM_General, (u32)RxTE);
	#endif
	PRESS_ANY("Press Any Key to DSI Master\n");
	Disp("Select Enable to check Rx Ack\n");
	Disp("0 : Diable[D]	1 : Enable\n");
	uSel1 = UART_GetIntNum();		
	if (uSel1 == 1)
		DCS_EnCheckRxAck(pDCSInfor, true);
	else
		DCS_EnCheckRxAck(pDCSInfor, false);
	DSIM_InitLink(pDSIInfor);
	DSIM_SetHSEn(pDSIInfor);
	DSIM_SetDataTransferMode(pDSIInfor, Transfer_ByCPU, false);
	pDDI_Handler->m_fnInit(0,0);
	{
		PRESS_ANY("Press Any Key to Command Transfer by FIMD\n");			
		{				
			u8 ucData[512];				
			LCDC_InitBase();
			#if (AUTOCMDTEST)
			LCDC_SetAutoCmdRate(PER_TWO_FRM, MAIN);			
			#endif
			DSIM_SetDisplayMode(pDSIInfor, pMainDisp, NULL);
			LCDC_Start();
			for (uCnt1 = 0; uCnt1 < 2; uCnt1++)
			{
				#if 0
				Disp("Select Image source WIN %d\n",uCnt1);
				Disp("0 : Draw[D]	1 : Download\n");
				uSel1 = UART_GetIntNum();
				if (uSel1 == 1)
				{
					u32 uFrmAddr;
					if ( uCnt1 == 0 )
						uFrmAddr = g_uDSIMFbAddr;
					else if ( uCnt1 == 1 )
						uFrmAddr = g_uDSIMFbAddr2;						
					Disp("Press Any key after Download BMP from PC to DUT 0x%x\n",g_uDownLoadBMPAddr);
					UART_Getc();
					if ( pMainDisp->m_02eBgBpp == RGB888 )
						ConvertBmpToRgb24bpp(g_uDownLoadBMPAddr, uFrmAddr, pMainDisp->m_00uHoriSize, pMainDisp->m_01uVertiSize);
					else if ( pMainDisp->m_02eBgBpp == RGB565 )
						ConvertBmpToRgb16bpp(g_uDownLoadBMPAddr, uFrmAddr, pMainDisp->m_00uHoriSize, pMainDisp->m_01uVertiSize);
				}
				else
				{
					if ( uCnt1 == 0 )
					{
						GLIB_InitInstance(g_uDSIMFbAddr, pMainDisp->m_00uHoriSize, pMainDisp->m_01uVertiSize, pMainDisp->m_02eBgBpp);	 	
						GLIB_DrawPattern(pDDI_Handler->m_pDDISpec->m_00uHoriSize, pDDI_Handler->m_pDDISpec->m_01uVertiSize);						
					}
					else if (uCnt1 == 1)
					{
						GLIB_InitInstance(g_uDSIMFbAddr2, pMainDisp->m_00uHoriSize, pMainDisp->m_01uVertiSize, pMainDisp->m_02eBgBpp);	 	
						GLIB_DrawPattern2(pDDI_Handler->m_pDDISpec->m_00uHoriSize, pDDI_Handler->m_pDDISpec->m_01uVertiSize);
						
					}
				}
				#endif
				DSIMTest_InitLcdDrawing(pMainDisp, uCnt1);
			}				
			DSIM_SetDataTransferMode(pDSIInfor, Transfer_ByLCDC, true);
			#if(RXTE_TEST)
			DCS_SetTearOn(pDCSInfor, 0);
			DSIM_ForceRead(pDSIInfor, (u32) ucDSIMReadBuffer, sizeof(ucDSIMReadBuffer));
			#endif
			LCDC_SetWinOnOff(0, (LCD_WINDOW)(uCnt0%2));
			LCDC_SetWinOnOff(1, (LCD_WINDOW)((uCnt0+1)%2));
			LCDC_Trigger();
			StartTimer(2);
			while(true)
			{
				if (LCDC_IsFrameDone() == true && DSIM_IsState(FrameDone))
				{
					Disp("%d msec\n",(u32)StopTimer(2));
					Disp("%d\n",++uCnt0);
					#if (RXTE_TEST)
					while(1)
					{
						if ( DSIM_ForceRead(pDSIInfor, (u32) ucDSIMReadBuffer, sizeof(ucDSIMReadBuffer)) == RxTE )
						{
							//Delay(100);
							break;
						}
					}
					#endif
					LCDC_SetWinOnOff(0, (LCD_WINDOW)(uCnt0%2));
					LCDC_SetWinOnOff(1, (LCD_WINDOW)((uCnt0+1)%2));
					
					#if (AUTOCMDTEST)
					if(uCnt0%4 == 1)
						uCmdVal[0] = (0x00 << 16) | (0x23 << 8) | (pMainDisp->m_uParaMeter[DSI_VirtualChID] << 6) |(DCSWrNoPara << 0);
					else if (uCnt0%4 == 3) 
						uCmdVal[0] = (0x00 << 16) | (0x22<< 8) | (pMainDisp->m_uParaMeter[DSI_VirtualChID] << 6) |(DCSWrNoPara << 0);
					LCDC_PutCmdToLdi(uCmdVal, 1, MAIN, LCD_AUTO_CMD);
					#endif
					
					#if 1
					PRESS_ANY("Press Any key to Update Image\n");
					#endif
					LCDC_Trigger();
					StartTimer(2);
					if ( (uCnt0 % REPEAT_NO == 0) && (uCnt0 != 0))
					{
						while(!(LCDC_IsFrameDone() == true && DSIM_IsState(FrameDone)));
						Disp("%d msec\n",(u32)StopTimer(2));
						DCS_SetTearOff(pDCSInfor);
						break;						
					}
				}							
			}
		}
	}
	PRESS_ANY("Press Any key to End the test\n");
	pDDI_Handler->m_fnDown(0,0);	
	DDI_Destory(pDDI_Handler, 0,0,0);
	DCS_Destory(pDCSInfor);
	DSIM_Destory(pDSIInfor);
}
