
#include <stdlib.h>
#include "dsim_test.h"

//////////
// Function Name : DSIMTest_InterruptTest
// Function Description : This function test to Interrupt Function of DSIM.
// Input : NONE
// Output : NONE
// Version : v0.0
void DSIMTest_InterruptTest(void)
{
	DDI_Spec* pMainDisp = DDI_GetSpec(g_eDSIMMainDisp);
	DSIM_Infor* pDSIInfor = DSIM_Create(DSIM_DefaultLinkAndPhy(), true);
	DCS_Infor* pDCSInfor = DCS_Create(Link_DSIM, (u32)pDSIInfor, pMainDisp->m_uParaMeter[DSI_VirtualChID]);
	DDI_Handler* pDDI_Handler  = DDI_Create(g_eDSIMMainDisp, Link_DSIM, (u32)pDSIInfor,(u32)pDCSInfor, 0);
	u8 bPass = 0;

	volatile double dTimeValue = 0;
	LCDC_InitBase();
	DSIMTest_InitLcdDrawing(pMainDisp, WIN0);
	
	//DSIM_SetIsrCallBack(pDSIInfor, SwRstRelease, IsrDSIM_General, (u32)SwRstRelease);
	#if 0
	// for Test
	//DSIM_SWReset(DSIM_SwRst);

	//DSIM_SetIsrCallBack(pDSIInfor, PllStable, IsrDSIM_General, (u32)PllStable);
	
	DSIM_SetIsrCallBack(pDSIInfor, SFRFifoEmpty, IsrDSIM_General, (u32)SFRFifoEmpty);
	//DSIM_SetIsrCallBack(pDSIInfor, BusTunrOver, IsrDSIM_General, (u32)BusTunrOver);

	DSIM_SetIsrCallBack(pDSIInfor, BusTunrOver, DSIMISR_TimerTest, (u32)(&dTimeValue));
	
	DSIM_SetIsrCallBack(pDSIInfor, FrameDone, IsrDSIM_General, (u32)FrameDone);
	DSIM_SetIsrCallBack(pDSIInfor, LPDRTimeOut, IsrDSIM_General, (u32)LPDRTimeOut);
	//DSIM_SetIsrCallBack(pDSIInfor, BTAAckTimeOut, IsrDSIM_General, (u32)BTAAckTimeOut);
	
	DSIM_SetIsrCallBack(pDSIInfor, BTAAckTimeOut, DSIMISR_TimerTest, (u32)(&dTimeValue));
	
	DSIM_SetIsrCallBack(pDSIInfor, RxDatDone, IsrDSIM_General, (u32)RxDatDone);
	DSIM_SetIsrCallBack(pDSIInfor, RxTE, IsrDSIM_General, (u32)RxTE);
	DSIM_SetIsrCallBack(pDSIInfor, RxAck, IsrDSIM_General, (u32)RxAck);
	DSIM_SetIsrCallBack(pDSIInfor, ErrRxECC, IsrDSIM_General, (u32)ErrRxECC);
	DSIM_SetIsrCallBack(pDSIInfor, ErrRxCRC, IsrDSIM_General, (u32)ErrRxCRC);
	
	DSIM_SetIsrCallBack(pDSIInfor, ErrEscLane3, IsrDSIM_General, (u32)ErrEscLane3);
	DSIM_SetIsrCallBack(pDSIInfor, ErrEscLane2, IsrDSIM_General, (u32)ErrEscLane2);
	DSIM_SetIsrCallBack(pDSIInfor, ErrEscLane1, IsrDSIM_General, (u32)ErrEscLane1);
	DSIM_SetIsrCallBack(pDSIInfor, ErrEscLane0, IsrDSIM_General, (u32)ErrEscLane0);

	DSIM_SetIsrCallBack(pDSIInfor, ErrSync3, IsrDSIM_General, (u32)ErrSync3);
	DSIM_SetIsrCallBack(pDSIInfor, ErrSync2, IsrDSIM_General, (u32)ErrSync2);
	DSIM_SetIsrCallBack(pDSIInfor, ErrSync1, IsrDSIM_General, (u32)ErrSync1);
	DSIM_SetIsrCallBack(pDSIInfor, ErrSync0, IsrDSIM_General, (u32)ErrSync0);

	DSIM_SetIsrCallBack(pDSIInfor, ErrControl3, IsrDSIM_General, (u32)ErrControl3);
	DSIM_SetIsrCallBack(pDSIInfor, ErrControl2, IsrDSIM_General, (u32)ErrControl2);
	DSIM_SetIsrCallBack(pDSIInfor, ErrControl1, IsrDSIM_General, (u32)ErrControl1);
	DSIM_SetIsrCallBack(pDSIInfor, ErrControl0, IsrDSIM_General, (u32)ErrControl0);

	DSIM_SetIsrCallBack(pDSIInfor, ErrContentLP0, IsrDSIM_General, (u32)ErrContentLP0);
	DSIM_SetIsrCallBack(pDSIInfor, ErrContentLP1, IsrDSIM_General, (u32)ErrContentLP1);	
	#endif

	DSIM_SetIsrCallBack(pDSIInfor, ErrContentLP0, IsrDSIM_General, (u32)ErrContentLP0);
	DSIM_SetIsrCallBack(pDSIInfor, ErrContentLP1, IsrDSIM_General, (u32)ErrContentLP1);	
	
	//DSIM_SetIsrCallBack(pDSIInfor, BusTunrOver, DSIMISR_TimerTest, (u32)(&dTimeValue));
	//DSIM_SetIsrCallBack(pDSIInfor, RxAck, DSIMISR_TimerTest, (u32)(&uTimeValue));
	DSIM_SetIsrCallBack(pDSIInfor, BTAAckTimeOut, DSIMISR_TimerTest, (u32)(&dTimeValue));
	//DSIM_SetIsrCallBack(pDSIInfor, LPDRTimeOut, DSIMISR_TimerTest, (u32)(&dTimeValue));
	
	do
	{
		PRESS_ANY("Press Any key to Init DSI Master and Transmit DCS Set On LPDT Mode\n");
		DSIM_InitLink(pDSIInfor);

		PRESS_ANY("Press Any Key to change state to HSDT State and Init DDI and Display Image\n");		
		if (g_eDSIMMainDisp ==  MIPI_Dummy)
		{
			DSIM_SetHSEn(pDSIInfor);	//why turn on the HSDT for Just LPDT transfer DDI Init cmd ?			
			DSIM_SetDisplayMode(pDSIInfor, pMainDisp, NULL);			
			LCDC_Start();			
			DSIM_SetDataTransferMode(pDSIInfor, Transfer_ByCPU, false);
			pDDI_Handler->m_fnInit(0,0);
			DSIM_EnBackLite(1);
		}
		else
		{
			DSIM_SetHSEn(pDSIInfor);	//why turn on the HSDT for Just LPDT transfer DDI Init cmd ?
			DSIM_SetDataTransferMode(pDSIInfor, Transfer_ByCPU, false);
			LCDC_Start();
			pDDI_Handler->m_fnInit(0,0);
			DSIM_EnBackLite(1);
			Delay(100);
			DSIM_SetDisplayMode(pDSIInfor, pMainDisp, NULL);			
		}		
		#if 1
		PRESS_ANY("Press Any Key to BTA\n");		
		if ( !bStartTimer)
		{
			StartTimer(2);
			bStartTimer = 1;
		}
		DSIM_ForceRead(pDSIInfor, NULL, NULL);
		#endif
		
		#if 1
		//Test ULPS Entry sequence and Exit ULPS sequence		
		PRESS_ANY("Press Any Key to change Stop State and ULPS Entry\n");
		if (g_eDSIMMainDisp ==  MIPI_Dummy)
		{
			LCDC_Stop();
			TEST_FN(DSIM_SetStopState(pDSIInfor));
		}
		else
		{
			pDDI_Handler->m_fnDown(0,0);
			LCDC_Stop();			
			TEST_FN(DSIM_SetStopState(pDSIInfor));
		}
		//Test ULPS Entry sequence and Exit ULPS sequence		
		TEST_FN(DSIM_SetULPS(pDSIInfor));
		DSIM_EnBackLite(0);
		
		PRESS_ANY("Press Any Key to Exit ULPS\n");
		TEST_FN(DSIM_SetStopState(pDSIInfor));		
		
		// HSDT after Exit ULPS
		PRESS_ANY("Press Any Key to High Speed Datat Transfer Mode By LCDC\n");
		TEST_FN(DSIM_SetHSEn(pDSIInfor));
		Delay(1000);		
		
		if (g_eDSIMMainDisp ==  MIPI_Dummy)
		{
			LCDC_Start();			
			DSIM_SetDataTransferMode(pDSIInfor, Transfer_ByCPU, false);			
			DSIM_EnBackLite(1);
		}
		else
		{
			DSIM_SetDataTransferMode(pDSIInfor, Transfer_ByCPU, false);
			pDDI_Handler->m_fnInit(0,0);
			LCDC_Start();
			DSIM_EnBackLite(1);
		}
		#endif
		#if 0
		PRESS_ANY("Press Any Key to Enter the Reset Trigger\n");
		DSIM_ResetTrigger();
		LCDC_PerFrameOff();
		Delay(1000);			// why delay is needed? and how much is it needed?
		#endif
		PRESS_ANY("Press Any Key to End Test\n");
		bPass = 1;
	}while(0);
	if (bStartTimer)	
	{
		StopTimer(2);
		bStartTimer = 0;
	}
	else
		Disp("Time is %d\n",dTimeValue);	
	
	if (bPass)
		Disp("Test Sucess\n");
	else
		Disp("Test Fail\n");
	pDDI_Handler->m_fnDown(1,0);
	LCDC_Stop();
	
	DDI_Destory(pDDI_Handler, 0,0,0);
	DCS_Destory(pDCSInfor);
	DSIM_Destory(pDSIInfor);
}
