#include <string.h>
#include "dsim_test.h"

static void IsrDSI_Test(u32 uVar0)
{
	Disp("Rx Done!\n");
}

//////////
// Function Name : DSIMTest_InitDSIM
// Function Description : This function test to Initialize DSI Master
// Input : NONE
// Output : NONE
// Version : v0.0
void DSIMTest_RWTest(void)
{
	DDI_Spec* pMainDisp = DDI_GetSpec(g_eDSIMMainDisp);
	DSIM_Infor* pDSIInfor = DSIM_Create(DSIM_DefaultLinkAndPhy(), false);
	DCS_Infor* pDCSInfor = DCS_Create(Link_DSIM, (u32)pDSIInfor, pMainDisp->m_uParaMeter[DSI_VirtualChID]);
	DDI_Handler* pDDI_Handler  = DDI_Create(g_eDSIMMainDisp, Link_DSIM, (u32)pDSIInfor,(u32)pDCSInfor, 0);
	u8 bPass = 0;
	volatile double dTimeValue = 0;
	LCDC_InitBase();
	DSIMTest_InitLcdDrawing(pMainDisp, WIN0);
	do
	{
		PRESS_ANY("Press Any Key to DSI Master\n");
		DSIM_InitLink(pDSIInfor);
		

		PRESS_ANY("Press Any Key to Transmit Init DDI Command on LPDT by CPU and Display Image by Display Controller on HSDT\n");
		if (g_eDSIMMainDisp ==  MIPI_Dummy)
		{
			DSIM_SetHSEn(pDSIInfor);	//why turn on the HSDT for Just LPDT transfer DDI Init cmd ?
			DSIM_SetDisplayMode(pDSIInfor, pMainDisp, NULL);
			LCDC_Start();
			DSIM_SetDataTransferMode(pDSIInfor, Transfer_ByCPU, false);
			pDDI_Handler->m_fnInit(0,0);		
			DSIM_EnBackLite(1);
		}		
		else
		{
			DSIM_SetHSEn(pDSIInfor);	//why turn on the HSDT for Just LPDT transfer DDI Init cmd ?
			DSIM_SetDataTransferMode(pDSIInfor, Transfer_ByCPU, false);
			pDDI_Handler->m_fnInit(0,0);
			DSIM_EnBackLite(1);
			Delay(100);
			DSIM_SetDisplayMode(pDSIInfor, pMainDisp, NULL);
			LCDC_Start();
		}		
		
		#if 1	
		DSIM_SetDataTransferMode(pDSIInfor, Transfer_ByCPU, true);
		PRESS_ANY("Press to enter invert mode\n");
		TEST_FN(DCS_EnterInvertMode(pDCSInfor));
		PRESS_ANY("Press to exit invert mode\n");
		TEST_FN(DCS_ExitInvertMode(pDCSInfor));		
		
		#endif
				
		#if 1		// Pixel format Read/Write Test
		{
			u8 eReadData;
			u8 eWriteData = DSIM_VID_16BPP_565 << 4;		
			PRESS_ANY("Press any to Get pixel format \n");
			DSIM_SetDataTransferMode(pDSIInfor, Transfer_ByCPU, false);		
			TEST_FN(DCS_GetPixelFormat(pDCSInfor, &eReadData));			
			Disp("Read Pixel Format is ");
			DSIMTest_PixelFormat(eReadData);
			PRESS_ANY("Press any to Set pixel format is ");			
			TEST_FN(DCS_SetPixelFormat(pDCSInfor, eWriteData));
			eWriteData = (u8) DSIMTest_PixelFormat(eWriteData);			
			PRESS_ANY("Press any to Get pixel format\n");
			TEST_FN(DCS_GetPixelFormat(pDCSInfor, &eReadData));			
			Disp("Read Pixel Format is ");
			eReadData = (u8) DSIMTest_PixelFormat(eReadData);
			
			Disp("Write Pixel Format is  0x%x\n", eWriteData);
			Disp("Read Pixel Format is  0x%x\n", eReadData);
		}
		#endif
		
		#if 1
		if (0)
		{
			u8 ucDDBBuffer[1024];
			u32 uDataSize;
			u32 uCnt12;
			PRESS_ANY("Press Any Key to Read Display Data Buffer continue \n");
			DCS_ReadDDBContinue(pDCSInfor, ucDDBBuffer, 1024, &uDataSize);
			Disp("Returned Data Size is %d\n",uDataSize);
			for (uCnt12 = 0; uCnt12 < uDataSize ; uCnt12++)
			{
				Disp("0x%x\n",ucDDBBuffer[uCnt12]);
			}
		}
		
		if (0)
		{
			u8 ucDDBBuffer[1024];
			u32 uDataSize;
			u32 uCnt12;
			PRESS_ANY("Press Any Key to Read Memory Start\n");
			DCS_ReadMemoryStart(pDCSInfor, ucDDBBuffer, 1024, &uDataSize);
			Disp("Returned Data Size is %d\n",uDataSize);
			for (uCnt12 = 0; uCnt12 < uDataSize ; uCnt12++)
			{
				Disp("0x%x\n",ucDDBBuffer[uCnt12]);
			}
		}
		
		PRESS_ANY("Press Any Key to BTA\n");
		
		DSIM_SetIsrCallBack(pDSIInfor, LPDRTimeOut, DSIMISR_TimerTest, (u32)(&dTimeValue));
		if ( !bStartTimer)
		{
			StartTimer(2);
			bStartTimer = 1;
		}
		DSIM_ForceRead(pDSIInfor, NULL, NULL);
		DSIM_SetIsrCallBack(pDSIInfor, LPDRTimeOut, NULL, NULL);
		#endif

		#if 0			// Partial Display Test
		PRESS_ANY("Press to enter partial\n");
		DCS_EnterPartialMode(pDCSInfor);		
		PRESS_ANY("Press to write partial image\n");		
		{
			int totals=5;
			const u32 PARTIAL_WIDTH = 240;
			const u32 PARTIAL_HEIGHT = 320;
			unsigned char odd[(PARTIAL_WIDTH/8) * 10];
			unsigned char even[(PARTIAL_WIDTH/8) * 10];		
			unsigned char *pDest;
			u32 uCnt0, uCnt1;
			u32 uTemp;
			{
				int i;
				for (i =0;i<PARTIAL_WIDTH/8;i++) 
				{
					if (i%2==0) 	{
						odd[i]=0x00;
						even[i]=0xff;
					} 
					else {
						even[i]=0x00;
						odd[i]=0xff;
					}
				}
				odd[0] = 0x1<<4;
				even[0] = 0x1<<4;
				odd[(PARTIAL_WIDTH/8)-1] = 0x1<<4;
				even[(PARTIAL_WIDTH/8)-1] = 0x1<<4;			
			
				for (i=0;i<9;i++) 
				{
					uTemp = ((i+1) * (PARTIAL_WIDTH/8));
					pDest = &(even[uTemp]);
					for (uCnt0 = 0; uCnt0 < PARTIAL_WIDTH/8 ; uCnt0++)
					{
						*pDest = even[uCnt0];
						*pDest = odd[uCnt0];
						pDest++;
					}
					
					//memcpy((u8 *)pDest,(u8 *)even,(PARTIAL_WIDTH/8));
					//pDest = &(odd[uTemp]);
					//memcpy((u8 *)pDest,(u8 *)odd,(PARTIAL_WIDTH/8));
				}				
			}			
			{			
				int i;
				for (i=0;i<PARTIAL_HEIGHT/totals + 1;i++) 
				{
					if ((i/8)%2==0) {
						if (i==0) 
							DCS_WriteMemoryStart(pDCSInfor, even,(PARTIAL_WIDTH/8)*totals);
						else
							DCS_WriteMemoryContinue(pDCSInfor, even,(PARTIAL_WIDTH/8)*totals);
					}
					else 
					{
						if (i==0)
							DCS_WriteMemoryStart(pDCSInfor, odd,(PARTIAL_WIDTH/8)*totals);
						else
							DCS_WriteMemoryContinue(pDCSInfor, odd,(PARTIAL_WIDTH/8)*totals);
					}
				}
			}
			
		}
		#endif	
		
		PRESS_ANY("Press any key to end Test\n");
		bPass = 1;
	}while(0);
	if (bStartTimer)	
	{
		StopTimer(2);
		bStartTimer = 0;
	}
	else
		Disp("Time is %3.2f\n",dTimeValue);	
	
	if (bPass)
		Disp("Test Sucess\n");
	else
		Disp("Test Fail\n");
	pDDI_Handler->m_fnDown(0,0);
	LCDC_Stop();	
	DDI_Destory(pDDI_Handler, 0,0,0);
	DCS_Destory(pDCSInfor);
	DSIM_Destory(pDSIInfor);
}
