#include "dsim_test.h"
#include "option.h"

static u8 bInterrtupEnable = false;

//////////
// Function Name : DSIMTest_InitDSIM
// Function Description : This function test to Initialize DSI Master
// Input : NONE
// Output : NONE
// Version : v0.0
void DSIMTest_InitDSIM(void)
{
	DDI_Spec* pMainDisp = DDI_GetSpec(g_eDSIMMainDisp);
	DSIM_Infor* pDSIInfor = DSIM_Create(DSIM_DefaultLinkAndPhy(), bInterrtupEnable);
	DCS_Infor* pDCSInfor = DCS_Create(Link_DSIM, (u32)pDSIInfor, pMainDisp->m_uParaMeter[DSI_VirtualChID]);
	DDI_Handler* pDDI_Handler  = DDI_Create(g_eDSIMMainDisp, Link_DSIM, (u32)pDSIInfor,(u32)pDCSInfor, 0);
	u8 bPass = 0;
	u8 uSel1 = 0;
	if (bInterrtupEnable)
	{
		DSIM_SetIsrCallBack(pDSIInfor, ErrEscLane3, IsrDSIM_General, (u32)ErrEscLane3);
		DSIM_SetIsrCallBack(pDSIInfor, ErrEscLane2, IsrDSIM_General, (u32)ErrEscLane2);
		DSIM_SetIsrCallBack(pDSIInfor, ErrEscLane1, IsrDSIM_General, (u32)ErrEscLane1);
		DSIM_SetIsrCallBack(pDSIInfor, ErrEscLane0, IsrDSIM_General, (u32)ErrEscLane0);

		DSIM_SetIsrCallBack(pDSIInfor, ErrSync3, IsrDSIM_General, (u32)ErrSync3);
		DSIM_SetIsrCallBack(pDSIInfor, ErrSync2, IsrDSIM_General, (u32)ErrSync2);
		DSIM_SetIsrCallBack(pDSIInfor, ErrSync1, IsrDSIM_General, (u32)ErrSync1);
		DSIM_SetIsrCallBack(pDSIInfor, ErrSync0, IsrDSIM_General, (u32)ErrSync0);

		DSIM_SetIsrCallBack(pDSIInfor, ErrControl3, IsrDSIM_General, (u32)ErrControl3);
		DSIM_SetIsrCallBack(pDSIInfor, ErrControl2, IsrDSIM_General, (u32)ErrControl2);
		DSIM_SetIsrCallBack(pDSIInfor, ErrControl1, IsrDSIM_General, (u32)ErrControl1);
		DSIM_SetIsrCallBack(pDSIInfor, ErrControl0, IsrDSIM_General, (u32)ErrControl0);

		DSIM_SetIsrCallBack(pDSIInfor, ErrContentLP0, IsrDSIM_General, (u32)ErrContentLP0);
		DSIM_SetIsrCallBack(pDSIInfor, ErrContentLP1, IsrDSIM_General, (u32)ErrContentLP1);	
	}
	
	LCDC_InitBase();
	DSIMTest_InitLcdDrawing(pMainDisp, WIN0);
	
	do
	{
		//Test Initialization sequence
		PRESS_ANY("Press Any key to Init DSI Master\n");
		DSIM_InitLink(pDSIInfor);

		PRESS_ANY("Press Any Key to Transmit Init DDI Command on LPDT by CPU\n");
		if (g_eDSIMMainDisp ==  MIPI_Dummy)
		{
			DSIM_SetDisplayMode(pDSIInfor, pMainDisp, NULL);
			LCDC_Start();			
			DSIM_SetHSEn(pDSIInfor);
			DSIM_SetDataTransferMode(pDSIInfor, Transfer_ByCPU, false);
			pDDI_Handler->m_fnInit(0,0);
			DSIM_EnBackLite(1);			
		}
		else
		{
			DSIM_SetHSEn(pDSIInfor);	//why turn on the HSDT for Just LPDT transfer DDI Init cmd ?
			DSIM_SetDataTransferMode(pDSIInfor, Transfer_ByCPU, false);
			pDDI_Handler->m_fnInit(0,0);
			DSIM_EnBackLite(1);
			Delay(100);
			DSIM_SetDisplayMode(pDSIInfor, pMainDisp, NULL);
			LCDC_Start();
		}

		Disp("Do you like to coutinue Other DSIM test?\n");
		Disp("0 : Diable[D]	1 : Enable\n");
		uSel1 = UART_GetIntNum();
		if( uSel1 == 1)
		{
			PRESS_ANY("Press to change Pll Frequency\n");
			DSIM_ChangePLL(pDSIInfor, 3, 101,2);			//change Clock 300Mbps
			DSIM_ForceRead(pDSIInfor, NULL, NULL);

			//test to LPDT While RGB Data is transfed in HSDT	
			PRESS_ANY("Press to enter invert mode\n");
			TEST_FN(DCS_EnterInvertMode(pDCSInfor));		
			PRESS_ANY("Press to exit invert mode\n");
			TEST_FN(DCS_ExitInvertMode(pDCSInfor));		
			
			PRESS_ANY("Press Any Key to Draw Small size Image\n");
			DSIMTest_DrawingSmall(pMainDisp, WIN0);
			
			PRESS_ANY("Press Any Key to BTA\n");
			DSIM_ForceRead(pDSIInfor, NULL, NULL);

			//test to LPDT While RGB Data is transfed in HSDT	
			PRESS_ANY("Press to enter invert mode\n");
			TEST_FN(DCS_EnterInvertMode(pDCSInfor));
			PRESS_ANY("Press to exit invert mode\n");
			TEST_FN(DCS_ExitInvertMode(pDCSInfor));	
		
			//Test ULPS Entry sequence and Exit ULPS sequence		
			PRESS_ANY("Press Any Key to change Stop State and ULPS Entry\n");
			if (g_eDSIMMainDisp ==  MIPI_Dummy)
			{
				LCDC_Stop();
				TEST_FN(DSIM_SetStopState(pDSIInfor));
			}			
			else
			{
				pDDI_Handler->m_fnDown(0,0);
				LCDC_PerFrameOff();
				TEST_FN(DSIM_SetStopState(pDSIInfor));
			}		
			PRESS_ANY("ULPS\n");
			//Test ULPS Entry sequence and Exit ULPS sequence		
			TEST_FN(DSIM_SetULPS(pDSIInfor));
			DSIM_EnBackLite(0);
			
			PRESS_ANY("Press Any Key to Exit ULPS\n");
			TEST_FN(DSIM_SetStopState(pDSIInfor));		
			
			// HSDT after Exit ULPS
			PRESS_ANY("Press Any Key to High Speed Datat Transfer Mode By LCDC\n");
			TEST_FN(DSIM_SetHSEn(pDSIInfor));
			Delay(1000);		
			
			if (g_eDSIMMainDisp ==  MIPI_Dummy)
			{
				LCDC_Start();			
				DSIM_SetDataTransferMode(pDSIInfor, Transfer_ByCPU, false);			
				DSIM_EnBackLite(1);
				// LPDT while Display after Exit ULPS
				PRESS_ANY("Press to enter invert mode\n");
				TEST_FN(DCS_EnterInvertMode(pDCSInfor));
				PRESS_ANY("Press to exit invert mode\n");
				TEST_FN(DCS_ExitInvertMode(pDCSInfor))
			}			
			else
			{
				DSIM_SetDataTransferMode(pDSIInfor, Transfer_ByCPU, false);
				pDDI_Handler->m_fnInit(0,0);
				LCDC_Start();
				DSIM_EnBackLite(1);
				// LPDT while Display after Exit ULPS
				PRESS_ANY("Press to enter invert mode\n");
				TEST_FN(DCS_EnterInvertMode(pDCSInfor));
				PRESS_ANY("Press to exit invert mode\n");
				TEST_FN(DCS_ExitInvertMode(pDCSInfor))
			}
		}
		PRESS_ANY("Press Any Key to End Test\n");		
		bPass = 1;
	}while(0);
	if (bPass)
		Disp("Test Sucess\n");
	else
		Disp("Test Fail\n");
	pDDI_Handler->m_fnDown(0,0);
	LCDC_Stop();	
	DDI_Destory(pDDI_Handler, 0,0,0);
	DCS_Destory(pDCSInfor);
	DSIM_Destory(pDSIInfor);
	
}
