#include "dsim_test.h"

#include "v210_sfr.h"
#include "sysc.h"
#include "SfrReadWriten.h"		//SFR Read Write Test


// SFR test	
static REGINFOn	sRegInfoDSIM[] = 
{ 
   	 //register name		address               		bit length	R/W	Reset Value		Flag(?)       PrivateBitMask		Read Value	
	{"DSIM_STATUS ",			MIPI_DSIM_BASE+0x00,	32,	 		RO,	 	0x0010010F,		DPPB, 		0x801107FF,			0},
	{"DSIM_SWRST ",			MIPI_DSIM_BASE+0x04, 	32, 			RW, 	0x00000000, 	DPPB,		0x00010001,			0},
	{"DSIM_CLKCTRL ",		MIPI_DSIM_BASE+0x08, 	32, 			RW, 	0x0000FFFF, 		DPPB, 		0x9FF8FFFF,			0},
	{"DSIM_TIMEOUT ",		MIPI_DSIM_BASE+0x0c, 	32, 			RW,		0x00FFFFFF, 		DPPB, 		0x00FFFFFF,			0},
	{"DSIM_CONFIG ",		MIPI_DSIM_BASE+0x10, 	32, 			RW, 	0x02000000,		DPPB,		0x1FFF777F,			0},
	{"DSIM_ESCMODE ",		MIPI_DSIM_BASE+0x14, 	32, 			RW,		0x00000000,		DPPB,		0xFFF100DF,			0},
	{"DSIM_MDRESOL ",		MIPI_DSIM_BASE+0x18, 	32, 			RW,		0x03000400,		DPPB, 		0x87FF07FF,			0},
	{"DSIM_MVPORCH ",		MIPI_DSIM_BASE+0x1c, 	32,			RW, 	0xF0000000,		DPPB, 		0xF7FF07FF,			0},
	{"DSIM_MHPORCH ",		MIPI_DSIM_BASE+0x20,	32, 			RW,		0x00000000, 	DPPB, 		0xFFFFFFFF,			0},
	{"DSIM_MSYNC ",		MIPI_DSIM_BASE+0x24, 	32, 			RW, 	0x00000000,		DPPB, 		0xFFC0FFFF,			0},
	{"DSIM_SDRESOL ",		MIPI_DSIM_BASE+0x28, 	32, 			RW, 	0x03000400, 	DPPB, 		0x87FF07FF,			0},
	{"DSIM_INTSRC ",			MIPI_DSIM_BASE+0x2c, 	32, 			RO,	 	0x00000000,		DPPB,		0xE337FFFF,			0},
	{"DSIM_INTMSK ",		MIPI_DSIM_BASE+0x30, 	32, 			RW,		0xB337FFFF, 		DPPB, 		0xE337FFFF,			0},
	{"DSIM_PKTHDR ",		MIPI_DSIM_BASE+0x34, 	32, 			WO, 	0x00000000, 	DPPB, 		0x00FFFFFF,			0},
	{"DSIM_PAYLOAD ",		MIPI_DSIM_BASE+0x38, 	32, 			WO, 	0x00000000,		DPPB,		0xFFFFFFFF,			0},
	{"DSIM_RXFIFO ",			MIPI_DSIM_BASE+0x3c, 	32,			RO,		0x00000000, 	DPDB,		0x00000000,			0},

	{"DSIM_FIFOCTRL ",		MIPI_DSIM_BASE+0x44, 	32, 			RW, 	0x0155551F,		DPPB, 		0x0000001F,			0},
	{"DSIM_MEMACCHR ",	MIPI_DSIM_BASE+0x48, 	32, 			RW, 	0x00004040,		DPPB, 		0x0000FFFF,			0},
	{"DSIM_PLLCTRL ",		MIPI_DSIM_BASE+0x4c, 	32, 			RW, 	0x00000000,		DPPB, 		0xFFFFFFFE,			0},
	{"DSIM_PLLTMR ",		MIPI_DSIM_BASE+0x50, 	32,			RW,		0xFFFFFFFF,		DPPB,		0xFFFFFFFF,			0},
	{"DSIM_PHYACCHR ",		MIPI_DSIM_BASE+0x54, 	32,			RW,		0x00000000, 	DPPB, 		0xFFFFFFFF,			0},
	{"DSIM_PHYACCHR1 ",	MIPI_DSIM_BASE+0x58, 	32, 			RW, 	0x00000000,		DPPB, 		0xFFFFFFFF,			0},
		

};

//////////
// Function Name : DSIMTest_RWSFR
// Function Description : This function tests DSIM SFR Read/Write Test
// Input : NONE
// Output : NONE
// Version : v0.0
void DSIMTest_RWSFR(void)
{
	SYSC_EnDPHY(DPHY_HW|DPHY_Master, 1);
	
	TestSFRn(sRegInfoDSIM, sizeof(sRegInfoDSIM)/sizeof(REGINFOn));

	SYSC_EnDPHY(DPHY_HW|DPHY_Master, 0);
	
}
