/**************************************************************************************
* 
*	Project Name : S5PV210 Validation
*
*	Copyright 2009 by Samsung Electronics, Inc.
*	All rights reserved.
*
*	Project Description :
*		This software is only for validating functions of the S5PV210.
*		Anybody can use this software without our permission.
*  
*--------------------------------------------------------------------------------------
* 
*	File Name : dsim_test.h
*  
*	File Description : This file is top of DSIM Test and Ohter Functions for DSIM Tests.
*
*	Author : Sunghyun,Na
*	Dept. : AP Development Team
*	Created Date : 2009/07/17
*	Version : 0.2
* 
*	History
*	- 0. Created(Sunghyun,Na 2009/07/17)		
*   
**************************************************************************************/

#ifndef __DSIM_TEST_H__
#define __DSIM_TEST_H__

#include <stdio.h>
#include "def.h"

#include "lcd.h"		//LCD Controller Driver
#include "glib.h"		//Graphic Library
#include "dsim.h"		//DSI Master Driver		
#include "dcs.h"		//Display Command Set Driver

#include "ddi.h"		//DDI Handler

#define PRESS_ANY(msg)		UART_Printf(msg);UART_Getc();
#define TEST_FN(fn)			if(!(fn))break;

extern DDI_MODEL g_eDSIMMainDisp;
extern u32 g_uDSIMFbAddr[5];
extern u32 g_uDownLoadBMPAddr;
extern u8 bStartTimer;

 
void DSIMTest_InitLcdDrawing(DDI_Spec* pDDISpec, LCD_WINDOW eDisplayWindow);
void DSIMTest_DrawingSmall(DDI_Spec* pDDISpec, LCD_WINDOW eDisplayWindow);
DSIM_PixerFormat DSIMTest_PixelFormat(u8 ucData);
void DSIM_PHYCLKout(void);
void DSIMISR_TimerTest(u32 uVar);
void IsrDSIM_General(u32 uVar);
#endif
