/**************************************************************************************
* 
*	Project Name : S5PV210 Validation
*
*	Copyright 2009 by Samsung Electronics, Inc.
*	All rights reserved.
*
*	Project Description :
*		This software is only for validating functions of the S5PV210.
*		Anybody can use this software without our permission.
*  
*--------------------------------------------------------------------------------------
* 
*	File Name : dsim_test.c
*  
*	File Description : This file is top of DSIM Test and Ohter Functions for DSIM Tests.
*
*	Author : Sunghyun,Na
*	Dept. : AP Development Team
*	Created Date : 2009/07/17
*	Version : 0.2
* 
*	History
*	- 0. Created(Sunghyun,Na 2009/07/17)		
*   
**************************************************************************************/
#include "dsim_test.h"

#include "gpio.h"
#include "sysc.h"
#include "option.h"
#include "max8698.h"			//to control PMIC for MIPI 1.8V

DDI_MODEL g_eDSIMMainDisp = MIPI_Dummy;
u32 g_uDSIMFbAddr[5] = {CODEC_MEM_ST, CODEC_MEM_ST + 0x01000000, CODEC_MEM_ST + 0x02000000, CODEC_MEM_ST + 0x03000000,	CODEC_MEM_ST + 0x04000000};						
u32 g_uDownLoadBMPAddr = CODEC_MEM_ST+0x05000000;
// Test Function
extern void DSIMTest_RWSFR(void);
extern void DSIMTest_InitDSIM(void);
extern void DSIMTest_RWTest(void);
extern void DSIMTest_InterruptTest(void);
extern void DSIMTest_CommandModeByLCDC(void);
extern void DSIMTest_CommandModeByCPU(void);
#if 0

void DSIMTest_ResetTrigger(void);
void DSIMTest_Interrupt(void);
void DSIMTest_SetTearOnCmd(void);
void DSIMTest_CommandModeByCPU(void);
void DSIMTest_InterrtupAging(void);
void DSIMTest_AgilentConformanceTest(void);
//Auto Test
u8 DSIMTest_AutoTest(void);
#endif
 
//////////
// Function Name : Test_MIPIDSI
// Function Description : This function test to Initialize DSI Master
// Input : NONE
// Output : NONE
// Version : v0.0
void Test_MIPIDSI(void)
{

	u32  i, sel;
	const testFuncMenu menu[]=
	{
		0,										"Exit\n",
		DSIMTest_RWSFR,						"Read/Write SFR\n",
		
		DSIMTest_InitDSIM,					"Init DSIM and State Transaction for Video Mode\n",
		
		DSIMTest_CommandModeByLCDC,	"Command Mode Transfer By LCDC",
		DSIMTest_CommandModeByCPU,		"Command Mode Transfer By CPU\n",

		DSIMTest_RWTest,					"Read/Write Test",
		DSIMTest_InterruptTest,				"Interrupt Test\n",
		#if 0		
		DSIMTest_ResetTrigger,				"Reset Trigger Test",		
		DSIMTest_SetTearOnCmd,				"Set Tear On/Off Test\n",
		DSIMTest_CommandModeByCPU,		"Command Mode Test By CPU Transfer\n",
		DSIMTest_InterrtupAging,				"Interrupt Aging Test\n",
		DSIMTest_AgilentConformanceTest,	"Conformane Test wiht Agilnet Test Kit\n",
		DSIMTest_AutoTest,					"DSIM AutoTest ",
		#endif
		0,0
		
	};	
	//MIPI 1.8V Out
	MAX8698_SetVoltageLDO4(LDO45679_VOL_18);			
	//Probing for Byte Clock & Esc Clock
	//GPIO_Init();
	//DSIM_PHYCLKout();

	#ifdef S5PV210
	SYSC_SetDispPath(eDISP_BYPASS);
	IEIP_Select(DISP_BYPASS);
	#endif	
	
	while(1)
	{
		Disp("\n");
		for (i=0; (int)(menu[i].desc)!=0; i++)
			Disp("%2d: %s\n", i, menu[i].desc);
		Disp("\nSelect the function to test : ");
		sel = UART_GetIntNum();
		Disp("\n");
		if (sel == 0)
			break;
		else if (sel>0 && sel<(sizeof(menu)/8-1))
			(menu[sel].func)();		
	}

	MAX8698_SetVoltageLDO4(LDO45679_VOL_OFF);			//MIPI 1.8V Out
}

//////////
// Function Name : DSIMTest_InitLcdDrawing
// Function Description : This function Initializes LCD Controller and draws Color bar pattern for DSI master Test
// Input : 	DSIM_Infor*		- DSI Configuration (main display buffer address) 
// Output : NONE
// Version : v0.0
void DSIMTest_InitLcdDrawing(DDI_Spec* pDDISpec, LCD_WINDOW eDisplayWindow)
{
	u32 uImageGen;
	static IMG_FMT eTestImageFmt;
	static u32 uBeforImageGen;
	u32 uDispBuffer;
	if (eDisplayWindow == ALLWIN)
		uDispBuffer = g_uDSIMFbAddr[0];
	else 
		uDispBuffer = g_uDSIMFbAddr[eDisplayWindow];
	
	LCDC_InitWin(	pDDISpec->m_02eBgBpp, 
					pDDISpec->m_00uHoriSize, 
					pDDISpec->m_01uVertiSize, 0, 0, 
			     		pDDISpec->m_00uHoriSize, 
			     		pDDISpec->m_01uVertiSize, 0, 0, 
			     		uDispBuffer, eDisplayWindow, false);

	LCDC_SetWinOnOff(1, eDisplayWindow);
	GLIB_InitInstance(	uDispBuffer, 
						pDDISpec->m_00uHoriSize, 
						pDDISpec->m_01uVertiSize, 
						pDDISpec->m_02eBgBpp);
	uImageGen = DispGetIntNum("Select Image Generation\n0: Drawing	1: Download BMP 0x%x	2: Skip\n",g_uDownLoadBMPAddr);
	
	if ( uImageGen == 0 )
	{
		GLIB_DrawPattern(pDDISpec->m_00uHoriSize, pDDISpec->m_01uVertiSize);
		GLIB_PutLine(0, 0, 0, pDDISpec->m_01uVertiSize-1, C_BLUE);							
		GLIB_PutLine(pDDISpec->m_00uHoriSize-1, 0, pDDISpec->m_00uHoriSize-1, pDDISpec->m_01uVertiSize-1, C_RED);
		uBeforImageGen = uImageGen;
	}		
	else if ( uImageGen == 1 )
	{
		Disp("Press Any key after Download BMP from PC to DUT 0x%x\n",g_uDownLoadBMPAddr);
		UART_Getc();
		if ( pDDISpec->m_02eBgBpp == RGB888)
			ConvertBmpToRgb24bpp(g_uDownLoadBMPAddr, uDispBuffer, pDDISpec->m_00uHoriSize, pDDISpec->m_01uVertiSize);

		else if ( pDDISpec->m_02eBgBpp == RGB565)
			ConvertBmpToRgb16bpp(g_uDownLoadBMPAddr, uDispBuffer, pDDISpec->m_00uHoriSize, pDDISpec->m_01uVertiSize);

		uBeforImageGen = uImageGen;
	}
	else
	{
		Disp("Image Generation Skip\n");
		if ( eTestImageFmt != pDDISpec->m_02eBgBpp )
		{
			if(uBeforImageGen == 0)
			{
				GLIB_DrawPattern(pDDISpec->m_00uHoriSize, pDDISpec->m_01uVertiSize);
				GLIB_PutLine(0, 0, 0, pDDISpec->m_01uVertiSize-1, C_BLUE);							
				GLIB_PutLine(pDDISpec->m_00uHoriSize-1, 0, pDDISpec->m_00uHoriSize-1, pDDISpec->m_01uVertiSize-1, C_RED);				
			}
			else if (uBeforImageGen == 1 )
			{
				if ( pDDISpec->m_02eBgBpp == RGB888)
					ConvertBmpToRgb24bpp(g_uDownLoadBMPAddr, uDispBuffer, pDDISpec->m_00uHoriSize, pDDISpec->m_01uVertiSize);

				else if ( pDDISpec->m_02eBgBpp == RGB565)
					ConvertBmpToRgb16bpp(g_uDownLoadBMPAddr, uDispBuffer, pDDISpec->m_00uHoriSize, pDDISpec->m_01uVertiSize);

			}
			eTestImageFmt = pDDISpec->m_02eBgBpp;
		}
	}

	GLIB_InitFont();
	GLIB_Printf(pDDISpec->m_00uHoriSize/5,pDDISpec->m_01uVertiSize*eDisplayWindow/5, "Window %d", eDisplayWindow);
}

//////////
// Function Name : DSIMTest_DrawingSmall
// Function Description : This function Initializes LCD Controller and draws Color bar pattern for DSI master Test
// Input : 	DSIM_Infor*		- DSI Configuration (main display buffer address) 
// Output : NONE
// Version : v0.0
void DSIMTest_DrawingSmall(DDI_Spec* pDDISpec, LCD_WINDOW eDisplayWindow)
{
	/*
	LCDC_InitWin(	pDDISpec->m_02eBgBpp, 
					pDDISpec->m_00uHoriSize / 2,
					pDDISpec->m_01uVertiSize / 2, 0, 0, 
		         		pDDISpec->m_00uHoriSize / 2,
		         		pDDISpec->m_01uVertiSize / 2, 80, 120, 
		         		g_uDSIMFbAddr[eDisplayWindow], eDisplayWindow, false);

	GLIB_InitInstance(	g_uDSIMFbAddr[eDisplayWindow], 
						pDDISpec->m_00uHoriSize/2, 
						pDDISpec->m_01uVertiSize/2, 
						pDDISpec->m_02eBgBpp);
	
	GLIB_DrawPattern(pDDISpec->m_00uHoriSize/2, pDDISpec->m_01uVertiSize/2);
	GLIB_PutLine(0, 0, 0, pDDISpec->m_01uVertiSize/2-1, C_BLUE);
	GLIB_PutLine(pDDISpec->m_00uHoriSize/2-1, 0, pDDISpec->m_00uHoriSize/2-1, pDDISpec->m_01uVertiSize/2-1, C_RED);
	*/
}

//////////
// Function Name : DSIMTest_GetPixelFormat
// Function Description : This function Initializes LCD Controller and draws Color bar pattern for DSI master Test
// Input : 	u8 - Data to extract Pixel format
// Output : NONE
// Version : v0.0
DSIM_PixerFormat DSIMTest_PixelFormat(u8 ucData)
{
	DSIM_PixerFormat ePixel = (DSIM_PixerFormat) (( ucData & 0xf0) >> 4);
	switch(ePixel)
	{
		case DSIM_CMD_3BPP:
			Disp("3PP");
			break;
		case DSIM_CMD_8BPP:
			Disp("8PP");
			break;
		case DSIM_CMD_12BPP:
			Disp("12PP");
			break;
		case DSIM_CMD_16BPP:
		case DSIM_VID_16BPP_565:
			Disp("16PP");
			break;
		case DSIM_VID_18BPP_666PACKED:
			Disp("18PP PACKED");
			break;
		case DSIM_18BPP_666LOOSELYPACKED:
			Disp("18PP Loosely PACKED");
			break;
		case DSIM_24BPP_888:
			Disp("24PP");
			break;
		default:
			Disp("Not recognized!");
			break;
	}
	Disp("\n");
	return ePixel;
}

//////////
// Function Name : DSIMTest_GetGeneralID
// Function Description : This function get General ID to read RDDB of DDI Module.
// Input : 	DCS_Infor* - Interface for DCS
// Output : NONE
// Version : v0.0
u8 DSIMTest_GetGeneralID(DCS_Infor* tDCS)
{
	if(tDCS)
	{
		u8 ucDDBBuffer[1024];
		u32 uDataSize;
		u32 uCnt12;
		if(DCS_ExitSleepMode(tDCS))
		{
			u8 ucPass;
			if(DCS_ReadDDBStart(tDCS, ucDDBBuffer, 1024, &uDataSize))
			{
				Disp("Returned Data Size is %d\n",uDataSize);
				for (uCnt12 = 0; uCnt12 < uDataSize ; uCnt12++)
				{
					Disp("0x%x\n",ucDDBBuffer[uCnt12]);
				}
				ucPass = 1;
			}
			else
			{
				Disp("Read Fail\n");
				ucPass = 0;
			}
			DCS_EnterSleepMode(tDCS);
			return ucPass;
		}
	}
	else
	{
		Disp("Please create dcs interface\n");
		return false;
	}
}

//////////
// Function Name : DSIM_PHYCLKout
// Function Description : 
//   This function Clock out of MIPI master Escape Clcok and Byte Clock
// Input : 	bEn - True/False
// Output : None
// Version : v0.0
void DSIM_PHYCLKout(void)
{
	GPIO_SetFunctionEach(eGPIO_J0, eGPIO_0, 0x5); 	//GPJ0[0] -> MIPI Escape Clock
	GPIO_SetFunctionEach(eGPIO_J0, eGPIO_1, 0x5); 	//GPJ0[1] -> MIPI Byte Clock
}

u8 bStartTimer = 0;
void DSIMISR_TimerTest(u32 uVar)
{
	if ( !bStartTimer)
	{
		StartTimer(2);
		bStartTimer = 1;
	}
	else 
	{
		*(double *)uVar = StopTimer(2);
		bStartTimer = 0;
	}
}

//Functions called on isr
void IsrDSIM_General(u32 uVar)
{
	switch(uVar)
	{
		case PllStable:
			Disp("\n!!!\t");
			Disp("Pll statble \n");
			return;
		case SwRstRelease :
			Disp("\n@@@\t");
			Disp("Sw Reset Release\n");
			return;
		case SFRFifoEmpty:
			Disp("\n***\t");
			Disp("SFR Fifo Empty \n");
			break;
		case BusTunrOver:
			//Disp("\n###\t");
			//Disp("Bus Turn Over\n");
			StopTimer(2);
			return;
		case FrameDone:
			Disp("\n$$$\t");
			Disp("Frame Done\n");
			DSIM_SetIntrMask(FrameDone, 1);		// Masked 	
			return;
		case LPDRTimeOut:
			Disp("\n%%%\t");
			Disp("LP Rx Time Out\n");
			break;
		case BTAAckTimeOut:
			//Disp("\n^^^\t");
			//Disp("BTA Time Out\n");
			StartTimer(2);
			break;
		case RxDatDone:
			Disp("\n&&&\t");
			Disp("Rx Data Done\n");
			break;
		case RxTE:
			Disp("\n&&&\t");
			Disp("Receive TE Signal\n");
			break;
		case RxAck:
			Disp("\n&&&\t");
			Disp("Receive Ack\n");
			break;
		case ErrRxECC:
			Disp("\n!!!\t");
			Disp("ECC error \n");
			break;
		case ErrRxCRC:
			Disp("\n!!!\t");
			Disp("CRC error \n");
			break;
		case ErrEscLane3:
			Disp("\n!!!\t");
			Disp("Error Escape Lane 3 \n");
			break;
		case ErrEscLane2:
			Disp("\n!!!\t");
			Disp("Error Escape Lane 2 \n");
			break;
		case ErrEscLane1:
			Disp("\n!!!\t");
			Disp("Error Escape Lane 1 \n");
			break;
		case ErrEscLane0:
			Disp("\n!!!\t");
			Disp("Error Escape Lane 0 \n");
			break;
		case ErrSync3:
			Disp("\n@@@@\t");
			Disp("LPDT SYNC Lane 3!!\n");
			break;
		case ErrSync2:
			Disp("\n@@@@\t");
			Disp("LPDT SYNC Lane 2!!\n");
			break;
		case ErrSync1:
			Disp("\n@@@@\t");
			Disp("LPDT SYNC Lane 1!!\n");
			break;
		case ErrSync0:
			Disp("\n@@@@\t");
			Disp("LPDT SYNC Lane 0!!\n");
			break;
		case ErrControl3:
			Disp("\n@@@@\t");
			Disp("Err Control Lane 3!!\n");
			break;
		case ErrControl2:
			Disp("\n@@@@\t");
			Disp("Err Control Lane 2!!\n");
			break;
		case ErrControl1:
			Disp("\n@@@@\t");
			Disp("Err Control Lane 1!!\n");
			break;
		case ErrControl0:
			Disp("\n@@@@\t");
			Disp("Err Control Lane 0!!\n");
			break;
		case ErrContentLP0:
			Disp("\n!!!\t");
			Disp("Contention LP0 \n");
			break;
		case ErrContentLP1:
			Disp("\n!!!\t");
			Disp("Contention LP1 \n");
			break;
	}	
}