#ifndef __DSIM_H_
#define __DSIM_H_
#include "sysc.h"
#include "def.h"
#include "ddi.h"

//DPHY Version
#define DPHY_65n	65
#define DPHY_45n	45

//DSI Version
#define DSIM_1_00	1
#define DSIM_1_02	2

//H/W Configuration
#define MIPI_FIN					24000000
#define DPHY_Version				DPHY_45n
#define DSIM_Version				DSIM_1_02	

#if ( DSIM_Version == DSIM_1_00 )
#define DSIM_NoOfInterrupt		27
#elif ( DSIM_Version == DSIM_1_02 )
#define DSIM_NoOfInterrupt		26
#endif

#define DSIM_HEADER_FIFO_SZ		16
#define DSIM_TIMEOUT_MS		5000

typedef struct {
	volatile u32 rDSIM_STATUS;		//0x0,		//R		// DSIM Status
	volatile u32 rDSIM_SWRST;			//0x4,		//R/W	// DSIM Software Reset Register
	volatile u32 rDSIM_CLKCTRL; 		//0x8,		//R/W	// DSIM Clock control register
	volatile u32 rDSIM_TIMEOUT; 		//0xc,   	//R/W	// DSIM Time-out Resgister
	volatile u32 rDSIM_CONFIG; 		//0x10,		//R/W	// DSIM Configuration
	volatile u32 rDSIM_ESCMODE;		//0x14,		//R/W	// DSIM Escape Mode Register
	volatile u32 rDSIM_MDRESOL;		//0x18,		//R/W	// DSIM Main Display Resolution Register
	volatile u32 rDSIM_MVPORCH; 		//0x1c,		//R/W	// DSIM Main Display Vertical Porch Register
	volatile u32 rDSIM_MHPORCH; 		//0x20,		//R/W	// DSIM Main Display Horizontal Porch Register
	volatile u32 rDSIM_MSYNC; 		//0x24,		//R/W	// DSIM Main Display Sync area Register
	volatile u32 rDSIM_SDRESOL;		//0x28,		//R/W	// DSIM Sub Display Image Resolution Register
	volatile u32 rDSIM_INTSRC;	 		//0x2c,		//R/W	// DSIM Interrupt Source Register
	volatile u32 rDSIM_INTMASK;		//0x30,		//R/W	// DSIM Interrupt Mask Register
	volatile u32 rDSIM_PKTHDR;		//0x34,		//W	// DSIM Packet header FIFO Register
	volatile u32 rDSIM_PAYLOAD;		//0x38,		//W	// DSIM Payload FIFO Register
	volatile u32 rDSIM_RXFIFO;	 		//0x3c,		//R		// DSIM Read FIFO Register
	volatile u32 rDSIM_FIFOTHLD;		//HIDDEN	//0x40	//R/W	// Reserved	//not used this function										
	volatile u32 rDSIM_FIFOCTRL;		//0x44,		//R/W	// DSIM FIFO Status & Control Register
	volatile u32 rDSIM_MEMACCHR;	//0x48,		//R/W	// DSIM FIFO Memory AC Characteristic Register
	volatile u32 rDSIM_PLLCTRL;		//0x4c,		//R/W	// DSIM PLL Contorl Register
	volatile u32 rDSIM_PLLTMR;		//0x50,		//R/W	// DSIM PLL Timer Register
	#ifndef S5PC100
	volatile u32 rDSIM_PHYACCHR; 	//0x54,		//R/W	// DSIM D-PHY AC Characteristic Register
	volatile u32 rDSIM_PHYACCHR1;	//0x58,		//R/W	// DSIM D-PHY AC Characteristic Register 1
	#else 
	volatile u32 uReserved00;		//0x54
	volatile u32 uReserved01;		//0x58
	#endif	
}DSIM_SFR;

typedef enum
{
	Lane_Clock = 0,	
	Lane_Data0 = (1 << 0),
	Lane_Data1 = (1 << 1),
	Lane_Data2 = (1 << 2),
	Lane_Data3 = (1 << 3),
	Lane_DataAll = (0xf),
	Lane_All = 0x10,
}DSIM_LANE;

typedef enum
{
	LaneState_HsReady,
	LaneState_ULPS,
	LaneState_Stop,
}DSIM_LaneState;

typedef enum 
{
	DSIM_FuncRst 	= (1 << 16),			//Function Register Reset 
	DSIM_SwRst 		= (1 << 0),
	DSIM_AllRst 		= 0,
}DSIM_Rst;

typedef enum {
	DataLane_1=0,
	DataLane_2=1,			
	DataLane_3=2,
	DataLane_4=3
}DSIM_NoOfDataLane;

typedef enum {
	VirtualCh_0=0,
	VirtualCh_1=1,
	VirtualCh_2=2,
	VirtualCh_3=3
}DSIM_VirtualChNo;

typedef enum 
{
	DSIM_Command 	= MIPI_Command,	 // I80 I/F
	DSIM_Video 		= MIPI_Video,		// RGB I/F	
}DSIM_InterfaceType;

typedef enum
{
	PLLOutDiv8 = 0x0,
	ExtclkDiv8 = 0x1,
	ExtclkBypass = 0x2,
}DSIM_ByteClkSrc;

typedef enum {
	DSIM_CMD_3BPP = 0,
	DSIM_CMD_8BPP = 1,
	DSIM_CMD_12BPP = 2,
	DSIM_CMD_16BPP = 3,
	DSIM_VID_16BPP_565 = 4,
	DSIM_VID_18BPP_666PACKED = 5,
	DSIM_18BPP_666LOOSELYPACKED = 6,
	DSIM_24BPP_888 = 7
}DSIM_PixerFormat;

typedef enum{
	Transfer_Neither	= 0x0,
	Transfer_ByCPU 	= (1 << 7),
	Transfer_ByLCDC 	= (1 << 6),
	Transfer_Both 	= (0x3 << 6),
}DSIM_Transfer;

typedef enum{
	ULPS_Exit,
	ULPS_Entry
}DSIM_UlpsReques;

typedef enum{
	AllofIntr = 0xffffffff,
	PllStable = (1 << 31),
	SwRstRelease = (1 << 30),
	SFRFifoEmpty = (1 << 29), 
	#if (DSIM_Version == DSIM_1_00)
	SYNCOverride = (1 << 28),				//r03 - C100. it is removed what has r11
	#endif
	BusTunrOver = (1 << 25),
	FrameDone = (1 << 24),
	LPDRTimeOut = (1 << 21),
	BTAAckTimeOut = (1 << 20),
	RxDatDone = (1 << 18),
	RxTE = (1 << 17),
	RxAck = (1 << 16),
	ErrRxECC = (1 << 15),
	ErrRxCRC = (1 << 14),	
	ErrEscLane3 = (1 << 13),
	ErrEscLane2 = (1 << 12),
	ErrEscLane1 = (1 << 11), 
	ErrEscLane0 = (1 << 10),	
	ErrSync3 = (1 << 9), 	
	ErrSync2 = (1 << 8),
	ErrSync1 = (1 << 7),
	ErrSync0 = (1 << 6),	
	ErrControl3 = (1 << 5),
	ErrControl2 = (1 << 4),
	ErrControl1 = (1 << 3),
	ErrControl0 = (1 << 2),
	ErrContentLP0 = (1 << 1),
	ErrContentLP1 = (1 << 0),	
}DSIM_IntSrc;

typedef enum{
	DSIM_RxFifo = (1 << 4),
	DSIM_TxSFRFifo = (1 << 3),
	DSIM_I80Fifo = (1 << 2),
	DSIM_SubDispFifo = (1 << 1),
	DSIM_MainDispFifo = (1 << 0),
}DSIM_Fifo;

typedef enum{
	DSIM_RxDataFull = (1 << 25),
	DSIM_RxDataEmpty = (1 << 24),
	SFRHeaderFull = (1 << 23),
	SFRHeaderEmpty = (1 << 22),
	SFRPayLoadFull = (1 << 21),
	SFRPayLoadEmpty = (1 << 20),
	I80HeaderFull = (1 << 19),
	I80HeaderEmpty = (1 << 18),
	I80PayLoadFull = (1 << 17),
	I80PayLoadEmpty = (1 << 16),
	SubDispHeaderFull = (1 << 15),
	SubDispHeaderEmpty = (1 << 14),
	SubDispPayLoadFull = (1 << 13),
	SubDispPayLoadEmpty = (1 << 12),
	MainDispHeaderFull = (1 << 11),
	MainDispHeaderEmpty = (1 << 10),
	MainDispPayLoadFull = (1 << 9),
	MainDispPayLoadEmpty = (1 << 8),
}DSIM_FifoState;

typedef enum {
	DSIM_NonBurstSyncEvent = 0x0,
	DSIM_NonBurstSyncPulse = 0x2,	
	DSIM_Burst = 0x3,
	DSIM_NonVideoMode = 0x4,
} DSIM_VideoModeType;
/////////////////////////////////////////////////


typedef __packed struct 
{
	u8 id;
	__packed union 
	{
		u16 word_count;
		u16 err_flag;
		__packed struct 
		{
			u8 data0;
			u8 data1;
		}data;
	} _inter;
	u8 ecc;
}DSIM_Header;
typedef DSIM_Header	DSIM_ShortPktHeader;		

typedef enum
{
	//Packet Types for Command
	//Short Packet Type	
	GenShortWrNoPara	= 0x03,
	GenShortWr1Para		= 0x13,
	GenShortWr2Para		= 0x23,
	GenRdNoPara		= 0x04,
	GenRd1Para			= 0x14,
	GenRd2Para			= 0x24,
	DCSWrNoPara		= 0x05,
	DCSWr1para			= 0x15 ,
	DCSRdNoPara 		= 0x06,
	SetMaxRtnPktsize		= 0x37,
	//Long Packet Type
	NullPkt				= 0x09,
	BlankingPkt			= 0x19,
	GenLongWr			= 0x29,
	DCSLongWr			= 0x39,

	//Generic Command
	//Short 
	CMOff				= 0x02,
	CMOn				= 0x12,
	ShutDown			= 0x22,
	TurnOn				= 0x32,	

	//Packet Types for Video Data - for test Data tranfer through Bus
	//Short
	VSyncStart			= 0x01,
	VSyncEnd			= 0x11,
	HSyncStart			= 0x21,
	HSyncEnd			= 0x31,
	EotPkt				= 0x08,
	//Long Packet Type
	RGB565Packed		= 0x0e,
	RGB666Packed		= 0x1e,
	RGB666Loosly		= 0x2e,
	RGB888Packed		= 0x3e,
}DSIM_DataID;

typedef enum
{
	Ack = 0x02,
	EoTp = 0x08,
	GenShort1B = 0x11,
	GenShort2B = 0x12,
	GenLong = 0x1a,
	DcsLong = 0x1c,
	DcsShort1B = 0x21,
	DcsShort2B = 0x22,
}DSIM_Response;

typedef enum
{
	Sot = (1 << 0),
	SotTSync = (1 << 1),
	EotSync = (1 << 2),
	ESCEntry = (1 << 3),
	LPTSync = (1 << 4),
	HSTimeout = (1 << 5),
	FalseControl = (1 << 6),
	//Reserved = (1 << 7),
	EccSingle = (1 << 8),
	EccMulti = (1 << 9),
	CheckSum = (1 << 10),
	DataType = (1 << 11),
	VC = (1 << 12),
	Length = (1 << 13),
	//Reserved = (1 << 14),
	Protocol = (1 << 15)
}DSIM_Error;	

//---------------------------------------------------------------------------------------------------------
typedef enum {
	DSIM_State_Reset = 0,
	DSIM_State_Init = 1,	
	DSIM_State_Stop = 2,
	DSIM_State_HSClkEn = 3,
	DSIM_State_ULPS = 4,	
}DSIM_State;

typedef struct
{
	#if ( DSIM_Version == DSIM_1_02)
	u8 m_ucEOTDisable;					//EOT Packet Genration
	#endif	
	//Porch Option
	u8 m_ucAutoVerticalCnt;				//Auto Vertical Cnt Mode
	u8 m_ucHSE;							//Horizontal Sync Evnet Mode
	u8 m_ucHFP;							//Discard Horizontal Front Porch Time
	u8 m_ucHBP;							//Discard Horizontal Back Porch Time
	u8 m_ucHSA;							//Discard Horizontal Sync Area Timing	
	//Data Lane  	
	DSIM_NoOfDataLane  m_eNoDataLane;	//Number of Data Lane using DSI Master
	//Pll
	u8 m_bPllBypass;
	//Pll PMS Value
	u8 m_ucP;
	u16 m_usM;
	u8 m_ucS;
	// Pll Stable Time
	u32 m_uPllStableTime;
	
	double m_dEscClk;
	//BTA Sequence
	u16 m_usStopHoldingCnt;
	u8 m_ucBTATimeOut;
	u16 m_usRxTimeOut;
	//ISR Priority
	DSIM_IntSrc m_eIsrPriority[DSIM_NoOfInterrupt];
}DSIM_Configuration;

typedef struct _DSIM_Infor
{
	DSIM_SFR* m_pBaseAddr;
	
	DSIM_Configuration* m_oDSIConfiguration;
	DDI_Spec* m_pMainDisp;
	DDI_Spec* m_pSubDisp;
	
	DSIM_LANE	m_eDataLane;
	DSIM_ByteClkSrc m_eByteclk;					//Clock Schme of DSIM
		
	double m_dHSClk;							//Maximum Clock of High Speed Mode
	double m_dByteClk;							//Byte Clcok
	double m_dEscapeClk;							//Escape Clcok
	
	//State 
	DSIM_State m_eState;
	u8 m_ucPadding3[3];								//Padding bits. not used
	// Rx Fifo 
	DSIM_ShortPktHeader m_oHeaderFifo[DSIM_HEADER_FIFO_SZ];
	s8 m_HeaderFifoIndex[DSIM_HEADER_FIFO_SZ];
	// ISR	
	void (*m_fnCallback[32])(u32);	// callback function pointer - for generate transfer completed signal
	u32 m_uCallbackVar[32];			// callback function parameter
	u8 m_bSetState[32];				// bit for state using interrupt

	u8 m_ucFreqBand;
}DSIM_Infor;

//---------------------------------------------------------------------------------------------------------------------
DSIM_Infor* DSIM_Create(DSIM_Configuration* pDSIConfiguration, u8 ucIntrEn);
void DSIM_Destory(DSIM_Infor* pInfor);
/*---------------------------------- APIs of v210 HW or SMDK--------------------*/
void DSIM_EnBackLite(u8 bEn);
void DSIM_HWResetModule(void);
/*--------------------------- APIs of DSIM Default Configuration ------------------*/
DSIM_Configuration* DSIM_DefaultLinkAndPhy(void);
/*---------------------------------- APIs of Status -----------------------------*/
void DSIM_Reset(DSIM_Infor* pInfor, DSIM_Rst eRst);
u8 DSIM_InitLink(DSIM_Infor* pInfor);
u8 DSIM_SetULPS(DSIM_Infor* pInfor);
u8 DSIM_SetHSEn(DSIM_Infor* pInfor);
u8 DSIM_SetStopState(DSIM_Infor* pInfor);
u8 DSIM_SetDataTransferMode(DSIM_Infor* pInfor, DSIM_Transfer eDataPath, u8 bHSEn);
u8 DSIM_SetDisplayMode(DSIM_Infor* pInfor, DDI_Spec* pMainDisplay, DDI_Spec* pSubDisplay);
/*---------------------------------- APIs of DSI Command Transfer ---------------*/
u8 DSIM_SetClock(DSIM_Infor* pInfor, DSIM_ByteClkSrc eByteClkSel, u8 ucEn);
double DSIM_ChangePLL(DSIM_Infor* pInfor, u8 ucPredivider, u16 ucMaindivider, u8 ucScaler);
u8 DSIM_PLLOn(DSIM_Infor* pInfor, u8 bEn);
/*---------------------------------- APIs of DSI Command Transfer ---------------*/
u32 DSIM_WrData(DSIM_Infor* pInfor, DSIM_DataID eDataID, u32 uData0, u32 uData1, u8 bCheckRxAck);
DSIM_IntSrc DSIM_ForceRead(DSIM_Infor* pInfor, u32 uReturnedAddress, u32 uSize);
u32 DSIM_ProcessResponse(DSIM_Infor*, DSIM_DataID eId);
/*---------------------------------- Header Parser of DSI Rx Data -----------------*/
u32 DSIM_PopRxPayload(DSIM_ShortPktHeader*,u8* ,u32);
DSIM_Response DSIM_GetRxHeaderType(DSIM_ShortPktHeader *);
u16 DSIM_GetRxPayloadDataSize(DSIM_ShortPktHeader *);
void DSIM_ShowResponseFlagInfo(DSIM_ShortPktHeader *);
DSIM_Error DSIM_GetErrorReportInPacket(DSIM_ShortPktHeader *pHead);
void DSIM_ShowErrorReportInPacket(DSIM_ShortPktHeader *);
/*---------------------------------- Fifo Apis of DSI Rx Data ----------------------*/
u32 DSIM_PopRxHeader(DSIM_Infor*, DSIM_ShortPktHeader *pHead);
u8 DSIM_PushHD(DSIM_Infor* pInfor, DSIM_ShortPktHeader *pHead);
u8 DSIM_PopHD(DSIM_Infor* pInfor, DSIM_ShortPktHeader *pHead);
u8 DSIM_InitHeaderFifo(DSIM_Infor* pInfor);
u8 DSIM_IsHeaderFifoEmpty(DSIM_Infor* pInfor);
/*-------------------------- Basic APIs of DSIM Interrupt ------------------------*/
void __irq Isr_DSIM(void);
void DSIM_EnIntr(DSIM_Infor* pInfor, u8 ucEn);
void DSIM_SetIsrCallBack(DSIM_Infor* pInfor, DSIM_IntSrc eIntSrc, void (*fnCallBack)(u32), u32 CallbackVar);	
/*---------------------------------- APIs of DSIM State---------------------------------*/
u8 DSIM_IsState(DSIM_IntSrc eIntSrc);
u8 DSIM_WaitState(DSIM_IntSrc  eIntSrc);

/*---------------------------------- APIs of DSIM_STATUS ------------------------*/
u8 DSIM_IsPllStable(void);
u8 DSIM_IsSwRstRelease(void);
u8 DSIM_IsDirection(void);
DSIM_LaneState DSIM_IsLaneState(DSIM_LANE eLane);
/*---------------------------------- APIs of DSIM_SWRST -------------------------*/
void DSIM_SWReset(DSIM_Rst eRst);
/*---------------------------------- APIs of DSIM_CLKCTRL ------------------------*/
void DSIM_EnHSClk(u8 bEn);
void DSIM_SetEscClkPrs(u8 bEn, u16 usPrsVal);
void DSIM_EnEscClkPrs(u8 bEn);
void DSIM_SetEscClkPrsVal(u16 usPrsVal);
void DSIM_EnPllBypass(u8 bEn);
void DSIM_SetByteClockSrc(DSIM_ByteClkSrc eSrc);
void DSIM_EnByteClock(u8 bEn);
void DSIM_EnEscClkOnLane(DSIM_LANE eLaneSel, u8 ucEn);
/*---------------------------------- APIs of DSIM_TIMEOUT-------------------------*/
void DSIM_SetBTATimeOut(u8 ucTimeOut);
void DSIM_SetLPDRTimeOut(u16 usTimeOut);
/*---------------------------------- APIs of DSIM_CONFIG--------------------------*/
void DSIM_InitConfiguration(DSIM_Configuration* oConfiguration);
void DSIM_EnLane(DSIM_LANE eLane, u8 ucEn);
void DSIM_DisplayConfiguration(DDI_Spec* pMainDispConf, DDI_Spec* pSubDispConf);
/*---------------------------------- APIs of DSIM_ESCMODE---------------------------------*/
void DSIM_SetStopStateCounter(u16 uCntVal);
void DSIM_ForceDPhyStopState(u8 ucEn);
void DSIM_ForceBTA(void);
void DSIM_SetDataMode(DSIM_Transfer eData,DSIM_State eState);
void DSIM_ResetTrigger(void);
void DSIM_ULPSRequest(DSIM_UlpsReques ucRequest, u8 ucBitSet);
/*---------------------------------- APIs of DSIM_MDRESOL---------------------------------*/
void DSIM_SetMainDispResolution(u16 usVertiResol, u16 usHorResol);
/*---------------------------------- APIs of DSIM_MVPORCH---------------------------------*/
void DSIM_SetMainDispVPorch(u16 usFront, u16 usBack, u16 usCmdAllow);
/*---------------------------------- APIs of DSIM_MHPORCH---------------------------------*/
void DSIM_SetMainDispHPorch(u16 usFront, u16 usBack);
void DSIM_SetMainDispSyncArea(u16 usVerti, u16 usHori);
/*---------------------------------- APIs of DSIM_SDRESOL---------------------------------*/
void DSIM_SetSubDispResolution(u16 usVerti, u16 usHori);
/*---------------------------------- APIs of DSIM_INTSRC---------------------------------*/
DSIM_IntSrc DSIM_GetIntrState(void);
void DSIM_ClrIntr(DSIM_IntSrc eIntSrc);
u8 DSIM_WaitState(DSIM_IntSrc  eIntSrc);
/*---------------------------------- APIs of DSIM_INTMSK---------------------------------*/
void DSIM_SetIntrMask(DSIM_IntSrc eIntSel, u8 ucMask);
u32 DSIM_GetIntrMask(void);
/*---------------------------------- APIs of DSIM_PKTHDR---------------------------------*/
void DSIM_WrTxHeader( u8 ucDI, u8 ucDat0,u8 ucDat1);
/*---------------------------------- APIs of DSIM_PAYLOAD---------------------------------*/
void DSIM_WrTxData(u32 uTxData);
/*---------------------------------- APIs of DSIM_RXFIFO---------------------------------*/
u32 DSIM_RdRxData(void);
/*---------------------------------- Hidden SFR--------------------------------------------*/
/*---------------------------------- APIs of DSIM_FIFOTHLD---------------------------------*/
DSIM_FifoState DSIM_GetFifoState(void);
void DSIM_InitFifoPointer(DSIM_Fifo eFifo);
/*---------------------------------- Hidden SFR--------------------------------------------*/
/*---------------------------------- APIs of DSIM_MEMACCHR-------------------------------*/
void DSIM_MemControl(DSIM_Fifo eFifo);
/*---------------------------------- APIs of DSIM_PLLCTRL-------------------------------*/
void DSIM_PllFreqBand(u8 ucFreqBand);
void DSIM_EnPll(u8 ucEn);
void DSIM_SetPllPMS(u8 ucPredivider, u16 ucMaindivider, u8 ucScaler);
void DSIM_PllFreq(u8 ucPredivider, u16 ucMaindivider, u8 ucScaler);
#if (DSIM_Version == DSIM_1_00)
void DSIM_SwapDpDn(u8 ucSwapEn);
#endif
/*---------------------------------- APIs of DSIM_PLLTMR-------------------------------*/
void DSIM_PllStatbleTime(u32 uLockTime);
#if (DPHY_Version == DPHY_45n)
/*---------------------------------- APIs of DSIM_PHYACCHR-------------------------------*/
void DSIM_SetPhyTunning(u32 uTunnigValue);
void DSIM_EnAFC(u8 ucEn, u8 ucAFCCode);
/*---------------------------------- APIs of DSIM_PHYACCHR1------------------------------*/
void DSIM_DpDnSwap(DSIM_LANE eLane, u8 ucSwapEn);
#endif

#endif
