/********************************************************************************
* 
*	Project Name : S5PV210 Validation
*
*	Copyright 2009 by Samsung Electronics, Inc.
*	All rights reserved.
*
*	Project Description :
*		This software is only for verifying functions of the S5PV210
*		Anybody can use this software without our permission.
*  
*--------------------------------------------------------------------------------
* 
*	File Name : dcs.h
*  
*	File Description :
*
*	Author	: Sung-Hyun, Na
*	Dept. : AP Development Team
*	Created Date : 2009/03/10
*	Version : 0.1
* 
*	History
*	- Version 0.0 (Sung-Hyun,Na, 2009/03/10)
*	  	-> convert from Media Team DCSProtocol.cpp 
*	- Version 0.1 (Sung-Hyn,Na 2009/06/17)
*		-> Check Rx Ack Enable/Disable using DSI Protocol
*		-> Add to the ohter Protocol
*
********************************************************************************/
#ifndef __DCS_H_
#define __DCS_H_

#include "def.h"

typedef enum 
{
	NOP = 0x0,
	SOFT_RESET=0x01,	

	ENTER_SLEEP		= 0x10,
	ENTER_PARTIAL	= 0x12,
	ENTER_NORMAL	= 0x13,
	ENTER_INVERT	= 0x21,
	ENTER_IDLE		= 0x39,

	EXIT_SLEEP		= 0x11,
	EXIT_INVERT		= 0x20,
	EXIT_IDLE		= 0x38,	
	
	GET_RED_CHANNEL		= 0x06,
	GET_GREEN_CHANNEL		= 0x07,
	GET_BLUE_CHANNEL		= 0x08,
	
	GET_POWER_MODE		= 0x0A,
	GET_ADDRESS_MODE		= 0x0B,
	GET_PIXEL_FORMAT		= 0x0C,
	GET_DISPLAY_MODE		= 0x0D,
	GET_SIGNAL_MODE		= 0x0E,
	GET_DIAGNOSTIC_RESULT	= 0x0F,
	
	GET_SCANLINE			= 0x45,	
	
	READ_DDB_CONTINUE=0xa8,
	READ_DDB_START=0xa1,
	READ_MEMORY_CONTINUE=0x3e,
	READ_MEMORY_START=0x2e,
	
	SET_ADDRESS_MODE=0x36,
	SET_COLUMN_ADDRESS=0x2a,
	SET_DISPLAY_OFF=0x28,
	SET_DISPLAY_ON=0x29,
	SET_GAMMA_CURVE=0x26,
	SET_PAGE_ADDRESS=0x2b,
	SET_PARTIAL_AREA=0x30,
	SET_PIXEL_FORMAT=0x3a,
	SET_SCROLL_AREA=0x33,
	SET_SCROLL_START=0x37,
	SET_TEAR_OFF=0x34,
	SET_TEAR_ON=0x35,
	SET_TEAR_SCANLINE=0x44,
	
	WRITE_LUT=0x2d,
	WRITE_MEMORY_CONTINUE=0x3c,
	WRITE_MEMORY_START=0x2c,		
}DCS_CmdSet;

//types 
typedef enum 
{
	GAMMA_NONE = 0x0,
	GAMMA_CURVE1 = 0x1,
	GAMMA_CURVE2 = 0x2,
	GAMMA_CURVE3 = 0x4,
	GAMMA_CURVE4 = 0x8,
}GAMMA_CURVE_t;

typedef struct
{
	//member variables
	Connectivity_Link m_eProtocol;
	u32 m_uLinkProtocol;
	u8 m_ucVcID;
	
	u8 m_ucDiagnosticResult;
	u8 m_ucAddressMode;
	u8 m_ucDisplayMode;
	u8 m_ucPowerMode;
	u8 m_ucSignalMode;

	u8 m_bCheckRxAck;						//Option : Check Rx Ack for non read Command
	
}DCS_Infor;

// methods
DCS_Infor* DCS_Create(Connectivity_Link eProtocol, u32 uDriver, u8 ucVcID);
void DCS_Destory(DCS_Infor* pInfor);
void DCS_EnCheckRxAck(DCS_Infor* pInfor, u8 bEn);

//Display Command Set (DCS v1.0)
u8 DCS_EnterIdle(DCS_Infor*);
u8 DCS_EnterInvertMode(DCS_Infor*);
u8 DCS_EnterNormalMode(DCS_Infor*);
u8 DCS_EnterPartialMode(DCS_Infor*);
u8 DCS_EnterSleepMode(DCS_Infor*);		// TODO : make sure TE output low
u8 DCS_ExitIdleMode(DCS_Infor*);
u8 DCS_ExitInvertMode(DCS_Infor* pInfor);
u8 DCS_ExitSleepMode(DCS_Infor* pInfor);

u8 DCS_GetAddressMode(DCS_Infor*, u8*);
u8 DCS_GetBlueChannel(DCS_Infor* pInfor, u8* pBlueCh);
u8 DCS_GetDisanosticResult(DCS_Infor* , u8*);
u8 DCS_GetDisplayMode(DCS_Infor*, u8*);
u8 DCS_GetGreenChannel(DCS_Infor* pInfor, u8 *pGreenCh);
u8 DCS_GetPixelFormat(DCS_Infor*, u8*);
u8 DCS_GetPowerMode(DCS_Infor*, u8*);
u8 DCS_GetRedChannel(DCS_Infor* pInfor, u8* pRedCh);
u8 DCS_GetScanLine(DCS_Infor*, u16*);
u8 DCS_GetSignalMode(DCS_Infor* , u8*);

u8 DCS_Nop(DCS_Infor*);

u8 DCS_ReadDDBStart(DCS_Infor* pInfor, u8* pBuf,u32 bufSize,u32* pnRead);
u8 DCS_ReadDDBContinue(DCS_Infor* pInfor,  u8* pBuf,u32 bufSize,u32* pnRead);
u8 DCS_ReadMemoryStart(DCS_Infor* pInfor, u8* pBuf,u32 bufSize,u32* pnRead);
u8 DCS_ReadMemoryContinue(DCS_Infor* pInfor, u8* pBuf,u32 bufSize,u32* pnRead);

u8 DCS_SetAddressMode(DCS_Infor* pInfor, u8 mode);
u8 DCS_SetColumnAddress(DCS_Infor* pInfor, u16 sc,u16 ec);
u8 DCS_SetDisplayOff(DCS_Infor* pInfor);
u8 DCS_SetDisplayOn(DCS_Infor* pInfor);
u8 DCS_SetGammaCurve(DCS_Infor* pInfor, GAMMA_CURVE_t curve);
u8 DCS_SetPageAddress(DCS_Infor* pInfor, u16 startPage,u16 endPage);
u8 DCS_SetPartialArea(DCS_Infor* pInfor, u16 startRow,u16 endRow);
u8 DCS_SetPixelFormat(DCS_Infor* pInfor, u8 format);
u8 DCS_SetScrollArea(DCS_Infor* pInfor, u16 top_fixed_area_lines, u16 vertical_scrolling_area_lines, u16 bottom_fixed_area_lines);
u8 DCS_SetScrollStart(DCS_Infor* pInfor, u16 vertical_scroll_pointer);
u8 DCS_SetTearOff(DCS_Infor* pInfor);
u8 DCS_SetTearOn(DCS_Infor* pInfor, u8 bothBlanking);
u8 DCS_SetTearScanline(DCS_Infor* pInfor, u16 line);
u8 DCS_SoftReset(DCS_Infor* pInfor);

u8 DCS_WriteLUT(DCS_Infor* pInfor, u8* pBuf,u32 size);
u8 DCS_WriteMemoryContinue(DCS_Infor* pInfor, u8* pBuf,u32 size);
u8 DCS_WriteMemoryStart(DCS_Infor* pInfor, u8* pBuf,u32 size);

//Private Function
u8 DCS_WriteLongPacketWithDCSCommand(DCS_Infor* pInfor, DCS_CmdSet cmd,u8* pDat,u32 size);
u8 _ReadLongPacketWithDCSCommand(DCS_Infor* pInfor, DCS_CmdSet cmd,u8* pDat,u32 size,u32* pnRead);
#endif
