/*--------------------------------------------------------------
 * Filename: csi.h
 *
 * Contents: Declaration of "CSIS of MIPI"
 *
 * Abbreviations:
 *
 * Person Involved: 
 *
 * Notes: 
 *
 * History:
 *   
 * Copyright (c) 2008 SAMSUNG Electronics.
 --------------------------------------------------------------*/
#ifndef __CSI_H__
#define __CSI_H__

#include "def.h"

typedef enum
{
	ERR_ID,
	ERR_CRC,
	ERR_ECC,
	ERR_CTRL,
	ERR_ESC,
	ERR_SOT_HS,
	ODD_AFTER,
	ODD_BEFORE,
	EVEN_AFTER,
	EVEN_BEFORE 
}CSIS_INT;

typedef enum
{
	DATALANE1=0,
	DATALANE2,
	DATALANE3,
	DATALANE4	
}CSIS_DATA_LANE_NUM;

typedef enum
{
	WCLKSRC_PCLK,
	WCLKSRC_EXTCLK
}CSIS_WCLK_SRC;

// Interval setting between CSIS and FIMC
typedef struct
{
	u32 CSIS_INTV_Lintv;			// 0x0~0x3F
	u32 CSIS_INTV_Sintv;		// 0x0~0x3F
	u32 CSIS_INTV_Eintv;		// 0x0~0xFFF
}CSIS_INTV_SETTING;

typedef enum
{
	CSIRaw_NoColor=0,
	CSIRaw_oRGeGB,		// 4CA
	CSIRaw_oGReBG,		// 4E1, 3H1
	CSIRaw_oBGeGR,
	CSIRaw_oGBeRG
}CSIRaw_Color;

extern CSIS_DATA_LANE_NUM eCSISDataLaneNum;

void CSI_Start(CSIS_DATA_LANE_NUM eDataLane, IMG_FMT eFinImgType, 
				IMG_RESOLUTION eSize, MIPI_DATA_ALIGN eDataAlign, 
				CSIS_WCLK_SRC eWCLKSrc, CSIS_INTV_SETTING *eCSISIntvSetting,
				u8 eHSsettle);
void CSI_SwapDnDp(void);
void CSI_Reset(void);
void CSI_SetNumOfDataLane(CSIS_DATA_LANE_NUM eDLane);
void CSI_EnableInterrupt(void);
void CSI_DisableInterrupt(void);
void CSI_ChkIntStatus(u32* eIntsec);
void CSI_ClearInterrupt(u32 eIntsec);
void CSI_GetIntMask(u32* uIntMask);
void CSI_DisableCSI(void);
void CSI_DPHYOn(CSIS_DATA_LANE_NUM eDataLane);

void InitBaseHwForCSIS(void);

#endif //__CSIS_H__
