/**************************************************************************************
* 
*	Project Name : S5PV210 FPGA Validation
*
*	Copyright 2008 by Samsung Electronics, Inc.
*	All rights reserved.
*
*	Project Description :
*		This software is only for validating functions of the S5PV210.
*		Anybody can use this software without our permission.
*  
*--------------------------------------------------------------------------------------
* 
*	File Name : RawConverter.h
*  
*	File Description : This file implements converting BayerRGB to RGB24(For CSI-Slave functions).
*
*	Author : Jun,Kim
*	Dept. : AP Development Team
*	Created Date : 
*	Version : 0.1 
* 
*	History
*	- Created(Jun,Kim 2009/07/24)
**************************************************************************************/

#ifndef __RAWCONVERTER_H__
#define __RAWCONVERTER_H__

void Raw2RGBInit(u8 *srcImgAddr, u32 imgWidth, u32 imgHeight, IMG_FMT inImgType);
void ExpandRawPixel(u8 *srcImgAddr, u16 *dstImgAddr, u32 InImgSize, IMG_FMT inImgType);
void ConvertRawToRGB(u8 *srcImgAddr, void *dstImgAddr, u32 imgWidth, u32 imgHeight, 
					IMG_FMT eCameraFmtType, CSIRaw_Color eCsiRawColorType);

#endif //__RAWCONVERTER_H__